--freemarker template
<sqlvars>
<sqlvar name="anzahl"><![CDATA[select count(*) from kenn_fibu_quartal where hs_nr=<<Hochschule>> and jahr=<<Jahr>>]]></sqlvar>
</sqlvars>

<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>

create temp table tmp_erg (tid serial,zeile varchar(255),kontengruppe varchar(255),name varchar(255),name2 varchar(255),hierarchie_ebene smallint,
plan <@doubletype/>, q1 <@doubletype/>,q2 <@doubletype/>,q3 <@doubletype/>,q4 <@doubletype/>,
gesamtist <@doubletype/>,vorschau <@doubletype/>, abweichung <@doubletype/>,vorjahr <@doubletype/>, erlaeuterung text,
sortnr integer,sortnr2 varchar(50)
) <@informixnolog/>;

<#if anzahl?number!=84>
  <#if anzahl?number=0>
  insert into tmp_erg (name,hierarchie_ebene) values ('Fr das Jahr <<Jahr>> wurden keine Daten gefunden',1);
  <#else>
  insert into tmp_erg (name,hierarchie_ebene) values ('Falsche Datensatzanzahl erwartet 84 - gefunden ${anzahl} - Fibu Konfiguration prfen!!',1);
  </#if>
<#else>

insert into tmp_erg (zeile,kontengruppe,name,hierarchie_ebene,plan,q1,q2,q3,q4,vorschau,vorjahr,erlaeuterung,sortnr,sortnr2)
select zeile, kontengruppe,name,hierarchie_ebene,plan,q1,q2,q3,q4 ,
steuerungvorschau,steuerungvorjahr,erlaeuterung,
sortnr,sortnr2 from 
kenn_fibu_quartal where hs_nr=<<Hochschule>> and jahr=<<Jahr>> order by sortnr,sortnr2 ;


create temp table tmp_sum (q1 <@doubletype/>,q2 <@doubletype/>,q3 <@doubletype/>,q4 <@doubletype/>,
gesamtist <@doubletype/>,vorjahr  <@doubletype/>,
vorschau <@doubletype/>, abweichung <@doubletype/>) <@informixnolog/>;
<#macro summe start bis zieltid>
delete from tmp_sum;
insert into tmp_sum (q1,q2,q3,q4,vorschau,abweichung,gesamtist,vorjahr)
select sum(q1),sum(q2),sum(q3),sum(q4),sum(vorschau),sum(abweichung),sum(gesamtist),sum(vorjahr) from  tmp_erg where tid>=${start} and tid<=${bis};
update tmp_erg 
set q1=(select q1 from tmp_sum),
q2=(select q2 from tmp_sum),
q3=(select q3 from tmp_sum),
q4=(select q4 from tmp_sum),
abweichung=(select abweichung from tmp_sum),
vorschau=(select vorschau from tmp_sum),
gesamtist=(select gesamtist from tmp_sum),
vorjahr=(select vorjahr from tmp_sum)
 where sortnr=${zieltid};
</#macro>

<@summe start=65 bis=68 zieltid=69/>
<@summe start=73 bis=74 zieltid=75/>
<@summe start=77 bis=80 zieltid=83/>

delete from tmp_sum;
insert into tmp_sum (q1,q2,q3,q4,vorschau,abweichung,gesamtist,vorjahr)
select sum(q1),sum(q2),sum(q3),sum(q4),sum(vorschau),sum(abweichung),sum(gesamtist),sum(vorjahr) from  tmp_erg where sortnr in (1000008,1000012);
update tmp_erg 
set q1=(select q1 from tmp_sum),
q2=(select q2 from tmp_sum),
q3=(select q3 from tmp_sum),
q4=(select q4 from tmp_sum),
abweichung=(select abweichung from tmp_sum),
vorschau=(select vorschau from tmp_sum),
gesamtist=(select gesamtist from tmp_sum),
vorjahr=(select vorjahr from tmp_sum)
 where sortnr=1000020;
drop table tmp_sum;
--nachberechnung 3 Zeilen
<@selectintotmp source="tmp_erg" target="tmp_hilf" select="tid,q1,q2,q3,q4,vorschau,abweichung,gesamtist,vorjahr">
where tid in (17,42,53)
</@selectintotmp>;
update tmp_erg set
q1=(select q1 from tmp_hilf where tid=17),
q2=(select q2 from tmp_hilf where tid=17),
q3=(select q3 from tmp_hilf where tid=17),
q4=(select q4 from tmp_hilf where tid=17),
vorschau=(select vorschau from tmp_hilf where tid=17),
abweichung=(select abweichung from tmp_hilf where tid=17),
gesamtist=(select gesamtist from tmp_hilf where tid=17),
vorjahr=(select vorjahr from tmp_hilf where tid=17)
where tid=54;
update tmp_erg set
q1=(select q1 from tmp_hilf where tid=42),
q2=(select q2 from tmp_hilf where tid=42),
q3=(select q3 from tmp_hilf where tid=42),
q4=(select q4 from tmp_hilf where tid=42),
vorschau=(select vorschau from tmp_hilf where tid=42),
abweichung=(select abweichung from tmp_hilf where tid=42),
gesamtist=(select gesamtist from tmp_hilf where tid=42),
vorjahr=(select vorjahr from tmp_hilf where tid=42)
where tid=55;
update tmp_erg set
q1=(select q1 from tmp_hilf where tid=53),
q2=(select q2 from tmp_hilf where tid=53),
q3=(select q3 from tmp_hilf where tid=53),
q4=(select q4 from tmp_hilf where tid=53),
vorschau=(select vorschau from tmp_hilf where tid=53),
abweichung=(select abweichung from tmp_hilf where tid=53),
gesamtist=(select gesamtist from tmp_hilf where tid=53),
vorjahr=(select vorjahr from tmp_hilf where tid=53)
where tid=56;
drop table tmp_hilf;



update tmp_erg set gesamtist=nvl(q1,0)+nvl(q2,0)+nvl(q3,0)+nvl(q4,0)
 where q1 is not null or q2 is not null or q3 is not null or q4 is not null ;
 <@selectintotmp source="tmp_erg" target="tmp_test" select="count(*) as anzahl_q4_gefuellt">
 where q4 is not null and q4!=0
 </@selectintotmp>;
 update tmp_erg set vorschau=gesamtist where (select anzahl_q4_gefuellt from tmp_test)>0;
 drop table tmp_test;
update tmp_erg set abweichung=plan-vorschau;

update tmp_erg set zeile='A',kontengruppe='Erfolgsplan',name='',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=1;
update tmp_erg set zeile='I.',kontengruppe='',name='Ertrge',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=2;
update tmp_erg set zeile='1.',kontengruppe='50',name='Ertrge aus wirtschaftlicher Hochschulttigkeit',name2='' where tid=3;
update tmp_erg set zeile='2.',kontengruppe='51',name='Ertrge aus Gebhren und Sanktionen, Entgelte',name2='' where tid=4;
update tmp_erg set zeile='3.',kontengruppe='520, 521',name='Erhhung oder Verminderung des Bestandes an unfertigen Leistungen',name2='' where tid=5;
update tmp_erg set zeile='4.',kontengruppe='525',name='Andere aktivierte Eigenleistungen',name2='' where tid=6;
update tmp_erg set zeile='5.',kontengruppe='53, 54, 58',name='Sonstige betriebliche Ertrge',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=7;
update tmp_erg set zeile='',kontengruppe='',name='5.1 Ertrge aus Zuweisungen, Zuschssen und Drittmitteln ',name2='' where tid=8;
update tmp_erg set zeile='',kontengruppe='',name='',name2='5.1.1 Zuschuss des Freistaates Sachsen fr laufenden Betrieb' where tid=9;
update tmp_erg set zeile='',kontengruppe='',name='',name2='5.1.2 Ertrge aus Projektfrderung' where tid=10;
update tmp_erg set zeile='',kontengruppe='',name='',name2='5.1.3 Sonstige Ertrge aus Zuweisungen und Zuschssen, Kostenerstattungen' where tid=11;
update tmp_erg set zeile='',kontengruppe='',name='5.2 Ertrge aus Zuweisungen und Zuschssen zur Finanzierung von Investitionen',name2='' where tid=12;
update tmp_erg set zeile='',kontengruppe='',name='',name2='darunter vom Freistaat Sachsen' where tid=13;
update tmp_erg set zeile='',kontengruppe='',name='5.3 Ertrge aus der Auflsung von Sonderposte',name2='' where tid=14;
update tmp_erg set zeile='',kontengruppe='',name='5.4 Sonstige Ertrge',name2='' where tid=15;
update tmp_erg set zeile='',kontengruppe='',name='= Summe Sonstige betriebliche Ertrge',name2='' where tid=16;
update tmp_erg set zeile='',kontengruppe='',name='= Summe der (ordentlichen) Ertrge',name2='' where tid=17;
update tmp_erg set zeile='II.',kontengruppe='',name='Aufwendungen',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=18;
update tmp_erg set zeile='6.',kontengruppe='',name='Materialaufwand',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=19;
update tmp_erg set zeile='',kontengruppe='60',name='',name2='a) Aufwand fr Roh-, Hilfs- und Betriebsstoffe und fr bezogene Waren' where tid=20;
update tmp_erg set zeile='',kontengruppe='61',name='',name2='b) Aufwendungen fr bezogene Leistungen' where tid=21;
update tmp_erg set zeile='',kontengruppe='',name='= Summe Materialaufwand',name2='' where tid=22;
update tmp_erg set zeile='7.',kontengruppe='',name='Personalaufwand',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=23;
update tmp_erg set zeile='',kontengruppe='62',name='',name2='a) Entgelte' where tid=24;
update tmp_erg set zeile='',kontengruppe='63',name='',name2='b) Bezge' where tid=25;
update tmp_erg set zeile='',kontengruppe='62',name='',name2='c) Vergtungen fr Auszubildende/Volontre' where tid=26;
update tmp_erg set zeile='',kontengruppe='62',name='',name2='d) Entgelte Drittmittelbeschftigte' where tid=27;
update tmp_erg set zeile='',kontengruppe='64',name='',name2='e) Soziale Abgaben und Aufwendungen fr Altersvorsorgung und fr Untersttzung' where tid=28;
update tmp_erg set zeile='',kontengruppe='',name='',name2='darunter fr Altersversorgung' where tid=29;
update tmp_erg set zeile='',kontengruppe='65',name='',name2='f) Sonstige Personalaufwendungen' where tid=30;
update tmp_erg set zeile='',kontengruppe='',name='= Summe Personalaufwand',name2='' where tid=31;
update tmp_erg set zeile='8.',kontengruppe='66',name='Abschreibungen',name2='' where tid=32;
update tmp_erg set zeile='9.',kontengruppe='',name='Sonstige betriebliche Aufwendungen',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=33;
update tmp_erg set zeile='',kontengruppe='',name='',name2='a) Aufwendungen fr die Inanspruchnahme von Rechten und Diensten ' where tid=34;
update tmp_erg set zeile='',kontengruppe='',name='',name2='b) Weitere Aufwendungen fr Kommunikation, Dokumentation, Information, Reisen, Literatur, Werbung' where tid=35;
update tmp_erg set zeile='',kontengruppe='',name='',name2='c) Aufwendungen fr Beitrge und Sonstiges sowie Wertkorrekturen und periodenfremde Aufwendungen' where tid=36;
update tmp_erg set zeile='',kontengruppe='',name='',name2='darunter Aufwendungen fr die Einstellung in den Sonderposten' where tid=37;
update tmp_erg set zeile='',kontengruppe='',name='',name2='d) Aufwendungen fr Zuweisungen und Zuschsse, Investitionszuschsse und Kostenerstattungen ' where tid=38;
update tmp_erg set zeile='',kontengruppe='',name='',name2='e) Aufwendungen fr sonstige Leistungen an Dritte' where tid=39;
update tmp_erg set zeile='',kontengruppe='',name='',name2='f) Betriebliche Steuern' where tid=40;
update tmp_erg set zeile='',kontengruppe='',name='= Summe Sonstige betriebliche Aufwendungen',name2='' where tid=41;
update tmp_erg set zeile='',kontengruppe='',name='= Summe der (ordentlichen) Aufwendungen',name2='' where tid=42;
update tmp_erg set zeile='III. ',kontengruppe='',name='Verwaltungsergebnis ( = Ertrge I. ./. Aufwendungen II.)',name2='' where tid=43;
update tmp_erg set zeile='10.',kontengruppe='56',name='Ertrge aus Beteiligungen',name2='' where tid=44;
update tmp_erg set zeile='',kontengruppe='',name='',name2='darunter aus verbundenen Unternehmen' where tid=45;
update tmp_erg set zeile='11.',kontengruppe='56',name='Ertrge aus anderen Wertpapieren und Ausleihungen des Finanzanlagevermgens',name2='' where tid=46;
update tmp_erg set zeile='',kontengruppe='',name='',name2='darunter aus verbundenen Unternehmen' where tid=47;
update tmp_erg set zeile='12.',kontengruppe='57',name='Sonstige Zinsen und hnliche Ertrge',name2='' where tid=48;
update tmp_erg set zeile='',kontengruppe='',name='',name2='darunter aus verbundenen Unternehmen' where tid=49;
update tmp_erg set zeile='13.',kontengruppe='74',name='Abschreibungen auf Finanzanlagen und auf Wertpapiere des Umlaufvermgens',name2='' where tid=50;
update tmp_erg set zeile='14.',kontengruppe='75',name='Zinsen und hnliche Aufwendungen',name2='' where tid=51;
update tmp_erg set zeile='',kontengruppe='',name='',name2='darunter aus verbundenen Unternehmen' where tid=52;
update tmp_erg set zeile='IV.',kontengruppe='',name='Finanzanlageergebnis und Zinsen (= 10 + 11 + 12 ./. 13 ./. 14)',name2='' where tid=53;
update tmp_erg set zeile='',kontengruppe='',name='Ordentliche Ertrge ( = I. )',name2='' where tid=54;
update tmp_erg set zeile='',kontengruppe='',name=' - ordentliche Aufwendungen ( = II. )',name2='' where tid=55;
update tmp_erg set zeile='',kontengruppe='',name=' +/- Finanzergebnis ( = IV. )',name2='' where tid=56;
update tmp_erg set zeile='V.',kontengruppe='',name='Ergebnis der gewhnlichen Geschftsttigkeit (= III. + IV.)',name2='' where tid=57;
update tmp_erg set zeile='15.',kontengruppe='59',name='Auerordentliche Ertrge',name2='' where tid=58;
update tmp_erg set zeile='16.',kontengruppe='79',name='Auerordentliche Aufwendungen',name2='' where tid=59;
update tmp_erg set zeile='VI.',kontengruppe='',name='Auerordentliches Ergebnis',name2='' where tid=60;
update tmp_erg set zeile='17.',kontengruppe='77',name='Steuern vom Einkommen und vom Ertrag',name2='' where tid=61;
update tmp_erg set zeile='18.',kontengruppe='779',name='Sonstige Steuern',name2='' where tid=62;
update tmp_erg set zeile='VII.',kontengruppe='',name='Summe Steuern (Zeilen 17. und 18.)',name2='' where tid=63;
update tmp_erg set zeile='VIII.',kontengruppe='',name='Quartalsergebnis (= V. + VI. ./. Steuern)',name2='' where tid=64;
update tmp_erg set zeile='B',kontengruppe='Investionsplan',name='',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=65;
update tmp_erg set zeile='1.',kontengruppe='',name='Investitionen aus Mitteln des Freistaates Sachsen (ber 5 T EUR)',name2='' where tid=66;
update tmp_erg set zeile='2.',kontengruppe='',name='Investitionen aus Mitteln des Freistaates Sachsen (bis zu 5 T EUR)',name2='' where tid=67;
update tmp_erg set zeile='3.',kontengruppe='',name='Sonderinvestitionen',name2='' where tid=68;
update tmp_erg set zeile='4.',kontengruppe='',name='Investitionen aus Mitteln Dritter und eigenen Einnahmen',name2='' where tid=69;
update tmp_erg set zeile='',kontengruppe='',name='Summe Investitionen',name2='' where tid=70;
update tmp_erg set zeile='C',kontengruppe='Finanzplan',name='',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=71;
update tmp_erg set zeile='I.',kontengruppe='',name='Finanzbedarf',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=72;
update tmp_erg set zeile='1.',kontengruppe='',name='Finanzbedarf fr den laufenden Betrieb',name2='' where tid=73;
update tmp_erg set zeile='2.',kontengruppe='',name='Finanzbedarf fr Investitionen',name2='' where tid=74;
update tmp_erg set zeile='',kontengruppe='',name='Summe Finanzbedarf (=1.+2.)',name2='' where tid=75;
update tmp_erg set zeile='II.',kontengruppe='',name='Deckungsmittel',name2='',
plan=null,q1=null,q2=null,q3=null,q4=null,gesamtist=null,vorschau=null,abweichung=null where tid=76;
update tmp_erg set zeile='3.',kontengruppe='',name='+ Zuweisungen und Zuschsse des Freistaates Sachsen fr den laufenden Betrieb',name2='' where tid=77;
update tmp_erg set zeile='4.',kontengruppe='',name='+ Zuweisungen und Zuschsse des Freistaates Sachsen fr Investitionen',name2='' where tid=78;
update tmp_erg set zeile='5.',kontengruppe='',name='+/- Entnahme / Bildung von Rcklagen',name2='' where tid=79;
update tmp_erg set zeile='6.',kontengruppe='',name='+/- Sonstiges',name2='' where tid=80;
update tmp_erg set zeile='6.1.',kontengruppe='',name='',name2='darunter Projekte (Drittmittel)' where tid=81;
update tmp_erg set zeile='6.2.',kontengruppe='',name='',name2='darunter Sonderzuweisungen' where tid=82;
update tmp_erg set zeile='',kontengruppe='',name='Summe Deckungsmittel',name2='' where tid=83;
update tmp_erg set zeile='III.',kontengruppe='',name='Saldo (I. + II.)',name2='' where tid=84;

update tmp_erg set plan=null where plan=0;
update tmp_erg set q1=null where q1=0;
update tmp_erg set q2=null where q2=0;
update tmp_erg set q3=null where q3=0;
update tmp_erg set q4=null where q4=0;
update tmp_erg set gesamtist=null where gesamtist=0;
update tmp_erg set vorschau=null where vorschau=0;
update tmp_erg set abweichung=null where abweichung=0;
update tmp_erg set vorjahr=null where vorjahr=0;

</#if>
select tid::varchar(2),zeile,kontengruppe,name,name2,hierarchie_ebene,plan,q1,q2,q3,q4,gesamtist,vorschau,abweichung,vorjahr,
erlaeuterung
from tmp_erg
order by sortnr,sortnr2;
