--freemarker template
<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>

<#if "<<dynamisch oder fest>>"="<<dynamisch oder fest>>">
create temp table tmp_erg(
einnahmen_ausgaben char(10),
sort_ea smallint, -- einnahmen ausgaben
sort_einzeltit_dr smallint default 0, -- 0 einzeltitel, 1 berschift Titelgr. , 2 drs
sort_drtit smallint default 0, --erst 0 drbez, 1 einzelne Titel, 2 dr summe 
typ char(5), --tit or dr or drsum
dr varchar(50),
titel varchar(150),
name varchar(255),
sortnr integer,
soll <@doubletype/>,  --Aktuelles Soll statt W Haushaltansatz 19.2.2012 - da Reste extra dargestellt werden in zwei Titel (36001,36002) entspricht das in MBS akts-reste
haushaltsvorgriff <@doubletype/>,
gesamtsoll  <@doubletype/>,
ist <@doubletype/>,
abweichung  <@doubletype/>,
erl varchar(255)
)<@informixnolog/>
;

create temp table tmp_konto (dr varchar(50),titel char(10),
akts <@doubletype/> default 0,
reste <@doubletype/> default 0,
haushaltsvorgriff <@doubletype/> default 0,
ist  <@doubletype/> default 0
) <@informixnolog/>;
---- statt W Hhans  S aktuelles Soll, X Ausgaben, Y Einnahmen, Z Reste, V = Haushaltsvorgriff 
insert into tmp_konto (dr,titel,akts)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='S'  
group by 1,2;
insert into tmp_konto (dr,titel,reste)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='Z'  
group by 1,2;
insert into tmp_konto (dr,titel,haushaltsvorgriff)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='V'  
group by 1,2;


  --einnahmen
insert into tmp_konto (dr,titel,ist)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and betragsart='Y'   and
substring(titel from 1 for 1) in ('0','1','2','3')
group by 1,2;
 --ausgaben
insert into tmp_konto (dr,titel,ist)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and betragsart='X'  and
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
 group by 1,2;

 update tmp_konto set dr='einzeltitel' where dr is null or dr='';
 
<#macro sumit sortea sort_einzeltit_dr sort_drtit typ feld dr>
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr,titel,soll,haushaltsvorgriff,ist )
select ${sortea},${sort_einzeltit_dr},${sort_drtit},'${typ}',dr,${feld},sum(akts)-sum(reste),sum(haushaltsvorgriff),sum(ist) from tmp_konto where
<#if sortea="0">
 substring(titel from 1 for 1) in ('0','1','2','3')  
<#else>
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
</#if>
 and ${dr}
 group by 1,2,3,4,5,6;
</#macro>
<#macro sumit70er sortea sort_einzeltit_dr sort_drtit typ feld dr>
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr,titel,soll,haushaltsvorgriff,ist )
select ${sortea},${sort_einzeltit_dr},${sort_drtit},'${typ}','70,72,73,74',${feld},sum(akts)-sum(reste),sum(haushaltsvorgriff),sum(ist) from tmp_konto where
<#if sortea="0">
 substring(titel from 1 for 1) in ('0','1','2','3')  
<#else>
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
</#if>
 and ${dr}
 group by 1,2,3,4,5,6;
</#macro>
 
--Einnahmen
insert into tmp_erg (sort_ea,sort_einzeltit_dr,name) values (0,-1,'Einnahmen');

  --Einzeltitel
<@sumit  sortea="0" sort_einzeltit_dr="0 as einzeltit" sort_drtit="0" typ='tit' feld="titel" dr="dr='einzeltitel'" />

 --berschrift Titelgruppen
-- insert into tmp_erg (sort_ea,sort_einzeltit_dr,name) values (0,1,'Titelgruppen');
 
  --Deckungsringberschriften
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr )
select distinct 0 as einnahmen,2 as dr,2 as drbez,'dr',dr from tmp_konto where substring(titel from 1 for 1)  in ('0','1','2','3')
  and dr!='einzeltitel' and dr not in ('70','72','73','74');
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr,name )
values (0,2 ,2 ,'dr','70,72,73,74','TG 70,72,73,74');

  -- Titel des DR
  <@sumit  sortea="0" sort_einzeltit_dr="2 as dreinzeltit" sort_drtit="3" typ='tit' feld="titel"  dr="dr!='einzeltitel' and dr not in ('70','72','73','74')" />
 <@sumit70er  sortea="0" sort_einzeltit_dr="2 as dreinzeltit" sort_drtit="3" typ='tit' feld="titel"  dr="dr in ('70','72','73','74')" />
 
  --Summe des Dr
   <@sumit  sortea="0" sort_einzeltit_dr="2 as dreinzeltit" sort_drtit="4 as drsum" typ='drsum' feld="''" dr="dr!='einzeltitel' and dr not in ('70','72','73','74')" />
 <@sumit70er  sortea="0" sort_einzeltit_dr="2 as dreinzeltit" sort_drtit="4 as drsum" typ='drsum' feld="'70,72,73,74'" dr="dr in ('70','72','73','74')" />

--leerzeilen
insert into tmp_erg (sort_ea,sort_einzeltit_dr,sort_drtit,dr) values (0,0,5,'einzeltitel'); -- leerzeile 
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,dr)
select distinct 0 as einnahmen,2 as dr,5,dr from tmp_konto where substring(titel from 1 for 1)  in ('0','1','2','3')
  and dr!='einzeltitel' and dr not in ('70','72','73','74');
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,dr )
values (0,2 ,5 ,'70,72,73,74');

 
  --summe Einnahmen
  insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,name,soll,haushaltsvorgriff,ist )
select 0 as einnahmen,3 as dr,0 as nix,'Summe Einnahmen',sum(akts)-sum(reste),sum(haushaltsvorgriff),
sum(ist) from tmp_konto where
      substring(titel from 1 for 1)  in ('0','1','2','3')  
   group by 1,2,3,4;
  
    
   
   
   --Ausgaben
 insert into tmp_erg (sort_ea,sort_einzeltit_dr,name) values (1,-1,'Ausgaben');  
    
  --Einzeltitel
<@sumit  sortea="1" sort_einzeltit_dr="0 as einzeltit" sort_drtit="0" typ='tit' feld="titel" dr="dr='einzeltitel'" />
 
 --erschrift Titelgruppen
 --insert into tmp_erg (sort_ea,sort_einzeltit_dr,name) values (1,1,'Titelgruppen');
 
  --Deckungsringberschriften
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,typ,dr )
select distinct 1 as ausgaben,2 as dr,0 as drbez,'dr',dr from tmp_konto where 
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
  and dr!='einzeltitel';

  -- Titel des DR
  <@sumit  sortea="1" sort_einzeltit_dr="2 as dreinzeltit" sort_drtit="2" typ='tit' feld="titel"  dr="dr!='einzeltitel'" />
 
  --Summe des Dr
   <@sumit  sortea="1" sort_einzeltit_dr="2 as dreinzeltit" sort_drtit="4 as drsum" typ='drsum' feld="''" dr="dr!='einzeltitel'" />
 
  --summe Ausgaben
  insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,name,soll,haushaltsvorgriff,ist )
select 1 as ausgaben,3 as dr,0 as nix,'Summe Ausgaben',sum(akts)-sum(reste),sum(haushaltsvorgriff),
sum(ist) from tmp_konto where
     substring(titel from 1 for 1) in ('4','5','6','7','8','9')
   group by 1,2,3,4; 
--leerzeilen
insert into tmp_erg (sort_ea,sort_einzeltit_dr,sort_drtit,dr) values (1,0,5,'einzeltitel'); -- leerzeile
insert into tmp_erg (sort_ea, sort_einzeltit_dr,sort_drtit,dr)
select distinct 1,2 as dr,5,dr from tmp_konto where substring(titel from 1 for 1)  in ('4','5','6','7','8','9')
  and dr!='einzeltitel';

   drop table tmp_konto;

update tmp_erg set einnahmen_ausgaben='einnahmen' where sort_ea=0;
update tmp_erg set einnahmen_ausgaben='ausgaben' where sort_ea=1;
   
      --erluerungen 
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_JE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.titel=kenn_zahl_wert.titel ) where einnahmen_ausgaben='einnahmen' and typ='tit';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_JE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.dr=kenn_zahl_wert.titel) where einnahmen_ausgaben='einnahmen' and typ='drsum';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_JE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    kenn_zahl_wert.titel='70') where einnahmen_ausgaben='einnahmen' and typ='drsum' and dr='70,72,73,74';
    
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_JA' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.titel=kenn_zahl_wert.titel) where einnahmen_ausgaben='ausgaben' and typ='tit';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_JA' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.dr=kenn_zahl_wert.titel) where einnahmen_ausgaben='ausgaben' and typ='drsum';
  

--SUmmenberechnung
update tmp_erg set gesamtsoll=nvl(soll,0)+nvl(haushaltsvorgriff,0);
update tmp_erg set abweichung=nvl(ist,0)-nvl(gesamtsoll,0);
update tmp_erg set gesamtsoll=null where gesamtsoll=0;
update tmp_erg set haushaltsvorgriff=null where haushaltsvorgriff=0;
update tmp_erg set soll=null where soll=0;
update tmp_erg set ist=null where ist=0;


--namen
update tmp_erg set name=(select substring(min(ktobez) from 7) from kenn_titel where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and tmp_erg.titel=kenn_titel.titel) where typ='tit';
update tmp_erg set name='',titel='TG '||dr||' '||(select substring(min(ktobez) from 4) from kenn_dr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and tmp_erg.dr=kenn_dr.dr) where typ='dr'
and dr!='70,72,73,74';
update tmp_erg set name='Summe der Titelgruppe' where typ='drsum' and dr!='70,72,73,74';
update tmp_erg set name='Summe der Titelgruppen' where typ='drsum' and dr='70,72,73,74';
update tmp_erg set abweichung=null where (name is null or name='') or (ist is null and gesamtsoll is null);

select einnahmen_ausgaben,dr,titel,name,soll,haushaltsvorgriff,gesamtsoll,ist,abweichung,erl from tmp_erg order by sort_ea,sort_einzeltit_dr,dr,sort_drtit,titel;



<#else>
-- alte Version
<#assign zeilen={"list":[
 {"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"Einnahmen","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"11949","zw":"Vermischte Einnahmen","formel":"'11949'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"12902","zw":"Einnahmen aus dem Betrieb der Institute, Laboratorien usw.","formel":"'12902'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"23131","zw":"Zuweisungen des Bundes fr Stipendien fr besonders begabte Studenten","formel":"'23131'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"23201","zw":"Zuweisungen des Freistaates Sachsen zum laufenden Betrieb","formel":"'23201'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"23501","zw":"Erstattungen im Rahmen des Altersteilzeitgesetzes","formel":"'23501'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"23503","zw":"Zuweisungen der Bundesagentur fr Arbeit ","formel":"'23503'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"26101","zw":"Programmpauschalen","formel":"'26101'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"28231","zw":"Zuweisungen von Dritten fr Stipendien fr besonders begabte Studenten","formel":"'28231'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"33201","zw":"Zuweisungen des Freistaates Sachsen fr Investitionen","formel":"'33201'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"35901","zw":"Entnahme aus der Rcklage","formel":"'35901'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"36001","zw":"berschuss des Vorjahres aus Landesmitteln","formel":"'36001'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"36002","zw":"berschuss des Vorjahres aus Drittmitteln","formel":"'36002'"},
{"einnahmen_ausgaben":"einnahmen","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"TG 52 Frderung der Forschung und Lehre aus Zuweisungen des Bundes und der DFG","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"23152","zw":"Zuweisungen fr laufende Zwecke","formel":"'23152'"},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"33152","zw":"Zuweisungen fr Investitionen","formel":"'33152'"},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"","zw":"Summe der Titelgruppe","formel":"'23152','33152'"},
{"einnahmen_ausgaben":"einnahmen","dr":"52","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"TG 53 Zuschsse von Sonstigen einschlielich Spenden","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"28253","zw":"Zuschsse fr laufende Zwecke","formel":"'28253'"},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"34253","zw":"Zuschsse fr Investitionen","formel":"'34253'"},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"","zw":"Summe der Titelgruppe","formel":"'28253','34253'"},
{"einnahmen_ausgaben":"einnahmen","dr":"53","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"TG 70, 72, 73, 74","zw":"","formel":""},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"23270","zw":"Zuweisungen fr Projekte ","formel":"'23270'"},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"23272","zw":"Zuweisungen Hochschulpakt 2020","formel":"'23272'"},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"23273","zw":"Zuweisungen fr Manahmen aus Mitteln des EU-Regionalfonds (EFRE)","formel":"'23273'"},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"23274","zw":"Zuweisungen fr Manahmen aus Mitteln des Europischen Sozialfonds (ESF)","formel":"'23274'"},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"","zw":"Summe der Titelgruppen","formel":"'23270','23272','23273','23274'"},
{"einnahmen_ausgaben":"einnahmen","dr":"70","titel":"","zw":"Gesamteinnahmen","formel":"'11949','12902','23131','23201','23501','23503','26101','28231','33201','35901','36001','36002','23152','33152','28253','34253','23270','23272','23273','23274'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"Ausgaben","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42201","zw":"Bezge der planmigen Beamten und Richter (einschl. Abordnungen)","formel":"'42201'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42206","zw":"Leistungsbezahlung Beamte","formel":"'42206'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42711","zw":"Entgelte fr Leistungen sonstiger Beschftigter","formel":"'42711'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42801","zw":"Entgelte fr Arbeitnehmerinnen und Arbeitnehmer","formel":"'42801'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42812","zw":"Aufwendungen fr Beschftigte in Arbeitsbeschaffungsmanahmen","formel":"'42812'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42821","zw":"Entgelte fr Auszubildende in tariflichen Ausbildungsverhltnissen","formel":"'42821'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"42826","zw":"Sonstige nicht stellenplangebundene Personalausgaben","formel":"'42826'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"44301","zw":"Untersttzungen auf Grund der Untersttzungsgrundstze, Frsorgemanahmen sowie Kosten nach dem Arbeitssicherheitsgesetz","formel":"'44301'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"45301","zw":"Trennungsgeld und Umzugskostenvergtungen","formel":"'45301'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"51101","zw":"Geschftsbedarf, Gerte und Ausstattungsgegenstnde, Brief- und Paketgebhren, Fernmeldegebhren","formel":"'51101'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"51701","zw":"Bewirtschaftung der Grundstcke, Gebude und Rume","formel":"'51701'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"51901","zw":"Unterhaltung der Grundstcke und baulichen Anlagen","formel":"'51901'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"52501","zw":"Aus- und Fortbildung, Umschulung","formel":"'52501'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"52701","zw":"Reisekostenvergtungen","formel":"'52701'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"52901","zw":"Zur Verfgung des Rektors fr auergewhnlichen Aufwand aus dienstlicher Veranlassung in besonderen Fllen","formel":"'52901'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"53101","zw":"Kosten fr Verffentlichungen, Dokumentation und ffentlichkeitsarbeit","formel":"'53101'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"54649","zw":"Vermischte Verwaltungsausgaben","formel":"'54649'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"68131","zw":"Stipendien fr besonders begabte Studenten","formel":"'68131'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"68501","zw":"Mitgliedsbeitrge","formel":"'68501'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"68502","zw":"Zuwendungen an Dritte","formel":"'68502'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"81101","zw":"Erwerb von Dienstfahrzeugen","formel":"'81101'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"81201","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81201'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"91901","zw":"Zufhrungen zur Rcklage","formel":"'91901'"},
{"einnahmen_ausgaben":"ausgaben","dr":"einz","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"TG 51 Lehre und Forschung","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"42751","zw":"Beschftigungsentgelte","formel":"'42751'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"51151","zw":"Geschftsbedarf, Gerte und Ausstattungen","formel":"'51151'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"52351","zw":"Wissenschaftliche Literatur","formel":"'52351'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"52751","zw":"Reisekostenvergtungen","formel":"'52751'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"54751","zw":"Sonstige schliche Ausgaben","formel":"'54751'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"81251","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81251'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"","zw":"Summe der Titelgruppe","formel":"'42751','51151','52351','52751','54751','81251'"},
{"einnahmen_ausgaben":"ausgaben","dr":"51","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"TG 52 Frderung der Forschung und Lehre aus Zuweisungen des Bundes und der DFG ","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"42852","zw":"Drittmittelfinanzierte Personalausgaben","formel":"'42852'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"45952","zw":"Vermischte Personalausgaben","formel":"'45952'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"54752","zw":"Schliche Ausgaben","formel":"'54752'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"81252","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81252'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"","zw":"Summe der Titelgruppe","formel":"'42852','45952','54752','81252'"},
{"einnahmen_ausgaben":"ausgaben","dr":"52","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"TG 53 Zuschsse von Sonstigen einschlielich Spenden","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"42853","zw":"Drittmittelfinanzierte Personalausgaben","formel":"'42853'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"45953","zw":"Vermischte Personalausgaben","formel":"'45953'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"54753","zw":"Schliche  Ausgaben","formel":"'54753'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"81253","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81253'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"","zw":"Summe der Titelgruppe","formel":"'42853','45953','54753','81253'"},
{"einnahmen_ausgaben":"ausgaben","dr":"53","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"TG 60 Institute, Laboratorien usw.","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"45960","zw":"Vermischte Personalausgaben","formel":"'45960'"},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"54760","zw":"Schliche Ausgaben","formel":"'54760'"},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"81260","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81260'"},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"","zw":"Summe der Titelgruppe","formel":"'45960','54760','81260'"},
{"einnahmen_ausgaben":"ausgaben","dr":"60","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"TG 70 Landesprojekte","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"42970","zw":"Personalausgaben","formel":"'42970'"},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"54770","zw":"Schliche Ausgaben","formel":"'54770'"},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"81270","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81270'"},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"","zw":"Summe der Titelgruppe","formel":"'42970','54770','81270'"},
{"einnahmen_ausgaben":"ausgaben","dr":"70","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"TG 72 Hochschulpakt 2020","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"42972","zw":"Personalausgaben","formel":"'42972'"},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"54772","zw":"Schliche Ausgaben","formel":"'54772'"},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"81272","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81272'"},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"","zw":"Summe der Titelgruppe","formel":"'42972','54772','81272'"},
{"einnahmen_ausgaben":"ausgaben","dr":"72","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"TG 73 Manahmen aus Mitteln des EU-Regional-fonds (EFRE)","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"42973","zw":"Personalausgaben","formel":"'42973'"},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"54773","zw":"Schliche Ausgaben","formel":"'54773'"},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"81273","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81273'"},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"","zw":"Summe der Titelgruppe","formel":"'42973','54773','81273'"},
{"einnahmen_ausgaben":"ausgaben","dr":"73","titel":"","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"TG 74 Manahmen aus Mitteln des Europischen Sozialfonds (ESF)","zw":"","formel":""},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"42974","zw":"Personalausgaben","formel":"'42974'"},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"54774","zw":"Schliche Ausgaben","formel":"'54774'"},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"81274","zw":"Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden","formel":"'81274'"},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"","zw":"Summe der Titelgruppe","formel":"'42974','54774','81274'"},
{"einnahmen_ausgaben":"ausgaben","dr":"74","titel":"","zw":"Gesamtausgaben","formel":"'42201','42206','42711','42801','42812','42821','42826','44301','45301','51101','51701','51901','52501','52701','52901','52501','52701','52901','53101','54649','68131','68501','68502','81101','81201','91901','42751','51151','52351','52751','54751','81251','42852','45952','54752','81252','42853','45953','54753','81253','45960','54760','81260','42970','54770','81270','42972','54772','81272','42973','54773','81273','42974','54774','81274'"}
]}/>

<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>

create temp table tmp_erg(
einnahmen_ausgaben char(10),
dr char(5),
titel varchar(255),
zw varchar(255),
sortnr integer,
soll <@doubletype/>,  --Aktuelles Soll statt W Haushaltansatz 19.2.2012 - da Reste extra dargestellt werden in zwei Titel (36001,36002) entspricht das in MBS akts-reste
haushaltsvorgriff <@doubletype/>,
gesamtsoll  <@doubletype/>,
ist <@doubletype/>,
abweichung  <@doubletype/>,
erl varchar(255)
)<@informixnolog/>
;

create temp table tmp_konto (dr char(5),dr2 char(5),titel char(10),
akts <@doubletype/> default 0,
reste <@doubletype/> default 0,
haushaltsvorgriff <@doubletype/> default 0,
ist  <@doubletype/> default 0
) <@informixnolog/>;
---- statt W Hhans  S aktuelles Soll, X Ausgaben, Y Einnahmen, Z Reste, V = Haushaltsvorgriff 
insert into tmp_konto (dr,titel,akts)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='S'  
group by 1,2;
insert into tmp_konto (dr,titel,reste)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='Z'  
group by 1,2;
insert into tmp_konto (dr,titel,haushaltsvorgriff)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and
jahr=<<Haushaltsjahr>> and betragsart='V'  
group by 1,2;


  --einnahmen
insert into tmp_konto (dr,titel,ist)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and betragsart='Y'   and
substring(titel from 1 for 1) in ('0','1','2','3')
group by 1,2;
 --ausgaben
insert into tmp_konto (dr,titel,ist)
select dr,titel,sum(betrag) from kenn_konto_aggr where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and jahr=<<Haushaltsjahr>> and betragsart='X'  and
substring(titel from 1 for 1) in ('4','5','6','7','8','9')
 group by 1,2;


 
 <#assign sortnr=0/>
 <#foreach zeile in zeilen.list>
 <#assign sortnr=sortnr+1/>
 <#if zeile.formel="">
 insert into tmp_erg (einnahmen_ausgaben,titel,dr,zw,sortnr )
 values ('${zeile.einnahmen_ausgaben}','${zeile.titel}','${zeile.dr}','${zeile.zw}',${sortnr});
 <#else>
insert into tmp_erg (einnahmen_ausgaben,dr,titel,zw,sortnr,soll,haushaltsvorgriff,ist )
select '${zeile.einnahmen_ausgaben}','${zeile.dr}','${zeile.titel}','${zeile.zw}',${sortnr},sum(akts)-sum(reste),sum(haushaltsvorgriff),sum(ist)
from xdummy left outer join tmp_konto on (
titel in (${zeile.formel}) )
group by 1,2,3,4,5;
 
 </#if>
</#foreach>
   drop table tmp_konto;
   
      --erluerungen 
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_JE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.titel=kenn_zahl_wert.titel ) where einnahmen_ausgaben='einnahmen' and zw not like 'Summe der Titelgruppe%';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_JE' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.dr=kenn_zahl_wert.titel) where einnahmen_ausgaben='einnahmen' and zw like 'Summe der Titelgruppe%';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_JA' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.titel=kenn_zahl_wert.titel) where einnahmen_ausgaben='ausgaben' and zw not like 'Summe der Titelgruppe%';
   update tmp_erg set erl=(select wert_str from kenn_zahl_wert where hs_nr::char(10) in <@printkeys .vars["Hochschule"].allNeededKeys /> and kenn_zahl='ERL_KAM_JA' and kenn_zahl_wert.jahr=<<Haushaltsjahr>> and 
    tmp_erg.dr=kenn_zahl_wert.titel) where einnahmen_ausgaben='ausgaben' and zw like 'Summe der Titelgruppe%';
  

--SUmmenberechnung
update tmp_erg set gesamtsoll=nvl(soll,0)+nvl(haushaltsvorgriff,0);
update tmp_erg set abweichung=nvl(ist,0)-nvl(gesamtsoll,0);
update tmp_erg set gesamtsoll=null where gesamtsoll=0;
update tmp_erg set haushaltsvorgriff=null where haushaltsvorgriff=0;
update tmp_erg set soll=null where soll=0;
update tmp_erg set ist=null where ist=0;

update tmp_erg set abweichung=null where (zw is null or zw='') or (ist is null and gesamtsoll is null);


select einnahmen_ausgaben,dr,titel,zw,soll,haushaltsvorgriff,gesamtsoll,ist,abweichung,erl from tmp_erg order by sortnr;
</#if>
