--freemarker template
<sqlvars>
<sqlvar name="anzahl"><![CDATA[select count(*) from 
<#if "<<Art des Berichts>>"="'G'">
kenn_fibu_guv 
<#else>
kenn_fibu_bilanz
</#if>
where hs_nr=<<Hochschule>> and jahr=<<Jahr>>
]]></sqlvar>
</sqlvars>

<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>
CREATE temp table tmp_bericht
(
   tid serial,
   name       varchar(255),
   name2 varchar(255),
   hierarchie_ebene  smallint,
   betrag            <@doubletype/>,
   betragvorjahr     <@doubletype/>,
   unterstrich       smallint      ,
   sortnr            integer        ,
   sortnr2           integer        
     
) <@informixnolog/>;
<#if "<<Art des Berichts>>"="'G'"&&anzahl?number!=56>
 <#if anzahl?number=0>
  insert into tmp_bericht (name,hierarchie_ebene) values ('Fr das Jahr <<Jahr>> wurden keine Daten gefunden',1);
  <#else>
  insert into tmp_bericht (name,hierarchie_ebene) values ('Falsche Datensatzanzahl erwartet 56 - gefunden ${anzahl} - Fibu Konfiguration prfen!!',1);
  </#if>
<#elseif "<<Art des Berichts>>"="'B'"&&anzahl?number!=72>
   <#if anzahl?number=0>
  insert into tmp_bericht (name,hierarchie_ebene) values ('Fr das Jahr <<Jahr>> wurden keine Daten gefunden',1);
  <#else>
  insert into tmp_bericht (name,hierarchie_ebene) values ('Falsche Datensatzanzahl erwartet 72 - gefunden ${anzahl} - Fibu Konfiguration prfen!!',1);
  </#if>
<#else>
insert into tmp_bericht (name,hierarchie_ebene,unterstrich,betragvorjahr,betrag,sortnr,sortnr2)
select name,hierarchie_ebene,unterstrich,betragvorjahr,betrag,sortnr,sortnr2
from 
<#if "<<Art des Berichts>>"="'G'">
kenn_fibu_guv 
<#else>
kenn_fibu_bilanz
</#if>
where hs_nr=<<Hochschule>> and jahr=<<Jahr>> order by sortnr,sortnr2;

create temp table tmp_leerzeilen (sortnr integer);
<#if "<<Art des Berichts>>"="'G'">
insert into tmp_leerzeilen select sortnr from tmp_bericht where  tid in (15,48,53,14);
--name like '= Summe der (ordentlichen) Ertrge%' or name like '= Finanzergebnis%' or
--name like '= Auerordentliches Ergebnis%' or name like '5.4. Sonstige Ertrge%';
insert into tmp_bericht (name,hierarchie_ebene,sortnr) select ' ',3,sortnr+1 from tmp_leerzeilen;

update tmp_bericht set name='Ertrge',betrag=null,betragvorjahr=null where tid=1;
update tmp_bericht set name='1. Ertrge aus wirtschaftlicher Hochschulttigkeit' where tid=2;
update tmp_bericht set name='2. Ertrge aus Gebhren und Sanktionen, Entgelte' where tid=3;
update tmp_bericht set name='3. Erhhung oder Verminderung des Bestandes an unfertigen Leistungen' where tid=4;
update tmp_bericht set name='4. Andere aktivierte Eigenleistungen' where tid=5;
update tmp_bericht set name='5. Sonstige betriebliche Ertrge',betrag=null,betragvorjahr=null where tid=6;
update tmp_bericht set name='5.1. Ertrge aus Zuweisungen, Zuschssen und Drittmitteln',betrag=null,betragvorjahr=null where tid=7;
update tmp_bericht set name='5.1.1. Zuschuss des Freistaates Sachsen fr den laufenden Betrieb' where tid=8;
update tmp_bericht set name='5.1.2. Ertrge aus Projektfrderung' where tid=9;
update tmp_bericht set name='5.1.3. Sonstige Ertrge aus Zuweisungen und Zuschssen, Kostenerstattungen' where tid=10;
update tmp_bericht set name='5.2. Ertrge aus Zuweisungen, Zuschssen fr Finanzierung von Investitionen' where tid=11;
update tmp_bericht set name='darunter vom Freistaat Sachsen' where tid=12;
update tmp_bericht set name='5.3. Ertrge aus der Auflsung von Sonderposten' where tid=13;
update tmp_bericht set name='5.4. Sonstige Ertrge' where tid=14;
update tmp_bericht set name='= Summe der (ordentlichen) Ertrge' where tid=15;
update tmp_bericht set name='Aufwendungen',betrag=null,betragvorjahr=null where tid=16;
update tmp_bericht set name='6. Materialaufwand' where tid=17;
update tmp_bericht set name='a) Aufwand fr Roh- Hilfs- und Betriebsstoffe und fr bezogene Waren' where tid=18;
update tmp_bericht set name='b) Aufwendungen fr bezogene Leistungen' where tid=19;
update tmp_bericht set name='7. Personalaufwand',betrag=null,betragvorjahr=null where tid=20;
update tmp_bericht set name='a) Entgelte' where tid=21;
update tmp_bericht set name='b) Bezge' where tid=22;
update tmp_bericht set name='c) Vergtungen fr Auszubildende/Volontre' where tid=23;
update tmp_bericht set name='d) Entgelte fr Drittmittelbeschftigte' where tid=24;
update tmp_bericht set name='e) Soziale Abgaben und Aufwendungen fr Altersversorgung und fr Untersttzung' where tid=25;
update tmp_bericht set name='darunter fr Altersversorgung' where tid=26;
update tmp_bericht set name='f) Sonstige Personalaufwendungen' where tid=27;
update tmp_bericht set name='8. Abschreibungen' where tid=28;
update tmp_bericht set name='9. Sonstige betriebliche Aufwendungen',betrag=null,betragvorjahr=null where tid=29;
update tmp_bericht set name='a) Aufwendungen fr die Inanspruchnahme von Rechten und Diensten' where tid=30;
update tmp_bericht set name='b) Weitere Aufwendungen fr Kommunikation, Dokumentation, Information, Reisen, Literatur, Werbung' where tid=31;
update tmp_bericht set name='c) Aufwendungen fr Beitrge und Sonstiges sowie Wertkorrekturen und periodenfremde Aufwendungen' where tid=32;
update tmp_bericht set name='darunter Aufwendungen fr die Einstellung in Sonderposten' where tid=33;
update tmp_bericht set name='d) Aufwendungen fr Zuwendungen und Zuschsse, Investitionszuschsse und Kostenerstattungen' where tid=34;
update tmp_bericht set name='e) Aufwendungen fr sonstige Leistungen an Dritte' where tid=35;
update tmp_bericht set name='f) Betriebliche Steuern' where tid=36;
update tmp_bericht set name='= Summe der (ordentlichen) Aufwendungen' where tid=37;
update tmp_bericht set name='Finanzanlageergebnis und Zinsen' where tid=38;
update tmp_bericht set name='10. Ertrge aus Beteiligungen' where tid=39;
update tmp_bericht set name='darunter aus verbundenen Unternehmen' where tid=40;
update tmp_bericht set name='11. + Ertrge aus anderen Wertpapieren und Ausleihungen des Finanzanlagevermgens' where tid=41;
update tmp_bericht set name='darunter aus verbundenen Unternehmen' where tid=42;
update tmp_bericht set name='12. + Sonstige Zinsen und hnliche Ertrge' where tid=43;
update tmp_bericht set name='darunter aus verbundenen Unternehmen' where tid=44;
update tmp_bericht set name='13. - Abschreibungen auf Finanzanlagen und auf Wertpapiere des Umlaufvermgens' where tid=45;
update tmp_bericht set name='14. - Zinsen und hnliche Aufwendungen' where tid=46;
update tmp_bericht set name='darunter aus verbundenen Unternehmen' where tid=47;
update tmp_bericht set name='= Finanzergebnis' where tid=48;
update tmp_bericht set name='Ordentliche Ertrge - ordentliche Aufwendungen +/- Finanzergebnis' where tid=49;
update tmp_bericht set name='= Ergebnis der gewhnlichen Geschftsttigkeit' where tid=50;
update tmp_bericht set name='15. + Auerordentliche Ertrge' where tid=51;
update tmp_bericht set name='16. - Auerordentliche Aufwendungen' where tid=52;
update tmp_bericht set name='= Auerordentliches Ergebnis' where tid=53;
update tmp_bericht set name='17. - Steuern vom Einkommen und vom Ertrag' where tid=54;
update tmp_bericht set name='18. - Sonstige Steuern' where tid=55;
update tmp_bericht set name='= Jahresberschuss/Jahresfehlbetrag' where tid=56;
<#else> 
--Bilanz

insert into tmp_leerzeilen select sortnr from tmp_bericht where tid in (21,39,42,51,55,59,69,71);
--name like '6. Sonstige%' or name like 'IV. Kassen%' or name like 'E. Aktiver%' or name like 'IV. Bilanz%' or name like '3. Sonderposten%' or
--name like '3. Sonstige%' or name like '9. Sonstige%' or name like 'F. Passive%';
insert into tmp_bericht (name,hierarchie_ebene,sortnr) select ' ',4,sortnr+1 from tmp_leerzeilen;

update tmp_bericht set name='Aktivseite der Bilanz (AKTIVA)',betrag=null,betragvorjahr=null where tid=1;
update tmp_bericht set name='A. Anlagevermgen',betrag=null,betragvorjahr=null where tid=2;
update tmp_bericht set name='I. Immaterielle Vermgensgegenstnde' where tid=3;
update tmp_bericht set name='1. Selbst geschaffene gewerbliche Schutzrechte und hnliche Rechte und Werte' where tid=4;
update tmp_bericht set name='2. Entgeltlich erworbene Konzessionen, gewerbliche Schutzrechte und hnliche Rechte und Werte sowie Lizenzen an solchen Rechten und Werten' where tid=5;
update tmp_bericht set name='3. Geschfts- oder Firmenwert' where tid=6;
update tmp_bericht set name='4. Geleistete Anzahlungen auf immaterielle Vermgensgegenstnde' where tid=7;
update tmp_bericht set name='5. Geleistete Investitionszuschsse' where tid=8;
update tmp_bericht set name='II. Sachanlagen',betrag=null,betragvorjahr=null where tid=9;
update tmp_bericht set name='1. Grundstcke, grundstcksgleiche Rechte und Bauten einschlielich der Bauten auf fremden Grundstcken' where tid=10;
update tmp_bericht set name='2. Sachanlagen im Gemeingebrauch' where tid=11;
update tmp_bericht set name='3. Technische Anlagen und Maschinen' where tid=12;
update tmp_bericht set name='4. Andere Anlagen, Betriebs- und Geschftsausstattung' where tid=13;
update tmp_bericht set name='5. Geleistete Anzahlungen auf Anlagen im Bau' where tid=14;
update tmp_bericht set name='III. Finanzanlagen',betrag=null,betragvorjahr=null where tid=15;
update tmp_bericht set name='1. Anteile an verbundenen Unternehmen' where tid=16;
update tmp_bericht set name='2. Ausleihungen an verbundene Unternehmen' where tid=17;
update tmp_bericht set name='3. Beteiligungen' where tid=18;
update tmp_bericht set name='4. Ausleihungen an Unternehmen, mit denen ein Beteiligungsverhltnis besteht' where tid=19;
update tmp_bericht set name='5. Wertpapiere des Anlagevermgens' where tid=20;
update tmp_bericht set name='6. Sonstige Ausleihungen (Sonstige Finanzanlagen)' where tid=21;
update tmp_bericht set name='B. Umlaufvermgen',betrag=null,betragvorjahr=null where tid=22;
update tmp_bericht set name='I. Vorrte',betrag=null,betragvorjahr=null where tid=23;
update tmp_bericht set name='1. Roh-, Hilfs- und Betriebsstoffe' where tid=24;
update tmp_bericht set name='2. Unfertige Erzeugnisse, unfertige Leistungen' where tid=25;
update tmp_bericht set name='3. Fertige Erzeugnisse und Waren' where tid=26;
update tmp_bericht set name='4. Geleistete Anzahlungen auf Vorrte' where tid=27;
update tmp_bericht set name='II. Forderungen und sonstige Vermgensgegenstnde',betrag=null,betragvorjahr=null where tid=28;
update tmp_bericht set name='1. Forderungen gegenber dem Freistaat Sachsen' where tid=29;
update tmp_bericht set name='2. Forderungen aus Lieferungen und Leistungen' where tid=30;
update tmp_bericht set name='3. Forderungen gegenber verbundenen Unternehmen' where tid=31;
update tmp_bericht set name='4. Forderungen gegenber Unternehmen, mit denen ein Beteiligungsverhltnis besteht' where tid=32;
update tmp_bericht set name='5. Forderungen gegenber anderen Bereichen der ffentlichen Hand und der nicht-ffentlichen Bereiche (Forderungen aus Projektfrderung)' where tid=33;
update tmp_bericht set name='6. Forderungen gegenber anderen Zuschussgebern' where tid=34;
update tmp_bericht set name='7. Sonstige Vermgensgegenstnde' where tid=35;
update tmp_bericht set name='III. Wertpapiere',betrag=null,betragvorjahr=null where tid=36;
update tmp_bericht set name='1. Anteile an verbundenen Unternehmen' where tid=37;
update tmp_bericht set name='2. Sonstige Wertpapiere des Umlaufvermgens' where tid=38;
update tmp_bericht set name='IV. Kassenbestand, Bundesbankguthaben, Guthaben bei Kreditinstituten und Schecks' where tid=39;
update tmp_bericht set name='C. Aktive Rechnungsabgrenzungsposten' where tid=40;
update tmp_bericht set name='D. Aktive latente Steuern' where tid=41;
update tmp_bericht set name='E. Aktiver Unterschiedsbetrag aus der Vermgensrechnung' where tid=42;
update tmp_bericht set name='Summe Aktiva' where tid=43;
update tmp_bericht set name='Passivseite der Bilanz (PASSIVA)',betrag=null,betragvorjahr=null where tid=44;
update tmp_bericht set name='A. Eigenkapital',betrag=null,betragvorjahr=null where tid=45;
update tmp_bericht set name='I. Nettoposition' where tid=46;
update tmp_bericht set name='II. Kapitalrcklage und Sondervermgen' where tid=47;
update tmp_bericht set name='III. Gewinnrcklagen',betrag=null,betragvorjahr=null where tid=48;
update tmp_bericht set name='1. Gewinnrcklage' where tid=49;
update tmp_bericht set name='2. Sonstige zweckgebundene Rcklagen' where tid=50;
update tmp_bericht set name='IV. Bilanzgewinn/ -verlust' where tid=51;
update tmp_bericht set name='B. Sonderposten fr Investitionszuschsse',betrag=null,betragvorjahr=null where tid=52;
update tmp_bericht set name='1. Sonderposten fr Investitionszuschsse des Freistaates Sachsen' where tid=53;
update tmp_bericht set name='2. Sonderposten fr Investitionszuschsse des sonstigen ffentlichen Bereiches' where tid=54;
update tmp_bericht set name='3. Sonderposten fr Investitionszuschsse des nicht-ffentlichen Bereiches' where tid=55;
update tmp_bericht set name='C. Rckstellungen',betrag=null,betragvorjahr=null where tid=56;
update tmp_bericht set name='1. Rckstellungen fr Pensionen und hnliche Verpflichtungen' where tid=57;
update tmp_bericht set name='2. Steuerrckstellungen' where tid=58;
update tmp_bericht set name='3. Sonstige Rckstellungen' where tid=59;
update tmp_bericht set name='D. Verbindlichkeiten',betrag=null,betragvorjahr=null where tid=60;
update tmp_bericht set name='1. Anleihen, Wertpapierschulden und Ausgleichsforderungen' where tid=61;
update tmp_bericht set name='2. Verbindlichkeiten gegenber Kreditinstituten' where tid=62;
update tmp_bericht set name='3. Erhaltene Anzahlungen auf Bestellungen' where tid=63;
update tmp_bericht set name='4. Verbindlichkeiten gegenber dem Freistaat Sachsen' where tid=64;
update tmp_bericht set name='5. Verbindlichkeiten aus Lieferungen und Leistungen' where tid=65;
update tmp_bericht set name='6. Verbindlichkeiten aus Steuern' where tid=66;
update tmp_bericht set name='7. Verbindlichkeiten gegenber verbundenen Unternehmen und Unternehmen, mit denen ein Beteiligungsverhltnis besteht' where tid=67;
update tmp_bericht set name='8. Verbindlichkeiten gegenber Gebietskrperschaften sowie dem sonstigen ffentlichen Bereich (Verbindlichkeiten aus Projektfrderung)' where tid=68;
update tmp_bericht set name='9. Sonstige Verbindlichkeiten' where tid=69;
update tmp_bericht set name='E. Passive Rechnungsabgrenzungsposten' where tid=70;
update tmp_bericht set name='F. Passive latente Steuern' where tid=71;
update tmp_bericht set name='Summe Passiva' where tid=72;


--update tmp_bericht set name='',name2='5.1.1.) Zuschuss des Freistaates Sachsen fr laufenden Betrieb' where name like '5.1.1%';
--update tmp_bericht set name='',name2='5.1.2.) Ertrge aus Projektfrderung' where name like '5.1.2%';
--update tmp_bericht set name='',name2='5.1.2.) Sonstige Ertrge aus Zuweisungen und Zuschssen, Kostenerstattungen' where name like '5.1.3%';
--update tmp_bericht set name='  a)',name2=replace(name,'a)','') where name like 'a)%';
--update tmp_bericht set name='  b)',name2=replace(name,'b)','') where name like 'b)%';
--update tmp_bericht set name='  c)',name2=replace(name,'c)','') where name like 'c)%';
--update tmp_bericht set name='  d)',name2=replace(name,'d)','') where name like 'd)%';
--update tmp_bericht set name='  e)',name2=replace(name,'e)','') where name like 'e)%';
--update tmp_bericht set name='  f)',name2=replace(name,'f)','') where name like 'f)%';

--update tmp_bericht set name='',name2=name where name like 'darunter%';


</#if>
drop table tmp_leerzeilen;
update tmp_bericht set betrag=null where betrag=0;
update tmp_bericht set betragvorjahr=null where betragvorjahr=0;
</#if>
select tid::varchar(2),name,hierarchie_ebene,unterstrich,betragvorjahr,betrag from tmp_bericht
order by sortnr,sortnr2;
