--freemarker template


 
create temp table tmp_erg(sort smallint,
titel char(10),
zweck varchar(255),
ist decimal(14,2),
soll decimal(14,2),
plan1 decimal(14,2),
plan2 decimal(14,2)
)<@informixnolog/>
;
-- V Soll, W Hhans, X Ausgaben, Y Einnahmen, Z Reste
<#macro row sort titel zweck einnahmen>
insert into tmp_erg (sort,titel,zweck,ist,soll,plan1,plan2)
values
(${sort}, '${titel}','${zweck}',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and 
<#if einnahmen==true>betragsart='Y'<#else>betragsart='X'</#if>
and jahr=<<Haushaltsjahr>> and titel='${titel}'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and titel='${titel}'),
(select sum(wert) from kenn_zahl_wert where kenn_zahl='KAMWP_PLAN' and hs_nr=<<Hochschule>> and jahr=<<Haushaltsjahr>>+2 and titel='${titel}'),
(select sum(wert) from kenn_zahl_wert where kenn_zahl='KAMWP_PLAN' and hs_nr=<<Hochschule>> and jahr=<<Haushaltsjahr>>+3 and titel='${titel}')
);

</#macro>

<#macro dr sort zweck bedingung einnahmen>
insert into tmp_erg (sort,zweck,ist,soll,plan1,plan2)
values
(${sort}, '${zweck}',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and 
<#if einnahmen==true>betragsart='Y'<#else>betragsart='X'</#if>
and jahr=<<Haushaltsjahr>> and ${bedingung}),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and ${bedingung}),
(select sum(wert) from kenn_zahl_wert where kenn_zahl='KAMWP_PLAN' and hs_nr=<<Hochschule>> and jahr=<<Haushaltsjahr>>+2 and ${bedingung}),
(select sum(wert) from kenn_zahl_wert where kenn_zahl='KAMWP_PLAN' and hs_nr=<<Hochschule>> and jahr=<<Haushaltsjahr>>+3 and ${bedingung})
);

</#macro>

<@row sort=1 titel='11949' zweck='Vermischte Einnahmen' einnahmen=true/>
<@row sort=2 titel='23201' zweck='Zuweisungen des Freistssaates Sachsen zum laufenden Betrieb' einnahmen=true/>
<@row sort=3 titel='23503' zweck='Zuweisungen der Bundesagentur fr Arbeit' einnahmen=true/>
<@row sort=4 titel='28201' zweck='Sonstige Erstattungen und Zuschsse aus dem Inland einschlielich Spenden' einnahmen=true/>
<@row sort=5 titel='33201' zweck='' einnahmen=true/>
<@dr sort=6 zweck='TG 52 Frderung der Forschung und Lehre aus Zuweisungen des Bundes und der DFG einschlielich Sonderforschungsbereiche' 
   bedingung="titel in ('23152','28252','33152')" einnahmen=true/> 
<@row sort=7 titel='23152' zweck='Zuweisungen fr laufende Zwecke' einnahmen=true/>
<@row sort=8 titel='28252' zweck='Zuschsse der DFG (einschl. Sonderforschungsbereiche)' einnahmen=true/>
<@row sort=9 titel='33152' zweck='Zuweisungen fr Investitionen' einnahmen=true/>
<@dr sort=10 zweck='TG 53 Zuschsse von Sonstigen' 
   bedingung="titel in ('28253','34253','23270')" einnahmen=true/>
<@row sort=11 titel='28253' zweck='Zuschsse fr laufende Zwecke' einnahmen=true/>
<@row sort=12 titel='34253' zweck='Zuschsse fr Investitionen' einnahmen=true/>
<@row sort=13 titel='23270' zweck='Zuweisungen fr Projekte' einnahmen=true/>


	

<@dr sort=14 zweck='Einzeltitel' 
   bedingung="titel in ('23272','23273','23274')" einnahmen=true/>

<@row sort=15 titel='23272' zweck='Zuweisungen Hochschulpakt 2020' einnahmen=true/>
 <@row sort=16 titel='23273' zweck='Zuweisungen fr Manahmen aus Mitteln des EU-Regionalsfonds (EFRE)-Frderperiode 2007-2013' einnahmen=true/>
 <@row sort=17 titel='23274' zweck='Zuweisungen fr Manahmen aus Mitteln des Europischen Sozialfonds (ESF)- Frderperiode 2007-2013 ' einnahmen=true/>
 
 create temp table tmp_sum (ist decimal(14,2),
soll decimal(14,2),
plan1 decimal(14,2),
plan2 decimal(14,2)) <@informixnolog/>;
 insert into tmp_sum select sum(ist),sum(soll),sum(plan1),sum(plan2) from tmp_erg
 where titel is not null; --nicht DR-Summen noch mal reinrechnen
 
 insert into tmp_erg (sort,zweck,ist,soll,plan1,plan2)
 select 18,'Einnahmen gesamt:',ist,soll,plan1,plan2 from  tmp_sum;
 delete from tmp_sum;
 
 
 <@row sort=100 titel='42201' zweck='Bezge der planmigen Beamten und Richter (einschl. Abordnungen)' einnahmen=false/>
 <@row sort=101 titel='42401' zweck='Versorgungsrcklage' einnahmen=false/>
 <@row sort=102 titel='42701' zweck='Entgelte und sonstige Aufwendungen fr nebenamtlich und nebenberuflich Ttige' einnahmen=false/>
 <@row sort=103 titel='42703' zweck='Entgelte und sonstige Aufwendungen fr studentische und wissenschaftliche Hilfskrfte' einnahmen=false/>
 <@row sort=104 titel='42712' zweck='Beschftigungsentgelte fr Sonstige' einnahmen=false/>
 <@row sort=105 titel='42801' zweck='Entgelte fr Arbeitnehmerinnen und Arbeitnehmer' einnahmen=false/>
 <@row sort=106 titel='42812' zweck='Aufwendungen fr Beschftigte in Arbeitsbeschftigungsmanehmen' einnahmen=false/>
 <@row sort=107 titel='42821' zweck='Entgelte fr Auszubildende in tariflichen Ausbildungsverhltnissen' einnahmen=false/>
 <@row sort=108 titel='42826' zweck='Sonstige nicht stellenplangebundene Personalausgaben' einnahmen=false/>
 <@row sort=109 titel='44301' zweck='Untersttzung auf Grund der Untersttzungsgrundstze, Frsorgemanahmen sowie Kosten nach dem Arbeiutssicherheitsgesetz' einnahmen=false/>
 <@row sort=110 titel='45301' zweck='Trennungsgeld und Umzugskostenvergtungen' einnahmen=false/>
 <@row sort=111 titel='51101' zweck='Geschftsbedarf, Gerte und Ausstattungsgegenstnde sowie Brief- und Paketgebhren' einnahmen=false/>
 <@row sort=112 titel='51701' zweck='Bewirtschaftung der Grundstcke, Gebude und Rume' einnahmen=false/>
 <@row sort=113 titel='51801' zweck='Mieten und Pachten fr Grundstcke und baulichen Anlagen' einnahmen=false/>
 <@row sort=114 titel='51901' zweck='Unterhaltung der Grundstcke und baulichen Anlagen' einnahmen=false/>
 <@row sort=115 titel='52701' zweck='Reisekostenvergtungen' einnahmen=false/>
 <@row sort=116 titel='52901' zweck='Zur Verfgung des Rektors fr auergewhnlichen Aufwand aus dienstlicher Veranlassung in besonderen Fllen' einnahmen=false/>
 <@row sort=117 titel='53101' zweck='Kosten fr Verffentlichungen,Dokumentation und ffentlichkeitsarbeit' einnahmen=false/>
 <@row sort=118 titel='54649' zweck='Vermischte Verwaltungsaufgabe' einnahmen=false/>
 <@row sort=119 titel='68501' zweck='Mitgliedsbeitrge' einnahmen=false/>
 <@row sort=120 titel='68502' zweck='Zuwendungen an Dritte' einnahmen=false/>
 <@row sort=121 titel='81101' zweck='Erwerb von Dienstfahrzeugen' einnahmen=false/>
 <@row sort=122  titel='81201' zweck='Erwerb von Gerten,Ausstattungs- und Ausrstungsgegenstnden' einnahmen=false/>

 <@dr sort=123 zweck='TG 51 Lehre und Forschung' 
   bedingung="titel in ('42751','51151','52351','54751','81251')" einnahmen=false/> 
 <@row sort=124 titel='42751' zweck='Beschftigungsentgelte' einnahmen=false/>
 <@row sort=125 titel='51151' zweck='Geschftsbedarf, Gerte und Ausstattungen' einnahmen=false/>
 <@row sort=126 titel='52351' zweck='Wissenschaftliche Literatur' einnahmen=false/>
 <@row sort=127 titel='54751' zweck='Sonstige schliche Ausgaben' einnahmen=false/>
 <@row sort=128 titel='81251' zweck='Erwerb von Gerten,Ausstattungs- und Ausstattungsgegenstnden' einnahmen=false/>
 	 				
 	 				
 	
 
 
 <@dr sort=129 zweck='TG 52 Frderung der Forschung und Lehre aus Zuweisungen des Bundes und der DFG einschlielich Sonderforschungsbereiche' 
   bedingung="titel in ('42852','54752','81252')" einnahmen=false/> 
<@row sort=130 titel='42852' zweck='Drittmittelfinanzierte Personalausgaben' einnahmen=false/>
<@row sort=131 titel='54752' zweck='Schliche Ausgaben' einnahmen=false/>
<@row sort=132 titel='81252' zweck='Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden' einnahmen=false/>
   
   <@dr sort=133 zweck='TG 53 Zuschsse von Sonstigen' 
   bedingung="titel in ('42853','57453','81253')" einnahmen=false/>
   <@row sort=134 titel='42853' zweck='Drittmittelfinanzierte Personalausgaben' einnahmen=false/>
   <@row sort=135 titel='54753' zweck='Schliche Ausgaben' einnahmen=false/>
   <@row sort=136 titel='81253' zweck='Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden' einnahmen=false/>
    
   <@dr sort=137 zweck='TG 70 Landesprojekte' 
   bedingung="titel in ('42970','54770')" einnahmen=false/>
   <@row sort=138 titel='42970' zweck='Personalausgaben' einnahmen=false/>
   <@row sort=139 titel='54770' zweck='Schliche Ausgaben' einnahmen=false/>
   
     <@dr sort=140 zweck='TG Hochschulpakt 2020' 
   bedingung="titel in ('42972','54772','81272')" einnahmen=false/>
   <@row sort=141 titel='42972' zweck='Personalausgaben' einnahmen=false/>
<@row sort=142 titel='54772' zweck='Schliche Ausgaben' einnahmen=false/>
<@row sort=143 titel='81272' zweck='Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden' einnahmen=false/>
 
<@dr sort=144 zweck='TG 73 Manahmen aus Mitteln des EU-Regional-fonds (EFRE)- Frderperiode 2007-2013' 
   bedingung="titel in ('42974','54774','81274')" einnahmen=false/>
<@row sort=145 titel='42974' zweck='Personalausgaben' einnahmen=false/>
<@row sort=146 titel='54774' zweck='Schliche Ausgaben' einnahmen=false/>
<@row sort=147 titel='81274' zweck='Erwerb von Gerten, Ausstattungs- und Ausrstungsgegenstnden ' einnahmen=false/>
  insert into tmp_sum 
  select sum(ist),sum(soll),sum(plan1),sum(plan2) from tmp_erg 
  where sort>=100 --nur ausgaben 
  and titel is not null; --nicht DR-Summen noch mal reinrechnen
 
 insert into tmp_erg (sort,zweck,ist,soll,plan1,plan2)
 select 148,'Ausgaben gesamt:',ist,soll,plan1,plan2 from  tmp_sum;

drop table tmp_sum;


--update tmp_erg set ist=ist/1000,soll1=soll1/1000,soll2=soll2/1000,soll3=soll3/1000;
select titel,zweck,round(ist,0)::integer,round(soll,0)::integer,round(plan1,0)::integer,round(plan2,0)::integer from tmp_erg order by sort;

