--freemarker template


 
create temp table tmp_erg(sort smallint,
name varchar(255),
ist decimal(14,2),
soll1 decimal(14,2),
soll2 decimal(14,2),
soll3 decimal(14,2)
)<@informixnolog/>
;
insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
values
(1, '1. Personalausgaben',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='X' and jahr=<<Haushaltsjahr>> and titel like '4%' and dr='60'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and titel like '4%' and dr='60'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+2 and titel like '4%' and dr='60'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+3 and titel like '4%' and dr='60')
);

insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
values
(2, '2. Schliche Verwaltungsausgaben',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='X' and jahr=<<Haushaltsjahr>> and titel like '5%'  and dr='60'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and titel like '5%' and dr='60'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+2 and titel like '5%' and dr='60'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+3 and titel like '5%' and dr='60')
);


insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
values
(3, '3. Zuweisungen und Zuschsse (ohne Investitionen)',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='X' and jahr=<<Haushaltsjahr>> and titel like '6%'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and titel like '6%'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+2 and titel like '6%'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+3 and titel like '6%')
);

insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
values
(4, '4. Ausgaben fr Investitionen',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='X' and jahr=<<Haushaltsjahr>> and titel like '8%' and dr='60'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and titel like '8%' and dr='60'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+2 and titel like '8%' and dr='60'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+3 and titel like '8%' and dr='60')
);

insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
values
(5, '5. Zusammen:',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='X' and jahr=<<Haushaltsjahr>> and
  ( (substring(titel from 1 for 1) in ('4','5','8') and dr='60') or titel like '6%')),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and ( (substring(titel from 1 for 1) in ('4','5','8') and dr='60') or titel like '6%')),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+2 and ( (substring(titel from 1 for 1) in ('4','5','8') and dr='60') or titel like '6%')),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+3 and ( (substring(titel from 1 for 1) in ('4','5','8') and dr='60') or titel like '6%'))
);

--Vor 2012: HG 1; ab 2012: Titel 119 49, 129 01. (Beim letzteren Einnahmetitel mssen die Ausgaben der Titelgruppe (TG) 60 bercksichtigt werden.)
<#macro eigeneEinnahmen jahr>
<#if jahr&lt;2012>
 titel like '1%'
 <#else>
 (titel='11949' or (titel='12901' and dr='60'))
  </#if>
</#macro>
insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
values
(6, '6. abzglich eigene Einnahmen:',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='Y' and jahr=<<Haushaltsjahr>> and <@eigeneEinnahmen jahr=<<Haushaltsjahr>>/> ),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and <@eigeneEinnahmen jahr=<<Haushaltsjahr>>+1/> ),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+2 and <@eigeneEinnahmen jahr=<<Haushaltsjahr>>+2/>) ,
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+3 and <@eigeneEinnahmen jahr=<<Haushaltsjahr>>+3/> )
);

<@selectintotmp source="tmp_erg" target="tmp_sum" select="sum(ist) as ist,sum(soll1) as soll1, sum(soll2) as soll2, sum(soll3) as soll3">
where sort in (5)
</@selectintotmp>;
insert into tmp_sum select ist*-1,soll1*-1,soll2*-1,soll3*-1 from tmp_erg where sort=6;
insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
select 7, '7. Mithin Zuwendungsbedarf ',sum(ist),sum(soll1),sum(soll2),sum(soll3) from tmp_sum;
drop table tmp_sum;

insert into tmp_erg (sort,name)
values 
(8,'Der Zuwendungsbedarf soll gedeckt werden durch:');

insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
values
(9, '8. Zuweisungen des Freistaates',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='Y' and jahr=<<Haushaltsjahr>> and substring(titel from 1 for 1) in ('2','3')),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and substring(titel from 1 for 1) in ('2','3')),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+2 and substring(titel from 1 for 1) in ('2','3')),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+3 and substring(titel from 1 for 1) in ('2','3'))
);

insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
values
(10, '9. Zuwendungen andere ffentlicher Zuwendungstrger',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='X' and jahr=<<Haushaltsjahr>> and titel like 'xxx%'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and titel like 'xxx%'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+2 and titel like 'xxx%'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+3 and titel like 'xxx%')
);

insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
values
(11, '10. Zuwendungen Dritter',
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='X' and jahr=<<Haushaltsjahr>> and titel like 'xxx%'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+1 and titel like 'xxx%'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+2 and titel like 'xxx%'),
(select sum(betrag) from kenn_konto_aggr where hs_nr=<<Hochschule>> and betragsart='W' and jahr=<<Haushaltsjahr>>+3 and titel like 'xxx%')
);

<@selectintotmp source="tmp_erg" target="tmp_sum" select="sum(ist) as ist,sum(soll1) as soll1, sum(soll2) as soll2, sum(soll3) as soll3">
where sort in (9,10,11)
</@selectintotmp>;
insert into tmp_erg (sort,name,ist,soll1,soll2,soll3)
select 12,'11. Zusammen',ist,soll1,soll2,soll3 from tmp_sum;
drop table tmp_sum;

update tmp_erg set ist=ist/1000,soll1=soll1/1000,soll2=soll2/1000,soll3=soll3/1000;
select name,round(ist,0)::integer,round(soll1,0)::integer,round(soll2,0)::integer,round(soll3,0)::integer from tmp_erg order by sort;

