#!/bin/bash

#Arbeitsverzeichnis fuer crontab
PFAD=$2
if [ "$PFAD" != "" ]
then

cd $PFAD

fi
#Umgebung einlesen:
if [ "$KENN_PFAD" = "" ]
then
echo "ACHTUNG: Die Umgebungsvariable KENN_PFAD ist nicht gesetzt. Bitte prfen Sie $SUPERX_DIR/db/bin/SQL_ENV"

exit 1

fi
if [ "$KENN_ERRORMAIL" != "" ]
then
ERRORMAIL=$KENN_ERRORMAIL
export ERRORMAIL
fi
if [ "$KENN_LOGMAIL" != "" ]
then
LOGMAIL=$KENN_LOGMAIL
export LOGMAIL
fi
if [ "$KENN_BACKUP" != "" ]
then
MODULE_BACKUP=$KENN_BACKUP
export MODULE_BACKUP
fi

#hier geht es los
#runAndCheck.x path command (EXIT_ON_ERROR|CONT_ON_ERROR) (SEND_ERRORMAIL|NO_ERRORMAIL) (SEND_LOGMAIL|NO_LOGMAIL) [description] "
echo "kenn-Update startet" >$KENN_ERRORDAT
#Tagesdatum fr Systeminfo
date +'%d.%m.%Y' > $KENN_LOAD_PFAD/superx.datum

runAndCheck.x $KENN_PFAD "module_etl.x kenn $KENN_PFAD $KENN_LOAD_PFAD" EXIT_ON_ERROR SEND_ERRORMAIL SEND_LOGMAIL "KENN update$MANDANTID"
cat $KENN_PFAD/L_KENN_update$MANDANTID.log >>$KENN_ERRORDAT

DOQUERY "select 't' || apnr from konstanten where beschreibung='KENN_UPDATE_PURGE';" false ^ _tmp.unl >>$KENN_ERRORDAT
fgrep -s "t1" _tmp.unl >>$KENN_ERRORDAT
FLAG1=$?


if [ $FLAG1 -eq 0 ]
then
echo "Vormodule werden geleert" >>$KENN_ERRORDAT

case $DATABASE in

POSTGRES)
	ABBR=pg
;;
INFORMIX)
	ABBR=ids
;;
HSQLDB)
	ABBR=hsql
;;
esac


if [ -f "$SOS_PFAD/VERSION" ]
then
$SOS_PFAD/sos_purge_"$ABBR".sql
fi

if [ -f "$COB_PFAD/VERSION" ]
then
$COB_PFAD/cob_purge_"$ABBR".sql

fi

if [ -f "$SVA_PFAD/VERSION" ]
then
$SVA_PFAD/sva_purge_"$ABBR".sql

fi

if [ -f "$FIN_PFAD/VERSION" ]
then
$FIN_PFAD/fin_purge_"$ABBR".sql

fi

else
echo "Vormodule werden nicht geleert" >>$KENN_ERRORDAT
fi


fgrep -s "not found" $KENN_ERRORDAT
FLAG1=$?
fgrep -i -s "error" $KENN_ERRORDAT
FLAG2=$?
fgrep -i -s "nicht gefunden" $KENN_ERRORDAT
FLAG3=$?
if [ $FLAG1 -eq 0 -o $FLAG2 -eq 0 -o $FLAG3 -eq 0 ]
then
	echo "Fehler beim KENN-Update "
	echo "---------------------------------------"
	echo "Fehlerprotokoll in $KENN_ERRORDAT"
	echo "---------------------------------------"
	cp $KENN_LOAD_PFAD/superx.datum.alt $KENN_LOAD_PFAD/superx.datum
else
	echo "KENN-Update erfolgreich"
fi

echo "---------------------------Beginn Prfroutine-----------------------------------" >>$KENN_ERRORDAT
#cat $KENN_PFAD/L_kenn_Test$MANDANTID.log >>$KENN_ERRORDAT
pruefmail.x $KENN_PFAD/L_kenn_Test$MANDANTID.log $ERRORMAIL 

