-- XML-generiertes SQL-Script fr psql--


select now(), 'Creating tables';



select now(), 'Erzeuge Tabelle kenn_sos_stg';

create table kenn_sos_stg(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_rueck_beur_ein SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
regel SMALLINT , 
hzbart SMALLINT , 
kz_rueck_beur_ein SMALLINT , 
fach_sem_zahl SMALLINT , 
hssem SMALLINT , 
kz_fach CHAR(1) , 
datum date , 
summe INTEGER , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
stufrm CHAR(10) , 
hrst CHAR(10) 
) 
;



comment on table kenn_sos_stg is 'Hilfstabelle Studierendenstatistik (Haupthrer ohne beurlaubte und exmatrik., stichtagsbezogen)';

comment on column kenn_sos_stg.hs_nr is 'Hochschulnummer';

comment on column kenn_sos_stg.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_sos_stg.fach_nr is 'Fach-Nummer';

comment on column kenn_sos_stg.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_sos_stg.ca12_staat is 'Nationalitt';

comment on column kenn_sos_stg.sem_rueck_beur_ein is 'Semester';

comment on column kenn_sos_stg.stg is 'Fach (amtlich)';

comment on column kenn_sos_stg.abschluss is 'Abschluss (amtlich)';

comment on column kenn_sos_stg.regel is 'in der RSZ (0=nein, 1=ja,-1=unbekannt)';

comment on column kenn_sos_stg.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_sos_stg.kz_rueck_beur_ein is 'Einschreib- oder Rckmeldestatus';

comment on column kenn_sos_stg.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_sos_stg.hssem is 'Anzahl Hochschulsemester';

comment on column kenn_sos_stg.kz_fach is 'Fachkennzeichen';

comment on column kenn_sos_stg.datum is 'Datum der Erzeugung';

comment on column kenn_sos_stg.summe is 'Summe';

comment on column kenn_sos_stg.extkost is 'Externe Kostenstelle';

comment on column kenn_sos_stg.extkotr is 'Externer Produktschlssel';

comment on column kenn_sos_stg.stufrm is 'Studienform';

comment on column kenn_sos_stg.hrst is 'Hrerstatus';


select now(), 'Erzeuge Index ixkenn_sos_stg1';

create  index ixkenn_sos_stg1 on kenn_sos_stg (hs_nr );


select now(), 'Erzeuge Index ixkenn_sos_stg2';

create  index ixkenn_sos_stg2 on kenn_sos_stg (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_sos_stg3';

create  index ixkenn_sos_stg3 on kenn_sos_stg (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_sos_stg4';

create  index ixkenn_sos_stg4 on kenn_sos_stg (sem_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_sos_stg5';

create  index ixkenn_sos_stg5 on kenn_sos_stg (abschluss );


select now(), 'Erzeuge Index ixkenn_sos_stg6';

create  index ixkenn_sos_stg6 on kenn_sos_stg (hzbart );


select now(), 'Erzeuge Index ixkenn_sos_stg7';

create  index ixkenn_sos_stg7 on kenn_sos_stg (kz_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_sos_stg8';

create  index ixkenn_sos_stg8 on kenn_sos_stg (kz_fach );


select now(), 'Tabelle kenn_sos_stg erzeugt';



select now(), 'Erzeuge Tabelle kenn_sos_lab';

create table kenn_sos_lab(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_der_pruefung SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
fach_sem_zahl SMALLINT , 
hzbart CHAR(2) , 
kz_fach CHAR(1) , 
regel SMALLINT , 
datum date , 
summe INTEGER , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
stufrm CHAR(10) 
) 
;



comment on table kenn_sos_lab is 'Hilfstabelle Prfungen (Hauptprfungen, bestanden, stichtagsbezogen)';

comment on column kenn_sos_lab.hs_nr is 'Hochschulnummer';

comment on column kenn_sos_lab.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_sos_lab.fach_nr is 'Fach-Nummer';

comment on column kenn_sos_lab.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_sos_lab.ca12_staat is 'Nationalitt';

comment on column kenn_sos_lab.sem_der_pruefung is 'Semester';

comment on column kenn_sos_lab.stg is 'Fach (amtlich)';

comment on column kenn_sos_lab.abschluss is 'Abschluss (amtlich)';

comment on column kenn_sos_lab.fach_sem_zahl is 'Dauer des Studiums in Fachsem.';

comment on column kenn_sos_lab.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_sos_lab.kz_fach is 'Fachkennzeichen';

comment on column kenn_sos_lab.regel is 'in der RSZ. BaWue: 0=nein, 1=ja,-1=unbekannt. Sachsen: -1=RSZ unbek., 0=ber der RSZ (+4), 1=in der RSZ, 2=RSZ +1, 3=RSZ +2, 4=RSZ +3';

comment on column kenn_sos_lab.datum is 'Datum der Erzeugung';

comment on column kenn_sos_lab.summe is 'Summe';

comment on column kenn_sos_lab.extkost is 'Externe Kostenstelle';

comment on column kenn_sos_lab.extkotr is 'Externer Produktschlssel';

comment on column kenn_sos_lab.stufrm is 'Studienform';


select now(), 'Erzeuge Index ixkenn_sos_lab1';

create  index ixkenn_sos_lab1 on kenn_sos_lab (hs_nr );


select now(), 'Erzeuge Index ixkenn_sos_lab2';

create  index ixkenn_sos_lab2 on kenn_sos_lab (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_sos_lab3';

create  index ixkenn_sos_lab3 on kenn_sos_lab (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_sos_lab4';

create  index ixkenn_sos_lab4 on kenn_sos_lab (sem_der_pruefung );


select now(), 'Erzeuge Index ixkenn_sos_lab5';

create  index ixkenn_sos_lab5 on kenn_sos_lab (abschluss );


select now(), 'Erzeuge Index ixkenn_sos_lab6';

create  index ixkenn_sos_lab6 on kenn_sos_lab (hzbart );


select now(), 'Erzeuge Index ixkenn_sos_lab8';

create  index ixkenn_sos_lab8 on kenn_sos_lab (kz_fach );


select now(), 'Tabelle kenn_sos_lab erzeugt';



select now(), 'Erzeuge Tabelle kenn_semester';

create table kenn_semester(
	tid INTEGER , 
kurz CHAR(50) , 
druck CHAR(200) , 
akad_jahr SMALLINT , 
akad_jahr_absolv SMALLINT , 
akad_jahr_anf SMALLINT , 
sem_beginn DATE , 
sem_ende DATE 
) 
;



comment on table kenn_semester is 'Schlsseltabelle Semester';

comment on column kenn_semester.tid is 'Schlssel';

comment on column kenn_semester.akad_jahr is 'Akademisches Jahr BW';

comment on column kenn_semester.akad_jahr_absolv is 'Akademisches Jahr fr Absolventen SA';

comment on column kenn_semester.akad_jahr_anf is 'Akademisches Jahr fr Studienanfnger SA';


select now(), 'Tabelle kenn_semester erzeugt';



select now(), 'Erzeuge Tabelle kenn_stichtag';

create table kenn_stichtag(
	tid SERIAL , 
stichtag DATE , 
bezugszeit SMALLINT , 
bezugsart CHAR(1)  not null, 
stichtagsart CHAR(100) , 
berechnen CHAR(1)  default '1' , 
exportieren CHAR(1)  default '1' , 
stichtagsart_id CHAR(40) , 
	constraint c_kenn_stich_tid primary key (tid)

) 
;



comment on table kenn_stichtag is 'Schlsseltabelle Stichtage zu Datenlieferungen';

comment on column kenn_stichtag.tid is 'Schlssel';

comment on column kenn_stichtag.stichtag is 'Stichtag';

comment on column kenn_stichtag.bezugszeit is 'Bezug des Stichtags';

comment on column kenn_stichtag.bezugsart is 'Bezugsart (Semester S,Jahr J, Quartal Q, Monat M)';

comment on column kenn_stichtag.stichtagsart is 'Art des Stichtags';

comment on column kenn_stichtag.berechnen is 'Berechnen?';

comment on column kenn_stichtag.exportieren is 'Exportieren?';

comment on column kenn_stichtag.stichtagsart_id is 'Stichtagsart';


select now(), 'Tabelle kenn_stichtag erzeugt';



select now(), 'Erzeuge Tabelle kenn_staat';

create table kenn_staat(
	astat CHAR(10) , 
druck CHAR(150) , 
erdteil CHAR(10) , 
d_akt_von DATE , 
d_akt_bis DATE 
) 
;



comment on table kenn_staat is 'Nationalitten der Studierenden';

comment on column kenn_staat.d_akt_von is 'gltig von';

comment on column kenn_staat.d_akt_bis is 'gltig bis';


select now(), 'Tabelle kenn_staat erzeugt';



select now(), 'Erzeuge Tabelle kenn_geschl';

create table kenn_geschl(
	apnr integer  not null, 
druck CHAR(150) 
) 
;



comment on table kenn_geschl is 'View Geschlecht';


select now(), 'Tabelle kenn_geschl erzeugt';



select now(), 'Erzeuge Tabelle kenn_hzbart';

create table kenn_hzbart(
	astat CHAR(2) , 
druck CHAR(150) 
) 
;



comment on table kenn_hzbart is 'View Hochschulzugangsberechtigung (gruppiert)';


select now(), 'Tabelle kenn_hzbart erzeugt';



select now(), 'Erzeuge Tabelle kenn_kzfa';

create table kenn_kzfa(
	astat CHAR(10) , 
kurz CHAR(10) , 
druck CHAR(150) , 
tid SERIAL 
) 
;



comment on table kenn_kzfa is 'View Fachkennzeichen (H=Hauptfach, N=Nebenfach)';

comment on column kenn_kzfa.tid is 'Laufnummer';


select now(), 'Tabelle kenn_kzfa erzeugt';



select now(), 'Erzeuge Tabelle kenn_hochschulen';

create table kenn_hochschulen(
	name CHAR(100)  not null, 
hs_nr INTEGER  not null, 
kapitel CHAR(5) , 
art CHAR(10) , 
traegerschaft CHAR(10) , 
kurztext CHAR(100) , 
ort VARCHAR(255) , 
bland CHAR(10) , 
kuerzel CHAR(10) , 
	constraint k_hochschulen primary key (hs_nr)

) 
;



comment on table kenn_hochschulen is 'Verzeichnis der Hochschulen';

comment on column kenn_hochschulen.name is 'Hochschulname';

comment on column kenn_hochschulen.hs_nr is 'Hochschulnummer (HIS)';

comment on column kenn_hochschulen.kapitel is 'Hochschulkapitel';

comment on column kenn_hochschulen.art is 'Hochschulart';

comment on column kenn_hochschulen.traegerschaft is 'Trgerschaft';

comment on column kenn_hochschulen.kurztext is 'Hochschulname (kurz)';

comment on column kenn_hochschulen.ort is 'Hochschulort';

comment on column kenn_hochschulen.bland is 'Bundesland';

comment on column kenn_hochschulen.kuerzel is 'Bundesland';


select now(), 'Tabelle kenn_hochschulen erzeugt';



select now(), 'Erzeuge Tabelle kenn_busa_aggr';

create table kenn_busa_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
monat SMALLINT , 
fikrkey CHAR(12) , 
kokl_faktor SMALLINT , 
klr_geldgeber CHAR(10) , 
ch110_institut VARCHAR(50) , 
projnr CHAR(10) , 
datum date , 
betrag double precision , 
bvkr_art CHAR(12) , 
inst_art CHAR(20) 
) 
;



comment on table kenn_busa_aggr is 'Hilfstabelle Primrkosten, busa steht fr Buchungsstze, aber die Werte sind aggregiert';

comment on column kenn_busa_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_busa_aggr.jahr is 'Jahr der Buchung';

comment on column kenn_busa_aggr.quartal is 'Quartal der Buchung';

comment on column kenn_busa_aggr.monat is 'Monat der Buchung';

comment on column kenn_busa_aggr.fikrkey is 'Kostenart';

comment on column kenn_busa_aggr.kokl_faktor is 'Kostenklasse (1=Kosten, -1=Erls)';

comment on column kenn_busa_aggr.klr_geldgeber is 'Geldgeber nach KLR (Drittm.,Fremdkap.,HH)';

comment on column kenn_busa_aggr.ch110_institut is 'Kostenstelle (alternative Hierarchie KENN-Kostenstellen)';

comment on column kenn_busa_aggr.projnr is 'Externer Kostentrger';

comment on column kenn_busa_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_busa_aggr.betrag is 'Betrag in EUR';

comment on column kenn_busa_aggr.bvkr_art is 'Kostenart (BVKR)';

comment on column kenn_busa_aggr.inst_art is 'Externe Kostenstelle';


select now(), 'Erzeuge Index ixkenn_busa_aggr1';

create  index ixkenn_busa_aggr1 on kenn_busa_aggr (jahr, 
monat, 
fikrkey, 
ch110_institut );


select now(), 'Erzeuge Index ixkenn_busa_aggr2';

create  index ixkenn_busa_aggr2 on kenn_busa_aggr (kokl_faktor );


select now(), 'Erzeuge Index ixkenn_busa_aggr3';

create  index ixkenn_busa_aggr3 on kenn_busa_aggr (projnr );


select now(), 'Erzeuge Index ixkenn_busa_aggr4';

create  index ixkenn_busa_aggr4 on kenn_busa_aggr (quartal );


select now(), 'Erzeuge Index ixkenn_busa_aggr5';

create  index ixkenn_busa_aggr5 on kenn_busa_aggr (klr_geldgeber );


select now(), 'Erzeuge Index kenn_busa_aggr6';

create  index kenn_busa_aggr6 on kenn_busa_aggr (hs_nr );


select now(), 'Erzeuge Index kenn_busa_aggr7';

create  index kenn_busa_aggr7 on kenn_busa_aggr (bvkr_art );


select now(), 'Erzeuge Index kenn_busa_aggr8';

create  index kenn_busa_aggr8 on kenn_busa_aggr (inst_art );


select now(), 'Tabelle kenn_busa_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_vtbu_aggr';

create table kenn_vtbu_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
monat SMALLINT , 
quell_ch110_inst VARCHAR(50) , 
quell_projnr CHAR(10) , 
quell_stug CHAR(20) , 
ziel_projnr CHAR(10) , 
ziel_stug CHAR(20) , 
ziel_fikrkey CHAR(12) , 
kokl CHAR(1) , 
klr_geldgeber CHAR(3) , 
vari CHAR(1) , 
datum date , 
betrag double precision , 
ziel_ch110_inst CHAR(10) 
) 
;



comment on table kenn_vtbu_aggr is 'Hilfstabelle Verteilbuchungen aus HISCOB';

comment on column kenn_vtbu_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_vtbu_aggr.quartal is 'Quartal der Buchung';

comment on column kenn_vtbu_aggr.quell_ch110_inst is 'Abgebende Kostenstelle';

comment on column kenn_vtbu_aggr.quell_projnr is 'Projektnr. (ext. Kostentrger)';

comment on column kenn_vtbu_aggr.quell_stug is 'Studiengang';

comment on column kenn_vtbu_aggr.ziel_projnr is 'Projektnr. (ext. Kostentrger)';

comment on column kenn_vtbu_aggr.ziel_stug is 'Studiengang';

comment on column kenn_vtbu_aggr.ziel_fikrkey is 'Ziel-Kostenartenblock';

comment on column kenn_vtbu_aggr.kokl is 'Kontenklasse';

comment on column kenn_vtbu_aggr.klr_geldgeber is 'Geldgeber';

comment on column kenn_vtbu_aggr.vari is 'Verteilschritte';

comment on column kenn_vtbu_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_vtbu_aggr.ziel_ch110_inst is 'Ziel-Kostenstelle';


select now(), 'Erzeuge Index ixkenn_vtbu_aggr1';

create  index ixkenn_vtbu_aggr1 on kenn_vtbu_aggr (jahr, 
monat, 
quell_projnr, 
ziel_projnr, 
ziel_fikrkey );


select now(), 'Erzeuge Index kenn_vtbu_aggr3';

create  index kenn_vtbu_aggr3 on kenn_vtbu_aggr (quell_stug );


select now(), 'Erzeuge Index kenn_vtbu_aggr4';

create  index kenn_vtbu_aggr4 on kenn_vtbu_aggr (ziel_stug );


select now(), 'Erzeuge Index kenn_vtbu_aggr5';

create  index kenn_vtbu_aggr5 on kenn_vtbu_aggr (klr_geldgeber );


select now(), 'Erzeuge Index kenn_vtbu_aggr6';

create  index kenn_vtbu_aggr6 on kenn_vtbu_aggr (hs_nr );


select now(), 'Erzeuge Index kenn_vtbu_aggr7';

create  index kenn_vtbu_aggr7 on kenn_vtbu_aggr (vari );


select now(), 'Erzeuge Index kenn_vtbu_aggr8';

create  index kenn_vtbu_aggr8 on kenn_vtbu_aggr (kokl );


select now(), 'Tabelle kenn_vtbu_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_flaeche';

create table kenn_flaeche(
	hs_nr INTEGER , 
ch110_institut VARCHAR(50) , 
nutzungsart CHAR(4) , 
kfanr VARCHAR(10) , 
jahr SMALLINT , 
datum date , 
flaeche double precision , 
extkotr CHAR(30) 
) 
;



comment on table kenn_flaeche is 'Hilfstabelle Flchen aus HISCOB (Tabl. cob_imp_flaeche)';

comment on column kenn_flaeche.hs_nr is 'Hochschulnummer';

comment on column kenn_flaeche.ch110_institut is 'Kostenstelle (alternative Hierarchie KENN-Kostenstellen)';

comment on column kenn_flaeche.nutzungsart is 'Raumnutzungsart';

comment on column kenn_flaeche.kfanr is 'Kostenflchenart';

comment on column kenn_flaeche.jahr is 'Jahr des Stichtags';

comment on column kenn_flaeche.datum is 'Datum der Erzeugung';

comment on column kenn_flaeche.extkotr is 'Externer Produktschlssel';


select now(), 'Erzeuge Index ixkenn_flaeche1';

create  index ixkenn_flaeche1 on kenn_flaeche (hs_nr );


select now(), 'Erzeuge Index ixkenn_flaeche2';

create  index ixkenn_flaeche2 on kenn_flaeche (ch110_institut );


select now(), 'Erzeuge Index ixkenn_flaeche3';

create  index ixkenn_flaeche3 on kenn_flaeche (nutzungsart );


select now(), 'Erzeuge Index ixkenn_flaeche4';

create  index ixkenn_flaeche4 on kenn_flaeche (kfanr );


select now(), 'Erzeuge Index ixkenn_flaeche5';

create  index ixkenn_flaeche5 on kenn_flaeche (jahr );


select now(), 'Tabelle kenn_flaeche erzeugt';



select now(), 'Erzeuge Tabelle kenn_stug';

create table kenn_stug(
	hs_nr INTEGER , 
stug_key CHAR(20) , 
stug_von DATE , 
stug_fach CHAR(10) , 
stug_abschl CHAR(10) , 
stug_dbez CHAR(51) , 
stug_rstuz SMALLINT , 
stug_cnw double precision , 
stug_bis DATE , 
key_lehreinh CHAR(10) , 
stug_plaetze SMALLINT , 
k_extkotr CHAR(10) 
) 
;



comment on column kenn_stug.hs_nr is 'Hochschulnummer';


select now(), 'Erzeuge Index kenn_hs_nr_key';

create  index kenn_hs_nr_key on kenn_stug (hs_nr );


select now(), 'Erzeuge Index kenn_uxstug_key';

create  index kenn_uxstug_key on kenn_stug (stug_key );


select now(), 'Tabelle kenn_stug erzeugt';



select now(), 'Erzeuge Tabelle kenn_su_imp_stud';

create table kenn_su_imp_stud(
	hs_nr INTEGER , 
lehreinheit CHAR(10) , 
k_extkotr CHAR(10) , 
sem INTEGER , 
stgnr VARCHAR(2) , 
fsemnr INTEGER , 
fachkey VARCHAR(4) , 
fachkeydbez VARCHAR(25) , 
abslkey VARCHAR(2) , 
abslkeydbez VARCHAR(25) , 
kzfach VARCHAR(1) , 
stufrm VARCHAR(1) , 
stufrmdbez VARCHAR(25) , 
kzfachdbez VARCHAR(25) , 
ffstgnr VARCHAR(2) , 
gruppierung VARCHAR(4) , 
ffgewicht double precision , 
stugkey CHAR(20) , 
vza double precision , 
ffges double precision , 
ffidr double precision , 
ff1_4 double precision , 
ffidrgfs double precision , 
ff1_4gfs double precision , 
ffidrgf2 double precision , 
ff1_4gf2 double precision , 
kpfges double precision , 
kpfidr double precision , 
kpf1_4 double precision , 
datum date 
) 
;



comment on table kenn_su_imp_stud is 'Studierendenstatistik fr die Kostenrechnung aus dem SuperX-COB-Modul';

comment on column kenn_su_imp_stud.hs_nr is 'Hochschulnummer';

comment on column kenn_su_imp_stud.lehreinheit is 'Lehreinheit aus cob_stug';

comment on column kenn_su_imp_stud.k_extkotr is 'externer Kostentrger';

comment on column kenn_su_imp_stud.vza is 'Vollzeitquivalent';

comment on column kenn_su_imp_stud.ffges is 'Fachflle gesamt';

comment on column kenn_su_imp_stud.ffidr is 'Fachflle in der RSZ';

comment on column kenn_su_imp_stud.ff1_4 is 'Fachflle 1.-4. Fachsemester';

comment on column kenn_su_imp_stud.ffidrgfs is 'FFA i.d.RSZ';

comment on column kenn_su_imp_stud.ff1_4gfs is 'VZ 1.-4. Fachsemester';

comment on column kenn_su_imp_stud.ffidrgf2 is 'VZ i.d. RSZ';

comment on column kenn_su_imp_stud.ff1_4gf2 is 'VZ 1.-4. Fachsemester';

comment on column kenn_su_imp_stud.kpfges is 'Kpfe gesamt';

comment on column kenn_su_imp_stud.kpfidr is 'Kpfe i.d. RSZ';

comment on column kenn_su_imp_stud.kpf1_4 is 'Kpfe 1.-4. Fachsemester';

comment on column kenn_su_imp_stud.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ix_kennstud_view_s';

create  index ix_kennstud_view_s on kenn_su_imp_stud (sem );


select now(), 'Erzeuge Index ix_kennstud_view1';

create  index ix_kennstud_view1 on kenn_su_imp_stud (hs_nr );


select now(), 'Erzeuge Index ix_kennstud_view2';

create  index ix_kennstud_view2 on kenn_su_imp_stud (k_extkotr );


select now(), 'Erzeuge Index ix_kennstud_view3';

create  index ix_kennstud_view3 on kenn_su_imp_stud (stgnr );


select now(), 'Erzeuge Index ix_kennstud_view4';

create  index ix_kennstud_view4 on kenn_su_imp_stud (stugkey );


select now(), 'Erzeuge Index ix_kennstud_view5';

create  index ix_kennstud_view5 on kenn_su_imp_stud (kzfach );


select now(), 'Tabelle kenn_su_imp_stud erzeugt';



select now(), 'Erzeuge Tabelle kenn_alt_keys';

create table kenn_alt_keys(
	hs_nr INTEGER , 
relation CHAR(10) , 
hierarchie_id integer  not null, 
key CHAR(12) , 
parent CHAR(12) , 
flags SMALLINT 
) 
;



comment on table kenn_alt_keys is 'Enthaelt die alternativen Hierarchien aus alt_inst, alt_fikr, alt_proj, die ans MWK exportiert werden. Nur fr Hochschulen, die mit dem SuperX-COB-Modul arbeiten.';

comment on column kenn_alt_keys.hs_nr is 'Hochschulnummer';


select now(), 'Erzeuge Index kenn_alt_keys_id';

create  index kenn_alt_keys_id on kenn_alt_keys (hierarchie_id );


select now(), 'Tabelle kenn_alt_keys erzeugt';



select now(), 'Erzeuge Tabelle kenn_fikr';

create table kenn_fikr(
	hs_nr INTEGER , 
key CHAR(12) , 
ueberg CHAR(12) , 
kbez CHAR(130) , 
lbez CHAR(150) , 
kokl CHAR(1) , 
habpos CHAR(1) , 
ebene SMALLINT , 
key_von DATE , 
key_bis DATE 
) 
;



comment on table kenn_fikr is 'Kostenarten (Bundesschlssel) aus dem SuperX-COB-Modul';

comment on column kenn_fikr.hs_nr is 'Hochschulnummer';


select now(), 'Erzeuge Index kenn_fikr_key';

create  index kenn_fikr_key on kenn_fikr (hs_nr, 
key, 
kokl, 
key_von, 
key_bis );


select now(), 'Erzeuge Index ixkenn_fikr_ko';

create  index ixkenn_fikr_ko on kenn_fikr (kokl );


select now(), 'Tabelle kenn_fikr erzeugt';



select now(), 'Erzeuge Tabelle kenn_inst_to_ext';

create table kenn_inst_to_ext(
	hs_nr INTEGER , 
instnr CHAR(10) , 
email CHAR(255) , 
key_ext CHAR(15) , 
dbez_ext CHAR(25) , 
gebnr CHAR(10) , 
key_extkotr CHAR(10) 
) 
;



comment on column kenn_inst_to_ext.hs_nr is 'Hochschulnummer';

comment on column kenn_inst_to_ext.instnr is 'Interne Kostenstellen-Nummer';

comment on column kenn_inst_to_ext.key_ext is 'Externe Kostenstellen-Nummer';

comment on column kenn_inst_to_ext.dbez_ext is 'Externe Kostenstelle Bezeichnung';

comment on column kenn_inst_to_ext.key_extkotr is 'ext. Kostentrger';


select now(), 'Erzeuge Index kuxinst_to_ext';

create  index kuxinst_to_ext on kenn_inst_to_ext (hs_nr, 
instnr );


select now(), 'Tabelle kenn_inst_to_ext erzeugt';



select now(), 'Erzeuge Tabelle kenn_inst';

create table kenn_inst(
	tid SERIAL  not null, 
hs_nr INTEGER , 
key_apnr VARCHAR(50) , 
parent VARCHAR(50) , 
drucktext CHAR(50) , 
name CHAR(250) , 
ebene INTEGER , 
lehre SMALLINT , 
gueltig_seit DATE , 
gueltig_bis DATE , 
orgstruktur INTEGER , 
bund_lehr_forsch CHAR(3) , 
bund_fachgebiet CHAR(4) , 
	constraint u420_349 primary key (tid)

) 
;



comment on table kenn_inst is 'Kostenstellen der Hochschulen aus dem SuperX-COB-Modul (alternative Hierarchie KENN-Kostenstellen und KENN-Lehreinheiten)';

comment on column kenn_inst.hs_nr is 'Hochschulnummer';

comment on column kenn_inst.drucktext is 'Name (Drucktext';

comment on column kenn_inst.name is 'Name (Drucktext';


select now(), 'Erzeuge Index kenn_inst_hsnr';

create  index kenn_inst_hsnr on kenn_inst (hs_nr );


select now(), 'Erzeuge Index kenn_inst_key';

create  index kenn_inst_key on kenn_inst (key_apnr, 
gueltig_seit, 
gueltig_bis );


select now(), 'Erzeuge Index kenn_inst_parent';

create  index kenn_inst_parent on kenn_inst (parent );


select now(), 'Tabelle kenn_inst erzeugt';



select now(), 'Erzeuge Tabelle kenn_extkotr';

create table kenn_extkotr(
	hs_nr INTEGER , 
key CHAR(30) , 
parent CHAR(30) , 
name CHAR(255) , 
kategorie CHAR(2) , 
fins_stugfach CHAR(3) , 
tid SERIAL , 
gueltig_von DATE , 
gueltig_bis DATE 
) 
;



comment on table kenn_extkotr is 'Verzeichnis der externen Kostentrger aus dem SuperX-COB-Modul';

comment on column kenn_extkotr.hs_nr is 'Hochschulnummer';

comment on column kenn_extkotr.key is 'Externer Kostentrgerschlssel';

comment on column kenn_extkotr.parent is 'bergeordneter Schlssel';

comment on column kenn_extkotr.name is 'Externer Kostentrgerbezeichnung';

comment on column kenn_extkotr.kategorie is 'Kostentrger-Kategorie';

comment on column kenn_extkotr.fins_stugfach is 'Finanzstatistikschlssel';

comment on column kenn_extkotr.tid is 'Laufnummer';

comment on column kenn_extkotr.gueltig_von is 'Gltig von';

comment on column kenn_extkotr.gueltig_bis is 'Gltig bis';


select now(), 'Erzeuge Index ix_kenn_extkotr';

create  index ix_kenn_extkotr on kenn_extkotr (hs_nr, 
key );


select now(), 'Tabelle kenn_extkotr erzeugt';



select now(), 'Erzeuge Tabelle kenn_sgd_aggr';

create table kenn_sgd_aggr(
	hs_nr INTEGER , 
bund_fachgebiet CHAR(10) , 
bund_dienstart SMALLINT , 
faktor decimal(3,2) , 
buadbz CHAR(10) , 
besetzung CHAR(1) , 
vzae_besetzung double precision , 
koepfe_besetzung double precision , 
buadbz_besetzung CHAR(10) , 
da_besetzung SMALLINT , 
taet_besetzung SMALLINT , 
stichtag DATE , 
datum date , 
zaehlung CHAR(2) , 
summe double precision , 
titel CHAR(10) , 
bund_bvl_stelle CHAR(10) , 
hhv SMALLINT , 
kategorie_gruppe SMALLINT , 
vzae_besetzung_beamt double precision , 
vzae_besetzung_besch double precision , 
vzae_besetzung_uw double precision , 
adbz_land CHAR(10) , 
bvl_stelle_kurz VARCHAR(255) , 
kapitel CHAR(10) 
) 
;



comment on table kenn_sgd_aggr is 'Hilfstabelle Stellengrunddaten einer Hochschule (aggregiert, nur Planstellen)';

comment on column kenn_sgd_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_sgd_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_sgd_aggr.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_sgd_aggr.faktor is 'Halbe Stelle/ganze Stelle';

comment on column kenn_sgd_aggr.buadbz is 'Bundesschlssel ADBZ';

comment on column kenn_sgd_aggr.besetzung is 'Besetzungsart';

comment on column kenn_sgd_aggr.vzae_besetzung is 'Umfang der Besetzung (VZ)';

comment on column kenn_sgd_aggr.koepfe_besetzung is 'Umfang der Besetzung (Kpfe)';

comment on column kenn_sgd_aggr.buadbz_besetzung is 'Amtsdienstbezeichung (Bund) der Besetzung';

comment on column kenn_sgd_aggr.da_besetzung is 'Dienstart (Bund) der Besetzung';

comment on column kenn_sgd_aggr.taet_besetzung is 'Ttigkeit (Bund) der Besetzung';

comment on column kenn_sgd_aggr.stichtag is 'Datum der Gltigkeit der Stelle';

comment on column kenn_sgd_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_sgd_aggr.zaehlung is 'Zhlung der Stelle';

comment on column kenn_sgd_aggr.summe is 'Summe der Stellen';

comment on column kenn_sgd_aggr.titel is 'Titel der Stelle';

comment on column kenn_sgd_aggr.bund_bvl_stelle is 'BVL-Gruppe Stelle';

comment on column kenn_sgd_aggr.hhv is 'Haushaltsvermerk';

comment on column kenn_sgd_aggr.kategorie_gruppe is 'Stellenkategorie';

comment on column kenn_sgd_aggr.vzae_besetzung_beamt is 'Umfang der Besetzung (VZ) durch Beamte';

comment on column kenn_sgd_aggr.vzae_besetzung_besch is 'Umfang der Besetzung (VZ) durch Beschftigte';

comment on column kenn_sgd_aggr.vzae_besetzung_uw is 'Umfang der Besetzung (VZ) unterwertig';

comment on column kenn_sgd_aggr.adbz_land is 'Landesschlssel ADBZ';

comment on column kenn_sgd_aggr.bvl_stelle_kurz is 'Kurztext der BVL-Gruppe';

comment on column kenn_sgd_aggr.kapitel is 'Kapitel';


select now(), 'Erzeuge Index ixkenn_sgd_aggr1';

create  index ixkenn_sgd_aggr1 on kenn_sgd_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_sgd_aggr2';

create  index ixkenn_sgd_aggr2 on kenn_sgd_aggr (bund_fachgebiet, 
bund_dienstart );


select now(), 'Erzeuge Index ixkenn_sgd_aggr3';

create  index ixkenn_sgd_aggr3 on kenn_sgd_aggr (buadbz );


select now(), 'Erzeuge Index ixkenn_sgd_aggr4';

create  index ixkenn_sgd_aggr4 on kenn_sgd_aggr (da_besetzung, 
taet_besetzung );


select now(), 'Erzeuge Index ixkenn_sgd_aggr5';

create  index ixkenn_sgd_aggr5 on kenn_sgd_aggr (stichtag );


select now(), 'Erzeuge Index ixkenn_sgd_aggr6';

create  index ixkenn_sgd_aggr6 on kenn_sgd_aggr (zaehlung );


select now(), 'Tabelle kenn_sgd_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_pbe_aggr';

create table kenn_pbe_aggr(
	hs_nr INTEGER , 
bund_fachgebiet CHAR(10) , 
bund_dienstart SMALLINT , 
faktor decimal(3,2) , 
buadbz CHAR(10) , 
buadbz_besetzung CHAR(10) , 
da_besetzung SMALLINT , 
taet_besetzung SMALLINT , 
stichtag DATE , 
datum date , 
zaehlung CHAR(2) , 
summe double precision 
) 
;



comment on table kenn_pbe_aggr is 'Hilfstabelle Stellenbesetzungen einer Hochschule (aggregiert, nur Planstellen)';

comment on column kenn_pbe_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_pbe_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_pbe_aggr.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_pbe_aggr.faktor is 'Halbe Stelle/ganze Stelle';

comment on column kenn_pbe_aggr.buadbz is 'Bundesschlssel ADBZ';

comment on column kenn_pbe_aggr.buadbz_besetzung is 'Amtsdienstbezeichung (Bund) der Besetzung';

comment on column kenn_pbe_aggr.da_besetzung is 'Dienstart (Bund) der Besetzung';

comment on column kenn_pbe_aggr.taet_besetzung is 'Ttigkeit (Bund) der Besetzung';

comment on column kenn_pbe_aggr.stichtag is 'Datum der Gltigkeit der Stelle';

comment on column kenn_pbe_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_pbe_aggr.zaehlung is 'Zhlung der Besetzung';

comment on column kenn_pbe_aggr.summe is 'Umfang der Besetzung (VZ)';


select now(), 'Erzeuge Index ixkenn_pbe_aggr1';

create  index ixkenn_pbe_aggr1 on kenn_pbe_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_pbe_aggr2';

create  index ixkenn_pbe_aggr2 on kenn_pbe_aggr (bund_fachgebiet, 
bund_dienstart );


select now(), 'Erzeuge Index ixkenn_pbe_aggr3';

create  index ixkenn_pbe_aggr3 on kenn_pbe_aggr (buadbz );


select now(), 'Erzeuge Index ixkenn_pbe_aggr4';

create  index ixkenn_pbe_aggr4 on kenn_pbe_aggr (da_besetzung, 
taet_besetzung );


select now(), 'Erzeuge Index ixkenn_pbe_aggr5';

create  index ixkenn_pbe_aggr5 on kenn_pbe_aggr (stichtag );


select now(), 'Erzeuge Index ixkenn_pbe_aggr6';

create  index ixkenn_pbe_aggr6 on kenn_pbe_aggr (zaehlung );


select now(), 'Tabelle kenn_pbe_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_pbv_aggr';

create table kenn_pbv_aggr(
	hs_nr INTEGER , 
geschlecht SMALLINT , 
bund_fachgebiet CHAR(10) , 
bund_taetigkeit SMALLINT , 
bund_dienstart SMALLINT , 
buadbz CHAR(5) , 
klr_geldgeber CHAR(4) , 
kapitel CHAR(5) , 
stichtag DATE , 
zaehlung CHAR(2) , 
datum date , 
summe double precision , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
befristet SMALLINT , 
staat INTEGER , 
ernennung_alter INTEGER , 
qualifizierung_art SMALLINT , 
finanzierung_art CHAR(10) 
) 
;



comment on table kenn_pbv_aggr is 'Hilfstabelle Personal-Beschftigungsverhltnisse einer Hochschule';

comment on column kenn_pbv_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_pbv_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_pbv_aggr.bund_taetigkeit is 'Art der Ttigkeit';

comment on column kenn_pbv_aggr.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_pbv_aggr.buadbz is 'Amts-Dienstbez. (Bundesschlssel)';

comment on column kenn_pbv_aggr.klr_geldgeber is 'Geldgeber aus Finanzierung';

comment on column kenn_pbv_aggr.kapitel is 'Kapitel aus Finanzierung';

comment on column kenn_pbv_aggr.stichtag is 'Datum der Gltigkeit des Besch.-Verh.';

comment on column kenn_pbv_aggr.zaehlung is 'Kpfe=k / VZAE zum Stichtag=v / (nur Sachsen:) VZAE im Jahr=j / Kpfe im Jahr=p';

comment on column kenn_pbv_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_pbv_aggr.summe is 'Summe';

comment on column kenn_pbv_aggr.extkost is 'Externe Kostenstelle';

comment on column kenn_pbv_aggr.extkotr is 'Externer Produktschlssel';

comment on column kenn_pbv_aggr.befristet is 'Befristet';

comment on column kenn_pbv_aggr.staat is 'Nationalitt';

comment on column kenn_pbv_aggr.ernennung_alter is 'Alter bei Ernennung';

comment on column kenn_pbv_aggr.qualifizierung_art is 'Tenure Track oder Nachwuchsgruppenleitung';

comment on column kenn_pbv_aggr.finanzierung_art is 'finanzierungsart';


select now(), 'Erzeuge Index ixkenn_pbv_aggr1';

create  index ixkenn_pbv_aggr1 on kenn_pbv_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_pbv_aggr2';

create  index ixkenn_pbv_aggr2 on kenn_pbv_aggr (bund_fachgebiet, 
bund_taetigkeit );


select now(), 'Erzeuge Index ixkenn_pbv_aggr3';

create  index ixkenn_pbv_aggr3 on kenn_pbv_aggr (geschlecht );


select now(), 'Erzeuge Index ixkenn_pbv_aggr4';

create  index ixkenn_pbv_aggr4 on kenn_pbv_aggr (buadbz );


select now(), 'Erzeuge Index ixkenn_pbv_aggr5';

create  index ixkenn_pbv_aggr5 on kenn_pbv_aggr (klr_geldgeber );


select now(), 'Erzeuge Index ixkenn_pbv_aggr6';

create  index ixkenn_pbv_aggr6 on kenn_pbv_aggr (kapitel );


select now(), 'Erzeuge Index ixkenn_pbv_aggr7';

create  index ixkenn_pbv_aggr7 on kenn_pbv_aggr (stichtag );


select now(), 'Erzeuge Index ixkenn_pbv_aggr8';

create  index ixkenn_pbv_aggr8 on kenn_pbv_aggr (zaehlung );


select now(), 'Tabelle kenn_pbv_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_pbv_aggr_astat';

create table kenn_pbv_aggr_astat(
	hs_nr INTEGER , 
jahr SMALLINT , 
geschlecht SMALLINT , 
bund_fachgebiet CHAR(10) , 
bund_taetigkeit SMALLINT , 
bund_dienstart SMALLINT , 
buadbz CHAR(5) , 
bund_geldgeber CHAR(4) , 
zaehlung CHAR(2) , 
datum date , 
befristet SMALLINT , 
staat INTEGER , 
ernennung_jahr INTEGER , 
ernennung_alter INTEGER , 
qualifizierung_art SMALLINT , 
fgr CHAR(10) , 
summe double precision 
) 
;



comment on table kenn_pbv_aggr_astat is 'Hilfstabelle Personal-Beschftigungsverhltnisse auf Basis amtl. Stat.';

comment on column kenn_pbv_aggr_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_pbv_aggr_astat.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_pbv_aggr_astat.bund_taetigkeit is 'Art der Ttigkeit';

comment on column kenn_pbv_aggr_astat.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_pbv_aggr_astat.buadbz is 'Amts-Dienstbez. (Bundesschlssel)';

comment on column kenn_pbv_aggr_astat.bund_geldgeber is 'Geldgeber aus Finanzierung';

comment on column kenn_pbv_aggr_astat.zaehlung is 'Kpfe=k / VZAE zum Stichtag=v / (nur Sachsen:) VZAE im Jahr=j / Kpfe im Jahr=p';

comment on column kenn_pbv_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_pbv_aggr_astat.befristet is 'Befristet';

comment on column kenn_pbv_aggr_astat.staat is 'Nationalitt';

comment on column kenn_pbv_aggr_astat.ernennung_jahr is 'Jahr der Ernennung';

comment on column kenn_pbv_aggr_astat.ernennung_alter is 'Alter bei Ernennung';

comment on column kenn_pbv_aggr_astat.qualifizierung_art is 'Tenure Track oder Nachwuchsgruppenleitung';

comment on column kenn_pbv_aggr_astat.fgr is 'Fchergruppe';

comment on column kenn_pbv_aggr_astat.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat1';

create  index ixkenn_pbv_aggr_astat1 on kenn_pbv_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat2';

create  index ixkenn_pbv_aggr_astat2 on kenn_pbv_aggr_astat (jahr );


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat_3';

create  index ixkenn_pbv_aggr_astat_3 on kenn_pbv_aggr_astat (geschlecht );


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat_4';

create  index ixkenn_pbv_aggr_astat_4 on kenn_pbv_aggr_astat (buadbz );


select now(), 'Erzeuge Index ixkenn_pbv_aggr_astat_5';

create  index ixkenn_pbv_aggr_astat_5 on kenn_pbv_aggr_astat (zaehlung );


select now(), 'Tabelle kenn_pbv_aggr_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_k_buadbz';

create table kenn_k_buadbz(
	buadbz CHAR(10) , 
gruppe_adbz CHAR(50) , 
adbz CHAR(50) , 
druck_adbz CHAR(50) , 
gruppe CHAR(1) 
) 
;



comment on table kenn_k_buadbz is 'Amts- und Dienstbezeichnungen Bundesschlssel, vgl. http://www.destatis.de/allg/d/veroe/hoch/hochdow3.htm';

comment on column kenn_k_buadbz.buadbz is 'Schlssel ADBZ';

comment on column kenn_k_buadbz.gruppe_adbz is 'Volltext ADBZ (gruppiert)';

comment on column kenn_k_buadbz.adbz is 'Volltext ADBZ';

comment on column kenn_k_buadbz.druck_adbz is 'Drucktext ADBZ';

comment on column kenn_k_buadbz.gruppe is 'Gruppe gem. HISCOB';


select now(), 'Tabelle kenn_k_buadbz erzeugt';



select now(), 'Erzeuge Tabelle kenn_lfb_fg';

create table kenn_lfb_fg(
	tid SERIAL  not null, 
apnr CHAR(10) , 
parent CHAR(10) , 
drucktext CHAR(255) , 
name CHAR(255) , 
struktur_c CHAR(50) , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint pk_kenn_lfb_fg primary key (tid)

) 
;



comment on table kenn_lfb_fg is '
        Schlssel des Stat. Bundesamtes fr Lehr-Forschungsbereiche und Fachgebiete. Die Tabelle spannt eine Hierarchie auf:
        Alle
        Fchergruppe
        Lehr- und Forschungsbreich
        Fachgebiet
        
        Im Feld "parent" steht jeweils der Schlssel des bergeordneten Elements. Im Feld "struktur_c" sehen Sie, ob es sich bei dem Datensatz um ein Fachgebiet, einen LFB oder eine Fchergruppe handelt. Die Hochschulen verwenden nur die unterste Ebene des Baums, das Fachgebiet. Die oberen Ebenen fgen wir hinzu, um es bersichtlicher zu machen.
      ';

comment on column kenn_lfb_fg.apnr is 'Schlssel Fach/LFB/Fchergruppe';

comment on column kenn_lfb_fg.parent is 'bergeordneter Schlssel';

comment on column kenn_lfb_fg.drucktext is 'Volltext Druck';

comment on column kenn_lfb_fg.name is 'Volltext Lang';

comment on column kenn_lfb_fg.struktur_c is 'Art des Schlssels (FG,LFB,FGR)';

comment on column kenn_lfb_fg.gueltig_von is 'Gltig von';

comment on column kenn_lfb_fg.gueltig_bis is 'Gltig von';


select now(), 'Tabelle kenn_lfb_fg erzeugt';



select now(), 'Erzeuge Tabelle kenn_cifx';

create table kenn_cifx(
	tid INTEGER , 
hs INTEGER , 
key SMALLINT , 
apnr CHAR(10) , 
d_akt_von DATE , 
d_akt_bis DATE , 
kurz CHAR(10) , 
druck CHAR(100) , 
lang_1 CHAR(250) , 
lang_2 CHAR(250) , 
lang_3 CHAR(250) , 
parent CHAR(10) , 
filter CHAR(10) , 
his_system_key CHAR(10) , 
astat CHAR(10) , 
bund_apnr CHAR(10) , 
land_apnr CHAR(10) , 
sort1 INTEGER , 
sort2 INTEGER , 
sort3 INTEGER , 
sortc1 CHAR(10) , 
sortc2 CHAR(10) , 
intern_int INTEGER , 
intern_c CHAR(10) , 
sprache CHAR(3) , 
struktur_int INTEGER , 
struktur_c CHAR(50) , 
ebene INTEGER , 
gruppe CHAR(10) , 
	constraint c_kenn_cifx_tid primary key (tid)

) 
;



comment on table kenn_cifx is 'Zentrale KENN-Schlssel, bestehend aus Schlssel, astat und ggf. auch parent.';

comment on column kenn_cifx.hs is 'Hochschulschlssel (ohne Verwendung)';

comment on column kenn_cifx.key is 'hochschulischer Schlssel';

comment on column kenn_cifx.apnr is 'statistische Ausprgung';

comment on column kenn_cifx.d_akt_von is 'gltig von';

comment on column kenn_cifx.d_akt_bis is 'gltig bis';

comment on column kenn_cifx.kurz is 'Kurzbezeichnung';

comment on column kenn_cifx.druck is 'Druckbezeichnung';

comment on column kenn_cifx.lang_1 is 'Langbezeichnung1';

comment on column kenn_cifx.lang_2 is 'Langbezeichnung2';

comment on column kenn_cifx.lang_3 is 'Langbezeichnung3';

comment on column kenn_cifx.parent is 'bergeordn. Schlssel';

comment on column kenn_cifx.filter is '(ohne Verwendung)';

comment on column kenn_cifx.his_system_key is '(ohne Verwendung)';

comment on column kenn_cifx.astat is 'Statistikschlssel';

comment on column kenn_cifx.bund_apnr is 'Statistikschlssel Bund';

comment on column kenn_cifx.land_apnr is 'Statistikschlssel Land';

comment on column kenn_cifx.sort1 is 'Sortierschlssel (Ganzzahl)';

comment on column kenn_cifx.sort2 is 'Sortierschlssel (Ganzzahl) 2';

comment on column kenn_cifx.sort3 is 'Sortierschlssel (Ganzzahl) 3';

comment on column kenn_cifx.sortc1 is 'Sortierschlssel (Alphabetisch)';

comment on column kenn_cifx.sortc2 is 'Sortierschlssel (Alphabetisch) 2';

comment on column kenn_cifx.intern_int is '(ohne Verwendung)';

comment on column kenn_cifx.intern_c is '(ohne Verwendung)';

comment on column kenn_cifx.sprache is '(ohne Verwendung)';

comment on column kenn_cifx.struktur_int is '(ohne Verwendung)';

comment on column kenn_cifx.struktur_c is '(ohne Verwendung)';

comment on column kenn_cifx.ebene is 'Ebene in Hierarchie';

comment on column kenn_cifx.gruppe is 'Gruppierungsmerkmal';


select now(), 'Erzeuge Index kenn_cifx_ind';

create  unique  index kenn_cifx_ind on kenn_cifx (hs, 
apnr, 
key, 
d_akt_von, 
d_akt_bis );


select now(), 'Erzeuge Index kenn_cifx_ind2';

create  index kenn_cifx_ind2 on kenn_cifx (key );


select now(), 'Erzeuge Index kenn_cifx_ind3';

create  index kenn_cifx_ind3 on kenn_cifx (apnr );


select now(), 'Tabelle kenn_cifx erzeugt';



select now(), 'Erzeuge Tabelle kenn_status';

create table kenn_status(
	tid INTEGER  not null, 
apnr CHAR(200) , 
eintrag CHAR(200) 
) 
;



comment on table kenn_status is 'SQL-Codes fr die flexible Filterung von Einschreib- und Rckmeldekennzeichen';


select now(), 'Tabelle kenn_status erzeugt';



select now(), 'Erzeuge Tabelle kenn_pruefrout';

create table kenn_pruefrout(
	tid SERIAL , 
datum DATE , 
gueltig_von DATE , 
gueltig_bis DATE , 
tabelle_quelle CHAR(18) , 
tabelle_kenn CHAR(18) , 
problem CHAR(255) , 
aktion CHAR(255) , 
	constraint c_kenn_pruef_tid primary key (tid)

) 
;



comment on table kenn_pruefrout is 'Log-Tabelle fr Prfroutinen';


select now(), 'Tabelle kenn_pruefrout erzeugt';



select now(), 'Erzeuge Tabelle kenn_sb_astfr_lfb';

create table kenn_sb_astfr_lfb(
	tid SERIAL  not null, 
astfr CHAR(10) , 
astfr_text CHAR(255) , 
sb_nr CHAR(10) , 
sb_text CHAR(255) , 
lfb_nr CHAR(10) , 
lfb_text CHAR(255) , 
	constraint c_kenn_sb_fr_lfb primary key (tid)

) 
;



comment on table kenn_sb_astfr_lfb is 'Gegenberstellung /Zusammenfhrung der amtlichen Schlssel zum Forschungs- und Lehrbereich (LuF), Studienbereich (StB) und zur Fachrichtung (FR) der Gasthrerstatistik';

comment on column kenn_sb_astfr_lfb.astfr is 'Schlssel Fachrichtung Gasthrerstat.';

comment on column kenn_sb_astfr_lfb.astfr_text is 'Volltext Fachrichtung Gasthrerstat.';

comment on column kenn_sb_astfr_lfb.sb_nr is 'Schlssel Studienbereich';

comment on column kenn_sb_astfr_lfb.sb_text is 'Volltext Studienbereich';

comment on column kenn_sb_astfr_lfb.lfb_nr is 'Schlssel Lehr- und Forschungsbereich';

comment on column kenn_sb_astfr_lfb.lfb_text is 'Volltext Lehr- und Forschungsbereich';


select now(), 'Tabelle kenn_sb_astfr_lfb erzeugt';



select now(), 'Erzeuge Tabelle kenn_sichten';

create table kenn_sichten(
	tid SERIAL  not null, 
dimension CHAR(40)  not null, 
dimension_lang CHAR(255) , 
stichtag DATE , 
sicht_id INTEGER , 
sichtart CHAR(40) , 
sicht_name_intern CHAR(200) , 
stichtag_id INTEGER , 
	constraint c_kenn_sichten primary key (tid)

) 
;



comment on table kenn_sichten is 'Zuordnung von Default-Hierarchien zu Berichtsdimensionen,z.B. BVKR';

comment on column kenn_sichten.dimension is 'Kurzname der Dimension';

comment on column kenn_sichten.dimension_lang is 'Beschreibungstext Dimension';

comment on column kenn_sichten.stichtag is 'Stichtag alt (Datum)';

comment on column kenn_sichten.sicht_id is 'TID der Sicht (obsolet)';

comment on column kenn_sichten.sichtart is 'Art der Sicht';

comment on column kenn_sichten.sicht_name_intern is 'ID der Sicht';

comment on column kenn_sichten.stichtag_id is 'Stichtag';


select now(), 'Tabelle kenn_sichten erzeugt';



select now(), 'Erzeuge Tabelle kenn_zahl_wert';

create table kenn_zahl_wert(
	tid SERIAL  not null, 
hs_nr INTEGER , 
kenn_zahl CHAR(40)  not null, 
jahr SMALLINT , 
sem SMALLINT , 
ch110_institut VARCHAR(50) , 
stugkey CHAR(20) , 
bund_fachgebiet CHAR(10) , 
titel CHAR(10) , 
wert double precision , 
wert_str varchar(255) , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
generic_dim1 VARCHAR(255) , 
generic_dim2 VARCHAR(255) , 
	constraint c_kenn_zahl_wert primary key (tid)

) 
;



comment on table kenn_zahl_wert is 'Kennzahlen aus manueller Schnittstelle';

comment on column kenn_zahl_wert.hs_nr is 'Hochschulnummer';

comment on column kenn_zahl_wert.kenn_zahl is 'Bestandsart';

comment on column kenn_zahl_wert.jahr is 'Bezugsjahr';

comment on column kenn_zahl_wert.sem is 'Bezugssemester';

comment on column kenn_zahl_wert.ch110_institut is 'Kostenstelle/Institut';

comment on column kenn_zahl_wert.stugkey is 'Studiengangschlssel KLR';

comment on column kenn_zahl_wert.bund_fachgebiet is 'Fachgebiet/Fchergruppe';

comment on column kenn_zahl_wert.titel is 'Titel/Titelgruppe';

comment on column kenn_zahl_wert.wert is 'Wert der Kennzahl';

comment on column kenn_zahl_wert.wert_str is 'Wert der Kennzahl (fr Texteingaben)';

comment on column kenn_zahl_wert.geschlecht is 'Geschlecht';

comment on column kenn_zahl_wert.ca12_staat is 'Nationalitt';

comment on column kenn_zahl_wert.generic_dim1 is 'Kategorie';

comment on column kenn_zahl_wert.generic_dim2 is 'Kategorie 2';


select now(), 'Erzeuge Index ixkennzw_aggr1';

create  index ixkennzw_aggr1 on kenn_zahl_wert (hs_nr );


select now(), 'Erzeuge Index ixkenn_zahl_wert';

create  index ixkenn_zahl_wert on kenn_zahl_wert (kenn_zahl, 
jahr, 
sem, 
stugkey, 
ch110_institut );


select now(), 'Tabelle kenn_zahl_wert erzeugt';



select now(), 'Erzeuge Tabelle kenn_konto_aggr';

create table kenn_konto_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
monat SMALLINT , 
kapitel CHAR(5) , 
dr CHAR(5) , 
titel CHAR(10) , 
fikrkey CHAR(12) , 
klr_geldgeber CHAR(10) , 
betragsart CHAR(1) , 
bund_fachgebiet CHAR(10) , 
datum date , 
betrag double precision , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
kfmkam SMALLINT 
) 
;



comment on table kenn_konto_aggr is 'Aggregierte Haushalts-Kontendaten aus FIN';

comment on column kenn_konto_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_konto_aggr.jahr is 'Jahr der Buchung';

comment on column kenn_konto_aggr.quartal is 'Quartal der Buchung';

comment on column kenn_konto_aggr.monat is 'Monat der Buchung';

comment on column kenn_konto_aggr.kapitel is 'Kapitel';

comment on column kenn_konto_aggr.dr is 'Titelgruppe (nur gefllt wenn Konstante KENN_KAMERAL_ERWEITERT=1)';

comment on column kenn_konto_aggr.titel is 'Titel';

comment on column kenn_konto_aggr.fikrkey is 'Kostenart gem.BVKR';

comment on column kenn_konto_aggr.klr_geldgeber is 'Geldgeber nach KLR (Drittm.,Fremdkap.,HH)';

comment on column kenn_konto_aggr.betragsart is 'Art des Betrages';

comment on column kenn_konto_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_konto_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_konto_aggr.betrag is 'Betrag in EUR';

comment on column kenn_konto_aggr.extkost is 'Externe Kostenstelle';

comment on column kenn_konto_aggr.extkotr is 'Externer Produktschlssel';

comment on column kenn_konto_aggr.kfmkam is 'Kaufm./Kameral berechnet';


select now(), 'Erzeuge Index ixkenn_konto_aggr1';

create  index ixkenn_konto_aggr1 on kenn_konto_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_konto_aggr2';

create  index ixkenn_konto_aggr2 on kenn_konto_aggr (jahr, 
quartal, 
monat );


select now(), 'Erzeuge Index ixkenn_konto_aggr3';

create  index ixkenn_konto_aggr3 on kenn_konto_aggr (kapitel, 
titel );


select now(), 'Erzeuge Index ixkenn_konto_aggr4';

create  index ixkenn_konto_aggr4 on kenn_konto_aggr (fikrkey );


select now(), 'Erzeuge Index ixkenn_konto_aggr5';

create  index ixkenn_konto_aggr5 on kenn_konto_aggr (klr_geldgeber );


select now(), 'Erzeuge Index ixkenn_konto_aggr6';

create  index ixkenn_konto_aggr6 on kenn_konto_aggr (betragsart );


select now(), 'Tabelle kenn_konto_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_drittm_aggr';

create table kenn_drittm_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
betragsart CHAR(1) , 
kfmkam SMALLINT , 
syf CHAR(10) , 
fgr CHAR(10) , 
datum date , 
betrag double precision 
) 
;



comment on table kenn_drittm_aggr is 'Aggregierte Drittmittel der Hs-Finanzstat.';

comment on column kenn_drittm_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_drittm_aggr.jahr is 'Jahr der Buchung';

comment on column kenn_drittm_aggr.betragsart is 'Art des Betrages';

comment on column kenn_drittm_aggr.kfmkam is 'Kaufm./Kameral berechnet';

comment on column kenn_drittm_aggr.syf is 'Syf-Code';

comment on column kenn_drittm_aggr.fgr is 'Fchergruppe';

comment on column kenn_drittm_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_drittm_aggr.betrag is 'Betrag in EUR';


select now(), 'Erzeuge Index ixkenn_drittm_aggr1';

create  index ixkenn_drittm_aggr1 on kenn_drittm_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_drittm_aggr2';

create  index ixkenn_drittm_aggr2 on kenn_drittm_aggr (jahr );


select now(), 'Erzeuge Index ixkenn_drittm_aggr3';

create  index ixkenn_drittm_aggr3 on kenn_drittm_aggr (fgr );


select now(), 'Erzeuge Index ixkenn_drittm_aggr4';

create  index ixkenn_drittm_aggr4 on kenn_drittm_aggr (betragsart, 
kfmkam );


select now(), 'Tabelle kenn_drittm_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_hsfinanz_stat';

create table kenn_hsfinanz_stat(
	hs_nr INTEGER , 
jahr SMALLINT , 
betragsart CHAR(1) , 
kfmkam SMALLINT , 
lfb CHAR(10) , 
syf CHAR(10) , 
betrag double precision 
) 
;



comment on table kenn_hsfinanz_stat is 'Importtabelle der Hs-Finanzstat.';

comment on column kenn_hsfinanz_stat.hs_nr is 'Hochschulnummer';

comment on column kenn_hsfinanz_stat.jahr is 'Jahr der Buchung';

comment on column kenn_hsfinanz_stat.betragsart is 'Art des Betrages';

comment on column kenn_hsfinanz_stat.kfmkam is 'Kaufm./Kameral berechnet';

comment on column kenn_hsfinanz_stat.lfb is 'Lehr- und Forschungsbereich';

comment on column kenn_hsfinanz_stat.syf is 'Syf-Code';

comment on column kenn_hsfinanz_stat.betrag is 'Betrag in EUR';


select now(), 'Tabelle kenn_hsfinanz_stat erzeugt';



select now(), 'Erzeuge Tabelle kenn_dr';

create table kenn_dr(
	hs_nr INTEGER , 
jahr SMALLINT , 
kapitel CHAR(5) , 
dr CHAR(5) , 
dritt integer , 
bezeichnung CHAR(150) , 
check1 CHAR(1) , 
ktobez VARCHAR(255) 
) 
;



comment on table kenn_dr is 'Deckungsring-Bezeichnungen der Hochschule (nur gefllt wenn Konstante KENN_KAMERAL_ERWEITERT=1)';

comment on column kenn_dr.hs_nr is 'Hochschulnummer';

comment on column kenn_dr.jahr is 'Haushaltsjahr';

comment on column kenn_dr.kapitel is 'Kapitel';

comment on column kenn_dr.dr is 'Titelgruppe/Deckungsring';

comment on column kenn_dr.dritt is 'Drittmittelkonto';

comment on column kenn_dr.bezeichnung is 'Bezeichnung';

comment on column kenn_dr.ktobez is 'Kontenbezeichnung';


select now(), 'Erzeuge Index ix_kenn_drjahr';

create  index ix_kenn_drjahr on kenn_dr (jahr );


select now(), 'Tabelle kenn_dr erzeugt';



select now(), 'Erzeuge Tabelle kenn_titel';

create table kenn_titel(
	hs_nr INTEGER , 
jahr smallint , 
kapitel CHAR(5) , 
dr CHAR(5) , 
dr2 CHAR(5) , 
titel CHAR(10) , 
dritt integer , 
ktobez VARCHAR(255) 
) 
;



comment on table kenn_titel is 'Titel-Bezeichnungen der Hochschule (nur gefllt wenn Konstante KENN_KAMERAL_ERWEITERT=1)';

comment on column kenn_titel.hs_nr is 'Hochschulnummer';

comment on column kenn_titel.jahr is 'Jahr';

comment on column kenn_titel.kapitel is 'Kapitel';

comment on column kenn_titel.dr is 'Deckungsring';

comment on column kenn_titel.titel is 'Titel';

comment on column kenn_titel.dritt is 'Drittmittel';

comment on column kenn_titel.ktobez is 'Kontenbezeichnung';


select now(), 'Erzeuge Index ix_kenn_titjahr';

create  index ix_kenn_titjahr on kenn_titel (jahr );


select now(), 'Tabelle kenn_titel erzeugt';



select now(), 'Erzeuge Tabelle kenn_katalog';

create table kenn_katalog(
	tid SERIAL  not null, 
id CHAR(100)  not null, 
name CHAR(255) , 
beschreibung TEXT , 
quelltabelle CHAR(255) , 
quellfeld CHAR(255) , 
bedingung TEXT , 
stichtagsart CHAR(100) , 
bezugsart CHAR(1) , 
zeitfeld CHAR(40) , 
einheit VARCHAR(255) , 
bezugszeit_wert SMALLINT , 
bezugszeit_art CHAR(1) , 
bezugszeit_diff VARCHAR(255)  default '0' , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint c_kenn_katalog primary key (tid)

) 
;



comment on table kenn_katalog is 'Formeln fr Grunddaten und Kennzahlen';

comment on column kenn_katalog.tid is 'Tupelidentifier';

comment on column kenn_katalog.id is 'ID der Kennzahl';

comment on column kenn_katalog.name is 'Name der Kennzahl';

comment on column kenn_katalog.beschreibung is 'Beschreibung der Kennzahl';

comment on column kenn_katalog.quelltabelle is 'Datenquelle';

comment on column kenn_katalog.quellfeld is 'Feld (SQL-Ausdruck)';

comment on column kenn_katalog.bedingung is 'Where-Bedingung (SQL-Ausdruck)';

comment on column kenn_katalog.stichtagsart is 'Art des Stichtags';

comment on column kenn_katalog.bezugsart is 'Art des Zeitbezugs';

comment on column kenn_katalog.zeitfeld is 'Name des Zeitfeldes';

comment on column kenn_katalog.einheit is 'Einheit des Ergebnisses der Kennahl';

comment on column kenn_katalog.bezugszeit_wert is 'Bezugszeit Wert';

comment on column kenn_katalog.bezugszeit_art is 'Bezugszeit Art';

comment on column kenn_katalog.bezugszeit_diff is 'Bezugszeit Differenz';

comment on column kenn_katalog.gueltig_von is 'gueltig_von';

comment on column kenn_katalog.gueltig_bis is 'gueltig_bis';


select now(), 'Erzeuge Index ix_kenn_katalog';

create  unique  index ix_kenn_katalog on kenn_katalog (id );


select now(), 'Tabelle kenn_katalog erzeugt';



select now(), 'Erzeuge Tabelle kenn_katalog_rpt';

create table kenn_katalog_rpt(
	tid SERIAL  not null, 
katalog_id CHAR(100)  not null, 
report_id CHAR(40)  not null, 
beschreibung TEXT , 
ord_nr SMALLINT , 
gruppe_1 CHAR(40) , 
gruppe_2 CHAR(40) , 
ebene SMALLINT , 
parent_katalog_id CHAR(100) , 
active smallint  default 1 , 
uniquename VARCHAR(255) , 
	constraint c_kenn_katalog_r primary key (tid)

) 
;



comment on table kenn_katalog_rpt is 'Berichtslayouts fr Grunddaten und Kennzahlen';

comment on column kenn_katalog_rpt.tid is 'Tupelidentifier';

comment on column kenn_katalog_rpt.katalog_id is 'ID der Kennzahl';

comment on column kenn_katalog_rpt.report_id is 'ID des Reports';

comment on column kenn_katalog_rpt.beschreibung is 'Beschreibung der Kennzahl';

comment on column kenn_katalog_rpt.ord_nr is 'Reihenfolge der Kennzahl';

comment on column kenn_katalog_rpt.gruppe_1 is 'Gruppierungsebene 1 der Kennzahl';

comment on column kenn_katalog_rpt.gruppe_2 is 'Gruppierungsebene 2 der Kennzahl';

comment on column kenn_katalog_rpt.ebene is 'Ebene der Kennzahl';

comment on column kenn_katalog_rpt.parent_katalog_id is 'bergeordnete Kennzahl (ID)';

comment on column kenn_katalog_rpt.active is 'Aktiv';

comment on column kenn_katalog_rpt.uniquename is 'Schlssel der Kennzahl im Bericht';


select now(), 'Tabelle kenn_katalog_rpt erzeugt';



select now(), 'Erzeuge Tabelle kenn_katalog_grp';

create table kenn_katalog_grp(
	tid SERIAL  not null, 
report_id CHAR(40)  not null, 
id CHAR(40)  not null, 
uniquename VARCHAR(255) , 
name VARCHAR(255) , 
beschreibung TEXT , 
parent_id CHAR(40) , 
ord_nr SMALLINT , 
	constraint c_kenn_katalog_grp primary key (tid)

) 
;



comment on table kenn_katalog_grp is 'Gruppierungen fr Grunddaten und Kennzahlen';

comment on column kenn_katalog_grp.tid is 'Tupelidentifier';

comment on column kenn_katalog_grp.report_id is 'ID des Reports';

comment on column kenn_katalog_grp.id is 'ID der Gruppe';

comment on column kenn_katalog_grp.uniquename is 'Schlssel der Gruppe im Bericht';

comment on column kenn_katalog_grp.name is 'Name der Gruppe';

comment on column kenn_katalog_grp.beschreibung is 'Beschreibung der Kennzahl';

comment on column kenn_katalog_grp.parent_id is 'ID der Gruppe';

comment on column kenn_katalog_grp.ord_nr is 'Reihenfolge der Kennzahl';


select now(), 'Tabelle kenn_katalog_grp erzeugt';



select now(), 'Erzeuge Tabelle kenn_katalog_sub';

create table kenn_katalog_sub(
	tid SERIAL  not null, 
report_id CHAR(40)  not null, 
katalog_id CHAR(100)  not null, 
sub_caption VARCHAR(255) , 
sub_key_col VARCHAR(255) , 
sub_lookup_table VARCHAR(255) , 
sub_lookup_key VARCHAR(255) , 
sub_lookup_name VARCHAR(255) , 
sub_lookup_whereclause VARCHAR(255) , 
sub_lookup_snowflake TEXT , 
ord_nr SMALLINT , 
	constraint c_kenn_katalog_sub primary key (tid)

) 
;



comment on table kenn_katalog_sub is 'Differenzierungen fr Grunddaten und Kennzahlen';

comment on column kenn_katalog_sub.tid is 'Tupelidentifier';

comment on column kenn_katalog_sub.report_id is 'ID des Reports';

comment on column kenn_katalog_sub.katalog_id is 'ID der Kennzahl';

comment on column kenn_katalog_sub.sub_caption is 'Differenzierung Name';

comment on column kenn_katalog_sub.sub_key_col is 'Differenzierung Spaltenname';

comment on column kenn_katalog_sub.sub_lookup_table is 'Differenzierung Lookup-Tabelle';

comment on column kenn_katalog_sub.sub_lookup_key is 'Differenzierung Lookup-Tabelle key-Spalte';

comment on column kenn_katalog_sub.sub_lookup_name is 'Differenzierung Lookup-Tabelle Name-Spalte';

comment on column kenn_katalog_sub.sub_lookup_whereclause is 'Differenzierung whereclause Lookup-Tabelle';

comment on column kenn_katalog_sub.sub_lookup_snowflake is 'Differenzierung weitere Lookup-Tabellen';

comment on column kenn_katalog_sub.ord_nr is 'Reihenfolge der Kennzahl';


select now(), 'Tabelle kenn_katalog_sub erzeugt';



select now(), 'Erzeuge Tabelle kenn_vari';

create table kenn_vari(
	tid SERIAL  not null, 
vari_nr INTEGER  not null, 
kotr_art CHAR(1)  not null, 
bezugszeit INTEGER , 
bezugsart CHAR(1)  not null, 
	constraint c_kenn_vari_r primary key (tid)

) 
;



comment on table kenn_vari is 'Verteilschritte fr Grunddaten und Kennzahlen im Bereich Kostenrechnung';

comment on column kenn_vari.tid is 'Tupelidentifier';

comment on column kenn_vari.vari_nr is 'Verteilschritt';

comment on column kenn_vari.kotr_art is 'Art d. Kostentrgers';

comment on column kenn_vari.bezugszeit is 'Bezug des Zeitraums';

comment on column kenn_vari.bezugsart is 'Bezugsart (Akad. Jahr A,Jahr J, Quartal Q, Monat M)';


select now(), 'Tabelle kenn_vari erzeugt';



select now(), 'Erzeuge Tabelle kenn_lieferung';

create table kenn_lieferung(
	hs_nr INTEGER , 
kennzahl CHAR(40) , 
datum date 
) 
;



comment on table kenn_lieferung is 'Lieferungen Datum+Hochschule';

comment on column kenn_lieferung.hs_nr is 'Hochschulnummer';

comment on column kenn_lieferung.kennzahl is 'Art der Kennzahl';

comment on column kenn_lieferung.datum is 'Datum der letzten Lieferung';


select now(), 'Tabelle kenn_lieferung erzeugt';



select now(), 'Erzeuge Tabelle kenn_quartal_hier';

create table kenn_quartal_hier(
	hs_nr INTEGER , 
quartal INTEGER , 
gruppe CHAR(12) , 
key CHAR(12) , 
ueberg CHAR(12) 
) 
;



comment on table kenn_quartal_hier is 'Zuordnung alternativer Hiearchien zu Landesschlsseln pro Quartal';

comment on column kenn_quartal_hier.hs_nr is 'Hochschulnummer';

comment on column kenn_quartal_hier.quartal is 'Quartal';

comment on column kenn_quartal_hier.gruppe is 'Kostenart/Kostenstelle';

comment on column kenn_quartal_hier.key is 'Schlssel';

comment on column kenn_quartal_hier.ueberg is 'bergeordnet lt. BVKR/Inst';


select now(), 'Erzeuge Index ix_kenn_q_hier';

create  unique  index ix_kenn_q_hier on kenn_quartal_hier (hs_nr, 
quartal, 
gruppe, 
key );


select now(), 'Tabelle kenn_quartal_hier erzeugt';



select now(), 'Erzeuge Tabelle kenn_anlagen_aggr';

create table kenn_anlagen_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
inst_ext CHAR(20) , 
bund_fachgebiet CHAR(10) , 
asp_akl varchar(6) , 
rest decimal(14,2) , 
rest_vj decimal(14,2) , 
zugang decimal(14,2) , 
abgang decimal(14,2) , 
abschr decimal(14,2) , 
histor_ahk decimal(14,2) , 
umbuch decimal(14,2) , 
zuschr decimal(14,2) , 
abschr_ges decimal(14,2) , 
datum date , 
extkotr CHAR(30) 
) 
;



comment on table kenn_anlagen_aggr is 'Aggregierte Anlagedaten aus IVS';

comment on column kenn_anlagen_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_anlagen_aggr.jahr is 'Jahr';

comment on column kenn_anlagen_aggr.inst_ext is 'Institut';

comment on column kenn_anlagen_aggr.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_anlagen_aggr.asp_akl is 'Anlagenklasse';

comment on column kenn_anlagen_aggr.rest is 'Restbuchwert';

comment on column kenn_anlagen_aggr.rest_vj is 'Restbuchwert Vorjahr';

comment on column kenn_anlagen_aggr.zugang is 'Zugnge';

comment on column kenn_anlagen_aggr.abgang is 'Abgnge';

comment on column kenn_anlagen_aggr.abschr is 'Abschreibungen';

comment on column kenn_anlagen_aggr.histor_ahk is 'Historische AHK';

comment on column kenn_anlagen_aggr.umbuch is 'Umbuchungen';

comment on column kenn_anlagen_aggr.zuschr is 'Zuschreibungen';

comment on column kenn_anlagen_aggr.abschr_ges is 'gesamte Abschreibungen';

comment on column kenn_anlagen_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_anlagen_aggr.extkotr is 'Externer Produktschlssel';


select now(), 'Erzeuge Index ixkenn_anlagen_aggr1';

create  index ixkenn_anlagen_aggr1 on kenn_anlagen_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_anlagen_aggr2';

create  index ixkenn_anlagen_aggr2 on kenn_anlagen_aggr (jahr );


select now(), 'Erzeuge Index ixkenn_anlagen_aggr3';

create  index ixkenn_anlagen_aggr3 on kenn_anlagen_aggr (inst_ext );


select now(), 'Erzeuge Index ixkenn_anlagen_aggr4';

create  index ixkenn_anlagen_aggr4 on kenn_anlagen_aggr (bund_fachgebiet );


select now(), 'Erzeuge Index ixkenn_anlagen_aggr5';

create  index ixkenn_anlagen_aggr5 on kenn_anlagen_aggr (asp_akl );


select now(), 'Tabelle kenn_anlagen_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_stg_int';

create table kenn_stg_int(
	hs_nr INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
astat CHAR(10) , 
abint CHAR(10) , 
datum date 
) 
;



comment on table kenn_stg_int is 'Hochschulinterne Fcher';

comment on column kenn_stg_int.hs_nr is 'Hochschulnummer';

comment on column kenn_stg_int.apnr is 'Fach (intern)';

comment on column kenn_stg_int.druck is 'Fachbezeichnung';

comment on column kenn_stg_int.astat is 'Fach (amtlich)';

comment on column kenn_stg_int.abint is 'Abschluss (intern)';

comment on column kenn_stg_int.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ixkenn_stg_int1';

create  index ixkenn_stg_int1 on kenn_stg_int (hs_nr );


select now(), 'Erzeuge Index ixkenn_stg_int2';

create  index ixkenn_stg_int2 on kenn_stg_int (apnr );


select now(), 'Erzeuge Index ixkenn_stg_int3';

create  index ixkenn_stg_int3 on kenn_stg_int (astat );


select now(), 'Tabelle kenn_stg_int erzeugt';



select now(), 'Erzeuge Tabelle kenn_abint';

create table kenn_abint(
	hs_nr INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
astat CHAR(10) , 
datum date 
) 
;



comment on table kenn_abint is 'Hochschulinterne Abschlsse';

comment on column kenn_abint.hs_nr is 'Hochschulnummer';

comment on column kenn_abint.apnr is 'Fach (intern)';

comment on column kenn_abint.druck is 'Fachbezeichnung';

comment on column kenn_abint.astat is 'Fach (amtlich)';

comment on column kenn_abint.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ixkenn_abint1';

create  index ixkenn_abint1 on kenn_abint (hs_nr );


select now(), 'Erzeuge Index ixkenn_abint2';

create  index ixkenn_abint2 on kenn_abint (apnr );


select now(), 'Erzeuge Index ixkenn_abint3';

create  index ixkenn_abint3 on kenn_abint (astat );


select now(), 'Tabelle kenn_abint erzeugt';



select now(), 'Erzeuge Tabelle kenn_hzbart_astat';

create table kenn_hzbart_astat(
	tid SERIAL  not null, 
bland INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
gruppe INTEGER , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint c_khzbart_astat_tid primary key (tid)

) 
;



comment on table kenn_hzbart_astat is 'Art der Hochschulzugangsber. (Amtlich)';

comment on column kenn_hzbart_astat.tid is 'Tupelidentifier';

comment on column kenn_hzbart_astat.bland is 'Bundesland';

comment on column kenn_hzbart_astat.apnr is 'Schlssel HZB-Art';

comment on column kenn_hzbart_astat.druck is 'Bezeichnung';

comment on column kenn_hzbart_astat.gruppe is 'Gruppe';

comment on column kenn_hzbart_astat.gueltig_von is 'Gltig von';

comment on column kenn_hzbart_astat.gueltig_bis is 'Gltig bis';


select now(), 'Tabelle kenn_hzbart_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_stufrm';

create table kenn_stufrm(
	tid SERIAL  not null, 
bland INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
	constraint c_kenn_stufrm_tid primary key (tid)

) 
;



comment on table kenn_stufrm is 'Studienform (Amtlich)';

comment on column kenn_stufrm.tid is 'Tupelidentifier';

comment on column kenn_stufrm.bland is 'Bundesland';

comment on column kenn_stufrm.apnr is 'Schlssel Studienform';

comment on column kenn_stufrm.druck is 'Bezeichnung';


select now(), 'Tabelle kenn_stufrm erzeugt';



select now(), 'Erzeuge Tabelle kenn_stuart';

create table kenn_stuart(
	tid SERIAL  not null, 
bland INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
	constraint c_kenn_stuart_tid primary key (tid)

) 
;



comment on table kenn_stuart is 'Studienart (Amtlich)';

comment on column kenn_stuart.tid is 'Tupelidentifier';

comment on column kenn_stuart.bland is 'Bundesland';

comment on column kenn_stuart.apnr is 'Schlssel Studienart';

comment on column kenn_stuart.druck is 'Bezeichnung';


select now(), 'Tabelle kenn_stuart erzeugt';



select now(), 'Erzeuge Tabelle kenn_stort';

create table kenn_stort(
	tid SERIAL  not null, 
bland INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
hs_nr INTEGER , 
kurz VARCHAR(254) , 
	constraint c_kenn_stort_tid primary key (tid)

) 
;



comment on table kenn_stort is 'Standorte (Amtlich)';

comment on column kenn_stort.tid is 'Tupelidentifier';

comment on column kenn_stort.bland is 'Bundesland';

comment on column kenn_stort.apnr is 'Schlssel Standort';

comment on column kenn_stort.druck is 'Bezeichnung';

comment on column kenn_stort.hs_nr is 'Hochschule';

comment on column kenn_stort.kurz is 'Hochschule';


select now(), 'Tabelle kenn_stort erzeugt';



select now(), 'Erzeuge Tabelle kenn_antr_aggr';

create table kenn_antr_aggr(
	hs_nr INTEGER , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
bewsem SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
antrnr SMALLINT , 
fach_sem_zahl SMALLINT , 
stort CHAR(10) , 
stg_int CHAR(10) , 
abint CHAR(10) , 
hzbart SMALLINT , 
zul_kz CHAR(1) , 
datum date , 
einschreib_kz CHAR(1) , 
summe INTEGER , 
stg_land CHAR(4) 
) 
;



comment on table kenn_antr_aggr is 'Hilfstabelle Bewerberstatistik';

comment on column kenn_antr_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_antr_aggr.fach_nr is 'Fach-Nummer';

comment on column kenn_antr_aggr.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_antr_aggr.ca12_staat is 'Nationalitt';

comment on column kenn_antr_aggr.bewsem is 'Semester';

comment on column kenn_antr_aggr.stg is 'Fach (amtlich)';

comment on column kenn_antr_aggr.abschluss is 'Abschluss (amtlich)';

comment on column kenn_antr_aggr.antrnr is 'Antragsnummer';

comment on column kenn_antr_aggr.fach_sem_zahl is 'Fachsemester';

comment on column kenn_antr_aggr.stort is 'Standort';

comment on column kenn_antr_aggr.stg_int is 'Fach (intern)';

comment on column kenn_antr_aggr.abint is 'Abschluss (intern)';

comment on column kenn_antr_aggr.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_antr_aggr.zul_kz is 'Zugelassen';

comment on column kenn_antr_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_antr_aggr.einschreib_kz is 'Einschreibungs-Kennzeichen';

comment on column kenn_antr_aggr.summe is 'Summe';

comment on column kenn_antr_aggr.stg_land is 'Fach Land (amtlich)';


select now(), 'Erzeuge Index ixkenn_antr_aggr1';

create  index ixkenn_antr_aggr1 on kenn_antr_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_antr_aggr2';

create  index ixkenn_antr_aggr2 on kenn_antr_aggr (fach_nr );


select now(), 'Erzeuge Index ixkenn_antr_aggr3';

create  index ixkenn_antr_aggr3 on kenn_antr_aggr (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_antr_aggr4';

create  index ixkenn_antr_aggr4 on kenn_antr_aggr (bewsem );


select now(), 'Erzeuge Index ixkenn_antr_aggr5';

create  index ixkenn_antr_aggr5 on kenn_antr_aggr (abschluss );


select now(), 'Erzeuge Index ixkenn_antr_aggr6';

create  index ixkenn_antr_aggr6 on kenn_antr_aggr (hzbart );


select now(), 'Erzeuge Index ixkenn_antr_aggr7';

create  index ixkenn_antr_aggr7 on kenn_antr_aggr (antrnr );


select now(), 'Tabelle kenn_antr_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_antr_prozess_aggr';

create table kenn_antr_prozess_aggr(
	hs_nr INTEGER , 
fach_nr SMALLINT , 
geschlecht CHAR(10) , 
bewsem SMALLINT , 
stg CHAR(4) , 
stg_land CHAR(4) , 
abschlusstyp CHAR(10) , 
antrnr SMALLINT , 
fach_sem_zahl_1 CHAR(10) , 
antrag_status CHAR(10) , 
aufbaustudium CHAR(10) , 
datum date , 
summe INTEGER 
) 
;



comment on table kenn_antr_prozess_aggr is 'Hilfstabelle Bewerbungsproze-Statistik';

comment on column kenn_antr_prozess_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_antr_prozess_aggr.fach_nr is 'Fach-Nummer';

comment on column kenn_antr_prozess_aggr.geschlecht is 'Geschlecht';

comment on column kenn_antr_prozess_aggr.bewsem is 'Semester';

comment on column kenn_antr_prozess_aggr.stg is 'Fach (amtlich Bund)';

comment on column kenn_antr_prozess_aggr.stg_land is 'Fach Land (amtlich)';

comment on column kenn_antr_prozess_aggr.abschlusstyp is 'Abschlusstyp';

comment on column kenn_antr_prozess_aggr.antrnr is 'Antragsnummer';

comment on column kenn_antr_prozess_aggr.fach_sem_zahl_1 is '1. Fachsemester';

comment on column kenn_antr_prozess_aggr.antrag_status is 'Antragsstatus';

comment on column kenn_antr_prozess_aggr.aufbaustudium is 'Ist Aufbaustudium';

comment on column kenn_antr_prozess_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_antr_prozess_aggr.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr1';

create  index ixkenn_antr_prozess_aggr1 on kenn_antr_prozess_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr2';

create  index ixkenn_antr_prozess_aggr2 on kenn_antr_prozess_aggr (fach_nr );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr3';

create  index ixkenn_antr_prozess_aggr3 on kenn_antr_prozess_aggr (geschlecht );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr4';

create  index ixkenn_antr_prozess_aggr4 on kenn_antr_prozess_aggr (bewsem );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr5';

create  index ixkenn_antr_prozess_aggr5 on kenn_antr_prozess_aggr (stg, 
abschlusstyp );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr6';

create  index ixkenn_antr_prozess_aggr6 on kenn_antr_prozess_aggr (antrag_status );


select now(), 'Erzeuge Index ixkenn_antr_prozess_aggr7';

create  index ixkenn_antr_prozess_aggr7 on kenn_antr_prozess_aggr (antrnr );


select now(), 'Tabelle kenn_antr_prozess_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_stg_aggr';

create table kenn_stg_aggr(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_rueck_beur_ein SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
regel SMALLINT , 
hzbart SMALLINT , 
kz_rueck_beur_ein SMALLINT , 
fach_sem_zahl SMALLINT , 
hssem SMALLINT , 
kz_fach CHAR(1) , 
stort CHAR(10) , 
stuart CHAR(10) , 
stufrm CHAR(10) , 
stg_int CHAR(10) , 
abint CHAR(10) , 
hzbart_astat CHAR(10) , 
hrst CHAR(10) , 
datum date , 
summe INTEGER , 
kz_fach_int CHAR(10) , 
vertfg CHAR(10) , 
stg_land CHAR(4) 
) 
;



comment on table kenn_stg_aggr is 'Hilfstabelle Studierendenstatistik (fr Semesterberichte)';

comment on column kenn_stg_aggr.hs_nr is 'Hochschule';

comment on column kenn_stg_aggr.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_stg_aggr.fach_nr is 'Fach-Nummer';

comment on column kenn_stg_aggr.geschlecht is 'Geschlecht';

comment on column kenn_stg_aggr.ca12_staat is 'Nationalitt';

comment on column kenn_stg_aggr.sem_rueck_beur_ein is 'Semester';

comment on column kenn_stg_aggr.stg is 'Fach (amtlich)';

comment on column kenn_stg_aggr.abschluss is 'Abschluss (amtlich)';

comment on column kenn_stg_aggr.regel is 'in der RSZ';

comment on column kenn_stg_aggr.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_stg_aggr.kz_rueck_beur_ein is 'Einschreib- oder Rckmeldestatus';

comment on column kenn_stg_aggr.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_stg_aggr.hssem is 'Anzahl Hochschulsemester';

comment on column kenn_stg_aggr.kz_fach is 'Fachkennzeichen';

comment on column kenn_stg_aggr.stort is 'Standort';

comment on column kenn_stg_aggr.stuart is 'Studienart (amtlich)';

comment on column kenn_stg_aggr.stufrm is 'Studienform (amtlich)';

comment on column kenn_stg_aggr.stg_int is 'Fach (intern)';

comment on column kenn_stg_aggr.abint is 'Abschluss (intern)';

comment on column kenn_stg_aggr.hzbart_astat is 'Hochschulzugangsberechtigung';

comment on column kenn_stg_aggr.hrst is 'Hrerstatus';

comment on column kenn_stg_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_stg_aggr.summe is 'Summe';

comment on column kenn_stg_aggr.kz_fach_int is 'Fachkennzeichen (intern)';

comment on column kenn_stg_aggr.vertfg is 'Vertiefung';

comment on column kenn_stg_aggr.stg_land is 'Fach Land (amtlich)';


select now(), 'Erzeuge Index ixkenn_stg_aggr1';

create  index ixkenn_stg_aggr1 on kenn_stg_aggr (hs_nr );


select now(), 'Erzeuge Index ixkenn_stg_aggr2';

create  index ixkenn_stg_aggr2 on kenn_stg_aggr (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_stg_aggr3';

create  index ixkenn_stg_aggr3 on kenn_stg_aggr (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_stg_aggr4';

create  index ixkenn_stg_aggr4 on kenn_stg_aggr (sem_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stg_aggr5';

create  index ixkenn_stg_aggr5 on kenn_stg_aggr (abschluss );


select now(), 'Erzeuge Index ixkenn_stg_aggr6';

create  index ixkenn_stg_aggr6 on kenn_stg_aggr (hzbart_astat );


select now(), 'Erzeuge Index ixkenn_stg_aggr7';

create  index ixkenn_stg_aggr7 on kenn_stg_aggr (kz_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stg_aggr8';

create  index ixkenn_stg_aggr8 on kenn_stg_aggr (stg );


select now(), 'Tabelle kenn_stg_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_kzfach_int';

create table kenn_kzfach_int(
	hs_nr INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
datum date 
) 
;



comment on table kenn_kzfach_int is 'Hochschulinterne Fachkennzeichen';

comment on column kenn_kzfach_int.hs_nr is 'Hochschulnummer';

comment on column kenn_kzfach_int.apnr is 'Fachkennzeichen (intern)';

comment on column kenn_kzfach_int.druck is 'Fachkennzeichenbezeichnung';

comment on column kenn_kzfach_int.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ixkenn_kzfach_int1';

create  index ixkenn_kzfach_int1 on kenn_kzfach_int (hs_nr );


select now(), 'Erzeuge Index ixkenn_kzfach_int2';

create  index ixkenn_kzfach_int2 on kenn_kzfach_int (apnr );


select now(), 'Tabelle kenn_kzfach_int erzeugt';



select now(), 'Erzeuge Tabelle kenn_vert_int';

create table kenn_vert_int(
	hs_nr INTEGER , 
apnr CHAR(10)  not null, 
druck VARCHAR(255) , 
datum date 
) 
;



comment on table kenn_vert_int is 'Hochschulinterne Vertiefungen';

comment on column kenn_vert_int.hs_nr is 'Hochschulnummer';

comment on column kenn_vert_int.apnr is 'Vertiefungen (intern)';

comment on column kenn_vert_int.druck is 'Vertiefungenbezeichnung';

comment on column kenn_vert_int.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ixkenn_vert_int1';

create  index ixkenn_vert_int1 on kenn_vert_int (hs_nr );


select now(), 'Erzeuge Index ixkenn_vert_int2';

create  index ixkenn_vert_int2 on kenn_vert_int (apnr );


select now(), 'Tabelle kenn_vert_int erzeugt';



select now(), 'Erzeuge Tabelle kenn_abschl_sbereich';

create table kenn_abschl_sbereich(
	tid SERIAL  not null, 
abschluss CHAR(10) , 
sbereich VARCHAR(255) , 
	constraint c_kenn_abschl_sbereich primary key (tid)

) 
;



comment on column kenn_abschl_sbereich.abschluss is 'Abschluss (intern)';

comment on column kenn_abschl_sbereich.sbereich is 'Abschlussgruppe';


select now(), 'Tabelle kenn_abschl_sbereich erzeugt';



select now(), 'Erzeuge Tabelle kenn_extkotr_stg';

create table kenn_extkotr_stg(
	tid SERIAL  not null, 
extkotr CHAR(30) , 
stg CHAR(10) , 
stg_astat CHAR(10) , 
stg_str CHAR(255) , 
	constraint c_kenn_extkotr_stg primary key (tid)

) 
;



comment on column kenn_extkotr_stg.extkotr is 'Externer Kostentrger';

comment on column kenn_extkotr_stg.stg is 'Fach (intern) Schlssel';

comment on column kenn_extkotr_stg.stg_astat is 'Fach (amtlich) Bundesschlssel';

comment on column kenn_extkotr_stg.stg_str is 'Fach (intern) Name';


select now(), 'Erzeuge Index ixkenn_extkotr_stg1';

create  unique  index ixkenn_extkotr_stg1 on kenn_extkotr_stg (stg );


select now(), 'Tabelle kenn_extkotr_stg erzeugt';



select now(), 'Erzeuge Tabelle kenn_proj_gege';

create table kenn_proj_gege(
	hs_nr INTEGER , 
projnr CHAR(10) , 
klr_geldgeber CHAR(10) , 
k_extkotr CHAR(10) , 
jahr INTEGER 
) 
;



comment on table kenn_proj_gege is 'Kostentrger zu Geldgeber';

comment on column kenn_proj_gege.hs_nr is 'Hochschulnummer';

comment on column kenn_proj_gege.projnr is 'Projekt Schlssel';

comment on column kenn_proj_gege.klr_geldgeber is 'KLR-Geldgeber';

comment on column kenn_proj_gege.k_extkotr is 'externer Kostentrger';


select now(), 'Erzeuge Index ix_kenn_proj_gege';

create  index ix_kenn_proj_gege on kenn_proj_gege (hs_nr, 
projnr );


select now(), 'Erzeuge Index ix_kenn_proj_gex';

create  index ix_kenn_proj_gex on kenn_proj_gege (k_extkotr );


select now(), 'Tabelle kenn_proj_gege erzeugt';



select now(), 'Erzeuge Tabelle kenn_pbv_klr';

create table kenn_pbv_klr(
	hs_nr INTEGER , 
jahr SMALLINT , 
monat SMALLINT , 
kapitel CHAR(5) , 
titel CHAR(10) , 
kostenart CHAR(12) , 
kalk_kostenart CHAR(12) , 
bund_dienstart SMALLINT , 
buadbz CHAR(10) , 
klr_geldgeber CHAR(10) , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
stichtag DATE , 
zaehlung CHAR(2) , 
datum date , 
summe double precision 
) 
;



comment on table kenn_pbv_klr is 'Personalstammstze aus der KLR';

comment on column kenn_pbv_klr.hs_nr is 'Hochschulnummer';

comment on column kenn_pbv_klr.kapitel is 'Kapitel aus Finanzierung';

comment on column kenn_pbv_klr.bund_dienstart is 'Dienstart (1=Wiss./2=Nichtwiss. Bundesschlssel)';

comment on column kenn_pbv_klr.buadbz is 'Amts-Dienstbez. (Bundesschlssel)';

comment on column kenn_pbv_klr.klr_geldgeber is 'Geldgeber aus Finanzierung';

comment on column kenn_pbv_klr.extkost is 'Externe Kostenstelle';

comment on column kenn_pbv_klr.extkotr is 'Externer Produktschlssel';

comment on column kenn_pbv_klr.stichtag is 'Datum der Gltigkeit des Besch.-Verh.';

comment on column kenn_pbv_klr.zaehlung is 'Kpfe=k / VZAE=v';

comment on column kenn_pbv_klr.datum is 'Datum der Erzeugung';

comment on column kenn_pbv_klr.summe is 'Summe';


select now(), 'Erzeuge Index kenn_imp_pbv_id';

create  index kenn_imp_pbv_id on kenn_pbv_klr (zaehlung, 
monat, 
jahr, 
klr_geldgeber );


select now(), 'Tabelle kenn_pbv_klr erzeugt';



select now(), 'Erzeuge Tabelle kenn_auslastung';

create table kenn_auslastung(
	hs_nr INTEGER , 
lehreinheit CHAR(10) , 
k_extkotr CHAR(10) , 
sem INTEGER , 
datum DATE , 
ffidrgf2 double precision , 
sws_lehrang double precision , 
sws_lehrnf double precision , 
sws_lehrnf_eigen double precision , 
sws_lehrnf_fremd double precision , 
sws_lehrnf_ea double precision , 
dlk double precision 
) 
;



comment on table kenn_auslastung is 'Lehrnachfrage/angebot gem. KapVo (nur Sachsen)';

comment on column kenn_auslastung.hs_nr is 'Hochschulnummer';

comment on column kenn_auslastung.lehreinheit is 'Lehreinheit';

comment on column kenn_auslastung.k_extkotr is 'Externer Produktschlssel';

comment on column kenn_auslastung.sem is 'Semester';

comment on column kenn_auslastung.datum is 'Berechnungsdatum';

comment on column kenn_auslastung.ffidrgf2 is 'VZ in der RSZ';

comment on column kenn_auslastung.sws_lehrang is 'SWS Angebot';

comment on column kenn_auslastung.sws_lehrnf is 'SWS Nachfrage';

comment on column kenn_auslastung.sws_lehrnf_eigen is 'SWS Nachfrage (eigene Studiengnge)';

comment on column kenn_auslastung.sws_lehrnf_fremd is 'SWS Nachfrage (Dienstleistung fr andere Studiengnge)';

comment on column kenn_auslastung.sws_lehrnf_ea is 'SWS Nachfrage eigener Studiengnge an alle Lehreinheiten';

comment on column kenn_auslastung.dlk is 'Dienstleistungskoeffizient';


select now(), 'Tabelle kenn_auslastung erzeugt';



select now(), 'Erzeuge Tabelle kenn_fibu_guv';

create table kenn_fibu_guv(
	hs_nr INTEGER , 
jahr SMALLINT , 
name VARCHAR(255) , 
hierarchie_ebene SMALLINT , 
betrag double precision , 
betragvorjahr double precision , 
unterstrich SMALLINT  default 0 , 
sortnr INTEGER  default 0 , 
sortnr2 INTEGER  default 0 , 
datum DATE 
) 
;



comment on column kenn_fibu_guv.hs_nr is 'Hochschulnummer';

comment on column kenn_fibu_guv.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index kenn_fibu_guv1';

create  index kenn_fibu_guv1 on kenn_fibu_guv (hs_nr );


select now(), 'Tabelle kenn_fibu_guv erzeugt';



select now(), 'Erzeuge Tabelle kenn_fibu_bilanz';

create table kenn_fibu_bilanz(
	hs_nr INTEGER , 
jahr SMALLINT , 
name VARCHAR(255) , 
hierarchie_ebene SMALLINT , 
betrag double precision , 
betragvorjahr double precision , 
unterstrich SMALLINT  default 0 , 
sortnr INTEGER  default 0 , 
sortnr2 INTEGER  default 0 , 
datum DATE 
) 
;



comment on column kenn_fibu_bilanz.hs_nr is 'Hochschulnummer';

comment on column kenn_fibu_bilanz.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index kenn_fibu_bil1';

create  index kenn_fibu_bil1 on kenn_fibu_bilanz (hs_nr );


select now(), 'Tabelle kenn_fibu_bilanz erzeugt';



select now(), 'Erzeuge Tabelle kenn_fibu_quartal';

create table kenn_fibu_quartal(
	hs_nr INTEGER , 
id VARCHAR(50)  default '0' , 
jahr SMALLINT , 
zeile VARCHAR(255) , 
kontengruppe VARCHAR(255) , 
name VARCHAR(255) , 
hierarchie_ebene SMALLINT , 
plan double precision , 
q1 double precision , 
q2 double precision , 
q3 double precision , 
q4 double precision , 
steuerungvorschau double precision , 
steuerungvorjahr double precision , 
erlaeuterung TEXT , 
sortnr INTEGER  default 0 , 
sortnr2 INTEGER  default 0 , 
datum DATE , 
zeilennr INTEGER , 
vorjahr_q1 double precision , 
vorjahr_q2 double precision , 
vorjahr_q3 double precision , 
vorjahr_q4 double precision , 
quartal SMALLINT 
) 
;



comment on column kenn_fibu_quartal.hs_nr is 'Hochschulnummer';

comment on column kenn_fibu_quartal.id is 'ID fr HIS-FIBU';

comment on column kenn_fibu_quartal.datum is 'Datum der Erzeugung';

comment on column kenn_fibu_quartal.quartal is 'Quartal der Lieferung';


select now(), 'Erzeuge Index kenn_fibu_quar1';

create  index kenn_fibu_quar1 on kenn_fibu_quartal (hs_nr );


select now(), 'Tabelle kenn_fibu_quartal erzeugt';



select now(), 'Erzeuge Tabelle kenn_fibu_wiplan';

create table kenn_fibu_wiplan(
	hs_nr INTEGER , 
id VARCHAR(50)  not null, 
jahr SMALLINT , 
kuerzel VARCHAR(255) , 
kontengruppe VARCHAR(255) , 
zweckbestimmung VARCHAR(255) , 
ist double precision , 
sollplus1 double precision , 
sollplus2 double precision , 
sollplus3 double precision , 
sortnr INTEGER  default 0 , 
datum DATE , 
	constraint id_kenn_fibu_wipla2 primary key (hs_nr, id)

) 
;



comment on column kenn_fibu_wiplan.hs_nr is 'Hochschulnummer';

comment on column kenn_fibu_wiplan.id is 'eindeutig ID zum Hinterlegen von manuell zu erfassenden Werten';

comment on column kenn_fibu_wiplan.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index kenn_fibu_wipl1';

create  index kenn_fibu_wipl1 on kenn_fibu_wiplan (hs_nr );


select now(), 'Tabelle kenn_fibu_wiplan erzeugt';



select now(), 'Erzeuge Tabelle kenn_kam_quartal';

create table kenn_kam_quartal(
	hs_nr INTEGER , 
jahr SMALLINT , 
dr VARCHAR(50) , 
titel CHAR(10) , 
soll double precision  default 0 , 
reste double precision  default 0 , 
haushaltsvorgriff double precision  default 0 , 
istq1 double precision  default 0 , 
istq2 double precision  default 0 , 
istq3 double precision  default 0 , 
istq4 double precision  default 0 , 
istvorjahr_q1 double precision  default 0 , 
istvorjahr_q2 double precision  default 0 , 
istvorjahr_q3 double precision  default 0 , 
istvorjahr_q4 double precision  default 0 , 
vorschau double precision  default 0 , 
erlaeuterung TEXT , 
datum DATE , 
quartal SMALLINT 
) 
;



comment on column kenn_kam_quartal.hs_nr is 'Hochschulnummer';

comment on column kenn_kam_quartal.datum is 'Datum der Erzeugung';

comment on column kenn_kam_quartal.quartal is 'Quartal der Lieferung';


select now(), 'Erzeuge Index ix_kenn_kam_quartal1';

create  index ix_kenn_kam_quartal1 on kenn_kam_quartal (hs_nr, 
jahr );


select now(), 'Erzeuge Index ix_kenn_kam_quartal2';

create  index ix_kenn_kam_quartal2 on kenn_kam_quartal (quartal );


select now(), 'Tabelle kenn_kam_quartal erzeugt';



select now(), 'Erzeuge Tabelle kenn_kam_ja';

create table kenn_kam_ja(
	hs_nr INTEGER , 
jahr SMALLINT , 
dr VARCHAR(50) , 
titel CHAR(10) , 
soll double precision  default 0 , 
reste double precision  default 0 , 
haushaltsvorgriff double precision  default 0 , 
ist double precision  default 0 , 
erlaeuterung TEXT , 
datum DATE 
) 
;



comment on column kenn_kam_ja.hs_nr is 'Hochschulnummer';

comment on column kenn_kam_ja.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ix_kenn_kam_ja1';

create  index ix_kenn_kam_ja1 on kenn_kam_ja (hs_nr, 
jahr );


select now(), 'Tabelle kenn_kam_ja erzeugt';



select now(), 'Erzeuge Tabelle kenn_stupl';

create table kenn_stupl(
	hs_nr INTEGER  not null, 
stug_key CHAR(12) , 
stug_rstuz SMALLINT , 
jahr INTEGER , 
sem INTEGER  not null, 
extkotr CHAR(30) , 
datum DATE , 
summe INTEGER 
) 
;



comment on table kenn_stupl is 'Studienplaetze je Studiengang';

comment on column kenn_stupl.hs_nr is 'Hochschulnummer';

comment on column kenn_stupl.extkotr is 'Externer Produktschlssel';

comment on column kenn_stupl.datum is 'Datum der Erzeugung';


select now(), 'Erzeuge Index ix_kenn_stupl';

create  index ix_kenn_stupl on kenn_stupl (stug_key, 
extkotr, 
sem );


select now(), 'Erzeuge Index ix_kenn_stupl2';

create  index ix_kenn_stupl2 on kenn_stupl (hs_nr );


select now(), 'Tabelle kenn_stupl erzeugt';



select now(), 'Erzeuge Tabelle kenn_zulzahl_id';

create table kenn_zulzahl_id(
	id SERIAL  not null, 
name VARCHAR(255) , 
beschreibung VARCHAR(255) , 
fach VARCHAR(255) , 
abschluss VARCHAR(255) , 
hs_nr INTEGER , 
stort CHAR(10) , 
abgrp CHAR(10) , 
erzeugt_am DATE  default today(), 
geaendert_am DATE , 
geaendert_von_id INTEGER , 
erzeugt_von_id INTEGER , 
redaktionsstatus INTEGER , 
	constraint pk_kenn_zulzahl_id_id primary key (id)

) 
;



comment on table kenn_zulzahl_id is 'Nur BaWue: ID fr Zulassungszahlen mit Namen und Kurzbeschreibung';

comment on column kenn_zulzahl_id.id is 'Laufnummer';

comment on column kenn_zulzahl_id.name is 'Name';

comment on column kenn_zulzahl_id.fach is 'Studienfach';

comment on column kenn_zulzahl_id.abschluss is 'Abschluss';

comment on column kenn_zulzahl_id.hs_nr is 'Hochschule';

comment on column kenn_zulzahl_id.stort is 'Standort';

comment on column kenn_zulzahl_id.abgrp is 'Abschlussgruppe';

comment on column kenn_zulzahl_id.erzeugt_am is 'Datum der Erzeugung des Datensatzes';

comment on column kenn_zulzahl_id.geaendert_am is 'Datum der letzten nderung des Datensatzes';

comment on column kenn_zulzahl_id.geaendert_von_id is 'UserID des ndernden';

comment on column kenn_zulzahl_id.erzeugt_von_id is 'UserID des Erzeugers';

comment on column kenn_zulzahl_id.redaktionsstatus is 'Redaktionsstatus';


select now(), 'Erzeuge Index ix_kenn_zulzahl_id1';

create  index ix_kenn_zulzahl_id1 on kenn_zulzahl_id (hs_nr );


select now(), 'Tabelle kenn_zulzahl_id erzeugt';



select now(), 'Erzeuge Tabelle kenn_zulzahl_sem';

create table kenn_zulzahl_sem(
	tid SERIAL  not null, 
zulzahl_id INTEGER  not null, 
semester INTEGER , 
zul_beschr SMALLINT , 
zulzahl INTEGER , 
	constraint pk_kenn_zulzahl_sem primary key (tid)

) 
;



comment on table kenn_zulzahl_sem is 'Nur BaWue: Zulassungszahlen pro Semester';

comment on column kenn_zulzahl_sem.tid is 'Laufnummer';

comment on column kenn_zulzahl_sem.zulzahl_id is 'Zulassungszahl-ID';

comment on column kenn_zulzahl_sem.semester is 'Semester';

comment on column kenn_zulzahl_sem.zul_beschr is 'Zulassungsbeschrnkt?';

comment on column kenn_zulzahl_sem.zulzahl is 'Zulassungszahl';


select now(), 'Erzeuge Index ix_kenn_zulzahl_stupl1';

create  index ix_kenn_zulzahl_stupl1 on kenn_zulzahl_sem (zulzahl_id, 
semester );


select now(), 'Tabelle kenn_zulzahl_sem erzeugt';



select now(), 'Erzeuge Tabelle kenn_zulzahl2int';

create table kenn_zulzahl2int(
	tid SERIAL  not null, 
zulzahl_id INTEGER , 
stg_int CHAR(10) , 
abschluss_int CHAR(10) , 
kz_fach_int CHAR(10) , 
vertfg CHAR(10) , 
stg_astat CHAR(10) , 
abschluss_astat CHAR(10) , 
hs_nr INTEGER , 
stort CHAR(10) , 
erzeugt_am DATE  default today(), 
geaendert_am DATE , 
geaendert_von_id INTEGER , 
erzeugt_von_id INTEGER , 
	constraint pk_kenn_zulzahl2int_tid primary key (tid)

) 
;



comment on table kenn_zulzahl2int is 'Nur BaWue: Zuordnung der Zulassungszahl-ID zum internen Studiengang';

comment on column kenn_zulzahl2int.tid is 'Laufnummer';

comment on column kenn_zulzahl2int.zulzahl_id is 'Studiengang-ID';

comment on column kenn_zulzahl2int.stg_int is 'Fach (intern)';

comment on column kenn_zulzahl2int.abschluss_int is 'Abschluss (intern)';

comment on column kenn_zulzahl2int.kz_fach_int is 'Fachkennzeichen (intern)';

comment on column kenn_zulzahl2int.vertfg is 'Vertiefung';

comment on column kenn_zulzahl2int.stg_astat is 'Fach (amtl.)';

comment on column kenn_zulzahl2int.abschluss_astat is 'Abschluss (amtl.)';

comment on column kenn_zulzahl2int.hs_nr is 'Hochschule';

comment on column kenn_zulzahl2int.stort is 'Standort';

comment on column kenn_zulzahl2int.erzeugt_am is 'Datum der Erzeugung des Datensatzes';

comment on column kenn_zulzahl2int.geaendert_am is 'Datum der letzten nderung des Datensatzes';

comment on column kenn_zulzahl2int.geaendert_von_id is 'UserID des ndernden';

comment on column kenn_zulzahl2int.erzeugt_von_id is 'UserID des Erzeugers';


select now(), 'Erzeuge Index ix_zulzahl2int2';

create  index ix_zulzahl2int2 on kenn_zulzahl2int (zulzahl_id );


select now(), 'Erzeuge Index ix_zulzahl2int3';

create  index ix_zulzahl2int3 on kenn_zulzahl2int (hs_nr );


select now(), 'Tabelle kenn_zulzahl2int erzeugt';



select now(), 'Erzeuge Tabelle kenn_vtbu_qp_aggr';

create table kenn_vtbu_qp_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
monat SMALLINT , 
quell_ch110_inst VARCHAR(50) , 
ziel_projnr CHAR(10) , 
kokl CHAR(1) , 
datum date , 
betrag double precision 
) 
;



comment on table kenn_vtbu_qp_aggr is 'Hilfstabelle Verteilbuchungen Querschnittsprodukte aus HISCOB';

comment on column kenn_vtbu_qp_aggr.hs_nr is 'Hochschulnummer';

comment on column kenn_vtbu_qp_aggr.jahr is 'Jahr';

comment on column kenn_vtbu_qp_aggr.quartal is 'Quartal';

comment on column kenn_vtbu_qp_aggr.monat is 'Monat';

comment on column kenn_vtbu_qp_aggr.quell_ch110_inst is 'Abgebende Kostenstelle';

comment on column kenn_vtbu_qp_aggr.ziel_projnr is 'Projektnr. (ext. Kostentrger)';

comment on column kenn_vtbu_qp_aggr.kokl is 'Kontenklasse';

comment on column kenn_vtbu_qp_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_vtbu_qp_aggr.betrag is 'Betrag';


select now(), 'Erzeuge Index ixkenn_vtbu_qpaggr1';

create  index ixkenn_vtbu_qpaggr1 on kenn_vtbu_qp_aggr (jahr, 
monat );


select now(), 'Erzeuge Index kenn_vtbu_qpaggr3';

create  index kenn_vtbu_qpaggr3 on kenn_vtbu_qp_aggr (quell_ch110_inst );


select now(), 'Erzeuge Index kenn_vtbu_qpaggr4';

create  index kenn_vtbu_qpaggr4 on kenn_vtbu_qp_aggr (ziel_projnr );


select now(), 'Erzeuge Index kenn_vtbu_qpaggr6';

create  index kenn_vtbu_qpaggr6 on kenn_vtbu_qp_aggr (hs_nr );


select now(), 'Tabelle kenn_vtbu_qp_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_stg_cube';

create table kenn_stg_cube(
	hs_nr INTEGER , 
ca12_staat INTEGER , 
geschlecht INTEGER , 
hzbart INTEGER , 
studiengang_nr INTEGER , 
fach_nr INTEGER , 
fach_sem_zahl INTEGER , 
sem_rueck_beur_ein INTEGER , 
kz_rueck_beur_ein INTEGER , 
hssem INTEGER , 
stufrm_astat INTEGER , 
stg_astat INTEGER , 
kz_fach_astat INTEGER , 
abschluss_astat INTEGER , 
rsz INTEGER , 
extkotr INTEGER , 
summe decimal(16,2) 
) 
;



comment on table kenn_stg_cube is 'Cube-Tabelle Belegungen von Studiengngen';

comment on column kenn_stg_cube.hs_nr is 'Hochschulen Namen';

comment on column kenn_stg_cube.ca12_staat is 'Staatsangehrigkeit (weltweit)';

comment on column kenn_stg_cube.geschlecht is 'Geschlecht';

comment on column kenn_stg_cube.hzbart is 'Hochschulzugangsberechtigung';

comment on column kenn_stg_cube.studiengang_nr is 'Studiengang Nr.';

comment on column kenn_stg_cube.fach_nr is 'Studienfachnummer';

comment on column kenn_stg_cube.fach_sem_zahl is 'Studiensem. nach Fachsem.';

comment on column kenn_stg_cube.sem_rueck_beur_ein is 'Zeitpunkt semesterweise';

comment on column kenn_stg_cube.kz_rueck_beur_ein is 'Einschreib/Rckmeldestatus';

comment on column kenn_stg_cube.hssem is 'Studiensem. nach Hochschulsem.';

comment on column kenn_stg_cube.stufrm_astat is 'Studienform (amtlich)';

comment on column kenn_stg_cube.stg_astat is 'Studienfach (amtlich)';

comment on column kenn_stg_cube.kz_fach_astat is 'Fachkennzeichen (amtlich)';

comment on column kenn_stg_cube.abschluss_astat is 'Studienabschluss (amtlich)';

comment on column kenn_stg_cube.rsz is 'Regelstudienzeit';

comment on column kenn_stg_cube.extkotr is 'Ext. Kostentrger';

comment on column kenn_stg_cube.summe is 'Summe';


select now(), 'Tabelle kenn_stg_cube erzeugt';



select now(), 'Erzeuge Tabelle kenn_sember_stg_cube';

create table kenn_sember_stg_cube(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
semester INTEGER , 
fachsem INTEGER , 
geschlecht INTEGER , 
hzbart INTEGER , 
rsz INTEGER , 
abschluss CHAR(20) , 
abschluss_astat CHAR(10) , 
stg_astat CHAR(20) , 
stg CHAR(20) , 
ca12_staat INTEGER , 
hssem INTEGER , 
kz_fach CHAR(10) , 
kz_rueck_beur_ein SMALLINT , 
hzbart_astat CHAR(10) , 
stort CHAR(10) , 
stuart CHAR(10) , 
stufrm CHAR(10) , 
hrst CHAR(10) , 
summe INTEGER 
) 
;



comment on table kenn_sember_stg_cube is 'Semesterberichte Studierende';

comment on column kenn_sember_stg_cube.hs_nr is 'Hochschule';

comment on column kenn_sember_stg_cube.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_sember_stg_cube.fach_nr is 'Fach-Nummer';

comment on column kenn_sember_stg_cube.semester is 'Semester';

comment on column kenn_sember_stg_cube.fachsem is 'Anzahl Fachsemester';

comment on column kenn_sember_stg_cube.geschlecht is 'Geschlecht';

comment on column kenn_sember_stg_cube.hzbart is 'Gruppe der HZB';

comment on column kenn_sember_stg_cube.rsz is 'in der RSZ';

comment on column kenn_sember_stg_cube.abschluss is 'Abschluss';

comment on column kenn_sember_stg_cube.abschluss_astat is 'Abschluss (amtlich)';

comment on column kenn_sember_stg_cube.stg_astat is 'Fach (amtlich)';

comment on column kenn_sember_stg_cube.stg is 'Hochschule und Fach (intern)';

comment on column kenn_sember_stg_cube.ca12_staat is 'Staatsangehrigkeit';

comment on column kenn_sember_stg_cube.hssem is 'Anzahl Hochschulsemester';

comment on column kenn_sember_stg_cube.kz_fach is 'Fachkennzeichen (amtlich)';

comment on column kenn_sember_stg_cube.kz_rueck_beur_ein is 'Status';

comment on column kenn_sember_stg_cube.hzbart_astat is 'Art der HZB (amtlich)';

comment on column kenn_sember_stg_cube.stort is 'Standort';

comment on column kenn_sember_stg_cube.stuart is 'Studienart (amtlich)';

comment on column kenn_sember_stg_cube.stufrm is 'Studienform (amtlich)';

comment on column kenn_sember_stg_cube.hrst is 'Hrerstatus (amtlich)';

comment on column kenn_sember_stg_cube.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_stgsem_cube1';

create  index ixkenn_stgsem_cube1 on kenn_sember_stg_cube (hs_nr );


select now(), 'Erzeuge Index ixkenn_stgsem_cube2';

create  index ixkenn_stgsem_cube2 on kenn_sember_stg_cube (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_stgsem_cube3';

create  index ixkenn_stgsem_cube3 on kenn_sember_stg_cube (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_stgsem_cube4';

create  index ixkenn_stgsem_cube4 on kenn_sember_stg_cube (semester );


select now(), 'Erzeuge Index ixkenn_stgsem_cube5';

create  index ixkenn_stgsem_cube5 on kenn_sember_stg_cube (abschluss );


select now(), 'Erzeuge Index ixkenn_stgsem_cube6';

create  index ixkenn_stgsem_cube6 on kenn_sember_stg_cube (hzbart_astat );


select now(), 'Erzeuge Index ixkenn_stgsem_cube7';

create  index ixkenn_stgsem_cube7 on kenn_sember_stg_cube (kz_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stgsem_cube8';

create  index ixkenn_stgsem_cube8 on kenn_sember_stg_cube (stg );


select now(), 'Tabelle kenn_sember_stg_cube erzeugt';



select now(), 'Erzeuge Tabelle kenn_antr_cube';

create table kenn_antr_cube(
	hs_nr INTEGER , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
bewsem SMALLINT , 
zul_kz INTEGER , 
abschluss_astat CHAR(10) , 
stg_astat CHAR(20) , 
stg CHAR(20) , 
antrnr SMALLINT , 
fach_sem_zahl SMALLINT , 
stort CHAR(10) , 
hzbart SMALLINT , 
summe INTEGER 
) 
;



comment on table kenn_antr_cube is 'Semesterberichte Bewerbungen';

comment on column kenn_antr_cube.hs_nr is 'Hochschulnummer';

comment on column kenn_antr_cube.fach_nr is 'Fach-Nummer';

comment on column kenn_antr_cube.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_antr_cube.ca12_staat is 'Nationalitt';

comment on column kenn_antr_cube.bewsem is 'Semester';

comment on column kenn_antr_cube.zul_kz is 'Zulassungskennzeichen';

comment on column kenn_antr_cube.abschluss_astat is 'Abschluss (amtlich)';

comment on column kenn_antr_cube.stg_astat is 'Fach (amtlich)';

comment on column kenn_antr_cube.stg is 'Hochschule und Fach (intern)';

comment on column kenn_antr_cube.antrnr is 'Antragsnummer';

comment on column kenn_antr_cube.fach_sem_zahl is 'Fachsemester';

comment on column kenn_antr_cube.stort is 'Standort';

comment on column kenn_antr_cube.hzbart is 'Art der Hochschulzugangsber.';

comment on column kenn_antr_cube.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_antr_cube1';

create  index ixkenn_antr_cube1 on kenn_antr_cube (hs_nr );


select now(), 'Erzeuge Index ixkenn_antr_cube2';

create  index ixkenn_antr_cube2 on kenn_antr_cube (fach_nr );


select now(), 'Erzeuge Index ixkenn_antr_cube3';

create  index ixkenn_antr_cube3 on kenn_antr_cube (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_antr_cube4';

create  index ixkenn_antr_cube4 on kenn_antr_cube (bewsem );


select now(), 'Erzeuge Index ixkenn_antr_cube5';

create  index ixkenn_antr_cube5 on kenn_antr_cube (abschluss_astat );


select now(), 'Erzeuge Index ixkenn_antr_cube6';

create  index ixkenn_antr_cube6 on kenn_antr_cube (stg );


select now(), 'Erzeuge Index ixkenn_antr_cube7';

create  index ixkenn_antr_cube7 on kenn_antr_cube (antrnr );


select now(), 'Tabelle kenn_antr_cube erzeugt';



select now(), 'Erzeuge Tabelle kenn_extkotr_lfb_hs';

create table kenn_extkotr_lfb_hs(
	key CHAR(10)  not null, 
hs_nr INTEGER  not null
) 
;



comment on table kenn_extkotr_lfb_hs is 'Externer Kostentrger (nur Lehr- und Forschungsbereiche) zu Hochschulen';

comment on column kenn_extkotr_lfb_hs.key is 'Externer Kostentrger (Schlssel)';

comment on column kenn_extkotr_lfb_hs.hs_nr is 'Hochschule';


select now(), 'Tabelle kenn_extkotr_lfb_hs erzeugt';



select now(), 'Erzeuge Tabelle kenn_bestand';

create table kenn_bestand(
	hs_nr INTEGER , 
bestandsart CHAR(40) , 
stichtagsart_id CHAR(40) , 
quelltabelle VARCHAR(255) , 
timeunit CHAR(1) , 
zeitwert INTEGER , 
bestand_anz INTEGER , 
bestand_datum date , 
datenherkunft VARCHAR(255) 
) 
;



comment on table kenn_bestand is 'Hilfstabelle Lieferungen pro Bestand';


select now(), 'Tabelle kenn_bestand erzeugt';



select now(), 'Erzeuge Tabelle kenn_report_stichtagsart';

create table kenn_report_stichtagsart(
	tid SERIAL  not null, 
report_id CHAR(40)  not null, 
stichtagsart_id CHAR(40)  not null, 
	constraint c_kenn_report_sticht primary key (tid)

) 
;



comment on table kenn_report_stichtagsart is 'Berichte zu Stichtagsarten';

comment on column kenn_report_stichtagsart.tid is 'Tupelidentifier';

comment on column kenn_report_stichtagsart.report_id is 'ID des Reports';

comment on column kenn_report_stichtagsart.stichtagsart_id is 'ID der Stichtagsart';


select now(), 'Tabelle kenn_report_stichtagsart erzeugt';



select now(), 'Erzeuge Tabelle kenn_bestandsart';

create table kenn_bestandsart(
	apnr CHAR(40)  not null, 
kurz VARCHAR(255) , 
druck VARCHAR(255) , 
beschreibung VARCHAR(255) , 
eingabeschema VARCHAR(255) , 
bezugsart CHAR(1)  default 'J' , 
quelltabelle VARCHAR(255) , 
zeitfeld VARCHAR(255) , 
stichtagsart_id CHAR(40)  not null, 
	constraint c_kenn_bestandsart primary key (apnr)

) 
;



comment on table kenn_bestandsart is 'Bestandsarten';

comment on column kenn_bestandsart.apnr is 'Schlssel Bestandsart';

comment on column kenn_bestandsart.bezugsart is 'Bezugsart (Semester S, Akad. Jahr A,Jahr J, Quartal Q, Monat M)';

comment on column kenn_bestandsart.stichtagsart_id is 'Schlssel Stichtagsart';


select now(), 'Tabelle kenn_bestandsart erzeugt';



select now(), 'Erzeuge Tabelle kenn_bestandsart_bland';

create table kenn_bestandsart_bland(
	tid SERIAL  not null, 
bestandsart CHAR(40)  not null, 
beschreibung VARCHAR(255) , 
eingabeschema VARCHAR(255) , 
bland CHAR(10) , 
	constraint c_kenn_bestandsart_bland primary key (tid)

) 
;



comment on table kenn_bestandsart_bland is 'Bestandsarten zu Bundeslndern';

comment on column kenn_bestandsart_bland.tid is 'Tupelidentifier';

comment on column kenn_bestandsart_bland.bestandsart is 'Schlssel Bestandsart';

comment on column kenn_bestandsart_bland.bland is 'Bundesland';


select now(), 'Tabelle kenn_bestandsart_bland erzeugt';



select now(), 'Erzeuge Tabelle kenn_promo';

create table kenn_promo(
	jahr_beginn SMALLINT , 
jahr_ende SMALLINT , 
art_ende CHAR(2) , 
koop_land_ausl CHAR(1) , 
geschlecht SMALLINT , 
extkotr CHAR(20) , 
summe INTEGER 
) 
;



comment on table kenn_promo is 'Datentabelle Promovierende: Begonnen in Jahr, Erfolgreich in Jahr, Kooperation mit anderer HS (HS-Nr. bei HS im Land, Dauer in Jahren,  Geschlecht, Summe';

comment on column kenn_promo.jahr_beginn is 'Jahr des Beginns der Promotion';

comment on column kenn_promo.jahr_ende is 'Jahr des Ende der Promotion';

comment on column kenn_promo.art_ende is 'erfolgreich (B=bestanden,NB=nicht bestanden, U=unbekannt)';

comment on column kenn_promo.koop_land_ausl is 'Staat der Koop. HS (L=Eigenes Bundesland, D=Anderes Bundesland in Deutschland, A=Ausland)';

comment on column kenn_promo.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_promo.extkotr is 'Fchergruppe';

comment on column kenn_promo.summe is 'Summe';


select now(), 'Tabelle kenn_promo erzeugt';



select now(), 'Erzeuge Tabelle kenn_promo_aggr';

create table kenn_promo_aggr(
	hs_nr INTEGER , 
jahr SMALLINT , 
jahr_beginn SMALLINT , 
jahr_ende SMALLINT , 
art_ende CHAR(2) , 
koop_land_ausl CHAR(1) , 
geschlecht SMALLINT , 
extkotr CHAR(20) , 
datum date , 
summe INTEGER , 
dauer_jahre FLOAT , 
monat_beginn SMALLINT , 
monat_ende SMALLINT , 
jahr_beginn_bezug SMALLINT , 
jahr_ende_bezug SMALLINT 
) 
;



comment on table kenn_promo_aggr is 'Hilfstabelle Promovierende: Begonnen in Jahr, Erfolgreich in Jahr, Kooperation mit anderer HS (HS-Nr. bei HS im Land, Dauer in Jahren,  Geschlecht, Summe';

comment on column kenn_promo_aggr.jahr is 'Bezugsjahr';

comment on column kenn_promo_aggr.jahr_beginn is 'Jahr des Beginns der Promotion';

comment on column kenn_promo_aggr.jahr_ende is 'Jahr des Ende der Promotion';

comment on column kenn_promo_aggr.art_ende is 'erfolgreich (B=bestanden,NB=nicht bestanden, U=unbekannt)';

comment on column kenn_promo_aggr.koop_land_ausl is 'Staat der Koop. HS (L=Eigenes Bundesland, D=Anderes Bundesland in Deutschland, A=Ausland)';

comment on column kenn_promo_aggr.geschlecht is 'Geschlecht (1 mnnl.,2 weibl.)';

comment on column kenn_promo_aggr.extkotr is 'Fchergruppe';

comment on column kenn_promo_aggr.datum is 'Datum der Erzeugung';

comment on column kenn_promo_aggr.summe is 'Summe';

comment on column kenn_promo_aggr.dauer_jahre is 'Dauer in Jahren';

comment on column kenn_promo_aggr.monat_beginn is 'Monat des Beginns der Promotion';

comment on column kenn_promo_aggr.monat_ende is 'Monat des Ende der Promotion';

comment on column kenn_promo_aggr.jahr_beginn_bezug is 'Bezugsjahr des Beginns der Promotion';

comment on column kenn_promo_aggr.jahr_ende_bezug is 'Bezugsjahr des Ende der Promotion';


select now(), 'Tabelle kenn_promo_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_stichtagsart';

create table kenn_stichtagsart(
	apnr CHAR(40)  not null, 
kurz VARCHAR(255) , 
druck VARCHAR(255) , 
beschreibung VARCHAR(255) , 
bezugsart CHAR(1)  default 'J' , 
aktiv CHAR(1)  default '1' , 
berechnen CHAR(1) , 
datum_wird_ausgewertet SMALLINT  default 0 , 
	constraint c_kenn_stichtagsart primary key (apnr)

) 
;



comment on table kenn_stichtagsart is 'Stichtagsarten';

comment on column kenn_stichtagsart.apnr is 'Schlssel Stichtagsart';

comment on column kenn_stichtagsart.bezugsart is 'Bezugsart (Semester S, Akad. Jahr A,Jahr J, Quartal Q, Monat M)';

comment on column kenn_stichtagsart.aktiv is 'Aktiv (1,0)';

comment on column kenn_stichtagsart.berechnen is 'Berechnen mglich?';

comment on column kenn_stichtagsart.datum_wird_ausgewertet is 'Datum wird ausgewertet?';


select now(), 'Tabelle kenn_stichtagsart erzeugt';



select now(), 'Erzeuge Tabelle kenn_dim_extkotr';

create table kenn_dim_extkotr(
	key CHAR(30) , 
name CHAR(255) , 
pb CHAR(30) , 
pb_str VARCHAR(255) , 
fgr CHAR(30) , 
fgr_str VARCHAR(255) , 
sb CHAR(30) , 
sb_str VARCHAR(255) , 
fach CHAR(30) , 
fach_str VARCHAR(255) , 
gueltig_von DATE , 
gueltig_bis DATE 
) 
;



comment on table kenn_dim_extkotr is 'Verzeichnis der externen Kostentrger';

comment on column kenn_dim_extkotr.key is 'Externer Kostentrgerschlssel';

comment on column kenn_dim_extkotr.name is 'Externer Kostentrgerbezeichnung';

comment on column kenn_dim_extkotr.pb is 'Produktbereich Schlssel';

comment on column kenn_dim_extkotr.pb_str is 'Produktbereich Name';

comment on column kenn_dim_extkotr.fgr is 'Produktbereich Schlssel';

comment on column kenn_dim_extkotr.fgr_str is 'Produktbereich Name';

comment on column kenn_dim_extkotr.sb is 'Produktbereich Schlssel';

comment on column kenn_dim_extkotr.sb_str is 'Produktbereich Name';

comment on column kenn_dim_extkotr.fach is 'Produktbereich Schlssel';

comment on column kenn_dim_extkotr.fach_str is 'Produktbereich Name';

comment on column kenn_dim_extkotr.gueltig_von is 'Gltig von';

comment on column kenn_dim_extkotr.gueltig_bis is 'Gltig bis';


select now(), 'Erzeuge Index ix_dim_extkotr_extkotr';

create  index ix_dim_extkotr_extkotr on kenn_dim_extkotr (fgr, 
fgr_str );


select now(), 'Tabelle kenn_dim_extkotr erzeugt';



select now(), 'Erzeuge Tabelle kenn_pkosten_cube';

create table kenn_pkosten_cube(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
bvkr_art CHAR(12) , 
klr_geldgeber CHAR(10) , 
projnr CHAR(10) , 
inst_art CHAR(20) , 
betrag double precision 
) 
;



comment on table kenn_pkosten_cube is 'Cube Primrkosten';

comment on column kenn_pkosten_cube.hs_nr is 'Hochschulnummer';

comment on column kenn_pkosten_cube.jahr is 'Jahr der Buchung';

comment on column kenn_pkosten_cube.quartal is 'Quartal der Buchung';

comment on column kenn_pkosten_cube.bvkr_art is 'Kostenart (BVKR)';

comment on column kenn_pkosten_cube.klr_geldgeber is 'Geldgeber nach KLR (Drittm.,Fremdkap.,HH)';

comment on column kenn_pkosten_cube.projnr is 'Externer Kostentrger';

comment on column kenn_pkosten_cube.inst_art is 'Externe Kostenstelle';

comment on column kenn_pkosten_cube.betrag is 'Betrag in EUR';


select now(), 'Tabelle kenn_pkosten_cube erzeugt';



select now(), 'Erzeuge Tabelle kenn_dim_extkost';

create table kenn_dim_extkost(
	hs_art CHAR(10) , 
hs_art_str VARCHAR(255) , 
hs_nr INTEGER , 
hs_nr_str VARCHAR(255) , 
kost_art VARCHAR(255) , 
extkost CHAR(40) , 
extkost_str VARCHAR(255) 
) 
;



comment on table kenn_dim_extkost is 'Verzeichnis der externen Kostenstellen';

comment on column kenn_dim_extkost.hs_art is 'Hochschulart';

comment on column kenn_dim_extkost.hs_art_str is 'Hochschulart Bezeichnung';

comment on column kenn_dim_extkost.hs_nr is 'Hochschule (Schlssel)';

comment on column kenn_dim_extkost.hs_nr_str is 'Hochschule (Name)';

comment on column kenn_dim_extkost.kost_art is 'Art der ext. Kostenstelle';

comment on column kenn_dim_extkost.extkost is 'Externe Kostenstelle (Schlssel)';

comment on column kenn_dim_extkost.extkost_str is 'Externe Kostenstelle (Name)';


select now(), 'Erzeuge Index ix_kenn_dim_extkost_hs_nr';

create  index ix_kenn_dim_extkost_hs_nr on kenn_dim_extkost (hs_nr );


select now(), 'Tabelle kenn_dim_extkost erzeugt';



select now(), 'Erzeuge Tabelle kenn_skosten_cube';

create table kenn_skosten_cube(
	hs_nr INTEGER , 
jahr SMALLINT , 
quartal INTEGER , 
projnr CHAR(10) , 
produkt CHAR(10) , 
prim_sek CHAR(10) , 
koa_block CHAR(10) , 
betrag double precision 
) 
;



comment on table kenn_skosten_cube is 'Cube Primrkosten und Verteilbuchungen';

comment on column kenn_skosten_cube.hs_nr is 'Hochschulnummer';

comment on column kenn_skosten_cube.quartal is 'Quartal der Buchung';

comment on column kenn_skosten_cube.projnr is 'Projektnr. (ext. Kostentrger)';

comment on column kenn_skosten_cube.produkt is 'Produkt';

comment on column kenn_skosten_cube.prim_sek is 'Prim./Sek.';

comment on column kenn_skosten_cube.koa_block is 'Kostenartenblock';


select now(), 'Erzeuge Index ix_kenn_skosten_cube_hs_nr';

create  index ix_kenn_skosten_cube_hs_nr on kenn_skosten_cube (hs_nr );


select now(), 'Erzeuge Index ix_kenn_skosten_cube_jahr';

create  index ix_kenn_skosten_cube_jahr on kenn_skosten_cube (jahr );


select now(), 'Erzeuge Index ix_kenn_skosten_cube_produkt';

create  index ix_kenn_skosten_cube_produkt on kenn_skosten_cube (produkt );


select now(), 'Erzeuge Index ix_kenn_skosten_cube_prim_sek';

create  index ix_kenn_skosten_cube_prim_sek on kenn_skosten_cube (prim_sek );


select now(), 'Erzeuge Index ix_kenn_skosten_cube_koa_block';

create  index ix_kenn_skosten_cube_koa_block on kenn_skosten_cube (koa_block );


select now(), 'Tabelle kenn_skosten_cube erzeugt';



select now(), 'Erzeuge Tabelle kenn_flaeche_cube';

create table kenn_flaeche_cube(
	hs_nr INTEGER , 
bund_fachgebiet CHAR(10) , 
nutzungsart CHAR(4) , 
kfanr VARCHAR(10) , 
jahr SMALLINT , 
inst_art CHAR(20) , 
flaeche decimal(15,2) 
) 
;



comment on table kenn_flaeche_cube is 'Joolap-Cube Flchen aus HISCOB (Tabl. cob_imp_flaeche)';

comment on column kenn_flaeche_cube.hs_nr is 'Hochschulnummer';

comment on column kenn_flaeche_cube.bund_fachgebiet is 'Fachgebiet';

comment on column kenn_flaeche_cube.nutzungsart is 'Raumnutzungsart';

comment on column kenn_flaeche_cube.kfanr is 'Kostenflchenart';

comment on column kenn_flaeche_cube.jahr is 'Jahr des Stichtags';

comment on column kenn_flaeche_cube.inst_art is 'Externe Kostenstelle';


select now(), 'Tabelle kenn_flaeche_cube erzeugt';



select now(), 'Erzeuge Tabelle kenn_dim_lfb_fg';

create table kenn_dim_lfb_fg(
	apnr CHAR(10) , 
drucktext CHAR(255) , 
lfb CHAR(10) , 
lfb_str CHAR(255) , 
fgr CHAR(10) , 
fgr_str CHAR(255) , 
gueltig_von DATE , 
gueltig_bis DATE 
) 
;



comment on table kenn_dim_lfb_fg is '
        Schlssel des Stat. Bundesamtes fr Lehr-Forschungsbereiche und Fachgebiete. Die Tabelle spannt eine Hierarchie auf:
        Alle
        Fchergruppe
        Lehr- und Forschungsbreich
        Fachgebiet
      ';

comment on column kenn_dim_lfb_fg.apnr is 'Fach (Schlssel)';

comment on column kenn_dim_lfb_fg.drucktext is 'Fach (Bezeichnung)';

comment on column kenn_dim_lfb_fg.lfb is 'LFB (Schlssel)';

comment on column kenn_dim_lfb_fg.lfb_str is 'LFB (Bezeichnung)';

comment on column kenn_dim_lfb_fg.fgr is 'Fchergruppe (Schlssel)';

comment on column kenn_dim_lfb_fg.fgr_str is 'Fchergruppe (Bezeichnung)';

comment on column kenn_dim_lfb_fg.gueltig_von is 'Gltig von';

comment on column kenn_dim_lfb_fg.gueltig_bis is 'Gltig von';


select now(), 'Tabelle kenn_dim_lfb_fg erzeugt';



select now(), 'Erzeuge Tabelle kenn_pbv_astat';

create table kenn_pbv_astat(
	hs_nr INTEGER , 
jahr INTEGER , 
datum DATE , 
personal_nr INTEGER , 
ernennung_jahr_ngl SMALLINT , 
ef01 INTEGER , 
ef02 VARCHAR(255) , 
ef03 VARCHAR(255) , 
ef04 VARCHAR(255) , 
ef05 VARCHAR(255) , 
ef06 VARCHAR(255) , 
ef07 VARCHAR(255) , 
ef08 VARCHAR(255) , 
ef09 VARCHAR(255) , 
ef10 VARCHAR(255) , 
ef11 VARCHAR(255) , 
ef12 VARCHAR(255) , 
ef13 VARCHAR(255) , 
ef14 VARCHAR(255) , 
ef15 VARCHAR(255) , 
ef16 VARCHAR(255) , 
ef17 VARCHAR(255) , 
ef18 VARCHAR(255) , 
ef19 VARCHAR(255) , 
ef20 VARCHAR(255) , 
ef21 VARCHAR(255) , 
ef22 VARCHAR(255) , 
ef23 INTEGER , 
ef24 VARCHAR(255) , 
ef25 INTEGER , 
ef26 INTEGER , 
ef27 VARCHAR(255) , 
ef28 VARCHAR(255) , 
ef29 VARCHAR(255) , 
ef30 INTEGER , 
ef31 VARCHAR(255) , 
ef32 VARCHAR(255) , 
ef33 VARCHAR(255) , 
ef34 VARCHAR(255) , 
ef35 VARCHAR(255) , 
ef36 INTEGER , 
ef37 INTEGER , 
ef38 VARCHAR(255) , 
ef39 VARCHAR(255) , 
ef40 VARCHAR(255) , 
ef41 VARCHAR(255) , 
ef42 VARCHAR(255) , 
ef43 VARCHAR(255) 
) 
;



comment on table kenn_pbv_astat is 'Hilfstabelle Personal amtl. Stat';

comment on column kenn_pbv_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_pbv_astat.jahr is 'Jahr';

comment on column kenn_pbv_astat.datum is 'Datum';

comment on column kenn_pbv_astat.personal_nr is 'Personalnr.';

comment on column kenn_pbv_astat.ernennung_jahr_ngl is 'Jahr bei Ernennung bei NGL';

comment on column kenn_pbv_astat.ef01 is 'ef01-Ordnungsmerkmal Satzart';

comment on column kenn_pbv_astat.ef02 is 'ef02-Berichtsland';

comment on column kenn_pbv_astat.ef03 is 'ef03-Hochschulnummer';

comment on column kenn_pbv_astat.ef04 is 'ef04-Listennummer';

comment on column kenn_pbv_astat.ef05 is 'ef05-Organisatorische Zugehrigkeit Kategorie';

comment on column kenn_pbv_astat.ef06 is 'ef06-Lehr- u. Forschungsbereich';

comment on column kenn_pbv_astat.ef07 is 'ef07-frei lassen';

comment on column kenn_pbv_astat.ef08 is 'ef08-Paginiernummer';

comment on column kenn_pbv_astat.ef09 is 'ef09-immer N';

comment on column kenn_pbv_astat.ef10 is 'ef10-Fachl. Zugehrigkeit';

comment on column kenn_pbv_astat.ef11 is 'ef11-Fachgebiet';

comment on column kenn_pbv_astat.ef12 is 'ef12-Dienstbezeichung';

comment on column kenn_pbv_astat.ef13 is 'ef13-Ttigkeit';

comment on column kenn_pbv_astat.ef14 is 'ef14-Arbeitszeit Vollzeit/Teilzeit';

comment on column kenn_pbv_astat.ef15 is 'ef15-hauptberufl. Ttigkeit';

comment on column kenn_pbv_astat.ef16 is 'ef16-Std. Anzahl';

comment on column kenn_pbv_astat.ef17 is 'ef17-Wochenstd. oder Semesterstd.';

comment on column kenn_pbv_astat.ef18 is 'ef18-Dienstverhltnis';

comment on column kenn_pbv_astat.ef19 is 'ef19-Beschftigung';

comment on column kenn_pbv_astat.ef20 is 'ef20-Laufbahngruppe';

comment on column kenn_pbv_astat.ef21 is 'ef21-Besoldungs-/ Vergtungsgruppe';

comment on column kenn_pbv_astat.ef22 is 'ef22-Art der Finanzierung';

comment on column kenn_pbv_astat.ef23 is 'ef23-Geschlecht';

comment on column kenn_pbv_astat.ef24 is 'ef24-Geburtsdatum Monat';

comment on column kenn_pbv_astat.ef25 is 'ef25-Jahr';

comment on column kenn_pbv_astat.ef26 is 'ef26-Staatsangeh.';

comment on column kenn_pbv_astat.ef27 is 'ef27-Hchster Schulabschluss';

comment on column kenn_pbv_astat.ef28 is 'ef28-Hochschule von EF27';

comment on column kenn_pbv_astat.ef29 is 'ef29-Staat von EF27';

comment on column kenn_pbv_astat.ef30 is 'ef30-Jahr des Erwerbs';

comment on column kenn_pbv_astat.ef31 is 'ef31-1. Fach des 1. Studiengang';

comment on column kenn_pbv_astat.ef32 is 'ef32-Habi. Fachgebiet d. Habi.';

comment on column kenn_pbv_astat.ef33 is 'ef33-Qualifizierung Art';

comment on column kenn_pbv_astat.ef34 is 'ef34-Verfahren';

comment on column kenn_pbv_astat.ef35 is 'ef35-Hochschule Position';

comment on column kenn_pbv_astat.ef36 is 'ef36-Jahr d. ersten Berufung auf Zeit';

comment on column kenn_pbv_astat.ef37 is 'ef37-Jahr d. ersten Berufung auf Lebenszeit';

comment on column kenn_pbv_astat.ef38 is 'ef38-Vorquali.';


select now(), 'Erzeuge Index ix_kenn_pbv_astat_hsnr';

create  index ix_kenn_pbv_astat_hsnr on kenn_pbv_astat (hs_nr );


select now(), 'Erzeuge Index ix_kenn_pbv_astat_jahr';

create  index ix_kenn_pbv_astat_jahr on kenn_pbv_astat (jahr );


select now(), 'Tabelle kenn_pbv_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_sos_astat';

create table kenn_sos_astat(
	hs_nr INTEGER , 
semester integer , 
matrikel_nr integer , 
ef001 varchar(12) , 
ef002 varchar(12) , 
ef003 varchar(12) , 
ef004 varchar(12) , 
ef005 varchar(12) , 
ef006 varchar(12) , 
ef007 varchar(12) , 
ef008u1 varchar(12) , 
ef008u2 varchar(12) , 
ef008u3 varchar(12) , 
ef009 varchar(12) , 
ef010 varchar(12) , 
ef011 varchar(12) , 
ef012u1 varchar(12) , 
ef012u2 varchar(12) , 
ef013u1 varchar(12) , 
ef013u2 varchar(12) , 
ef014 varchar(12) , 
ef015 varchar(12) , 
ef016 varchar(12) , 
ef017 varchar(12) , 
ef018 varchar(12) , 
ef019 varchar(12) , 
ef020 varchar(12) , 
ef021 varchar(12) , 
ef022 varchar(12) , 
ef023 varchar(12) , 
ef024 varchar(12) , 
ef025 varchar(12) , 
ef026 varchar(12) , 
ef027 varchar(12) , 
ef028 varchar(12) , 
ef029 varchar(12) , 
ef030 varchar(12) , 
ef031 varchar(12) , 
ef032 varchar(12) , 
ef033u1 varchar(12) , 
ef033u2 varchar(12) , 
ef034u1 varchar(12) , 
ef034u2 varchar(12) , 
ef035 varchar(12) , 
ef036 varchar(12) , 
ef037 varchar(12) , 
ef038 varchar(12) , 
ef039 varchar(12) , 
ef040 varchar(12) , 
ef041 varchar(12) , 
ef042 varchar(12) , 
ef043 varchar(12) , 
ef044 varchar(12) , 
ef045 varchar(12) , 
ef046 varchar(12) , 
ef047 varchar(12) , 
ef048 varchar(12) , 
ef049u1 varchar(12) , 
ef049u2 varchar(12) , 
ef050u1 varchar(12) , 
ef050u2 varchar(12) , 
ef051 varchar(12) , 
ef052 varchar(12) , 
ef053 varchar(12) , 
ef054 varchar(12) , 
ef055 varchar(12) , 
ef056 varchar(12) , 
ef057 varchar(12) , 
ef058 varchar(12) , 
ef059 varchar(12) , 
ef060 varchar(12) , 
ef061 varchar(12) , 
ef062 varchar(12) , 
ef063 varchar(12) , 
ef064 varchar(12) , 
ef065 varchar(12) , 
ef066 varchar(12) , 
ef067 varchar(12) , 
ef068 varchar(12) , 
ef069 varchar(12) , 
ef070 varchar(12) , 
ef071 varchar(12) , 
ef072 varchar(12) , 
ef073 varchar(12) , 
ef074 varchar(12) , 
ef075 varchar(12) , 
ef076 varchar(12) , 
ef077 varchar(12) , 
ef078 varchar(12) , 
ef079 varchar(12) , 
ef080 varchar(12) , 
ef081 varchar(12) , 
ef082 varchar(12) , 
ef083 varchar(12) , 
ef084 varchar(12) , 
ef085 varchar(12) , 
ef086 varchar(12) , 
ef087 varchar(12) , 
ef088 varchar(12) , 
ef089 varchar(12) , 
ef090 varchar(12) , 
ef091 varchar(12) , 
ef092 varchar(12) , 
ef093 varchar(12) , 
ef094 varchar(12) , 
ef095 varchar(12) , 
ef096 varchar(12) , 
ef097 varchar(12) , 
ef098 varchar(12) , 
ef099 varchar(12) , 
ef100 varchar(12) , 
ef101 varchar(12) , 
ef102 varchar(12) , 
ef103 varchar(12) , 
ef104 varchar(12) , 
ef105 varchar(12) , 
ef106 varchar(12) , 
ef107 varchar(12) , 
ef108 varchar(12) , 
ef109 varchar(12) , 
ef110 varchar(12) , 
ef111 varchar(12) , 
ef112 varchar(12) , 
ef113 varchar(12) , 
ef114 varchar(12) , 
ef115 varchar(12) , 
ef116 varchar(12) , 
ef117 varchar(12) , 
ef118 varchar(12) , 
ef119u1 varchar(12) , 
ef119u2 varchar(12) , 
ef120 varchar(12) , 
ef121 varchar(12) , 
ef122 varchar(12) , 
ef123 varchar(12) , 
ef124 varchar(12) , 
ef125 varchar(12) , 
ef126 varchar(12) , 
ef127 varchar(12) , 
ef128 varchar(12) , 
ef129 varchar(12) , 
ef130 varchar(12) , 
ef131 varchar(12) , 
ef132 varchar(12) , 
ef133 varchar(12) , 
ef134 varchar(12) , 
ef135 varchar(12) , 
ef136 varchar(12) , 
ef137 varchar(12) , 
ef138 varchar(12) , 
ef139 varchar(12) , 
ef140 varchar(12) , 
ef141 varchar(12) , 
ef142 varchar(12) , 
ef143 varchar(12) , 
ef144 varchar(12) , 
ef145 varchar(12) , 
ef146 varchar(12) , 
ef147u1 varchar(12) , 
ef147u2 varchar(12) , 
ef148 varchar(12) , 
ef149 varchar(12) , 
ef150 varchar(12) , 
ef151 varchar(12) , 
ef152 varchar(12) , 
ef153 varchar(12) , 
ef154 varchar(12) , 
ef155 varchar(12) , 
ef156 varchar(12) , 
ef157 varchar(12) , 
ef158 varchar(12) , 
ef159 varchar(12) , 
ef160 varchar(12) , 
ef161 varchar(12) , 
ef162 varchar(12) , 
ef163 varchar(12) , 
ef164 varchar(12) , 
ef165 varchar(12) , 
ef166 varchar(12) , 
ef167 varchar(12) , 
ef168 varchar(12) , 
ef169 varchar(12) , 
ef170 varchar(12) , 
ef171 varchar(12) , 
ef172 varchar(12) , 
ef173 varchar(12) , 
ef174 varchar(12) , 
ef175 varchar(12) , 
ef176 varchar(12) , 
ef177 varchar(12) , 
ef178 varchar(12) , 
ef179 varchar(12) , 
ef180 varchar(12) , 
ef181 varchar(12) , 
ef182 varchar(12) , 
ef183 varchar(12) , 
ef184u1 varchar(12) , 
ef184u2 varchar(12) , 
ef185 varchar(12) , 
ef186 varchar(12) , 
ef187 varchar(12) , 
ef188 varchar(12) , 
ef189 varchar(12) , 
ef190 varchar(12) , 
ef191 varchar(12) , 
ef192 varchar(12) , 
ef193 varchar(12) , 
ef194 varchar(12) , 
ef195 varchar(12) , 
ef196 varchar(12) , 
ef197 varchar(12) , 
ef198 varchar(12) , 
ef199 varchar(12) , 
id SERIAL  not null, 
importdatum timestamptz 
) 
;



comment on table kenn_sos_astat is 'Statistiktabelle Studierende zur Lieferung ans STALA (nach neuem Format)';

comment on column kenn_sos_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_sos_astat.semester is 'Semester';

comment on column kenn_sos_astat.matrikel_nr is 'Matrikelnr.';

comment on column kenn_sos_astat.ef001 is 'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen';

comment on column kenn_sos_astat.ef002 is 'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester';

comment on column kenn_sos_astat.ef003 is 'ef003-Berichtsjahr';

comment on column kenn_sos_astat.ef004 is 'ef004-Hochschulstandort';

comment on column kenn_sos_astat.ef005 is 'ef005-Paginiernummer';

comment on column kenn_sos_astat.ef006 is 'ef006-Matrikelnummer';

comment on column kenn_sos_astat.ef007 is 'ef007-Geschlecht 1 = mnnlich 2 = weiblich';

comment on column kenn_sos_astat.ef008u1 is 'ef008u1-Geburtsdatum - Tag';

comment on column kenn_sos_astat.ef008u2 is 'ef008u2-Geburtsdatum - Monat';

comment on column kenn_sos_astat.ef008u3 is 'ef008u3-Geburtsdatum - Jahr';

comment on column kenn_sos_astat.ef009 is 'ef009-Name (Die ersten 4 Buchstaben des Vornamens';

comment on column kenn_sos_astat.ef010 is 'ef010-Staatsangehrigkeit';

comment on column kenn_sos_astat.ef011 is 'ef011-Weitere Staatsangehrigkeit';

comment on column kenn_sos_astat.ef012u1 is 'ef012u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat.ef012u2 is 'ef012u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_sos_astat.ef013u1 is 'ef013u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat.ef013u2 is 'ef013u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_sos_astat.ef014 is 'ef014-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat';

comment on column kenn_sos_astat.ef015 is 'ef015-Frei fr StL';

comment on column kenn_sos_astat.ef016 is 'ef016-Frei fr StL';

comment on column kenn_sos_astat.ef017 is 'ef017-Hochschulstandort der Ersteinschreibung';

comment on column kenn_sos_astat.ef018 is 'ef018-Bei Ersteinschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef019 is 'ef019-Ersteinschreibung in Deutschland/Semester';

comment on column kenn_sos_astat.ef020 is 'ef020-Jahr der Ersteinschreibung';

comment on column kenn_sos_astat.ef021 is 'ef021-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt';

comment on column kenn_sos_astat.ef022 is 'ef022-Urlaubssemester';

comment on column kenn_sos_astat.ef023 is 'ef023-Praxissemester';

comment on column kenn_sos_astat.ef024 is 'ef024-Semester am Studienkolleg';

comment on column kenn_sos_astat.ef025 is 'ef025-Anzahl der Unterbrechungssemester insgesamt';

comment on column kenn_sos_astat.ef026 is 'ef026-Art der Studienunterbrechung (Nur bei Exmatrikulation)';

comment on column kenn_sos_astat.ef027 is 'ef027-Frei fr StL';

comment on column kenn_sos_astat.ef028 is 'ef028-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_sos_astat.ef029 is 'ef029-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_sos_astat.ef030 is 'ef030-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_sos_astat.ef031 is 'ef031-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_sos_astat.ef032 is 'ef032-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat.ef033u1 is 'ef033u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_sos_astat.ef033u2 is 'ef033u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_sos_astat.ef034u1 is 'ef034u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat.ef034u2 is 'ef034u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland';

comment on column kenn_sos_astat.ef035 is 'ef035-Regelstudienzeit 1. Studiengang';

comment on column kenn_sos_astat.ef036 is 'ef036-1. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat.ef037 is 'ef037-2. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat.ef038 is 'ef038-Frei fr StL';

comment on column kenn_sos_astat.ef039 is 'ef039-3. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat.ef040 is 'ef040-Frei fr StL';

comment on column kenn_sos_astat.ef041 is 'ef041-Frei fr StL';

comment on column kenn_sos_astat.ef042 is 'ef042-Frei fr StL';

comment on column kenn_sos_astat.ef043 is 'ef043-Frei fr StL';

comment on column kenn_sos_astat.ef044 is 'ef044-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_sos_astat.ef045 is 'ef045-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_sos_astat.ef046 is 'ef046-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_sos_astat.ef047 is 'ef047-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_sos_astat.ef048 is 'ef048-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat.ef049u1 is 'ef049u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_sos_astat.ef049u2 is 'ef049u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_sos_astat.ef050u1 is 'ef050u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland (2. Studiengang)';

comment on column kenn_sos_astat.ef050u2 is 'ef050u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland (2. Studiengang)';

comment on column kenn_sos_astat.ef051 is 'ef051-Regelstudienzeit 2. Studiengang';

comment on column kenn_sos_astat.ef052 is 'ef052-1. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat.ef053 is 'ef053-2. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat.ef054 is 'ef054-Frei fr StL';

comment on column kenn_sos_astat.ef055 is 'ef055-3. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat.ef056 is 'ef056-Frei fr StL';

comment on column kenn_sos_astat.ef057 is 'ef057-Frei fr StL';

comment on column kenn_sos_astat.ef058 is 'ef058-Frei fr StL';

comment on column kenn_sos_astat.ef059 is 'ef059-Frei fr StL';

comment on column kenn_sos_astat.ef060 is 'ef060-Einschreibung an einer anderen Hochschule - Hochschulstandort';

comment on column kenn_sos_astat.ef061 is 'ef061-Einschreibung an einer anderen Hochschule - Bei Einschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef062 is 'ef062-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat.ef063 is 'ef063-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat.ef064 is 'ef064-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat.ef065 is 'ef065-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat.ef066 is 'ef066-Frei fr StL';

comment on column kenn_sos_astat.ef067 is 'ef067-Frei fr StL';

comment on column kenn_sos_astat.ef068 is 'ef068-Frei fr StL';

comment on column kenn_sos_astat.ef069 is 'ef069-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen';

comment on column kenn_sos_astat.ef070 is 'ef070-Studiengang gleich dem Berichtssemster?';

comment on column kenn_sos_astat.ef071 is 'ef071-Hochschulstandort';

comment on column kenn_sos_astat.ef072 is 'ef072-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef073 is 'ef073-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat.ef074 is 'ef074-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat.ef075 is 'ef075-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat.ef076 is 'ef076-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat.ef077 is 'ef077-Frei fr StL';

comment on column kenn_sos_astat.ef078 is 'ef078-Frei fr StL';

comment on column kenn_sos_astat.ef079 is 'ef079-Frei fr StL';

comment on column kenn_sos_astat.ef080 is 'ef080-Hochschulstandort';

comment on column kenn_sos_astat.ef081 is 'ef081-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef082 is 'ef082-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat.ef083 is 'ef083-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat.ef084 is 'ef084-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat.ef085 is 'ef085-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat.ef086 is 'ef086-Frei fr StL';

comment on column kenn_sos_astat.ef087 is 'ef087-Frei fr StL';

comment on column kenn_sos_astat.ef088 is 'ef088-Frei fr StL';

comment on column kenn_sos_astat.ef089 is 'ef089-Hochschulstandort';

comment on column kenn_sos_astat.ef090 is 'ef090-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef091 is 'ef091-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef092 is 'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef093 is 'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef094 is 'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef095 is 'ef095-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef096 is 'ef096-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat.ef097 is 'ef097-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_sos_astat.ef098 is 'ef098-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00';

comment on column kenn_sos_astat.ef099 is 'ef099-Frei fr StL';

comment on column kenn_sos_astat.ef100 is 'ef100-Frei fr StL';

comment on column kenn_sos_astat.ef101 is 'ef101-Frei fr StL';

comment on column kenn_sos_astat.ef102 is 'ef102-Frei fr StL';

comment on column kenn_sos_astat.ef103 is 'ef103-Hochschulstandort';

comment on column kenn_sos_astat.ef104 is 'ef104-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule';

comment on column kenn_sos_astat.ef105 is 'ef105-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef106 is 'ef106-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef107 is 'ef107-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef108 is 'ef108-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef109 is 'ef109-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef110 is 'ef110-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat.ef111 is 'ef111-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_sos_astat.ef112 is 'ef112-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00';

comment on column kenn_sos_astat.ef113 is 'ef113-Frei fr StL';

comment on column kenn_sos_astat.ef114 is 'ef114-Frei fr StL';

comment on column kenn_sos_astat.ef115 is 'ef115-Frei fr StL';

comment on column kenn_sos_astat.ef116 is 'ef116-Frei fr StL';

comment on column kenn_sos_astat.ef117 is 'ef117-Jahr des ersten Erwerbs der HZB';

comment on column kenn_sos_astat.ef118 is 'ef118-Art der HZB';

comment on column kenn_sos_astat.ef119u1 is 'ef119u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat.ef119u2 is 'ef119u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)';

comment on column kenn_sos_astat.ef120 is 'ef120-Frei fr StL';

comment on column kenn_sos_astat.ef121 is 'ef121-Frei fr StL';

comment on column kenn_sos_astat.ef122 is 'ef122-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER';

comment on column kenn_sos_astat.ef123 is 'ef123-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER';

comment on column kenn_sos_astat.ef124 is 'ef124-Frei fr StL';

comment on column kenn_sos_astat.ef125 is 'ef125-Frei fr StL';

comment on column kenn_sos_astat.ef126 is 'ef126-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef127 is 'ef127-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef128 is 'ef128-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef129 is 'ef129-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_sos_astat.ef130 is 'ef130-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_sos_astat.ef131 is 'ef131-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_sos_astat.ef132 is 'ef132-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte';

comment on column kenn_sos_astat.ef133 is 'ef133-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132';

comment on column kenn_sos_astat.ef134 is 'ef134-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte';

comment on column kenn_sos_astat.ef135 is 'ef135-1. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef136 is 'ef136-1. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef137 is 'ef137-1. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef138 is 'ef138-1. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef139 is 'ef139-2. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef140 is 'ef140-2. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef141 is 'ef141-2. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef142 is 'ef142-2. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef143 is 'ef143-3. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef144 is 'ef144-3. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef145 is 'ef145-3. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef146 is 'ef146-3. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef147u1 is 'ef147u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Studienform';

comment on column kenn_sos_astat.ef147u2 is 'ef147u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Abschluss';

comment on column kenn_sos_astat.ef148 is 'ef148-Fr Promotionsabsolventen Art der Promotion (1. Prfung)';

comment on column kenn_sos_astat.ef149 is 'ef149-Regelstudienzeit (1. Prfung)';

comment on column kenn_sos_astat.ef150 is 'ef150-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef151 is 'ef151-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef152 is 'ef152-Frei fr StL';

comment on column kenn_sos_astat.ef153 is 'ef153-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef154 is 'ef154-Frei fr StL';

comment on column kenn_sos_astat.ef155 is 'ef155-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef156 is 'ef156-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef157 is 'ef157-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat.ef158 is 'ef158-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00';

comment on column kenn_sos_astat.ef159 is 'ef159-Frei fr StL';

comment on column kenn_sos_astat.ef160 is 'ef160-Frei fr StL';

comment on column kenn_sos_astat.ef161 is 'ef161-Frei fr StL';

comment on column kenn_sos_astat.ef162 is 'ef162-Frei fr StL';

comment on column kenn_sos_astat.ef163 is 'ef163-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef164 is 'ef164-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef165 is 'ef165-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef166 is 'ef166-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_sos_astat.ef167 is 'ef167-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_sos_astat.ef168 is 'ef168-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_sos_astat.ef169 is 'ef169-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte';

comment on column kenn_sos_astat.ef170 is 'ef170-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132';

comment on column kenn_sos_astat.ef171 is 'ef171-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte';

comment on column kenn_sos_astat.ef172 is 'ef172-1. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef173 is 'ef173-1. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef174 is 'ef174-1. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef175 is 'ef175-1. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef176 is 'ef176-2. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef177 is 'ef177-2. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef178 is 'ef178-2. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef179 is 'ef179-2. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef180 is 'ef180-3. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_sos_astat.ef181 is 'ef181-3. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_sos_astat.ef182 is 'ef182-3. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_sos_astat.ef183 is 'ef183-3. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_sos_astat.ef184u1 is 'ef184u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform';

comment on column kenn_sos_astat.ef184u2 is 'ef184u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss';

comment on column kenn_sos_astat.ef185 is 'ef185-Fr Promotionsabsolventen Art der Promotion (2. Prfung)';

comment on column kenn_sos_astat.ef186 is 'ef186-Regelstudienzeit (2. Prfung)';

comment on column kenn_sos_astat.ef187 is 'ef187-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef188 is 'ef188-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef189 is 'ef189-Frei fr StL';

comment on column kenn_sos_astat.ef190 is 'ef190-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef191 is 'ef191-Frei fr StL';

comment on column kenn_sos_astat.ef192 is 'ef192-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef193 is 'ef193-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef194 is 'ef194-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat.ef195 is 'ef195-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00';

comment on column kenn_sos_astat.ef196 is 'ef196-Frei fr StL';

comment on column kenn_sos_astat.ef197 is 'ef197-Frei fr StL';

comment on column kenn_sos_astat.ef198 is 'ef198-Frei fr StL';

comment on column kenn_sos_astat.ef199 is 'ef199-Frei fr StL';

comment on column kenn_sos_astat.id is 'id';


select now(), 'Erzeuge Index kenn_sos_astat_ix1';

create  index kenn_sos_astat_ix1 on kenn_sos_astat (matrikel_nr );


select now(), 'Erzeuge Index kenn_sos_astat_ix2';

create  index kenn_sos_astat_ix2 on kenn_sos_astat (semester );


select now(), 'Tabelle kenn_sos_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_lab_astat';

create table kenn_lab_astat(
	hs_nr INTEGER , 
semester integer , 
matrikel_nr integer , 
ef001 varchar(12) , 
ef002 varchar(12) , 
ef003 varchar(12) , 
ef004 varchar(12) , 
ef005 varchar(12) , 
ef006 varchar(12) , 
ef007 varchar(12) , 
ef008u1 varchar(12) , 
ef008u2 varchar(12) , 
ef008u3 varchar(12) , 
ef009 varchar(12) , 
ef010 varchar(12) , 
ef011 varchar(12) , 
ef012u1 varchar(12) , 
ef012u2 varchar(12) , 
ef013u1 varchar(12) , 
ef013u2 varchar(12) , 
ef014 varchar(12) , 
ef015 varchar(12) , 
ef016 varchar(12) , 
ef017 varchar(12) , 
ef018 varchar(12) , 
ef019 varchar(12) , 
ef020 varchar(12) , 
ef021 varchar(12) , 
ef022 varchar(12) , 
ef023 varchar(12) , 
ef024 varchar(12) , 
ef025 varchar(12) , 
ef026 varchar(12) , 
ef027 varchar(12) , 
ef028 varchar(12) , 
ef029 varchar(12) , 
ef030 varchar(12) , 
ef031 varchar(12) , 
ef032 varchar(12) , 
ef033u1 varchar(12) , 
ef033u2 varchar(12) , 
ef034u1 varchar(12) , 
ef034u2 varchar(12) , 
ef035 varchar(12) , 
ef036 varchar(12) , 
ef037 varchar(12) , 
ef038 varchar(12) , 
ef039 varchar(12) , 
ef040 varchar(12) , 
ef041 varchar(12) , 
ef042 varchar(12) , 
ef043 varchar(12) , 
ef044 varchar(12) , 
ef045 varchar(12) , 
ef046 varchar(12) , 
ef047 varchar(12) , 
ef048 varchar(12) , 
ef049u1 varchar(12) , 
ef049u2 varchar(12) , 
ef050u1 varchar(12) , 
ef050u2 varchar(12) , 
ef051 varchar(12) , 
ef052 varchar(12) , 
ef053 varchar(12) , 
ef054 varchar(12) , 
ef055 varchar(12) , 
ef056 varchar(12) , 
ef057 varchar(12) , 
ef058 varchar(12) , 
ef059 varchar(12) , 
ef060 varchar(12) , 
ef061 varchar(12) , 
ef062 varchar(12) , 
ef063 varchar(12) , 
ef064 varchar(12) , 
ef065 varchar(12) , 
ef066 varchar(12) , 
ef067 varchar(12) , 
ef068 varchar(12) , 
ef069 varchar(12) , 
ef070 varchar(12) , 
ef071 varchar(12) , 
ef072 varchar(12) , 
ef073 varchar(12) , 
ef074 varchar(12) , 
ef075 varchar(12) , 
ef076 varchar(12) , 
ef077 varchar(12) , 
ef078 varchar(12) , 
ef079 varchar(12) , 
ef080 varchar(12) , 
ef081 varchar(12) , 
ef082 varchar(12) , 
ef083 varchar(12) , 
ef084 varchar(12) , 
ef085 varchar(12) , 
ef086 varchar(12) , 
ef087 varchar(12) , 
ef088 varchar(12) , 
ef089 varchar(12) , 
ef090 varchar(12) , 
ef091 varchar(12) , 
ef092 varchar(12) , 
ef093 varchar(12) , 
ef094 varchar(12) , 
ef095 varchar(12) , 
ef096 varchar(12) , 
ef097 varchar(12) , 
ef098 varchar(12) , 
ef099 varchar(12) , 
ef100 varchar(12) , 
ef101 varchar(12) , 
ef102 varchar(12) , 
ef103 varchar(12) , 
ef104 varchar(12) , 
ef105 varchar(12) , 
ef106 varchar(12) , 
ef107 varchar(12) , 
ef108 varchar(12) , 
ef109 varchar(12) , 
ef110 varchar(12) , 
ef111 varchar(12) , 
ef112 varchar(12) , 
ef113 varchar(12) , 
ef114 varchar(12) , 
ef115 varchar(12) , 
ef116 varchar(12) , 
ef117 varchar(12) , 
ef118 varchar(12) , 
ef119u1 varchar(12) , 
ef119u2 varchar(12) , 
ef120 varchar(12) , 
ef121 varchar(12) , 
ef122 varchar(12) , 
ef123 varchar(12) , 
ef124 varchar(12) , 
ef125 varchar(12) , 
ef126 varchar(12) , 
ef127 varchar(12) , 
ef128 varchar(12) , 
ef129 varchar(12) , 
ef130 varchar(12) , 
ef131 varchar(12) , 
ef132 varchar(12) , 
ef133 varchar(12) , 
ef134 varchar(12) , 
ef135 varchar(12) , 
ef136 varchar(12) , 
ef137 varchar(12) , 
ef138 varchar(12) , 
ef139 varchar(12) , 
ef140 varchar(12) , 
ef141 varchar(12) , 
ef142 varchar(12) , 
ef143 varchar(12) , 
ef144 varchar(12) , 
ef145 varchar(12) , 
ef146 varchar(12) , 
ef147u1 varchar(12) , 
ef147u2 varchar(12) , 
ef148 varchar(12) , 
ef149 varchar(12) , 
ef150 varchar(12) , 
ef151 varchar(12) , 
ef152 varchar(12) , 
ef153 varchar(12) , 
ef154 varchar(12) , 
ef155 varchar(12) , 
ef156 varchar(12) , 
ef157 varchar(12) , 
ef158 varchar(12) , 
ef159 varchar(12) , 
ef160 varchar(12) , 
ef161 varchar(12) , 
ef162 varchar(12) , 
ef163 varchar(12) , 
ef164 varchar(12) , 
ef165 varchar(12) , 
ef166 varchar(12) , 
ef167 varchar(12) , 
ef168 varchar(12) , 
ef169 varchar(12) , 
ef170 varchar(12) , 
ef171 varchar(12) , 
ef172 varchar(12) , 
ef173 varchar(12) , 
ef174 varchar(12) , 
ef175 varchar(12) , 
ef176 varchar(12) , 
ef177 varchar(12) , 
ef178 varchar(12) , 
ef179 varchar(12) , 
ef180 varchar(12) , 
ef181 varchar(12) , 
ef182 varchar(12) , 
ef183 varchar(12) , 
ef184u1 varchar(12) , 
ef184u2 varchar(12) , 
ef185 varchar(12) , 
ef186 varchar(12) , 
ef187 varchar(12) , 
ef188 varchar(12) , 
ef189 varchar(12) , 
ef190 varchar(12) , 
ef191 varchar(12) , 
ef192 varchar(12) , 
ef193 varchar(12) , 
ef194 varchar(12) , 
ef195 varchar(12) , 
ef196 varchar(12) , 
ef197 varchar(12) , 
ef198 varchar(12) , 
ef199 varchar(12) , 
id SERIAL  not null, 
importdatum timestamptz 
) 
;



comment on table kenn_lab_astat is 'Statistiktabelle Absolventen zur Lieferung ans STALA (nach neuem Format)';

comment on column kenn_lab_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_lab_astat.semester is 'Semester';

comment on column kenn_lab_astat.matrikel_nr is 'Matrikelnr.';

comment on column kenn_lab_astat.ef001 is 'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen';

comment on column kenn_lab_astat.ef002 is 'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester';

comment on column kenn_lab_astat.ef003 is 'ef003-Berichtsjahr';

comment on column kenn_lab_astat.ef004 is 'ef004-Hochschulstandort';

comment on column kenn_lab_astat.ef005 is 'ef005-Paginiernummer';

comment on column kenn_lab_astat.ef006 is 'ef006-Matrikelnummer';

comment on column kenn_lab_astat.ef007 is 'ef007-Geschlecht 1 = mnnlich 2 = weiblich';

comment on column kenn_lab_astat.ef008u1 is 'ef008u1-Geburtsdatum - Tag';

comment on column kenn_lab_astat.ef008u2 is 'ef008u2-Geburtsdatum - Monat';

comment on column kenn_lab_astat.ef008u3 is 'ef008u3-Geburtsdatum - Jahr';

comment on column kenn_lab_astat.ef009 is 'ef009-Name (Die ersten 4 Buchstaben des Vornamens';

comment on column kenn_lab_astat.ef010 is 'ef010-Staatsangehrigkeit';

comment on column kenn_lab_astat.ef011 is 'ef011-Weitere Staatsangehrigkeit';

comment on column kenn_lab_astat.ef012u1 is 'ef012u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat.ef012u2 is 'ef012u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_lab_astat.ef013u1 is 'ef013u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat.ef013u2 is 'ef013u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_lab_astat.ef014 is 'ef014-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat';

comment on column kenn_lab_astat.ef015 is 'ef015-Frei fr StL';

comment on column kenn_lab_astat.ef016 is 'ef016-Frei fr StL';

comment on column kenn_lab_astat.ef017 is 'ef017-Hochschulstandort der Ersteinschreibung';

comment on column kenn_lab_astat.ef018 is 'ef018-Bei Ersteinschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef019 is 'ef019-Ersteinschreibung in Deutschland/Semester';

comment on column kenn_lab_astat.ef020 is 'ef020-Jahr der Ersteinschreibung';

comment on column kenn_lab_astat.ef021 is 'ef021-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt';

comment on column kenn_lab_astat.ef022 is 'ef022-Urlaubssemester';

comment on column kenn_lab_astat.ef023 is 'ef023-Praxissemester';

comment on column kenn_lab_astat.ef024 is 'ef024-Semester am Studienkolleg';

comment on column kenn_lab_astat.ef025 is 'ef025-Anzahl der Unterbrechungssemester insgesamt';

comment on column kenn_lab_astat.ef026 is 'ef026-Art der Studienunterbrechung (Nur bei Exmatrikulation)';

comment on column kenn_lab_astat.ef027 is 'ef027-Frei fr StL';

comment on column kenn_lab_astat.ef028 is 'ef028-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_lab_astat.ef029 is 'ef029-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_lab_astat.ef030 is 'ef030-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_lab_astat.ef031 is 'ef031-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_lab_astat.ef032 is 'ef032-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat.ef033u1 is 'ef033u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_lab_astat.ef033u2 is 'ef033u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_lab_astat.ef034u1 is 'ef034u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat.ef034u2 is 'ef034u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland';

comment on column kenn_lab_astat.ef035 is 'ef035-Regelstudienzeit 1. Studiengang';

comment on column kenn_lab_astat.ef036 is 'ef036-1. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat.ef037 is 'ef037-2. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat.ef038 is 'ef038-Frei fr StL';

comment on column kenn_lab_astat.ef039 is 'ef039-3. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat.ef040 is 'ef040-Frei fr StL';

comment on column kenn_lab_astat.ef041 is 'ef041-Frei fr StL';

comment on column kenn_lab_astat.ef042 is 'ef042-Frei fr StL';

comment on column kenn_lab_astat.ef043 is 'ef043-Frei fr StL';

comment on column kenn_lab_astat.ef044 is 'ef044-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_lab_astat.ef045 is 'ef045-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_lab_astat.ef046 is 'ef046-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_lab_astat.ef047 is 'ef047-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_lab_astat.ef048 is 'ef048-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat.ef049u1 is 'ef049u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_lab_astat.ef049u2 is 'ef049u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_lab_astat.ef050u1 is 'ef050u1-Ort der angestrebten Abschlussprfung - Bundesland bzw. "99" fr Ausland (2. Studiengang)';

comment on column kenn_lab_astat.ef050u2 is 'ef050u2-Ort der angestrebten Abschlussprfung - Kreis bei Ort in Deutschland (2. Studiengang)';

comment on column kenn_lab_astat.ef051 is 'ef051-Regelstudienzeit 2. Studiengang';

comment on column kenn_lab_astat.ef052 is 'ef052-1. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat.ef053 is 'ef053-2. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat.ef054 is 'ef054-Frei fr StL';

comment on column kenn_lab_astat.ef055 is 'ef055-3. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat.ef056 is 'ef056-Frei fr StL';

comment on column kenn_lab_astat.ef057 is 'ef057-Frei fr StL';

comment on column kenn_lab_astat.ef058 is 'ef058-Frei fr StL';

comment on column kenn_lab_astat.ef059 is 'ef059-Frei fr StL';

comment on column kenn_lab_astat.ef060 is 'ef060-Einschreibung an einer anderen Hochschule - Hochschulstandort';

comment on column kenn_lab_astat.ef061 is 'ef061-Einschreibung an einer anderen Hochschule - Bei Einschreibung an einer Hochschule ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef062 is 'ef062-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat.ef063 is 'ef063-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat.ef064 is 'ef064-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat.ef065 is 'ef065-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat.ef066 is 'ef066-Frei fr StL';

comment on column kenn_lab_astat.ef067 is 'ef067-Frei fr StL';

comment on column kenn_lab_astat.ef068 is 'ef068-Frei fr StL';

comment on column kenn_lab_astat.ef069 is 'ef069-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen';

comment on column kenn_lab_astat.ef070 is 'ef070-Studiengang gleich dem Berichtssemster?';

comment on column kenn_lab_astat.ef071 is 'ef071-Hochschulstandort';

comment on column kenn_lab_astat.ef072 is 'ef072-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef073 is 'ef073-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat.ef074 is 'ef074-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat.ef075 is 'ef075-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat.ef076 is 'ef076-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat.ef077 is 'ef077-Frei fr StL';

comment on column kenn_lab_astat.ef078 is 'ef078-Frei fr StL';

comment on column kenn_lab_astat.ef079 is 'ef079-Frei fr StL';

comment on column kenn_lab_astat.ef080 is 'ef080-Hochschulstandort';

comment on column kenn_lab_astat.ef081 is 'ef081-Wenn Hochschule im vorhergehenden Semester ausserhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef082 is 'ef082-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat.ef083 is 'ef083-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat.ef084 is 'ef084-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat.ef085 is 'ef085-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat.ef086 is 'ef086-Frei fr StL';

comment on column kenn_lab_astat.ef087 is 'ef087-Frei fr StL';

comment on column kenn_lab_astat.ef088 is 'ef088-Frei fr StL';

comment on column kenn_lab_astat.ef089 is 'ef089-Hochschulstandort';

comment on column kenn_lab_astat.ef090 is 'ef090-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef091 is 'ef091-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef092 is 'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef093 is 'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef094 is 'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef095 is 'ef095-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef096 is 'ef096-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat.ef097 is 'ef097-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_lab_astat.ef098 is 'ef098-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00';

comment on column kenn_lab_astat.ef099 is 'ef099-Frei fr StL';

comment on column kenn_lab_astat.ef100 is 'ef100-Frei fr StL';

comment on column kenn_lab_astat.ef101 is 'ef101-Frei fr StL';

comment on column kenn_lab_astat.ef102 is 'ef102-Frei fr StL';

comment on column kenn_lab_astat.ef103 is 'ef103-Hochschulstandort';

comment on column kenn_lab_astat.ef104 is 'ef104-Wenn Hochschule einer bereits abgelegten Abschlussprfung auerhalb Deutschlands der Staat der Hochschule';

comment on column kenn_lab_astat.ef105 is 'ef105-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef106 is 'ef106-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef107 is 'ef107-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef108 is 'ef108-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef109 is 'ef109-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef110 is 'ef110-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat.ef111 is 'ef111-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_lab_astat.ef112 is 'ef112-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00';

comment on column kenn_lab_astat.ef113 is 'ef113-Frei fr StL';

comment on column kenn_lab_astat.ef114 is 'ef114-Frei fr StL';

comment on column kenn_lab_astat.ef115 is 'ef115-Frei fr StL';

comment on column kenn_lab_astat.ef116 is 'ef116-Frei fr StL';

comment on column kenn_lab_astat.ef117 is 'ef117-Jahr des ersten Erwerbs der HZB';

comment on column kenn_lab_astat.ef118 is 'ef118-Art der HZB';

comment on column kenn_lab_astat.ef119u1 is 'ef119u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat.ef119u2 is 'ef119u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)';

comment on column kenn_lab_astat.ef120 is 'ef120-Frei fr StL';

comment on column kenn_lab_astat.ef121 is 'ef121-Frei fr StL';

comment on column kenn_lab_astat.ef122 is 'ef122-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER';

comment on column kenn_lab_astat.ef123 is 'ef123-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER';

comment on column kenn_lab_astat.ef124 is 'ef124-Frei fr StL';

comment on column kenn_lab_astat.ef125 is 'ef125-Frei fr StL';

comment on column kenn_lab_astat.ef126 is 'ef126-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef127 is 'ef127-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef128 is 'ef128-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef129 is 'ef129-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_lab_astat.ef130 is 'ef130-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_lab_astat.ef131 is 'ef131-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_lab_astat.ef132 is 'ef132-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte';

comment on column kenn_lab_astat.ef133 is 'ef133-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132';

comment on column kenn_lab_astat.ef134 is 'ef134-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (1. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte';

comment on column kenn_lab_astat.ef135 is 'ef135-1. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef136 is 'ef136-1. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef137 is 'ef137-1. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef138 is 'ef138-1. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef139 is 'ef139-2. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef140 is 'ef140-2. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef141 is 'ef141-2. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef142 is 'ef142-2. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef143 is 'ef143-3. Auslandsaufenthalt 1. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef144 is 'ef144-3. Auslandsaufenthalt 1. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef145 is 'ef145-3. Auslandsaufenthalt 1. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef146 is 'ef146-3. Auslandsaufenthalt 1. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef147u1 is 'ef147u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Studienform';

comment on column kenn_lab_astat.ef147u2 is 'ef147u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)- Abschluss';

comment on column kenn_lab_astat.ef148 is 'ef148-Fr Promotionsabsolventen Art der Promotion (1. Prfung)';

comment on column kenn_lab_astat.ef149 is 'ef149-Regelstudienzeit (1. Prfung)';

comment on column kenn_lab_astat.ef150 is 'ef150-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef151 is 'ef151-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef152 is 'ef152-Frei fr StL';

comment on column kenn_lab_astat.ef153 is 'ef153-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef154 is 'ef154-Frei fr StL';

comment on column kenn_lab_astat.ef155 is 'ef155-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef156 is 'ef156-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef157 is 'ef157-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat.ef158 is 'ef158-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00';

comment on column kenn_lab_astat.ef159 is 'ef159-Frei fr StL';

comment on column kenn_lab_astat.ef160 is 'ef160-Frei fr StL';

comment on column kenn_lab_astat.ef161 is 'ef161-Frei fr StL';

comment on column kenn_lab_astat.ef162 is 'ef162-Frei fr StL';

comment on column kenn_lab_astat.ef163 is 'ef163-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef164 is 'ef164-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef165 is 'ef165-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef166 is 'ef166-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_lab_astat.ef167 is 'ef167-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_lab_astat.ef168 is 'ef168-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_lab_astat.ef169 is 'ef169-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - Anzahl der fr den Studiengang anerkannten ECTS-Punkte';

comment on column kenn_lab_astat.ef170 is 'ef170-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - beruflicher Qualifikationen "Darunter-Position" von EF132';

comment on column kenn_lab_astat.ef171 is 'ef171-seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en) (2. Prfung) - im Ausland erworbenen anerkannte ECTS-Punkte';

comment on column kenn_lab_astat.ef172 is 'ef172-1. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef173 is 'ef173-1. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef174 is 'ef174-1. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef175 is 'ef175-1. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef176 is 'ef176-2. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef177 is 'ef177-2. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef178 is 'ef178-2. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef179 is 'ef179-2. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef180 is 'ef180-3. Auslandsaufenthalt 2. Prfung - Staat des Auslandsaufenthalts';

comment on column kenn_lab_astat.ef181 is 'ef181-3. Auslandsaufenthalt 2. Prfung - Dauer des Aufenthaltes in Monaten';

comment on column kenn_lab_astat.ef182 is 'ef182-3. Auslandsaufenthalt 2. Prfung - Art des Auslandsaufenthaltes';

comment on column kenn_lab_astat.ef183 is 'ef183-3. Auslandsaufenthalt 2. Prfung - Art des Mobilittsprogramm';

comment on column kenn_lab_astat.ef184u1 is 'ef184u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform';

comment on column kenn_lab_astat.ef184u2 is 'ef184u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss';

comment on column kenn_lab_astat.ef185 is 'ef185-Fr Promotionsabsolventen Art der Promotion (2. Prfung)';

comment on column kenn_lab_astat.ef186 is 'ef186-Regelstudienzeit (2. Prfung)';

comment on column kenn_lab_astat.ef187 is 'ef187-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef188 is 'ef188-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef189 is 'ef189-Frei fr StL';

comment on column kenn_lab_astat.ef190 is 'ef190-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef191 is 'ef191-Frei fr StL';

comment on column kenn_lab_astat.ef192 is 'ef192-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef193 is 'ef193-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef194 is 'ef194-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat.ef195 is 'ef195-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00';

comment on column kenn_lab_astat.ef196 is 'ef196-Frei fr StL';

comment on column kenn_lab_astat.ef197 is 'ef197-Frei fr StL';

comment on column kenn_lab_astat.ef198 is 'ef198-Frei fr StL';

comment on column kenn_lab_astat.ef199 is 'ef199-Frei fr StL';

comment on column kenn_lab_astat.id is 'id';


select now(), 'Erzeuge Index kenn_lab_astat_ix1';

create  index kenn_lab_astat_ix1 on kenn_lab_astat (ef006 );


select now(), 'Erzeuge Index kenn_lab_astat_ix2';

create  index kenn_lab_astat_ix2 on kenn_lab_astat (ef002, 
ef003 );


select now(), 'Tabelle kenn_lab_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_stg_aggr_astat';

create table kenn_stg_aggr_astat(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_rueck_beur_ein SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
fgr CHAR(10) , 
abgrp CHAR(255) , 
regel SMALLINT , 
kz_rueck_beur_ein SMALLINT , 
fach_sem_zahl SMALLINT , 
hssem SMALLINT , 
stort CHAR(10) , 
stuart CHAR(10) , 
stufrm CHAR(10) , 
hzbart_astat CHAR(10) , 
hzbkfzkz CHAR(2) , 
hrst CHAR(10) , 
letzte_pruefung_stort CHAR(10) , 
letzte_pruefung_staat SMALLINT , 
letzte_pruefung_abschluss CHAR(2) , 
letzte_pruefung_ergebnis SMALLINT , 
vorletzte_pruefung_stort CHAR(10) , 
vorletzte_pruefung_staat SMALLINT , 
vorletzte_pruefung_abschluss CHAR(2) , 
vorletzte_pruefung_ergebnis SMALLINT , 
datum date , 
summe INTEGER , 
stg_land CHAR(4) 
) 
;



comment on table kenn_stg_aggr_astat is 'Hilfstabelle Studierendenstatistik (amtl.)';

comment on column kenn_stg_aggr_astat.hs_nr is 'Hochschule';

comment on column kenn_stg_aggr_astat.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_stg_aggr_astat.fach_nr is 'Fach-Nummer';

comment on column kenn_stg_aggr_astat.geschlecht is 'Geschlecht';

comment on column kenn_stg_aggr_astat.ca12_staat is 'Nationalitt';

comment on column kenn_stg_aggr_astat.sem_rueck_beur_ein is 'Semester';

comment on column kenn_stg_aggr_astat.stg is 'Fach (amtlich)';

comment on column kenn_stg_aggr_astat.abschluss is 'Abschluss (amtlich)';

comment on column kenn_stg_aggr_astat.fgr is 'Fchergruppe';

comment on column kenn_stg_aggr_astat.abgrp is 'Abschlussart';

comment on column kenn_stg_aggr_astat.regel is 'Regelstudienzeit';

comment on column kenn_stg_aggr_astat.kz_rueck_beur_ein is 'Einschreib- oder Rckmeldestatus';

comment on column kenn_stg_aggr_astat.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_stg_aggr_astat.hssem is 'Anzahl Hochschulsemester';

comment on column kenn_stg_aggr_astat.stort is 'Standort';

comment on column kenn_stg_aggr_astat.stuart is 'Studienart (amtlich)';

comment on column kenn_stg_aggr_astat.stufrm is 'Studienform (amtlich)';

comment on column kenn_stg_aggr_astat.hzbart_astat is 'Hochschulzugangsberechtigung Art';

comment on column kenn_stg_aggr_astat.hzbkfzkz is 'Hochschulzugangsberechtigung Land';

comment on column kenn_stg_aggr_astat.hrst is 'Hrerstatus';

comment on column kenn_stg_aggr_astat.letzte_pruefung_stort is 'Letzte Externe Prfung Hochschule/Standort';

comment on column kenn_stg_aggr_astat.letzte_pruefung_staat is 'Letzte Externe Prfung Staat';

comment on column kenn_stg_aggr_astat.letzte_pruefung_abschluss is 'Letzte Externe Prfung Abschluss (amtlich)';

comment on column kenn_stg_aggr_astat.letzte_pruefung_ergebnis is 'Letzte Externe Prfung Prfungsergebnis';

comment on column kenn_stg_aggr_astat.vorletzte_pruefung_stort is 'Vorletzte Externe Prfung Hochschule/Standort';

comment on column kenn_stg_aggr_astat.vorletzte_pruefung_staat is 'Vorletzte Externe Prfung Staat';

comment on column kenn_stg_aggr_astat.vorletzte_pruefung_abschluss is 'Vorletzte Externe Prfung Abschluss (amtlich)';

comment on column kenn_stg_aggr_astat.vorletzte_pruefung_ergebnis is 'Vorletzte Externe Prfung Prfungsergebnis';

comment on column kenn_stg_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_stg_aggr_astat.summe is 'Summe';

comment on column kenn_stg_aggr_astat.stg_land is 'Fach Land (amtlich)';


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat1';

create  index ixkenn_stg_aggr_astat1 on kenn_stg_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat2';

create  index ixkenn_stg_aggr_astat2 on kenn_stg_aggr_astat (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat3';

create  index ixkenn_stg_aggr_astat3 on kenn_stg_aggr_astat (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat4';

create  index ixkenn_stg_aggr_astat4 on kenn_stg_aggr_astat (sem_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat5';

create  index ixkenn_stg_aggr_astat5 on kenn_stg_aggr_astat (abgrp );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat6';

create  index ixkenn_stg_aggr_astat6 on kenn_stg_aggr_astat (hzbart_astat );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat7';

create  index ixkenn_stg_aggr_astat7 on kenn_stg_aggr_astat (kz_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stg_aggr_astat8';

create  index ixkenn_stg_aggr_astat8 on kenn_stg_aggr_astat (fgr );


select now(), 'Tabelle kenn_stg_aggr_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_stud_aggr_astat';

create table kenn_stud_aggr_astat(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht CHAR(10) , 
bildungstyp CHAR(10) , 
sem_rueck_beur_ein SMALLINT , 
stg CHAR(4) , 
stg_land CHAR(4) , 
abschlusstyp CHAR(10) , 
regel SMALLINT , 
fach_sem_zahl SMALLINT , 
hssem_1 CHAR(10) , 
aufbaustudium CHAR(10) , 
hrst CHAR(10) , 
datum date , 
summe INTEGER 
) 
;



comment on table kenn_stud_aggr_astat is 'Hilfstabelle Studierendenstatistik (amtl.) fr Semesterberichte Unis BaWue';

comment on column kenn_stud_aggr_astat.hs_nr is 'Hochschule';

comment on column kenn_stud_aggr_astat.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_stud_aggr_astat.fach_nr is 'Fach-Nummer';

comment on column kenn_stud_aggr_astat.geschlecht is 'Geschlecht';

comment on column kenn_stud_aggr_astat.bildungstyp is 'Bildungstyp';

comment on column kenn_stud_aggr_astat.sem_rueck_beur_ein is 'Semester';

comment on column kenn_stud_aggr_astat.stg is 'Fach (amtlich)';

comment on column kenn_stud_aggr_astat.stg_land is 'Fach Land (amtlich)';

comment on column kenn_stud_aggr_astat.abschlusstyp is 'Abschlusstyp';

comment on column kenn_stud_aggr_astat.regel is 'Regelstudienzeit';

comment on column kenn_stud_aggr_astat.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_stud_aggr_astat.hssem_1 is '1. Hochschulsemester';

comment on column kenn_stud_aggr_astat.aufbaustudium is 'Ist Aufbaustudium';

comment on column kenn_stud_aggr_astat.hrst is 'Hrerstatus';

comment on column kenn_stud_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_stud_aggr_astat.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat1';

create  index ixkenn_stud_aggr_astat1 on kenn_stud_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat2';

create  index ixkenn_stud_aggr_astat2 on kenn_stud_aggr_astat (fach_nr );


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat3';

create  index ixkenn_stud_aggr_astat3 on kenn_stud_aggr_astat (geschlecht, 
bildungstyp );


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat4';

create  index ixkenn_stud_aggr_astat4 on kenn_stud_aggr_astat (sem_rueck_beur_ein );


select now(), 'Erzeuge Index ixkenn_stud_aggr_astat5';

create  index ixkenn_stud_aggr_astat5 on kenn_stud_aggr_astat (abschlusstyp );


select now(), 'Tabelle kenn_stud_aggr_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_lab_aggr_astat';

create table kenn_lab_aggr_astat(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_der_pruefung SMALLINT , 
stg CHAR(4) , 
abschluss CHAR(2) , 
fgr CHAR(10) , 
abgrp CHAR(255) , 
regel SMALLINT , 
fach_sem_zahl SMALLINT , 
hzbart_astat CHAR(10) , 
hzbkfzkz CHAR(2) , 
stort CHAR(10) , 
stufrm CHAR(10) , 
pruefung_monat SMALLINT , 
pruefung_jahr SMALLINT , 
pruefung_ergebnis SMALLINT , 
ausland SMALLINT , 
datum date , 
summe INTEGER , 
stg_land CHAR(4) 
) 
;



comment on table kenn_lab_aggr_astat is 'Hilfstabelle Prfungsstatistik (amtl.)';

comment on column kenn_lab_aggr_astat.hs_nr is 'Hochschule';

comment on column kenn_lab_aggr_astat.studiengang_nr is 'Studiengang-Nummer';

comment on column kenn_lab_aggr_astat.fach_nr is 'Fach-Nummer';

comment on column kenn_lab_aggr_astat.geschlecht is 'Geschlecht';

comment on column kenn_lab_aggr_astat.ca12_staat is 'Nationalitt';

comment on column kenn_lab_aggr_astat.sem_der_pruefung is 'Semester';

comment on column kenn_lab_aggr_astat.stg is 'Fach (amtlich)';

comment on column kenn_lab_aggr_astat.abschluss is 'Abschluss (amtlich)';

comment on column kenn_lab_aggr_astat.fgr is 'Fchergruppe';

comment on column kenn_lab_aggr_astat.abgrp is 'Abschlussart';

comment on column kenn_lab_aggr_astat.regel is 'Regelstudienzeit';

comment on column kenn_lab_aggr_astat.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_lab_aggr_astat.hzbart_astat is 'Hochschulzugangsberechtigung Art';

comment on column kenn_lab_aggr_astat.hzbkfzkz is 'Hochschulzugangsberechtigung Land';

comment on column kenn_lab_aggr_astat.stort is 'Standort';

comment on column kenn_lab_aggr_astat.stufrm is 'Studienform (amtlich)';

comment on column kenn_lab_aggr_astat.pruefung_monat is 'Monat der Prfung';

comment on column kenn_lab_aggr_astat.pruefung_jahr is 'Jahr der Prfung';

comment on column kenn_lab_aggr_astat.pruefung_ergebnis is 'Prfungsergebnis';

comment on column kenn_lab_aggr_astat.ausland is 'Studienbezogene Auslandsaufenthalte';

comment on column kenn_lab_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_lab_aggr_astat.summe is 'Summe';

comment on column kenn_lab_aggr_astat.stg_land is 'Fach Land (amtlich)';


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat1';

create  index ixkenn_lab_aggr_astat1 on kenn_lab_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat2';

create  index ixkenn_lab_aggr_astat2 on kenn_lab_aggr_astat (studiengang_nr, 
fach_nr );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat3';

create  index ixkenn_lab_aggr_astat3 on kenn_lab_aggr_astat (geschlecht, 
ca12_staat );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat4';

create  index ixkenn_lab_aggr_astat4 on kenn_lab_aggr_astat (sem_der_pruefung );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat5';

create  index ixkenn_lab_aggr_astat5 on kenn_lab_aggr_astat (abgrp );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat6';

create  index ixkenn_lab_aggr_astat6 on kenn_lab_aggr_astat (hzbart_astat );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat7';

create  index ixkenn_lab_aggr_astat7 on kenn_lab_aggr_astat (pruefung_ergebnis );


select now(), 'Erzeuge Index ixkenn_lab_aggr_astat8';

create  index ixkenn_lab_aggr_astat8 on kenn_lab_aggr_astat (fgr );


select now(), 'Tabelle kenn_lab_aggr_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_absolv_aggr_astat';

create table kenn_absolv_aggr_astat(
	hs_nr INTEGER , 
fach_nr SMALLINT , 
geschlecht CHAR(10) , 
bildungstyp CHAR(10) , 
sem_der_pruefung SMALLINT , 
stg CHAR(4) , 
stg_land CHAR(4) , 
abschlusstyp CHAR(10) , 
regel SMALLINT , 
fach_sem_zahl SMALLINT , 
aufbaustudium CHAR(10) , 
datum date , 
summe INTEGER 
) 
;



comment on table kenn_absolv_aggr_astat is 'Hilfstabelle Prfungsstatistik (amtl.) fr Semesterberichte Unis BaWue';

comment on column kenn_absolv_aggr_astat.hs_nr is 'Hochschule';

comment on column kenn_absolv_aggr_astat.fach_nr is 'Fach-Nummer';

comment on column kenn_absolv_aggr_astat.geschlecht is 'Geschlecht';

comment on column kenn_absolv_aggr_astat.bildungstyp is 'Bildungstyp';

comment on column kenn_absolv_aggr_astat.sem_der_pruefung is 'Semester';

comment on column kenn_absolv_aggr_astat.stg is 'Fach (amtlich)';

comment on column kenn_absolv_aggr_astat.stg_land is 'Fach Land (amtlich)';

comment on column kenn_absolv_aggr_astat.abschlusstyp is 'Abschlusstyp';

comment on column kenn_absolv_aggr_astat.regel is 'Regelstudienzeit';

comment on column kenn_absolv_aggr_astat.fach_sem_zahl is 'Anzahl Fachsemester';

comment on column kenn_absolv_aggr_astat.aufbaustudium is 'Ist Aufbaustudium';

comment on column kenn_absolv_aggr_astat.datum is 'Datum der Erzeugung';

comment on column kenn_absolv_aggr_astat.summe is 'Summe';


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat1';

create  index ixkenn_absolv_aggr_astat1 on kenn_absolv_aggr_astat (hs_nr );


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat2';

create  index ixkenn_absolv_aggr_astat2 on kenn_absolv_aggr_astat (fach_nr );


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat3';

create  index ixkenn_absolv_aggr_astat3 on kenn_absolv_aggr_astat (geschlecht, 
bildungstyp );


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat4';

create  index ixkenn_absolv_aggr_astat4 on kenn_absolv_aggr_astat (sem_der_pruefung );


select now(), 'Erzeuge Index ixkenn_absolv_aggr_astat5';

create  index ixkenn_absolv_aggr_astat5 on kenn_absolv_aggr_astat (abschlusstyp );


select now(), 'Tabelle kenn_absolv_aggr_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_dim_fgr';

create table kenn_dim_fgr(
	apnr CHAR(10) , 
drucktext CHAR(255) , 
fg_personal CHAR(10) , 
fg_studierende CHAR(10) , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint c_kenn_dim_fgr_apnr primary key (apnr)

) 
;



comment on table kenn_dim_fgr is 'Schlssel des Stat. Bundesamtes fr Fchergruppen (Studierende und Personal)';

comment on column kenn_dim_fgr.apnr is 'Fchergruppe (Schlssel)';

comment on column kenn_dim_fgr.drucktext is 'Fchergruppe (Bezeichnung)';

comment on column kenn_dim_fgr.fg_personal is 'Fchergruppe Personal (Schlssel)';

comment on column kenn_dim_fgr.fg_studierende is 'Fchergruppe Studierende (Schlssel)';

comment on column kenn_dim_fgr.gueltig_von is 'Gltig von';

comment on column kenn_dim_fgr.gueltig_bis is 'Gltig von';


select now(), 'Tabelle kenn_dim_fgr erzeugt';



select now(), 'Erzeuge Tabelle kenn_sos_astat_2015';

create table kenn_sos_astat_2015(
	hs_nr INTEGER , 
semester integer , 
matrikel_nr integer , 
ef001 varchar(12) , 
ef002 varchar(12) , 
ef003 varchar(12) , 
ef004 varchar(12) , 
ef005 varchar(12) , 
ef006 varchar(12) , 
ef007 varchar(12) , 
ef008u1 varchar(12) , 
ef008u2 varchar(12) , 
ef009 varchar(12) , 
ef010u1 varchar(12) , 
ef010u2 varchar(12) , 
ef011u1 varchar(12) , 
ef011u2 varchar(12) , 
ef012 varchar(12) , 
ef013 varchar(12) , 
ef014 varchar(12) , 
ef015 varchar(12) , 
ef016 varchar(12) , 
ef017 varchar(12) , 
ef018 varchar(12) , 
ef019 varchar(12) , 
ef020 varchar(12) , 
ef021 varchar(12) , 
ef022 varchar(12) , 
ef023 varchar(12) , 
ef024 varchar(12) , 
ef025 varchar(12) , 
ef026 varchar(12) , 
ef027 varchar(12) , 
ef028 varchar(12) , 
ef029 varchar(12) , 
ef030 varchar(12) , 
ef031u1 varchar(12) , 
ef031u2 varchar(12) , 
ef032 varchar(12) , 
ef033 varchar(12) , 
ef034 varchar(12) , 
ef035 varchar(12) , 
ef036 varchar(12) , 
ef037 varchar(12) , 
ef038 varchar(12) , 
ef039 varchar(12) , 
ef040 varchar(12) , 
ef041 varchar(12) , 
ef042 varchar(12) , 
ef043 varchar(12) , 
ef044 varchar(12) , 
ef045 varchar(12) , 
ef046u1 varchar(12) , 
ef046u2 varchar(12) , 
ef047 varchar(12) , 
ef048 varchar(12) , 
ef049 varchar(12) , 
ef050 varchar(12) , 
ef051 varchar(12) , 
ef052 varchar(12) , 
ef053 varchar(12) , 
ef054 varchar(12) , 
ef055 varchar(12) , 
ef056 varchar(12) , 
ef057 varchar(12) , 
ef058 varchar(12) , 
ef059u1 varchar(12) , 
ef059u2 varchar(12) , 
ef060 varchar(12) , 
ef061 varchar(12) , 
ef062 varchar(12) , 
ef063 varchar(12) , 
ef064 varchar(12) , 
ef065 varchar(12) , 
ef066 varchar(12) , 
ef067 varchar(12) , 
ef068 varchar(12) , 
ef069u2 varchar(12) , 
ef069u1 varchar(12) , 
ef070 varchar(12) , 
ef071 varchar(12) , 
ef072 varchar(12) , 
ef073 varchar(12) , 
ef074 varchar(12) , 
ef075 varchar(12) , 
ef076 varchar(12) , 
ef077u1 varchar(12) , 
ef077u2 varchar(12) , 
ef078 varchar(12) , 
ef079 varchar(12) , 
ef080 varchar(12) , 
ef081 varchar(12) , 
ef082 varchar(12) , 
ef083 varchar(12) , 
ef084 varchar(12) , 
ef085 varchar(12) , 
ef086 varchar(12) , 
ef087 varchar(12) , 
ef088 varchar(12) , 
ef089 varchar(12) , 
ef090 varchar(12) , 
ef091u1 varchar(12) , 
ef091u2 varchar(12) , 
ef092 varchar(12) , 
ef093 varchar(12) , 
ef094 varchar(12) , 
ef095 varchar(12) , 
ef096 varchar(12) , 
ef097 varchar(12) , 
ef098 varchar(12) , 
ef099 varchar(12) , 
ef100u1 varchar(12) , 
ef100u2 varchar(12) , 
ef101 varchar(12) , 
ef102 varchar(12) , 
ef103 varchar(12) , 
ef104 varchar(12) , 
ef105 varchar(12) , 
ef106 varchar(12) , 
ef107 varchar(12) , 
ef108 varchar(12) , 
ef109 varchar(12) , 
ef110 varchar(12) , 
ef111u1 varchar(12) , 
ef111u2 varchar(12) , 
ef112 varchar(12) , 
ef113 varchar(12) , 
ef114 varchar(12) , 
ef115 varchar(12) , 
ef116 varchar(12) , 
ef117 varchar(12) , 
ef118 varchar(12) , 
ef119 varchar(12) , 
ef120 varchar(12) , 
ef121 varchar(12) , 
ef122 varchar(12) , 
ef123 varchar(12) , 
ef124 varchar(12) , 
ef125 varchar(12) , 
ef126u1 varchar(12) , 
ef126u2 varchar(12) , 
ef127 varchar(12) , 
ef128 varchar(12) , 
ef129 varchar(12) , 
ef130 varchar(12) , 
ef131 varchar(12) , 
ef132 varchar(12) , 
ef133 varchar(12) , 
ef134 varchar(12) , 
ef135 varchar(12) , 
ef136 varchar(12) , 
ef137 varchar(12) , 
ef138 varchar(12) , 
ef139 varchar(12) , 
ef140 varchar(12) , 
ef141 varchar(12) , 
ef142u1 varchar(12) , 
ef142u2 varchar(12) , 
ef143 varchar(12) , 
ef144 varchar(12) , 
ef145 varchar(12) , 
ef146 varchar(12) , 
ef147 varchar(12) , 
ef148 varchar(12) , 
ef149 varchar(12) , 
ef150 varchar(12) , 
ef151 varchar(12) , 
ef152 varchar(12) , 
id SERIAL  not null, 
	constraint pk_sos_astat_2015_id primary key (id)

) 
;



comment on table kenn_sos_astat_2015 is 'Statistiktabelle Studierende zur Lieferung ans STALA (nach altem Format bis 2016)';

comment on column kenn_sos_astat_2015.hs_nr is 'Hochschulnummer';

comment on column kenn_sos_astat_2015.semester is 'Semester';

comment on column kenn_sos_astat_2015.matrikel_nr is 'Matrikelnr.';

comment on column kenn_sos_astat_2015.ef001 is 'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen';

comment on column kenn_sos_astat_2015.ef002 is 'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester';

comment on column kenn_sos_astat_2015.ef003 is 'ef003-Berichtsjahr';

comment on column kenn_sos_astat_2015.ef004 is 'ef004-Hochschule';

comment on column kenn_sos_astat_2015.ef005 is 'ef005-Paginiernummer';

comment on column kenn_sos_astat_2015.ef006 is 'ef006-Matrikelnummer';

comment on column kenn_sos_astat_2015.ef007 is 'ef007-Geschlecht 1 = mnnlich 2 = weiblich';

comment on column kenn_sos_astat_2015.ef008u1 is 'ef008u1-Geburtsdatum - Monat';

comment on column kenn_sos_astat_2015.ef008u2 is 'ef008u2-Geburtsdatum - Jahr';

comment on column kenn_sos_astat_2015.ef009 is 'ef009-Staatsangehrigkeit';

comment on column kenn_sos_astat_2015.ef010u1 is 'ef010u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat_2015.ef010u2 is 'ef010u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_sos_astat_2015.ef011u1 is 'ef011u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat_2015.ef011u2 is 'ef011u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_sos_astat_2015.ef012 is 'ef012-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat';

comment on column kenn_sos_astat_2015.ef013 is 'ef013-Frei fr StL';

comment on column kenn_sos_astat_2015.ef014 is 'ef014-Frei fr StL';

comment on column kenn_sos_astat_2015.ef015 is 'ef015-Frei fr StL';

comment on column kenn_sos_astat_2015.ef016 is 'ef016-Hochschule der Ersteinschreibung';

comment on column kenn_sos_astat_2015.ef017 is 'ef017-Ersteinschreibung in Deutschland/Semester';

comment on column kenn_sos_astat_2015.ef018 is 'ef018-Jahr der Ersteinschreibung';

comment on column kenn_sos_astat_2015.ef019 is 'ef019-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt';

comment on column kenn_sos_astat_2015.ef020 is 'ef020-Urlaubssemester';

comment on column kenn_sos_astat_2015.ef021 is 'ef021-Praxissemester';

comment on column kenn_sos_astat_2015.ef022 is 'ef022-- Semester in der DDR bzw. Berlin (Ost) (einschl. Urlaubssemester)';

comment on column kenn_sos_astat_2015.ef023 is 'ef023-Nur bei Studium in der DDR bzw. Berlin (Ost) Art des Studiums 1 = Prsenzstudium 2 = Fernstudium';

comment on column kenn_sos_astat_2015.ef024 is 'ef024-Semester am Studienkolleg';

comment on column kenn_sos_astat_2015.ef025 is 'ef025-Anzahl der Unterbrechungssemester insgesamt';

comment on column kenn_sos_astat_2015.ef026 is 'ef026-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_sos_astat_2015.ef027 is 'ef027-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_sos_astat_2015.ef028 is 'ef028-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_sos_astat_2015.ef029 is 'ef029-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_sos_astat_2015.ef030 is 'ef030-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat_2015.ef031u1 is 'ef031u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_sos_astat_2015.ef031u2 is 'ef031u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_sos_astat_2015.ef032 is 'ef032-1. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat_2015.ef033 is 'ef033-Frei fr StL';

comment on column kenn_sos_astat_2015.ef034 is 'ef034-2. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat_2015.ef035 is 'ef035-Frei fr StL';

comment on column kenn_sos_astat_2015.ef036 is 'ef036-3. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_sos_astat_2015.ef037 is 'ef037-Frei fr StL';

comment on column kenn_sos_astat_2015.ef038 is 'ef038-Frei fr StL';

comment on column kenn_sos_astat_2015.ef039 is 'ef039-Frei fr StL';

comment on column kenn_sos_astat_2015.ef040 is 'ef040-Frei fr StL';

comment on column kenn_sos_astat_2015.ef041 is 'ef041-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_sos_astat_2015.ef042 is 'ef042-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_sos_astat_2015.ef043 is 'ef043-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_sos_astat_2015.ef044 is 'ef044-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_sos_astat_2015.ef045 is 'ef045-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat_2015.ef046u1 is 'ef046u1-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform';

comment on column kenn_sos_astat_2015.ef046u2 is 'ef046u2-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Abschluss';

comment on column kenn_sos_astat_2015.ef047 is 'ef047-1. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat_2015.ef048 is 'ef048-Frei fr StL';

comment on column kenn_sos_astat_2015.ef049 is 'ef049-2. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat_2015.ef050 is 'ef050-Frei fr StL';

comment on column kenn_sos_astat_2015.ef051 is 'ef051-3. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_sos_astat_2015.ef052 is 'ef052-Frei fr StL';

comment on column kenn_sos_astat_2015.ef053 is 'ef053-Frei fr StL';

comment on column kenn_sos_astat_2015.ef054 is 'ef054-Frei fr StL';

comment on column kenn_sos_astat_2015.ef055 is 'ef055-Frei fr StL';

comment on column kenn_sos_astat_2015.ef056 is 'ef056-Hochschule (bei Einschreibung an einer anderen HS im Berichtssemester)';

comment on column kenn_sos_astat_2015.ef057 is 'ef057-Frei fr StL';

comment on column kenn_sos_astat_2015.ef058 is 'ef058-Frei fr StL';

comment on column kenn_sos_astat_2015.ef059u1 is 'ef059u1-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Studienform';

comment on column kenn_sos_astat_2015.ef059u2 is 'ef059u2-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Abschluss';

comment on column kenn_sos_astat_2015.ef060 is 'ef060-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat_2015.ef061 is 'ef061-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat_2015.ef062 is 'ef062-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_sos_astat_2015.ef063 is 'ef063-Frei fr StL';

comment on column kenn_sos_astat_2015.ef064 is 'ef064-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen';

comment on column kenn_sos_astat_2015.ef065 is 'ef065-Studiengang gleich dem Berichtssemster?';

comment on column kenn_sos_astat_2015.ef066 is 'ef066-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat_2015.ef067 is 'ef067-Frei fr StL';

comment on column kenn_sos_astat_2015.ef068 is 'ef068-Frei fr StL';

comment on column kenn_sos_astat_2015.ef069u2 is 'ef069u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Studienform';

comment on column kenn_sos_astat_2015.ef069u1 is 'ef069u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Abschluss';

comment on column kenn_sos_astat_2015.ef070 is 'ef070-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat_2015.ef071 is 'ef071-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat_2015.ef072 is 'ef072-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_sos_astat_2015.ef073 is 'ef073-Frei fr StL';

comment on column kenn_sos_astat_2015.ef074 is 'ef074-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat_2015.ef075 is 'ef075-Frei fr StL';

comment on column kenn_sos_astat_2015.ef076 is 'ef076-Frei fr StL';

comment on column kenn_sos_astat_2015.ef077u1 is 'ef077u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Studienform';

comment on column kenn_sos_astat_2015.ef077u2 is 'ef077u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Abschluss';

comment on column kenn_sos_astat_2015.ef078 is 'ef078-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat_2015.ef079 is 'ef079-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat_2015.ef080 is 'ef080-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_sos_astat_2015.ef081 is 'ef081-Frei fr StL';

comment on column kenn_sos_astat_2015.ef082 is 'ef082-1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_sos_astat_2015.ef083 is 'ef083-Monate im 1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_sos_astat_2015.ef084 is 'ef084-Frei fr StL';

comment on column kenn_sos_astat_2015.ef085 is 'ef085-2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_sos_astat_2015.ef086 is 'ef086-Monate im 2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_sos_astat_2015.ef087 is 'ef087-Frei fr StL';

comment on column kenn_sos_astat_2015.ef088 is 'ef088-Frei fr StL';

comment on column kenn_sos_astat_2015.ef089 is 'ef089-Frei fr StL';

comment on column kenn_sos_astat_2015.ef090 is 'ef090-Frei fr StL';

comment on column kenn_sos_astat_2015.ef091u1 is 'ef091u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Studienform';

comment on column kenn_sos_astat_2015.ef091u2 is 'ef091u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Abschluss';

comment on column kenn_sos_astat_2015.ef092 is 'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef093 is 'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef094 is 'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef095 is 'ef095-Frei fr StL';

comment on column kenn_sos_astat_2015.ef096 is 'ef096-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef097 is 'ef097-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_sos_astat_2015.ef098 is 'ef098-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_sos_astat_2015.ef099 is 'ef099-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00';

comment on column kenn_sos_astat_2015.ef100u1 is 'ef100u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Studienform';

comment on column kenn_sos_astat_2015.ef100u2 is 'ef100u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Abschluss';

comment on column kenn_sos_astat_2015.ef101 is 'ef101-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef102 is 'ef102-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef103 is 'ef103-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef104 is 'ef104-Frei fr StL';

comment on column kenn_sos_astat_2015.ef105 is 'ef105-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef106 is 'ef106-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_sos_astat_2015.ef107 is 'ef107-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_sos_astat_2015.ef108 is 'ef108-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00';

comment on column kenn_sos_astat_2015.ef109 is 'ef109-Jahr des ersten Erwerbs der HZB';

comment on column kenn_sos_astat_2015.ef110 is 'ef110-Art der HZB';

comment on column kenn_sos_astat_2015.ef111u1 is 'ef111u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland';

comment on column kenn_sos_astat_2015.ef111u2 is 'ef111u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)';

comment on column kenn_sos_astat_2015.ef112 is 'ef112-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER';

comment on column kenn_sos_astat_2015.ef113 is 'ef113-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER';

comment on column kenn_sos_astat_2015.ef114 is 'ef114-Frei fr StL';

comment on column kenn_sos_astat_2015.ef115 is 'ef115-Frei fr StL';

comment on column kenn_sos_astat_2015.ef116 is 'ef116-Frei fr StL';

comment on column kenn_sos_astat_2015.ef117 is 'ef117-Frei fr StL';

comment on column kenn_sos_astat_2015.ef118 is 'ef118-Frei fr StL';

comment on column kenn_sos_astat_2015.ef119 is 'ef119-Frei fr StL';

comment on column kenn_sos_astat_2015.ef120 is 'ef120-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef121 is 'ef121-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef122 is 'ef122-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef123 is 'ef123-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_sos_astat_2015.ef124 is 'ef124-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_sos_astat_2015.ef125 is 'ef125-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_sos_astat_2015.ef126u1 is 'ef126u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Studienform';

comment on column kenn_sos_astat_2015.ef126u2 is 'ef126u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Abschluss';

comment on column kenn_sos_astat_2015.ef127 is 'ef127-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef128 is 'ef128-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef129 is 'ef129-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef130 is 'ef130-Frei fr StL';

comment on column kenn_sos_astat_2015.ef131 is 'ef131-Frei fr StL';

comment on column kenn_sos_astat_2015.ef132 is 'ef132-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef133 is 'ef133-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef134 is 'ef134-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_sos_astat_2015.ef135 is 'ef135-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00';

comment on column kenn_sos_astat_2015.ef136 is 'ef136-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef137 is 'ef137-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef138 is 'ef138-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef139 is 'ef139-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_sos_astat_2015.ef140 is 'ef140-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_sos_astat_2015.ef141 is 'ef141-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_sos_astat_2015.ef142u1 is 'ef142u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform';

comment on column kenn_sos_astat_2015.ef142u2 is 'ef142u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss';

comment on column kenn_sos_astat_2015.ef143 is 'ef143-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef144 is 'ef144-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef145 is 'ef145-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef146 is 'ef146-Frei fr StL';

comment on column kenn_sos_astat_2015.ef147 is 'ef147-Frei fr StL';

comment on column kenn_sos_astat_2015.ef148 is 'ef148-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef149 is 'ef149-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef150 is 'ef150-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_sos_astat_2015.ef151 is 'ef151-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00';

comment on column kenn_sos_astat_2015.ef152 is 'ef152-Gesamtnote in Punkten bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';


select now(), 'Erzeuge Index ixkenn_sos_astat_20151';

create  index ixkenn_sos_astat_20151 on kenn_sos_astat_2015 (matrikel_nr );


select now(), 'Erzeuge Index ixkenn_sos_astat_20152';

create  index ixkenn_sos_astat_20152 on kenn_sos_astat_2015 (semester );


select now(), 'Tabelle kenn_sos_astat_2015 erzeugt';



select now(), 'Erzeuge Tabelle kenn_lab_astat_2015';

create table kenn_lab_astat_2015(
	hs_nr INTEGER , 
semester integer , 
matrikel_nr integer , 
ef001 varchar(12) , 
ef002 varchar(12) , 
ef003 varchar(12) , 
ef004 varchar(12) , 
ef005 varchar(12) , 
ef006 varchar(12) , 
ef007 varchar(12) , 
ef008u1 varchar(12) , 
ef008u2 varchar(12) , 
ef009 varchar(12) , 
ef010u1 varchar(12) , 
ef010u2 varchar(12) , 
ef011u1 varchar(12) , 
ef011u2 varchar(12) , 
ef012 varchar(12) , 
ef013 varchar(12) , 
ef014 varchar(12) , 
ef015 varchar(12) , 
ef016 varchar(12) , 
ef017 varchar(12) , 
ef018 varchar(12) , 
ef019 varchar(12) , 
ef020 varchar(12) , 
ef021 varchar(12) , 
ef022 varchar(12) , 
ef023 varchar(12) , 
ef024 varchar(12) , 
ef025 varchar(12) , 
ef026 varchar(12) , 
ef027 varchar(12) , 
ef028 varchar(12) , 
ef029 varchar(12) , 
ef030 varchar(12) , 
ef031u1 varchar(12) , 
ef031u2 varchar(12) , 
ef032 varchar(12) , 
ef033 varchar(12) , 
ef034 varchar(12) , 
ef035 varchar(12) , 
ef036 varchar(12) , 
ef037 varchar(12) , 
ef038 varchar(12) , 
ef039 varchar(12) , 
ef040 varchar(12) , 
ef041 varchar(12) , 
ef042 varchar(12) , 
ef043 varchar(12) , 
ef044 varchar(12) , 
ef045 varchar(12) , 
ef046u1 varchar(12) , 
ef046u2 varchar(12) , 
ef047 varchar(12) , 
ef048 varchar(12) , 
ef049 varchar(12) , 
ef050 varchar(12) , 
ef051 varchar(12) , 
ef052 varchar(12) , 
ef053 varchar(12) , 
ef054 varchar(12) , 
ef055 varchar(12) , 
ef056 varchar(12) , 
ef057 varchar(12) , 
ef058 varchar(12) , 
ef059u1 varchar(12) , 
ef059u2 varchar(12) , 
ef060 varchar(12) , 
ef061 varchar(12) , 
ef062 varchar(12) , 
ef063 varchar(12) , 
ef064 varchar(12) , 
ef065 varchar(12) , 
ef066 varchar(12) , 
ef067 varchar(12) , 
ef068 varchar(12) , 
ef069u2 varchar(12) , 
ef069u1 varchar(12) , 
ef070 varchar(12) , 
ef071 varchar(12) , 
ef072 varchar(12) , 
ef073 varchar(12) , 
ef074 varchar(12) , 
ef075 varchar(12) , 
ef076 varchar(12) , 
ef077u1 varchar(12) , 
ef077u2 varchar(12) , 
ef078 varchar(12) , 
ef079 varchar(12) , 
ef080 varchar(12) , 
ef081 varchar(12) , 
ef082 varchar(12) , 
ef083 varchar(12) , 
ef084 varchar(12) , 
ef085 varchar(12) , 
ef086 varchar(12) , 
ef087 varchar(12) , 
ef088 varchar(12) , 
ef089 varchar(12) , 
ef090 varchar(12) , 
ef091u1 varchar(12) , 
ef091u2 varchar(12) , 
ef092 varchar(12) , 
ef093 varchar(12) , 
ef094 varchar(12) , 
ef095 varchar(12) , 
ef096 varchar(12) , 
ef097 varchar(12) , 
ef098 varchar(12) , 
ef099 varchar(12) , 
ef100u1 varchar(12) , 
ef100u2 varchar(12) , 
ef101 varchar(12) , 
ef102 varchar(12) , 
ef103 varchar(12) , 
ef104 varchar(12) , 
ef105 varchar(12) , 
ef106 varchar(12) , 
ef107 varchar(12) , 
ef108 varchar(12) , 
ef109 varchar(12) , 
ef110 varchar(12) , 
ef111u1 varchar(12) , 
ef111u2 varchar(12) , 
ef112 varchar(12) , 
ef113 varchar(12) , 
ef114 varchar(12) , 
ef115 varchar(12) , 
ef116 varchar(12) , 
ef117 varchar(12) , 
ef118 varchar(12) , 
ef119 varchar(12) , 
ef120 varchar(12) , 
ef121 varchar(12) , 
ef122 varchar(12) , 
ef123 varchar(12) , 
ef124 varchar(12) , 
ef125 varchar(12) , 
ef126u1 varchar(12) , 
ef126u2 varchar(12) , 
ef127 varchar(12) , 
ef128 varchar(12) , 
ef129 varchar(12) , 
ef130 varchar(12) , 
ef131 varchar(12) , 
ef132 varchar(12) , 
ef133 varchar(12) , 
ef134 varchar(12) , 
ef135 varchar(12) , 
ef136 varchar(12) , 
ef137 varchar(12) , 
ef138 varchar(12) , 
ef139 varchar(12) , 
ef140 varchar(12) , 
ef141 varchar(12) , 
ef142u1 varchar(12) , 
ef142u2 varchar(12) , 
ef143 varchar(12) , 
ef144 varchar(12) , 
ef145 varchar(12) , 
ef146 varchar(12) , 
ef147 varchar(12) , 
ef148 varchar(12) , 
ef149 varchar(12) , 
ef150 varchar(12) , 
ef151 varchar(12) , 
ef152 varchar(12) , 
id SERIAL  not null, 
	constraint pk_lab_astat_2015_id primary key (id)

) 
;



comment on table kenn_lab_astat_2015 is 'Statistiktabelle Absolventen zur Lieferung ans STALA (nach altem Format bis 2016)';

comment on column kenn_lab_astat_2015.hs_nr is 'Hochschulnummer';

comment on column kenn_lab_astat_2015.semester is 'Semester';

comment on column kenn_lab_astat_2015.matrikel_nr is 'Matrikelnr.';

comment on column kenn_lab_astat_2015.ef001 is 'ef001-Berichtsland 01 = Schleswig-Holstein . . . 16 = Thringen';

comment on column kenn_lab_astat_2015.ef002 is 'ef002-Berichtssemester 1 = Sommersemester 2 = Wintersemester';

comment on column kenn_lab_astat_2015.ef003 is 'ef003-Berichtsjahr';

comment on column kenn_lab_astat_2015.ef004 is 'ef004-Hochschule';

comment on column kenn_lab_astat_2015.ef005 is 'ef005-Paginiernummer';

comment on column kenn_lab_astat_2015.ef006 is 'ef006-Matrikelnummer';

comment on column kenn_lab_astat_2015.ef007 is 'ef007-Geschlecht 1 = mnnlich 2 = weiblich';

comment on column kenn_lab_astat_2015.ef008u1 is 'ef008u1-Geburtsdatum - Monat';

comment on column kenn_lab_astat_2015.ef008u2 is 'ef008u2-Geburtsdatum - Jahr';

comment on column kenn_lab_astat_2015.ef009 is 'ef009-Staatsangehrigkeit';

comment on column kenn_lab_astat_2015.ef010u1 is 'ef010u1-Semesterwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat_2015.ef010u2 is 'ef010u2-Semesterwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_lab_astat_2015.ef011u1 is 'ef011u1-Heimatwohnsitz - Bundesland/Ausland: Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat_2015.ef011u2 is 'ef011u2-Heimatwohnsitz Kreis/Staat: Kreis bei Wohnsitz in Deutschland bzw. Staat bei Wohnsitz im Ausland';

comment on column kenn_lab_astat_2015.ef012 is 'ef012-Hrerstatus: 1 = Haupthrer 2 = Nebenhrer/Zweithrer 3 = Studienkollegiat';

comment on column kenn_lab_astat_2015.ef013 is 'ef013-Frei fr StL';

comment on column kenn_lab_astat_2015.ef014 is 'ef014-Frei fr StL';

comment on column kenn_lab_astat_2015.ef015 is 'ef015-Frei fr StL';

comment on column kenn_lab_astat_2015.ef016 is 'ef016-Hochschule der Ersteinschreibung';

comment on column kenn_lab_astat_2015.ef017 is 'ef017-Ersteinschreibung in Deutschland/Semester';

comment on column kenn_lab_astat_2015.ef018 is 'ef018-Jahr der Ersteinschreibung';

comment on column kenn_lab_astat_2015.ef019 is 'ef019-Anzahl der Hochschulsemester an deutschen Hochschulen insgesamt';

comment on column kenn_lab_astat_2015.ef020 is 'ef020-Urlaubssemester';

comment on column kenn_lab_astat_2015.ef021 is 'ef021-Praxissemester';

comment on column kenn_lab_astat_2015.ef022 is 'ef022-- Semester in der DDR bzw. Berlin (Ost) (einschl. Urlaubssemester)';

comment on column kenn_lab_astat_2015.ef023 is 'ef023-Nur bei Studium in der DDR bzw. Berlin (Ost) Art des Studiums 1 = Prsenzstudium 2 = Fernstudium';

comment on column kenn_lab_astat_2015.ef024 is 'ef024-Semester am Studienkolleg';

comment on column kenn_lab_astat_2015.ef025 is 'ef025-Anzahl der Unterbrechungssemester insgesamt';

comment on column kenn_lab_astat_2015.ef026 is 'ef026-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_lab_astat_2015.ef027 is 'ef027-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_lab_astat_2015.ef028 is 'ef028-Art des Studiums im Berichtssemester (1. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_lab_astat_2015.ef029 is 'ef029-Voll-/Teilzeit/ Duales Studium im Berichtssemester (1. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_lab_astat_2015.ef030 is 'ef030-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat_2015.ef031u1 is 'ef031u1-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Studienform';

comment on column kenn_lab_astat_2015.ef031u2 is 'ef031u2-Angestrebte Abschlussprfung im Berichtssemester (1. Studiengang)-Abschluss';

comment on column kenn_lab_astat_2015.ef032 is 'ef032-1. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat_2015.ef033 is 'ef033-Frei fr StL';

comment on column kenn_lab_astat_2015.ef034 is 'ef034-2. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat_2015.ef035 is 'ef035-Frei fr StL';

comment on column kenn_lab_astat_2015.ef036 is 'ef036-3. Studienfach im Berichtssemester (1. Studiengang)';

comment on column kenn_lab_astat_2015.ef037 is 'ef037-Frei fr StL';

comment on column kenn_lab_astat_2015.ef038 is 'ef038-Frei fr StL';

comment on column kenn_lab_astat_2015.ef039 is 'ef039-Frei fr StL';

comment on column kenn_lab_astat_2015.ef040 is 'ef040-Frei fr StL';

comment on column kenn_lab_astat_2015.ef041 is 'ef041-Art der Einschreibung/Exmatrikulation/Beurlaubung 1 = Ersteinschreibung 2 = Neueinschreibung 3 = Rckmeldung 4 = Beurlaubung 5 = Exmatrikulation 6 = frhere Exmatrikulation';

comment on column kenn_lab_astat_2015.ef042 is 'ef042-Grund der Beurlaubung/Exmatrikulation';

comment on column kenn_lab_astat_2015.ef043 is 'ef043-Art des Studiums im Berichtssemester (2. Studiengang) 1. Studium in Deutschland 1 = Prsenzstudium 2 = Fernstudium 3 = Praxissemester 2. Auslandsstudium 4 = Prsenzstudium 5 = Praxissemester';

comment on column kenn_lab_astat_2015.ef044 is 'ef044-Voll-/Teilzeit/ Duales Studium im Berichtssemester (2. Studiengang) 1 = Vollzeit 2 = Teilzeit 3 = Duales Studium';

comment on column kenn_lab_astat_2015.ef045 is 'ef045-Anzahl der Fachsemester im Hinblick auf die angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat_2015.ef046u1 is 'ef046u1-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Studienform';

comment on column kenn_lab_astat_2015.ef046u2 is 'ef046u2-Angestrebte Abschlussprfung im Berichtssemester (2. Studiengang)-Abschluss';

comment on column kenn_lab_astat_2015.ef047 is 'ef047-1. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat_2015.ef048 is 'ef048-Frei fr StL';

comment on column kenn_lab_astat_2015.ef049 is 'ef049-2. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat_2015.ef050 is 'ef050-Frei fr StL';

comment on column kenn_lab_astat_2015.ef051 is 'ef051-3. Studienfach im Berichtssemester (2. Studiengang)';

comment on column kenn_lab_astat_2015.ef052 is 'ef052-Frei fr StL';

comment on column kenn_lab_astat_2015.ef053 is 'ef053-Frei fr StL';

comment on column kenn_lab_astat_2015.ef054 is 'ef054-Frei fr StL';

comment on column kenn_lab_astat_2015.ef055 is 'ef055-Frei fr StL';

comment on column kenn_lab_astat_2015.ef056 is 'ef056-Hochschule (bei Einschreibung an einer anderen HS im Berichtssemester)';

comment on column kenn_lab_astat_2015.ef057 is 'ef057-Frei fr StL';

comment on column kenn_lab_astat_2015.ef058 is 'ef058-Frei fr StL';

comment on column kenn_lab_astat_2015.ef059u1 is 'ef059u1-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Studienform';

comment on column kenn_lab_astat_2015.ef059u2 is 'ef059u2-Angestrebte Abschlussprfung, bei Einschreibung an einer anderen Hochschule im Berichtssemester-Abschluss';

comment on column kenn_lab_astat_2015.ef060 is 'ef060-1. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat_2015.ef061 is 'ef061-2. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat_2015.ef062 is 'ef062-3. Studienfach, bei Einschreibung an einer anderen Hochschule im Berichtssemester.';

comment on column kenn_lab_astat_2015.ef063 is 'ef063-Frei fr StL';

comment on column kenn_lab_astat_2015.ef064 is 'ef064-Kennziffer fr jetzige oder andere Hochschule 1 = jetzige Hochschule 2 = andere Hochschule in Deutschland 3 = Hochschule im Ausland 4 = jetzige und weitere Hochschulen';

comment on column kenn_lab_astat_2015.ef065 is 'ef065-Studiengang gleich dem Berichtssemster?';

comment on column kenn_lab_astat_2015.ef066 is 'ef066-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat_2015.ef067 is 'ef067-Frei fr StL';

comment on column kenn_lab_astat_2015.ef068 is 'ef068-Frei fr StL';

comment on column kenn_lab_astat_2015.ef069u2 is 'ef069u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Studienform';

comment on column kenn_lab_astat_2015.ef069u1 is 'ef069u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang)-Abschluss';

comment on column kenn_lab_astat_2015.ef070 is 'ef070-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat_2015.ef071 is 'ef071-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat_2015.ef072 is 'ef072-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (1. Studiengang).';

comment on column kenn_lab_astat_2015.ef073 is 'ef073-Frei fr StL';

comment on column kenn_lab_astat_2015.ef074 is 'ef074-Hochschule beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat_2015.ef075 is 'ef075-Frei fr StL';

comment on column kenn_lab_astat_2015.ef076 is 'ef076-Frei fr StL';

comment on column kenn_lab_astat_2015.ef077u1 is 'ef077u1-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Studienform';

comment on column kenn_lab_astat_2015.ef077u2 is 'ef077u2-Angestrebte Abschlussprfung beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang)-Abschluss';

comment on column kenn_lab_astat_2015.ef078 is 'ef078-1. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat_2015.ef079 is 'ef079-2. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat_2015.ef080 is 'ef080-3. Studienfach beim Studium im vorhergehenden Semester, nur Studium in Deutschland (2. Studiengang).';

comment on column kenn_lab_astat_2015.ef081 is 'ef081-Frei fr StL';

comment on column kenn_lab_astat_2015.ef082 is 'ef082-1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_lab_astat_2015.ef083 is 'ef083-Monate im 1. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_lab_astat_2015.ef084 is 'ef084-Frei fr StL';

comment on column kenn_lab_astat_2015.ef085 is 'ef085-2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_lab_astat_2015.ef086 is 'ef086-Monate im 2. Land (Staat) bei einem frheren - auf das jetzige Studium in Deutschland bezogene - Studium im Ausland.';

comment on column kenn_lab_astat_2015.ef087 is 'ef087-Frei fr StL';

comment on column kenn_lab_astat_2015.ef088 is 'ef088-Frei fr StL';

comment on column kenn_lab_astat_2015.ef089 is 'ef089-Frei fr StL';

comment on column kenn_lab_astat_2015.ef090 is 'ef090-Frei fr StL';

comment on column kenn_lab_astat_2015.ef091u1 is 'ef091u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Studienform';

comment on column kenn_lab_astat_2015.ef091u2 is 'ef091u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung)-Abschluss';

comment on column kenn_lab_astat_2015.ef092 is 'ef092-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef093 is 'ef093-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef094 is 'ef094-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef095 is 'ef095-Frei fr StL';

comment on column kenn_lab_astat_2015.ef096 is 'ef096-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef097 is 'ef097-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung).';

comment on column kenn_lab_astat_2015.ef098 is 'ef098-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_lab_astat_2015.ef099 is 'ef099-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (letzte Prfung). X,00';

comment on column kenn_lab_astat_2015.ef100u1 is 'ef100u1-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Studienform';

comment on column kenn_lab_astat_2015.ef100u2 is 'ef100u2-Art der Prfung bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung)-Abschluss';

comment on column kenn_lab_astat_2015.ef101 is 'ef101-1. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef102 is 'ef102-2. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef103 is 'ef103-3. Studienfach bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef104 is 'ef104-Frei fr StL';

comment on column kenn_lab_astat_2015.ef105 is 'ef105-Monat des Prfnugsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef106 is 'ef106-Jahr des Prfungsabschlusses bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung).';

comment on column kenn_lab_astat_2015.ef107 is 'ef107-Prfungsergebnis bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). 1 = insgesamt bestanden 2 = endgltig nicht bestanden';

comment on column kenn_lab_astat_2015.ef108 is 'ef108-Gesamtnote bei bereits vor dem Berichtssemester abgelegten Abschlussprfungen an Hochschulen (vorletzte Prfung). X,00';

comment on column kenn_lab_astat_2015.ef109 is 'ef109-Jahr des ersten Erwerbs der HZB';

comment on column kenn_lab_astat_2015.ef110 is 'ef110-Art der HZB';

comment on column kenn_lab_astat_2015.ef111u1 is 'ef111u1-Erwerb der HZB Bundesland bzw. "99" fr Ausland';

comment on column kenn_lab_astat_2015.ef111u2 is 'ef111u2-Erwerb der HZB Kreis (bei Erwerb in Deutschland) bzw. Staat (bei Erwerb im Ausland)';

comment on column kenn_lab_astat_2015.ef112 is 'ef112-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Berufsausbildung mit Abschluss sonst LEER';

comment on column kenn_lab_astat_2015.ef113 is 'ef113-Berufspraktische Ttigkeit vor dem Studium Art der Ttigkeit 1 = Praktikum oder Volontariat im Hinblick auf das derzeitige Studium sonst LEER';

comment on column kenn_lab_astat_2015.ef114 is 'ef114-Frei fr StL';

comment on column kenn_lab_astat_2015.ef115 is 'ef115-Frei fr StL';

comment on column kenn_lab_astat_2015.ef116 is 'ef116-Frei fr StL';

comment on column kenn_lab_astat_2015.ef117 is 'ef117-Frei fr StL';

comment on column kenn_lab_astat_2015.ef118 is 'ef118-Frei fr StL';

comment on column kenn_lab_astat_2015.ef119 is 'ef119-Frei fr StL';

comment on column kenn_lab_astat_2015.ef120 is 'ef120-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef121 is 'ef121-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef122 is 'ef122-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef123 is 'ef123-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_lab_astat_2015.ef124 is 'ef124-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_lab_astat_2015.ef125 is 'ef125-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_lab_astat_2015.ef126u1 is 'ef126u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Studienform';

comment on column kenn_lab_astat_2015.ef126u2 is 'ef126u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)-Abschluss';

comment on column kenn_lab_astat_2015.ef127 is 'ef127-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef128 is 'ef128-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef129 is 'ef129-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef130 is 'ef130-Frei fr StL';

comment on column kenn_lab_astat_2015.ef131 is 'ef131-Frei fr StL';

comment on column kenn_lab_astat_2015.ef132 is 'ef132-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef133 is 'ef133-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef134 is 'ef134-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung)';

comment on column kenn_lab_astat_2015.ef135 is 'ef135-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (1. Prfung) X,00';

comment on column kenn_lab_astat_2015.ef136 is 'ef136-Prfungsamt der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef137 is 'ef137-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef138 is 'ef138-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef139 is 'ef139-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Aus einem anderem Studiengang an einer deutschen Hochschule (einschl. Praxissemester)';

comment on column kenn_lab_astat_2015.ef140 is 'ef140-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: Berufspraktische Ttigkeit vor der Einschreibungim Studiengang der Prfung, soweit als Praxissemester bewertet';

comment on column kenn_lab_astat_2015.ef141 is 'ef141-Anzahl der Fachsemester fr diese Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) hier: aus einem Auslandsstudium';

comment on column kenn_lab_astat_2015.ef142u1 is 'ef142u1-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Studienform';

comment on column kenn_lab_astat_2015.ef142u2 is 'ef142u2-Art der Prfung der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)-Abschluss';

comment on column kenn_lab_astat_2015.ef143 is 'ef143-1. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef144 is 'ef144-2. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef145 is 'ef145-3. Studienfach der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef146 is 'ef146-Frei fr StL';

comment on column kenn_lab_astat_2015.ef147 is 'ef147-Frei fr StL';

comment on column kenn_lab_astat_2015.ef148 is 'ef148-Monat des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef149 is 'ef149-Jahr des Prfungsabschlusses bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef150 is 'ef150-Prfungsergebnis bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';

comment on column kenn_lab_astat_2015.ef151 is 'ef151-Gesamtnote bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung) X,00';

comment on column kenn_lab_astat_2015.ef152 is 'ef152-Gesamtnote in Punkten bei der seit der letzten Semestermeldung insgesamt abgeschlossene Prfung(en). (2. Prfung)';


select now(), 'Tabelle kenn_lab_astat_2015 erzeugt';



select now(), 'Erzeuge Tabelle kenn_kennz_aggr';

create table kenn_kennz_aggr(
	hs_nr INTEGER , 
report_id CHAR(40)  not null, 
katalog_id CHAR(100)  not null, 
parent_katalog_id CHAR(100) , 
katalog_id_beschreibung TEXT , 
hochschulart CHAR(10) , 
zeitraum_int INTEGER , 
bezugszeit INTEGER , 
bezugsart CHAR(1) , 
ebene SMALLINT , 
ord_nr SMALLINT , 
ord_nr_2 SMALLINT , 
is_sub SMALLINT , 
sub_1_caption VARCHAR(255) , 
sub_1_key VARCHAR(255) , 
sub_1_name VARCHAR(255) , 
sub_2_caption VARCHAR(255) , 
sub_2_key VARCHAR(255) , 
sub_2_name VARCHAR(255) , 
betrag double precision , 
einheit CHAR(255) 
) 
;



comment on column kenn_kennz_aggr.report_id is 'ID des Reports';


select now(), 'Tabelle kenn_kennz_aggr erzeugt';



select now(), 'Erzeuge Tabelle kenn_prom_astat';

create table kenn_prom_astat(
	hs_nr INTEGER , 
berichtseinheitid VARCHAR(8) , 
ef001 INTEGER , 
ef002 INTEGER , 
ef003 VARCHAR(255) , 
ef004 VARCHAR(255) , 
ef005 INTEGER , 
ef006u1 INTEGER , 
ef006u2 INTEGER , 
ef006u3 INTEGER , 
ef007 VARCHAR(255) , 
ef008 INTEGER , 
ef009 INTEGER , 
ef010 INTEGER , 
ef011 CHAR(4) , 
ef012 INTEGER , 
ef013u1 INTEGER , 
ef013u2 INTEGER , 
ef014u1 INTEGER , 
ef014u2 INTEGER , 
ef015 INTEGER , 
ef016 INTEGER , 
ef017 INTEGER , 
ef018 INTEGER , 
ef019 VARCHAR(255) , 
ef020 INTEGER , 
ef021 INTEGER , 
ef022 INTEGER , 
ef023 INTEGER , 
ef024 VARCHAR(255) , 
ef025 INTEGER , 
ef026 CHAR(3) , 
ef027 CHAR(4) , 
ef028 INTEGER , 
ef029 INTEGER , 
ef030 INTEGER , 
ef031 INTEGER , 
ef032 VARCHAR(255) , 
ef033u1 INTEGER , 
ef033u2 INTEGER , 
ef034 VARCHAR(255) , 
ef035 VARCHAR(255) , 
ef036 VARCHAR(255) , 
ef037 VARCHAR(255) , 
ef038 VARCHAR(255) 
) 
;



comment on table kenn_prom_astat is 'Tabelle zum Import der Lieferung der Promovierenden ans STALA';

comment on column kenn_prom_astat.hs_nr is 'Hochschulnummer';

comment on column kenn_prom_astat.berichtseinheitid is 'Berichtseinheit ID';

comment on column kenn_prom_astat.ef001 is 'Berichtsland';

comment on column kenn_prom_astat.ef002 is 'Berichtsjahr';

comment on column kenn_prom_astat.ef003 is 'Hochschule der Promotion';

comment on column kenn_prom_astat.ef004 is 'Paginiernummer';

comment on column kenn_prom_astat.ef005 is 'Geschlecht';

comment on column kenn_prom_astat.ef006u1 is 'Geburtsdatum - Tag';

comment on column kenn_prom_astat.ef006u2 is 'Geburtsdatum - Monat';

comment on column kenn_prom_astat.ef006u3 is 'Geburtsdatum - Jahr';

comment on column kenn_prom_astat.ef007 is 'Name';

comment on column kenn_prom_astat.ef008 is 'Staatsangehrigkeit';

comment on column kenn_prom_astat.ef009 is 'weitere Staatsangehrigkeit';

comment on column kenn_prom_astat.ef010 is 'Art der Promotion';

comment on column kenn_prom_astat.ef011 is 'Promotionsfach';

comment on column kenn_prom_astat.ef012 is 'Art der Registrierung als Promovierender';

comment on column kenn_prom_astat.ef013u1 is 'Promotionsbeginn Monat';

comment on column kenn_prom_astat.ef013u2 is 'Promotionsbeginn Jahr';

comment on column kenn_prom_astat.ef014u1 is 'Promotionsende Monat';

comment on column kenn_prom_astat.ef014u2 is 'Promotionsende Jahr';

comment on column kenn_prom_astat.ef015 is 'Immatrikulation';

comment on column kenn_prom_astat.ef016 is 'Teilnahme an einem strukturierenden Promotionsprogramm';

comment on column kenn_prom_astat.ef017 is 'Beschftigungsverhltnis an der Hochschule der Promotion';

comment on column kenn_prom_astat.ef018 is 'Art der Dissertation';

comment on column kenn_prom_astat.ef019 is 'Hochschule (Ersteinschreibung)';

comment on column kenn_prom_astat.ef020 is 'Staat der Hochschule';

comment on column kenn_prom_astat.ef021 is 'Semester';

comment on column kenn_prom_astat.ef022 is 'Jahr';

comment on column kenn_prom_astat.ef023 is 'Zur Promotion berechtigende Abschlussprfung';

comment on column kenn_prom_astat.ef024 is 'Hochschule';

comment on column kenn_prom_astat.ef025 is 'Vorherige Hochschule Staat';

comment on column kenn_prom_astat.ef026 is 'Art der Prfung';

comment on column kenn_prom_astat.ef027 is '1. Studienfach';

comment on column kenn_prom_astat.ef028 is 'Monat des Prfungsabschlusses';

comment on column kenn_prom_astat.ef029 is 'Jahr des Prfungsabschlusses';

comment on column kenn_prom_astat.ef030 is 'Gesamtnote';

comment on column kenn_prom_astat.ef031 is 'Jahr des Erwerbs einer HZB';

comment on column kenn_prom_astat.ef032 is 'Art der ersten HZB';

comment on column kenn_prom_astat.ef033u1 is 'Land der ersten HZB';

comment on column kenn_prom_astat.ef033u2 is 'Kreis/Staat der ersten HZB';

comment on column kenn_prom_astat.ef034 is 'frei fr landesinterne Angaben';

comment on column kenn_prom_astat.ef035 is 'frei fr landesinterne Angaben';

comment on column kenn_prom_astat.ef036 is 'frei fr landesinterne Angaben';

comment on column kenn_prom_astat.ef037 is 'frei fr landesinterne Angaben';

comment on column kenn_prom_astat.ef038 is 'frei fr landesinterne Angaben';


select now(), 'Tabelle kenn_prom_astat erzeugt';



select now(), 'Erzeuge Tabelle kenn_abschl_pruef_grp';

create table kenn_abschl_pruef_grp(
	astat CHAR(10) , 
pruef_grp CHAR(10) 
) 
;



comment on table kenn_abschl_pruef_grp is 'Verzeichnis der externen Prfungsgruppen';

comment on column kenn_abschl_pruef_grp.astat is 'Amtlicher Schlssel Abschluss';

comment on column kenn_abschl_pruef_grp.pruef_grp is 'Prfungsgruppe Schlssel';


select now(), 'Tabelle kenn_abschl_pruef_grp erzeugt';



select now(), 'Erzeuge Tabelle kenn_stelle_bvl_bez';

create table kenn_stelle_bvl_bez(
	id SERIAL  not null, 
sortnr integer , 
kapitel VARCHAR(255) , 
titel VARCHAR(255) , 
bez VARCHAR(255) , 
bvl_stelle_kurz VARCHAR(255) , 
hs_nr INTEGER , 
bez_hs VARCHAR(255) , 
adbz_land VARCHAR(255) , 
optional INTEGER , 
zeilenkontext VARCHAR(255) , 
gueltig_von DATE , 
gueltig_bis DATE , 
	constraint pk_kenn_stelle_bvl_bez primary key (id)

) 
;



comment on column kenn_stelle_bvl_bez.kapitel is 'Kapitel';

comment on column kenn_stelle_bvl_bez.titel is 'Titel';

comment on column kenn_stelle_bvl_bez.bez is 'Bezeichnung (hochschulunabhngig)';

comment on column kenn_stelle_bvl_bez.bvl_stelle_kurz is 'Kurztext der BVL-Gruppe';

comment on column kenn_stelle_bvl_bez.hs_nr is 'Hochschulnummer';

comment on column kenn_stelle_bvl_bez.bez_hs is 'Bezeichnung der Stellengruppe an der jew. Hochschule';

comment on column kenn_stelle_bvl_bez.adbz_land is 'Untergruppierung der BVL-Gruppe';

comment on column kenn_stelle_bvl_bez.optional is 'Zeile optional im STBB?';

comment on column kenn_stelle_bvl_bez.zeilenkontext is 'Zeilen innerhalb werden wei formatiert, Zeilen auserhalb grau. Innerhalb bedeutet --> zwischen Zeilen, welche in der gewhlten Berichtsart Stellen ausweisen.';

comment on column kenn_stelle_bvl_bez.gueltig_von is 'Gltig von';

comment on column kenn_stelle_bvl_bez.gueltig_bis is 'Gltig bis';


select now(), 'Tabelle kenn_stelle_bvl_bez erzeugt';



select now(), 'Erzeuge Tabelle kenn_stelle_hhpl';

create table kenn_stelle_hhpl(
	kapitel CHAR(10) , 
titel CHAR(10) , 
hs_nr INTEGER , 
bvl_stelle_kurz VARCHAR(255) , 
adbz_land VARCHAR(255) , 
summe FLOAT , 
jahr_von INTEGER , 
jahr_bis INTEGER , 
datum date 
) 
;



comment on column kenn_stelle_hhpl.kapitel is 'Kapitel';

comment on column kenn_stelle_hhpl.titel is 'Titel der Stelle';

comment on column kenn_stelle_hhpl.hs_nr is 'Hochschulnummer';

comment on column kenn_stelle_hhpl.bvl_stelle_kurz is 'Kurztext der BVL-Gruppe';

comment on column kenn_stelle_hhpl.adbz_land is 'Untergruppierung der BVL-Gruppe';

comment on column kenn_stelle_hhpl.summe is 'Summe';

comment on column kenn_stelle_hhpl.jahr_von is 'Jahr von';

comment on column kenn_stelle_hhpl.jahr_bis is 'Jahr bis';

comment on column kenn_stelle_hhpl.datum is 'Datum der Berechnung';


select now(), 'Tabelle kenn_stelle_hhpl erzeugt';



select now(), 'Erzeuge Tabelle kenn_stbb_kap_titel_bericht';

create table kenn_stbb_kap_titel_bericht(
	hs_nr INTEGER , 
kapitel VARCHAR(255) , 
titel VARCHAR(255) , 
berichtsname VARCHAR(255) , 
berichtsname_key VARCHAR(255) 
) 
;



comment on column kenn_stbb_kap_titel_bericht.hs_nr is 'Hochschulnummer';

comment on column kenn_stbb_kap_titel_bericht.kapitel is 'Kapitel';

comment on column kenn_stbb_kap_titel_bericht.titel is 'Titel';

comment on column kenn_stbb_kap_titel_bericht.berichtsname is 'Berichtsname';

comment on column kenn_stbb_kap_titel_bericht.berichtsname_key is 'Berichtsname (Schlssel)';


select now(), 'Tabelle kenn_stbb_kap_titel_bericht erzeugt';



select now(), 'Erzeuge Tabelle kenn_rpt_ansprech';

create table kenn_rpt_ansprech(
	tid SERIAL  not null, 
hs_nr INTEGER , 
report_id CHAR(10)  not null, 
name VARCHAR(255) , 
vorname VARCHAR(255) , 
email VARCHAR(255) , 
telefon VARCHAR(255) , 
exportieren CHAR(1)  default '1' , 
	constraint pk_kenn_rpt_ansprech primary key (tid)

) 
;



comment on column kenn_rpt_ansprech.hs_nr is 'Hochschule';

comment on column kenn_rpt_ansprech.report_id is 'Bericht';

comment on column kenn_rpt_ansprech.name is 'Nachname';

comment on column kenn_rpt_ansprech.vorname is 'Vorname';

comment on column kenn_rpt_ansprech.email is 'Email';

comment on column kenn_rpt_ansprech.telefon is 'Telefon';

comment on column kenn_rpt_ansprech.exportieren is 'Exportieren?';


select now(), 'Tabelle kenn_rpt_ansprech erzeugt';



select now(), 'Erzeuge Tabelle kenn_rpt_version';

create table kenn_rpt_version(
	tid SERIAL  not null, 
report_id CHAR(40)  not null, 
defaulttext VARCHAR(255) , 
uniquename VARCHAR(255) , 
version_comment TEXT , 
ordinal_number INTEGER , 
release_version VARCHAR(255) , 
valid_from DATE , 
valid_to DATE , 
	constraint pk_kenn_rpt_version primary key (tid)

) 
;



comment on column kenn_rpt_version.report_id is 'Bericht';

comment on column kenn_rpt_version.defaulttext is 'Name';

comment on column kenn_rpt_version.uniquename is 'Schlssel';

comment on column kenn_rpt_version.version_comment is 'Kommentar';

comment on column kenn_rpt_version.ordinal_number is 'Version (numerisch)';

comment on column kenn_rpt_version.release_version is 'Paket-Version';

comment on column kenn_rpt_version.valid_from is 'Gltig von';

comment on column kenn_rpt_version.valid_to is 'Gltig bis';


select now(), 'Tabelle kenn_rpt_version erzeugt';



select now(), 'Erzeuge Tabelle kenn_stylesheet_version';

create table kenn_stylesheet_version(
	tid SERIAL  not null, 
stylesheet_id INTEGER  not null, 
rpt_version_id INTEGER  not null, 
	constraint pk_kenn_stylesheet_version primary key (tid)

) 
;



comment on column kenn_stylesheet_version.stylesheet_id is 'Stylesheet';

comment on column kenn_stylesheet_version.rpt_version_id is 'Version';


select now(), 'Tabelle kenn_stylesheet_version erzeugt';



select now(), 'Erzeuge Tabelle kenn_zsl_ausgleich_kennungen';

create table kenn_zsl_ausgleich_kennungen(
	astat CHAR(3)  not null, 
studienart TEXT  not null, 
kennung_stud_hs1 SMALLINT  not null, 
kennung_stud_rsz2 SMALLINT  not null, 
kennung_absolv SMALLINT  not null, 
faktor FLOAT  not null
) 
;



comment on column kenn_zsl_ausgleich_kennungen.studienart is 'Studienart';


select now(), 'Tabelle kenn_zsl_ausgleich_kennungen erzeugt';



select now(), 'Erzeuge View kenn_perso_z';

create view kenn_perso_z(
	name, 
key) as
	select apnr, druck from kenn_cifx where key=111;
	

select now(), 'Erzeuge View kenn_stell_z';

create view kenn_stell_z(
	name, 
key) as
	select apnr, druck from kenn_cifx where key=112;
	

select now(), 'Erzeuge View kenn_gege';

create view kenn_gege(
	id, 
apnr, 
kurz, 
druck, 
lang_1, 
struktur_c, 
gruppe) as
	select tid, apnr, kurz, druck, lang_1, struktur_c, gruppe from kenn_cifx where key=648;
	

select now(), 'Erzeuge View kenn_dienstart';

create view kenn_dienstart(
	tid, 
bund_dienstart, 
kurztext, 
drucktext, 
langtext) as
	select tid, apnr as bund_dienstart, kurz, druck, lang_1 from kenn_cifx where key=660;
	

select now(), 'Erzeuge View kenn_taetigkeit';

create view kenn_taetigkeit(
	tid, 
bund_taetigkeit, 
kurztext, 
drucktext, 
langtext) as
	select tid, apnr as bund_taetigkeit, kurz, druck, lang_1 from kenn_cifx where key=661;
	

select now(), 'Erzeuge View kenn_stg_astat';

create view kenn_stg_astat(
	tid, 
astat, 
parent, 
ktxt, 
dtxt, 
ltxt, 
sicht, 
ebene, 
sort1, 
sortc1, 
gueltig_von, 
gueltig_bis, 
struktur_c) as
	
          select tid, apnr as astat, parent,
                   kurz as ktxt,
                   druck as dtxt,
                   lang_1 as ltxt,
                   'kenn_stg_astat_stb_fg'::char(200) as sicht,
                   ebene,
                   sort1,
                   sortc1,
                   d_akt_von as gueltig_von  ,
                   d_akt_bis as gueltig_bis  ,
                   struktur_c
                   from kenn_cifx where key=663 
        ;
	

select now(), 'Erzeuge View kenn_abschl_astat';

create view kenn_abschl_astat(
	tid, 
astat, 
parent, 
ktxt, 
dtxt, 
ltxt, 
sicht, 
ebene, 
sort1, 
sortc1, 
gueltig_von, 
gueltig_bis, 
struktur_c) as
	
          select tid, apnr as astat, parent,
                   kurz as ktxt,
                   druck as dtxt,
                   lang_1 as ltxt,
                   'kenn_abschl_astat'::char(200) as sicht,
                   ebene,
                   sort1,
                   sortc1,
                   d_akt_von as gueltig_von  ,
                   d_akt_bis as gueltig_bis  ,
                   struktur_c
                   from kenn_cifx where key=662 
        ;
	

select now(), 'Erzeuge View kenn_quartale';

create view kenn_quartale(
	apnr, 
kurz, 
druck, 
lang_1, 
sort1) as
	select to_number(apnr,'99999'), kurz, druck, lang_1,sort1 from kenn_cifx where key=664;
	

select now(), 'Erzeuge View kenn_zahlen';

create view kenn_zahlen(
	apnr, 
kurz, 
druck, 
lang_1, 
gruppierung, 
sort1, 
ebene, 
struktur_c, 
gruppe) as
	select apnr, kurz, druck, lang_1,lang_2 as gruppierung,sort1 ,ebene,struktur_c,gruppe from kenn_cifx where key=665;
	

select now(), 'Erzeuge View kenn_hs_sichten';

create view kenn_hs_sichten(
	hs_nr, 
tid, 
dimension, 
dimension_lang, 
stichtag, 
alt_hier_id, 
sichtart, 
bezugszeit, 
bezugsart, 
exportieren) as
	
          
                   select distinct H.hs_nr, S.tid,
                   K.dimension,
                   K.dimension_lang,
                   K.stichtag,
                   S.alt_hier_id,
                   K.sichtart,
                   I.bezugszeit,
                   I.bezugsart,
                   I.exportieren
                   FROM kenn_sichten K, sichten S, hochschulinfo H, kenn_stichtag I
                   where 
                   K.sicht_name_intern=S.name_intern
                   and I.stichtagsart='Kostenrechnung'
                   and (I.tid=K.stichtag_id or K.stichtag_id=0)
          
        ;
	

select now(), 'Erzeuge View kenn_hs_stort_trg';

create view kenn_hs_stort_trg(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select name,hs_nr::char(10) as apnr,traegerschaft as parent,3::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen
                   where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union
                   select lang_1, apnr,'_root',2,'Trgerschaft' from kenn_cifx where key=672
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.kurztext) || ' - ' || S.kurz,'ST' || apnr,H.hs_nr::char(10),4,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	

select now(), 'Erzeuge View kenn_hs_stort_art';

create view kenn_hs_stort_art(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select name,hs_nr::char(10) as apnr,art as parent,3::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen
                   where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union
                   select druck, apnr,'_root',2,'Art' from kenn_cifx where key=673
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.kurztext) || ' - ' || S.kurz,'ST' || apnr,H.hs_nr::char(10),4,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	

select now(), 'Erzeuge View kenn_hs_st_trgart';

create view kenn_hs_st_trgart(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select kurztext,hs_nr::char(10) as apnr,trim(traegerschaft) || '_' || art as parent,4::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union
                   select lang_1, apnr,'_root',2,'Art' from kenn_cifx where key=673
                   union
                   select lang_1, trim(apnr) || '_U','U',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_FH','FH',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_PH','PH',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_VFH','VFH',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_KMW','KMW',3,'Trgerschaft' from kenn_cifx where key=672
                   union
                   select lang_1, trim(apnr) || '_DH','DH',3,'Trgerschaft' from kenn_cifx where key=672
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.kurztext) || ' - ' || S.kurz,'ST' || apnr,H.hs_nr::char(10),4,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	

select now(), 'Erzeuge View kenn_hs_stort';

create view kenn_hs_stort(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select name,hs_nr::char(10) as apnr,'_root'::char(10) as parent,2::smallint as ebene,'Hochschule'::varchar(50) as struktur_str
                   from kenn_hochschulen
                   where hs_nr in (select H.hs_nr from hochschulinfo H)
                   and traegerschaft is not null
                   and (
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (1,2,3,4))and bland='BW')
                   or 
                   (0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL' and apnr in (5,6))and bland='SA')
                   ) 
                   union 
                   select 'Hochschulen','_root',null::char(10),1,'Alle' from xdummy
                   union
                   select trim(H.name) || ' Standort  ' || trim(S.druck),'ST' || apnr,H.hs_nr::char(10),3,'Standort' from kenn_stort S, kenn_hochschulen H
                   where H.hs_nr=S.hs_nr 
                   and H.hs_nr in (select O.hs_nr from hochschulinfo O)
          
        ;
	

select now(), 'Erzeuge View kenn_stg_sb';

create view kenn_stg_sb(
	name, 
apnr, 
parent, 
ebene, 
struktur_str) as
	
          
                   select druck as name,apnr,parent,1::smallint as ebene,struktur_c as struktur_str from kenn_cifx where key=663 and struktur_c ='Fach (amtlich)'
                   union select druck,apnr,'_Alle',1,struktur_c from kenn_cifx where key=663 and struktur_c ='Studienbereich'
                   union select 'Alle Studienbereiche','_Alle',null::char(10),1,'Summe Studienbereiche' from xdummy
          
        ;
	

select now(), 'Erzeuge View kenn_redaktionsstatus';

create view kenn_redaktionsstatus(
	apnr, 
name) as
	
          
                   select 3::integer as apnr, 'In Bearbeitung' from xdummy
                   union
                   select 4::integer as apnr, 'Freigegeben' from xdummy
          
        ;
	

select now(), 'Erzeuge View dim_hochschule';

create view dim_hochschule(
	hs_nr, 
name, 
kurztext, 
art) as
	
          
                   SELECT 
                   hs_nr,
                   name,
                   kurztext,
                   case when art='FH'  then 'Fachhochschule'
                   when art='U' then 'Universitt'
                   when art='DH' then 'Duale Hochschule'
                   when art='KMW' then 'Kunst/Musikhochschule'
                   when art='PH' then 'Pdagogische Hochschule'
                   else art
                   end
                   FROM kenn_hochschulen
                   where (bland='BW'
                   and (select K.apnr from konstanten K where K.beschreibung='KENN_PROFIL') in (1,2,3,4))
                   or (bland='SA'
                   and (select K.apnr from konstanten K where K.beschreibung='KENN_PROFIL') in (5,6))
                   or bland is null
                   or bland not in ('BW','SA')
                   
                   
          
        ;
	

select now(), 'Erzeuge View kenn_extkotr_lfb';

create view kenn_extkotr_lfb(
	key, 
parent, 
name, 
struktur_str, 
gueltig_von, 
gueltig_bis) as
	
          
                   SELECT 
                   distinct  substring(key from 4 for 3) as key,
                   substring(key from 2 for 2) as parent,
                   case when name like 'Le LFB%' then substring (name from 8 for 150) when name like 'Le %' then substring (name from 4 for 150) else name end as name,
                   'lfb'::char(10) as struktur_str,
                   extract (year from gueltig_von) as gueltig_von,
                   extract (year from gueltig_bis) as gueltig_bis
                   FROM kenn_extkotr
                   where kategorie='lf'
                   and key like '1%'
                   union
                   select distinct substring(key from 2 for 2) as key,
                   '_lfb' as parent,
                   substring(name from 4 for 200) as name,
                   kategorie as struktur_str,
                   extract (year from gueltig_von) as gueltig_von,
                   extract (year from gueltig_bis) as gueltig_bis
                   from kenn_extkotr where
                   kategorie='fg'
                   and key like '1%'
                   union select '_lfb'::char(10),null::char(10), 'Lehr- und Forschungsbereiche',
                   'Alle' as struktur_str,1900,3000 from xdummy
                   
                   
          
        ;
	

select now(), 'Erzeuge View kenn_extkotr_lehre_k';

create view kenn_extkotr_lehre_k(
	key, 
parent, 
kurztext, 
name, 
gueltig_von, 
gueltig_bis) as
	
          
                   
                   select 
                   key,
                   null::char(30) as parent,
                   substring(name from 1 for 10) as kurztext,
                   name,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where key ='01'
                   union
                   --Fchergruppe:
                   select 
                   'F' || substring(key from 3 for 2),
                   '01',
                   substring(name from 1 for 10),
                   name,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where 
                   key like '01%'
                   and length(trim(key))=4
                   union
                   --FGR ohne koop.
                   select 
                   key,
                   'F' || substring(key from 3 for 2),
                   substring(name from 1 for 10),
                   trim(name) || ' (ohne Koop.-Stg.)',
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where 
                   key like '01%'
                   and length(trim(key))=4
                   union
                   --FGR mit koop-Stg:
                   select key,
                   'F' || substring(key from 3 for 2),
                   substring(name from 1 for 10),
                   trim(name) || ' (Koop.-Stg.)',
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where 
                   key like '11%'
                   and length(trim(key))=4
                   union
                   select 
                   key,
                   parent,
                   substring(name from 1 for 10),
                   trim(name) ,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr 
                   where (key like '01%' or key like '11%')
                   and length(trim(key))>4
                   
                   
          
        ;
	

select now(), 'Erzeuge View kenn_extkotr_a';

create view kenn_extkotr_a(
	key, 
parent, 
kurztext, 
name, 
kategorie, 
gueltig_von, 
gueltig_bis) as
	
          
                   
                   select 
                   --alte Knoten:
                   key,
                   parent,
                   substring(name from 1 for 10) as kurztext,
                   trim(name) || ' (bis ' || extract (year from gueltig_bis) || ')',
                   kategorie,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where extract (year from gueltig_bis) <3000
                   union
                   --aktuelle Knoten:
                   select
                   key,
                   parent,
                   substring(name from 1 for 10) as kurztext,
                   trim(name),
                   kategorie,
                   gueltig_von,
                   gueltig_bis
                   from kenn_extkotr where extract (year from gueltig_bis) =3000
                   or gueltig_bis is null
                   
                   
          
        ;
	

select now(), 'Erzeuge View kenn_hzbart_astat_akt';

create view kenn_hzbart_astat_akt(
	tid, 
bland, 
apnr, 
druck, 
gruppe) as
	select tid,bland,apnr,druck,gruppe from kenn_hzbart_astat where current_date between gueltig_von and gueltig_bis;
	

select now(), 'Erzeuge View dim_kenn_koepfe_faelle';

create view dim_kenn_koepfe_faelle(
	apnr, 
druck, 
struktur_int) as
	
          
                   
                   select 'K'::char(1) as apnr, 
                   'Kpfe'::varchar(255) as druck,
                   1::integer as struktur_int
                   from xdummy
                   union
                   select 'S'::char(1) as apnr, 
                   'Kpfe Stat. Landesamt (1.F.,n-ter Stg)'::varchar(255) as druck,
                   3::integer as struktur_int
                   from xdummy
                   union
                   select 'F'::char(1) as apnr, 
                   'Flle'::varchar(255) as druck,
                   2::integer as struktur_int
                   from xdummy
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_monat';

create view dim_kenn_monat(
	monat, 
quartal, 
halbjahr, 
name) as
	
          
                   
                   SELECT to_number(substring(wert from 7 for 2),'99')::integer as monat,
                   (case when to_number(substring(wert from 7 for 2),'99') between 1 and 3 then 1
                   when to_number(substring(wert from 7 for 2),'99') between 4 and 6 then 2
                   when to_number(substring(wert from 7 for 2),'99') between 7 and 9 then 3
                   when to_number(substring(wert from 7 for 2),'99') between 10 and 13 then 4
                   end )::integer as quartal,
                   (case when to_number(substring(wert from 7 for 2),'99') between 1 and 6 then 1
                   when to_number(substring(wert from 7 for 2),'99') between 6 and 13 then 2
                   end )::integer as halbjahr,
                   name from aggregierung
                   where kategorie='ZeitraumMonat'
                   and wert like '%=%'
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_stg_int';

create view dim_kenn_stg_int(
	apnr, 
druck, 
hs_nr_str, 
hs_nr, 
stg_astat_str) as
	
          
                   
                   select '' || S.hs_nr  || '_' || trim(S.apnr) as apnr,
                   (trim(H.name) || ': ' || trim(S.druck))::varchar(255) as druck,
                   H.name as hs_nr_str,
                   H.hs_nr,
                   C.druck as stg_astat_str
                   
                   from kenn_hochschulen H, kenn_stg_int S 
                   left outer join kenn_cifx C on (
                   S.astat=C.apnr
                   and C.key=663
                   and C.struktur_c='Fach (amtlich)')
                   where 
                   H.hs_nr=S.hs_nr
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_stg_astat';

create view dim_kenn_stg_astat(
	apnr, 
druck, 
sb, 
sb_str, 
fgr) as
	
          
                   
                   select C.apnr, 
                   C.druck,
                   C.parent as sb,
                   C.lang_2 as sb_str,
                   C.lang_3 as fgr
                   from kenn_cifx C 
                   where C.key=663
                   and C.struktur_c='Fach (amtlich)'
                   
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_abschl_astat';

create view dim_kenn_abschl_astat(
	apnr, 
druck, 
abschlussart, 
abschlussgruppe) as
	
          
                   
                   select C.apnr, 
                   C.druck,
                   C.lang_2 as abschlussart,
                   C.lang_3 as abschlussgruppe
                   from kenn_cifx C 
                   where C.key=662
                   and C.struktur_c='Abschluss (amtlich)'
                   
                   
                   
          
        ;
	

select now(), 'Erzeuge View dim_kenn_bvkr_art';

create view dim_kenn_bvkr_art(
	apnr, 
druck, 
parent, 
struktur_c, 
ebene, 
kostentyp, 
kostentyp_str) as
	
          
                   select 
                   apnr,
                   druck,
                   parent ,
                   struktur_c,
                   ebene,
                   gruppe as kostentyp,
                   case when gruppe='60' then 'Erlse' 
                   when gruppe='62' then 'Sachaufwendungen' 
                   when gruppe='64' then 'Kosten Abschreibungen'
                   when gruppe='63' then 'Weitere Aufwendungen'
                   when gruppe='65' then 'Kosten kalkulatorische Mieten'
                   when gruppe='61' then 'Personalstandardkosten' 
                   else 'Sonstige'
                   end  as kostentyp_str      
                   from 
                   kenn_cifx where key=668
                   and ebene>1 
          
        ;
	

select now(), 'Erzeuge View kenn_report_katalog';

create view kenn_report_katalog(
	apnr, 
druck, 
parent, 
struktur_str, 
sortnr, 
ebene, 
quelltabelle, 
report_id, 
uniquename) as
	
          
                   select '_' || apnr::char(100) as apnr,
                   druck,
                   null::char(100) as parent,
                   'Bericht'::varchar(255) as struktur_str,
                   1000::smallint as sortnr ,
                   1::smallint as ebene,
                   null::char(255) as quelltabellen,
                   apnr::char(40) as report_id,
                   null::varchar(255) as uniquename
                   from kenn_cifx where key=666 
                   --ebene Gruppe:
                   union select '_G_' || G.id as apnr,
                   G.name,
                   '_' || G.report_id as parent,
                   'Gruppe'::varchar(255) as struktur_str,
                   (1000+G.ord_nr)::smallint as sortnr ,
                   2::smallint as ebene,
                   null::char(255) as quelltabellen,
                   G.report_id ,
                   G.uniquename
                   from kenn_katalog_grp G
                   union select R.katalog_id,
                   K.name,coalesce(R.parent_katalog_id,'_G_' || R.gruppe_1) as parent,
                   'Kennzahl'::varchar(255) as struktur_str,
                   10000+R.ord_nr as sortnr,
                   2+R.ebene as ebene,
                   K.quelltabelle,
                   R.report_id,
                   R.uniquename
                   from kenn_katalog_rpt R, kenn_katalog K, kenn_cifx C
                   where R.katalog_id=K.id
                   and R.report_id=C.apnr
                   and R.active > 0
                   and C.key=666
          
        ;
	

select now(), 'Erzeuge View kenn_report';

create view kenn_report(
	apnr, 
druck, 
sortnr, 
land_apnr, 
is_download, 
bezugsart, 
gruppe) as
	
          
                   SELECT apnr,
		   druck,
		   sort1 as sortnr,
		   land_apnr,
		   (case when intern_c='D' then 'J' else 'N' end) as is_download,
		   struktur_c as bezugsart ,
		   gruppe
		   from kenn_cifx 
		   where key in (666,679)
          
        ;
	

select now(), 'Erzeuge View kenn_report_fuer_stichtagsarten';

create view kenn_report_fuer_stichtagsarten(
	apnr, 
druck, 
sortnr, 
land_apnr, 
is_download, 
bezugsart) as
	
          
                   SELECT apnr,
		   druck,
		   sort1 as sortnr,
		   land_apnr,
		   (case when intern_c='D' then 'J' else 'N' end) as is_download,
		   struktur_c as bezugsart 
		   from kenn_cifx 
		   where key in (688)
          
        ;
	

select now(), 'Erzeuge View kenn_bezugszeit';

create view kenn_bezugszeit(
	bezugsart, 
bezugszeit, 
druck) as
	
          
                   
	    select 'S'::char(1) as bezugsart,
	    K.tid as bezugszeit,
	    K.druck 
	    from kenn_semester K
	    union select 'J',
	    ord as bezugszeit,
	    name::varchar(255) as druck
	    from aggregierung 
	    where kategorie='KENN-Jahr'
	    union
	    SELECT 'Q',
	    CAST(apnr AS INTEGER),
	    druck
	    FROM kenn_cifx where key=664
           
        ;
	

select now(), 'Erzeuge View kenn_abschl_astat_pruef_grp';

create view kenn_abschl_astat_pruef_grp(
	astat, 
pruef_grp, 
kurz, 
druck, 
lang_1, 
sort1) as
	
          
                   SELECT G.astat,G.pruef_grp, C.kurz, C.druck,C.lang_1, C.sort1
                   from kenn_cifx C left outer join kenn_abschl_pruef_grp G
                   on (G.pruef_grp = C.apnr)
                   where C.key=687
                   
          
        ;
	

select now(), 'Erzeuge View kenn_stbb_kapitel';

create view kenn_stbb_kapitel(
	kapitel) as
	
          
                   SELECT distinct kapitel 
		   from kenn_stbb_kap_titel_bericht
                   
          
        ;
	

select now(), 'Erzeuge View kenn_stbb_titel';

create view kenn_stbb_titel(
	titel) as
	
          
                   SELECT distinct titel 
		   from kenn_stbb_kap_titel_bericht
                   
          
        ;
	

select now(), 'Erzeuge View k_astat_studienfach_land_l';

create view k_astat_studienfach_land_l(
	schluessel, 
gueltig_ab, 
land, 
version, 
sortkey, 
gueltig_bis, 
name, 
isced, 
keybund) as
	
          
					select 
						L.schluessel,
						L.gueltig_ab,
						L.land,
						L.version,
						L.sortkey,
						L.gueltig_bis,
						L.name,
						L.isced,
						L.keybund
					from 
						k_astat_studienfach_land L,
						cif C
					where 
						C.apnr=L.land
						and C.key=659  
          
        ;
	

select now(), 'Erzeuge View kenn_hochschulen_plus';

create view kenn_hochschulen_plus(
	hs_nr, 
kuerzel) as
	
          
					select hs_nr::char(40), kuerzel from kenn_hochschulen union 
					select 'hochschulroot', 'Gesamt' from xdummy union
					select '10001', 'Uni' from xdummy union
					select '20001', 'FH' from xdummy union
					select '30001', 'KunstMusik' from xdummy union
					select '40001', 'Sonst' from xdummy
					; 
          
        ;
	--Funktion / Prozedur sp_get_vari_parent


select now(), 'Erzeuge Funktion sp_get_vari_parent';

\! DOSQL $KENN_PFAD/prozeduren/proc_get_vari_parent_pg.sql
			--Funktion / Prozedur sp_get_children


select now(), 'Erzeuge Funktion sp_get_children';

\! DOSQL $KENN_PFAD/prozeduren/proc_get_children_pg.sql
			--Funktion / Prozedur get_akad_jahr


select now(), 'Erzeuge Funktion get_akad_jahr';

\! DOSQL $KENN_PFAD/prozeduren/proc_get_akad_jahr_pg.sql
			--Funktion / Prozedur sp_get_rpt_sta_bezugszeit


select now(), 'Erzeuge Funktion sp_get_rpt_sta_bezugszeit';

\! DOSQL $KENN_PFAD/prozeduren/proc_sp_get_rpt_sta_bezugszeit_pg.sql
			--Funktion / Prozedur get_quartal


select now(), 'Erzeuge Funktion get_quartal';

\! DOSQL $KENN_PFAD/prozeduren/proc_get_quartal_pg.sql
			--Install-Schritt:  


select now(), 'SQL-Ausdruck create table tmp_aggregierung   (     tid smallint,     name char(50),     kategorie char(30),     wert char(255)   ) ; ausfhren';

create table tmp_aggregierung   (     tid smallint,     name char(50),     kategorie char(30),     wert char(255)   ) ;
		

select now(), 'SQL-Ausdruck create table tmp_repository(  tid INTEGER  not null,  id CHAR(200)  not null,  content TEXT ,  caption CHAR(200) ,  comment TEXT ,  version SMALLINT ,  art CHAR(200) ,  art2 CHAR(200) ,  art3 CHAR(200) ,  sachgebiete_id INTEGER ,  sort1 INTEGER ,  sort2 INTEGER ,  sort3 INTEGER ,  geaendert_am DATE ,  aktiv smallint ,  gueltig_seit DATE,  gueltig_bis DATE ); ausfhren';

create table tmp_repository(  tid INTEGER  not null,  id CHAR(200)  not null,  content TEXT ,  caption CHAR(200) ,  comment TEXT ,  version SMALLINT ,  art CHAR(200) ,  art2 CHAR(200) ,  art3 CHAR(200) ,  sachgebiete_id INTEGER ,  sort1 INTEGER ,  sort2 INTEGER ,  sort3 INTEGER ,  geaendert_am DATE ,  aktiv smallint ,  gueltig_seit DATE,  gueltig_bis DATE );
		

select now(), 'SQL-Ausdruck create table tmp_captions        (         id CHAR(200) ,          table_name CHAR(200) ,          field_name CHAR(200) ,          record_no INTEGER ,          locale CHAR(10) ,          contents_short CHAR(255) ,          contents_long text ,          equalitystatus SMALLINT ,          sachgebiete_id INTEGER  , doku_link varchar(255), export_to_glossar integer DEFAULT 1          ); ausfhren';

create table tmp_captions        (         id CHAR(200) ,          table_name CHAR(200) ,          field_name CHAR(200) ,          record_no INTEGER ,          locale CHAR(10) ,          contents_short CHAR(255) ,          contents_long text ,          equalitystatus SMALLINT ,          sachgebiete_id INTEGER  , doku_link varchar(255), export_to_glossar integer DEFAULT 1          );
		

select now(), 'SQL-Ausdruck CREATE TABLE tmp_abschl_astat (     tid serial NOT NULL,     astat character(10) NOT NULL,     parent character(10),     ktxt character(10),     dtxt character(150),     ltxt character(250),     sicht character(200) NOT NULL,     ebene smallint,     sort1 integer,     sortc1 character(10),     gueltig_von date,     gueltig_bis date,     struktur_c char(50) ); ausfhren';

CREATE TABLE tmp_abschl_astat (     tid serial NOT NULL,     astat character(10) NOT NULL,     parent character(10),     ktxt character(10),     dtxt character(150),     ltxt character(250),     sicht character(200) NOT NULL,     ebene smallint,     sort1 integer,     sortc1 character(10),     gueltig_von date,     gueltig_bis date,     struktur_c char(50) );
		

select now(), 'SQL-Ausdruck CREATE TABLE tmp_stg_astat (     tid serial NOT NULL,     astat character(10) NOT NULL,     parent character(10),     ktxt character(10),     dtxt character(150),     ltxt character(250),     sicht character(200) NOT NULL,     ebene smallint,     sort1 integer,     sortc1 character(10),     gueltig_von date,     gueltig_bis date,     struktur_c char(50) ); ausfhren';

CREATE TABLE tmp_stg_astat (     tid serial NOT NULL,     astat character(10) NOT NULL,     parent character(10),     ktxt character(10),     dtxt character(150),     ltxt character(250),     sicht character(200) NOT NULL,     ebene smallint,     sort1 integer,     sortc1 character(10),     gueltig_von date,     gueltig_bis date,     struktur_c char(50) );
		

select now(), 'SQL-Ausdruck create table tmp_extkotr_bawue( hs_nr INTEGER ,   key CHAR(30) ,  parent CHAR(30) ,  name CHAR(255) ,  kategorie CHAR(2) ,  fins_stugfach CHAR(3), tid integer , gueltig_von date, gueltig_bis date )  ; ausfhren';

create table tmp_extkotr_bawue( hs_nr INTEGER ,   key CHAR(30) ,  parent CHAR(30) ,  name CHAR(255) ,  kategorie CHAR(2) ,  fins_stugfach CHAR(3), tid integer , gueltig_von date, gueltig_bis date )  ;
		

select now(), 'SQL-Ausdruck create table tmp_extkotr_sachsen(  hs_nr INTEGER ,  key CHAR(30) ,  parent CHAR(30) ,  name CHAR(255) ,  kategorie CHAR(2) ,  fins_stugfach CHAR(3) , tid integer, gueltig_von date, gueltig_bis date )  ; ausfhren';

create table tmp_extkotr_sachsen(  hs_nr INTEGER ,  key CHAR(30) ,  parent CHAR(30) ,  name CHAR(255) ,  kategorie CHAR(2) ,  fins_stugfach CHAR(3) , tid integer, gueltig_von date, gueltig_bis date )  ;
		

select now(), 'SQL-Ausdruck CREATE TABLE tmp_cif_load_kenn (     tid integer NOT NULL,     hs integer ,     key smallint NOT NULL,     apnr integer NOT NULL,     d_akt_von date,     d_akt_bis date,     kurz character(10),     druck character(100),     lang_1 character(100),     lang_2 character(150),     lang_3 character(250) ); ausfhren';

CREATE TABLE tmp_cif_load_kenn (     tid integer NOT NULL,     hs integer ,     key smallint NOT NULL,     apnr integer NOT NULL,     d_akt_von date,     d_akt_bis date,     kurz character(10),     druck character(100),     lang_1 character(100),     lang_2 character(150),     lang_3 character(250) );
		

select now(), 'SQL-Ausdruck create table tmp_kenn_katalog_sub( report_id CHAR(40)  not null,  katalog_id CHAR(100)  not null,  sub_caption VARCHAR(255) ,  sub_key_col VARCHAR(255) ,  sub_lookup_table VARCHAR(255) ,  sub_lookup_key VARCHAR(255) ,  sub_lookup_name VARCHAR(255) ,  sub_lookup_whereclause VARCHAR(255) ,  sub_lookup_snowflake TEXT ,  ord_nr SMALLINT  )  ; ausfhren';

create table tmp_kenn_katalog_sub( report_id CHAR(40)  not null,  katalog_id CHAR(100)  not null,  sub_caption VARCHAR(255) ,  sub_key_col VARCHAR(255) ,  sub_lookup_table VARCHAR(255) ,  sub_lookup_key VARCHAR(255) ,  sub_lookup_name VARCHAR(255) ,  sub_lookup_whereclause VARCHAR(255) ,  sub_lookup_snowflake TEXT ,  ord_nr SMALLINT  )  ;
		

select now(), 'SQL-Ausdruck create table tmp_kenn_katalog_grp( report_id CHAR(40)  not null,  id CHAR(40)  not null,  uniquename VARCHAR(255) ,  name VARCHAR(255) ,  beschreibung TEXT ,  parent_id CHAR(40) ,  ord_nr SMALLINT )  ; ausfhren';

create table tmp_kenn_katalog_grp( report_id CHAR(40)  not null,  id CHAR(40)  not null,  uniquename VARCHAR(255) ,  name VARCHAR(255) ,  beschreibung TEXT ,  parent_id CHAR(40) ,  ord_nr SMALLINT )  ;
		

select now(), 'SQL-Ausdruck create table tmp_kenn_katalog(   id CHAR(100)  not null,  name CHAR(255) ,  beschreibung TEXT ,  quelltabelle CHAR(255) ,  quellfeld CHAR(255) ,  bedingung TEXT ,  stichtagsart CHAR(100) ,  bezugsart CHAR(1) ,  zeitfeld CHAR(40) ,  einheit VARCHAR(255) ,  bezugszeit_wert SMALLINT ,  bezugszeit_art CHAR(1) ,  bezugszeit_diff VARCHAR(255), gueltig_von date, gueltig_bis date )  ; ausfhren';

create table tmp_kenn_katalog(   id CHAR(100)  not null,  name CHAR(255) ,  beschreibung TEXT ,  quelltabelle CHAR(255) ,  quellfeld CHAR(255) ,  bedingung TEXT ,  stichtagsart CHAR(100) ,  bezugsart CHAR(1) ,  zeitfeld CHAR(40) ,  einheit VARCHAR(255) ,  bezugszeit_wert SMALLINT ,  bezugszeit_art CHAR(1) ,  bezugszeit_diff VARCHAR(255), gueltig_von date, gueltig_bis date )  ;
		

select now(), 'SQL-Ausdruck create table tmp_kenn_katalog_rpt(  katalog_id CHAR(100)  not null,  report_id CHAR(40)  not null,  beschreibung TEXT ,  ord_nr SMALLINT ,  gruppe_1 CHAR(40) ,  gruppe_2 CHAR(40) ,  ebene SMALLINT ,  parent_katalog_id CHAR(100) ,  active smallint  default 1 ,  uniquename VARCHAR(255)   )  ; ausfhren';

create table tmp_kenn_katalog_rpt(  katalog_id CHAR(100)  not null,  report_id CHAR(40)  not null,  beschreibung TEXT ,  ord_nr SMALLINT ,  gruppe_1 CHAR(40) ,  gruppe_2 CHAR(40) ,  ebene SMALLINT ,  parent_katalog_id CHAR(100) ,  active smallint  default 1 ,  uniquename VARCHAR(255)   )  ;
		

select now(), 'SQL-Ausdruck CREATE TABLE tmp_sx_jobs (     uniquename character varying(255),     caption character varying(255),     filepath character varying(255),     sachgebiete_id integer,     kenn_profil integer,     hs_nr integer,     modus_supported smallint,     params character varying(255),     check_sql text ); ausfhren';

CREATE TABLE tmp_sx_jobs (     uniquename character varying(255),     caption character varying(255),     filepath character varying(255),     sachgebiete_id integer,     kenn_profil integer,     hs_nr integer,     modus_supported smallint,     params character varying(255),     check_sql text );
		

select now(), 'Lade Tabelle tmp_repository';

\! sx_auto_upload_table.x tmp_repository $KENN_PFAD/schluesseltabellen/sx_repository.unl


select now(), 'Lade Tabelle tmp_aggregierung';

\! sx_auto_upload_table.x tmp_aggregierung $KENN_PFAD/schluesseltabellen/aggregierung.unl


select now(), 'Lade Tabelle kenn_staat';

\! sx_auto_upload_table.x kenn_staat $KENN_PFAD/schluesseltabellen/kenn_staat.unl


select now(), 'Lade Tabelle tmp_cif_load_kenn';

\! sx_auto_upload_table.x tmp_cif_load_kenn $KENN_PFAD/schluesseltabellen/cif.unl


select now(), 'Lade Tabelle tmp_captions';

\! sx_auto_upload_table.x tmp_captions $KENN_PFAD/schluesseltabellen/kenn_captions.unl


select now(), 'Lade Tabelle kenn_cifx';

\! sx_auto_upload_table.x kenn_cifx $KENN_PFAD/schluesseltabellen/kenn_cifx.unl


select now(), 'Lade Tabelle kenn_geschl';

\! sx_auto_upload_table.x kenn_geschl $KENN_PFAD/schluesseltabellen/kenn_geschl.unl


select now(), 'Lade Tabelle kenn_hzbart';

\! sx_auto_upload_table.x kenn_hzbart $KENN_PFAD/schluesseltabellen/kenn_hzbart.unl


select now(), 'Lade Tabelle kenn_kzfa';

\! sx_auto_upload_table.x kenn_kzfa $KENN_PFAD/schluesseltabellen/kenn_kzfa.unl


select now(), 'Lade Tabelle kenn_abschl_pruef_grp';

\! sx_auto_upload_table.x kenn_abschl_pruef_grp $KENN_PFAD/schluesseltabellen/kenn_abschl_pruef_grp.unl


select now(), 'Lade Tabelle tmp_kenn_katalog';

\! sx_upload_records.x tmp_kenn_katalog $KENN_PFAD/schluesseltabellen/kenn_katalog.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_GRUND_BW.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_GRUND_BW.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_GRUND_BW.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_KENN_BW.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_KENN_BW.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_KENN_BW.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_ERFOLG_SAH.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_ERFOLG_SAH.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_ERFOLG_SAH.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_ERFOLG_SAL.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_ERFOLG_SAL.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_ERFOLG_SAL.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_MWKBW2017.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_MWKBW2017.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_MWKBW2017.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_GuVQ.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_GuVQ.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_GuVQ.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_KAM_Q.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_KAM_Q.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_KAM_Q.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_GuV.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_GuV.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_GuV.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_Bilanz.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_Bilanz.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_Bilanz.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_KAM_J.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_KAM_J.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_KAM_J.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_rpt';

\! sx_upload_records.x tmp_kenn_katalog_rpt $KENN_PFAD/schluesseltabellen/kenn_katalog_rpt_KAM_JAZ.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_grp';

\! sx_upload_records.x tmp_kenn_katalog_grp $KENN_PFAD/schluesseltabellen/kenn_katalog_grp_KAM_JAZ.unl


select now(), 'Lade Tabelle tmp_kenn_katalog_sub';

\! sx_upload_records.x tmp_kenn_katalog_sub $KENN_PFAD/schluesseltabellen/kenn_katalog_sub_KAM_JAZ.unl


select now(), 'Lade Tabelle kenn_dim_fgr';

\! sx_auto_upload_table.x kenn_dim_fgr $KENN_PFAD/schluesseltabellen/kenn_dim_fgr.unl


select now(), 'Lade Tabelle kenn_lfb_fg';

\! sx_auto_upload_table.x kenn_lfb_fg $KENN_PFAD/schluesseltabellen/kenn_lfb_fg.unl


select now(), 'Lade Tabelle tmp_stg_astat';

\! sx_auto_upload_table.x tmp_stg_astat $KENN_PFAD/schluesseltabellen/kenn_stg_astat.unl


select now(), 'Lade Tabelle tmp_abschl_astat';

\! sx_auto_upload_table.x tmp_abschl_astat $KENN_PFAD/schluesseltabellen/kenn_abschl_astat.unl


select now(), 'Lade Tabelle kenn_hochschulen';

\! sx_auto_upload_table.x kenn_hochschulen $KENN_PFAD/schluesseltabellen/kenn_hochschulen.unl


select now(), 'Lade Tabelle kenn_report_stichtagsart';

\! sx_auto_upload_table.x kenn_report_stichtagsart $KENN_PFAD/schluesseltabellen/kenn_report_stichtagsart.unl


select now(), 'Lade Tabelle kenn_stichtagsart';

\! sx_auto_upload_table.x kenn_stichtagsart $KENN_PFAD/schluesseltabellen/kenn_stichtagsart.unl


select now(), 'Lade Tabelle kenn_bestandsart';

\! sx_auto_upload_table.x kenn_bestandsart $KENN_PFAD/schluesseltabellen/kenn_bestandsart.unl


select now(), 'Lade Tabelle kenn_bestandsart_bland';

\! sx_auto_upload_table.x kenn_bestandsart_bland $KENN_PFAD/schluesseltabellen/kenn_bestandsart_bland.unl


select now(), 'Lade Tabelle tmp_sx_jobs';

\! sx_auto_upload_table.x tmp_sx_jobs $KENN_PFAD/schluesseltabellen/sx_jobs.unl


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_hzbart_astat_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_hzbart_astat_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_stuart_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_stuart_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_stufrm_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_stufrm_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_stort_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_stort_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/macro_masken_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/macro_masken_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/macro_masken_bez_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/macro_masken_bez_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/macro_feld_wert_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/macro_feld_wert_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/dimension_bp_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/dimension_bp_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/dimension_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/dimension_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_reports_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_reports_fuellen.sql


select now(), 'Lade Tabelle kenn_stichtag';

\! sx_auto_upload_table.x kenn_stichtag $KENN_PFAD/schluesseltabellen/kenn_stichtag.unl


select now(), 'Lade Tabelle kenn_status';

\! sx_auto_upload_table.x kenn_status $KENN_PFAD/schluesseltabellen/kenn_status.unl


select now(), 'Lade Tabelle kenn_sb_astfr_lfb';

\! sx_auto_upload_table.x kenn_sb_astfr_lfb $KENN_PFAD/schluesseltabellen/kenn_sb_astfr_lfb.unl


select now(), 'Lade Tabelle kenn_k_buadbz';

\! sx_auto_upload_table.x kenn_k_buadbz $KENN_PFAD/schluesseltabellen/kenn_k_buadbz.unl


select now(), 'Lade Tabelle kenn_abschl_sbereich';

\! sx_auto_upload_table.x kenn_abschl_sbereich $KENN_PFAD/schluesseltabellen/kenn_abschl_sbereich.unl


select now(), 'Lade Tabelle kenn_sichten';

\! sx_auto_upload_table.x kenn_sichten $KENN_PFAD/schluesseltabellen/kenn_sichten.unl


select now(), 'Lade Tabelle tmp_extkotr_bawue';

\! sx_auto_upload_table.x tmp_extkotr_bawue $KENN_PFAD/schluesseltabellen/kenn_extkotr_bawue.unl


select now(), 'Lade Tabelle tmp_extkotr_sachsen';

\! sx_auto_upload_table.x tmp_extkotr_sachsen $KENN_PFAD/schluesseltabellen/kenn_extkotr_sachsen.unl


select now(), 'Lade Tabelle kenn_stelle_bvl_bez';

\! sx_auto_upload_table.x kenn_stelle_bvl_bez $KENN_PFAD/schluesseltabellen/kenn_stelle_bvl_bez.unl


select now(), 'Lade Tabelle kenn_stbb_kap_titel_bericht';

\! sx_auto_upload_table.x kenn_stbb_kap_titel_bericht $KENN_PFAD/schluesseltabellen/kenn_stbb_kap_titel_bericht.unl


select now(), 'Lade Tabelle kenn_zsl_ausgleich_kennungen';

\! sx_auto_upload_table.x kenn_zsl_ausgleich_kennungen $KENN_PFAD/schluesseltabellen/kenn_zsl_ausgleich_kennungen.unl


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/cif_upgrade.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/cif_upgrade.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/cif_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/cif_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/aggregierung_install.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/aggregierung_install.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/captions_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/captions_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_schluessel_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_schluessel_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_cifx_init.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_cifx_init.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_feste_konstanten_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_feste_konstanten_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_profil_ermitteln.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_profil_ermitteln.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/trans_kenn_extkotr.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/trans_kenn_extkotr.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/themenbaum_update.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/themenbaum_update.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/sichten_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/sichten_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/sx_stylesheets_einfuegen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/sx_stylesheets_einfuegen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/sachgebiete_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/sachgebiete_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/sx_repository_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/sx_repository_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/drop_k.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/drop_k.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/purge_themenbaum.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/purge_themenbaum.sql


select now(), 'SQL-Script $KENN_PFAD/hilfstabellen/set_sequences.sql ausfhren';


\!  DOSQL $KENN_PFAD/hilfstabellen/set_sequences.sql


select now(), 'SQL-Script $KENN_PFAD/prozeduren/proc_decval_create_pg.sql ausfhren';


\!  DOSQL $KENN_PFAD/prozeduren/proc_decval_create_pg.sql


select now(), 'SQL-Script $KENN_PFAD/upgrade/sx_repository_upgrade.sql ausfhren';


\!  DOSQL $KENN_PFAD/upgrade/sx_repository_upgrade.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/sx_jobs_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/sx_jobs_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/sx_keywords_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/sx_keywords_fuellen.sql


select now(), 'Scriptfile $KENN_PFAD/schluesseltabellen/kenn_rpt_version_fuellen.sql ausfhren';

	
\!  DOSQL $KENN_PFAD/schluesseltabellen/kenn_rpt_version_fuellen.sql
--Integrieren: 


select now(), 'Flle db_version';


delete from db_version  where his_system='kenn';
insert into db_version (his_system,version,systeminfo_id) values('kenn','2.5',109);



select now(), 'Flle db_tabellen';

delete from db_tabellen where name='kenn_sos_stg';
insert into db_tabellen (name,protokollierung) values('kenn_sos_stg',0);
delete from db_tabellen where name='kenn_sos_lab';
insert into db_tabellen (name,protokollierung) values('kenn_sos_lab',0);
delete from db_tabellen where name='kenn_semester';
insert into db_tabellen (name,protokollierung) values('kenn_semester',0);
delete from db_tabellen where name='kenn_stichtag';
insert into db_tabellen (name,protokollierung) values('kenn_stichtag',0);
delete from db_tabellen where name='kenn_staat';
insert into db_tabellen (name,protokollierung) values('kenn_staat',0);
delete from db_tabellen where name='kenn_geschl';
insert into db_tabellen (name,protokollierung) values('kenn_geschl',0);
delete from db_tabellen where name='kenn_hzbart';
insert into db_tabellen (name,protokollierung) values('kenn_hzbart',0);
delete from db_tabellen where name='kenn_kzfa';
insert into db_tabellen (name,protokollierung) values('kenn_kzfa',0);
delete from db_tabellen where name='kenn_hochschulen';
insert into db_tabellen (name,protokollierung) values('kenn_hochschulen',0);
delete from db_tabellen where name='kenn_busa_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_busa_aggr',0);
delete from db_tabellen where name='kenn_vtbu_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_vtbu_aggr',0);
delete from db_tabellen where name='kenn_flaeche';
insert into db_tabellen (name,protokollierung) values('kenn_flaeche',0);
delete from db_tabellen where name='kenn_stug';
insert into db_tabellen (name,protokollierung) values('kenn_stug',0);
delete from db_tabellen where name='kenn_su_imp_stud';
insert into db_tabellen (name,protokollierung) values('kenn_su_imp_stud',0);
delete from db_tabellen where name='kenn_alt_keys';
insert into db_tabellen (name,protokollierung) values('kenn_alt_keys',0);
delete from db_tabellen where name='kenn_fikr';
insert into db_tabellen (name,protokollierung) values('kenn_fikr',0);
delete from db_tabellen where name='kenn_inst_to_ext';
insert into db_tabellen (name,protokollierung) values('kenn_inst_to_ext',0);
delete from db_tabellen where name='kenn_inst';
insert into db_tabellen (name,protokollierung) values('kenn_inst',0);
delete from db_tabellen where name='kenn_extkotr';
insert into db_tabellen (name,protokollierung) values('kenn_extkotr',0);
delete from db_tabellen where name='kenn_sgd_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_sgd_aggr',0);
delete from db_tabellen where name='kenn_pbe_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_pbe_aggr',0);
delete from db_tabellen where name='kenn_pbv_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_pbv_aggr',0);
delete from db_tabellen where name='kenn_pbv_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_pbv_aggr_astat',0);
delete from db_tabellen where name='kenn_k_buadbz';
insert into db_tabellen (name,protokollierung) values('kenn_k_buadbz',0);
delete from db_tabellen where name='kenn_lfb_fg';
insert into db_tabellen (name,protokollierung) values('kenn_lfb_fg',0);
delete from db_tabellen where name='kenn_cifx';
insert into db_tabellen (name,protokollierung) values('kenn_cifx',0);
delete from db_tabellen where name='kenn_status';
insert into db_tabellen (name,protokollierung) values('kenn_status',0);
delete from db_tabellen where name='kenn_pruefrout';
insert into db_tabellen (name,protokollierung) values('kenn_pruefrout',0);
delete from db_tabellen where name='kenn_sb_astfr_lfb';
insert into db_tabellen (name,protokollierung) values('kenn_sb_astfr_lfb',0);
delete from db_tabellen where name='kenn_sichten';
insert into db_tabellen (name,protokollierung) values('kenn_sichten',0);
delete from db_tabellen where name='kenn_zahl_wert';
insert into db_tabellen (name,protokollierung) values('kenn_zahl_wert',0);
delete from db_tabellen where name='kenn_konto_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_konto_aggr',0);
delete from db_tabellen where name='kenn_drittm_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_drittm_aggr',0);
delete from db_tabellen where name='kenn_hsfinanz_stat';
insert into db_tabellen (name,protokollierung) values('kenn_hsfinanz_stat',0);
delete from db_tabellen where name='kenn_dr';
insert into db_tabellen (name,protokollierung) values('kenn_dr',0);
delete from db_tabellen where name='kenn_titel';
insert into db_tabellen (name,protokollierung) values('kenn_titel',0);
delete from db_tabellen where name='kenn_katalog';
insert into db_tabellen (name,protokollierung) values('kenn_katalog',0);
delete from db_tabellen where name='kenn_katalog_rpt';
insert into db_tabellen (name,protokollierung) values('kenn_katalog_rpt',0);
delete from db_tabellen where name='kenn_katalog_grp';
insert into db_tabellen (name,protokollierung) values('kenn_katalog_grp',0);
delete from db_tabellen where name='kenn_katalog_sub';
insert into db_tabellen (name,protokollierung) values('kenn_katalog_sub',0);
delete from db_tabellen where name='kenn_vari';
insert into db_tabellen (name,protokollierung) values('kenn_vari',0);
delete from db_tabellen where name='kenn_lieferung';
insert into db_tabellen (name,protokollierung) values('kenn_lieferung',0);
delete from db_tabellen where name='kenn_quartal_hier';
insert into db_tabellen (name,protokollierung) values('kenn_quartal_hier',0);
delete from db_tabellen where name='kenn_anlagen_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_anlagen_aggr',0);
delete from db_tabellen where name='kenn_stg_int';
insert into db_tabellen (name,protokollierung) values('kenn_stg_int',0);
delete from db_tabellen where name='kenn_abint';
insert into db_tabellen (name,protokollierung) values('kenn_abint',0);
delete from db_tabellen where name='kenn_hzbart_astat';
insert into db_tabellen (name,protokollierung) values('kenn_hzbart_astat',0);
delete from db_tabellen where name='kenn_stufrm';
insert into db_tabellen (name,protokollierung) values('kenn_stufrm',0);
delete from db_tabellen where name='kenn_stuart';
insert into db_tabellen (name,protokollierung) values('kenn_stuart',0);
delete from db_tabellen where name='kenn_stort';
insert into db_tabellen (name,protokollierung) values('kenn_stort',0);
delete from db_tabellen where name='kenn_antr_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_antr_aggr',0);
delete from db_tabellen where name='kenn_antr_prozess_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_antr_prozess_aggr',0);
delete from db_tabellen where name='kenn_stg_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_stg_aggr',0);
delete from db_tabellen where name='kenn_kzfach_int';
insert into db_tabellen (name,protokollierung) values('kenn_kzfach_int',0);
delete from db_tabellen where name='kenn_vert_int';
insert into db_tabellen (name,protokollierung) values('kenn_vert_int',0);
delete from db_tabellen where name='kenn_abschl_sbereich';
insert into db_tabellen (name,protokollierung) values('kenn_abschl_sbereich',0);
delete from db_tabellen where name='kenn_extkotr_stg';
insert into db_tabellen (name,protokollierung) values('kenn_extkotr_stg',0);
delete from db_tabellen where name='kenn_proj_gege';
insert into db_tabellen (name,protokollierung) values('kenn_proj_gege',0);
delete from db_tabellen where name='kenn_pbv_klr';
insert into db_tabellen (name,protokollierung) values('kenn_pbv_klr',0);
delete from db_tabellen where name='kenn_auslastung';
insert into db_tabellen (name,protokollierung) values('kenn_auslastung',0);
delete from db_tabellen where name='kenn_fibu_guv';
insert into db_tabellen (name,protokollierung) values('kenn_fibu_guv',0);
delete from db_tabellen where name='kenn_fibu_bilanz';
insert into db_tabellen (name,protokollierung) values('kenn_fibu_bilanz',0);
delete from db_tabellen where name='kenn_fibu_quartal';
insert into db_tabellen (name,protokollierung) values('kenn_fibu_quartal',0);
delete from db_tabellen where name='kenn_fibu_wiplan';
insert into db_tabellen (name,protokollierung) values('kenn_fibu_wiplan',0);
delete from db_tabellen where name='kenn_kam_quartal';
insert into db_tabellen (name,protokollierung) values('kenn_kam_quartal',0);
delete from db_tabellen where name='kenn_kam_ja';
insert into db_tabellen (name,protokollierung) values('kenn_kam_ja',0);
delete from db_tabellen where name='kenn_stupl';
insert into db_tabellen (name,protokollierung) values('kenn_stupl',0);
delete from db_tabellen where name='kenn_zulzahl_id';
insert into db_tabellen (name,protokollierung) values('kenn_zulzahl_id',0);
delete from db_tabellen where name='kenn_zulzahl_sem';
insert into db_tabellen (name,protokollierung) values('kenn_zulzahl_sem',0);
delete from db_tabellen where name='kenn_zulzahl2int';
insert into db_tabellen (name,protokollierung) values('kenn_zulzahl2int',0);
delete from db_tabellen where name='kenn_vtbu_qp_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_vtbu_qp_aggr',0);
delete from db_tabellen where name='kenn_stg_cube';
insert into db_tabellen (name,protokollierung) values('kenn_stg_cube',0);
delete from db_tabellen where name='kenn_sember_stg_cube';
insert into db_tabellen (name,protokollierung) values('kenn_sember_stg_cube',0);
delete from db_tabellen where name='kenn_antr_cube';
insert into db_tabellen (name,protokollierung) values('kenn_antr_cube',0);
delete from db_tabellen where name='kenn_extkotr_lfb_hs';
insert into db_tabellen (name,protokollierung) values('kenn_extkotr_lfb_hs',0);
delete from db_tabellen where name='kenn_bestand';
insert into db_tabellen (name,protokollierung) values('kenn_bestand',0);
delete from db_tabellen where name='kenn_report_stichtagsart';
insert into db_tabellen (name,protokollierung) values('kenn_report_stichtagsart',0);
delete from db_tabellen where name='kenn_bestandsart';
insert into db_tabellen (name,protokollierung) values('kenn_bestandsart',0);
delete from db_tabellen where name='kenn_bestandsart_bland';
insert into db_tabellen (name,protokollierung) values('kenn_bestandsart_bland',0);
delete from db_tabellen where name='kenn_promo';
insert into db_tabellen (name,protokollierung) values('kenn_promo',0);
delete from db_tabellen where name='kenn_promo_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_promo_aggr',0);
delete from db_tabellen where name='kenn_stichtagsart';
insert into db_tabellen (name,protokollierung) values('kenn_stichtagsart',0);
delete from db_tabellen where name='kenn_dim_extkotr';
insert into db_tabellen (name,protokollierung) values('kenn_dim_extkotr',0);
delete from db_tabellen where name='kenn_pkosten_cube';
insert into db_tabellen (name,protokollierung) values('kenn_pkosten_cube',0);
delete from db_tabellen where name='kenn_dim_extkost';
insert into db_tabellen (name,protokollierung) values('kenn_dim_extkost',0);
delete from db_tabellen where name='kenn_skosten_cube';
insert into db_tabellen (name,protokollierung) values('kenn_skosten_cube',0);
delete from db_tabellen where name='kenn_flaeche_cube';
insert into db_tabellen (name,protokollierung) values('kenn_flaeche_cube',0);
delete from db_tabellen where name='kenn_dim_lfb_fg';
insert into db_tabellen (name,protokollierung) values('kenn_dim_lfb_fg',0);
delete from db_tabellen where name='kenn_pbv_astat';
insert into db_tabellen (name,protokollierung) values('kenn_pbv_astat',0);
delete from db_tabellen where name='kenn_sos_astat';
insert into db_tabellen (name,protokollierung) values('kenn_sos_astat',0);
delete from db_tabellen where name='kenn_lab_astat';
insert into db_tabellen (name,protokollierung) values('kenn_lab_astat',0);
delete from db_tabellen where name='kenn_stg_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_stg_aggr_astat',0);
delete from db_tabellen where name='kenn_stud_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_stud_aggr_astat',0);
delete from db_tabellen where name='kenn_lab_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_lab_aggr_astat',0);
delete from db_tabellen where name='kenn_absolv_aggr_astat';
insert into db_tabellen (name,protokollierung) values('kenn_absolv_aggr_astat',0);
delete from db_tabellen where name='kenn_dim_fgr';
insert into db_tabellen (name,protokollierung) values('kenn_dim_fgr',0);
delete from db_tabellen where name='kenn_sos_astat_2015';
insert into db_tabellen (name,protokollierung) values('kenn_sos_astat_2015',0);
delete from db_tabellen where name='kenn_lab_astat_2015';
insert into db_tabellen (name,protokollierung) values('kenn_lab_astat_2015',0);
delete from db_tabellen where name='kenn_kennz_aggr';
insert into db_tabellen (name,protokollierung) values('kenn_kennz_aggr',0);
delete from db_tabellen where name='kenn_prom_astat';
insert into db_tabellen (name,protokollierung) values('kenn_prom_astat',0);
delete from db_tabellen where name='kenn_abschl_pruef_grp';
insert into db_tabellen (name,protokollierung) values('kenn_abschl_pruef_grp',0);
delete from db_tabellen where name='kenn_stelle_bvl_bez';
insert into db_tabellen (name,protokollierung) values('kenn_stelle_bvl_bez',0);
delete from db_tabellen where name='kenn_stelle_hhpl';
insert into db_tabellen (name,protokollierung) values('kenn_stelle_hhpl',0);
delete from db_tabellen where name='kenn_stbb_kap_titel_bericht';
insert into db_tabellen (name,protokollierung) values('kenn_stbb_kap_titel_bericht',0);
delete from db_tabellen where name='kenn_rpt_ansprech';
insert into db_tabellen (name,protokollierung) values('kenn_rpt_ansprech',0);
delete from db_tabellen where name='kenn_rpt_version';
insert into db_tabellen (name,protokollierung) values('kenn_rpt_version',0);
delete from db_tabellen where name='kenn_stylesheet_version';
insert into db_tabellen (name,protokollierung) values('kenn_stylesheet_version',0);
delete from db_tabellen where name='kenn_zsl_ausgleich_kennungen';
insert into db_tabellen (name,protokollierung) values('kenn_zsl_ausgleich_kennungen',0);


select now(), 'Flle sachgebiete, systeminfo und themenbaum';



--Das Sachgebiet wird erzeugt, ggf. vorherige Sachgebiete sichern.


insert into sachgebiete(tid,name) select 109,'Kennzahlen'
from xdummy
where 0=(select count(*) from sachgebiete S where S.tid=109);
insert into group_sachgeb_bez 
select G.tid,109 from groupinfo G 
where (G.name='Administratoren' or G.name='superx')
and 0=(select count(*) from group_sachgeb_bez G where G.sachgebiete_id=109);

-- his1 rightname fuer Sachgebiete nachtragen


--freemarker template

<#if TableFieldExists?exists&&TableFieldExists('sachgebiete','rightname')>

update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFI]' where tid=109;
update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFS]' where tid=110;
update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFH]' where tid=111;
update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFC]' where tid=112;
update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFF]' where tid=113;
update sachgebiete set rightname='CS_BIA_ADMINISTRATE_TOPIC_AREA[PFI]' where tid=22;
update sachgebiete set rightname='CS_BIA_ADMINISTRATE_TOPIC_AREA[PFM]' where tid=114;
</#if>

 -- wird auch noch mal als template aufgerufen in sx_tables_fuellen.sql  --Das system wird erzeugt, ggf. vorherige systeme sichern.

insert into systeminfo(tid,name,datum) select 109,'Kennzahlen',date('1.1.1900')
from xdummy
where 0=(select count(*) from systeminfo S where S.tid=109);



select now(), 'Das Thema und die Masken in den Themenbaum einfgen';


--Das Thema und die Masken in den Themenbaum einfgen
--zunaechst werden die Eintraege in den themenbaum_bak eingefuegt, default ist parent=themenbaum_root
-- auf Serial setzen, damit fortlaufende Nummern vergeben werden
create temp table tmp_themenbaum
  (
    tid serial,
    name varchar(255) not null ,
    maskeninfo_id integer,
    parent integer,
    parentname char(50),
    gueltig_seit date,
    gueltig_bis date,
    erlaeuterung char(240)
  );
  create temp table tmp_themenbaum2
  (
    tid integer,
    name varchar(255) not null ,
    maskeninfo_id integer,
    parent integer,
    parentname char(50),
    gueltig_seit date,
    gueltig_bis date,
    erlaeuterung char(240)
  );
  
  

select setval('tmp_themenbaum_tid_seq',(select max(tid)+1 from themenbaum));


select now(), 'root fr das Modul einfgen und in den Themenbaum einhngen:';


insert into tmp_themenbaum
(  tid,name, gueltig_seit,gueltig_bis )
select max(tid)+1,'Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000') from themenbaum;

update tmp_themenbaum set parent=(select max(tid) from themenbaum where name='Abfragen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Grunddaten Studierende, Prfungen','Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'),'@@kenn_pers_beschreibung@@ @@@kenn_pers_doku_benutzer_url@@@');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Grunddaten Studierende, Prfungen' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('ZSL-Mittelverteilung','Grunddaten Studierende, Prfungen',date_val('01.01.1900'),date_val('01.01.3000'),'');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='ZSL-Mittelverteilung' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Grunddaten Stellen, Personal','Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'),'@@kenn_pers_beschreibung@@ @@@kenn_pers_doku_benutzer_url@@@');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Grunddaten Stellen, Personal' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Grunddaten Kostenrechnung','Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'),'@@kenn_klr_beschreibung@@ @@@kenn_klr_doku_benutzer_url@@@');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Grunddaten Kostenrechnung' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Grunddaten Finanzrechnung','Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'),'@@kenn_fin_beschreibung@@ @@@kenn_fin_doku_benutzer_url@@@');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Grunddaten Finanzrechnung' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Zentrale Kennzahlen','Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'),'@@@kenn_sem_doku_benutzer_url@@@');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Zentrale Kennzahlen' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Semesterberichte','Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'),'@@kenn_sem_beschreibung@@ @@@kenn_sem_doku_benutzer_url@@@');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Semesterberichte' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Fachhochschulen','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'),'Die Semesterberichte der Fachhochschulen @@@kenn_sem_doku_benutzer_url@@@');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Fachhochschulen' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Pdagogische Hochschulen','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'),'Die Semesterberichte der Pdagogische Hochschulen @@@kenn_sem_doku_benutzer_url@@@');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Pdagogische Hochschulen' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Administration Grunddaten und Kennzahlen','Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'),'@@kenn_admin_beschreibung@@ @@@kenn_doku_admin_url@@@');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Administration Grunddaten und Kennzahlen' 
or T.name='Grunddaten und Kennzahlen');
insert into tmp_themenbaum(name, parentname, gueltig_seit,gueltig_bis,erlaeuterung)
 values('Grunddaten Forschung','Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'),'Kennzahlen zur Forschung');

--gibt es das Thema schon?
delete from tmp_themenbaum where name in (select T.name from themenbaum  T where T.name='Grunddaten Forschung' 
or T.name='Grunddaten und Kennzahlen');

--root fr das Modul einfgen und in den Themenbaum einhngen
--update themenbaum_bak set parent=(select tid from themenbaum where parent is null)
--where parent is null;
--update themenbaum_bak set tid=(select max(tid) from themenbaum 
--Nun die Eintrge einfgen, die tids werden durch das serial-Feld erzeugt:
--insert into tmp_themenbaum(name, maskeninfo_id,parentname, gueltig_seit,gueltig_bis)
--select name, maskeninfo_id,parent, gueltig_seit,gueltig_bis from themenbaum_bak;
--update tmp_themenbaum set parentname=(select name from themenbaum_bak T where T.tid=tmp_themenbaum.parent);

--Nun die einzelnen Masken


select now(), 'Nun die einzelnen Masken:';


insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Prfprotokoll Kenn-Modul','18140','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kostenartenbericht','18160','Grunddaten Kostenrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kostentrger Lehre-Studiengnge','18180','Grunddaten Kostenrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Schlsselverzeichnis KENN-Modul','18200','Zentrale Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Gesamtberblick Grunddaten und Kennzahlen (BaWue)','18220','Zentrale Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Grunddaten und Kennzahlen hinzufgen (csv)','18240','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Grunddaten und Kennzahlen suchen','18260','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Stichtage verwalten','18280','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Semesterbericht Studierende Datenblatt','18400','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Semesterbericht Datenblatt Bewerbungen','18420','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende Pivottabelle','18440','Pdagogische Hochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Tab. 1 Bewerbungen nach Prfungsgruppen und Status','18460','Pdagogische Hochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Semesterbericht Pd. Hochschulen','18480','Pdagogische Hochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kostenartenbericht (extern)','18580','Grunddaten Kostenrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Studierende und Studienanfnger','18620','Grunddaten Studierende, Prfungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Absolventen nach Geschlecht','18640','Grunddaten Studierende, Prfungen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Anlagespiegel nach Anlageklasse','18660','Grunddaten Finanzrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Tab.1 Bewerbungen und Studierende nach Hochschule','18760','Fachhochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Tab.2 Bewerbungen und Studienanfnger nach HZB-Art','18780','Fachhochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Tab.4 Studierende nach Fach und Hochschule','18800','Fachhochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Tab.5 Studierende nach Fach und Trgerschaft','18820','Fachhochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Tab.6 Studierende nach Fach und Fachsemester','18840','Fachhochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Tab.7 Studierende nach Fach und Fachsemester fr alle Hochschulen','18860','Fachhochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Tabelle 1-7 Bewerbungs- und Studierendenstatistik','18880','Fachhochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Semesterbericht Hochschulverzeichnis','18900','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Semesterbericht Studienfcher','18920','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Schlsselverzeichnis KENN-Modul gesamt','18940','Zentrale Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Tab.3 Bewerbungen','18960','Fachhochschulen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kameraler Quartalsbericht (Sachsen)','18980','Grunddaten Finanzrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kameraler Jahresbericht Hochschule (Sachsen)','18520','Grunddaten Finanzrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Stellenbewirtschaftungsbericht Hochschulkapitel 1208-1241','18540','Grunddaten Stellen, Personal',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Gesamtberblick Grunddaten und Kennzahlen (Sachsen)','18100','Zentrale Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Produktbericht (Sachsen)','18120','Grunddaten Kostenrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kaufmnnischer Jahresabschluss','18380','Grunddaten Finanzrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kaufmnnischer Quartalsbericht','18560','Grunddaten Finanzrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('KENN Formularbearbeitung','18040','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('bersicht der Bestnde','18700','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kamerales Jahresbericht zahlem. (Sachsen)','32120','Grunddaten Finanzrechnung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Wirtschaftsplan, Leerstellenbericht und Groforschungsprojekte abrufen','32140','Zentrale Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Grunddaten und Kennzahlen hinzufgen (Datei)','32200','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kennzahlen-Bericht 2017 (BaWue)','32220','Zentrale Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Kennzahlen-Bericht 2017 Datenblatt (BaWue)','32260','Zentrale Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Dokument hochladen','32320','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Stellen lt. HH-Plan','32360','Grunddaten Stellen, Personal',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Stellenbewirtschaftungsbericht Kapitel 1207','32380','Grunddaten Stellen, Personal',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Stichtage abrufen','32600','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Versionen abrufen','32660','Administration Grunddaten und Kennzahlen',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('ZSL-Mittelverteilung (Gesamtbericht)','32860','ZSL-Mittelverteilung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('ZSL-Mittelverteilung (Teiltabelle)','32880','ZSL-Mittelverteilung',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Semesterbericht Datenblatt Studierende (amtlich)','32900','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Semesterbericht Datenblatt Absolvierende (amtlich)','32930','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Semesterbericht Datenblatt Promovierende (amtlich)','32960','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'));

insert into tmp_themenbaum
(  name  ,maskeninfo_id, parentname,
   gueltig_seit ,
   gueltig_bis)
values('Semesterbericht Bewerbungsprozess Datenblatt','32980','Semesterberichte',date_val('01.01.1900'),date_val('01.01.3000'));

--gibt es die Maske schon?
delete from tmp_themenbaum where maskeninfo_id in (select T.maskeninfo_id from themenbaum  T);


select now(), 'Die einzelnen Masken sind eingefgt.';



insert into tmp_themenbaum2 select * from tmp_themenbaum;
update tmp_themenbaum set parent=(select max(tid) from tmp_themenbaum2 T where tmp_themenbaum.parentname=T.name)
where parent is null;
--Wenn das Thema im echten Themenbaum schon drin war, wird da als parent genommen
update tmp_themenbaum set parent=(select max(tid) from themenbaum T where tmp_themenbaum.parentname=T.name)
where parent is null;

--Defaultmaessig werden alle parents auf themenbaum_root gesetzt
update tmp_themenbaum set parent=(select max(tid) from themenbaum where parent is null)
where parent is null;
insert into themenbaum(tid,name, maskeninfo_id,parent, gueltig_seit,gueltig_bis,erlaeuterung,sort)
select tid,name, maskeninfo_id,parent, gueltig_seit,gueltig_bis,erlaeuterung,0 from tmp_themenbaum;
drop table tmp_themenbaum2;
drop table tmp_themenbaum;


select setval('themenbaum_tid_seq',(select max(tid)+1 from themenbaum));
update themenbaum set erlaeuterung='@@kenn_beschreibung@@ @@@kenn_doku_benutzer_url@@@ @@@legende@@@' where name='Grunddaten und Kennzahlen';
update themenbaum set erlaeuterung='@@kenn_pers_beschreibung@@ @@@kenn_pers_doku_benutzer_url@@@' where name='Grunddaten Studierende, Prfungen';
update themenbaum set erlaeuterung='@@kenn_pers_beschreibung@@ @@@kenn_pers_doku_benutzer_url@@@' where name='Grunddaten Stellen, Personal';
update themenbaum set erlaeuterung='@@kenn_klr_beschreibung@@ @@@kenn_klr_doku_benutzer_url@@@' where name='Grunddaten Kostenrechnung';
update themenbaum set erlaeuterung='@@kenn_fin_beschreibung@@ @@@kenn_fin_doku_benutzer_url@@@' where name='Grunddaten Finanzrechnung';
update themenbaum set erlaeuterung='@@@kenn_sem_doku_benutzer_url@@@' where name='Zentrale Kennzahlen';
update themenbaum set erlaeuterung='@@kenn_sem_beschreibung@@ @@@kenn_sem_doku_benutzer_url@@@' where name='Semesterberichte';
update themenbaum set erlaeuterung='Die Semesterberichte der Fachhochschulen @@@kenn_sem_doku_benutzer_url@@@' where name='Fachhochschulen';
update themenbaum set erlaeuterung='Die Semesterberichte der Pdagogische Hochschulen @@@kenn_sem_doku_benutzer_url@@@' where name='Pdagogische Hochschulen';
update themenbaum set erlaeuterung='@@kenn_admin_beschreibung@@ @@@kenn_doku_admin_url@@@' where name='Administration Grunddaten und Kennzahlen';
update themenbaum set erlaeuterung='Kennzahlen zur Forschung' where name='Grunddaten Forschung';
 
CREATE temp TABLE tmp_db_forms (
    tid serial NOT NULL,
    name character(100),
    tablename character(100),
    form_path character(255),
    caption character(200),
    description character(255)
);
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('kenn_sichten','kenn_sichten','/edit/kenn/kenn_sichten_edit.jsp','Sichten fr das KENN-Modul bearbeiten'::varchar(200),'In diesem Formular knnen Sie Sichten fr zu berechnende Grunddaten und Kennzahlen festlegen. Nach einer nderung mssen Sie den kenn_update.x neu starten.'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('kenn_zulzahl2int_edit','kenn_zulzahl2int','/edit/kenn/kenn_zulzahl2int_edit.jsp','Hochschulinterne Studiengnge zur ID aus der BaWue-Datenbank zuordnen'::varchar(200),'In diesem Formular knnen Sie Hochschulinterne Studiengnge zur Zulassungszahl-IDs (BaWue-Datenbank) zuordnen'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('kenn_zulzahl_id_edit','kenn_zulzahl_id','/edit/kenn/kenn_zulzahl_id_edit.jsp','Studiengnge (extern) bearbeiten'::varchar(200),'In diesem Formular knnen Sie Zulassungszahl-IDs verwalten'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('kenn_rpt_ansprech_list','kenn_rpt_ansprech','/edit/kenn/kenn_rpt_ansprech_list.jsp','Ansprechpartner/-innen zum Bericht (Listenformular)'::varchar(200),'In diesem Formular knnen Sie Ansprechpartner/-innen zum Bericht bearbeiten. Diese Angaben werden als Kontaktadressen zum zustndigen Landesministerium bertragen (nur Sachsen).'::varchar(255));

create temp table tmp_hilf(tid integer);
insert into tmp_hilf select max(tid) from db_forms;
update tmp_hilf set tid=0 where tid is null;
insert into db_forms(tid,name, tablename,form_path,caption,description)
select H.tid+D.tid, name, tablename,form_path,caption,description
from tmp_db_forms D, tmp_hilf H;

insert into sachgeb_dbform_bez select  109, H.tid+D.tid 
from tmp_db_forms D, tmp_hilf H;

drop table tmp_hilf;
drop table tmp_db_forms;


select now(), 'Flle sx_tables, sx_fields und unload_params';


\! DOSQL $KENN_PFAD/conf/sx_tables_fuellen.sql
\! DOSQL $KENN_PFAD/conf/unload_params_fuellen.sql

\! DOSQL $KENN_PFAD/kenn_install_custom.sql
