create temp table tmp_pbv_aggr (
tid serial,
personal_nr integer,
besch_verh_nr integer,
besch_st_nr integer,
geschlecht smallint,
ch110_besch_st char(10),
bund_fachgebiet char(10),
ca107_dienstart char(10),
bund_dienstart smallint,
vertart char(10),
bund_taetigkeit smallint,
ca108_amtsbez char(10),
buadbz char(5),
ch212_geldgeber char(10),
klr_geldgeber char(10),
kapitel char(5),
beurl_art char(10), 
vzae double precision,
drittmittel smallint,
projekt  char(10) ,
kostenstelle char(10),
extkotr char(30) ,
extkost char(30),
stichtag date,
zaehlung char(2),
d_befristung date,
befristet SMALLINT,
ca501_staat integer,
datum date,
d_besch_von     date,
d_besch_bis     date,
wochenstunden double precision,
stunden_gewichtet double precision,
stunden_pro_jahr double precision,
pfi_prozent     double precision,
anteil_proz    double precision,
dauer_tage integer,
summe double precision
);

--VZ pro Jahr Sachsen:
--Vollzeit-quivalente
insert into tmp_pbv_aggr (
geschlecht,
ch110_besch_st,
ca107_dienstart,
vertart,
ca108_amtsbez,
ch212_geldgeber,
kapitel,
projekt ,
kostenstelle,
beurl_art,
stichtag,
zaehlung,
datum,
d_befristung,
ca501_staat,
d_besch_von,
d_besch_bis,
pfi_prozent,
anteil_proz, 
wochenstunden)
select  
A.geschlecht,
A.ch110_besch_st,
A.ca107_dienstart,
A.vertart,
A.ca108_amtsbez,
A.ch212_geldgeber,
A.kapitel,
A.projekt ,
A.kostenstelle,
A.beurl_art,
S.stichtag,
'j'::char(1),
today(),
A.d_befristung,
A.ca501_staat,
d_besch_von,
d_besch_bis,
pfi_prozent,
anteil_proz, 
sum(stunden) from sva_inst I,sva_pbv_aggr A, kenn_stichtag S
where 
  S.stichtagsart='Personalstatistik'
and S.berechnen='1'
and I.key_apnr=A.ch110_besch_st
and S.stichtag between I.gueltig_seit and I.gueltig_bis
and year(S.stichtag) between year(A.d_besch_von) and year(A.d_besch_bis)
and A.vertart in (select V.apnr from sva_k_vertragsart V where bundstat_relevant='J')
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19
;
--Wenn Beginn der Beschftigung vor Jahresbeginn liegt:
update tmp_pbv_aggr set d_besch_von=date_val('01.01.' || year(stichtag))
where zaehlung='j'
and d_besch_von <date_val('01.01.' || year(stichtag));
--Wenn Ende der Beschftigung nach Jahresende liegt:
update tmp_pbv_aggr set d_besch_bis=date_val('31.12.' || year(stichtag))
where zaehlung='j'
and d_besch_bis > date_val('31.12.' || year(stichtag));
--Dauer in Tagen ermitteln:
update tmp_pbv_aggr set dauer_tage=d_besch_bis-d_besch_von+1
where zaehlung='j';
--Stunden anteilig auf poz_prozent und pfi_prozent:
update tmp_pbv_aggr set stunden_gewichtet=wochenstunden*pfi_prozent*anteil_proz/10000
where zaehlung='j';
--Wochenstunden hochrechnen auf Stunden pro Jahr:
update tmp_pbv_aggr set stunden_pro_jahr =stunden_gewichtet * 52  * dauer_tage/364
where zaehlung='j';
--wenn ganzes Jahr:
update tmp_pbv_aggr set stunden_pro_jahr =stunden_gewichtet * 52 
where zaehlung='j'
and dauer_tage = 365;
--VZ Formel Sachsen: stunden_pro_jahr / (52 *40) 
update tmp_pbv_aggr set summe =stunden_pro_jahr /(52*40) 
where zaehlung='j';

--Ende VZ Jahr

update tmp_pbv_aggr set buadbz=(select bund_adbz from sva_k_amtsdienst where apnr=tmp_pbv_aggr.ca108_amtsbez)
;

--Ermittlung KLR-Geldgeber
update tmp_pbv_aggr set klr_geldgeber=
(select C.gruppe from  sva_cifx C 
where C.key=636
and tmp_pbv_aggr.ch212_geldgeber=C.apnr)
where ch212_geldgeber is not null;
update tmp_pbv_aggr set klr_geldgeber=substring(klr_geldgeber from 5 for 20)
where klr_geldgeber like 'KLR_%';


--wird nur in Sachsen benutzt:

--beurlaubtes Personal wird nur gezhlt wenn Bezge gezahlt werden:
delete from tmp_pbv_aggr where beurl_art in (
select C.apnr from sva_cifx C
where C.key=106
and (C.struktur_c is null or  C.struktur_c != 'J') --C.struktur_c enthlt Bezge-KZ, ggf. mit "J" gefllt
);

--09.07.2012 Sachsen: Sofern Kostenstelle und Kostentrger zugeordnet sind, wird der externe Schlssel des Kostentrgers (der Finanzierung) ausgewertet. 
update tmp_pbv_aggr set extkotr=(select P.k_extkotr from cob_proj P
where P.projnr=tmp_pbv_aggr.projekt)
;
-- ext. Kostenstelle ermitteln
update tmp_pbv_aggr set extkost=(select min(I.key_extkotr) from kenn_inst_to_ext I
where I.instnr=tmp_pbv_aggr.kostenstelle
and I.key_extkotr is not null
and trim(I.key_extkotr) !='')
;
--wenn projnr leer ist, wird ext. Kostenstelle genommen
update tmp_pbv_aggr set extkotr=extkost where extkost is not null
and extkotr is null;

update tmp_pbv_aggr set extkotr=(select min(E.key) from kenn_inst I, kenn_extkotr E
where substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Produktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
and E.kategorie='lf' --Ebene LFB
and E.key like '1%' --nur Lehre
and I.key_apnr=tmp_pbv_aggr.kostenstelle)
where extkotr is null;
--Validierung: bitte die u.g. Selektionen einzeln ausfhren, ja nach Bedarf:

--Beispiel fr KLR-Geldgeber 11: Bundesministerium fr Bildung und Forschung
--Personal VZ mit Personal-Nr / Pseudonym z.B. im Jahr 2014:
select personal_nr,sum(summe)
from tmp_pbv_aggr
where  buadbz not in ('510','520','530','592') --ohne Lehrbeauftr.
and year(stichtag)=2014
and klr_geldgeber='11'
group by 1
order by 1;
--LFB-Summe VZ z.B. im Jahr 2014:
select substring(extkotr from 4 for 3),sum(summe)
from tmp_pbv_aggr
where   buadbz not in ('510','520','530','592') --ohne Lehrbeauftr
and year(stichtag)=2014
and klr_geldgeber='11'
group by 1
order by 1;
--Personal Kpfe mit Personal-Nr / Pseudonym z.B. im Jahr 2014:
select distinct personal_nr
from tmp_pbv_aggr
where   buadbz not in ('510','520','530','592') --ohne Lehrbeauftr
and year(stichtag)=2014
and klr_geldgeber='11'
order by 1;
--LFB-Summe Kpfe z.B. im Jahr 2014:
select substring(extkotr from 4 for 3),count(distinct personal_nr)
from tmp_pbv_aggr
where   buadbz not in ('510','520','530','592') --ohne Lehrbeauftr
and year(stichtag)=2014
and klr_geldgeber='11'
group by 1
order by 1;
--Summen fr alle KLR-Geldgeber:
--Summe VZ z.B. im Jahr 2014:
select klr_geldgeber,sum(summe)
from tmp_pbv_aggr
where   buadbz not in ('510','520','530','592') --ohne Lehrbeauftr
and year(stichtag)=2014
group by 1
order by 1;
--Summe Kpfe z.B. im Jahr 2014:
select klr_geldgeber,count(distinct personal_nr)
from tmp_pbv_aggr
where   buadbz not in ('510','520','530','592') --ohne Lehrbeauftr
and year(stichtag)=2014
group by 1
order by 1;

drop table tmp_pbv_aggr;
