--(c) 2008 Daniel Quathamer
--freemarker template

<sqlvars>

<sqlvar name="lehr_stg_ab_stug_exists">
select sp_table_exists('lehr_stg_ab_stug') from xdummy
</sqlvar>
<sqlvar name="zul_installed">
select count(*) from db_version where his_system ='zul';
</sqlvar>
<sqlvar name="KENN_BEW_MAN_var">
select apnr from konstanten where beschreibung='KENN_BEW_MAN'
</sqlvar>

</sqlvars>


<#assign KENN_BEW_MAN=0 />
<#if KENN_BEW_MAN_var?exists && KENN_BEW_MAN_var?string?length &gt; 0>
<#assign KENN_BEW_MAN=KENN_BEW_MAN_var />
</#if>

<#if  zul_installed=1 && KENN_BEW_MAN=0 &&  lehr_stg_ab_stug_exists=1>

create temp table tmp_kenn_antr_aggr
( 
hs_nr integer, 
bewsem smallint,
stg char(10),
abschluss char(10),
datum date,
stug_key char(20),
fach_sem_zahl smallint,
summe integer);

insert into tmp_kenn_antr_aggr(hs_nr,bewsem,stg,abschluss,datum,fach_sem_zahl,summe)
select hs_nr,bewsem,stg_int,abint,datum,fach_sem_zahl,sum(summe) 
from kenn_antr_aggr
where bewsem in (select distinct K.bezugszeit 
from kenn_stichtag K
where K.stichtagsart in ('Bewerber Gesamt', 'Bewerber 1. FS')
and K.berechnen='1')
and ${KENN_BEW_ZUL_ANTRNR}
group by 1,2,3,4,5,6
;

<#if TableFieldExists?exists&&TableFieldExists('lehr_stg_ab_stug','stug_key')>
update tmp_kenn_antr_aggr set stug_key=(select min(L.stug_key)
from lehr_stg_ab_stug L
where L.stg=tmp_kenn_antr_aggr.stg
and L.abschluss=tmp_kenn_antr_aggr.abschluss);
</#if>

delete from kenn_zahl_wert
where kenn_zahl ='BEWERB_G'
and sem in (select distinct K.bezugszeit 
from kenn_stichtag K
where K.stichtagsart in ('Bewerber Gesamt')
and K.berechnen='1');

delete from kenn_zahl_wert
where kenn_zahl ='BEWERB_1'
and sem in (select distinct K.bezugszeit 
from kenn_stichtag K
where K.stichtagsart in ('Bewerber 1. FS')
and K.berechnen='1');



insert into kenn_zahl_wert
( hs_nr,
       kenn_zahl,
       sem,
       stugkey,
       wert)
select hs_nr,
'BEWERB_G'::char(10),
bewsem,
stug_key,
sum(summe)
from tmp_kenn_antr_aggr
where bewsem in (select distinct K.bezugszeit 
from kenn_stichtag K
where K.stichtagsart in ('Bewerber Gesamt')
and K.berechnen='1')
group by 1,2,3,4;


insert into kenn_zahl_wert
( hs_nr,
       kenn_zahl,
       sem,
       stugkey,
       wert)
select hs_nr,
'BEWERB_1'::char(10),
bewsem,
stug_key,
sum(summe)
from tmp_kenn_antr_aggr
where fach_sem_zahl=1
and bewsem in (select distinct K.bezugszeit 
from kenn_stichtag K
where K.stichtagsart in ('Bewerber 1. FS')
and K.berechnen='1')
group by 1,2,3,4;


insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select today(),
'kenn_antr_aggr'::char(18),
'kenn_zahl_wert'::char(18),
('Grunddatum Bewerber (gesamt): Es wurden im Semester ' || bewsem || ' insgesamt ' || sum(summe)::integer || ' Bewerber eingefgt. ')::char(200),
'Info'::char(10) 
from tmp_kenn_antr_aggr S 
where S.bewsem in (select distinct K.bezugszeit 
from kenn_stichtag K
where K.stichtagsart in ('Bewerber Gesamt')
and K.berechnen='1')
group by S.bewsem
;  

insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select today(),
'kenn_antr_aggr'::char(18),
'kenn_zahl_wert'::char(18),
('Grunddatum Bewerber (1.FS): Es wurden im Semester ' || bewsem || ' insgesamt ' || sum(summe)::integer || ' Bewerber eingefgt. ')::char(200),
'Info'::char(10) 
from tmp_kenn_antr_aggr S 
where S.fach_sem_zahl=1
and S.bewsem in (select distinct K.bezugszeit 
from kenn_stichtag K
where K.stichtagsart in ('Bewerber 1. FS')
and K.berechnen='1')
group by S.bewsem
;  

insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select today(),
'kenn_antr_aggr'::char(18),
'kenn_zahl_wert'::char(18),
('Grunddaten Bewerber: Es wurden im Semester ' || bewsem || ' im Fach ' || trim(nvl(S.stg,'Unbek.'::char)) || ' und Abschluss ' || trim(nvl(S.abschluss,'Unbek.'::char)) || ' insgesamt ' || sum(summe)::integer || ' Bewerber ohne KLR-Studiengang eingefgt. ')::char(200),
'Warnung'::char(10) 
from tmp_kenn_antr_aggr S 
where S.stug_key is null
group by S.bewsem,S.stg,S.abschluss
;  

drop table tmp_kenn_antr_aggr;

</#if>

