--freemarker template

<sqlvars>
 <sqlvar name="KENN_KOSTEN_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_KOSTEN_DATENQUELLE'
    </sqlvar>
    <sqlvar name="bezugszeiten">
        SELECT bezugszeit,kotr_art,bezugsart
        from kenn_vari V
        where V.kotr_art ='Q'
        order by 2,1,3
        ;
    </sqlvar>
    <sqlvar name="cob_installed">
        select count(*) from db_version where his_system ='cob';
    </sqlvar>

</sqlvars>
 create temp table tmp_quartal
        (
        tid integer,
        bezugszeit integer,
        jahr smallint,
        quartal integer
        );

        --zuerst alle Quartale zusammenstellen:

        insert into tmp_quartal(
        tid,
        bezugszeit,
        jahr,
        quartal
        )
        select tid,
        val(bezugszeit || '1'),
        bezugszeit,
        1
        from kenn_stichtag
        where stichtagsart_id='KOTN_QP'
        and berechnen='1'
        and bezugsart='J';
        insert into tmp_quartal(
        tid,
        bezugszeit,
        jahr,
        quartal
        )
        select tid,
        val(bezugszeit || '2'),
        bezugszeit,
        2

        from kenn_stichtag
        where stichtagsart_id='KOTN_QP'
        and berechnen='1'
        and bezugsart='J';
        insert into tmp_quartal(
        tid,
        bezugszeit,
        jahr,
        quartal
        )
        select tid,
        val(bezugszeit || '3'),
        bezugszeit,
        3

        from kenn_stichtag
        where stichtagsart_id='KOTN_QP'
        and berechnen='1'
        and bezugsart='J';
        insert into tmp_quartal(
        tid,
        bezugszeit,
        jahr,
        quartal
        )
        select tid,
        val(bezugszeit || '4'),
        bezugszeit,
        4
        from kenn_stichtag
        where stichtagsart_id='KOTN_QP'
        and berechnen='1'
        and bezugsart='J';

        --nun die einzelnen Quartale, werden ggf. danach mit distinct rausgeworfen
        insert into tmp_quartal(
        tid,
        bezugszeit,
        jahr,
        quartal
        )
        select tid,
        bezugszeit ,
        val(substring('' || bezugszeit from 1 for 4)),
        val(substring('' || bezugszeit from 5 for 1))

        from kenn_stichtag
        where stichtagsart_id='KOTN_QP'
        and berechnen='1'
        and bezugsart='Q';

        --

        create temp table tmp_quartal2
        (

        bezugszeit integer,
        jahr smallint,
        quartal integer,
        bvkr_sicht_id integer,
        inst_sicht_id integer,
        monat_von smallint,
        monat_bis smallint

        );

        insert into tmp_quartal2
        (bezugszeit,
        jahr,
        quartal)
        select distinct bezugszeit,
        jahr,
        quartal
        from tmp_quartal;

        update tmp_quartal2 set monat_von=quartal*3-2;
        update tmp_quartal2 set monat_bis=quartal*3;
        update tmp_quartal2 set monat_bis=13 where monat_bis=12; --Korrekturmonat soll rein
        
<#if cob_installed=1&& KENN_KOSTEN_DATENQUELLE!=170>

    <#if bezugszeiten?has_content >


        create temp table tmp_vari (vari_nr integer
        ) ;
        create temp table tmp_ausg(gruppe char(12),key char(12),ueberg char(12));
        create temp table tmp_ausg_block(block char(12), gruppe char(12),key char(12),ueberg char(12));
        create temp table tmp_hier(gruppe char(12),key char(120),ueberg char(12));
        create temp table tmp_fikr(fikrkey char(12),bezugszeit integer);
        create temp table tmp_inst(ch110_institut char(10),bezugszeit integer);


        create temp table tmp_kenn_vtbu_aggr (
        hs_nr INTEGER ,
        jahr SMALLINT ,
        quartal integer,
        monat SMALLINT ,
        quell_ch110_inst CHAR(10) ,
        quell_ch110_inst_tmp CHAR(10) ,
        quell_projnr CHAR(10) ,
        quell_stug CHAR(20) ,
        ziel_projnr CHAR(10) ,
        ziel_stug CHAR(20) ,
        ziel_fikrkey CHAR(12) ,
        ziel_fikr_aggr char(12),
        ziel_projnr_tmp CHAR(10),
        ziel_ch110_inst CHAR(10) ,
        ziel_ch110_inst_tmp CHAR(10) ,
        kokl CHAR(1) ,
        klr_geldgeber CHAR(10),
        ggnr char(4),
        vari char(1),
        lfb char(10),
        datum date ,
        betrag double precision
        );


       


        --zuerst BVKR
        --Sichten mit stichtag_id=0 gelten fr alle Stichtage
        update tmp_quartal2 set bvkr_sicht_id=(select min(S.tid)
        from sichten S, kenn_sichten K
        where K.sicht_name_intern=S.name_intern
        and K.dimension='BVKR'
        and K.stichtag_id=0)
        ;
        --Sicht frs ganze Jahr:
        update tmp_quartal2 set bvkr_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr);

        --Sicht frs Quartal:
        update tmp_quartal2 set bvkr_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit);
        --Ab ins Pruefprotokoll:
        insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
        select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (Verteilbuchungen) gilt folgende BVKR-Kostenartensicht:' || S.name)::char(200), 'Info'::char(10)
        from tmp_quartal2 Q, sichten S
        where S.tid=Q.bvkr_sicht_id
        ;
        insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
        select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (Verteilbuchungen) ist keine BVKR-Kostenartensicht definiert')::char(200), 'Warnung'::char(10)
        from tmp_quartal2 Q
        where Q.bvkr_sicht_id is null;

        --Wenn alt. Hier. als BVKR-Sicht definiert ist:
        insert into tmp_fikr
        select distinct A.key,Q.bezugszeit from
        cob_fikr F,cob_alt_keys A, sichten S, tmp_quartal2 Q
        where F.key = A.key
        and Q.bvkr_sicht_id=S.tid
        and S.alt_hier_id=A.hierarchie_id::char(150)
        and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between F.key_von and F.key_bis
        and S.type=20
        ;
        --Wenn regulre Sicht als KoA-Sicht def.:
        insert into tmp_fikr
        select distinct F.key,Q.bezugszeit from
        cob_fikr F, sichten S, tmp_quartal2 Q
        where Q.bvkr_sicht_id=S.tid
        and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between F.key_von and F.key_bis
        and S.type=10
        ;

        create index tmp_ix_fikr1 on tmp_fikr(fikrkey);
        create index tmp_ix_fikr2 on tmp_fikr(bezugszeit);

        --nun INST
        --Sichten mit stichtag_id=0 gelten fr alle Stichtage
        update tmp_quartal2 set inst_sicht_id=(select min(S.tid) from sichten S, kenn_sichten K
        where K.sicht_name_intern=S.name_intern
        and K.dimension='MWK_INST'
        and K.stichtag_id=0);

        --Sicht frs ganze Jahr:
        update tmp_quartal2 set inst_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='MWK_INST'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='MWK_INST'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr);

        --Sicht frs Quartal:
        update tmp_quartal2 set inst_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='MWK_INST'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='MWK_INST'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit);

        --Wenn alt. Hier. als INST-Sicht definiert ist:

        insert into tmp_inst
        select distinct A.key,Q.bezugszeit from
        cob_inst C,cob_alt_keys A, sichten S, tmp_quartal2 Q
        where C.key_apnr=A.key
        and Q.inst_sicht_id=S.tid
        and S.alt_hier_id=A.hierarchie_id::char(150)
        and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between C.gueltig_seit and C.gueltig_bis
        and S.type=20
        ;
        --Wenn regulre Sicht als INST-Sicht def.:
        insert into tmp_inst
        select distinct C.key_apnr,Q.bezugszeit from
        cob_inst C, sichten S, tmp_quartal2 Q
        where Q.inst_sicht_id=S.tid
        and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between C.gueltig_seit and C.gueltig_bis
        and S.type=10
        ;

        insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.parent
        from cob_alt_keys C, tmp_quartal2 Q, sichten S
        where S.tid=Q.bvkr_sicht_id
        and S.type=20
        and C.hierarchie_id::char(150)=S.alt_hier_id
        ;
        insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.ueberg
        from kenn_fikr C, tmp_quartal2 Q, sichten S
        where S.tid=Q.bvkr_sicht_id
        and S.type=10
        ;
        create index tmp_ix_thier1 on tmp_hier(gruppe);
        create index tmp_ix_thier2 on tmp_hier(ueberg);




        <#foreach bezugszeit in bezugszeiten>

            <#assign kotr_art="Unbekannt" />
            <#if bezugszeit.name="Q">
                <#assign kotr_art="Querschnittsprodukte" />
            </#if>

            select 'Verarbeitung fr ${bezugszeit.key} ${bezugszeit.strukturStr} bei kotr_art ${kotr_art}  beginnt' from xdummy;

            delete from tmp_vari;

            --Suche zunchst alle parents des Verteilschritts fr Kosten der Lehre
            --Duplikate ab ins Pruefprotokoll, siehe https://hiszilla.his.de/hiszilla/show_bug.cgi?id=89159:
            insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
            select today(),'kenn_vari'::char(18),
            'Fr Stichtags-Zeitraum ${bezugszeit.key} im Bereich Kostenrechnung (Querschnittsprodukte) (${bezugszeit.name}) gibt es mehrere Verteilschritte' , 'Warnung'::char(10)
            from xdummy
            where
            1 < (select count(*) from kenn_vari where kotr_art='${bezugszeit.name}' and bezugszeit=${bezugszeit.key} and bezugsart='${bezugszeit.strukturStr}')
            ;

            <#if SQLdialect='Postgres'>

                select sp_get_vari_parent((
                select min(vari_nr) from kenn_vari where kotr_art='${bezugszeit.name}' and bezugszeit=${bezugszeit.key} and bezugsart='${bezugszeit.strukturStr}')
                );
            <#else>

                execute procedure sp_get_vari_parent((
                select min(vari_nr) from kenn_vari where kotr_art='${bezugszeit.name}' and bezugszeit=${bezugszeit.key} and bezugsart='${bezugszeit.strukturStr}')
                );

            </#if>

            <#if bezugszeit.strukturStr='J'>

                delete from tmp_kenn_vtbu_aggr
                where jahr=${bezugszeit.key}
                and vari='${bezugszeit.name}';

                insert into tmp_kenn_vtbu_aggr (
                jahr,
                quartal,
                monat,
                quell_ch110_inst_tmp,
                ziel_projnr_tmp,
                kokl,
                vari,
                datum,
                betrag
                )
                select A.jahr, Q.bezugszeit,A.monat, quell_ch110_inst,
                ziel_projnr,
                kokl,
                '${bezugszeit.name}',
                today(),
                sum(betrag)
                from cob_vtbu_aggr A, tmp_quartal2 Q
                where Q.jahr=A.jahr
                and A.monat between Q.monat_von and Q.monat_bis
                and A.jahr=${bezugszeit.key}
                and A.kokl='K'
                and A.varnr in (select vari_nr from tmp_vari)
                -- nur wenn die interne Kostenstelle in der alt.Hier drin ist:
                and (A.quell_ch110_inst is null or A.quell_ch110_inst in (
                select I.ch110_institut from tmp_inst I where I.bezugszeit=Q.bezugszeit
                ))
                --analog auch fr die KoA:
                and (A.zfikr is null or A.zfikr in (
                select F.fikrkey from tmp_fikr F where F.bezugszeit=Q.bezugszeit
                ))
                group by 1,2,3,4,5,6,7,8;

                --Ab ins Pruefprotokoll:
                insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
                select distinct today(),'kenn_vari'::char(18),
                ('Fr Stichtags-Zeitraum Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (Querschnittsprodukte) (${kotr_art}) gilt im Verteilschritt-Zeitraum Jahr ${bezugszeit.key} folgender Verteilschritt:'
                || trim(C.vari_dbez) || ' (' || V.vari_nr|| ')')::char(255), 'Info'::char(10)
                from tmp_quartal2 Q,kenn_vari V, cob_vari C
                where V.bezugszeit=Q.jahr
                and C.vari_nr=V.vari_nr
                and V.kotr_art='${bezugszeit.name}' and V.bezugszeit=${bezugszeit.key}
                and V.bezugsart='${bezugszeit.strukturStr}';


            </#if>

            <#if bezugszeit.strukturStr='Q'>

                <#assign jahr=bezugszeit.key[0..3] />
                <#assign quartal=bezugszeit.key[4..4]?number />
                <#assign monat_u=(quartal*3)-2 />
                <#assign monat_o=quartal*3 />
                <#if monat_o=12>

                    <#assign monat_o=13 />

                </#if>

                select '${jahr}-${quartal} Monat ${monat_u}-${monat_o}' from xdummy;

                delete from tmp_kenn_vtbu_aggr
                where jahr=${jahr}
                and monat between ${monat_u} and ${monat_o}
                and vari='${bezugszeit.name}';

                insert into tmp_kenn_vtbu_aggr (
                jahr,
                quartal,
                monat,
                quell_ch110_inst_tmp,
                ziel_projnr_tmp,
                kokl,
                vari,
                datum,
                betrag
                )
                select A.jahr, Q.bezugszeit,A.monat, quell_ch110_inst,
                ziel_projnr,
                kokl,
                '${bezugszeit.name}',
                today(),
                sum(betrag)
                from cob_vtbu_aggr A, tmp_quartal2 Q
                where Q.jahr=A.jahr
                and A.monat between Q.monat_von and Q.monat_bis
                and A.jahr=${jahr}
                and A.monat between ${monat_u} and ${monat_o}
                and A.varnr in (select vari_nr from tmp_vari)
                -- nur wenn die interne Kostenstelle in der alt.Hier drin ist:
                and (A.quell_ch110_inst is null or A.quell_ch110_inst in (
                select I.ch110_institut from tmp_inst I where I.bezugszeit=Q.bezugszeit
                ))
                --analog auch fr die KoA:
                and (A.zfikr is null or A.zfikr in (
                select F.fikrkey from tmp_fikr F where F.bezugszeit=Q.bezugszeit
                ))
                group by 1,2,3,4,5,6,7,8;

                --Ab ins Pruefprotokoll:
                insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
                select distinct today(),'kenn_vari'::char(18),
                ('Fr Stichtags-Zeitraum Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (Querschnittsprodukte) (${kotr_art}) gilt im Verteilschritt-Zeitraum Quartal ${bezugszeit.key} folgender Verteilschritt:'
                || trim(C.vari_dbez) || ' (' || V.vari_nr|| ')')::char(255), 'Info'::char(10)
                from tmp_quartal2 Q,kenn_vari V, cob_vari C
                where V.bezugszeit=Q.bezugszeit
                and C.vari_nr=V.vari_nr
                and V.kotr_art='${bezugszeit.name}' and V.bezugszeit=${bezugszeit.key}
                and V.bezugsart='${bezugszeit.strukturStr}';


            </#if>

            <#if bezugszeit.strukturStr='M'>
                <#assign jahr=bezugszeit.key[0..3] />
                <#assign monat=bezugszeit.key[4..5] />

                select '${jahr}- Monat ${monat}' from xdummy;


                delete from tmp_kenn_vtbu_aggr
                where jahr=${jahr}
                and monat= ${monat}
                and vari='${bezugszeit.name}';

                insert into tmp_kenn_vtbu_aggr (
                jahr,
                quartal,
                monat,
                quell_ch110_inst_tmp,
                ziel_projnr_tmp,
                kokl,
                vari,
                datum,
                betrag
                )
                select A.jahr, Q.bezugszeit,A.monat, quell_ch110_inst,
                ziel_projnr,
                kokl,
                '${bezugszeit.name}',
                today(),
                sum(betrag)
                from cob_vtbu_aggr A, tmp_quartal2 Q
                where Q.jahr=A.jahr
                and A.monat between Q.monat_von and Q.monat_bis
                and A.jahr=${jahr}
                and A.monat= ${monat}
                and A.varnr in (select vari_nr from tmp_vari)
                -- nur wenn die interne Kostenstelle in der alt.Hier drin ist:
                and (A.quell_ch110_inst is null or A.quell_ch110_inst in (
                select I.ch110_institut from tmp_inst I where I.bezugszeit=Q.bezugszeit
                ))
                --analog auch fr die KoA:
                and (A.zfikr is null or A.zfikr in (
                select F.fikrkey from tmp_fikr F where F.bezugszeit=Q.bezugszeit
                ))
                group by 1,2,3,4,5,6,7,8;

                --Ab ins Pruefprotokoll:
                insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
                select distinct today(),'kenn_vari'::char(18),
                ('Fr Stichtags-Zeitraum Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (Querschnittsprodukte) (${kotr_art}) gilt im Verteilschritt-Zeitraum Jahr-Monat ${jahr}-${monat} folgender Verteilschritt:'
                || trim(C.vari_dbez) || ' (' || V.vari_nr|| ')')::char(255), 'Info'::char(10)
                from tmp_quartal2 Q,kenn_vari V, cob_vari C
                where C.vari_nr=V.vari_nr
                and V.monat between Q.monat_von and Q.monat_bis
                and V.kotr_art='${bezugszeit.name}' and V.bezugszeit=${bezugszeit.key}
                and V.bezugsart='${bezugszeit.strukturStr}';

            </#if>

        </#foreach>




        update tmp_kenn_vtbu_aggr set ziel_projnr=(select k_extkotr from cob_proj P where P.projnr=tmp_kenn_vtbu_aggr.ziel_projnr_tmp)
        where ziel_projnr_tmp is not null;

        insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
        select distinct today(),'cob_proj'::char(18),'Projekt ' || trim(ziel_projnr_tmp) || ' im Bereich Sekundrkosten QP ist keinem externen Kostentrger zugeordnet !'::char(200), 'Warnung'::char(10)
        from tmp_kenn_vtbu_aggr
        where ziel_projnr is null
        and ziel_projnr_tmp is not null;

        insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
        select today(),'cob_proj'::char(18),sum(betrag)::decimal(14,2) || ' EUR im Bereich Sekundrkosten Querschnittsprodukte im Jahr ' || jahr || ' sind keinem externen Kostentrger zugeordnet !'::char(200), 'Warnung'::char(10)
        from tmp_kenn_vtbu_aggr
        where ziel_projnr is null
        and ziel_projnr_tmp is null
        group by 1,jahr
        ;

        update tmp_kenn_vtbu_aggr set hs_nr=(select hs_nr from hochschulinfo);


        delete from kenn_vtbu_qp_aggr where 0=
        (select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');

        delete from kenn_vtbu_qp_aggr
        where quartal in (select bezugszeit from tmp_quartal2) ;



        insert into kenn_vtbu_qp_aggr (
        hs_nr,
        jahr,
        quartal,
        monat,
        --quell_ch110_inst, TODO ext. Kostenstelle, wird aber vielleicht nicht bentigt
        ziel_projnr,
        kokl,
        datum,
        betrag
        )
        select
        hs_nr,
        jahr,
        quartal,
        monat,
        --quell_ch110_inst,
        ziel_projnr,
        kokl,
        datum,
        sum(betrag)
        from tmp_kenn_vtbu_aggr
        group by 1,2,3,4,5,6,7;


        drop table tmp_kenn_vtbu_aggr;
        drop table tmp_vari;
        

        drop table tmp_ausg;
        drop table tmp_ausg_block;
        drop table tmp_hier;
        drop table tmp_fikr;
        drop table tmp_inst;

    </#if>

</#if>
<#if KENN_KOSTEN_DATENQUELLE=170> -- gxstage
 

        delete from kenn_vtbu_qp_aggr where 0=
        (select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');

        delete from kenn_vtbu_qp_aggr
        where quartal in (select bezugszeit from tmp_quartal2) ;



        insert into kenn_vtbu_qp_aggr (
        hs_nr,
        jahr,
        quartal,
        monat,
        quell_ch110_inst, -- bei Datenquelle COB auskommentiert: ext. Kostenstelle, wird aber vielleicht nicht bentigt
        ziel_projnr,
        kokl,
        datum,
        betrag
        )
        select
        hs_nr,
        G.jahr,
        G.quartal,
        monat,
        quell_ch110_inst,-- bei Datenquelle COB auskommentiert: ext. Kostenstelle, wird aber vielleicht nicht bentigt
        ziel_projnr,
        kokl,
        datum,
        sum(betrag)
        from gxstage_vtbu_aggr G,tmp_quartal2 Q where vari='Q'
        and Q.jahr=G.jahr
        and G.monat between Q.monat_von and Q.monat_bis
        group by 1,2,3,4,5,6,7,8;
</#if>
drop table tmp_quartal;
drop table tmp_quartal2;
