--freemarker template

<sqlvars>
<sqlvar name="KENN_KOSTEN_DATENQUELLE">
select apnr from konstanten where beschreibung ='KENN_KOSTEN_DATENQUELLE'
</sqlvar>
<sqlvar name="bezugszeiten" type="hashsequence">
SELECT bezugszeit,kotr_art,bezugsart
 from kenn_vari V
 where V.kotr_art::Char(10) in (select C.apnr from kenn_cifx C 
 where C.key=677
 and C.gruppe='KENN')
 order by 2,1,3
;
</sqlvar>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>

</sqlvars>

<#if K_KENN_PROFIL==5>

<#if cob_installed=1 || KENN_KOSTEN_DATENQUELLE=170>

<#if bezugszeiten?has_content >


create temp table tmp_vari (vari_nr integer
) ;
--Tabelle nur fr Sachsen:
create temp table tmp_vari_nhs (bezugszeit integer, bezugsart char(1), vari_nr integer, kotr_art char(1),spaeter smallint);


--fr alle:
create temp table tmp_ausg(gruppe char(12),key char(12),ueberg char(12));
 create temp table tmp_ausg_block(block char(12), gruppe char(12),key char(12),ueberg char(12));
 create temp table tmp_hier(gruppe char(12),key char(120),ueberg char(12));
create temp table tmp_fikr(fikrkey char(12),bezugszeit integer);
create temp table tmp_inst(ch110_institut char(10),bezugszeit integer);



create temp table tmp_kenn_vtbu_aggr (
hs_nr INTEGER , 
jahr SMALLINT , 
quartal integer,
monat SMALLINT , 
quell_ch110_inst CHAR(10) ,
quell_ch110_inst_tmp CHAR(10) ,
quell_projnr CHAR(10) , 
quell_stug CHAR(20) , 
ziel_projnr CHAR(10) , 
ziel_stug CHAR(20) , 
ziel_fikrkey CHAR(12) , 
ziel_fikr_aggr char(12),
ziel_projnr_tmp CHAR(10),
ziel_ch110_inst CHAR(10) ,
ziel_ch110_inst_tmp CHAR(10) ,
kokl CHAR(1) , 
klr_geldgeber CHAR(10), 
ggnr char(4),
vari char(1),
lfb char(10),
datum date , 
betrag double precision 
); 


create temp table tmp_quartal
(
   tid integer,
    bezugszeit integer,
    jahr smallint,
    quartal integer
);

--zuerst alle Quartale zusammenstellen:

insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       val(bezugszeit || '1'),
       bezugszeit,
       1
  from kenn_stichtag
where stichtagsart_id='KOTN'
and berechnen='1'
and bezugsart='J';
insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       val(bezugszeit || '2'),
       bezugszeit,
       2
       
from kenn_stichtag
where stichtagsart_id='KOTN'
and berechnen='1'
and bezugsart='J';
insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       val(bezugszeit || '3'),
       bezugszeit,
       3
       
from kenn_stichtag
where stichtagsart_id='KOTN'
and berechnen='1'
and bezugsart='J';
insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       val(bezugszeit || '4'),
       bezugszeit,
       4
 from kenn_stichtag
where stichtagsart_id='KOTN'
and berechnen='1'
and bezugsart='J';

--nun die einzelnen Quartale, werden ggf. danach mit distinct rausgeworfen
insert into tmp_quartal(
tid,
       bezugszeit,
       jahr,
       quartal
       )
select tid,
       bezugszeit ,
       val(substring('' || bezugszeit from 1 for 4)),
       val(substring('' || bezugszeit from 5 for 1))
       
from kenn_stichtag
where stichtagsart_id='KOTN'
and berechnen='1'
and bezugsart='Q';

--

create temp table tmp_quartal2
(
  
    bezugszeit integer,
    jahr smallint,
    quartal integer,
    bvkr_sicht_id integer,
    inst_sicht_id integer,
    monat_von smallint,
    monat_bis smallint

);

insert into tmp_quartal2
(bezugszeit,
jahr,
       quartal)
select distinct bezugszeit,
jahr,
       quartal
       from tmp_quartal;
       
update tmp_quartal2 set monat_von=quartal*3-2;
update tmp_quartal2 set monat_bis=quartal*3;
update tmp_quartal2 set monat_bis=13 where monat_bis=12; --Korrekturmonat soll rein


--zuerst BVKR
--Sichten mit stichtag_id=0 gelten fr alle Stichtage
update tmp_quartal2 set bvkr_sicht_id=(select min(S.tid) 
from sichten S, kenn_sichten K 
 where K.sicht_name_intern=S.name_intern
and K.dimension='BVKR'
and K.stichtag_id=0)
;
--Sicht frs ganze Jahr:
update tmp_quartal2 set bvkr_sicht_id=(
select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
 where K.sicht_name_intern=S.name_intern
and I.tid=K.stichtag_id
and K.dimension='BVKR'
and I.bezugsart='J'
and I.bezugszeit=tmp_quartal2.jahr)
where 0 < (select count(*) 
from sichten S, kenn_sichten K , kenn_stichtag I
 where K.sicht_name_intern=S.name_intern
and I.tid=K.stichtag_id
and K.dimension='BVKR'
and I.bezugsart='J'
and I.bezugszeit=tmp_quartal2.jahr);

--Sicht frs Quartal:
update tmp_quartal2 set bvkr_sicht_id=(
select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
 where K.sicht_name_intern=S.name_intern
and I.tid=K.stichtag_id
and K.dimension='BVKR'
and I.bezugsart='Q'
and I.bezugszeit=tmp_quartal2.bezugszeit)
where 0 < (select count(*) 
from sichten S, kenn_sichten K , kenn_stichtag I
 where K.sicht_name_intern=S.name_intern
and I.tid=K.stichtag_id
and K.dimension='BVKR'
and I.bezugsart='Q'
and I.bezugszeit=tmp_quartal2.bezugszeit);



<#if cob_installed=1>
--Ab ins Pruefprotokoll:
insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (Verteilbuchungen) gilt folgende BVKR-Kostenartensicht:' || S.name)::char(200), 'Info'::char(10) 
from tmp_quartal2 Q, sichten S
where S.tid=Q.bvkr_sicht_id
; 
insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (Verteilbuchungen) ist keine BVKR-Kostenartensicht definiert')::char(200), 'Warnung'::char(10) 
from tmp_quartal2 Q
where Q.bvkr_sicht_id is null;

--Wenn alt. Hier. als BVKR-Sicht definiert ist:
insert into tmp_fikr
select distinct A.key,Q.bezugszeit from 
cob_fikr F,cob_alt_keys A, sichten S, tmp_quartal2 Q
  where F.key = A.key
  and Q.bvkr_sicht_id=S.tid
  and S.alt_hier_id=A.hierarchie_id::char(150)
  and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between F.key_von and F.key_bis
  and S.type=20
   ;
--Wenn regulre Sicht als KoA-Sicht def.:
insert into tmp_fikr
select distinct F.key,Q.bezugszeit from 
cob_fikr F, sichten S, tmp_quartal2 Q
  where Q.bvkr_sicht_id=S.tid
  and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between F.key_von and F.key_bis
  and S.type=10
   ;

   create index tmp_ix_fikr1 on tmp_fikr(fikrkey);
create index tmp_ix_fikr2 on tmp_fikr(bezugszeit);

--nun INST
--Sichten mit stichtag_id=0 gelten fr alle Stichtage
update tmp_quartal2 set inst_sicht_id=(select min(S.tid) from sichten S, kenn_sichten K 
 where K.sicht_name_intern=S.name_intern
and K.dimension='MWK_INST'
and K.stichtag_id=0);

--Sicht frs ganze Jahr:
update tmp_quartal2 set inst_sicht_id=(
select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
 where K.sicht_name_intern=S.name_intern
and I.tid=K.stichtag_id
and K.dimension='MWK_INST'
and I.bezugsart='J'
and I.bezugszeit=tmp_quartal2.jahr)
where 0 < (select count(*) 
from sichten S, kenn_sichten K , kenn_stichtag I
 where K.sicht_name_intern=S.name_intern
and I.tid=K.stichtag_id
and K.dimension='MWK_INST'
and I.bezugsart='J'
and I.bezugszeit=tmp_quartal2.jahr);

--Sicht frs Quartal:
update tmp_quartal2 set inst_sicht_id=(
select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
 where K.sicht_name_intern=S.name_intern
and I.tid=K.stichtag_id
and K.dimension='MWK_INST'
and I.bezugsart='Q'
and I.bezugszeit=tmp_quartal2.bezugszeit)
where 0 < (select count(*) 
from sichten S, kenn_sichten K , kenn_stichtag I
 where K.sicht_name_intern=S.name_intern
and I.tid=K.stichtag_id
and K.dimension='MWK_INST'
and I.bezugsart='Q'
and I.bezugszeit=tmp_quartal2.bezugszeit);

--Wenn alt. Hier. als INST-Sicht definiert ist:

insert into tmp_inst
select distinct A.key,Q.bezugszeit from 
cob_inst C,cob_alt_keys A, sichten S, tmp_quartal2 Q
  where C.key_apnr=A.key
  and Q.inst_sicht_id=S.tid
  and S.alt_hier_id=A.hierarchie_id::char(150)
  and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between C.gueltig_seit and C.gueltig_bis
  and S.type=20
  ;
--Wenn regulre Sicht als INST-Sicht def.:
insert into tmp_inst
select distinct C.key_apnr,Q.bezugszeit from 
cob_inst C, sichten S, tmp_quartal2 Q
  where Q.inst_sicht_id=S.tid
  and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between C.gueltig_seit and C.gueltig_bis
    and S.type=10
  ;

insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.parent
from cob_alt_keys C, tmp_quartal2 Q, sichten S
where S.tid=Q.bvkr_sicht_id
and S.type=20
and C.hierarchie_id::char(150)=S.alt_hier_id
;
insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.ueberg
from kenn_fikr C, tmp_quartal2 Q, sichten S
where S.tid=Q.bvkr_sicht_id
and S.type=10
;
create index tmp_ix_thier1 on tmp_hier(gruppe);
create index tmp_ix_thier2 on tmp_hier(ueberg);


--nur Sachsen: Bewirtschaftungskosten und jeweils andere Verteilung von V und Z immer raus bei den Overheadkosten:
--Verteilschritte sammeln:
<#foreach bezugszeit in bezugszeiten>

select 'Verteilschritte fr ${bezugszeit.bezugszeit} ${bezugszeit.bezugsart}   sammeln' from xdummy;
delete from tmp_vari;
delete from tmp_vari_nhs where kotr_art='${bezugszeit.kotr_art}'
and bezugszeit=${bezugszeit.bezugszeit}
and bezugsart='${bezugszeit.bezugsart}';

<#if SQLdialect='Postgres'>
--DBI unter Windows fhrt keine selects asu:
create temp table tmp_dummy(test varchar(255));

insert into tmp_dummy
select sp_get_vari_parent((
select min(vari_nr) from kenn_vari where kotr_art='${bezugszeit.kotr_art}' and bezugszeit=${bezugszeit.bezugszeit} and bezugsart='${bezugszeit.bezugsart}')
);

drop table tmp_dummy;

<#else>

execute procedure sp_get_vari_parent((
select min(vari_nr) from kenn_vari where kotr_art='${bezugszeit.kotr_art}' and bezugszeit=${bezugszeit.bezugszeit} and bezugsart='${bezugszeit.bezugsart}')
);

</#if>

<#if bezugszeit.kotr_art == "B" ||  bezugszeit.kotr_art == "V" ||  bezugszeit.kotr_art == "Z">
insert into tmp_vari_nhs(bezugszeit,bezugsart,vari_nr,kotr_art)
select ${bezugszeit.bezugszeit},'${bezugszeit.bezugsart}',vari_nr,'${bezugszeit.kotr_art}' from tmp_vari;
</#if>

</#foreach>
--den jeweils anderen Verteilschritt bei V und Z rausschmeien:
create temp table tmp_vari_nhs_vergleich(bezugszeit integer,
bezugsart char(1),
kotr_art_v_anz integer,kotr_art_z_anz  integer);

create temp table  tmp_vari_nhs_z(bezugszeit integer,
bezugsart char(1),vari_nr integer);
create temp table  tmp_vari_nhs_v(bezugszeit integer,
bezugsart char(1),vari_nr integer);
create temp table  tmp_vari_nhs_b(bezugszeit integer,
bezugsart char(1),vari_nr integer);

insert into tmp_vari_nhs_v
select bezugszeit,bezugsart,vari_nr from tmp_vari_nhs
where kotr_art='V';
insert into tmp_vari_nhs_z
select bezugszeit,bezugsart,vari_nr from tmp_vari_nhs
where kotr_art='Z';
insert into tmp_vari_nhs_b
select bezugszeit,bezugsart,vari_nr from tmp_vari_nhs
where kotr_art='B';

--Bewirtschaftungskosten fallen immer raus:
delete from tmp_vari_nhs
where kotr_art in ('Z','V')
and vari_nr in (select T.vari_nr from tmp_vari_nhs_b T
where T.bezugszeit=tmp_vari_nhs.bezugszeit
and T.bezugsart=tmp_vari_nhs.bezugsart)
;

insert into tmp_vari_nhs_vergleich(bezugszeit,bezugsart,kotr_art_v_anz)
select bezugszeit,bezugsart,count(vari_nr) 
from tmp_vari_nhs
where kotr_art in ('V')
group by 1,2
;
update tmp_vari_nhs_vergleich set kotr_art_z_anz=(select count(vari_nr) 
from tmp_vari_nhs T
where T.kotr_art in ('Z')
and T.bezugszeit=tmp_vari_nhs_vergleich.bezugszeit
and T.bezugsart=tmp_vari_nhs_vergleich.bezugsart
)
;
update tmp_vari_nhs set spaeter=1
where kotr_art ='V'
and 0<(select count(*) from tmp_vari_nhs_vergleich T 
where T.bezugszeit=tmp_vari_nhs.bezugszeit
and T.bezugsart=tmp_vari_nhs.bezugsart
and kotr_art_z_anz < kotr_art_v_anz); 
update tmp_vari_nhs set spaeter=1
where kotr_art ='Z'
and 0<(select count(*) from tmp_vari_nhs_vergleich T
where T.bezugszeit=tmp_vari_nhs.bezugszeit
and T.bezugsart=tmp_vari_nhs.bezugsart
and kotr_art_z_anz > kotr_art_v_anz)
; 

delete from tmp_vari_nhs
where kotr_art='V'
and spaeter=1
and vari_nr in (select T.vari_nr from tmp_vari_nhs_z T
where T.bezugszeit=tmp_vari_nhs.bezugszeit
and T.bezugsart=tmp_vari_nhs.bezugsart)
;

delete from tmp_vari_nhs
where kotr_art='Z'
and spaeter=1
and vari_nr in (select T.vari_nr from tmp_vari_nhs_v T
where T.bezugszeit=tmp_vari_nhs.bezugszeit
and T.bezugsart=tmp_vari_nhs.bezugsart)
;

drop table tmp_vari_nhs_v;
drop table tmp_vari_nhs_z;
drop table tmp_vari_nhs_b;
drop table tmp_vari_nhs_vergleich;



--Ende Verteilschritte sammeln Sachsen

<#foreach bezugszeit in bezugszeiten>

<#assign kotr_art="Unbekannt" />
<#if bezugszeit.kotr_art="L">
<#assign kotr_art="Lehre (Nachfrage)" />
</#if>
<#if bezugszeit.kotr_art="A">
<#assign kotr_art="Lehre (Angebot)" />
</#if>
<#if bezugszeit.kotr_art="F">
<#assign kotr_art="Forschung" />
</#if>
<#if bezugszeit.kotr_art="D">
<#assign kotr_art="Sonstige Dienstleistungen" />
</#if>
<#if bezugszeit.kotr_art="Z">
<#assign kotr_art="Zentralverwaltung" />
</#if>
<#if bezugszeit.kotr_art="V">
<#assign kotr_art="Fakulttsverwaltung" />
</#if>
<#if bezugszeit.kotr_art="B">
<#assign kotr_art="Bewirtschaftungskosten" />
</#if>
select 'Verarbeitung fr ${bezugszeit.bezugszeit} ${bezugszeit.bezugsart} bei kotr_art ${kotr_art}  beginnt' from xdummy;

delete from tmp_vari;

--Suche zunchst alle parents des Verteilschritts fr Kosten der Lehre
--Duplikate ab ins Pruefprotokoll, siehe https://hiszilla.his.de/hiszilla/show_bug.cgi?id=89159:
insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
select today(),'kenn_vari'::char(18),
'Fr Stichtags-Zeitraum ${bezugszeit.bezugszeit} im Bereich Kostenrechnung (${bezugszeit.kotr_art}) gibt es mehrere Verteilschritte' , 'Warnung'::char(10) 
from xdummy
where 
1 < (select count(*) from kenn_vari where kotr_art='${bezugszeit.kotr_art}' and bezugszeit=${bezugszeit.bezugszeit} and bezugsart='${bezugszeit.bezugsart}')
;

<#if SQLdialect='Postgres'>
--DBI unter Windows fhrt keine selects asu:
create temp table tmp_dummy(test varchar(255));

insert into tmp_dummy
select sp_get_vari_parent((
select min(vari_nr) from kenn_vari where kotr_art='${bezugszeit.kotr_art}' and bezugszeit=${bezugszeit.bezugszeit} and bezugsart='${bezugszeit.bezugsart}')
);

drop table tmp_dummy;

<#else>

execute procedure sp_get_vari_parent((
select min(vari_nr) from kenn_vari where kotr_art='${bezugszeit.kotr_art}' and bezugszeit=${bezugszeit.bezugszeit} and bezugsart='${bezugszeit.bezugsart}')
);

</#if>

<#if bezugszeit.bezugsart='J'>

delete from tmp_kenn_vtbu_aggr
where jahr=${bezugszeit.bezugszeit}
and vari='${bezugszeit.kotr_art}';

insert into tmp_kenn_vtbu_aggr (
jahr,
quartal,
monat,
quell_ch110_inst_tmp,
quell_projnr,
quell_stug,
ziel_projnr_tmp,
ziel_stug,
ziel_fikrkey,
ziel_ch110_inst_tmp,
kokl,
ggnr,
vari,
datum,
betrag
)
select A.jahr, Q.bezugszeit,A.monat, quell_ch110_inst,
quell_projnr,
quell_stug, 
ziel_projnr,
ziel_stug, zfikr, 
ziel_ch110_inst,
kokl, klr_geldgeber,'${bezugszeit.kotr_art}', today(), sum(betrag)
from cob_vtbu_aggr A, tmp_quartal2 Q
where Q.jahr=A.jahr
and A.monat between Q.monat_von and Q.monat_bis
and A.jahr=${bezugszeit.bezugszeit}
and A.varnr in (select vari_nr from tmp_vari)
--nur wenn die interne Kostenstelle in der alt.Hier drin ist:
and (A.quell_ch110_inst is null or A.quell_ch110_inst in (
select I.ch110_institut from tmp_inst I where I.bezugszeit=Q.bezugszeit
))
--nur Sachsen: Bewirtschaftungskosten und jeweils andere Verteilung von V und Z immer raus bei den Overheadkosten:
<#if bezugszeit.kotr_art == "V" || bezugszeit.kotr_art == "Z" >
and A.varnr in (select V.vari_nr  from tmp_vari_nhs V
where V.kotr_art ='${bezugszeit.kotr_art}'
and V.bezugszeit=${bezugszeit.bezugszeit}
and V.bezugsart='${bezugszeit.bezugsart}')

</#if>
group by 1,2,3,4,5,6,7,8,9,10,11,12,13;

--Ab ins Pruefprotokoll:
insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
select distinct today(),'kenn_vari'::char(18),
('Fr Stichtags-Zeitraum Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (${kotr_art}) gilt im Verteilschritt-Zeitraum Jahr ${bezugszeit.bezugszeit} folgender Verteilschritt:' 
|| trim(C.vari_dbez) || ' (' || V.vari_nr|| ')')::char(255), 'Info'::char(10) 
from tmp_quartal2 Q,kenn_vari V, cob_vari C
where V.bezugszeit=Q.jahr
and C.vari_nr=V.vari_nr
and V.kotr_art='${bezugszeit.kotr_art}' and V.bezugszeit=${bezugszeit.bezugszeit} 
and V.bezugsart='${bezugszeit.bezugsart}';


</#if> --Ende bezugszeit.bezugsart='J'

<#if bezugszeit.bezugsart='Q'>

<#assign jahr=bezugszeit.bezugszeit[0..3] />
<#assign quartal=bezugszeit.bezugszeit[4..4]?number />
<#assign monat_u=(quartal*3)-2 />
<#assign monat_o=quartal*3 />
<#if monat_o=12>

<#assign monat_o=13 />

</#if>

select '${jahr}-${quartal} Monat ${monat_u}-${monat_o}' from xdummy;

delete from tmp_kenn_vtbu_aggr
where jahr=${jahr}
and monat between ${monat_u} and ${monat_o}
and vari='${bezugszeit.kotr_art}';

insert into tmp_kenn_vtbu_aggr (
jahr,
quartal,
monat,
quell_ch110_inst_tmp,
quell_projnr,
quell_stug,
ziel_projnr_tmp,
ziel_stug,
ziel_fikrkey,
ziel_ch110_inst_tmp,
kokl,
ggnr,
vari,
datum,
betrag
)
select A.jahr, Q.bezugszeit,A.monat, quell_ch110_inst,
quell_projnr,
quell_stug, 
ziel_projnr,
ziel_stug, zfikr, 
ziel_ch110_inst,
kokl, klr_geldgeber,'${bezugszeit.kotr_art}', today(), sum(betrag)
from cob_vtbu_aggr A, tmp_quartal2 Q
where Q.jahr=A.jahr
and A.monat between Q.monat_von and Q.monat_bis
and A.jahr=${jahr}
and A.monat between ${monat_u} and ${monat_o}
and A.varnr in (select vari_nr from tmp_vari)
--Sachsen und Rest der Welt: nur wenn die interne Kostenstelle in der alt.Hier drin ist:
and (A.quell_ch110_inst is null or A.quell_ch110_inst in (
select I.ch110_institut from tmp_inst I where I.bezugszeit=Q.bezugszeit
))
--nur Sachsen: Bewirtschaftungskosten und jeweils andere Verteilung von V und Z immer raus bei den Overheadkosten:
<#if bezugszeit.kotr_art == "V" || bezugszeit.kotr_art == "Z" >
and A.varnr in (select V.vari_nr  from tmp_vari_nhs V
where V.kotr_art ='${bezugszeit.kotr_art}'
and V.bezugszeit=${bezugszeit.bezugszeit}
and V.bezugsart='${bezugszeit.bezugsart}'
)

</#if>

group by 1,2,3,4,5,6,7,8,9,10,11,12,13;

--Ab ins Pruefprotokoll:
insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
select distinct today(),'kenn_vari'::char(18),
('Fr Stichtags-Zeitraum Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (${kotr_art}) gilt im Verteilschritt-Zeitraum Quartal ${bezugszeit.bezugszeit} folgender Verteilschritt:' 
|| trim(C.vari_dbez) || ' (' || V.vari_nr|| ')')::char(255), 'Info'::char(10) 
from tmp_quartal2 Q,kenn_vari V, cob_vari C
where V.bezugszeit=Q.bezugszeit
and C.vari_nr=V.vari_nr
and V.kotr_art='${bezugszeit.kotr_art}' and V.bezugszeit=${bezugszeit.bezugszeit} 
and V.bezugsart='${bezugszeit.bezugsart}';


</#if> --Ende bezugszeit.bezugsart='Q'>

<#if bezugszeit.bezugsart='M'>
<#assign jahr=bezugszeit.bezugszeit[0..3] />
<#assign monat=bezugszeit.bezugszeit[4..5] />

select '${jahr}- Monat ${monat}' from xdummy;


delete from tmp_kenn_vtbu_aggr
where jahr=${jahr}
and monat= ${monat} 
and vari='${bezugszeit.kotr_art}';

insert into tmp_kenn_vtbu_aggr (
jahr,
quartal,
monat,
quell_ch110_inst_tmp,
quell_projnr,
quell_stug,
ziel_projnr_tmp,
ziel_stug,
ziel_fikrkey,
ziel_ch110_inst_tmp,
kokl,
ggnr,
vari,
datum,
betrag
)
select A.jahr, Q.bezugszeit,A.monat, quell_ch110_inst,
quell_projnr,
quell_stug, 
ziel_projnr,
ziel_stug, zfikr, 
ziel_ch110_inst,
kokl, klr_geldgeber,'${bezugszeit.kotr_art}', today(), sum(betrag)
from cob_vtbu_aggr A, tmp_quartal2 Q
where Q.jahr=A.jahr
and A.monat between Q.monat_von and Q.monat_bis
and A.jahr=${jahr}
and A.monat= ${monat} 
and A.varnr in (select vari_nr from tmp_vari)
--Sachsen und Rest der Welt: nur wenn die interne Kostenstelle in der alt.Hier drin ist:
and (A.quell_ch110_inst is null or A.quell_ch110_inst in (
select I.ch110_institut from tmp_inst I where I.bezugszeit=Q.bezugszeit
))
--nur Sachsen: Bewirtschaftungskosten und jeweils andere Verteilung von V und Z immer raus bei den Overheadkosten:
<#if bezugszeit.kotr_art == "V" || bezugszeit.kotr_art == "Z" >
and A.varnr in (select V.vari_nr  from tmp_vari_nhs V
where V.kotr_art ='${bezugszeit.kotr_art}'
and V.bezugszeit=${bezugszeit.bezugszeit}
and V.bezugsart='${bezugszeit.bezugsart}'
)

</#if>
group by 1,2,3,4,5,6,7,8,9,10,11,12,13;

--Ab ins Pruefprotokoll:
insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
select distinct today(),'kenn_vari'::char(18),
('Fr Stichtags-Zeitraum Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (${kotr_art}) gilt im Verteilschritt-Zeitraum Jahr-Monat ${jahr}-${monat} folgender Verteilschritt:' 
|| trim(C.vari_dbez) || ' (' || V.vari_nr|| ')')::char(255), 'Info'::char(10) 
from tmp_quartal2 Q,kenn_vari V, cob_vari C
where C.vari_nr=V.vari_nr
and V.monat between Q.monat_von and Q.monat_bis
and V.kotr_art='${bezugszeit.kotr_art}' and V.bezugszeit=${bezugszeit.bezugszeit} 
and V.bezugsart='${bezugszeit.bezugsart}';

</#if> --Ende bezugszeit.bezugsart='M'


--Sachsen und Rest der Welt: ziel-KoA:
update tmp_kenn_vtbu_aggr set ziel_fikr_aggr=ziel_fikrkey;


</#foreach>  --Ende Schleife Bezugszeiten




update tmp_kenn_vtbu_aggr set ziel_fikr_aggr='_S'
where ziel_fikr_aggr is null;

update tmp_kenn_vtbu_aggr set klr_geldgeber=(select gruppe from kenn_cifx C where key=648 and C.apnr=tmp_kenn_vtbu_aggr.ggnr)
where ggnr is not null;

update tmp_kenn_vtbu_aggr set quell_projnr=(select k_extkotr from cob_proj P where P.projnr=tmp_kenn_vtbu_aggr.quell_projnr)
where quell_projnr is not null;
update tmp_kenn_vtbu_aggr set quell_projnr=(select k_extkotr from cob_stug S where S.stug_key=tmp_kenn_vtbu_aggr.quell_stug)
where quell_projnr is null
and quell_stug is not null;


update tmp_kenn_vtbu_aggr set ziel_projnr=(select k_extkotr from cob_proj P where P.projnr=tmp_kenn_vtbu_aggr.ziel_projnr_tmp)
where ziel_projnr_tmp is not null;

update tmp_kenn_vtbu_aggr set ziel_projnr=(select k_extkotr from cob_stug S where S.stug_key=tmp_kenn_vtbu_aggr.ziel_stug)
where ziel_stug is not null
and ziel_projnr is null;

--nur Sachsen:



--Der LFB wird in zweiter Prioritt ber das Projekt zugewiesen
update tmp_kenn_vtbu_aggr set ziel_projnr=(select min(E.key) from cob_proj I, kenn_extkotr E
where I.projnr=tmp_kenn_vtbu_aggr.ziel_projnr_tmp
and substring(E.key from 4 for 3)=I.fins --der LFB ist im externen Porduktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
and E.kategorie='lf' --Ebene LFB
and E.key like '1%' --nur Lehre
)
where ziel_projnr is null
and ziel_projnr_tmp is not null
;
--ziel_ch110_inst auf ext. Schlssel:

update tmp_kenn_vtbu_aggr set ziel_ch110_inst=(select min(I.key_extkotr) from kenn_inst_to_ext I
where I.instnr=tmp_kenn_vtbu_aggr.ziel_ch110_inst_tmp
and I.key_extkotr is not null
and trim(I.key_extkotr) !='')
--nur wenn die interne Kostenstelle in der alt.Hier drin ist:
where ziel_ch110_inst_tmp is not null
;
--Wenn ext. Kostenstelle noch nicht gepflegt wird, dann wird versucht dies aus sva_inst.fins (in Sachsen der LFB) zu nehmen:
update tmp_kenn_vtbu_aggr set ziel_ch110_inst=(select min(E.key) from kenn_extkotr E, kenn_inst I
where I.key_apnr=tmp_kenn_vtbu_aggr.ziel_ch110_inst_tmp
and substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Produktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
and E.kategorie='lf' --Ebene LFB
and E.key like '1%' --nur Lehre
)
--nur wenn die interne Kostenstelle in der alt.Hier drin ist:
where ziel_ch110_inst_tmp is not null
and ziel_ch110_inst is null
;
--quell_ch110_inst 
update tmp_kenn_vtbu_aggr set quell_ch110_inst=(select min(I.key_extkotr) from kenn_inst_to_ext I
where I.instnr=tmp_kenn_vtbu_aggr.quell_ch110_inst_tmp
and I.key_extkotr is not null
and trim(I.key_extkotr) !='')
--nur wenn die interne Kostenstelle in der alt.Hier drin ist:
where quell_ch110_inst_tmp is not null
;
--Wenn ext. Kostenstelle noch nicht gepflegt wird, dann wird versucht dies aus sva_inst.fins (in Sachsen der LFB) zu nehmen:
update tmp_kenn_vtbu_aggr set quell_ch110_inst=(select min(E.key) from kenn_extkotr E, kenn_inst I
where I.key_apnr=tmp_kenn_vtbu_aggr.quell_ch110_inst_tmp
and substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Produktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
and E.kategorie='lf' --Ebene LFB
and E.key like '1%' --nur Lehre
)
--nur wenn die interne Kostenstelle in der alt.Hier drin ist:
where quell_ch110_inst_tmp is not null
and quell_ch110_inst is null
;
--Overhead unntige Zeilen lschen:
--Fakulttsverw. = orgstruktur 60
-- delete from tmp_kenn_vtbu_aggr
-- where vari='V'
-- and 0=(select count(*) from cob_inst I
-- where I.key_apnr=quell_ch110_inst_tmp
-- and I.orgstruktur=60);

--Zentralverw. = orgstruktur 80
-- delete from tmp_kenn_vtbu_aggr
-- where vari='Z'
-- and 0=(select count(*) from cob_inst I
-- where I.key_apnr=quell_ch110_inst_tmp
-- and I.orgstruktur=80);

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'cob_proj'::char(18),'Projekt ' || trim(ziel_projnr_tmp) || ' im Bereich Sekundrkosten ist keinem externen Kostentrger zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_kenn_vtbu_aggr 
where ziel_projnr is null
and ziel_projnr_tmp is not null; 

update tmp_kenn_vtbu_aggr set hs_nr=(select hs_nr from hochschulinfo);


delete from kenn_vtbu_aggr where 0=
(select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');

delete from kenn_vtbu_aggr 
where quartal in (select bezugszeit from tmp_quartal2) ;



insert into kenn_vtbu_aggr (
hs_nr, 
jahr,
quartal,
monat,
quell_ch110_inst,
quell_projnr,
quell_stug,
ziel_projnr,
ziel_stug,
ziel_fikrkey,
ziel_ch110_inst,
kokl,
klr_geldgeber,
vari,
datum,
betrag
)
select 
hs_nr, 
jahr,
quartal,
monat,
quell_ch110_inst,
quell_projnr,
quell_stug,
ziel_projnr,
ziel_stug,
ziel_fikr_aggr,
ziel_ch110_inst,
kokl,
klr_geldgeber,
vari,
datum,
sum(betrag)
from tmp_kenn_vtbu_aggr
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;

 </#if> -- ende Datenquelle COB


 
 
 
 <#if KENN_KOSTEN_DATENQUELLE=170>
delete from kenn_vtbu_aggr where 0=
(select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');

delete from kenn_vtbu_aggr 
where quartal in (select bezugszeit from tmp_quartal2) ;


insert into kenn_vtbu_aggr (
hs_nr, 
jahr,
quartal,
monat,
quell_ch110_inst,
quell_projnr,
quell_stug,
ziel_projnr,
ziel_stug,
ziel_fikrkey,
kokl,
klr_geldgeber,
vari,
datum,
betrag
)
select H.hs_nr,G.jahr,G.quartal,G.monat,G.quell_ch110_inst,G.quell_projnr,G.quell_stug,G.ziel_projnr,G.ziel_stug,G.ziel_fikrkey,G.kokl,G.klr_geldgeber,G.vari,today(),G.betrag
from gxstage_vtbu_aggr G, hochschulinfo H, tmp_quartal2 Q
where Q.jahr=G.jahr
and G.monat between Q.monat_von and Q.monat_bis;

 </#if> -- ende Datenquelle GXSTAGE

drop table tmp_kenn_vtbu_aggr;
drop table tmp_vari;
drop table tmp_vari_nhs;


drop table tmp_quartal;
drop table tmp_quartal2;

drop table tmp_ausg;
drop table tmp_ausg_block;
drop table tmp_hier;
drop table tmp_fikr;
drop table tmp_inst;

</#if>

</#if>

</#if>
