--freemarker template

<sqlvars>
    <sqlvar name="KENN_KOSTEN_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_KOSTEN_DATENQUELLE'
    </sqlvar>
    <sqlvar name="bezugszeiten" type="hashsequence">
        SELECT bezugszeit,kotr_art,bezugsart
        from kenn_vari V
        where V.kotr_art::Char(10) in (select C.apnr from kenn_cifx C
        where C.key=677
        and C.gruppe='KENN')
        order by 2,1,3
        ;
    </sqlvar>
    <sqlvar name="cob_installed">
        select count(*) from db_version where his_system ='cob';
    </sqlvar>
 <sqlvar name="hsnr">select hs_nr from hochschulinfo</sqlvar>
</sqlvars>

<#if K_KENN_PROFIL==1 || K_KENN_PROFIL==2 ||K_KENN_PROFIL==3>

<#if cob_installed=1 || KENN_KOSTEN_DATENQUELLE=170>

    create temp table tmp_quartal
    (
    tid integer,
    bezugszeit integer,
    jahr smallint,
    quartal integer
    );

    --zuerst alle Quartale zusammenstellen:

    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '1'),
    bezugszeit,
    1
    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='J';
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '2'),
    bezugszeit,
    2

    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='J';
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '3'),
    bezugszeit,
    3

    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='J';
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '4'),
    bezugszeit,
    4
    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='J';

    --nun die einzelnen Quartale, werden ggf. danach mit distinct rausgeworfen
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    bezugszeit ,
    val(substring('' || bezugszeit from 1 for 4)),
    val(substring('' || bezugszeit from 5 for 1))

    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='Q';

    --

    create temp table tmp_quartal2
    (

    bezugszeit integer,
    jahr smallint,
    quartal integer,
    bvkr_sicht_id integer,
    inst_sicht_id integer,
    monat_von smallint,
    monat_bis smallint

    );

    insert into tmp_quartal2
    (bezugszeit,
    jahr,
    quartal)
    select distinct bezugszeit,
    jahr,
    quartal
    from tmp_quartal;

    update tmp_quartal2 set monat_von=quartal*3-2;
    update tmp_quartal2 set monat_bis=quartal*3;
    update tmp_quartal2 set monat_bis=13 where monat_bis=12; --Korrekturmonat soll rein

    <#if bezugszeiten?has_content&&KENN_KOSTEN_DATENQUELLE!=170 >


        create temp table tmp_vari (vari_nr integer
        ) ;
        create temp table tmp_ausg(gruppe char(12),key char(12),ueberg char(12));
        create temp table tmp_ausg_block(block char(12), gruppe char(12),key char(12),ueberg char(12));
        create temp table tmp_hier(gruppe char(12),key char(120),ueberg char(12));
        create temp table tmp_fikr(fikrkey char(12),bezugszeit integer);
        create temp table tmp_inst(ch110_institut char(10),bezugszeit integer);


        create temp table tmp_kenn_vtbu_aggr (
        hs_nr INTEGER ,
        jahr SMALLINT ,
        quartal integer,
        monat SMALLINT ,
        quell_ch110_inst CHAR(10) ,
        quell_ch110_inst_tmp CHAR(10) ,
        quell_projnr CHAR(10) ,
        quell_stug CHAR(20) ,
        ziel_projnr CHAR(10) ,
        ziel_stug CHAR(20) ,
        ziel_fikrkey CHAR(12) ,
        ziel_fikr_aggr char(12),
        ziel_projnr_tmp CHAR(10),
        ziel_ch110_inst CHAR(10) ,
        ziel_ch110_inst_tmp CHAR(10) ,
        kokl CHAR(1) ,
        klr_geldgeber CHAR(10),
        ggnr char(4),
        vari char(1),
        lfb char(10),
        datum date ,
        betrag double precision
        );





        --zuerst BVKR
        --Sichten mit stichtag_id=0 gelten fr alle Stichtage
        update tmp_quartal2 set bvkr_sicht_id=(select min(S.tid)
        from sichten S, kenn_sichten K
        where K.sicht_name_intern=S.name_intern
        and K.dimension='BVKR'
        and K.stichtag_id=0)
        ;
        --Sicht frs ganze Jahr:
        update tmp_quartal2 set bvkr_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr);

        --Sicht frs Quartal:
        update tmp_quartal2 set bvkr_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit);



        <#if cob_installed=1>
            --Ab ins Pruefprotokoll:
            insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
            select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (Verteilbuchungen) gilt folgende BVKR-Kostenartensicht:' || S.name)::char(200), 'Info'::char(10)
            from tmp_quartal2 Q, sichten S
            where S.tid=Q.bvkr_sicht_id
            ;
            insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
            select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung (Verteilbuchungen) ist keine BVKR-Kostenartensicht definiert')::char(200), 'Warnung'::char(10)
            from tmp_quartal2 Q
            where Q.bvkr_sicht_id is null;

            --Wenn alt. Hier. als BVKR-Sicht definiert ist:
            insert into tmp_fikr
            select distinct A.key,Q.bezugszeit from
            cob_fikr F,cob_alt_keys A, sichten S, tmp_quartal2 Q
            where F.key = A.key
            and Q.bvkr_sicht_id=S.tid
            and S.alt_hier_id=A.hierarchie_id::char(150)
            and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between F.key_von and F.key_bis
            and S.type=20
            ;
            --Wenn regulre Sicht als KoA-Sicht def.:
            insert into tmp_fikr
            select distinct F.key,Q.bezugszeit from
            cob_fikr F, sichten S, tmp_quartal2 Q
            where Q.bvkr_sicht_id=S.tid
            and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between F.key_von and F.key_bis
            and S.type=10
            ;

            create index tmp_ix_fikr1 on tmp_fikr(fikrkey);
            create index tmp_ix_fikr2 on tmp_fikr(bezugszeit);

            --nun INST
            --Sichten mit stichtag_id=0 gelten fr alle Stichtage
            update tmp_quartal2 set inst_sicht_id=(select min(S.tid) from sichten S, kenn_sichten K
            where K.sicht_name_intern=S.name_intern
            and K.dimension='MWK_INST'
            and K.stichtag_id=0);

            --Sicht frs ganze Jahr:
            update tmp_quartal2 set inst_sicht_id=(
            select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
            where K.sicht_name_intern=S.name_intern
            and I.tid=K.stichtag_id
            and K.dimension='MWK_INST'
            and I.bezugsart='J'
            and I.bezugszeit=tmp_quartal2.jahr)
            where 0 < (select count(*)
            from sichten S, kenn_sichten K , kenn_stichtag I
            where K.sicht_name_intern=S.name_intern
            and I.tid=K.stichtag_id
            and K.dimension='MWK_INST'
            and I.bezugsart='J'
            and I.bezugszeit=tmp_quartal2.jahr);

            --Sicht frs Quartal:
            update tmp_quartal2 set inst_sicht_id=(
            select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
            where K.sicht_name_intern=S.name_intern
            and I.tid=K.stichtag_id
            and K.dimension='MWK_INST'
            and I.bezugsart='Q'
            and I.bezugszeit=tmp_quartal2.bezugszeit)
            where 0 < (select count(*)
            from sichten S, kenn_sichten K , kenn_stichtag I
            where K.sicht_name_intern=S.name_intern
            and I.tid=K.stichtag_id
            and K.dimension='MWK_INST'
            and I.bezugsart='Q'
            and I.bezugszeit=tmp_quartal2.bezugszeit);

            --Wenn alt. Hier. als INST-Sicht definiert ist:

            insert into tmp_inst
            select distinct A.key,Q.bezugszeit from
            cob_inst C,cob_alt_keys A, sichten S, tmp_quartal2 Q
            where C.key_apnr=A.key
            and Q.inst_sicht_id=S.tid
            and S.alt_hier_id=A.hierarchie_id::char(150)
            and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between C.gueltig_seit and C.gueltig_bis
            and S.type=20
            ;
            --Wenn regulre Sicht als INST-Sicht def.:
            insert into tmp_inst
            select distinct C.key_apnr,Q.bezugszeit from
            cob_inst C, sichten S, tmp_quartal2 Q
            where Q.inst_sicht_id=S.tid
            and date_val('01.' || trim(replace(Q.monat_bis::char(2), '13', '12')) || '.' || Q.jahr) between C.gueltig_seit and C.gueltig_bis
            and S.type=10
            ;

            insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.parent
            from cob_alt_keys C, tmp_quartal2 Q, sichten S
            where S.tid=Q.bvkr_sicht_id
            and S.type=20
            and C.hierarchie_id::char(150)=S.alt_hier_id
            ;
            insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.ueberg
            from kenn_fikr C, tmp_quartal2 Q, sichten S
            where S.tid=Q.bvkr_sicht_id
            and S.type=10
            ;
            create index tmp_ix_thier1 on tmp_hier(gruppe);
            create index tmp_ix_thier2 on tmp_hier(ueberg);

            --BVKR-Leafs fr Kostenartenblcke:
            --zuerst KENN_KOA_BLOCK_PERS_W
            <#if KENN_KOA_BLOCK_PERS_W?exists && "''" != KENN_KOA_BLOCK_PERS_W && "" != KENN_KOA_BLOCK_PERS_W>

                select 'KENN_KOA_BLOCK_PERS_W ist definiert' from xdummy;

                insert into tmp_ausg select distinct Q.bezugszeit,C.key,C.key
                from tmp_quartal2 Q,cob_fikr C where C.key in (${KENN_KOA_BLOCK_PERS_W})
                ;
                <#if SQLdialect='Postgres'>
                    select sp_get_children() ;
                <#else>

                    execute procedure sp_get_children();

                </#if>
                insert into tmp_ausg_block
                select '_PERS_W',gruppe ,key ,ueberg
                from tmp_ausg;
                delete from tmp_ausg;
            </#if>
            --zuerst KENN_KOA_BLOCK_PERS_NW
            <#if KENN_KOA_BLOCK_PERS_NW?exists &&  "''" != KENN_KOA_BLOCK_PERS_NW && "" != KENN_KOA_BLOCK_PERS_NW>
                select 'KENN_KOA_BLOCK_PERS_NW ist definiert' from xdummy;

                insert into tmp_ausg select distinct Q.bezugszeit,C.key,C.key
                from tmp_quartal2 Q,cob_fikr C where C.key in (${KENN_KOA_BLOCK_PERS_NW})
                ;
                <#if SQLdialect='Postgres'>
                    select sp_get_children() ;
                <#else>

                    execute procedure sp_get_children();

                </#if>
                insert into tmp_ausg_block
                select '_PERS_NW',gruppe ,key ,ueberg
                from tmp_ausg;
                delete from tmp_ausg;
            </#if>

            --dann KENN_KOA_BLOCK_PERS_S
            <#if KENN_KOA_BLOCK_PERS_S?exists && "''" != KENN_KOA_BLOCK_PERS_S && "" != KENN_KOA_BLOCK_PERS_S>
                select 'KENN_KOA_BLOCK_PERS_S ist definiert' from xdummy;

                insert into tmp_ausg select distinct Q.bezugszeit,C.key,C.key
                from tmp_quartal2 Q,cob_fikr C where C.key in (${KENN_KOA_BLOCK_PERS_S})
                ;
                <#if SQLdialect='Postgres'>
                    select sp_get_children() ;
                <#else>

                    execute procedure sp_get_children();

                </#if>
                insert into tmp_ausg_block
                select '_PERS_S',gruppe ,key ,ueberg
                from tmp_ausg;
                delete from tmp_ausg;
            </#if>

            --dann KENN_KOA_BLOCK_SACHK_O_BEW
            <#if KENN_KOA_BLOCK_SACHK_O_BEW?exists && "''" != KENN_KOA_BLOCK_SACHK_O_BEW && "" != KENN_KOA_BLOCK_SACHK_O_BEW>
                select 'KENN_KOA_BLOCK_SACHK_O_BEW ist definiert' from xdummy;

                insert into tmp_ausg select distinct Q.bezugszeit,C.key,C.key
                from tmp_quartal2 Q,cob_fikr C where C.key in (${KENN_KOA_BLOCK_SACHK_O_BEW})
                ;
                <#if SQLdialect='Postgres'>
                    select sp_get_children() ;
                <#else>

                    execute procedure sp_get_children();

                </#if>
                insert into tmp_ausg_block
                select '_SACHK_O_BEW',gruppe ,key ,ueberg
                from tmp_ausg;
                delete from tmp_ausg;
            </#if>



            --dann KENN_KOA_BLOCK_SACHK_BEW
            <#if KENN_KOA_BLOCK_SACHK_BEW?exists && "''" != KENN_KOA_BLOCK_SACHK_BEW && "" != KENN_KOA_BLOCK_SACHK_BEW>
                select 'KENN_KOA_BLOCK_SACHK_BEW ist definiert' from xdummy;

                insert into tmp_ausg select distinct Q.bezugszeit,C.key,C.key
                from tmp_quartal2 Q,cob_fikr C where C.key in (${KENN_KOA_BLOCK_SACHK_BEW})
                ;
                <#if SQLdialect='Postgres'>
                    select sp_get_children() ;
                <#else>

                    execute procedure sp_get_children();

                </#if>
                insert into tmp_ausg_block
                select '_SACHK_BEW',gruppe ,key ,ueberg
                from tmp_ausg;

                --Bewirtschaftungskosten drfen nicht in Sachkosten o. Bew. enthalten sein, daher
                --rausnehmen
                delete from tmp_ausg_block
                where
                block='_SACHK_O_BEW'
                and key in (select A.key from tmp_ausg A);
                --fertig
                delete from tmp_ausg;
            </#if>

            --dann KENN_KOA_BLOCK_ABSCHR
            <#if KENN_KOA_BLOCK_ABSCHR?exists && "''" != KENN_KOA_BLOCK_ABSCHR && "" != KENN_KOA_BLOCK_ABSCHR>
                select 'KENN_KOA_BLOCK_ABSCHR ist definiert' from xdummy;

                insert into tmp_ausg select distinct Q.bezugszeit,C.key,C.key
                from tmp_quartal2 Q,cob_fikr C where C.key in (${KENN_KOA_BLOCK_ABSCHR})
                ;
                <#if SQLdialect='Postgres'>
                    select sp_get_children() ;
                <#else>

                    execute procedure sp_get_children();

                </#if>
                insert into tmp_ausg_block
                select '_ABSCHR',gruppe ,key ,ueberg
                from tmp_ausg;
                delete from tmp_ausg;
            </#if>

            --dann KENN_KOA_BLOCK_KALK_MIETE
            <#if KENN_KOA_BLOCK_KALK_MIETE?exists && "''" != KENN_KOA_BLOCK_KALK_MIETE && "" != KENN_KOA_BLOCK_KALK_MIETE>
                select 'KENN_KOA_BLOCK_KALK_MIETE ist definiert' from xdummy;

                insert into tmp_ausg select distinct Q.bezugszeit,C.key,C.key
                from tmp_quartal2 Q,cob_fikr C where C.key in (${KENN_KOA_BLOCK_KALK_MIETE})
                ;
                <#if SQLdialect='Postgres'>
                    select sp_get_children() ;
                <#else>

                    execute procedure sp_get_children();

                </#if>
                insert into tmp_ausg_block
                select '_KALK_MIETE',gruppe ,key ,ueberg
                from tmp_ausg;
                delete from tmp_ausg;
            </#if>
            --dann KENN_KOA_BLOCK_ERL_STUD
            <#if KENN_KOA_BLOCK_ERL_STUD?exists && "''" != KENN_KOA_BLOCK_ERL_STUD && "" != KENN_KOA_BLOCK_ERL_STUD>
                select 'KENN_KOA_BLOCK_ERL_STUD ist definiert' from xdummy;

                insert into tmp_ausg select distinct Q.bezugszeit,C.key,C.key
                from tmp_quartal2 Q,cob_fikr C where C.key in (${KENN_KOA_BLOCK_ERL_STUD})
                ;
                <#if SQLdialect='Postgres'>
                    select sp_get_children() ;
                <#else>

                    execute procedure sp_get_children();

                </#if>
                insert into tmp_ausg_block
                select '_ERL_STUD',gruppe ,key ,ueberg
                from tmp_ausg;
                delete from tmp_ausg;
            </#if>

            --Gibt es folgenden Fall: eine KoA, die als Leaf im BVKR fungiert,
            --ist in der alt.Hier. der Hochschule ein Element unterhalb eines anderen Leafs,
            --dann tritt der paradoxe Fall auf, da eine Buchung bei der BVKR-Art beide Leafs haben soll
            --was aber nicht geht.

            --Daher rausschmeien:
            create temp table tmp_doppelt(block char(12),gruppe char(12),key char(12),ueberg char(12));
            insert into tmp_doppelt (block,gruppe,key)
            select block,gruppe,key from tmp_ausg_block group by 1,2,3 having count(*) > 1;

            insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
            select distinct today(),'cob_alt_keys'::char(18),'kenn_alt_keys'::char(18),
            ('Fr Quartal ' || trim(D.gruppe) || ' im Bereich Kostenrechnung ist die Kostenart ' || trim(D.key) || ' einer BVKR-KoA untergeordnet, obwohl sie selbst eine BVKR-KoA ist.')::char(250),
            'Info'::char(10)
            from tmp_doppelt D
            ;

            delete from tmp_ausg_block where block || '_' || gruppe || '_' || key in
            (select D.block || '_' || D.gruppe || '_' || D.key from tmp_doppelt D)
            and key != ueberg;

            drop table tmp_doppelt;

            --Ende Ziel-Kostenart zum Block


            <#foreach bezugszeit in bezugszeiten>

                select 'Verarbeitung fr ${bezugszeit.bezugszeit} ${bezugszeit.bezugsart} bei kotr_art {bezugszeit.kotr_art}  beginnt' from xdummy;

                delete from tmp_vari;

                --Suche zunchst alle parents des Verteilschritts fr Kosten der Lehre
                --Duplikate ab ins Pruefprotokoll, siehe https://hiszilla.his.de/hiszilla/show_bug.cgi?id=89159:
                insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
                select today(),'kenn_vari'::char(18),
                'Fr Stichtags-Zeitraum ${bezugszeit.bezugszeit} im Bereich Kostenrechnung (${bezugszeit.kotr_art}) gibt es mehrere Verteilschritte' , 'Warnung'::char(10)
                from xdummy
                where
                1 < (select count(*) from kenn_vari where kotr_art='${bezugszeit.kotr_art}' and bezugszeit=${bezugszeit.bezugszeit} and bezugsart='${bezugszeit.bezugsart}')
                ;

                <#if SQLdialect='Postgres'>

                    select sp_get_vari_parent((
                    select min(vari_nr) from kenn_vari where kotr_art='${bezugszeit.kotr_art}' and bezugszeit=${bezugszeit.bezugszeit} and bezugsart='${bezugszeit.bezugsart}')
                    );
                <#else>

                    execute procedure sp_get_vari_parent((
                    select min(vari_nr) from kenn_vari where kotr_art='${bezugszeit.kotr_art}' and bezugszeit=${bezugszeit.bezugszeit} and bezugsart='${bezugszeit.bezugsart}')
                    );

                </#if>

                <#if bezugszeit.bezugsart='J'>

                    delete from tmp_kenn_vtbu_aggr
                    where jahr=${bezugszeit.bezugszeit}
                    and vari='${bezugszeit.kotr_art}';

                    insert into tmp_kenn_vtbu_aggr (
                    jahr,
                    quartal,
                    monat,
                    quell_ch110_inst_tmp,
                    quell_projnr,
                    quell_stug,
                    ziel_projnr_tmp,
                    ziel_stug,
                    ziel_fikrkey,
                    ziel_ch110_inst_tmp,
                    kokl,
                    ggnr,
                    vari,
                    datum,
                    betrag
                    )
                    select A.jahr, Q.bezugszeit,A.monat, quell_ch110_inst,
                    quell_projnr,
                    quell_stug,
                    ziel_projnr,
                    ziel_stug, zfikr,
                    ziel_ch110_inst,
                    kokl, klr_geldgeber,'${bezugszeit.kotr_art}', today(), sum(betrag)
                    from cob_vtbu_aggr A, tmp_quartal2 Q
                    where Q.jahr=A.jahr
                    and A.monat between Q.monat_von and Q.monat_bis
                    and A.jahr=${bezugszeit.bezugszeit}
                    and A.varnr in (select vari_nr from tmp_vari)
                    <#if bezugszeit.kotr_art='L' || bezugszeit.kotr_art='A'>
                        and A.ziel_stug is not null --bislang nur Kosten der Studiengnge in BaWue
                    <#else>
                        --Sachsen und Rest der Welt: nur wenn die interne Kostenstelle in der alt.Hier drin ist:
                        and (A.quell_ch110_inst is null or A.quell_ch110_inst in (
                        select I.ch110_institut from tmp_inst I where I.bezugszeit=Q.bezugszeit
                        ))
                    </#if>
                    
                    group by 1,2,3,4,5,6,7,8,9,10,11,12,13;

                    --Ab ins Pruefprotokoll:
                    insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
                    select distinct today(),'kenn_vari'::char(18),
                    ('Fr Stichtags-Zeitraum Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung ({bezugszeit.kotr_art}) gilt im Verteilschritt-Zeitraum Jahr ${bezugszeit.bezugszeit} folgender Verteilschritt:'
                    || trim(C.vari_dbez) || ' (' || V.vari_nr|| ')')::char(255), 'Info'::char(10)
                    from tmp_quartal2 Q,kenn_vari V, cob_vari C
                    where V.bezugszeit=Q.jahr
                    and C.vari_nr=V.vari_nr
                    and V.kotr_art='${bezugszeit.kotr_art}' and V.bezugszeit=${bezugszeit.bezugszeit}
                    and V.bezugsart='${bezugszeit.bezugsart}';


                </#if> --Ende bezugszeit.bezugsart='J'

                <#if bezugszeit.bezugsart='Q'>

                    <#assign jahr=bezugszeit.bezugszeit[0..3] />
                    <#assign quartal=bezugszeit.bezugszeit[4..4]?number />
                    <#assign monat_u=(quartal*3)-2 />
                    <#assign monat_o=quartal*3 />
                    <#if monat_o=12>

                        <#assign monat_o=13 />

                    </#if>

                    select '${jahr}-${quartal} Monat ${monat_u}-${monat_o}' from xdummy;

                    delete from tmp_kenn_vtbu_aggr
                    where jahr=${jahr}
                    and monat between ${monat_u} and ${monat_o}
                    and vari='${bezugszeit.kotr_art}';

                    insert into tmp_kenn_vtbu_aggr (
                    jahr,
                    quartal,
                    monat,
                    quell_ch110_inst_tmp,
                    quell_projnr,
                    quell_stug,
                    ziel_projnr_tmp,
                    ziel_stug,
                    ziel_fikrkey,
                    ziel_ch110_inst_tmp,
                    kokl,
                    ggnr,
                    vari,
                    datum,
                    betrag
                    )
                    select A.jahr, Q.bezugszeit,A.monat, quell_ch110_inst,
                    quell_projnr,
                    quell_stug,
                    ziel_projnr,
                    ziel_stug, zfikr,
                    ziel_ch110_inst,
                    kokl, klr_geldgeber,'${bezugszeit.kotr_art}', today(), sum(betrag)
                    from cob_vtbu_aggr A, tmp_quartal2 Q
                    where Q.jahr=A.jahr
                    and A.monat between Q.monat_von and Q.monat_bis
                    and A.jahr=${jahr}
                    and A.monat between ${monat_u} and ${monat_o}
                    and A.varnr in (select vari_nr from tmp_vari)
                    <#if bezugszeit.kotr_art='L' || bezugszeit.kotr_art='A'>
                        and A.ziel_stug is not null --bislang nur Kosten der Lehre
                    </#if>
                    group by 1,2,3,4,5,6,7,8,9,10,11,12,13;

                    --Ab ins Pruefprotokoll:
                    insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
                    select distinct today(),'kenn_vari'::char(18),
                    ('Fr Stichtags-Zeitraum Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung ({bezugszeit.kotr_art}) gilt im Verteilschritt-Zeitraum Quartal ${bezugszeit.bezugszeit} folgender Verteilschritt:'
                    || trim(C.vari_dbez) || ' (' || V.vari_nr|| ')')::char(255), 'Info'::char(10)
                    from tmp_quartal2 Q,kenn_vari V, cob_vari C
                    where V.bezugszeit=Q.bezugszeit
                    and C.vari_nr=V.vari_nr
                    and V.kotr_art='${bezugszeit.kotr_art}' and V.bezugszeit=${bezugszeit.bezugszeit}
                    and V.bezugsart='${bezugszeit.bezugsart}';


                </#if> --Ende bezugszeit.bezugsart='Q'>

                <#if bezugszeit.bezugsart='M'>
                    <#assign jahr=bezugszeit.bezugszeit[0..3] />
                    <#assign monat=bezugszeit.bezugszeit[4..5] />

                    select '${jahr}- Monat ${monat}' from xdummy;


                    delete from tmp_kenn_vtbu_aggr
                    where jahr=${jahr}
                    and monat= ${monat}
                    and vari='${bezugszeit.kotr_art}';

                    insert into tmp_kenn_vtbu_aggr (
                    jahr,
                    quartal,
                    monat,
                    quell_ch110_inst_tmp,
                    quell_projnr,
                    quell_stug,
                    ziel_projnr_tmp,
                    ziel_stug,
                    ziel_fikrkey,
                    ziel_ch110_inst_tmp,
                    kokl,
                    ggnr,
                    vari,
                    datum,
                    betrag
                    )
                    select A.jahr, Q.bezugszeit,A.monat, quell_ch110_inst,
                    quell_projnr,
                    quell_stug,
                    ziel_projnr,
                    ziel_stug, zfikr,
                    ziel_ch110_inst,
                    kokl, klr_geldgeber,'${bezugszeit.kotr_art}', today(), sum(betrag)
                    from cob_vtbu_aggr A, tmp_quartal2 Q
                    where Q.jahr=A.jahr
                    and A.monat between Q.monat_von and Q.monat_bis
                    and A.jahr=${jahr}
                    and A.monat= ${monat}
                    and A.varnr in (select vari_nr from tmp_vari)
                    <#if bezugszeit.kotr_art='L' || bezugszeit.kotr_art='A'>
                        and A.ziel_stug is not null --bislang nur Kosten der Lehre
                    </#if>
                    group by 1,2,3,4,5,6,7,8,9,10,11,12,13;

                    --Ab ins Pruefprotokoll:
                    insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
                    select distinct today(),'kenn_vari'::char(18),
                    ('Fr Stichtags-Zeitraum Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung ({bezugszeit.kotr_art}) gilt im Verteilschritt-Zeitraum Jahr-Monat ${jahr}-${monat} folgender Verteilschritt:'
                    || trim(C.vari_dbez) || ' (' || V.vari_nr|| ')')::char(255), 'Info'::char(10)
                    from tmp_quartal2 Q,kenn_vari V, cob_vari C
                    where C.vari_nr=V.vari_nr
                    and V.monat between Q.monat_von and Q.monat_bis
                    and V.kotr_art='${bezugszeit.kotr_art}' and V.bezugszeit=${bezugszeit.bezugszeit}
                    and V.bezugsart='${bezugszeit.bezugsart}';

                </#if> --Ende bezugszeit.bezugsart='M'

		<#if bezugszeit.kotr_art='L' || bezugszeit.kotr_art='A'>
                    --Ziel-KoA Blcke BaWue:
                    update tmp_kenn_vtbu_aggr set ziel_fikr_aggr=
                    (select distinct block from tmp_ausg_block A
                    where A.key=tmp_kenn_vtbu_aggr.ziel_fikrkey
                    and val(A.gruppe)=tmp_kenn_vtbu_aggr.quartal
                    );
                </#if>

            </#foreach>  --Ende Schleife Bezugszeiten




            update tmp_kenn_vtbu_aggr set ziel_fikr_aggr='_S'
            where ziel_fikr_aggr is null;

            update tmp_kenn_vtbu_aggr set klr_geldgeber=(select gruppe from kenn_cifx C where key=648 and C.apnr=tmp_kenn_vtbu_aggr.ggnr)
            where ggnr is not null;

            update tmp_kenn_vtbu_aggr set quell_projnr=(select k_extkotr from cob_proj P where P.projnr=tmp_kenn_vtbu_aggr.quell_projnr)
            where quell_projnr is not null;
            update tmp_kenn_vtbu_aggr set quell_projnr=(select k_extkotr from cob_stug S where S.stug_key=tmp_kenn_vtbu_aggr.quell_stug)
            where quell_projnr is null
            and quell_stug is not null;


            update tmp_kenn_vtbu_aggr set ziel_projnr=(select k_extkotr from cob_proj P where P.projnr=tmp_kenn_vtbu_aggr.ziel_projnr_tmp)
            where ziel_projnr_tmp is not null;

            update tmp_kenn_vtbu_aggr set ziel_projnr=(select k_extkotr from cob_stug S where S.stug_key=tmp_kenn_vtbu_aggr.ziel_stug)
            where ziel_stug is not null
            and ziel_projnr is null;


            insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
            select distinct today(),'cob_proj'::char(18),'Projekt ' || trim(ziel_projnr_tmp) || ' im Bereich Sekundrkosten ist keinem externen Kostentrger zugeordnet !'::char(200), 'Warnung'::char(10)
            from tmp_kenn_vtbu_aggr
            where ziel_projnr is null
            and ziel_projnr_tmp is not null;

            update tmp_kenn_vtbu_aggr set hs_nr=(select hs_nr from hochschulinfo);


            delete from kenn_vtbu_aggr where 0=
            (select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');

            delete from kenn_vtbu_aggr
            where quartal in (select bezugszeit from tmp_quartal2) ;



            insert into kenn_vtbu_aggr (
            hs_nr,
            jahr,
            quartal,
            monat,
            quell_ch110_inst,
            quell_projnr,
            quell_stug,
            ziel_projnr,
            ziel_stug,
            ziel_fikrkey,
            ziel_ch110_inst,
            kokl,
            klr_geldgeber,
            vari,
            datum,
            betrag
            )
            select
            hs_nr,
            jahr,
            quartal,
            monat,
            quell_ch110_inst,
            quell_projnr,
            quell_stug,
            ziel_projnr,
            ziel_stug,
            ziel_fikr_aggr,
            ziel_ch110_inst,
            kokl,
            klr_geldgeber,
            vari,
            datum,
            sum(betrag)
            from tmp_kenn_vtbu_aggr
            group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;

	    drop table tmp_kenn_vtbu_aggr;
            drop table tmp_vari;
	    drop table tmp_ausg;
            drop table tmp_ausg_block;
            drop table tmp_hier;
            drop table tmp_fikr;
            drop table tmp_inst;
        </#if> -- ende Datenquelle COB


    </#if>
    <#if KENN_KOSTEN_DATENQUELLE=170>
        delete from kenn_vtbu_aggr where 0=
        (select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');

        delete from kenn_vtbu_aggr
        where quartal::char(5) in (select bezugszeit::char(5) from tmp_quartal2) ;

        <@selectintotmp source="gxstage_vtbu_aggr G,  tmp_quartal2 Q" target="tmp_vtbu"
                        select="G.hs_nr,G.jahr,G.quartal,G.monat,G.quell_ch110_inst,G.quell_projnr,G.quell_stug,G.ziel_projnr,G.ziel_stug,G.ziel_fikrkey,G.kokl,G.klr_geldgeber,G.vari,G.datum,G.betrag,G.ziel_ch110_inst">
            where Q.jahr=G.jahr
            and G.monat between Q.monat_von and Q.monat_bis
            and (vari is null or vari!='Q') -- Querschnittsprodukte in separater Datei trans_kenn_vtbu_qp_aggr.sql
            </@selectintotmp>
            <@informixnolog/>;
    --HfT Karlsruhe 6760
     --FH Reutlingen 6830
    --FH Aalen 6710
     --FH Pforzheim 6810
            <#if hsnr==6760||hsnr==6830||hsnr==6710||hsnr==6810>
                -- Referenzmodell HAWed Bawue Mail Frau Raub 12.4.2017 im Memtext svn Projekte/hsz-bw/muster/SAP_LCC/Sekundaerkostenartenbloecke/K_Kostenartenblcke_SuperX V0 1.doc
                -- ggfs. fhrende Nullen entfernen
                update tmp_vtbu set ziel_fikrkey=substring(ziel_fikrkey from 3 for 10) where ziel_fikrkey like '00%';
                -- IF-Blcke dieser Art sind immer true, dient dazu Einrckung mit emacs machen zu knnen
                <#if "Sekundrkostenartenblcke bei KT Forschung und Dienstleistung (vari F und vari D, Verrechnungsschema W2)"!="">
                    --_PERS_W=Personalkosten wissenschaftlicher Dienst
                    update tmp_vtbu set ziel_fikrkey='_PERS_W' where vari in ('F','D') and ziel_fikrkey in (
                    -- 65700100 bis 65700150
                    '65700100', --Wissenschaftliche Hilfskrfte MA
                    '65700150', --Wissenschaftliche Hilfskrfte BA
                    '93000100', --Abrechnung Personalkosten Wiss.D.
                    '96000100', --Umlagen Pers.kosten Wiss. Dienst
                    '61300200', --61300230
                    '61300200', --Werkvertrge, Leiharbeitskrfte
                    '61300210', --Lehrauftrge (ber Zeitraum)
                    '61300220', --Gastprofessoren (Werkvertrag)
                    '61300230', --Gastvortrge (einmalig)
                    '71700000', --Kostenerstattungen Stiftungsprofessuren
                    '90606100', --PSK WISS. DIENST E 13
                    '90604100', --PSK HH. DIENST (A)
                    '90605100' --PSK HH. DIENST (B)
                    );

                    --_PERS_NW=Personalkosten nichtwissenschaftlicher Dienst
                    update tmp_vtbu set ziel_fikrkey='_PERS_NW' where vari in ('F','D') and ziel_fikrkey in (
                    '65700200', --Stud. Hilfskrfte
                    '62500000', --Entgelte Auszubildende
                    '62300000', --bergangsgelder / Abfindungen
                    '65000000', --Aufwendungen fr Personalmanahmen
                    '65700000', --Praktikanten
                    '65900900', --brige sonstige Personalaufwendungen
                    '90601100', --PSK EINFACHER DIENST
                    '90602100', --PSK MITTLERER DIENST
                    '90603100', --PSK GEHOBENER DIENST
                    '93000150', --Abrechnung Personalkosten Sonstige
                    '96000150' --Umlagen Pers.kosten nicht-Wiss. Dienst
                    );

                    --_SACHK_BEW=Bewirtschaftungskosten
                    update tmp_vtbu set ziel_fikrkey='_SACHK_BEW' where vari in ('F','D') and ziel_fikrkey in (
                    -- 60500000 bis 60610000
                    '60500000', --Strom
                    '60500100', --(Fern-)Wrme und Klte
                    '60500110', --Aufw. Heizl
                    '60500200', --Wasser und Abwasser
                    '60500300', --Treibstoffe und Schmierstoffe (Benzin, M
                    '60500900', --Sonstige Energiekosten
                    '60600000', --Material Reparatur / Instandh. Geb. / ba
                    '60610000', --Material Reparatur / Instandh. unbew. Ve
                    --61400000 bis 61400900
                    '61400000', --Abfall und Entsorgung
                    '61400900', --Sonstige Entsorgungskosten
                    --61700000 bis 61700500
                    '61700000', --Aufw. Fremdreinigungskosten
                    '61700100', --Aufw. Ungezieferbekmpfung
                    '61700200', --Aufw. Haus-/Gelndebewachung/-sicherung
                    '61700500', --Gartenpflege und Winterdienst
                    --67000000  bis 67100310
                    '67000000', --Pachten, Erbbauzinsen und Nebenkosten
                    '67000010', --Grundbesitzabgaben
                    '67000100', --Mieten Gebude (langfristige Anmietung)
                    '67000150', --Mieten Rume (kurzfristige Anmietung)
                    '67000200', --Mieten Techn. Anlagen, Gerte, Maschinen
                    '67000300', --Mieten and. Anlagen, Betriebs- / Geschf
                    '67000310', --Mieten Fahrzeuge
                    '67100100', --Leasing Gebude
                    '67100200', --Leasing Techn. Anlagen, Gerte, Maschine
                    '67100300', --Leasing and. Anlagen, Betriebs- / Gesch
                    '67100310', --Leasing Fahrzeuge
                    '90201000', --Kalkulatorische Bewirtschaftungskosten
                    '93000400', --Abrechnung Bewirtschaftungskosten
                    '96000400' --Umlagen Bewirtschaftungskosten
                    );

                    --_SACHK_O_BEW=Sachkosten ohne Bewirtschaftungskosten
                    update tmp_vtbu set ziel_fikrkey='_SACHK_O_BEW' where vari in ('F','D') and ziel_fikrkey in (
                    --60000000 bis 60400000
                    '60000000', --Rohstoffe
                    '60000100', --Bestandsvernderung Vorrte
                    '60000200', --Aufw. Chemikalien / Gase / Organische Ma
                    '60000300', --Aufw. Holz / Kunststoff / Glas / Metalle
                    '60000400', --Aufw. Elektronikbauteile
                    '60100100', --Aufwendungen fr EDV-Material
                    '60100200', --Putz- und Pflegematerial
                    '60100300', --Aufw. Lebensmittel und Kantinenwaren
                    '60100900', --Sonstiges Verbrauchsmaterial
                    '60200000', --Hilfsstoffe
                    '60300000', --Betriebsstoffe
                    '60300100', --Aufw. Werkzeuge und Kleinbauteile
                    '60400000', --Verpackungsmaterial
                    --60620000 bis 61300150
                    '60620000', --Material Reparatur / Instandh. bew. Sach
                    '60700010', --Aufw. EDV-Gerte und -Komponenten
                    '60700090', --Aufw. Sonst. Einr. (o. EDV), Kleingerte
                    '60700100', --Aufw. Lehr- und Lernmaterial
                    '60700200', --Aufw. fr bezogene (Handels-)Waren
                    '60700900', --Sonstige Materialien
                    '60800000', --Dienst- und Schutzkleidung
                    '60800100', --Arbeits- und Betriebssicherheit
                    '60900000', --Sonderabschreibung auf Vorrte
                    '61200000', --Akkreditierungskosten
                    '61200100', --Evaluierungskosten
                    '61200200', --(Sachverstndigen-)Gutachten
                    '61200300', --Forschungs- und Entwicklungsauftrge
                    '61200400', --EDV-Fremddienstleistungen
                    '61300100', --Druck- und Kopierkosten (extern)
                    '61300150', --Aufw. fr Publikationen (Druckkostenzusc
                    --61300300 bis 61300900
                    '61300300', --Verlags- / Bibliotheksdienstleistungen
                    '61300400', --Aufw. Binden / Restaurieren Bcher / Sch
                    '61300600', --Umzugskosten (innerhalb Hochschule)
                    '61300900', --Sonstige Fremdleistungen
                    --61500000  bis 61620920
                    '61500000', --Frachtkosten
                    '61600010', --Fremdinst. Gebude und bauliche Anlagen
                    '61600020', --Wartung Gebude und bauliche Anlagen
                    '61610010', --Fremdinst. Sonst. unbew. Verm.
                    '61610020', --Wartung Sonst. unbew. Verm.
                    '61620010', --Fremdinst. Gerte / Ausstattung
                    '61620020', --Wartung Gerte / Ausstattung
                    '61620110', --Fremdinst. EDV-Gerte / EDV-Ausstattung
                    '61620120', --Wartung EDV-Gerte / EDV-Ausstattung
                    '61620210', --Fremdinst. Fernmeldeanlagen
                    '61620220', --Wartung Fernmeldeanlagen
                    '61620910', --Fremdinst. Sonst. Bew. Sachen
                    '61620920', --Wartung Sonst. Bew. Sachen
                    '61700900', --Sonstige Aufwendungen fr bezogene Leist
                    '61800000', --Aufwandsberichtigungen (Skonti, Boni,
                    --65000100 bis 65400000
                    '65000100', --Stellenausschreibung
                    '65100000', --Aufw. bernommene Fahrtkosten
                    '65100100', --Aufw. Umzugskosten / Trennungsgeld
                    '65100200', --Heimfahrten Azubis
                    '65200000', --Aufwendungen fr Betriebs- / Amtsarzt
                    '65200010', --Aufwendungen fr Arbeitssicherheit
                    '65400000', --Aufwendungen fr Aus-, Fort- und Weiterb
                    --65700900 bis 65900100
                    '65700900', --So. Aufw. ehren-, nebenamtlich, -berufli
                    '65900100', --Kosten fr ABM
                    '65900300', --Aufwand Dienstleistungen LBV
                    --67200000 bis 71250000
                    '67200000', --Lizenzen und Konzessionen
                    '67300000', --Gebhren der Technischen berwachung
                    '67300010', --Gebhren fr Patente
                    '67300020', --ffentlich-Rechtliche Gebhren
                    '67300090', --Sonstige Gebhren
                    '67500000', --Nebenkosten des Geldverkehrs
                    '67600000', --Provisionen
                    '67700000', --Gerichts- / Anwaltskosten
                    '67700100', --(Steuer-)Beratungskosten
                    '67700200', --Prfung / Erstellung JA
                    '67800000', --Aufwendungen fr Hochschulrat und dgl.
                    '67900000', --Sonst. Aufw. Inanspruchnahme von Rechten
                    '68000000', --Papier
                    '68000200', --Aufw. Bromaterial
                    '68100000', --Medien (10 Jahre)
                    '68100100', --Lehrbcher (4 Jahre)
                    '68100200', --Zeitungen, Zeitschriften (Periodika)
                    '68100300', --Fortsetzungen, Lieferungswerke
                    '68100400', --Elektronische Medien
                    '68100500', --Rara, Inkunablen, 
                    '68200000', --Porto, Versandkosten, Zustelldienste
                    '68300000', --Fernmeldegebhren
                    '68300100', --Kosten der Datenbertragung
                    '68300900', --Sonstige Kommunikationskosten
                    '68500000', --Wegstreckenentschdigungen / Dienstgnge
                    '68500100', --Dienstreisen Inland
                    '68500200', --Dienstreisen europisches Ausland
                    '68500300', --Dienstreisen auereuropisches Ausland
                    '68500400', --Reisen Gastwissenschaftler, Honorarkrft
                    '68600000', --Bewirtungskosten
                    '68600200', --Reprsentationskosten
                    '68600800', --ffentlichkeitsarbeit und Werbung
                    '68610000', --Aufw. Verfgungsmittel
                    '68900900', --Sonstige schliche Kosten
                    '69000000', --Gebudeversicherungen
                    '69010000', --Sonstige Versicherungen
                    '69100000', --Mitgliedsbeitrge Inland
                    '69110000', --Mitgliedsbeitrge Ausland
                    '69200000', --Schadensersatzleistungen, Leist. aus Br
                    '69301000', --Aufwendungen aus Forderungsverzicht
                    '69302000', --Kassenfehlbetrge
                    '69305100', --Aufwand aus Inventurdifferenzen (MM)
                    '69305200', --Aufwand aus Umbewertungen (MM)
                    '69305300', --Aufwand aus Zahlungsdifferenzen
                    '69305400', --Aufwand aus Kursdifferenzen
                    '69305500', --Aufwand aus Rundungsdifferenzen
                    '69309000', --Sonst. betr. Aufw.
                    '69309001', --Aufwand Projektpauschale
                    '69500000', --Verluste aus dem Abgang von Vorrten
                    '69600000', --Verluste aus dem Abgang von Vermgensgeg
                    '69600001', --Verluste aus Abgang von Vermgensgegenst
                    '69700000', --Einstellungen Sonderposten mit Rcklagen
                    '69700100', --Aufwand aus Zufhrung Sonderposten Bund
                    '69700200', --Aufwand aus Zufhrung Sonderposten Land
                    '69700400', --Aufwand aus Zufhrung Sonderposten ffen
                    '69700500', --Aufwand aus Zufhrung SoPo nicht ffentl
                    '69700600', --Aufwand aus Zufhrung Sonderposten DFG
                    '69700700', --Aufwand aus Zufhrung SoPo Schenkung/Sac
                    '69703000', --Aufwand aus Zufhrung Sonderposten ander
                    '69800000', --Zufhrung Rckstellungen
                    '69900000', --Periodenfremde Aufwendungen
                    '70200000', --Grundsteuer
                    '70300000', --Kfz-Steuer
                    '70700000', --Umsatzsteuer aus unentgeltlicher Wertabg
                    '70900100', --Ein- und Ausfuhrzlle
                    '70900900', --Sonst. betr. Steuern, steuerhnl. Aufw.
                    '71100000', --Allgemeine Zuweisungen an Sondervermgen
                    '71250000', --Weitere sonstige Zuschsse laufende Zwec
                    --71700090 bis 73100900
                    '71700090', --Kostenerstattungen an Sonstige im Inland
                    '73000100', --Stipendien Studierende - Inlnder
                    '73000110', --Stipendien Doktoranden - Inlnder
                    '73000120', --Stipendien Post-Doktoranden - Inlnder
                    '73000190', --Sonstige Stipendienaufw. - Inlnder
                    '73000200', --Stipendien Studierende - Auslnder
                    '73000210', --Stipendien Doktoranden - Auslnder
                    '73000220', --Stipendien Post-Doktoranden - Auslnder
                    '73000290', --Sonstige Stipendienaufw. - Auslnder
                    '73000400', --Spenden, Preisgelder, Ehrungen
                    '73100010', --Exkursionen Studierende - Inland
                    '73100020', --Exkursionen Studierende - Ausland
                    '73100100', --Sonstige Zuwendungen fr Studierende
                    '73100900', --Weitere Leistungen an Dritte
                    --74500000 bis 79700100
                    '74500000', --Verluste aus dem Abgang von Finanzanlage
                    '75110000', --Zinsen am inlndischen Kreditmarkt
                    '75900000', --Sonstige Zinsen und hnliche Aufwendunge
                    '77000000', --Gewerbeertragsteuer
                    '77100000', --Krperschaftsteuer
                    '77200000', --Kapitalertragsteuer
                    '77300000', --Auslndische Quellensteuer
                    '77990000', --Sonstige Steuern
                    '79100000', --Auerordentliche Aufwendungen
                    '79670000', --Aufw. aus der Zufhrung zu Fonds und St
                    '79690000', --Aufw. aus der Zufhrung zu Rcklagen
                    '79700000', --Rckzahlungen von Zuweisungen und Zusch
                    '79700100', --Rckzahlungen von Investitionszuschssen
                    '93000200', --Abrechnung Sachkosten
                    '96000200' --Umlagen Sachkosten
                    );
                    --_ABSCHR=Abschreibungen
                    update tmp_vtbu set ziel_fikrkey='_ABSCHR' where vari in ('F','D') and ziel_fikrkey in (
                    '93000300', --Abrechnung Abschreibungen
                    '96000300', --Umlagen Abschreibungen
                    --66100000  bis 66800000
                    '66100000', --Planmige Abschreibungen immaterielle V
                    '66200000', --Abschreibungen auf Gebude, Gebudeeinri
                    '66310000', --Planm. Abschr. Techn. Anlagen / Maschine
                    '66390000', --Planm. Abschr. GWG Techn. Anlagen / Masc
                    '66400000', --Abschreibungen Medienbestand
                    '66410000', --Abschreibungen andere Anlagen, BuGA
                    '66490000', --Abschreibungen GWG andere Anlagen, BuGA
                    '66500010', --Auerplanm. Abschreibungen Immat. VG
                    '66500020', --Auerplanm. Abschreibungen Gebude
                    '66500030', --Auerplanm. Abschreibungen Techn. Anl.
                    '66500040', --Auerplanm. Abschreibungen BuGA
                    '66500050', --Auerplanm. AfA FinA
                    '66800000', --Unbliche Abschr. Vorrte, Ford. und son
                    '74000000' --Abschreibungen auf Finanzanlagen
                    );
                    --_KALK_MIETE=Kalkulatorische Mieten
                    update tmp_vtbu set ziel_fikrkey='_KALK_MIETE' where vari in ('F','D') and ziel_fikrkey in (
                    '90200001', --Kalkulatorische Flchenkosten
                    '96000500', --Umlagen Kalkulatorische Mieten
                    '93000500' --Abrechnung Kalk. Mieten
                    );
                </#if>
                <#if "Sekundrkostenartenblcke bei KT Lehre nachfrageorientiert (vari L, Verrechnungsschema W3)"!="">
                    --_PERS_W=Personalkosten wissenschaftlicher Dienst
                    update tmp_vtbu set ziel_fikrkey='_PERS_W' where vari in ('L') and ziel_fikrkey in (
                    '96000100', --Umlagen Pers.kosten Wiss. Dienst
                    --65700100 bis 65700150
                    '65700100', --Wissenschaftliche Hilfskrfte MA
                    '65700150', --Wissenschaftliche Hilfskrfte BA
                    '93000100', --Abrechnung Personalkosten Wiss.D.
                    --61300200  bis 61300230
                    '61300200', --Werkvertrge, Leiharbeitskrfte
                    '61300210', --Lehrauftrge (ber Zeitraum)
                    '61300220', --Gastprofessoren (Werkvertrag)
                    '61300230', --Gastvortrge (einmalig)
                    '96000103', --(N) Umlagen Pers.kosten Wiss. Dienst
                    '71700000', --Kostenerstattungen Stiftungsprofessuren
                    '90606100', --PSK WISS. DIENST E 13
                    '90604100', --PSK HH. DIENST (A)
                    '90605100' --PSK HH. DIENST (B)
                    );
                    --_PERS_NW=Personalkosten nichtwissenschaftlicher Dienst
                    update tmp_vtbu set ziel_fikrkey='_PERS_NW' where vari in ('L') and ziel_fikrkey in (
                    '65700200', --Stud. Hilfskrfte
                    '62500000', --Entgelte Auszubildende
                    '62300000', --bergangsgelder / Abfindungen
                    '65000000', --Aufwendungen fr Personalmanahmen
                    '96000150', --Umlagen Pers.kosten nicht-Wiss. Dienst
                    '65700000', --Praktikanten
                    '65900900', --brige sonstige Personalaufwendungen
                    '90601100', --PSK EINFACHER DIENST
                    '90602100', --PSK MITTLERER DIENST
                    '90603100', --PSK GEHOBENER DIENST
                    '93000150', --Abrechnung Personalkosten Sonstige
                    '96000153' --(N) Umlagen Pers.kosten nicht-WD
                    );
                    --_SACHK_BEW=Bewirtschaftungskosten
                    update tmp_vtbu set ziel_fikrkey='_SACHK_BEW' where vari in ('L') and ziel_fikrkey in (
                    '96000400', --Umlagen Bewirtschaftungskosten
                    --60500000 bis 60610000
                    '60500000', --Strom
                    '60500100', --(Fern-)Wrme und Klte
                    '60500110', --Aufw. Heizl
                    '60500200', --Wasser und Abwasser
                    '60500300', --Treibstoffe und Schmierstoffe (Benzin, M
                    '60500900', --Sonstige Energiekosten
                    '60600000', --Material Reparatur / Instandh. Geb. / ba
                    '60610000', --Material Reparatur / Instandh. unbew. Ve
                    --61400000 bis 61400900
                    '61400000', --Abfall und Entsorgung
                    '61400900', --Sonstige Entsorgungskosten
                    --61700000 bis 61700500
                    '61700000', --Aufw. Fremdreinigungskosten
                    '61700100', --Aufw. Ungezieferbekmpfung
                    '61700200', --Aufw. Haus-/Gelndebewachung/-sicherung
                    '61700500', --Gartenpflege und Winterdienst
                    --67000000 bis 67100310
                    '67000000', --Pachten, Erbbauzinsen und Nebenkosten
                    '67000010', --Grundbesitzabgaben
                    '67000100', --Mieten Gebude (langfristige Anmietung)
                    '67000150', --Mieten Rume (kurzfristige Anmietung)
                    '67000200', --Mieten Techn. Anlagen, Gerte, Maschinen
                    '67000300', --Mieten and. Anlagen, Betriebs- / Geschf
                    '67000310', --Mieten Fahrzeuge
                    '67100100', --Leasing Gebude
                    '67100200', --Leasing Techn. Anlagen, Gerte, Maschine
                    '67100300', --Leasing and. Anlagen, Betriebs- / Gesch
                    '67100310', --Leasing Fahrzeuge
                    '90201000', --Kalkulatorische Bewirtschaftungskosten
                    '93000400', --Abrechnung Bewirtschaftungskosten
                    '96000403' --(N) Umlagen Bewirtschaftungskosten
                    );
                    --_SACHK_O_BEW=Sachkosten ohne Bewirtschaftungskosten
                    update tmp_vtbu set ziel_fikrkey='_SACHK_O_BEW' where vari in ('L') and ziel_fikrkey in (
                    '96000200', --Umlagen Sachkosten
                    --60000000 bis 60400000
                    '60000000', --Rohstoffe
                    '60000100', --Bestandsvernderung Vorrte
                    '60000200', --Aufw. Chemikalien / Gase / Organische Ma
                    '60000300', --Aufw. Holz / Kunststoff / Glas / Metalle
                    '60000400', --Aufw. Elektronikbauteile
                    '60100100', --Aufwendungen fr EDV-Material
                    '60100200', --Putz- und Pflegematerial
                    '60100300', --Aufw. Lebensmittel und Kantinenwaren
                    '60100900', --Sonstiges Verbrauchsmaterial
                    '60200000', --Hilfsstoffe
                    '60300000', --Betriebsstoffe
                    '60300100', --Aufw. Werkzeuge und Kleinbauteile
                    '60400000', --Verpackungsmaterial
                    --60620000 bis 61300150
                    '60620000', --Material Reparatur / Instandh. bew. Sach
                    '60700010', --Aufw. EDV-Gerte und -Komponenten
                    '60700090', --Aufw. Sonst. Einr. (o. EDV), Kleingerte
                    '60700100', --Aufw. Lehr- und Lernmaterial
                    '60700200', --Aufw. fr bezogene (Handels-)Waren
                    '60700900', --Sonstige Materialien
                    '60800000', --Dienst- und Schutzkleidung
                    '60800100', --Arbeits- und Betriebssicherheit
                    '60900000', --Sonderabschreibung auf Vorrte
                    '61200000', --Akkreditierungskosten
                    '61200100', --Evaluierungskosten
                    '61200200', --(Sachverstndigen-)Gutachten
                    '61200300', --Forschungs- und Entwicklungsauftrge
                    '61200400', --EDV-Fremddienstleistungen
                    '61300100', --Druck- und Kopierkosten (extern)
                    '61300150', --Aufw. fr Publikationen (Druckkostenzusc
                    --61300300 bis 61300900
                    '61300300', --Verlags- / Bibliotheksdienstleistungen
                    '61300400', --Aufw. Binden / Restaurieren Bcher / Sch
                    '61300600', --Umzugskosten (innerhalb Hochschule)
                    '61300900', --Sonstige Fremdleistungen
                    --61500000 bis 61620920
                    '61500000', --Frachtkosten
                    '61600010', --Fremdinst. Gebude und bauliche Anlagen
                    '61600020', --Wartung Gebude und bauliche Anlagen
                    '61610010', --Fremdinst. Sonst. unbew. Verm.
                    '61610020', --Wartung Sonst. unbew. Verm.
                    '61620010', --Fremdinst. Gerte / Ausstattung
                    '61620020', --Wartung Gerte / Ausstattung
                    '61620110', --Fremdinst. EDV-Gerte / EDV-Ausstattung
                    '61620120', --Wartung EDV-Gerte / EDV-Ausstattung
                    '61620210', --Fremdinst. Fernmeldeanlagen
                    '61620220', --Wartung Fernmeldeanlagen
                    '61620910', --Fremdinst. Sonst. Bew. Sachen
                    '61620920', --Wartung Sonst. Bew. Sachen
                    '61700900', --Sonstige Aufwendungen fr bezogene Leist
                    '61800000', --Aufwandsberichtigungen (Skonti, Boni,
                    --65000100 bis 65400000
                    '65000100', --Stellenausschreibung
                    '65100000', --Aufw. bernommene Fahrtkosten
                    '65100100', --Aufw. Umzugskosten / Trennungsgeld
                    '65100200', --Heimfahrten Azubis
                    '65200000', --Aufwendungen fr Betriebs- / Amtsarzt
                    '65200010', --Aufwendungen fr Arbeitssicherheit
                    '65400000', --Aufwendungen fr Aus-, Fort- und Weiterb
                    --65700900 bis 65900100
                    '65700900', --So. Aufw. ehren-, nebenamtlich, -berufli
                    '65900100', --Kosten fr ABM
                    '65900300', --Aufwand Dienstleistungen LBV
                    --67200000 bis 71250000
                    '67200000', --Lizenzen und Konzessionen
                    '67300000', --Gebhren der Technischen berwachung
                    '67300010', --Gebhren fr Patente
                    '67300020', --ffentlich-Rechtliche Gebhren
                    '67300090', --Sonstige Gebhren
                    '67500000', --Nebenkosten des Geldverkehrs
                    '67600000', --Provisionen
                    '67700000', --Gerichts- / Anwaltskosten
                    '67700100', --(Steuer-)Beratungskosten
                    '67700200', --Prfung / Erstellung JA
                    '67800000', --Aufwendungen fr Hochschulrat und dgl.
                    '67900000', --Sonst. Aufw. Inanspruchnahme von Rechten
                    '68000000', --Papier
                    '68000200', --Aufw. Bromaterial
                    '68100000', --Medien (10 Jahre)
                    '68100100', --Lehrbcher (4 Jahre)
                    '68100200', --Zeitungen, Zeitschriften (Periodika)
                    '68100300', --Fortsetzungen, Lieferungswerke
                    '68100400', --Elektronische Medien
                    '68100500', --Rara, Inkunablen, 
                    '68200000', --Porto, Versandkosten, Zustelldienste
                    '68300000', --Fernmeldegebhren
                    '68300100', --Kosten der Datenbertragung
                    '68300900', --Sonstige Kommunikationskosten
                    '68500000', --Wegstreckenentschdigungen / Dienstgnge
                    '68500100', --Dienstreisen Inland
                    '68500200', --Dienstreisen europisches Ausland
                    '68500300', --Dienstreisen auereuropisches Ausland
                    '68500400', --Reisen Gastwissenschaftler, Honorarkrft
                    '68600000', --Bewirtungskosten
                    '68600200', --Reprsentationskosten
                    '68600800', --ffentlichkeitsarbeit und Werbung
                    '68610000', --Aufw. Verfgungsmittel
                    '68900900', --Sonstige schliche Kosten
                    '69000000', --Gebudeversicherungen
                    '69010000', --Sonstige Versicherungen
                    '69100000', --Mitgliedsbeitrge Inland
                    '69110000', --Mitgliedsbeitrge Ausland
                    '69200000', --Schadensersatzleistungen, Leist. aus Br
                    '69301000', --Aufwendungen aus Forderungsverzicht
                    '69302000', --Kassenfehlbetrge
                    '69305100', --Aufwand aus Inventurdifferenzen (MM)
                    '69305200', --Aufwand aus Umbewertungen (MM)
                    '69305300', --Aufwand aus Zahlungsdifferenzen
                    '69305400', --Aufwand aus Kursdifferenzen
                    '69305500', --Aufwand aus Rundungsdifferenzen
                    '69309000', --Sonst. betr. Aufw.
                    '69309001', --Aufwand Projektpauschale
                    '69500000', --Verluste aus dem Abgang von Vorrten
                    '69600000', --Verluste aus dem Abgang von Vermgensgeg
                    '69600001', --Verluste aus Abgang von Vermgensgegenst
                    '69700000', --Einstellungen Sonderposten mit Rcklagen
                    '69700100', --Aufwand aus Zufhrung Sonderposten Bund
                    '69700200', --Aufwand aus Zufhrung Sonderposten Land
                    '69700400', --Aufwand aus Zufhrung Sonderposten ffen
                    '69700500', --Aufwand aus Zufhrung SoPo nicht ffentl
                    '69700600', --Aufwand aus Zufhrung Sonderposten DFG
                    '69700700', --Aufwand aus Zufhrung SoPo Schenkung/Sac
                    '69703000', --Aufwand aus Zufhrung Sonderposten ander
                    '69800000', --Zufhrung Rckstellungen
                    '69900000', --Periodenfremde Aufwendungen
                    '70200000', --Grundsteuer
                    '70300000', --Kfz-Steuer
                    '70700000', --Umsatzsteuer aus unentgeltlicher Wertabg
                    '70900100', --Ein- und Ausfuhrzlle
                    '70900900', --Sonst. betr. Steuern, steuerhnl. Aufw.
                    '71100000', --Allgemeine Zuweisungen an Sondervermgen
                    '71250000', --Weitere sonstige Zuschsse laufende Zwec
                    --71700090 bis 73100900
                    '71700090', --Kostenerstattungen an Sonstige im Inland
                    '73000100', --Stipendien Studierende - Inlnder
                    '73000110', --Stipendien Doktoranden - Inlnder
                    '73000120', --Stipendien Post-Doktoranden - Inlnder
                    '73000190', --Sonstige Stipendienaufw. - Inlnder
                    '73000200', --Stipendien Studierende - Auslnder
                    '73000210', --Stipendien Doktoranden - Auslnder
                    '73000220', --Stipendien Post-Doktoranden - Auslnder
                    '73000290', --Sonstige Stipendienaufw. - Auslnder
                    '73000400', --Spenden, Preisgelder, Ehrungen
                    '73100010', --Exkursionen Studierende - Inland
                    '73100020', --Exkursionen Studierende - Ausland
                    '73100100', --Sonstige Zuwendungen fr Studierende
                    '73100900', --Weitere Leistungen an Dritte
                    --74500000 bis 79700100
                    '74500000', --Verluste aus dem Abgang von Finanzanlage
                    '75110000', --Zinsen am inlndischen Kreditmarkt
                    '75900000', --Sonstige Zinsen und hnliche Aufwendunge
                    '77000000', --Gewerbeertragsteuer
                    '77100000', --Krperschaftsteuer
                    '77200000', --Kapitalertragsteuer
                    '77300000', --Auslndische Quellensteuer
                    '77990000', --Sonstige Steuern
                    '79100000', --Auerordentliche Aufwendungen
                    '79670000', --Aufw. aus der Zufhrung zu Fonds und St
                    '79690000', --Aufw. aus der Zufhrung zu Rcklagen
                    '79700000', --Rckzahlungen von Zuweisungen und Zusch
                    '79700100', --Rckzahlungen von Investitionszuschssen
                    '93000200', --Abrechnung Sachkosten
                    '96000203' --(N) Umlagen Sachkosten
                    );
                    --_ABSCHR=Abschreibungen
                    update tmp_vtbu set ziel_fikrkey='_ABSCHR' where vari in ('L') and ziel_fikrkey in (
                    '96000300', --Umlagen Abschreibungen
                    '93000300', --Abrechnung Abschreibungen
                    --66100000 bis 66800000
                    '66100000', --Planmige Abschreibungen immaterielle V
                    '66200000', --Abschreibungen auf Gebude, Gebudeeinri
                    '66310000', --Planm. Abschr. Techn. Anlagen / Maschine
                    '66390000', --Planm. Abschr. GWG Techn. Anlagen / Masc
                    '66400000', --Abschreibungen Medienbestand
                    '66410000', --Abschreibungen andere Anlagen, BuGA
                    '66490000', --Abschreibungen GWG andere Anlagen, BuGA
                    '66500010', --Auerplanm. Abschreibungen Immat. VG
                    '66500020', --Auerplanm. Abschreibungen Gebude
                    '66500030', --Auerplanm. Abschreibungen Techn. Anl.
                    '66500040', --Auerplanm. Abschreibungen BuGA
                    '66500050', --Auerplanm. AfA FinA
                    '66800000', --Unbliche Abschr. Vorrte, Ford. und son
                    '96000303', --(N) Umlagen Abschreibungen
                    '74000000' --Abschreibungen auf Finanzanlagen
                    );
                    --_KALK_MIETE=Kalkulatorische Mieten
                    update tmp_vtbu set ziel_fikrkey='_KALK_MIETE' where vari in ('L') and ziel_fikrkey in (
                    '90200001', --Kalkulatorische Flchenkosten
                    '93000500', --Abrechnung Kalk. Mieten
                    '96000500', --Umlagen Kalkulatorische Mieten
                    '96000503' --(N) Umlagen Kalkulatorische Mieten
                    );
                </#if>
                <#if "Sekundrkostenartenblcke bei KT Lehre angebotsorientiert (vari A, Verrechnungsschema W4)"!="">
                --_PERS_W=Personalkosten wissenschaftlicher Dienst
                update tmp_vtbu set ziel_fikrkey='_PERS_W' where vari in ('A') and ziel_fikrkey in (
                    '96000100', --Umlagen Pers.kosten Wiss. Dienst
                    --65700100 bis 65700150
                    '65700100', --Wissenschaftliche Hilfskrfte MA
                    '65700150', --Wissenschaftliche Hilfskrfte BA
                    '93000100', --Abrechnung Personalkosten Wiss.D.
                    --61300200 bis 61300230
                    '61300200', --Werkvertrge, Leiharbeitskrfte
                    '61300210', --Lehrauftrge (ber Zeitraum)
                    '61300220', --Gastprofessoren (Werkvertrag)
                    '61300230', --Gastvortrge (einmalig)
                    '96000104', --(A) Umlagen Pers.kosten Wiss. Dienst
                    '71700000', --Kostenerstattungen Stiftungsprofessuren
                    '90606100', --PSK WISS. DIENST E 13
                    '90604100', --PSK HH. DIENST (A)
                    '90605100' --PSK HH. DIENST (B)
                );
                --_PERS_NW=Personalkosten nichtwissenschaftlicher Dienst
                update tmp_vtbu set ziel_fikrkey='_PERS_NW' where vari in ('A') and ziel_fikrkey in (
                    '65700200', --Stud. Hilfskrfte
                    '62500000', --Entgelte Auszubildende
                    '62300000', --bergangsgelder / Abfindungen
                    '65000000', --Aufwendungen fr Personalmanahmen
                    '96000150', --Umlagen Pers.kosten nicht-Wiss. Dienst
                    '65700000', --Praktikanten
                    '65900900', --brige sonstige Personalaufwendungen
                    '90601100', --PSK EINFACHER DIENST
                    '90602100', --PSK MITTLERER DIENST
                    '90603100', --PSK GEHOBENER DIENST
                    '93000150', --Abrechnung Personalkosten Sonstige
                    '96000154' --(A) Umlagen Pers.kosten nicht-WD
                );
                --_SACHK_BEW=Bewirtschaftungskosten
                update tmp_vtbu set ziel_fikrkey='_SACHK_BEW' where vari in ('A') and ziel_fikrkey in (
                    '96000400', --Umlagen Bewirtschaftungskosten
                    --60500000 bis 60610000
                    '60500000', --Strom
                    '60500100', --(Fern-)Wrme und Klte
                    '60500110', --Aufw. Heizl
                    '60500200', --Wasser und Abwasser
                    '60500300', --Treibstoffe und Schmierstoffe (Benzin, M
                        '60500900', --Sonstige Energiekosten
                        '60600000', --Material Reparatur / Instandh. Geb. / ba
                        '60610000', --Material Reparatur / Instandh. unbew. Ve
                        --61400000 bis 61400900
                        '61400000', --Abfall und Entsorgung
                        '61400900', --Sonstige Entsorgungskosten
                        --61700000 bis 61700500
                        '61700000', --Aufw. Fremdreinigungskosten
                        '61700100', --Aufw. Ungezieferbekmpfung
                        '61700200', --Aufw. Haus-/Gelndebewachung/-sicherung
                        '61700500', --Gartenpflege und Winterdienst
                        --67000000 bis 67100310
                        '67000000', --Pachten, Erbbauzinsen und Nebenkosten
                        '67000010', --Grundbesitzabgaben
                        '67000100', --Mieten Gebude (langfristige Anmietung)
                        '67000150', --Mieten Rume (kurzfristige Anmietung)
                        '67000200', --Mieten Techn. Anlagen, Gerte, Maschinen
                        '67000300', --Mieten and. Anlagen, Betriebs- / Geschf
                        '67000310', --Mieten Fahrzeuge
                        '67100100', --Leasing Gebude
                        '67100200', --Leasing Techn. Anlagen, Gerte, Maschine
                        '67100300', --Leasing and. Anlagen, Betriebs- / Gesch
                        '67100310', --Leasing Fahrzeuge
                        '90201000', --Kalkulatorische Bewirtschaftungskosten
                        '93000400', --Abrechnung Bewirtschaftungskosten
                        '96000404' --(A) Umlagen Bewirtschaftungskosten
                    );
                    --_SACHK_O_BEW=Sachkosten ohne Bewirtschaftungskosten
                    update tmp_vtbu set ziel_fikrkey='_SACHK_O_BEW' where vari in ('A') and ziel_fikrkey in (
                        '96000200', --Umlagen Sachkosten
                        --60000000 bis 60400000
                        '60000000', --Rohstoffe
                        '60000100', --Bestandsvernderung Vorrte
                        '60000200', --Aufw. Chemikalien / Gase / Organische Ma
                        '60000300', --Aufw. Holz / Kunststoff / Glas / Metalle
                        '60000400', --Aufw. Elektronikbauteile
                        '60100100', --Aufwendungen fr EDV-Material
                        '60100200', --Putz- und Pflegematerial
                        '60100300', --Aufw. Lebensmittel und Kantinenwaren
                        '60100900', --Sonstiges Verbrauchsmaterial
                        '60200000', --Hilfsstoffe
                        '60300000', --Betriebsstoffe
                        '60300100', --Aufw. Werkzeuge und Kleinbauteile
                        '60400000', --Verpackungsmaterial
                        --60620000 bis 61300150
                        '60620000', --Material Reparatur / Instandh. bew. Sach
                        '60700010', --Aufw. EDV-Gerte und -Komponenten
                        '60700090', --Aufw. Sonst. Einr. (o. EDV), Kleingerte
                        '60700100', --Aufw. Lehr- und Lernmaterial
                        '60700200', --Aufw. fr bezogene (Handels-)Waren
                        '60700900', --Sonstige Materialien
                        '60800000', --Dienst- und Schutzkleidung
                        '60800100', --Arbeits- und Betriebssicherheit
                        '60900000', --Sonderabschreibung auf Vorrte
                        '61200000', --Akkreditierungskosten
                        '61200100', --Evaluierungskosten
                        '61200200', --(Sachverstndigen-)Gutachten
                        '61200300', --Forschungs- und Entwicklungsauftrge
                        '61200400', --EDV-Fremddienstleistungen
                        '61300100', --Druck- und Kopierkosten (extern)
                        '61300150', --Aufw. fr Publikationen (Druckkostenzusc
                            --61300300 bis 61300900
                            '61300300', --Verlags- / Bibliotheksdienstleistungen
                            '61300400', --Aufw. Binden / Restaurieren Bcher / Sch
                            '61300600', --Umzugskosten (innerhalb Hochschule)
                            '61300900', --Sonstige Fremdleistungen
                            --61500000 bis 61620920
                            '61500000', --Frachtkosten
                            '61600010', --Fremdinst. Gebude und bauliche Anlagen
                            '61600020', --Wartung Gebude und bauliche Anlagen
                            '61610010', --Fremdinst. Sonst. unbew. Verm.
                            '61610020', --Wartung Sonst. unbew. Verm.
                            '61620010', --Fremdinst. Gerte / Ausstattung
                            '61620020', --Wartung Gerte / Ausstattung
                            '61620110', --Fremdinst. EDV-Gerte / EDV-Ausstattung
                            '61620120', --Wartung EDV-Gerte / EDV-Ausstattung
                            '61620210', --Fremdinst. Fernmeldeanlagen
                            '61620220', --Wartung Fernmeldeanlagen
                            '61620910', --Fremdinst. Sonst. Bew. Sachen
                            '61620920', --Wartung Sonst. Bew. Sachen
                            '61700900', --Sonstige Aufwendungen fr bezogene Leist
                            '61800000', --Aufwandsberichtigungen (Skonti, Boni,
                                --65000100 bis 65400000
                                '65000100', --Stellenausschreibung
                                '65100000', --Aufw. bernommene Fahrtkosten
                                '65100100', --Aufw. Umzugskosten / Trennungsgeld
                                '65100200', --Heimfahrten Azubis
                                '65200000', --Aufwendungen fr Betriebs- / Amtsarzt
                                '65200010', --Aufwendungen fr Arbeitssicherheit
                                '65400000', --Aufwendungen fr Aus-, Fort- und Weiterb
                                --65700900 bis 65900100
                                '65700900', --So. Aufw. ehren-, nebenamtlich, -berufli
                                '65900100', --Kosten fr ABM
                                '65900300', --Aufwand Dienstleistungen LBV
                                --67200000 bis 71250000
                                '67200000', --Lizenzen und Konzessionen
                                '67300000', --Gebhren der Technischen berwachung
                                '67300010', --Gebhren fr Patente
                                '67300020', --ffentlich-Rechtliche Gebhren
                                '67300090', --Sonstige Gebhren
                                '67500000', --Nebenkosten des Geldverkehrs
                                '67600000', --Provisionen
                                '67700000', --Gerichts- / Anwaltskosten
                                '67700100', --(Steuer-)Beratungskosten
                                '67700200', --Prfung / Erstellung JA
                                '67800000', --Aufwendungen fr Hochschulrat und dgl.
                                '67900000', --Sonst. Aufw. Inanspruchnahme von Rechten
                                '68000000', --Papier
                                '68000200', --Aufw. Bromaterial
                                '68100000', --Medien (10 Jahre)
                                '68100100', --Lehrbcher (4 Jahre)
                                '68100200', --Zeitungen, Zeitschriften (Periodika)
                                '68100300', --Fortsetzungen, Lieferungswerke
                                '68100400', --Elektronische Medien
                                '68100500', --Rara, Inkunablen,
                                '68200000', --Porto, Versandkosten, Zustelldienste
                                '68300000', --Fernmeldegebhren
                                '68300100', --Kosten der Datenbertragung
                                '68300900', --Sonstige Kommunikationskosten
                                '68500000', --Wegstreckenentschdigungen / Dienstgnge
                                '68500100', --Dienstreisen Inland
                                '68500200', --Dienstreisen europisches Ausland
                                '68500300', --Dienstreisen auereuropisches Ausland
                                '68500400', --Reisen Gastwissenschaftler, Honorarkrft
                                '68600000', --Bewirtungskosten
                                '68600200', --Reprsentationskosten
                                '68600800', --ffentlichkeitsarbeit und Werbung
                                '68610000', --Aufw. Verfgungsmittel
                                '68900900', --Sonstige schliche Kosten
                                '69000000', --Gebudeversicherungen
                                '69010000', --Sonstige Versicherungen
                                '69100000', --Mitgliedsbeitrge Inland
                                '69110000', --Mitgliedsbeitrge Ausland
                                '69200000', --Schadensersatzleistungen, Leist. aus Br
                                '69301000', --Aufwendungen aus Forderungsverzicht
                                '69302000', --Kassenfehlbetrge
                                '69305100', --Aufwand aus Inventurdifferenzen (MM)
                                '69305200', --Aufwand aus Umbewertungen (MM)
                                '69305300', --Aufwand aus Zahlungsdifferenzen
                                '69305400', --Aufwand aus Kursdifferenzen
                                '69305500', --Aufwand aus Rundungsdifferenzen
                                '69309000', --Sonst. betr. Aufw.
                                '69309001', --Aufwand Projektpauschale
                                '69500000', --Verluste aus dem Abgang von Vorrten
                                '69600000', --Verluste aus dem Abgang von Vermgensgeg
                                '69600001', --Verluste aus Abgang von Vermgensgegenst
                                '69700000', --Einstellungen Sonderposten mit Rcklagen
                                '69700100', --Aufwand aus Zufhrung Sonderposten Bund
                                '69700200', --Aufwand aus Zufhrung Sonderposten Land
                                '69700400', --Aufwand aus Zufhrung Sonderposten ffen
                                '69700500', --Aufwand aus Zufhrung SoPo nicht ffentl
                                '69700600', --Aufwand aus Zufhrung Sonderposten DFG
                                '69700700', --Aufwand aus Zufhrung SoPo Schenkung/Sac
                                '69703000', --Aufwand aus Zufhrung Sonderposten ander
                                '69800000', --Zufhrung Rckstellungen
                                '69900000', --Periodenfremde Aufwendungen
                                '70200000', --Grundsteuer
                                '70300000', --Kfz-Steuer
                                '70700000', --Umsatzsteuer aus unentgeltlicher Wertabg
                                '70900100', --Ein- und Ausfuhrzlle
                                '70900900', --Sonst. betr. Steuern, steuerhnl. Aufw.
                                '71100000', --Allgemeine Zuweisungen an Sondervermgen
                                '71250000', --Weitere sonstige Zuschsse laufende Zwec
                                --71700090 bis 73100900
                                '71700090', --Kostenerstattungen an Sonstige im Inland
                                '73000100', --Stipendien Studierende - Inlnder
                                '73000110', --Stipendien Doktoranden - Inlnder
                                '73000120', --Stipendien Post-Doktoranden - Inlnder
                                '73000190', --Sonstige Stipendienaufw. - Inlnder
                                '73000200', --Stipendien Studierende - Auslnder
                                '73000210', --Stipendien Doktoranden - Auslnder
                                '73000220', --Stipendien Post-Doktoranden - Auslnder
                                '73000290', --Sonstige Stipendienaufw. - Auslnder
                                '73000400', --Spenden, Preisgelder, Ehrungen
                                '73100010', --Exkursionen Studierende - Inland
                                '73100020', --Exkursionen Studierende - Ausland
                                '73100100', --Sonstige Zuwendungen fr Studierende
                                '73100900', --Weitere Leistungen an Dritte
                                --74500000 bis 79700100
                                '74500000', --Verluste aus dem Abgang von Finanzanlage
                                '75110000', --Zinsen am inlndischen Kreditmarkt
                                '75900000', --Sonstige Zinsen und hnliche Aufwendunge
                                '77000000', --Gewerbeertragsteuer
                                '77100000', --Krperschaftsteuer
                                '77200000', --Kapitalertragsteuer
                                '77300000', --Auslndische Quellensteuer
                                '77990000', --Sonstige Steuern
                                '79100000', --Auerordentliche Aufwendungen
                                '79670000', --Aufw. aus der Zufhrung zu Fonds und St
                                '79690000', --Aufw. aus der Zufhrung zu Rcklagen
                                '79700000', --Rckzahlungen von Zuweisungen und Zusch
                                '79700100', --Rckzahlungen von Investitionszuschssen
                                '93000200', --Abrechnung Sachkosten
                                '96000204' --(A) Umlagen Sachkosten
                            );
                            --_ABSCHR=Abschreibungen
                            update tmp_vtbu set ziel_fikrkey='_ABSCHR' where vari in ('A') and ziel_fikrkey in (
                                '96000300', --Umlagen Abschreibungen
                                '93000300', --Abrechnung Abschreibungen
                                '96000304', --(A) Umlagen Abschreibungen
                                --66100000 bis 66800000
                                '66100000', --Planmige Abschreibungen immaterielle V
                                '66200000', --Abschreibungen auf Gebude, Gebudeeinri
                                '66310000', --Planm. Abschr. Techn. Anlagen / Maschine
                                '66390000', --Planm. Abschr. GWG Techn. Anlagen / Masc
                                '66400000', --Abschreibungen Medienbestand
                                '66410000', --Abschreibungen andere Anlagen, BuGA
                                '66490000', --Abschreibungen GWG andere Anlagen, BuGA
                                '66500010', --Auerplanm. Abschreibungen Immat. VG
                                '66500020', --Auerplanm. Abschreibungen Gebude
                                '66500030', --Auerplanm. Abschreibungen Techn. Anl.
                                '66500040', --Auerplanm. Abschreibungen BuGA
                                '66500050', --Auerplanm. AfA FinA
                                '66800000', --Unbliche Abschr. Vorrte, Ford. und son
                                '74000000' --Abschreibungen auf Finanzanlagen
                            );
                            --_KALK_MIETE=Kalkulatorische Mieten
                            update tmp_vtbu set ziel_fikrkey='_KALK_MIETE' where vari in ('A') and ziel_fikrkey in (
                                '90200001', --Kalkulatorische Flchenkosten
                                '93000500', --Abrechnung Kalk. Mieten
                                '96000500', --Umlagen Kalkulatorische Mieten
                                '96000504' --(A) Umlagen Kalkulatorische Mieten
                            );
                            </#if>
                </#if>
                insert into kenn_vtbu_aggr (
                hs_nr,
                jahr,
                quartal,
                monat,
                quell_ch110_inst,
                quell_projnr,
                quell_stug,
                ziel_projnr,
                ziel_stug,
                ziel_fikrkey,
                kokl,
                klr_geldgeber,
                vari,
                datum,
                ziel_ch110_inst,
                betrag
	        )
	        select
                hs_nr,
                jahr,
                quartal,
                monat,
                quell_ch110_inst,
                quell_projnr,
                quell_stug,
                ziel_projnr,
                ziel_stug,
                ziel_fikrkey,
                kokl,
                klr_geldgeber,
                vari,
                datum,
                ziel_ch110_inst,
                sum(betrag) from tmp_vtbu
                group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;
	        drop table tmp_vtbu;



            </#if> -- ende Datenquelle GXSTAGE


            drop table tmp_quartal;
            drop table tmp_quartal2;


    </#if>
    
</#if>
