--freemarker template
<sqlvars>
<sqlvar name="k_stg_exists">
select sp_table_exists('k_stg') from xdummy
</sqlvar>
<sqlvar name="k_abint_exists">
select sp_table_exists('k_abint') from xdummy
</sqlvar> 
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
<sqlvar name="KENN_STUD_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_STUD_DATENQUELLE'
    </sqlvar>

</sqlvars>

select '${SQLdialect}' from xdummy;
delete from kenn_su_imp_stud where 0=
(select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');


delete from kenn_su_imp_stud
where sem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDG')
;

<#if cob_installed=1&&KENN_STUD_DATENQUELLE!=170>

create temp table tmp_su_imp_stud
  (
    hs_nr integer,
    lehreinheit char(10),
    k_extkotr char(10),
    sem integer,
    stgnr varchar(2),
    fsemnr integer,
    fachkey varchar(4),
    fachkeydbez varchar(25),
    stg_astat char(4),
    abslkey varchar(2),
    abslkeydbez varchar(25),
abschluss_astat char(2),
    kzfach varchar(1),
kz_fach_astat char(1),
    stufrm varchar(1),
    stufrmdbez varchar(25),
    kzfachdbez varchar(25),
    ffstgnr varchar(2),
    gruppierung varchar(4),
    ffgewicht float,
    stugkey char(20),
    vza float,
    ffges float,
    ffidr float,
    ff1_4 float,
    ffidrgfs float,
    ff1_4gfs float,
    ffidrgf2 float,
    ff1_4gf2 float,
    kpfges float,
    kpfidr float,
    kpf1_4 float,
    datum date
  ) ;



insert into tmp_su_imp_stud
(
       sem,
       stgnr,
       fsemnr,
       fachkey,
       fachkeydbez,
       abslkey,
       abslkeydbez,
       kzfach,
       stufrm,
       stufrmdbez,
       kzfachdbez,
       ffstgnr,
       gruppierung,
       stugkey,
       datum,
       ffgewicht,
       vza,
       ffges,
       ffidr,
       ff1_4,
       ffidrgfs,
       ff1_4gfs,
       ffidrgf2,
       ff1_4gf2,
       kpfges,
       kpfidr,
       kpf1_4
)
select sem,
       stgnr,
       fsemnr,
       fachkey,
       fachkeydbez,
       abslkey,
       abslkeydbez,
       kzfach,
       stufrm,
       stufrmdbez,
       kzfachdbez,
       ffstgnr,
       gruppierung,
       stugkey,
       today(),
       sum(ffgewicht),
       sum(vza),
       sum(ffges),
       sum(ffidr),
       sum(ff1_4),
       sum(ffidrgfs),
       sum(ff1_4gfs),
       sum(ffidrgf2),
       sum(ff1_4gf2),
       sum(kpfges),
       sum(kpfidr),
       sum(kpf1_4)
       FROM cob_su_imp_stud C
where C.sem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDG')

group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
;


update tmp_su_imp_stud set k_extkotr=(select k_extkotr from cob_stug C
where C.stug_key=tmp_su_imp_stud.stugkey);
update tmp_su_imp_stud set lehreinheit=(select key_lehreinh from cob_stug C
where C.stug_key=tmp_su_imp_stud.stugkey);



<#if k_stg_exists = 1>
 --Amtliche Fcher und Abschlsse
update tmp_su_imp_stud set stg_astat=(select min(astat) from k_stg K where K.refstg::char(4)=tmp_su_imp_stud.fachkey::char(4) and K.astat is not null);

--manche HSen pflegen die amtlichen Fcher in Abhngigkeit vom Abschluss:
update tmp_su_imp_stud set stg_astat=(select min(astat2) from k_abstgv K 
where K.stg::char(4)=tmp_su_imp_stud.fachkey::char(4) and K.abschl=tmp_su_imp_stud.abslkey and K.astat2 is not null)
where stg_astat is null;
update tmp_su_imp_stud set kz_fach_astat=(select astat from sos_k_kzfa K where K.apnr=tmp_su_imp_stud.kzfach);
update tmp_su_imp_stud set abschluss_astat=(select min(astat) from k_abint K where K.abint::char(2)=tmp_su_imp_stud.abslkey::char(2));

</#if>

insert into kenn_su_imp_stud
(
       sem,
       stgnr,
       fsemnr,
       fachkey,
       fachkeydbez,
       abslkey,
       abslkeydbez,
       kzfach,
       stufrm,
       stufrmdbez,
       kzfachdbez,
       ffstgnr,
       gruppierung,
       stugkey,
       k_extkotr,
       lehreinheit,
       datum,
       ffgewicht,
       vza,
       ffges,
       ffidr,
       ff1_4,
       ffidrgfs,
       ff1_4gfs,
       ffidrgf2,
       ff1_4gf2,
       kpfges,
       kpfidr,
       kpf1_4
)
select sem,
       stgnr,
       fsemnr,
       stg_astat,
       fachkeydbez,
       abschluss_astat,
       abslkeydbez,
       kz_fach_astat,
       stufrm,
       stufrmdbez,
       kzfachdbez,
       ffstgnr,
       gruppierung,
       stugkey,
      k_extkotr,
       lehreinheit,
       datum,
       ffgewicht,
       vza,
       ffges,
       ffidr,
       ff1_4,
       ffidrgfs,
       ff1_4gfs,
       ffidrgf2,
       ff1_4gf2,
       kpfges,
       kpfidr,
       kpf1_4
       FROM tmp_su_imp_stud
;

 

drop table tmp_su_imp_stud;

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'cob_stug'::char(18),'Externer Kostentrger von Studiengang ' || trim(stugkey) || ' ist nicht definiert !'::char(200), 'Warnung'::char(10) 
from kenn_su_imp_stud 
where k_extkotr is null;  


insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'cob_stug'::char(18),'Lehreinheit von Studiengang ' || trim(stugkey) || ' ist nicht definiert !'::char(200), 'Warnung'::char(10) 
from kenn_su_imp_stud 
where lehreinheit is null; 

</#if>

<#if KENN_STUD_DATENQUELLE=170>
-- todo nachtragen von extkotr amtl. Schlssel ntig?, group by oder hat das schon webservice gemacht
insert into kenn_su_imp_stud (
hs_nr,
       lehreinheit,
       k_extkotr,
       sem,
       stgnr,
       fsemnr,
       fachkey,
       fachkeydbez,
       abslkey,
       abslkeydbez,
       kzfach,
       stufrm,
       stufrmdbez,
       kzfachdbez,
       ffstgnr,
       gruppierung,
       ffgewicht,
       stugkey,
       vza,
       ffges,
       ffidr,
       ff1_4,
       ffidrgfs,
       ff1_4gfs,
       ffidrgf2,
       ff1_4gf2,
       kpfges,
       kpfidr,
       kpf1_4,
       datum)
SELECT hs_nr,
       lehreinheit,
       k_extkotr,
       sem,
       stgnr,
       fsemnr,
       fachkey,
       fachkeydbez,
       abslkey,
       abslkeydbez,
       kzfach,
       stufrm,
       stufrmdbez,
       kzfachdbez,
       ffstgnr,
       gruppierung,
       ffgewicht,
       stugkey,
       vza,
       ffges,
       ffidr,
       ff1_4,
       ffidrgfs,
       ff1_4gfs,
       ffidrgf2,
       ff1_4gf2,
       kpfges,
       kpfidr,
       kpf1_4,
       datum
FROM gxstage_su_imp_stud
where sem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDG')

--group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
;

</#if>



update kenn_su_imp_stud set hs_nr=(select hs_nr from hochschulinfo);
update kenn_su_imp_stud set  fachkey='0'||fachkey
where length(fachkey) =3;
