--freemarker template
<sqlvars>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
<sqlvar name="KENN_KOSTEN_DATENQUELLE">
select apnr from konstanten where beschreibung ='KENN_KOSTEN_DATENQUELLE'
</sqlvar>
<sqlvar name="semester" type="hashsequence"> select bezugszeit from kenn_stichtag K where K.berechnen='1' and K.stichtagsart_id='STPLKLR'</sqlvar>
</sqlvars>
select '${SQLdialect}' from xdummy;

delete from kenn_stupl where 0=
(select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');

create temp table tmp_stupl(
	hs_nr INTEGER , 
stug_key CHAR(12), 
stug_rstuz SMALLINT , 
jahr INTEGER , 
sem INTEGER , 
extkotr CHAR(30) , 
datum DATE , 
summe INTEGER 
) 
;
delete from kenn_stupl
where sem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STPLKLR')
;

<#if cob_installed=1&&KENN_KOSTEN_DATENQUELLE!=170 && TableFieldExists?exists && TableFieldExists('cob_stupl','sem')>

insert into tmp_stupl
(
 
       stug_key,
       stug_rstuz,
--       jahr,
       sem,
       extkotr,
       datum,
       summe
)
select 
       C.stug_key,
       G.stug_rstuz,
--       jahr,
C.sem,
G.k_extkotr,
       today(),
       sum(C.stug_plaetze)
       FROM cob_stupl C left outer join cob_stug G
on ( G.stug_key=C.stug_key)
where C.sem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STPLKLR')
group by 1,2,3,4,5
;

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'cob_stupl'::char(18),'Studiengang ' || trim(stug_key) || ' hat keine RSZ in cob_stug !'::char(200), 'Warnung'::char(10) 
from tmp_stupl 
where stug_rstuz is null;  
</#if>

<#if KENN_KOSTEN_DATENQUELLE=170>
<#foreach sem in semester>
insert into tmp_stupl
(
 
       stug_key,
       stug_rstuz,
--       jahr,
       sem,
       extkotr,
       datum,
       summe
)
select 
       stug_key,
       stug_rstuz,
--       jahr,
       ${sem.bezugszeit},
       k_extkotr,
       today(),
       sum(stug_plaetze)
       FROM gxstage_stug
group by 1,2,3,4,5;
</#foreach>
insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'gxstage_stug'::char(18),'Studiengang ' || trim(stug_key) || ' hat keine RSZ in gxstage_stug !'::char(200), 'Warnung'::char(10) 
from tmp_stupl 
where stug_rstuz is null;

</#if>
update tmp_stupl set hs_nr=(select hs_nr from hochschulinfo);
insert into kenn_stupl(hs_nr,
       stug_key,
       stug_rstuz,
       jahr,
       sem,
       extkotr,
       datum,
       summe
)
SELECT hs_nr,
       stug_key,
       stug_rstuz,
       jahr,
       sem,
       extkotr,
       datum,
       summe
FROM tmp_stupl;

drop table tmp_stupl;

