--freemarker template
--(c) 2008 Daniel Quathamer



<sqlvars>

<sqlvar name="katalog">
SELECT F.name,
       B.keyfieldtype,
       B.tid::varchar(255)
from sx_fields F, dimension D, dimension_bp B
 where D.fact_table ='kenn_stg_cube'
 and D.fact_table=F.table_name
 and F.name != 'summe'
 and F.name=D.name
 and B.tid=D.dimension_bp_id
 order by 1
;
</sqlvar>
</sqlvars>



<#assign KENN_start_stg_cube=19001 />

--Konstante abfragen hat hchste Prioritt 

<#if K_KENN_start_stg_cube?exists && K_KENN_start_stg_cube?string?length &gt; 0>
<#assign KENN_start_stg_cube=K_KENN_start_stg_cube />
</#if>

-- Discard temp resources
-- discard temp;
-- discard plans;

select 'Startsemester ${KENN_start_stg_cube} '::char(30) from xdummy;

create temp table tmp_kenn_stg(
hs_nr INTEGER , 
studiengang_nr integer , 
fach_nr integer , 
geschlecht integer , 
ca12_staat integer , 
sem_rueck_beur_ein integer , 
stg_astat CHAR(10) , 
stg_astat_int integer,
abschluss_astat CHAR(10) , 
abschluss_astat_int INTEGER , 
rsz integer , 
hzbart integer , 
kz_rueck_beur_ein integer , 
fach_sem_zahl integer , 
hssem integer , 
kz_fach_astat CHAR(10) , 
kz_fach_astat_int INTEGER , 
extkotr CHAR(30) , 
extkotr_int INTEGER , 
stufrm_astat CHAR(10) ,
stufrm_astat_int INTEGER , 
summe INTEGER 
) 
;
create temp table tmp_kenn_stg_cube(
	hs_nr INTEGER , 
ca12_staat INTEGER , 
geschlecht INTEGER , 
hzbart INTEGER , 
studiengang_nr INTEGER , 
fach_nr INTEGER , 
fach_sem_zahl INTEGER , 
sem_rueck_beur_ein INTEGER , 
kz_rueck_beur_ein INTEGER , 
hssem INTEGER , 
stufrm_astat INTEGER , 
stg_astat INTEGER , 
kz_fach_astat INTEGER , 
abschluss_astat INTEGER , 
rsz INTEGER , 
extkotr INTEGER , 
summe decimal(16,2) 
) 
;
   
insert into tmp_kenn_stg(
hs_nr,
       ca12_staat,
       geschlecht,
       hzbart,
       studiengang_nr,
       fach_nr,
       fach_sem_zahl,
       sem_rueck_beur_ein,
       kz_rueck_beur_ein,
       hssem,
       stufrm_astat,
       stg_astat,
       kz_fach_astat,
       abschluss_astat,
       rsz,
       extkotr,
       summe)
select  hs_nr,
       ca12_staat,
       geschlecht,
       hzbart,
       studiengang_nr,
       fach_nr,
       fach_sem_zahl,
       sem_rueck_beur_ein,
       kz_rueck_beur_ein,
       hssem,
       stufrm,
       stg,
       kz_fach,
       abschluss,
       regel,
       extkotr,
       sum(summe)
       from kenn_sos_stg S
       where S.sem_rueck_beur_ein>=${KENN_start_stg_cube}
       group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
      ;
--Umschlsselung:
--kenn_sos_stg: in der RSZ (0=nein, 1=ja,-1=unbekannt)
--kenn_stg_cube: 99 = in der Regelstudienzeit, 100 = ber die RSZ, 3 unbekannt
update tmp_kenn_stg set rsz=99 where rsz=1;
update tmp_kenn_stg set rsz=100 where rsz=0;
update tmp_kenn_stg set rsz=3 where (rsz=-1 or rsz is null);

--Umschlsselung der Schlssel zu ICE-Schlsseln:

<#if katalog?has_content >

<#foreach merkmal in katalog>
--
select 'Merkmal ${merkmal.key}, Typ ${merkmal.name}, Blueprint id ${merkmal.strukturStr} '::varchar(255) from xdummy;

<#if merkmal.name?lower_case?index_of('char') != -1 >
update tmp_kenn_stg set ${merkmal.key}_int = (
select apnr from trans_dim_bp_apnr T
where T.sourcesystem_id=tmp_kenn_stg.${merkmal.key}::varchar(255)
and T.dimension_bp_id=${merkmal.strukturStr}
);
update tmp_kenn_stg set ${merkmal.key}_int = 99998 where ${merkmal.key}_int is null; 
<#else>
update tmp_kenn_stg set ${merkmal.key} = (
case
when ${merkmal.key} is null then 99998
else (
select apnr from trans_dim_bp_apnr T
where T.sourcesystem_id=tmp_kenn_stg.${merkmal.key}::varchar(255)
and T.dimension_bp_id=${merkmal.strukturStr}
)
end);

</#if>

</#foreach>

</#if>
--Ende Umschlsselung 

insert into tmp_kenn_stg_cube
(hs_nr,
       ca12_staat,
       geschlecht,
       hzbart,
       studiengang_nr,
       fach_nr,
       fach_sem_zahl,
       sem_rueck_beur_ein,
       kz_rueck_beur_ein,
       hssem,
       stufrm_astat,
       stg_astat,
       kz_fach_astat,
       abschluss_astat,
       rsz,
       extkotr,
       summe)
select hs_nr,
       ca12_staat,
       geschlecht,
       hzbart,
       studiengang_nr,
       fach_nr,
       fach_sem_zahl,
       sem_rueck_beur_ein,
       kz_rueck_beur_ein,
       hssem,
       stufrm_astat_int,
       stg_astat_int,
       kz_fach_astat_int,
       abschluss_astat_int,
       rsz,
       extkotr_int,
       sum(summe)
       from tmp_kenn_stg
       group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16;
       
update tmp_kenn_stg_cube set ca12_staat=99998
where ca12_staat is null;
       
       
delete from kenn_stg_cube where sem_rueck_beur_ein >= ${KENN_start_stg_cube};

insert into kenn_stg_cube(
hs_nr,
       ca12_staat,
       geschlecht,
       hzbart,
       studiengang_nr,
       fach_nr,
       fach_sem_zahl,
       sem_rueck_beur_ein,
       kz_rueck_beur_ein,
       hssem,
       stufrm_astat,
       stg_astat,
       kz_fach_astat,
       abschluss_astat,
       rsz,
       extkotr,
       summe)
select 
hs_nr,
       ca12_staat,
       geschlecht,
       hzbart,
       studiengang_nr,
       fach_nr,
       fach_sem_zahl,
       sem_rueck_beur_ein,
       kz_rueck_beur_ein,
       hssem,
       stufrm_astat,
       stg_astat,
       kz_fach_astat,
       abschluss_astat,
       rsz,
       extkotr,
       summe
from tmp_kenn_stg_cube
;

select count(*) || ' Stze in kenn_stg_cube' from kenn_stg_cube;

drop table tmp_kenn_stg;
drop table tmp_kenn_stg_cube;
