
--Freemarker Template 

<sqlvars>
--landesspezifika ermitteln: 5='nrw',14='Sachsen',8 'BaWue'
<sqlvar name="bland_kuerzel">
select 746::integer as kuerzel from cif where key=659 and apnr=5 
union
select 751::integer from cif where key=659 and apnr=14 
union
select 750::integer from cif where key=659 and apnr=8
union
select 750::integer from xdummy where 0=(
select count(*) from cif where key=659 and apnr in (5,8,14)) 
;
</sqlvar>
<sqlvar name = "k_astat_studienfach_land_exists">
SELECT sp_table_exists('k_astat_studienfach_land') FROM xdummy;
</sqlvar>
<sqlvar name = "k_astat_abschluss3steller_land_exists">
SELECT sp_table_exists('k_astat_abschluss3steller_land') FROM xdummy;
</sqlvar>
<sqlvar name = "k_astat_staat_eu_exists">
SELECT sp_table_exists('k_astat_staat_eu') FROM xdummy;
</sqlvar>
<sqlvar name = "sos_staat_eu_exists">
SELECT sp_table_exists('sos_staat_eu') FROM xdummy;
</sqlvar>
<sqlvar name="abschlusstypen" type="hashsequence">
SELECT apnr,lang_3 as whereclause from kenn_cifx
where key=689
and apnr !='S' --sonstige wird unten als Joker genutzt
;
</sqlvar>
<sqlvar name = "ewr_staaten">
select lang_3 as ewr_staaten from kenn_cifx where key=691
and apnr='BA_EWR';
</sqlvar>
</sqlvars>

<#assign staat_eu_table_name="" />
<#if k_astat_staat_eu_exists==1>
	<#assign staat_eu_table_name="k_astat_staat_eu" />
<#elseif sos_staat_eu_exists==1>
	<#assign staat_eu_table_name="sos_staat_eu" />
</#if>

--(c) 2008 Daniel Quathamer
delete from kenn_stg_aggr_astat where 0=
(select apnr from konstanten where beschreibung ='KENN_STUDIUM_ARCHIV');

--zuerst bereinigen:es darf nur 2015er oder 2016er Lieferung geben.
--2016 hat Prioritt:
create temp table tmp_sem
(
semester integer,
format integer
);
insert into tmp_sem
select distinct semester,2015
from kenn_sos_astat_2015
where semester in(
select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDA'
);
insert into tmp_sem
select distinct semester,2016
from kenn_sos_astat
where semester in(
select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDA'
);

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_sos_astat'::char(18),'Semester '|| semester || ' liegt in 2015er und 2016er Format vor, 2015 wird gelscht', 'Info'::char(10) 
from kenn_sos_astat_2015
where semester in (
select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDA'
)
and semester in (select T.semester
from tmp_sem T
where T.format=2016) ;  


delete from kenn_sos_astat_2015
where semester in (
select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDA'
)
and semester in (select T.semester
from tmp_sem T
where T.format=2016);

drop table tmp_sem;


--Unplausible Werte korrigieren:
update  kenn_sos_astat set ef010=null where substring(ef010 from 1 for 1) not in ('0','1','2','3','4','5','6','7','8','9');


create temp table tmp_stg_aggr_astat(
	hs_nr INTEGER , 
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_rueck_beur_ein SMALLINT , 
stg_land CHAR(4) , 
stg CHAR(4) , 
sb char(19),
fgr char(10),
abschluss_astat_land char(10),
abschluss_astat_bund char(10),
abschlussart char(10),
abgrp char(255),
abschlusstyp char(10), --BaWue Gruppierung 2024
regel SMALLINT , 
kz_rueck_beur_ein SMALLINT , 
fach_sem_zahl SMALLINT , 
hssem SMALLINT , 
kz_fach CHAR(1) , 
stort CHAR(10) , 
stuart CHAR(10) , 
stufrm CHAR(10) , 
hzbart_astat CHAR(10) , 
hzbkfzkz CHAR(2) ,
hzb_staat integer,
hzb_staat_eu smallint,
hzb_staat_ewr smallint,
hrst CHAR(10) ,
letzte_pruefung_stort CHAR(10) , 
letzte_pruefung_staat SMALLINT , 
letzte_pruefung_abschluss CHAR(2) , 
letzte_pruefung_ergebnis SMALLINT , 
vorletzte_pruefung_stort CHAR(10) , 
vorletzte_pruefung_staat SMALLINT , 
vorletzte_pruefung_abschluss CHAR(2) , 
vorletzte_pruefung_ergebnis SMALLINT , 
datum date , 
summe INTEGER 
) 
;

--Bentigt werden in KENN BaWue 2017:
--Semester, 
-- Fachsemester, 
-- Abschlussart MA/BA/Non-Degree/Sonstige, 
-- HZB-Art, 
-- Staatsangehrigkeit,
-- Vorbildung Bachelor HS-Typ, 
-- Status

<#assign  studiengang_nr_fach_nr = [
  {"studiengang_nr":"1", "fach_nr":"1", "fach":"ef036","abschluss":"ef033u2","stufrm":"ef033u1", "regel":"ef035", "kz_rueck_beur_ein":"ef028", "fach_sem_zahl":"ef032","stuart":"ef030"},
  {"studiengang_nr":"1", "fach_nr":"2", "fach":"ef037","abschluss":"ef033u2","stufrm":"ef033u1", "regel":"ef035", "kz_rueck_beur_ein":"ef028", "fach_sem_zahl":"ef032","stuart":"ef030"},
  {"studiengang_nr":"1", "fach_nr":"3", "fach":"ef039","abschluss":"ef033u2","stufrm":"ef033u1", "regel":"ef035", "kz_rueck_beur_ein":"ef028", "fach_sem_zahl":"ef032","stuart":"ef030"},
  {"studiengang_nr":"2", "fach_nr":"1", "fach":"ef052","abschluss":"ef049u2","stufrm":"ef049u1", "regel":"ef051", "kz_rueck_beur_ein":"ef044", "fach_sem_zahl":"ef048","stuart":"ef046"},
  {"studiengang_nr":"2", "fach_nr":"2", "fach":"ef053","abschluss":"ef049u2","stufrm":"ef049u1", "regel":"ef051", "kz_rueck_beur_ein":"ef044", "fach_sem_zahl":"ef048","stuart":"ef046"},
  {"studiengang_nr":"2", "fach_nr":"3", "fach":"ef055","abschluss":"ef049u2","stufrm":"ef049u1", "regel":"ef051", "kz_rueck_beur_ein":"ef044", "fach_sem_zahl":"ef048","stuart":"ef046"}
  ] />

<#assign  studiengang_nr_fach_nr_2015 = [
  {"studiengang_nr":"1", "fach_nr":"1", "fach":"ef032","abschluss":"ef031u2","stufrm":"ef031u1", "regel":"null::char(1)", "kz_rueck_beur_ein":"ef026", "fach_sem_zahl":"ef030","stuart":"ef028"},
  {"studiengang_nr":"1", "fach_nr":"2", "fach":"ef034","abschluss":"ef031u2","stufrm":"ef031u1", "regel":"null::char(1)", "kz_rueck_beur_ein":"ef026", "fach_sem_zahl":"ef030","stuart":"ef028"},
  {"studiengang_nr":"1", "fach_nr":"3", "fach":"ef036","abschluss":"ef031u2","stufrm":"ef031u1", "regel":"null::char(1)", "kz_rueck_beur_ein":"ef026", "fach_sem_zahl":"ef030","stuart":"ef028"},
  {"studiengang_nr":"2", "fach_nr":"1", "fach":"ef047","abschluss":"ef046u2","stufrm":"ef046u1", "regel":"null::char(1)", "kz_rueck_beur_ein":"ef041", "fach_sem_zahl":"ef045","stuart":"ef043"},
  {"studiengang_nr":"2", "fach_nr":"2", "fach":"ef049","abschluss":"ef046u2","stufrm":"ef046u1", "regel":"null::char(1)", "kz_rueck_beur_ein":"ef041", "fach_sem_zahl":"ef045","stuart":"ef043"},
  {"studiengang_nr":"2", "fach_nr":"3", "fach":"ef050","abschluss":"ef046u2","stufrm":"ef046u1", "regel":"null::char(1)", "kz_rueck_beur_ein":"ef041", "fach_sem_zahl":"ef045","stuart":"ef043"}
  ] />
<#assign vorherige_pruefungen=[

{"art":"letzte", "pruefung_stort":"ef089", "pruefung_staat":"ef090", "pruefung_abschluss":"substring(ef091 from 2 for 2)", "pruefung_ergebnis":"ef097"},
{"art":"vorletzte", "pruefung_stort":"ef103", "pruefung_staat":"ef104", "pruefung_abschluss":"substring(ef105 from 2 for 2)", "pruefung_ergebnis":"ef111"}
 ] />

<#assign vorherige_pruefungen_2015=[

{"art":"letzte", "pruefung_stort":"null::char(1)", "pruefung_staat":"null::char(1)", "pruefung_abschluss":"ef091u2", "pruefung_ergebnis":"ef098"},
{"art":"vorletzte", "pruefung_stort":"null::char(1)", "pruefung_staat":"null::char(1)", "pruefung_abschluss":"ef100u2", "pruefung_ergebnis":"ef107"}
 ] />
  
<#foreach stgnr in studiengang_nr_fach_nr>
--${stgnr.studiengang_nr}. Studiengang, ${stgnr.fach_nr}. Fach:
insert into tmp_stg_aggr_astat(
hs_nr,
       studiengang_nr,
       fach_nr,
      geschlecht,
      ca12_staat,
       sem_rueck_beur_ein,
       stg_land,
       abschluss_astat_land,
      regel,
      kz_rueck_beur_ein,
      fach_sem_zahl,
      hssem,
     stort,
      stuart,
      stufrm,
       hzbart_astat,
       hzbkfzkz,
       hzb_staat,
       hrst,
<#if stgnr.studiengang_nr=="1" && stgnr.fach_nr=="1">
<#foreach vorherige_pruefung in vorherige_pruefungen>
${vorherige_pruefung.art}_pruefung_stort,
${vorherige_pruefung.art}_pruefung_staat,
${vorherige_pruefung.art}_pruefung_abschluss,
${vorherige_pruefung.art}_pruefung_ergebnis,
</#foreach>
</#if>
       datum,
       summe)
 select
 hs_nr,
${stgnr.studiengang_nr} as       studiengang_nr,
${stgnr.fach_nr} as       fach_nr,
val(ef007) as geschlecht,
val(ef010) as ca12_staat,
semester as       sem_rueck_beur_ein,
${stgnr.fach} as stg_land,
${stgnr.abschluss} as abschluss,
val(${stgnr.regel}) as regel,
val(${stgnr.kz_rueck_beur_ein}) as kz_rueck_beur_ein,
val(${stgnr.fach_sem_zahl}) as fach_sem_zahl,
val(ef021) as hssem,
ef004 as stort,
val(${stgnr.stuart}) as stuart,
${stgnr.stufrm} as stufrm,
ef118 as hzbart_astat,
ef119u1 as hzbkfzkz,
(case when ef119u1='99' then val(ef119u2) else 0 end) as hzb_staat,
ef014 as hrst,
<#if stgnr.studiengang_nr=="1" && stgnr.fach_nr=="1">
<#foreach vorherige_pruefung in vorherige_pruefungen>
${vorherige_pruefung.pruefung_stort},
val(${vorherige_pruefung.pruefung_staat}),
${vorherige_pruefung.pruefung_abschluss},
val(${vorherige_pruefung.pruefung_ergebnis}),
</#foreach>
</#if>
       today(),
       count(*) as summe
FROM kenn_sos_astat 
where ${stgnr.abschluss} is not null
and ${stgnr.fach} is not null
and semester in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDA')
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20
<#if stgnr.studiengang_nr=="1" && stgnr.fach_nr=="1">
,21,22,23,24,25,26,27,28
</#if>
 ;

</#foreach>
--nun 2015, wenn vorhanden:
<#foreach stgnr in studiengang_nr_fach_nr_2015>
--${stgnr.studiengang_nr}. Studiengang, ${stgnr.fach_nr}. Fach:
insert into tmp_stg_aggr_astat(
hs_nr,
       studiengang_nr,
       fach_nr,
      geschlecht,
      ca12_staat,
       sem_rueck_beur_ein,
       stg_land,
       abschluss_astat_land,
      regel,
      kz_rueck_beur_ein,
      fach_sem_zahl,
      hssem,
     stort,
      stuart,
      stufrm,
       hzbart_astat,
       hzbkfzkz,
       hzb_staat,
       hrst,
<#if stgnr.studiengang_nr=="1" && stgnr.fach_nr=="1">
<#foreach vorherige_pruefung in vorherige_pruefungen_2015>
${vorherige_pruefung.art}_pruefung_stort,
${vorherige_pruefung.art}_pruefung_staat,
${vorherige_pruefung.art}_pruefung_abschluss,
${vorherige_pruefung.art}_pruefung_ergebnis,
</#foreach>
</#if>
       datum,
       summe)
 select
 hs_nr,
${stgnr.studiengang_nr} as       studiengang_nr,
${stgnr.fach_nr} as       fach_nr,
val(ef007) as geschlecht,
val(ef009) as ca12_staat,
semester as       sem_rueck_beur_ein,
${stgnr.fach} as stg_land,
${stgnr.abschluss} as abschluss,
val(${stgnr.regel}) as regel,
val(${stgnr.kz_rueck_beur_ein}) as kz_rueck_beur_ein,
val(${stgnr.fach_sem_zahl}) as fach_sem_zahl,
(case when ef026='1' then 1
else val(ef019) end ) as hssem,
ef004 as stort,
val(${stgnr.stuart}) as stuart,
${stgnr.stufrm} as stufrm,
ef110 as hzbart_astat,
ef111u1 as hzbkfzkz,
(case when ef111u1='99' then val(ef111u2) else 0 end) as hzb_staat,
ef012 as hrst,
<#if stgnr.studiengang_nr=="1" && stgnr.fach_nr=="1">
<#foreach vorherige_pruefung in vorherige_pruefungen_2015>
${vorherige_pruefung.pruefung_stort},
val(${vorherige_pruefung.pruefung_staat}),
${vorherige_pruefung.pruefung_abschluss},
val(${vorherige_pruefung.pruefung_ergebnis}),
</#foreach>
</#if>
       today(),
       count(*) as summe
FROM kenn_sos_astat_2015 
where ${stgnr.abschluss} is not null
and ${stgnr.fach} is not null
and semester in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDA')
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20
<#if stgnr.studiengang_nr=="1" && stgnr.fach_nr=="1">
,21,22,23,24,25,26,27,28
</#if>
 ;

</#foreach>



<#if k_astat_studienfach_land_exists=1>
SELECT L.schluessel,
       L.land,
       null::char(10) as keybund,
       max(nvl(L.gueltig_bis,30001)) as gueltig_bis
   into temp tmp_stg
FROM k_astat_studienfach_land L, cif C
where L.land=C.apnr
and C.key=659 --Bundesland der Hochschule
group by 1,2,3;

update tmp_stg set keybund=(select distinct L.keybund
from k_astat_studienfach_land L
where L.schluessel=tmp_stg.schluessel
and L.land=tmp_stg.land
and (L.gueltig_bis=tmp_stg.gueltig_bis or (L.gueltig_bis is null and tmp_stg.gueltig_bis =30001))
);

update tmp_stg_aggr_astat set stg=(select K.keybund from tmp_stg K where (tmp_stg_aggr_astat.stg_land=K.schluessel or tmp_stg_aggr_astat.stg_land='0' || K.schluessel))
where 1=(select count(*) from tmp_stg K where tmp_stg_aggr_astat.stg_land=K.schluessel or tmp_stg_aggr_astat.stg_land='0' || K.schluessel);


update tmp_stg_aggr_astat set stg='0' || stg where length(trim(stg))=3;


drop table tmp_stg;
</#if>

update tmp_stg_aggr_astat set sb=(select A.parent from kenn_stg_astat A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_stg_aggr_astat.sem_rueck_beur_ein
and A.astat=tmp_stg_aggr_astat.stg_land);
update tmp_stg_aggr_astat set fgr=(select A.parent from kenn_stg_astat A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_stg_aggr_astat.sem_rueck_beur_ein
and A.astat=tmp_stg_aggr_astat.sb);

update tmp_stg_aggr_astat set fgr=(select A.apnr from kenn_dim_fgr A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_stg_aggr_astat.sem_rueck_beur_ein
and A.fg_studierende=tmp_stg_aggr_astat.fgr);

update tmp_stg_aggr_astat set fgr='U' where fgr is null;

<#if k_astat_abschluss3steller_land_exists=1>
-- Bund Abschluss ermitteln:
update tmp_stg_aggr_astat set abschluss_astat_bund=(select min(substring(K.keybund from 2 for 2))
from k_astat_abschluss3steller_land K, cif C
where K.land=C.apnr
and C.key=659 --Bundesland der Hochschule
and substring(K.schluessel from 2 for 2) =tmp_stg_aggr_astat.abschluss_astat_land);

--Fallback: 
update tmp_stg_aggr_astat set abschluss_astat_bund=abschluss_astat_land
where abschluss_astat_bund is null;

<#else>
--Fallback: vor Kern 5.1 gab es keine Zuordnung in kenn:
update tmp_stg_aggr_astat set abschluss_astat_bund=abschluss_astat_land;

</#if>


update tmp_stg_aggr_astat set abschlussart=(select A.parent from kenn_abschl_astat A
where A.astat=tmp_stg_aggr_astat.abschluss_astat_bund);
update tmp_stg_aggr_astat set abgrp='BA' where abschlussart='A24';
update tmp_stg_aggr_astat set abgrp='MA' where abschlussart='A37';
--Diplom :
update tmp_stg_aggr_astat set abgrp='D' where abschluss_astat_bund in (
'11', --Diplom Uni                                                                                          
'12', --Diplom Uni Dolmetscher                                                                              
'13', --Diplom Uni bersetzer                                                                               
'14', --Diplom I UNI GH                                                                                     
'18', --Diplom Lehrerprfung Uni                                                                            
'29', --sonst.LA nach Schulart                                                                              
'51', --Diplom FH                                                                                           
'53', --Diplom FH Dolmetscher                                                                               
'54', --Diplom FH bersetzer                                                                                
'75' --Diplom Kunsthochschule 
);

--Staatsexamen:
update tmp_stg_aggr_astat set abgrp='ST' where abschluss_astat_bund in (
'08', --Staatsexamen ohn.LA Prfg.                                                                           
'09', --Staatsexamen einphasig                                                                              
'20', --LA Grund- und Hauptschulen
'21', --LA Grundschulen
'22', --LA Hauptschulen
'42', --LA Grundstufe/Primarstufe
'28', --LA Sekundarstufe I/Primarstufe
'40', --LA Grundschulen/Sekundarstufe I
'23', --LA Realschulen
'24', --LA Haupt- und Realschulen/Unterstufe und Mittelstufe Gymnasien
'43', --LA Mittelstufe/Sekundarstufe I
'41', --LA Sekundarstufe II/Sekundarstufe I
'25', --LA Gymnasien
'44', --LA Oberstufe/Sekundarstufe II, allgemeinbildende Schulen
'26', --LA Sonderschulen/Frderschulen
'27', --LA Berufliche Schulen
'45', --LA Oberstufe/Sekundarstufe II, berufliche Schulen
'29' --Sonstige Staatsprfungen nach Schularten/Schulstufen
);
update tmp_stg_aggr_astat set abgrp='S' where abgrp is null;

--Promotion:
update tmp_stg_aggr_astat set abgrp='P' where abschluss_astat_bund in ('06','07','91','92');

--HZB-Staat EWR
update tmp_stg_aggr_astat set hzb_staat_ewr=1
where hzb_staat in (${ewr_staaten});

--HZB-Staat EU?
--hzb_staat_eu ermitteln:
<#if staat_eu_table_name!="">
update tmp_stg_aggr_astat set hzb_staat_eu=1
where hzb_staat=0
or exists (select eu
from ${staat_eu_table_name} E
where tmp_stg_aggr_astat.sem_rueck_beur_ein between E.semester_von and E.semester_bis
and val(E.astat)= tmp_stg_aggr_astat.hzb_staat
and eu='J');

update tmp_stg_aggr_astat set hzb_staat_eu=0
where hzb_staat!=0
and exists (select eu
from ${staat_eu_table_name} E
where tmp_stg_aggr_astat.sem_rueck_beur_ein between E.semester_von and E.semester_bis
and val(E.astat)= tmp_stg_aggr_astat.hzb_staat
and eu='N');
</#if>

--Gruppierung und Lehramt:
<#if abschlusstypen?has_content>
<#foreach typ in abschlusstypen>

update tmp_stg_aggr_astat set abschlusstyp='${typ.apnr}'
where abschluss_astat_bund in (${typ.whereclause})
;
</#foreach>
</#if>

update tmp_stg_aggr_astat set abschlusstyp='S' where abschlusstyp is null;



delete from kenn_stg_aggr_astat
where sem_rueck_beur_ein in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDA')
;


insert into kenn_stg_aggr_astat(hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       stg_land,
       abschluss,
       fgr,
       abgrp,
       regel,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
 --      kz_fach,
       stort,
       stuart,
       stufrm,
       hzbart_astat,
       hzbkfzkz,
       hrst,
       letzte_pruefung_stort,
       letzte_pruefung_staat,
       letzte_pruefung_abschluss,
       letzte_pruefung_ergebnis,
       vorletzte_pruefung_stort,
       vorletzte_pruefung_staat,
       vorletzte_pruefung_abschluss,
       vorletzte_pruefung_ergebnis,
       datum,
       summe)
       select hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       stg,
       stg_land,
       abschluss_astat_bund,
       fgr,
       abgrp,
       regel,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
--       kz_fach,
       stort,
       stuart,
       stufrm,
       hzbart_astat,
       hzbkfzkz,
       hrst,
       letzte_pruefung_stort,
       letzte_pruefung_staat,
       letzte_pruefung_abschluss,
       letzte_pruefung_ergebnis,
       vorletzte_pruefung_stort,
       vorletzte_pruefung_staat,
       vorletzte_pruefung_abschluss,
       vorletzte_pruefung_ergebnis,
       datum,
       sum(summe)
       from tmp_stg_aggr_astat
       group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30
       ;

delete from kenn_stud_aggr_astat
where sem_rueck_beur_ein in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDA')
;

insert into kenn_stud_aggr_astat(
 hs_nr,
 studiengang_nr,
       fach_nr,
       geschlecht,
       bildungstyp,
       sem_rueck_beur_ein,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       hssem_1,
       aufbaustudium,
       hrst,
       datum,
       summe)
select  hs_nr,
 	studiengang_nr,
 	fach_nr,
       (case when geschlecht=2 then 2 else 1 end) as geschlecht,
       (case when ca12_staat=0 or hzb_staat=0 then 'BI' --Bildungsinlnger = Staat D, oder HZB-art in BRD 
       when hzb_staat_ewr=1 then 'BA_EWR'
       when hzb_staat_eu =1 then 'BA_EU'
       when hzb_staat_eu =0 then 'BA_N_E'
       else 'U' end) as bildungstyp,
       sem_rueck_beur_ein,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       (case when hssem=1 then 1 else 0 end) as hssem_1,
       (case when stufrm in ('3','4','6') then 1 else 0 end) as aufbaustudium,
       hrst,
       datum,
       sum(summe)
       from tmp_stg_aggr_astat
       where kz_rueck_beur_ein in (1,2,3) --ohne Exmatr./Beurlaubte
       and hs_nr is not null
       and (abschluss_astat_bund != '07' or abschluss_astat_bund is null) --wg. Abgleich mit amtl. Statistik
       group by hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       hzb_staat,
       hzb_staat_eu,
       hzb_staat_ewr,
       sem_rueck_beur_ein,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       hssem,
       stufrm,
       hrst,
       datum;
       
       
drop table tmp_stg_aggr_astat;
       


<#if k_astat_studienfach_land_exists=1>


--Korrektur Fchergruppe:
select distinct stg, 
sem_rueck_beur_ein as semester,
null::char(19) as sb,
null::char(10) AS fgr
into temp tmp_stg_aggr_astat
from kenn_stg_aggr_astat;


update tmp_stg_aggr_astat set sb=(select A.parent from kenn_stg_astat A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_stg_aggr_astat.semester
and A.astat=tmp_stg_aggr_astat.stg);

update tmp_stg_aggr_astat set fgr=(select A.parent from kenn_stg_astat A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_stg_aggr_astat.semester
and A.astat=tmp_stg_aggr_astat.sb);

update tmp_stg_aggr_astat set fgr=(select A.apnr from kenn_dim_fgr A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_stg_aggr_astat.semester
and A.fg_studierende=tmp_stg_aggr_astat.fgr);

update tmp_stg_aggr_astat set fgr='U' where fgr is null;

update kenn_stg_aggr_astat set fgr=(select min(T.fgr)
from tmp_stg_aggr_astat T
where T.stg=kenn_stg_aggr_astat.stg
and T.semester=kenn_stg_aggr_astat.sem_rueck_beur_ein);



drop table tmp_stg_aggr_astat;

</#if>


