
--Freemarker Template 

<sqlvars>
<sqlvar name="sos_installed">
select count(*) from db_version where his_system ='sos';
</sqlvar>
<sqlvar name="zul_antr_aggr_exists">
select sp_table_exists('zul_antr_aggr') from xdummy;
</sqlvar>
--landesspezifika ermitteln: 5='nrw',14='Sachsen',8 'BaWue'
<sqlvar name="bland_kuerzel">
select 746::integer as kuerzel from cif where key=659 and apnr=5 
union
select 751::integer from cif where key=659 and apnr=14 
union
select 750::integer from cif where key=659 and apnr=8
union
select 750::integer from xdummy where 0=(
select count(*) from cif where key=659 and apnr in (5,8,14)) 
;
</sqlvar>
<sqlvar name = "k_astat_studienfach_land_exists">
SELECT sp_table_exists('k_astat_studienfach_land') FROM xdummy;
</sqlvar>
</sqlvars>

<#if sos_installed=1>

--(c) 2008 Daniel Quathamer
delete from kenn_stg_aggr where 0=
(select apnr from konstanten where beschreibung ='KENN_STUDIUM_ARCHIV');


delete from kenn_stg_aggr
where sem_rueck_beur_ein in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDM')
;

--TODO: merkmal hrst fllen aus sos_stg_aggr, danach transofrmieren in astat (siehe Studienform stufrm)
create temp table tmp_kenn_stg_aggr
( 
hs_nr integer, 
matrikel_nr integer,
studiengang_nr smallint, 
fach_nr smallint, 
geschlecht smallint,
ca12_staat smallint,
sem_rueck_beur_ein smallint,
kz_rueck_beur_ein smallint,
fach_sem_zahl smallint,
hssem smallint,
stg_int char(10),
stg_land char(4),
stg_bund char(4),	-- in Zieltabelle stg
kz_fach char(10),
kz_fach_astat char(10),
vertfg char(10),
vertfg_astat char(10),
abschluss char(10),
abschluss_astat char(2),
regel smallint,
hzbart smallint,
datum date,
summe integer,
stort CHAR(10) ,
stort_astat char(10),
stuart CHAR(10) , 
stuart_astat CHAR(10) ,
stufrm CHAR(10) , 
stufrm_astat CHAR(10) , 
hzbart_int CHAR(10),
hzbart_astat CHAR(10),
hrst char(10),
hrst_astat char(10),
antrnr INTEGER ,
rsz smallint
);
	

insert into tmp_kenn_stg_aggr (
hs_nr,
matrikel_nr,
studiengang_nr,
fach_nr,
geschlecht,
ca12_staat,
sem_rueck_beur_ein,
kz_rueck_beur_ein,
fach_sem_zahl,
hssem,
stg_int,
kz_fach,
vertfg,
abschluss,
rsz,
hzbart,
datum,
      stort,
       stuart,
       stufrm,
       hzbart_int,
       hrst,
       summe)
select H.hs_nr,
S.matrikel_nr,
       S.studiengang_nr,
       S.fach_nr,
       S.geschlecht,
       S.ca12_staat,
       S.sem_rueck_beur_ein,
       S.kz_rueck_beur_ein,
       S.fach_sem_zahl,
       S.hssem,
       L.stg as stg_int,
       L.kz_fach,
       L.vertfg,
       L.abschluss,
       L.regel, 
       S.hzbart,
       today(),
       L.stort,
       S.stuart,
       S.stufrm,
       S.hzbart_int,
       S.hrst,
       sum(S.summe)
FROM sos_stg_aggr S, lehr_stg_ab L, hochschulinfo H, kenn_stichtag K
where sem_rueck_beur_ein = K.bezugszeit 
and K.stichtagsart_id='STDM'
and K.berechnen='1'
and S.stichtag = (select I.tid from sos_stichtag I where I.appl_key ='6')
and S.tid_stg = L.tid
--and S.kz_rueck_beur_ein in (1,2,3) 
--and S.hrst in (select apnr from sos_k_hrst where astat='1') 
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22;
 
--Ermittlung Kennzeichen regel:
--Studierende in der RSZ:
update tmp_kenn_stg_aggr set regel=1 where fach_sem_zahl <= rsz;
--Studierende ber RSZ:
update tmp_kenn_stg_aggr set regel=-1 where fach_sem_zahl > rsz;
--RSZ unbekannt:
update tmp_kenn_stg_aggr set regel=0 where regel is null;

--Ermittlung Antragsnummer aus ZUL, derzeit inaktiv:
<#if zul_antr_aggr_exists=1 && 1=0>
--zur Studiengang (Fach+Abschluss):

<@selectintotmp source="zul_antr_aggr" target="tmp_zul_antr_aggr" 
select="mtknr,bewsem,antrnr,stg,abschl,fachnr">
where bewsem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDM')
</@selectintotmp>;
create index tmp_ix1 on tmp_zul_antr_aggr(bewsem);
create index tmp_ix2 on tmp_zul_antr_aggr(mtknr);
create index tmp_ix3 on tmp_zul_antr_aggr(stg_int,abschl);


update tmp_kenn_stg_aggr set antrnr=(select min(Z.antrnr)
from tmp_zul_antr_aggr Z
where Z.bewsem=tmp_kenn_stg_aggr.sem_rueck_beur_ein
and Z.mtknr=tmp_kenn_stg_aggr.matrikel_nr
and Z.stg=tmp_kenn_stg_aggr.stg_int
and Z.abschl=tmp_kenn_stg_aggr.abschluss);
--nur Fach:
update tmp_kenn_stg_aggr set antrnr=(select min(Z.antrnr)
from tmp_zul_antr_aggr Z
where Z.bewsem=tmp_kenn_stg_aggr.sem_rueck_beur_ein
and Z.mtknr=tmp_kenn_stg_aggr.matrikel_nr
and Z.stg=tmp_kenn_stg_aggr.stg_int
--and Z.abschl=tmp_kenn_stg_aggr.abschl
)
where antrnr is null;

drop table tmp_zul_antr_aggr;

</#if>

 --Amtliche Fcher und Abschlsse
update tmp_kenn_stg_aggr set stg_land=(select min(astat) from sos_k_stg K where K.apnr=tmp_kenn_stg_aggr.stg_int and K.astat is not null);
--manche HSen pflegen die amtlichen Fcher in Abhngigkeit vom Abschluss:
update tmp_kenn_stg_aggr set stg_land=(select min(astat2) from k_abstgv K 
where K.stg=tmp_kenn_stg_aggr.stg_int and K.abschl=tmp_kenn_stg_aggr.abschluss and K.astat2 is not null)
where stg_land is null;
--Abschluss
update tmp_kenn_stg_aggr set abschluss_astat=(select astat from k_abint K where K.abint=tmp_kenn_stg_aggr.abschluss);
-- Fachkennzeichen
update tmp_kenn_stg_aggr set kz_fach_astat=(select astat from sos_k_kzfa K where K.apnr=tmp_kenn_stg_aggr.kz_fach);
-- Vertiefung
--update tmp_kenn_stg_aggr set vertfg_astat=(select astat from sos_k_vert K where K.apnr=tmp_kenn_stg_aggr.vertfg);
--HZB-Arten:
update tmp_kenn_stg_aggr set hzbart_astat=(select min(astat) from sos_k_hzbart K where K.apnr=tmp_kenn_stg_aggr.hzbart_int and K.astat is not null);
--Standort:
update tmp_kenn_stg_aggr set stort_astat=(select min(astat) from sos_k_stort K where K.apnr=tmp_kenn_stg_aggr.stort and K.astat is not null);
--Studienart:
update tmp_kenn_stg_aggr set stuart_astat=(select min(astat) from sos_k_stuart K where K.apnr=tmp_kenn_stg_aggr.stuart and K.astat is not null);
--Studienform:
update tmp_kenn_stg_aggr set stufrm_astat=(select min(astat) from sos_k_stufrm K where K.apnr=tmp_kenn_stg_aggr.stufrm and K.astat is not null);
--Hrerstatus:
update tmp_kenn_stg_aggr set hrst_astat=(select min(astat) from sos_k_hrst K where K.apnr=tmp_kenn_stg_aggr.hrst and K.astat is not null);


--Prfroutine kz_fach:
insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sos_k_kzfa'::char(18),'Das Fachkennzeichen ' || trim(S.kz_fach) || ' hat keinen gltigen HIS_KZFA-Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_stg_aggr S left outer join sos_k_kzfa A on (S.kz_fach_astat=A.astat)  
where A.astat is null ;  

--Prfroutine vertfg:
--insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
--select distinct today(),'sos_k_vert'::char(18),'Die Vertiefung ' || trim(S.vertfg) || ' hat keinen gltigen Wert'::char(100), 'Warnung'::char(10) 
--from tmp_kenn_stg_aggr S left outer join sos_k_vert A on (S.vertfg_astat=A.astat)  
--where A.astat is null ;  

--Prfroutine fach:
insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sos_k_stg'::char(18),'Das interne Fach ' || trim(S.stg_int) || ' hat keinen gltigen ASTAT-Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_stg_aggr S left outer join sos_k_stg A on (S.stg_int=A.apnr)  
where A.astat is null ; 


<#if k_astat_studienfach_land_exists=1>

SELECT L.schluessel,
       L.land,
       null::char(10) as keybund,
       max(nvl(L.gueltig_bis,30001)) as gueltig_bis
   into temp tmp_stg
FROM k_astat_studienfach_land L, cif C
where L.land=C.apnr
and C.key=659 --Bundesland der Hochschule
group by 1,2,3;

update tmp_stg set keybund=(select distinct L.keybund
from k_astat_studienfach_land L
where L.schluessel=tmp_stg.schluessel
and L.land=tmp_stg.land
and (L.gueltig_bis=tmp_stg.gueltig_bis or (L.gueltig_bis is null and tmp_stg.gueltig_bis =30001))
);

update tmp_kenn_stg_aggr set stg_bund=(select K.keybund from tmp_stg K where (tmp_kenn_stg_aggr.stg_land=K.schluessel or tmp_kenn_stg_aggr.stg_land='0' || K.schluessel))
where 1=(select count(*) from tmp_stg K where tmp_kenn_stg_aggr.stg_land=K.schluessel or tmp_kenn_stg_aggr.stg_land='0' || K.schluessel);

update tmp_kenn_stg_aggr set stg_bund='0' || stg_bund where length(trim(stg_bund))=3;

drop table tmp_stg;
</#if>

--Prfroutine fach astat gegen ausgelieferten Stand (kenn_stg_astat):
insert into kenn_pruefrout (datum,tabelle_kenn,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_stg_astat'::char(18),'sos_k_stg'::char(18),'Das Fach ' || trim(S.stg_land) || ' hat keinen gltigen ASTAT-Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_stg_aggr S left outer join kenn_stg_astat A on 
(S.stg_land=A.astat)
where A.astat is null; 


--Prfroutine abschluss:
insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sos_k_abint'::char(18),'Der interne Abschluss ' || trim(S.abschluss) || ' hat keinen gltigen Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_stg_aggr S left outer join sos_k_stg A on (S.stg_int=A.apnr)  
where A.astat is null ; 

--Prfroutine abschl astat gegen ausgelieferten Stand (kenn_stg_astat):
insert into kenn_pruefrout (datum,tabelle_kenn,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_abschl_astat'::char(18),'sos_k_abint'::char(18),'Der Abschluss ' || trim(S.abschluss_astat) || ' hat keinen gltigen Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_stg_aggr S left outer join kenn_abschl_astat A on 
(S.abschluss_astat=A.astat)
where A.astat is null; 

--Nur PH BaWue: Prfroutine abint gegen kenn_abschl_sbereich.unl :
insert into kenn_pruefrout (datum,tabelle_kenn,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_abschl_sbereich'::char(18),'sos_k_abint'::char(18),'Der Abschluss ' || trim(S.abschluss) || ' hat keine Abschlussgruppe'::char(100), 'Warnung'::char(10) 
from tmp_kenn_stg_aggr S left outer join kenn_abschl_sbereich A on 
(S.abschluss=A.abschluss)
where A.abschluss is null
and 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart in ('Studierendenstatistik (Land)') and berechnen='1')
--nur PHen BaWue
and 0 < (select count(*) from konstanten where beschreibung='KENN_PROFIL'
and apnr in  (2))
;

--Prfroutine abschluss:
-- insert into kenn_pruefrout (datum,tabelle_kenn,tabelle_quelle,problem,aktion)
-- select distinct today(),'sos_k_abint'::char(18),'sos_k_abint'::char(18),'Das Fachkennzeichen ' || trim(S.kz_fach) || ' hat keinen gltigen ASTAT-Wert'::char(100), 'Warnung'::char(10) 
-- from tmp_kenn_stg_aggr S left outer join sos_k_abint A on (S.kz_fach_astat=A.astat)  
-- where A.astat is null ;  


update tmp_kenn_stg_aggr set kz_fach_astat='U' where kz_fach_astat is null;

<#if K_KENN_SWITCH_BA_MA?exists && K_KENN_SWITCH_BA_MA==1>
--Bei nderungen bitte auch kopieren nach 
--kenn/hilfstabellen/trans_kenn_sos_stg.sql

--BA und MA werden vertauscht, wenn:
--1. Bachelorstudenten die im 2. Studiengang ein Masterstudium begonnen 
--haben und sich im 1. Fachsemester befinden
--2. diese Bachelorstudenten mssen sich im Erststudium und im 7. und 
--hheren Fachsemester befinden

create index tmp_ixstg1 on tmp_kenn_stg_aggr(studiengang_nr);
create index tmp_ixstg2 on tmp_kenn_stg_aggr(matrikel_nr, sem_rueck_beur_ein);
create index tmp_ixstg3 on tmp_kenn_stg_aggr(fach_sem_zahl);
create index tmp_ixstg4 on tmp_kenn_stg_aggr(abschluss_astat);


--welche Studis kommen in Frage?
create temp table tmp_switch(
sem_rueck_beur_ein integer,
matrikel_nr integer,
do_switch smallint
);

insert into tmp_switch(
sem_rueck_beur_ein ,
matrikel_nr ,
do_switch 
)
select distinct sem_rueck_beur_ein ,
matrikel_nr ,
0
from tmp_kenn_stg_aggr
where studiengang_nr=1
and stufrm_astat='1' --Erststudium
and fach_sem_zahl >=7
and abschluss_astat in (select K.astat from kenn_abschl_astat K
where K.parent in ('A24')) --Bachelor
;
update tmp_switch set do_switch=1
where 0 < (select count(*) 
from tmp_kenn_stg_aggr T
where T.matrikel_nr=tmp_switch.matrikel_nr
and T.sem_rueck_beur_ein=tmp_switch.sem_rueck_beur_ein
and T.fach_sem_zahl=1
and T.studiengang_nr=2
and abschluss_astat in (select K.astat from kenn_abschl_astat K
where K.parent in ('A37','A41')) --Master
);

delete from tmp_switch where do_switch=0;

insert into kenn_pruefrout (datum,tabelle_kenn,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_stg_aggr'::char(18),'sos_stg_aggr'::char(18),('Der/die Studierende ' || T.matrikel_nr || ' wird im Semester ' || T.sem_rueck_beur_ein || ' im Studiengang Master auf 1 gesetzt, BA auf 2')::char(200), 'Info'::char(10) 
from tmp_kenn_stg_aggr S, tmp_switch T
where T.matrikel_nr=S.matrikel_nr
and T.sem_rueck_beur_ein=S.sem_rueck_beur_ein
; 


update tmp_kenn_stg_aggr set studiengang_nr=-1
where studiengang_nr=1
and 0<(select count(*) 
from tmp_switch T
where T.matrikel_nr=tmp_kenn_stg_aggr.matrikel_nr
and T.sem_rueck_beur_ein=tmp_kenn_stg_aggr.sem_rueck_beur_ein);

update tmp_kenn_stg_aggr set studiengang_nr=1
where studiengang_nr=2
and 0<(select count(*) 
from tmp_switch T
where T.matrikel_nr=tmp_kenn_stg_aggr.matrikel_nr
and T.sem_rueck_beur_ein=tmp_kenn_stg_aggr.sem_rueck_beur_ein);

update tmp_kenn_stg_aggr set studiengang_nr=2
where studiengang_nr=-1;

drop table tmp_switch;

</#if>

insert into kenn_stg_aggr
( hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       stg,--stg_bund
       stg_land,
       abschluss,
       kz_fach,
       kz_fach_int,
       vertfg,
       regel,
       hzbart,
       datum,
       hzbart_astat,
       stuart,
       stufrm,
       stort,
       stg_int,
       abint,
       hrst,
--       antrnr,
       summe
       )
SELECT hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
      kz_rueck_beur_ein,
      fach_sem_zahl,
      hssem,
      stg_bund,
      stg_land,
      abschluss_astat,
       kz_fach_astat,
       kz_fach,
       vertfg,
       regel,
       hzbart,
       datum,
       hzbart_astat,
       stuart_astat,
       stufrm_astat,
       stort_astat,
       stg_int,
       abschluss,
       hrst_astat,
--       antrnr,
       sum(summe)
FROM tmp_kenn_stg_aggr
 group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25;
 
insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'sos_stg'::char(18),'kenn_stg_aggr'::char(18),('Es gibt ' || count(*)::integer || ' Flle, wo Studierende kein gltiges Geschlecht haben. ')::char(100), 'Info'::char(10) 
from kenn_stg_aggr S 
where (geschlecht is null or geschlecht not in (1,2,3))  
and 0 < (select sum(summe) from tmp_kenn_stg_aggr 
where (geschlecht is null or geschlecht not in (1,2,3)))
;  

update kenn_sos_stg set stg='0'||stg where length(stg)=3
and substring(stg from 1 for 1)  in ('0','1','2','3','4','5','6','7','8','9')
;

drop table tmp_kenn_stg_aggr;

</#if>



