
--Freemarker Template 
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="sos_installed">
select count(*) from db_version where his_system ='sos';
</sqlvar>
--landesspezifika ermitteln: 5='nrw',14='Sachsen',8 'BaWue'
<sqlvar name="bland_kuerzel">
select 746::integer as kuerzel from cif where key=659 and apnr=5 
union
select 751::integer from cif where key=659 and apnr=14 
union
select 750::integer from cif where key=659 and apnr=8
union
select 750::integer from xdummy where 0=(
select count(*) from cif where key=659 and apnr in (5,8,14)) 
;
</sqlvar>
<sqlvar name = "k_astat_studienfach_land_exists">
SELECT sp_table_exists('k_astat_studienfach_land') FROM xdummy;
</sqlvar>
</sqlvars>

<#assign hrst_filter="" /> 
<#if K_KENN_PROFIL?exists && (K_KENN_PROFIL=1 || K_KENN_PROFIL=2 ||K_KENN_PROFIL=3)>
--nur BaWue
<#assign hrst_filter="and S.hrst in (select apnr from sos_k_hrst where astat='1')" /> 
</#if>
<#if K_KENN_PROFIL?exists && K_KENN_PROFIL=5>
--nur Sachsen: 
 --ohne Studienkolleg/Gasthrer:
<#assign hrst_filter="and (S.hrst is null or S.hrst not in (select apnr from sos_k_hrst where astat in ('3','4')))" /> 
</#if>





<#if sos_installed=1>

--(c) 2008 Daniel Quathamer
delete from kenn_sos_stg where 0=
(select apnr from konstanten where beschreibung ='KENN_STUDIUM_ARCHIV');


delete from kenn_sos_stg
where sem_rueck_beur_ein in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDI')
;


create temp table tmp_kenn_sos_stg
( 
matrikel_nr integer,
hs_nr integer, 
studiengang_nr smallint, 
fach_nr smallint, 
geschlecht smallint,
ca12_staat smallint,
sem_rueck_beur_ein smallint,
kz_rueck_beur_ein smallint,
fach_sem_zahl smallint,
hssem smallint,
stg char(10),
fb char(10),
stg_astat char(4),
kz_fach char(10),
kz_fach_astat char(1),
abschluss char(10),
abschluss_astat char(2),
extkotr char(30),
extkost char(30),
stufrm char(10),
stufrm_ext char(10),
stuart  char(10),
stutyp char(10),
hrst char(10),
hrst_astat char(10),
rsz integer,
regel smallint,
hzbart smallint,
datum date,
summe integer
);
	
--Studierende selektieren:
insert into tmp_kenn_sos_stg (
matrikel_nr,
hs_nr,
studiengang_nr,
fach_nr,
geschlecht,
ca12_staat,
sem_rueck_beur_ein,
kz_rueck_beur_ein,
fach_sem_zahl,
hssem,
stg,
fb,
kz_fach,
abschluss,
rsz,
--regel,
hzbart,
stufrm,
stuart,
stutyp,
datum,
hrst,
summe)
select S.matrikel_nr,
H.hs_nr,
       S.studiengang_nr,
       S.fach_nr,
       S.geschlecht,
       S.ca12_staat,
       S.sem_rueck_beur_ein,
       S.kz_rueck_beur_ein,
       S.fach_sem_zahl,
       S.hssem,
       L.stg,
       L.fb,
       L.kz_fach,
       L.abschluss,
       L.regel,
       S.hzbart,
       S.stufrm,
       S.stuart,
       S.stutyp,
       today(),
       S.hrst,
       sum(S.summe)
FROM sos_stg_aggr S, lehr_stg_ab L, hochschulinfo H, kenn_stichtag K
where sem_rueck_beur_ein = K.bezugszeit 
and K.stichtagsart_id='STDI'
and K.berechnen='1'
and S.stichtag = (select Y.tid from sos_stichtag Y where Y.stichtagsart='Studierende' and Y.appl_key ='1')
and S.tid_stg = L.tid
and S.kz_rueck_beur_ein in (1,2,3) 
${hrst_filter}
<#if KENN_sos_stg_CUSTOM?exists && KENN_sos_stg_CUSTOM !="">
<@addcomment comment="Embedding customer-specific repository Script KENN_sos_stg_CUSTOM"/> 

${KENN_sos_stg_CUSTOM}
</#if>
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21;
 
--Studierende in RSZ:
update tmp_kenn_sos_stg set regel=1
where fach_sem_zahl <= rsz;
--Studierende ber RSZ
update tmp_kenn_sos_stg set regel=0
where fach_sem_zahl > rsz;
--RSZ unbekannt:
 update tmp_kenn_sos_stg set regel=-1
where regel is null;

 --Amtliche Fcher und Abschlsse
update tmp_kenn_sos_stg set stg_astat=(select min(astat) from k_stg K where K.refstg=tmp_kenn_sos_stg.stg and K.astat is not null);

--manche HSen pflegen die amtlichen Fcher in Abhngigkeit vom Abschluss:
update tmp_kenn_sos_stg set stg_astat=(select min(astat2) from k_abstgv K 
where K.stg=tmp_kenn_sos_stg.stg and K.abschl=tmp_kenn_sos_stg.abschluss and K.astat2 is not null)
where stg_astat is null;


update tmp_kenn_sos_stg set kz_fach_astat=(select astat from sos_k_kzfa K where K.apnr=tmp_kenn_sos_stg.kz_fach);
update tmp_kenn_sos_stg set abschluss_astat=(select astat from k_abint K where K.abint=tmp_kenn_sos_stg.abschluss);
--Hrerstatus:
update tmp_kenn_sos_stg set hrst_astat=(select min(astat) from sos_k_hrst K where K.apnr=tmp_kenn_sos_stg.hrst and K.astat is not null);

--Studienform:
update tmp_kenn_sos_stg set stufrm_ext=(select min(astat) from sos_k_stufrm K where K.apnr=tmp_kenn_sos_stg.stufrm and K.astat is not null);


--nur Sachsen:
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5)>

--Studierende generell ohne Promotion:
--in kenn 1.1 / NHs Pack 2015-07-15 nicht mehr:
--delete from tmp_kenn_sos_stg where abschluss_astat in ('06','07');


--Fak. ermitteln:
update tmp_kenn_sos_stg set extkost=fb;
update tmp_kenn_sos_stg set extkost='' where extkost is null;
insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'lehr_stg_ab'::char(18),'Das Studienfach ' || trim(S.stg) || ' hat keine Fakultt'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_stg S 
where S.extkost is null ; 

<#if KENN_STUD_MED?exists && KENN_STUD_MED != "">
--Medizin. Fakultt lschen:
delete from tmp_kenn_sos_stg 
where extkost in ('${KENN_STUD_MED}');
;
</#if>

update tmp_kenn_sos_stg set extkotr=(select min(K.extkotr)
from kenn_extkotr_stg K
where K.stg=tmp_kenn_sos_stg.stg);

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_extkotr_stg'::char(18),'Das Studienfach ' || trim(S.stg) || ' hat keinen externen Produktschlssel'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_stg S 
where S.extkotr is null ; 

<#if KENN_STUFRM_WEITERB?exists && KENN_STUFRM_WEITERB != "">
update tmp_kenn_sos_stg set stufrm_ext='W' where 1=1 
and ${KENN_STUFRM_WEITERB}
;
</#if>

</#if>

--Umschlsselung Fach ggf. von Landes- auf Bundesschlssel:
update tmp_kenn_sos_stg set stg_astat=(select min(C.bund_apnr)
from sos_cifx C
where C.key=${bland_kuerzel}
and C.apnr=tmp_kenn_sos_stg.stg_astat)
where ${bland_kuerzel} in (746, 751) --nur Sachsen und NRW
;

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'k_stg'::char(18),'Das Studienfach ' || trim(S.stg) || ' hat keinen gltigen ASTAT-Wert (Bund)'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_stg S left outer join kenn_stg_astat A on (S.stg_astat=A.astat)  
where A.astat is null ;  


insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'k_abint'::char(18),'Der Abschluss ' || trim(S.abschluss) || ' hat keinen gltigen ASTAT-Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_stg S left outer join kenn_abschl_astat A on (S.abschluss_astat=A.astat)  
where A.astat is null ;


insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sos_k_kzfa'::char(18),'Das Fachkennzeichen ' || trim(S.kz_fach) || ' hat keinen gltigen HIS_KZFA-Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_stg S left outer join sos_k_kzfa A on (S.kz_fach_astat=A.astat)  
where A.astat is null ;  

update tmp_kenn_sos_stg set kz_fach_astat='U' where kz_fach_astat is null or kz_fach_astat='';
-- abschluss und fach 
update tmp_kenn_sos_stg set abschluss_astat='U' where abschluss_astat is null or abschluss_astat='';
update tmp_kenn_sos_stg set stg_astat='U' where stg_astat is null or stg_astat='';

-- Hrerstati
insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sos_k_hrst'::char(18),'Der Hrerstatus ' || trim(S.apnr) || ' wird aufgrund seines Merkmals astat=1 als Haupthrer klassifiziert'::char(130), 'Info'::char(10) 
from sos_k_hrst S  
where astat='1';
insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sos_k_hrst'::char(18),'Der Hrerstatus ' || trim(S.apnr) || ' wird aufgrund seines Merkmals astat!=1 nicht als Haupthrer klassifiziert'::char(130), 'Info'::char(10) 
from sos_k_hrst S  
where (astat !='1' or astat is null);

<#if K_KENN_SWITCH_BA_MA?exists && K_KENN_SWITCH_BA_MA==1>
--kopiert von kenn/hilfstabellen/trans_kenn_stg_aggr.sql:

--BA und MA werden vertauscht, wenn:
--1. Bachelorstudenten die im 2. Studiengang ein Masterstudium begonnen 
--haben und sich im 1. Fachsemester befinden
--2. diese Bachelorstudenten mssen sich im Erststudium und im 7. und 
--hheren Fachsemester befinden

create index tmp_ixstg1 on tmp_kenn_sos_stg(studiengang_nr);
create index tmp_ixstg2 on tmp_kenn_sos_stg(matrikel_nr, sem_rueck_beur_ein);
create index tmp_ixstg3 on tmp_kenn_sos_stg(fach_sem_zahl);
create index tmp_ixstg4 on tmp_kenn_sos_stg(abschluss_astat);


--welche Studis kommen in Frage?
create temp table tmp_switch(
sem_rueck_beur_ein integer,
matrikel_nr integer,
do_switch smallint
);

insert into tmp_switch(
sem_rueck_beur_ein ,
matrikel_nr ,
do_switch 
)
select distinct sem_rueck_beur_ein ,
matrikel_nr ,
0
from tmp_kenn_sos_stg
where studiengang_nr=1
and stufrm_ext='1' --Erststudium
and fach_sem_zahl >=7
and abschluss_astat in (select K.astat from kenn_abschl_astat K
where K.parent in ('A24')) --Bachelor
;
update tmp_switch set do_switch=1
where 0 < (select count(*) 
from tmp_kenn_sos_stg T
where T.matrikel_nr=tmp_switch.matrikel_nr
and T.sem_rueck_beur_ein=tmp_switch.sem_rueck_beur_ein
and T.fach_sem_zahl=1
and T.studiengang_nr=2
and abschluss_astat in (select K.astat from kenn_abschl_astat K
where K.parent in ('A37','A41')) --Master
);

delete from tmp_switch where do_switch=0;

insert into kenn_pruefrout (datum,tabelle_kenn,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_sos_stg'::char(18),'sos_stg_aggr'::char(18),('Der/die Studierende ' || T.matrikel_nr || ' wird im Semester ' || T.sem_rueck_beur_ein || ' im Studiengang Master auf 1 gesetzt, BA auf 2')::char(200), 'Info'::char(10) 
from tmp_kenn_sos_stg S, tmp_switch T
where T.matrikel_nr=S.matrikel_nr
and T.sem_rueck_beur_ein=S.sem_rueck_beur_ein
; 


update tmp_kenn_sos_stg set studiengang_nr=-1
where studiengang_nr=1
and 0<(select count(*) 
from tmp_switch T
where T.matrikel_nr=tmp_kenn_sos_stg.matrikel_nr
and T.sem_rueck_beur_ein=tmp_kenn_sos_stg.sem_rueck_beur_ein);

update tmp_kenn_sos_stg set studiengang_nr=1
where studiengang_nr=2
and 0<(select count(*) 
from tmp_switch T
where T.matrikel_nr=tmp_kenn_sos_stg.matrikel_nr
and T.sem_rueck_beur_ein=tmp_kenn_sos_stg.sem_rueck_beur_ein);

update tmp_kenn_sos_stg set studiengang_nr=2
where studiengang_nr=-1;

drop table tmp_switch;

</#if>

insert into kenn_sos_stg
( hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
       kz_rueck_beur_ein,
       fach_sem_zahl,
       hssem,
       stg,
       kz_fach,
       abschluss,
       regel,
       hzbart,
       stufrm,
       datum,
       extkotr,
       extkost,
       summe
       )
SELECT hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_rueck_beur_ein,
      kz_rueck_beur_ein,
      fach_sem_zahl,
      hssem,
       stg_astat,
       kz_fach_astat,
       abschluss_astat,
       regel,
       hzbart,
       stufrm_ext,
       datum,
       extkotr,
       extkost,
       sum(summe)
FROM tmp_kenn_sos_stg
 group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18;
 
insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'sos_stg'::char(18),'kenn_sos_stg'::char(18),('Es gibt ' || count(*)::integer || ' Flle, wo Studierende kein gltiges Geschlecht haben. ')::char(100), 'Info'::char(10) 
from kenn_sos_stg S 
where (geschlecht is null or geschlecht not in (1,2,3))  
and 0 < (select sum(summe) from tmp_kenn_sos_stg 
where (geschlecht is null or geschlecht not in (1,2,3)))
;  

update kenn_sos_stg set stg='0'||stg where length(stg)=3
and substring(stg from 1 for 1)  in ('0','1','2','3','4','5','6','7','8','9')
;

drop table tmp_kenn_sos_stg;

</#if>


<#if k_astat_studienfach_land_exists=1>
SELECT L.schluessel,
       L.land,
       null::char(10) as keybund,
       max(nvl(L.gueltig_bis,30001)) as gueltig_bis
   into temp tmp_stg
FROM k_astat_studienfach_land L, cif C
where L.land=C.apnr
and C.key=659 --Bundesland der Hochschule
group by 1,2,3;

update tmp_stg set keybund=(select distinct L.keybund
from k_astat_studienfach_land L
where L.schluessel=tmp_stg.schluessel
and L.land=tmp_stg.land
and (L.gueltig_bis=tmp_stg.gueltig_bis or (L.gueltig_bis is null and tmp_stg.gueltig_bis =30001))
);

update kenn_sos_stg set stg=(select K.keybund from tmp_stg K where (kenn_sos_stg.stg=K.schluessel or kenn_sos_stg.stg='0' || K.schluessel))
where 1=(select count(*) from tmp_stg K where kenn_sos_stg.stg=K.schluessel or kenn_sos_stg.stg='0' || K.schluessel);

update kenn_sos_stg set stg='0' || stg where length(trim(stg))=3;

drop table tmp_stg;
</#if>

