
--Freemarker Template 

<sqlvars>
<sqlvar name="sos_installed">
select count(*) from db_version where his_system ='sos';
</sqlvar>
--landesspezifika ermitteln: 5='nrw',14='Sachsen',8 'BaWue'
<sqlvar name="bland_kuerzel">
select 746::integer as kuerzel from cif where key=659 and apnr=5 
union
select 751::integer from cif where key=659 and apnr=14 
union
select 750::integer from cif where key=659 and apnr=8
union
select 750::integer from xdummy where 0=(
select count(*) from cif where key=659 and apnr in (5,8,14)) 
;
</sqlvar>
<sqlvar name="KENN_PROM_MAN_var">
select apnr from konstanten where beschreibung='KENN_PROM_MAN'
</sqlvar>
<sqlvar name = "k_astat_studienfach_land_exists">
SELECT sp_table_exists('k_astat_studienfach_land') FROM xdummy;
</sqlvar>
</sqlvars>

<#assign KENN_PROM_MAN=0 />
<#if KENN_PROM_MAN_var?exists && KENN_PROM_MAN_var?string?length &gt; 0>
<#assign KENN_PROM_MAN=KENN_PROM_MAN_var />
</#if>

<#if sos_installed=1>

delete from kenn_sos_lab where 0=
(select apnr from konstanten where beschreibung ='KENN_PRFUNG_ARCHIV');


delete from kenn_sos_lab
where sem_der_pruefung in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='PRFI')
;

create temp table tmp_kenn_sos_lab
( 
matrikel_nr integer,
hs_nr integer, 
studiengang_nr smallint, 
fach_nr smallint, 
geschlecht smallint,
ca12_staat smallint,
sem_der_pruefung smallint,
stg char(10),
stg_astat char(4),
fb char(10),
extkotr char(30),
extkost char(30),
kz_fach char(10),
kz_fach_astat char(1),
abschluss char(10),
abschluss_astat char(2),
fach_sem_zahl smallint,
hzbart char(10),
regel smallint,
fach_sem_zahl_rsz smallint,
stufrm char(10),
stufrm_ext char(10),
stuart  char(10),
stutyp char(10),
tid_stg integer,
datum date,
summe integer
) ;

insert into tmp_kenn_sos_lab
(matrikel_nr ,
hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_der_pruefung,
       stg,
       fb,
       kz_fach,
       abschluss,
       fach_sem_zahl,
       hzbart,
       regel,
       tid_stg,
       datum,
       summe)
select S.matrikel_nr ,
H.hs_nr,
       S.studiengang_nr,
       S.fach_nr,
       S.geschlecht,
       S.ca12_staat,
       S.sem_d_abg_pruefung,
       L.stg,
       L.fb,
       L.kz_fach,
       L.abschluss,
       S.fach_sem_zahl,
       S.hzbart,
       L.regel,
       S.tid_stg,
       today(),
       sum(summe)
from sos_lab_stg S, lehr_stg_ab L, hochschulinfo H, kenn_stichtag K
where S.sem_d_abg_pruefung = K.bezugszeit
and K.stichtagsart_id='PRFI'
and K.berechnen='1'
and S.stichtag =(select Y.tid from sos_stichtag Y where Y.stichtagsart='Prfungen' and Y.appl_key ='4')
and S.tid_stg = L.tid
and S.abschnitt=2
and S.pstatus='BE'
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;

--nur Sachsen:
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5)>


<#assign stufrm = ["stufrm", "stuart", "stutyp"] />
<#list stufrm as spalte>
  
  
  update tmp_kenn_sos_lab set ${spalte}=(
select min(S.${spalte}) from sos_stg_aggr S,sos_stichtag Y
where S.sem_rueck_beur_ein = tmp_kenn_sos_lab.sem_der_pruefung
and S.matrikel_nr = tmp_kenn_sos_lab.matrikel_nr
and S.studiengang_nr = tmp_kenn_sos_lab.studiengang_nr
and S.stichtag =Y.tid 
and Y.stichtagsart='Studierende'
and Y.appl_key ='1');
--wenn prfung nach letzten studierten Semester war, wird der erstbeste Wert genommen
update tmp_kenn_sos_lab set ${spalte}=(
select min(S.${spalte}) from sos_stg_aggr S,sos_stichtag Y
where 
--S.sem_rueck_beur_ein = tmp_kenn_sos_lab.sem_der_pruefung
--and 
S.matrikel_nr = tmp_kenn_sos_lab.matrikel_nr
and S.studiengang_nr = tmp_kenn_sos_lab.studiengang_nr
and S.stichtag =Y.tid 
and Y.stichtagsart='Studierende'
and Y.appl_key ='1')
where stufrm is null;
--analog fr stuart,stutyp

</#list>  

--Studienform ermitteln aus SOS Satz:


<#if KENN_STUFRM_WEITERB?exists && KENN_STUFRM_WEITERB != "">
update tmp_kenn_sos_lab set stufrm_ext='W' where 1=1 
and ${KENN_STUFRM_WEITERB}
;
</#if>

</#if>


-- BW
--RSZ:
--    1=in der RSZ
--    0=ber der RSZ
--   -1=RSZ ist unbekannt

-- NHS Sachsen
--RSZ:
--   -1=RSZ ist unbekannt
--    0=ber der RSZ (+4)
--    1=in der RSZ
--    2=RSZ +1
--    3=RSZ +2
--    4=RSZ +3   fach_sem_zahl = regel+3  z.B. fach_sem_zahl =8, Regel ist 5, dann true

update tmp_kenn_sos_lab set fach_sem_zahl_rsz=1 where fach_sem_zahl <= regel;
update tmp_kenn_sos_lab set fach_sem_zahl_rsz=0 where fach_sem_zahl > regel;
update tmp_kenn_sos_lab set fach_sem_zahl_rsz=-1 where fach_sem_zahl_rsz is null;

--nur BW:
--<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL=1 || K_KENN_PROFIL=2 ||K_KENN_PROFIL=3)>
--</#if>

--nur Sachsen:
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5)>
update tmp_kenn_sos_lab set fach_sem_zahl_rsz=2 where fach_sem_zahl = regel + 1;
update tmp_kenn_sos_lab set fach_sem_zahl_rsz=3 where fach_sem_zahl = regel + 2;
update tmp_kenn_sos_lab set fach_sem_zahl_rsz=4 where fach_sem_zahl = regel + 3;
</#if>

<#if  KENN_PROM_MAN=1 >
--Promotionen aus manueller Schnittstelle dazuholen:
--PROM_SEM Promotionen (semesterweise)
insert into tmp_kenn_sos_lab
(hs_nr,
       studiengang_nr,
       fach_nr,
       sem_der_pruefung,
       stg,
       kz_fach,
       abschluss_astat,
       datum,
       geschlecht ,
ca12_staat,
       summe)
select W.hs_nr,
1::smallint,
1::smallint,
W.sem,
K.stug_fach,
'H'::char(2),
'06'::char(2),
today(),
W.geschlecht ,
W.ca12_staat,
sum(W.wert)
from kenn_zahl_wert W left outer join kenn_stug K
on (W.stugkey=K.stug_key)
where W.kenn_zahl in ('PROM_SEM')
and W.sem in (select S.bezugszeit
from kenn_stichtag S
where S.berechnen='1'
and S.stichtagsart_id='PRFI')
group by 1,2,3,4,5,6,7,8,9,10
;
</#if>


 --Amtliche Fcher und Abschlsse
update tmp_kenn_sos_lab set stg_astat=(select min(astat) from k_stg K 
where K.refstg=tmp_kenn_sos_lab.stg and K.astat is not null);
--manche HSen pflegen die amtlichen Fcher in Abhngigkeit vom Abschluss:
update tmp_kenn_sos_lab set stg_astat=(select min(astat2) from k_abstgv K 
where K.stg=tmp_kenn_sos_lab.stg and K.abschl=tmp_kenn_sos_lab.abschluss and K.astat2 is not null)
where stg_astat is null;
update tmp_kenn_sos_lab set kz_fach_astat=(select astat from sos_k_kzfa K where K.apnr=tmp_kenn_sos_lab.kz_fach);
update tmp_kenn_sos_lab set abschluss_astat=(select astat from k_abint K where K.abint=tmp_kenn_sos_lab.abschluss) where abschluss is not null;

--Umschlsselung Fach ggf. von Landes- auf Bundesschlssel:
update tmp_kenn_sos_lab set stg_astat=(select min(C.bund_apnr)
from sos_cifx C
where C.key=${bland_kuerzel}
and C.apnr=tmp_kenn_sos_lab.stg_astat)
where ${bland_kuerzel} in (746, 751) --nur Sachsen und NRW
;

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'k_stg'::char(18),'Das Studienfach ' || trim(S.stg) || ' hat keinen gltigen ASTAT-Wert (Bund)'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_lab S left outer join kenn_stg_astat A on (S.stg_astat=A.astat)  
where (A.astat is null or S.stg_astat is null) ;  




insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'k_abint'::char(18),'Der Abschluss ' || trim(S.abschluss) || ' hat keinen gltigen ASTAT-Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_lab S left outer join kenn_abschl_astat A on (S.abschluss_astat=A.astat)  
where A.astat is null ;

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sos_k_kzfa'::char(18),'Das Fachkennzeichen ' || trim(S.kz_fach) || ' hat keinen gltigen HIS_KZFA-Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_lab S left outer join sos_k_kzfa A on (S.kz_fach_astat=A.astat)  
where A.astat is null ;  

update tmp_kenn_sos_lab set kz_fach_astat='U' where kz_fach_astat is null;

--nur Sachsen:
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5)>

update tmp_kenn_sos_lab set extkost=fb;

<#if KENN_STUD_MED?exists && KENN_STUD_MED != "">
--Medizin. Fakultt lschen:
delete from tmp_kenn_sos_lab 
where extkost in ('${KENN_STUD_MED}');
;
</#if>

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'lehr_stg_ab'::char(18),'Das Studienfach ' || trim(S.stg) || ' hat keine Fakultt'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_lab S 
where S.extkost is null ; 

update tmp_kenn_sos_lab set extkotr=(select min(K.extkotr)
from kenn_extkotr_stg K
where K.stg=tmp_kenn_sos_lab.stg)
where extkotr is null;

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_extkotr_stg'::char(18),'Das Studienfach ' || trim(string_not_null(S.stg)) || ' hat keinen externen Produktschlssel'::char(100), 'Warnung'::char(10) 
from tmp_kenn_sos_lab S 
where S.extkotr is null ; 

</#if>

insert into kenn_sos_lab
( hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_der_pruefung,
       stg,
       kz_fach,
       abschluss,
       fach_sem_zahl,
       hzbart,
       regel,
       extkost,
       extkotr,
       stufrm,
       datum,
       summe
       )
SELECT hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_der_pruefung,
       stg_astat,
       kz_fach_astat,
       abschluss_astat,
       fach_sem_zahl,
       hzbart,
       fach_sem_zahl_rsz,
       extkost,
       extkotr,
       stufrm_ext,
       today(),
       sum(summe)
FROM tmp_kenn_sos_lab
 group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;
 
 
insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'sos_lab'::char(18),'kenn_sos_lab'::char(18),('Es gibt ' || count(*)::integer || ' Flle, wo Absolventen kein gltiges Geschlecht haben. ')::char(100), 'Info'::char(10) 
from kenn_sos_lab S 
where (geschlecht is null or geschlecht not in (1,2,3))  
and 0 < (select sum(summe) from tmp_kenn_sos_lab 
where (geschlecht is null or geschlecht not in (1,2,3)))
;  
update kenn_sos_lab set stg='0'||stg where length(stg)=3
and substring(stg from 1 for 1)  in ('0','1','2','3','4','5','6','7','8','9')
;

drop table tmp_kenn_sos_lab;

</#if>



<#if k_astat_studienfach_land_exists=1>
SELECT L.schluessel,
       L.land,
       null::char(10) as keybund,
       max(nvl(L.gueltig_bis,30001)) as gueltig_bis
   into temp tmp_stg
FROM k_astat_studienfach_land L, cif C
where L.land=C.apnr
and C.key=659 --Bundesland der Hochschule
group by 1,2,3;

update tmp_stg set keybund=(select distinct L.keybund
from k_astat_studienfach_land L
where L.schluessel=tmp_stg.schluessel
and L.land=tmp_stg.land
and (L.gueltig_bis=tmp_stg.gueltig_bis or (L.gueltig_bis is null and tmp_stg.gueltig_bis =30001))
);

update kenn_sos_lab set stg=(select K.keybund from tmp_stg K where (kenn_sos_lab.stg=K.schluessel or kenn_sos_lab.stg='0' || K.schluessel))
where 1=(select count(*) from tmp_stg K where kenn_sos_lab.stg=K.schluessel or kenn_sos_lab.stg='0' || K.schluessel);

update kenn_sos_lab set stg='0' || stg where length(trim(stg))=3;

drop table tmp_stg;
</#if>