
--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="koa_block" type="hashsequence">
select apnr,druck,gruppe from kenn_cifx 
where  key=684 
 ;
 
</sqlvar>

</sqlvars>  

<#if SQLdialect='Postgres'>

truncate table kenn_skosten_cube;

<#else>

delete from kenn_skosten_cube;

</#if>

CREATE temp TABLE tmp_vtbu_cube (
    hs_nr integer,
    jahr smallint,
    quartal integer,
    produkt char(10),
    projnr character(10),
    ziel_stug  character(20),
    prim_sek character(10),
    kokl char(1),
    ziel_fikrkey CHAR(12),
    koa_block char(10),
    betrag double precision
);


--Sekundrkosten zuerst temp. zwischenspeichern:

insert into tmp_vtbu_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       ziel_stug,
       prim_sek,
       kokl,
       ziel_fikrkey,
       betrag)
select
hs_nr,
       jahr,
       val(substring('' || quartal from 5 for 1)),
       vari,
       ziel_projnr,
       ziel_stug,
       'S', --Sek.Kosten
       kokl,
       ziel_fikrkey,
       sum(betrag)
FROM kenn_vtbu_aggr
where (ziel_projnr is not null or ziel_stug is not null)
--and jahr=2017
group by 1,2,3,4,5,6,7,8,9;

insert into tmp_vtbu_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       kokl,
       betrag)
select
hs_nr,
       jahr,
       val(substring('' || quartal from 5 for 1)),
       'Q',
       ziel_projnr,
       'S',
       'K',
       sum(betrag)
FROM kenn_vtbu_qp_aggr
where ziel_projnr is not null
--and jahr=2017
group by 1,2,3,4,5,6,7;

--Kosten der Lehre aus stug

update tmp_vtbu_cube set projnr=(select min(ST.k_extkotr) from kenn_stug ST
where tmp_vtbu_cube.ziel_stug=ST.stug_key
and ST.hs_nr=tmp_vtbu_cube.hs_nr
and length(trim(ST.k_extkotr))>2)
where projnr is null
and produkt in ('L','A');

--in produkt steht A,L,F oder D
--Kosten auf Verteilschritt Lehre, aber KoTr 01/11 machen keinen Sinn:
--Sekundrkosten Lehre:
--zuerst alle ohne KoA-Block:
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       '_S',
       sum(betrag)
FROM tmp_vtbu_cube
where produkt ='L'
and kokl='K'
and (ziel_fikrkey is null or ziel_fikrkey not in (
<#foreach block in koa_block>
'${block.apnr}',
</#foreach>
'_-1')) --nur ein Dummy
and (projnr like '01%' or projnr like '11%') 
group by 1,2,3,4,5,6,7;

--dann KoA-Blcke:
<#foreach block in koa_block>
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       'S'::char(10),
       '${block.apnr}'::char(10),
       sum(betrag)
FROM tmp_vtbu_cube
where produkt ='L'
and kokl='K'
and ziel_fikrkey ='${block.apnr}'
and (projnr like '01%' or projnr like '11%') 
group by 1,2,3,4,5;
</#foreach>


--Sekundrerlse Lehre ohne Studiengebhren:
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       'E',
       '_ERL',
       sum(betrag)
FROM tmp_vtbu_cube
where produkt ='L'
and kokl='E'
and (ziel_fikrkey is null or ziel_fikrkey != '_ERL_STUD')
and (projnr like '01%' or projnr like '11%') 
group by 1,2,3,4,5,6,7;
--Sekundrerlse Lehre  Studiengebhren:
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       'E'::char(4),
       ziel_fikrkey,
       sum(betrag)
FROM tmp_vtbu_cube
where produkt ='L'
and kokl='E'
and (ziel_fikrkey = '_ERL_STUD')
and (projnr like '01%' or projnr like '11%') 
group by 1,2,3,4,5,6,7;

--angebotsorientiert
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       'S'::char(2),
       '_S',
       sum(betrag)
FROM tmp_vtbu_cube
where produkt='A'
and (projnr like '01%' or projnr like '11%') 
group by 1,2,3,4,5;

--Sekundrkosten Forschung:
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       'S' as prim_sek,
       '_S'  as koa_block,
       sum(betrag)
FROM tmp_vtbu_cube
where produkt='F'
and kokl='K'
and projnr like '03%' 
and (ziel_fikrkey is null or ziel_fikrkey not in (
<#foreach block in koa_block>
'${block.apnr}',
</#foreach>
'_-1')) --nur ein Dummy
group by 1,2,3,4,5,6,7;

--dann KoA-Blcke:
<#foreach block in koa_block>
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       'S' as prim_sek,
       ziel_fikrkey,
       sum(betrag)
FROM tmp_vtbu_cube
where produkt ='F'
and kokl='K'
and ziel_fikrkey ='${block.apnr}'
and projnr like '03%' 
group by 1,2,3,4,5,6,7;

</#foreach>

--Sekundrkosten sonst. Dienstl.:
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       'S' as prim_sek,
       '_S' as koa_block,
       sum(betrag)
FROM tmp_vtbu_cube
where produkt='D'
and kokl='K'
and projnr like '05%'
and (ziel_fikrkey is null or ziel_fikrkey not in (
<#foreach block in koa_block>
'${block.apnr}',
</#foreach>
'_-1')) --nur ein Dummy
group by 1,2,3,4,5,6,7;

--dann KoA-Blcke:
<#foreach block in koa_block>
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       'S' as prim_sek,
       ziel_fikrkey as koa_block,
       sum(betrag)
FROM tmp_vtbu_cube
where produkt ='D'
and kokl='K'
and ziel_fikrkey ='${block.apnr}'
and projnr like '05%' 
group by 1,2,3,4,5,6,7;

</#foreach>

--Primrkosten Lehre sind laut Fachkonzept nicht gewnscht
--Primrkosten Forschung:

insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       val(substring('' || quartal from 5 for 1)),
       'F' as produkt,
       projnr,
       'P' as prim_sek,
       '_S' as koa_block,
       sum(kokl_faktor*betrag)
FROM kenn_busa_aggr
where kokl_faktor=1
and projnr is not null
and projnr like '03%'
and bvkr_art is not null and inst_art is not null
group by 1,2,3,4,5,6,7;

--Primrkosten sonst. dienstl.:

insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       val(substring('' || quartal from 5 for 1)),
       'D' as produkt,
       projnr,
       'P' as prim_sek,
       '_S' as koa_block,
       sum(kokl_faktor*betrag)
FROM kenn_busa_aggr
where kokl_faktor=1
and projnr is not null
and projnr like '05%'
and bvkr_art is not null and inst_art is not null
group by 1,2,3,4,5,6,7;

--Primrerlse ab 0.2rc8 nicht mehr gewnscht:

-- insert into kenn_skosten_cube(
-- hs_nr,
       -- jahr,
       -- quartal,
       -- projnr,
       -- prim_sek,
       -- betrag)
-- select
-- hs_nr,
       -- jahr,
       -- val(substring(quartal from 5 for 1)),
       -- projnr,
       -- 'E'::char(1),
       -- sum(kokl_faktor*betrag)
-- FROM kenn_busa_aggr
-- where kokl_faktor=-1
-- and projnr is not null
-- and bvkr_art is not null and inst_art is not null
-- group by 1,2,3,4,5;

--neu ab 05-2015: Querschnittsprodukte
insert into kenn_skosten_cube(
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       koa_block,
       betrag)
select
hs_nr,
       jahr,
       quartal,
       produkt,
       projnr,
       prim_sek,
       '_S' as koa_block,
       sum(betrag)
FROM tmp_vtbu_cube
where produkt ='QP'
and kokl='K'
group by 1,2,3,4,5,6,7;

drop TABLE tmp_vtbu_cube;
