--Freemarker Template 
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="sva_installed">
select count(*) from db_version where his_system ='sva';
</sqlvar>

<sqlvar name="adbz_bez" type="hashsequence">
	select id,content,art2 from sx_repository where art='KENN_STBB_ADBZ' and aktiv=1;
</sqlvar>
<sqlvar name="bvl_bez" type="hashsequence">
	select id,content,art2 from sx_repository where art='KENN_STBB_BVL' and aktiv=1;
</sqlvar>
<sqlvar name="titel_bez" type="hashsequence">
	select id,content,art2 from sx_repository where art='KENN_STBB_TITEL' and aktiv=1;
</sqlvar>

</sqlvars> 

<#if sva_installed=1>



delete from kenn_sgd_aggr where 0=
(select apnr from konstanten where beschreibung ='KENN_STELLEN_ARCHIV');


create temp table tmp_sgd_einz (
stellen_nr integer,
sbst_nr integer,
ch110_besch_st char(10),
bund_fachgebiet char(10),
ca107_dienstart char(10),
buadbz char(10),
stichtag date,
faktor float,
ca259_kategorie char(10),
kapitel char(10),
titel CHAR(5) , 
ca109_key_bvl char(10),
bund_bvl_stelle CHAR(10) , 
ca115_haushverm char(10),
hhv SMALLINT , 
kategorie_gruppe SMALLINT,
plan smallint,
leer smallint,
haushalt_nr char(20)
);


create temp table tmp_sgd_aggr (
hs_nr integer,
stellen_nr integer,
sbst_nr integer,
ch110_besch_st char(10),
bund_fachgebiet char(10),
ca107_dienstart char(10),
bund_dienstart SMALLINT,
faktor float,
buadbz char(10),
adbz_land char(10),
bvl_stelle_kurz varchar(255),
besetzung char(1),
ca108_amtsbez char(10),
vzae_besetzung float,
vzae_besetzung_beamt float,
vzae_besetzung_besch float,
vzae_besetzung_uw float,
koepfe_besetzung float, 
buadbz_besetzung char(10),
da_besetzung SMALLINT,
taet_besetzung SMALLINT,
stichtag date,
datum date,
zaehlung char(1),
summe float,
ca259_kategorie char(10),
kapitel char(10),
kapitel_land char(10),
titel CHAR(5) , 
titel_land CHAR(5) , 
ca109_key_bvl char(10),
bund_bvl_stelle CHAR(10) , 
kennzeichen char(4),
hhv SMALLINT , 
kategorie_gruppe SMALLINT ,
haushalt_nr char(20)
);

create temp table tmp_pbe_aggr (
stichtag date,
stellen_nr integer,
soe_serial integer,
pbe_serial integer,
personal_nr integer,
besch_verh_nr integer,
ch110_besch_st_p char(20),
kostenstelle char(10),
vzae_besetzung float,
koepfe_besetzung float,
ca107_dienstart char(10),
ca108_amtsbez char(10),
vertart char(10),
da_besetzung smallint,
taet_besetzung smallint,
pbe_prozent float,
buadbz_besetzung char(10),
abw_besetzt SMALLINT,
vertart_besetzung smallint
);

create temp table tmp_pbe_aggr_dup (
stichtag date,
stellen_nr integer,
soe_serial integer,
pbe_serial integer,
personal_nr integer,
besch_verh_nr integer,
ch110_besch_st_p char(20),
kostenstelle char(10),
vzae float,
ca107_dienstart char(10),
ca108_amtsbez char(10),
vertart char(10),
da_besetzung smallint,
taet_besetzung smallint,
pbe_prozent float,
buadbz_besetzung char(10),
abw_besetzt SMALLINT,
vertart_besetzung smallint
);
--Zuerst einzelne Stellen, wg. Duplikaten
insert into tmp_sgd_einz (stellen_nr,
sbst_nr,
ch110_besch_st,
ca107_dienstart,
faktor,
buadbz,
stichtag,
ca259_kategorie,
kapitel,
titel, 
ca109_key_bvl ,
plan,
leer,
haushalt_nr
)
select distinct stellen_nr,
sbst_nr,
ch110_besch_st,
ca107_dienstart,
faktor,
buadbz,
S.stichtag,
A.ca259_kategorie,
A.kapitel,
A.titel, 
A.ca109_key_bvl ,
A.plan,
A.leer,
A.haushalt_nr
from sva_inst I,sva_sgd_aggr A, kenn_stichtag S
where 
--year(today())=year(S.stichtag)
S.stichtag between d_gueltig_anfang and d_gueltig_ende
and S.stichtagsart_id='STLI'
and S.berechnen='1'
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL=1 || K_KENN_PROFIL=2 ||K_KENN_PROFIL=3)>
--nur BaWue
--Filter auf plan
and A.plan=1
</#if>
and I.key_apnr=A.ch110_besch_st
and S.stichtag between I.gueltig_seit and I.gueltig_bis
;
--Umschlsselung plan/leer Plan=1, Leer=2
update tmp_sgd_einz set kategorie_gruppe=1
where plan=1;
update tmp_sgd_einz set kategorie_gruppe=2
where leer=1;

--Umschlsselung HHV:
--1=KW, 2=Staubsaugervermerk (derzeit noch ungeklrt)
update tmp_sgd_einz set hhv=1 
where 0 < (select count(*) from sva_sgd_aggr H, sva_cifx K
where H.ca115_haushverm=K.apnr
and K.key=115
and H.stellen_nr=tmp_sgd_einz.stellen_nr
and tmp_sgd_einz.stichtag between H.d_gueltig_anfang and H.d_gueltig_ende
and K.his_system_key='KW')
;

--VZAE
insert into tmp_sgd_aggr (hs_nr,
stellen_nr,
sbst_nr,
ch110_besch_st,
ca107_dienstart,
--faktor,
buadbz,
besetzung,
stichtag,
datum,
zaehlung,
ca259_kategorie,
kapitel,
titel, 
ca109_key_bvl ,
hhv,
kategorie_gruppe,
haushalt_nr,
summe)
select H.hs_nr,
stellen_nr,
sbst_nr,
ch110_besch_st,
ca107_dienstart,
--faktor,9
buadbz,
'N'::char(1),
S.stichtag,
today(),
'v'::char(1),
ca259_kategorie,
S.kapitel,
titel, 
ca109_key_bvl ,
hhv,
kategorie_gruppe,
haushalt_nr,
sum(faktor)
from tmp_sgd_einz S, hochschulinfo H
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17;

update tmp_sgd_aggr set bund_fachgebiet=(select bund_fachgebiet from sva_inst where key_apnr=tmp_sgd_aggr.ch110_besch_st)
;
update tmp_sgd_aggr set bund_dienstart=(select val(bund_dienstart) from sva_k_dienstart where apnr=tmp_sgd_aggr.ca107_dienstart)
;
update tmp_sgd_aggr set bund_bvl_stelle=(select bund_bvlgruppe 
from sva_k_bvlgruppe where apnr=tmp_sgd_aggr.ca109_key_bvl)
;
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>
--nur NHS Sachsen:

--Kurztext des ASTAT wird fr NHS / Sachsen bentigt:
update tmp_sgd_aggr set bvl_stelle_kurz=(select C.kurz
from cifx C 
where C.key=649 
and C.apnr=tmp_sgd_aggr.bund_bvl_stelle);



--Besonderheiten:
<#if bvl_bez?has_content>
<#foreach bvl in bvl_bez>
<@addcomment comment="Transformation BVL Repo-Variable id=" + bvl.id /> 

	update tmp_sgd_aggr set bvl_stelle_kurz='${bvl.art2}' where ${bvl.content}; 
</#foreach>
</#if>

<#if adbz_bez?has_content>
<#foreach ab in adbz_bez>
<@addcomment comment="Transformation ADBZ Repo-Variable id=" + ab.id /> 

	update tmp_sgd_aggr set adbz_land='${ab.art2}' where ${ab.content}; 
</#foreach>
</#if>

--Kapitel 1207 Titel 68556 zum Zukunftsvertrag etc.
<#assign kap1207_titel="'-9x'" />
<#if titel_bez?has_content>
<#foreach ab in titel_bez>
<@addcomment comment="Transformation Titel Repo-Variable id=" + ab.id /> 

	update tmp_sgd_aggr set kapitel_land='1207',
	kategorie_gruppe=1,
	titel_land='${ab.art2}' where ${ab.content}; 

<#assign kap1207_titel=kap1207_titel+",'"+ab.art2?trim+"'" />
</#foreach>
</#if>


update tmp_sgd_aggr set titel_land='68502' where titel_land not in (${kap1207_titel}) or titel_land is null; 
update tmp_sgd_aggr set kapitel_land=K.kapitel 
from kenn_stbb_kap_titel_bericht K
where K.hs_nr=tmp_sgd_aggr.hs_nr
and tmp_sgd_aggr.kapitel_land is null
and K.berichtsname_key='0-0' --Hochschul-Kapitel
; 


</#if>

--Besetzte Stellen
--zunchst Duplikate aufgrund von HHV rausfischen mit distinct:
insert into tmp_pbe_aggr_dup (stichtag,
stellen_nr,
soe_serial,
pbe_serial,
personal_nr ,
besch_verh_nr ,
ch110_besch_st_p ,
kostenstelle ,
pbe_prozent,
abw_besetzt,
vertart,
vzae
)
select distinct S.stichtag,
B.stellen_nr,
B.soe_serial ,
B.pbe_serial,
B.personal_nr,
B.besch_verh_nr,
ch110_besch_st_p ,
kostenstelle ,
prozent,
0, --1 wre unterbesetzt, 0 = default
B.vertart,
B.prozent/100
from sva_pbe_aggr B, kenn_stichtag S 
where 
 S.stichtag between B.d_besetz_anfang and B.d_besetz_ende
 and S.stichtagsart_id='STLI'
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL=1 || K_KENN_PROFIL=2 ||K_KENN_PROFIL=3)>
--nur BaWue: nur echte Besetzungen, keine Mittelschpfungen
and B.personal_nr is not null
</#if>
 and ${SVA_PBE_AGGR_BESETZ}
;

insert into tmp_pbe_aggr (stichtag,
stellen_nr,
soe_serial,
pbe_serial,
personal_nr ,
besch_verh_nr ,
ch110_besch_st_p ,
kostenstelle ,
pbe_prozent,
abw_besetzt,
vertart,
vzae_besetzung,
koepfe_besetzung 
)
select B.stichtag,
B.stellen_nr,
B.soe_serial ,
B.pbe_serial,
B.personal_nr,
B.besch_verh_nr,
B.ch110_besch_st_p ,
B.kostenstelle ,
B.pbe_prozent,
B.abw_besetzt,
B.vertart,
sum(B.vzae),
count(distinct B.personal_nr)  --eigentlich Unsinn, muss immer 1 sein
from tmp_pbe_aggr_dup B
group by 1,2,3,4,5,6,7,8,9,10,11;



--Unterbesetzte Stellen

update tmp_pbe_aggr set abw_besetzt=1
where 0 < (select count(*) 
from sva_pbe_aggr B, kenn_stichtag S 
where 
 S.stichtag between B.d_besetz_anfang and B.d_besetz_ende
 and S.stichtagsart_id='STLI'
 and B.pbe_serial=tmp_pbe_aggr.pbe_serial
 and S.stichtag=tmp_pbe_aggr.stichtag
 and ${SVA_PBE_AGGR_BESETZ}
 and ${SVA_unterbesetzt}
 );




-- update tmp_pbe_aggr set vzae_besetzung=pbe_prozent /100 * (select sum(B.vzae) from sva_pbv_aggr B 
-- where B.personal_nr=tmp_pbe_aggr.personal_nr
 -- and B.besch_verh_nr=tmp_pbe_aggr.besch_verh_nr
 -- and tmp_pbe_aggr.stichtag between B.d_besch_von and B.d_besch_bis
 -- and B.ch110_besch_st=tmp_pbe_aggr.ch110_besch_st_p
 -- and (B.kostenstelle=tmp_pbe_aggr.kostenstelle
-- or (B.kostenstelle is null and tmp_pbe_aggr.kostenstelle is null))
-- )
-- ;

update tmp_pbe_aggr set ca107_dienstart=(select min(B.ca107_dienstart) from sva_pbv_aggr B 
where B.personal_nr=tmp_pbe_aggr.personal_nr
 and B.besch_verh_nr=tmp_pbe_aggr.besch_verh_nr
 and tmp_pbe_aggr.stichtag between B.d_besch_von and B.d_besch_bis
 and B.ch110_besch_st=tmp_pbe_aggr.ch110_besch_st_p
 and (B.kostenstelle=tmp_pbe_aggr.kostenstelle
or (B.kostenstelle is null and tmp_pbe_aggr.kostenstelle is null))
)
;
update tmp_pbe_aggr set ca108_amtsbez=(select min(B.ca108_amtsbez) from sva_pbv_aggr B 
where B.personal_nr=tmp_pbe_aggr.personal_nr
 and B.besch_verh_nr=tmp_pbe_aggr.besch_verh_nr
 and tmp_pbe_aggr.stichtag between B.d_besch_von and B.d_besch_bis
 and B.ch110_besch_st=tmp_pbe_aggr.ch110_besch_st_p
 and (B.kostenstelle=tmp_pbe_aggr.kostenstelle
or (B.kostenstelle is null and tmp_pbe_aggr.kostenstelle is null))
)
;
--Beamte ermitteln:
update tmp_pbe_aggr set vertart_besetzung=1
where vertart in (select apnr from sva_k_vertrag_ang V
where V.parent='_B')
;
--Angestellte
update tmp_pbe_aggr set vertart_besetzung=2
where vertart in (select apnr from sva_k_vertrag_ang V
where V.parent='_A')
;
--Sonstige
update tmp_pbe_aggr set vertart_besetzung=3
where vertart is null
;
update tmp_pbe_aggr set vertart_besetzung=3
where vertart_besetzung is null
;


 
update tmp_pbe_aggr set da_besetzung=(select val(bund_dienstart) from sva_k_dienstart where apnr=tmp_pbe_aggr.ca107_dienstart);
update tmp_pbe_aggr set taet_besetzung=(select val(bund_taetigkeit) from sva_k_vertragsart where apnr=tmp_pbe_aggr.vertart);
update tmp_pbe_aggr set buadbz_besetzung=(select bund_adbz from sva_k_amtsdienst where apnr=tmp_pbe_aggr.ca108_amtsbez);



update tmp_sgd_aggr set besetzung='J' 
where stellen_nr in (select A.stellen_nr from tmp_pbe_aggr A
where A.stichtag=tmp_sgd_aggr.stichtag);

update tmp_sgd_aggr set da_besetzung=(select min(A.da_besetzung) from tmp_pbe_aggr A
where A.stichtag=tmp_sgd_aggr.stichtag
and A.stellen_nr=tmp_sgd_aggr.stellen_nr
and (A.soe_serial=tmp_sgd_aggr.sbst_nr or A.soe_serial is null));

update tmp_sgd_aggr set taet_besetzung=(select min(A.taet_besetzung) from tmp_pbe_aggr A
where A.stichtag=tmp_sgd_aggr.stichtag
and A.stellen_nr=tmp_sgd_aggr.stellen_nr
and (A.soe_serial=tmp_sgd_aggr.sbst_nr or A.soe_serial is null));

update tmp_sgd_aggr set buadbz_besetzung=(select min(A.buadbz_besetzung) from tmp_pbe_aggr A
where A.stichtag=tmp_sgd_aggr.stichtag
and A.stellen_nr=tmp_sgd_aggr.stellen_nr
and (A.soe_serial=tmp_sgd_aggr.sbst_nr or A.soe_serial is null));

update tmp_sgd_aggr set vzae_besetzung=(select sum( A.vzae_besetzung) from tmp_pbe_aggr A
where A.stichtag=tmp_sgd_aggr.stichtag
and A.stellen_nr=tmp_sgd_aggr.stellen_nr
and (A.soe_serial=tmp_sgd_aggr.sbst_nr or A.soe_serial is null));

update tmp_sgd_aggr set vzae_besetzung_beamt=(select sum( A.vzae_besetzung) from tmp_pbe_aggr A
where A.stichtag=tmp_sgd_aggr.stichtag
and A.stellen_nr=tmp_sgd_aggr.stellen_nr
and (A.soe_serial=tmp_sgd_aggr.sbst_nr or A.soe_serial is null)
and A.vertart_besetzung=1);

update tmp_sgd_aggr set vzae_besetzung_besch=(select sum( A.vzae_besetzung) from tmp_pbe_aggr A
where A.stichtag=tmp_sgd_aggr.stichtag
and A.stellen_nr=tmp_sgd_aggr.stellen_nr
and (A.soe_serial=tmp_sgd_aggr.sbst_nr or A.soe_serial is null)
and A.vertart_besetzung in (2,3));


update tmp_sgd_aggr set vzae_besetzung_uw=(select sum( A.vzae_besetzung) from tmp_pbe_aggr A
where A.stichtag=tmp_sgd_aggr.stichtag
and A.stellen_nr=tmp_sgd_aggr.stellen_nr
and (A.soe_serial=tmp_sgd_aggr.sbst_nr or A.soe_serial is null)
and A.abw_besetzt=1);


update tmp_sgd_aggr set koepfe_besetzung=(select count(distinct A.personal_nr) from tmp_pbe_aggr A
where A.stichtag=tmp_sgd_aggr.stichtag
and A.stellen_nr=tmp_sgd_aggr.stellen_nr
and (A.soe_serial=tmp_sgd_aggr.sbst_nr or A.soe_serial is null));

update tmp_sgd_aggr set titel='68502' 
where titel is null;

insert into kenn_pruefrout (datum,gueltig_von,gueltig_bis,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),stichtag,stichtag,'sva_pfi,sva_poz'::char(20),'kenn_sgd_aggr'::char(18),('Bei der Stelle ' || stellen_nr || ' ist die VZAE-Zahl der Besetzung grer als die der Stelle, vermutlich ist pfi_prozent oder pbe_anteil falsch gesetzt.')::char(240), 'Warnung'::char(10) 
from tmp_sgd_aggr 
where vzae_besetzung > summe
and zaehlung='v';  

--Inst definiert:
insert into kenn_pruefrout (datum,gueltig_von,gueltig_bis,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),S.stichtag,S.stichtag,'sva_soe'::char(20),'kenn_sgd_aggr'::char(18),('Bei der Stelle ' || A.stellen_nr || ' ist die Inst. ' || trim(A.ch110_besch_st)  || ' unbekannt')::char(240), 'Warnung'::char(10) 
  from kenn_stichtag S, sva_sgd_aggr A left outer join sva_inst I
on (I.key_apnr=A.ch110_besch_st)
where 
--year(today())=year(S.stichtag)
S.stichtag between d_gueltig_anfang and d_gueltig_ende
and S.stichtagsart_id='STLI'
and S.berechnen='1'
and A.plan=1
and I.key_apnr is null;

--Lschung vorh. Stichtage:
delete from kenn_sgd_aggr
where stichtag in (select distinct stichtag
from tmp_sgd_aggr)
;

insert into kenn_sgd_aggr (bund_fachgebiet,
bund_dienstart,
faktor,
buadbz,
besetzung,
buadbz_besetzung,
bvl_stelle_kurz,
adbz_land,
taet_besetzung,
da_besetzung,
stichtag,
datum,
zaehlung,
kapitel,
titel , 
bund_bvl_stelle , 
hhv  , 
kategorie_gruppe,
vzae_besetzung,
vzae_besetzung_beamt,
vzae_besetzung_besch,
vzae_besetzung_uw,
koepfe_besetzung,
summe)
select bund_fachgebiet,
bund_dienstart,
faktor,
buadbz,
besetzung,
buadbz_besetzung,
bvl_stelle_kurz,
adbz_land,
taet_besetzung,
da_besetzung,
stichtag,
datum,
zaehlung,
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>
--nur NHS Sachsen:
kapitel_land,
titel_land , 
bund_bvl_stelle , 
hhv  , 
kategorie_gruppe,
<#else>
null::char(10) , --kapitel,
null::char(10), --titel , 
null::char(10),--bund_bvl_stelle , 
null::smallint,--hhv  , 
null::smallint,--kategorie_gruppe,
</#if>
sum(vzae_besetzung),
sum(vzae_besetzung_beamt),
sum(vzae_besetzung_besch),
sum(vzae_besetzung_uw),
sum(koepfe_besetzung),
sum(summe)
from tmp_sgd_aggr
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18;

delete from kenn_stelle_hhpl
where jahr_von in (select K.bezugszeit from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='STHP'
        and K.bezugsart='J'
        )
	or jahr_von is null
;

INSERT INTO kenn_stelle_hhpl
(
  
  hs_nr,
  kapitel,
  titel,
  bvl_stelle_kurz,
  adbz_land,
  jahr_von,
  jahr_bis,
  datum,
  summe
)
select 
	T.hs_nr,
	T.kapitel_land,
	T.titel_land,
	T.bvl_stelle_kurz,
	T.adbz_land,
	min(year(T.stichtag)),
	max(year(T.stichtag)),
	today(),
	sum(T.summe)
from tmp_sgd_aggr T,kenn_stichtag K
where T.stichtag=K.stichtag
and K.berechnen='1'
        and K.stichtagsart_id='STHP'
        and K.bezugsart='J'
	and K.bezugszeit=year(T.stichtag)
	and month(T.stichtag)=1
	and T.kategorie_gruppe=1 --Plan
	group by 1,2,3,4,5,8
	having sum(T.summe) >0
;
	

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sva_inst'::char(18),('Institution ' || trim(ch110_besch_st) ||' im Bereich Stellen ist nicht dem Bundesschlssel des Fachgebiets zugeordnet !')::char(200), 'Warnung'::char(10) 
from tmp_sgd_aggr 
where bund_fachgebiet is null; 

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sva_inst'::char(18),('Bund-Fachgebiet-Schlssel ' || trim(B.bund_fachgebiet)  
||' im Bereich Stellen ist unbekannt !')::char(200), 'Warnung'::char(10) 
from kenn_sgd_aggr B  left outer join kenn_lfb_fg L
on (B.bund_fachgebiet=L.apnr)
where L.apnr  is null
and B.bund_fachgebiet is not null;

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sva_k_dienstart'::char(18),('Dienstart ' || trim(ca107_dienstart) || ' im Bereich Stellen ist nicht dem Bundesschlssel der Dienstart (wiss./nichtwiss.) zugeordnet !')::char(200), 'Warnung'::char(10) 
from tmp_sgd_aggr 
where bund_dienstart is null or bund_dienstart not in (1,2);  

 
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>
--nur NHS Sachsen:
insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sva_soe'::char(18),('Stelle Nr.' || stellen_nr ||' im Bereich Stellen hat keine Titelinformation!')::char(200), 'Warnung'::char(10) 
from tmp_sgd_aggr 
where titel is null; 
--bund_bvl_stelle
insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sva_k_bvlgruppe'::char(18),('Stelle Nr.' || stellen_nr ||' im Bereich Stellen hat keine Bund-BVL-Gruppe!')::char(200), 'Warnung'::char(10) 
from tmp_sgd_aggr 
where bund_bvl_stelle is null; 
</#if>


drop table tmp_sgd_aggr;
drop table tmp_pbe_aggr;
drop table tmp_sgd_einz;
drop table tmp_pbe_aggr_dup;

update kenn_sgd_aggr set hs_nr=(select hs_nr from hochschulinfo);

</#if>
