--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>
<sqlvars>
<sqlvar name="jahre" type="hashsequence">
SELECT bezugszeit 
 FROM kenn_stichtag where bezugsart='J' 
 and stichtagsart_id='PROM'
 and berechnen='1';
</sqlvar>
--landesspezifika ermitteln: 5='nrw',14='Sachsen',8 'BaWue'
<sqlvar name="bland_kuerzel">
select 746::integer as kuerzel from cif where key=659 and apnr=5 
union
select 751::integer from cif where key=659 and apnr=14 
union
select 750::integer from cif where key=659 and apnr=8
union
select 750::integer from xdummy where 0=(
select count(*) from cif where key=659 and apnr in (5,8,14)) 
;
</sqlvar>
<sqlvar name = "k_astat_studienfach_land_exists">
SELECT sp_table_exists('k_astat_studienfach_land') FROM xdummy;
</sqlvar>
</sqlvars>

create temp table tmp_kenn_promo_aggr(
quelle char(1),
	hs_nr INTEGER , 
jahr SMALLINT , 
person_id varchar(255), --nur zum Debuggen
jahr_beginn SMALLINT , 
jahr_ende SMALLINT , 
jahr_beginn_bezug smallint,
jahr_ende_bezug smallint,
monat_beginn SMALLINT , 
monat_ende SMALLINT , 
art_ende CHAR(2) , 
koop_land_ausl CHAR(1) , 
geschlecht SMALLINT , 
stg char(4),
sb char(10),
extkotr CHAR(20) , 
dauer_jahre float,
datum date , 
summe INTEGER 
) 
;

<#if jahre?has_content>
<#foreach jahr in jahre>


--manuell wird immer geladen, wenn vorhanden:
insert into tmp_kenn_promo_aggr(
quelle,
 hs_nr,
       jahr,
       jahr_beginn,
       jahr_ende,
       art_ende,
       koop_land_ausl,
       geschlecht,
       datum,
       extkotr,
       dauer_jahre,
       summe
)
 SELECT 'P', --Tabelle kenn_promo
 H.hs_nr,
       ${jahr.bezugszeit},
       jahr_beginn,
       jahr_ende,
       art_ende,
       koop_land_ausl,
       geschlecht,
       today(),
       extkotr,
       jahr_ende-jahr_beginn,
       sum(summe)

FROM kenn_promo , hochschulinfo H
where  ${jahr.bezugszeit} >=jahr_beginn
--and (${jahr.bezugszeit} <=jahr_ende or jahr_ende is null)
group by 1,2,3,4,5,6,7,8,9,10,11
 ;
 
<#if K_KENN_ABG_PROM_LAB==1>

--Promotionen aus amtl. Statistik Absolventen, dies ist der Default:
insert into tmp_kenn_promo_aggr(
quelle,
 hs_nr,
       jahr,
       jahr_beginn,
       jahr_ende,
--       jahr_beginn_bezug,
--       jahr_ende_bezug,
       art_ende,
       koop_land_ausl,
       geschlecht,
       datum,
       stg,
       extkotr,
       dauer_jahre,
       summe
)
 SELECT 'P',
 H.hs_nr,
       ${jahr.bezugszeit},
       null::integer, --get_akad_jahr(sem_der_pruefung,'P') - ,  --'Promotionsbeginn Jahr'
       get_akad_jahr(sem_der_pruefung,'P') as jahr_ende,
       (case when pruefung_ergebnis=1 then 'B'
       else 'NB' end ) as art_ende, 
       null::char(1) as    koop_land_ausl,
       geschlecht,-- as geschlecht,
       today(),
       stg,
       fgr,
       case when fach_sem_zahl is null or fach_sem_zahl=0 then null::float
       else fach_sem_zahl/2::float end as dauer_jahre, --Fachsem. Zahl=0 -> Ungltiger Wert #253439
       sum(A.summe)

FROM kenn_lab_aggr_astat A , hochschulinfo H
where  ${jahr.bezugszeit} =get_akad_jahr(sem_der_pruefung,'P') --Berichtsjahr
and abschluss in  ('06','07','91','92')

group by 1,2,3,4,5,pruefung_ergebnis,geschlecht,stg,fgr,fach_sem_zahl
 ;
--jahr_beginn muss aus promov.-Stat. kommen:
--Anpassung des Bezugszeitraums der Kennzahl fr "Begonnene Promotionen" #253439:
--auf exakt den Bezugszeitraum der Promovierendenstatistik [02.12. Vorjahr bis 01.12. Stichtagsjahr] 
--Zhle alle Doktorand*innen In der Promovierendenstatistik 2019 (EF2), 
--die im Jahr 2019 [Januar bis November] sowie im Jahr 2018 [Dezember] ihre Promotion begonnen haben (EF13U1 + EF13U2).
--ef013u2 enthlt Jahr, ef013u1 den Monat des Beginns

insert into tmp_kenn_promo_aggr(
quelle,
 hs_nr,
       jahr,
       jahr_beginn,
       jahr_beginn_bezug,
       jahr_ende,
       monat_beginn,
       monat_ende,
       art_ende,
       koop_land_ausl,
       geschlecht,
       datum,
       stg,
       summe
)
 SELECT 'A',
 H.hs_nr,
       ${jahr.bezugszeit},
       ef013u2 as jahr_beginn,
       (case when ef013u1 between 1 and 11 then ef013u2
        when  ef013u1 =12 then ef013u2+1
       else ef013u2 end ) as jahr_beginn_bezug, --'Promotionsbeginn Jahr'
       null::integer as jahr_ende,--weil dies nur fr begonnene Promotionen gezhlt wird
       ef013u1 as monat_beginn,
       null::integer as monat_ende,--weil dies nur fr begonnene Promotionen gezhlt wird
       'A' as art_ende, 
       null::char(1) as koop_land_ausl,
       ef005,-- as geschlecht,
       today(),
       ef011,-- as stg,
       count(*)

FROM kenn_prom_astat A , hochschulinfo H
where  1=1
and 
${jahr.bezugszeit} =A.ef002 --Berichtsjahr
 group by 1,2,ef013u1,ef013u2,ef005,ef011,ef010
 ;
</#if>
</#foreach>
<#if K_KENN_ABG_PROM_LAB==0>

-- Abgeschl. Promotionen aus amtl. Statistik Promovierende:

insert into tmp_kenn_promo_aggr(
quelle,
 hs_nr,
       jahr,
       person_id,
       jahr_beginn,
       jahr_ende,
       monat_beginn,
       monat_ende,
       art_ende,
       koop_land_ausl,
       geschlecht,
       datum,
       stg,
       summe
)
 SELECT 'A',
 H.hs_nr,
       S.bezugszeit,
       S.bezugszeit || '_' || ef004 as person_id,
       ef013u2 as jahr_beginn, --'Promotionsbeginn Jahr'
       ef014u2 as jahr_ende,
       ef013u1 as monat_beginn,
       ef014u1 as monat_ende,
       (case when ef012=5 then 'B'
       when ef012=6 then 'NB'
       else 'U' end ) as art_ende, 
       null::char(1) as koop_land_ausl, 
       ef005,-- as geschlecht,
       today(),
       ef011,-- as stg,
       count(*)

FROM kenn_prom_astat A , hochschulinfo H, kenn_stichtag S
where S.bezugszeit =A.ef002 --Berichtsjahr
and S.bezugsart='J' 
 and S.stichtagsart_id='PROM'
 and S.berechnen='1'
group by 1,2,3,4,5,6,7,8,ef012,ef005,ef011
 ;
 
update tmp_kenn_promo_aggr set jahr_beginn_bezug=jahr_beginn
where monat_beginn between 1 and 11;
 update tmp_kenn_promo_aggr set jahr_beginn_bezug=jahr_beginn+1
 where monat_beginn =12 ;
 

update tmp_kenn_promo_aggr set jahr_ende_bezug=jahr_ende
where monat_ende between 1 and 11;
 update tmp_kenn_promo_aggr set jahr_ende_bezug=jahr_ende+1
 where monat_ende =12 ;

--select * from tmp_kenn_promo_aggr where jahr_beginn_bezug != jahr_beginn;

--select * from tmp_kenn_promo_aggr where jahr_ende_bezug != jahr_ende;


update tmp_kenn_promo_aggr set dauer_jahre=(
((jahr_ende*12 + monat_ende) - (jahr_beginn*12+monat_beginn))::float) / 12
where quelle='A'
--and ((jahr_ende*12 + monat_ende) - (jahr_beginn*12+monat_ende))::float > 0 
;


</#if>



</#if>

--Fach Bundesschlssel ermitteln:
 <#if k_astat_studienfach_land_exists=1>
create temp table tmp_kenn_bland ( apnr varchar(255), druck varchar(255), astat integer);

INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BA', 'Bayern', 9 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BB', 'Brandenburg', 12 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BE', 'Berlin', 11 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BR', 'Bremen', 4 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'BW', 'Baden-Wrttemberg', 8 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'HA', 'Hamburg', 2 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'HE', 'Hessen', 6 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'MV', 'Mecklenburg-Vorpommern', 13 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'NI', 'Niedersachsen', 3 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'NW', 'Nordrhein-Westfalen', 5 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'RP', 'Rheinland-Pfalz', 7 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'SA', 'Saarland', 10 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'SH', 'Schleswig-Holstein', 1 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'SN', 'Sachsen', 14 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'ST', 'Sachsen-Anhalt', 15 );
INSERT INTO tmp_kenn_bland ( apnr, druck, astat ) VALUES ( 'TH', 'Thringen', 16 );

create temp table tmp_kenn_bland_hs (bland integer);

insert into tmp_kenn_bland_hs (bland)
select astat from tmp_kenn_bland where apnr in (select K.bland from kenn_hochschulen K, hochschulinfo H where H.hs_nr=K.hs_nr);

<@selectintotmp source="k_astat_studienfach_land" target="tmp_stg" select="schluessel,
       land,
       null::char(10) as keybund,
       max(nvl(gueltig_bis,30001)) as gueltig_bis">
where land=(select bland from tmp_kenn_bland_hs)
group by 1,2,3
</@selectintotmp> <@informixnolog/>;


update tmp_stg set keybund=(select distinct L.keybund
from k_astat_studienfach_land L
where L.schluessel=tmp_stg.schluessel
and L.land=tmp_stg.land
and (L.gueltig_bis=tmp_stg.gueltig_bis or (L.gueltig_bis is null and tmp_stg.gueltig_bis =30001))
);

update tmp_kenn_promo_aggr set stg=(select K.keybund from tmp_stg K where (tmp_kenn_promo_aggr.stg=K.schluessel or tmp_kenn_promo_aggr.stg='0' || K.schluessel))
where 1=(select count(*) from tmp_stg K where tmp_kenn_promo_aggr.stg=K.schluessel or tmp_kenn_promo_aggr.stg='0' || K.schluessel);


drop table tmp_kenn_bland;
drop table tmp_kenn_bland_hs;
drop table tmp_stg;
</#if>

--FGR ermitteln
 

update tmp_kenn_promo_aggr set stg='0' || stg
where length(trim(stg))=3
 ;


update tmp_kenn_promo_aggr set sb=(select A.parent from kenn_stg_astat A
where tmp_kenn_promo_aggr.jahr between year(A.gueltig_von) and year(A.gueltig_bis)
and A.astat=tmp_kenn_promo_aggr.stg)
;
update tmp_kenn_promo_aggr set extkotr=(select A.parent from kenn_stg_astat A
where tmp_kenn_promo_aggr.jahr between year(A.gueltig_von) and year(A.gueltig_bis)
and A.astat=tmp_kenn_promo_aggr.sb)
 ;

update tmp_kenn_promo_aggr set extkotr=(select A.apnr from kenn_dim_fgr A
where tmp_kenn_promo_aggr.jahr between year(A.gueltig_von) and year(A.gueltig_bis)
and A.fg_studierende=tmp_kenn_promo_aggr.extkotr)
 ;

update tmp_kenn_promo_aggr set extkotr='U' where extkotr is null;


delete from kenn_promo_aggr
where jahr in (select K.bezugszeit
from kenn_stichtag K
where K.bezugsart='J' 
and K.berechnen='1'
and K.stichtagsart_id='PROM')
;

insert into kenn_promo_aggr
( hs_nr,
       jahr,
       jahr_beginn,
       jahr_ende,
<#if TableFieldExists?exists && TableFieldExists('kenn_promo_aggr','monat_beginn')>
jahr_beginn_bezug,
jahr_ende_bezug,
       monat_beginn,
       monat_ende,
</#if>
       art_ende,
       koop_land_ausl,
       geschlecht,
       datum,
       extkotr,
       dauer_jahre,
       summe
)
 
 SELECT   hs_nr,
 jahr,
       jahr_beginn,
       jahr_ende,
<#if TableFieldExists?exists && TableFieldExists('kenn_promo_aggr','monat_beginn')>
jahr_beginn_bezug,
jahr_ende_bezug,
       monat_beginn,
       monat_ende,
</#if>
       art_ende,
       koop_land_ausl,
       geschlecht,
       datum,
       extkotr,
       dauer_jahre,
       summe
FROM tmp_kenn_promo_aggr
 ;

drop table tmp_kenn_promo_aggr;

