--freemarker template



CREATE temp TABLE tmp_busa_cube (
    hs_nr integer,
    jahr smallint,
    quartal integer,
    kosten_erloese char(1),
    bvkr_art char(12),
    ch110_institut char(10),
    inst_art char(20),
    inst_ext char(40),
    kokl_faktor smallint,
    klr_geldgeber character(10),
    projnr character(10),
    betrag double precision
);



insert into tmp_busa_cube
(hs_nr,
       jahr,
       quartal,
       bvkr_art,
       ch110_institut,
       kokl_faktor,
       klr_geldgeber,
       projnr,
       betrag)
 
SELECT hs_nr,
       jahr,
       val(substring('' || quartal from 5 for 1)),
       bvkr_art,
       ch110_institut, --inst_art,
       kokl_faktor,
       klr_geldgeber,
       projnr,
       sum(kokl_faktor*betrag)
FROM kenn_busa_aggr
where inst_art is not null
and bvkr_art is not null
group by 1,2,3,4,5,6,7,8;

--Ext. Kostenstelle

update tmp_busa_cube set inst_ext=
(select min(I.key_ext) from kenn_inst_to_ext I
where I.hs_nr=tmp_busa_cube.hs_nr
and I.instnr=tmp_busa_cube.ch110_institut
and I.key_ext is not null
and trim(I.key_ext) !='');

update tmp_busa_cube set inst_art='' || hs_nr || '_' || substring(inst_ext from 1 for 3)
where inst_ext like '1%';
update tmp_busa_cube set inst_art='' || hs_nr || '_' || substring(inst_ext from 1 for 1)
where substring(inst_ext from 1 for 1) in ('2','3','4','8','9');

update tmp_busa_cube set inst_art='' || hs_nr || '_S' where inst_art is null;

<#if SQLdialect='Postgres'>

truncate table kenn_pkosten_cube;

<#else>

delete from kenn_pkosten_cube;

</#if>

insert into kenn_pkosten_cube
(hs_nr,
       jahr,
       quartal,
       bvkr_art,
--       klr_geldgeber,
inst_art,
       projnr,
       betrag)
 
SELECT hs_nr,
       jahr,
       quartal,
       bvkr_art,
--       klr_geldgeber,
inst_art,
       projnr,
       sum(betrag)
FROM tmp_busa_cube
group by 1,2,3,4,5,6;

drop table tmp_busa_cube;
