--Freemarker Template 

<sqlvars>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
<sqlvar name="kenn_profil">
select apnr from konstanten where beschreibung='KENN_PROFIL';
</sqlvar>
<sqlvar name="sva_cifx_exists">
select sp_table_exists('sva_cifx') from xdummy;
</sqlvar>
</sqlvars>

--wird nur in Sachsen benutzt
<#if cob_installed=1 && kenn_profil=5>

create temp table tmp_imp_sva_pbv(
tid serial,
durchfuehrung DATE , 
pbv_dienststelle CHAR(8) , 
ch110_institut CHAR(10) , 
poz_institut CHAR(10) , 
poz_anteil_proz double precision , 
poz_projekt CHAR(10) , 
jahr SMALLINT , 
monat SMALLINT , 
pbl_bvl_gruppe CHAR(10) , 
pbl_laufbahn CHAR(4) , 
pbl_adt_bez CHAR(10) , 
pbv_dienstart CHAR(4) , 
vollzeit_aequiv double precision , 
pbv_befr_bis CHAR(1) , 
pbv_art CHAR(4) , 
pbv_rechtsstell CHAR(2) , 
pbv_geldgeber CHAR(10) , 
klr_geldgeber char(10),
pbv_kapitel CHAR(5) , 
pbv_titel CHAR(5) , 
pbv_kostenart CHAR(12) , 
pbv_zaehler SMALLINT , 
kalk_kostenart CHAR(12) , 
pgd_zaehler INTEGER , 
imp_verz_id INTEGER, 
extkotr char(30) ,
extkost char(30),
stichtag date,
zaehlung char(2),
datum date,
summe decimal(10,2)
);

create temp table tmp_pbv_klr2(
hs_nr INTEGER , 
jahr SMALLINT , 
monat SMALLINT , 
kapitel CHAR(5) , 
titel CHAR(5) , 
kostenart CHAR(12) , 
kalk_kostenart CHAR(12) , 
bund_dienstart SMALLINT , 
buadbz CHAR(5) , 
klr_geldgeber CHAR(4) , 
extkost CHAR(30) , 
extkotr CHAR(30) , 
stichtag DATE , 
zaehlung CHAR(2) , 
datum date , 
summe DECIMAL(10,2) 
) 
;

create temp table tmp_stichtag(
	
stichtag DATE , 
bezugszeit SMALLINT , 
bezugsart CHAR(1)  not null, 
stichtagsart CHAR(100) , 
berechnen CHAR(1)  default '1' , 
exportieren CHAR(1)  default '1'
) 
;
insert into tmp_stichtag(
 stichtag,
       bezugszeit,
       bezugsart,
       stichtagsart,
       berechnen,
       exportieren
)
select  stichtag,
       bezugszeit,
       bezugsart,
       stichtagsart,
       berechnen,
       exportieren
from kenn_stichtag S
where S.stichtagsart_id='PEKLR'
and S.berechnen='1'
and S.bezugsart='J'
;

update tmp_stichtag set stichtag=(select max(durchfuehrung)
from cob_imp_sva_pbv C
where C.jahr=tmp_stichtag.bezugszeit)
where stichtag is null;


delete from kenn_pbv_klr where 0=
(select apnr from konstanten where beschreibung ='KENN_PERSONAL_ARCHIV');



--Kpfe ermitteln


insert into tmp_imp_sva_pbv (durchfuehrung,
       pbv_dienststelle,
       ch110_institut,
       poz_institut,
       poz_anteil_proz,
       poz_projekt,
       jahr,
       monat,
       pbl_bvl_gruppe,
       pbl_laufbahn,
       pbl_adt_bez,
       pbv_dienstart,
       vollzeit_aequiv,
       pbv_befr_bis,
       pbv_art,
       pbv_rechtsstell,
       pbv_geldgeber,
       pbv_kapitel,
       pbv_titel,
       pbv_kostenart,
       pbv_zaehler,
       kalk_kostenart,
       pgd_zaehler,
       imp_verz_id,
       stichtag ,
zaehlung ,
datum )
       select 
       durchfuehrung,
       pbv_dienststelle,
       ch110_institut,
       poz_institut,
       poz_anteil_proz,
       poz_projekt,
       jahr,
       monat,
       pbl_bvl_gruppe,
       pbl_laufbahn,
       pbl_adt_bez,
       pbv_dienstart,
       vollzeit_aequiv,
       pbv_befr_bis,
       pbv_art,
       pbv_rechtsstell,
       pbv_geldgeber,
       pbv_kapitel,
       pbv_titel,
       pbv_kostenart,
       pbv_zaehler,
       kalk_kostenart,
       pgd_zaehler,
       imp_verz_id,
       durchfuehrung,
'k'::char(1),
today()
from cob_inst I,cob_imp_sva_pbv A, tmp_stichtag S
where 
 S.stichtag =A.durchfuehrung 
and I.key_apnr=A.ch110_institut
and S.stichtag between I.gueltig_seit and I.gueltig_bis
;
update tmp_imp_sva_pbv set klr_geldgeber=
(select klr_geldgeber from cob_geldgeber C
where C.ggnr=tmp_imp_sva_pbv.pbv_geldgeber);
<#if sva_cifx_exists == 1>
update tmp_imp_sva_pbv set pbl_adt_bez=
(select C.bund_adbz from sva_k_amtsdienst C
where C.apnr=tmp_imp_sva_pbv.pbl_adt_bez);
<#else>
update tmp_imp_sva_pbv set pbl_adt_bez=null;
</#if>

create temp table tmp_doppelt(
tid integer,
monat smallint,
pgd_zaehler integer,
stichtag date,
vzae decimal(14,2)
);


--durch die Finanzierung kommen Personen doppelt rein, es wird jetzt der jeweils grte Anteil
--selektiert.


insert into tmp_doppelt(pgd_zaehler,monat,stichtag,vzae)
select pgd_zaehler,monat,stichtag,max(vollzeit_aequiv) from tmp_imp_sva_pbv
group by 1,2,3;

--zuerst aus HH-Mitteln:


update tmp_doppelt set tid=(select min(tid) from tmp_imp_sva_pbv A
where A.pgd_zaehler=tmp_doppelt.pgd_zaehler
and A.monat=tmp_doppelt.monat
and A.stichtag=tmp_doppelt.stichtag
and A.vollzeit_aequiv=tmp_doppelt.vzae
and (A.klr_geldgeber like '2%' or A.klr_geldgeber is null)
);

--dann auch Drittmittel (ohne beurl.).

update tmp_doppelt set tid=(select min(tid) from tmp_imp_sva_pbv A
where A.pgd_zaehler=tmp_doppelt.pgd_zaehler
and A.stichtag=tmp_doppelt.stichtag
and A.vollzeit_aequiv=tmp_doppelt.vzae
and A.klr_geldgeber not like '2%'
)
where tid is null
;

--wird nur in Sachsen benutzt
<#if cob_installed=1 && kenn_profil=5>

--09.07.2012 Sachsen: Sofern Kostenstelle und Kostentrger zugeordnet sind, wird der externe Schlssel des Kostentrgers (der Finanzierung) ausgewertet. 
update tmp_imp_sva_pbv set extkotr=(select P.k_extkotr from cob_proj P
where P.projnr=tmp_imp_sva_pbv.poz_projekt)
;
update tmp_imp_sva_pbv set extkotr=(select min(E.key) from kenn_inst I, kenn_extkotr E
where substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Produktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
and E.kategorie='lf' --Ebene LFB
and E.key like '1%' --nur Lehre
and I.key_apnr=tmp_imp_sva_pbv.ch110_institut)
where extkotr is null;

--ext. Kostenstelle ermitteln
update tmp_imp_sva_pbv set extkost=(select min(I.key_extkotr) from kenn_inst_to_ext I
where I.instnr=tmp_imp_sva_pbv.ch110_institut
and I.key_extkotr is not null
and trim(I.key_extkotr) !='')
;
--wenn projnr leer ist, wird ext. Kostenstelle genommen
update tmp_imp_sva_pbv set extkotr=extkost where extkost is not null
and extkotr is null;

--Ende Extkotr /Extkost. Sachsen
</#if>
--kpfe

insert into tmp_pbv_klr2 (
hs_nr,
       jahr,
       monat,
       kapitel,
       titel,
--       kostenart,
--       kalk_kostenart,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       extkost,
       extkotr,
       stichtag,
       zaehlung,
       datum,
       summe)
select H.hs_nr,
       jahr,
       A.monat,
       pbv_kapitel,
       pbv_titel,
       val(pbv_dienstart),
       pbl_adt_bez,
       klr_geldgeber,
      extkost,
       extkotr,
       A.stichtag,
       zaehlung,
datum,
count(distinct A.pgd_zaehler)
from tmp_imp_sva_pbv A, tmp_doppelt D,hochschulinfo H
where A.zaehlung='k'
and A.tid=D.tid
group by 1,2,3,4,5,6,7,8,9,10,11,12,13;


--vzae:

insert into tmp_pbv_klr2 (
hs_nr,
       jahr,
       monat,
       kapitel,
       titel,
--       kostenart,
--       kalk_kostenart,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       extkost,
       extkotr,
       stichtag,
       zaehlung,
       datum,
       summe)
select H.hs_nr,
       jahr,
       monat,
       pbv_kapitel,
       pbv_titel,
       val(pbv_dienstart),
       pbl_adt_bez,
       klr_geldgeber,
      extkost,
       extkotr,
       stichtag,
       'v'::char(1),
datum,
sum(vollzeit_aequiv)
from tmp_imp_sva_pbv A, hochschulinfo H
group by 1,2,3,4,5,6,7,8,9,10,11,12,13;





insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'cob_proj/cob_inst'::char(18),'kenn_pbv_klr'::char(18),'Projekt' || string_not_null(trim(poz_projekt)) || ' oder Kost.' || string_not_null(trim(poz_institut)) ||' im Bereich Personal KLR ist nicht externem Kostentrger zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_imp_sva_pbv 
where extkotr is null;  


insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'cob_imp_sva_pbv'::char(18),'kenn_pbv_klr'::char(18),'Dienstart ' || trim(string_not_null(pbv_dienstart)) || ' im Bereich Personal KLR ist nicht dem Bundesschlssel der Dienstart (wiss./nichtwiss.) zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_imp_sva_pbv 
where pbv_dienstart is null or pbv_dienstart not in ('1','2');  

insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'cob_imp_sva_pbv'::char(18),'kenn_pbv_klr'::char(18),'Amts-Dienstbez. ' || trim(string_not_null(pbl_adt_bez)) || ' im Bereich Personal KLR ist nicht dem Bundesschlssel der Amts-Dienstbez. (Professoren etc) zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_imp_sva_pbv 
where pbl_adt_bez is null;  

insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'cob_imp_sva_pbv'::char(18),'kenn_pbv_klr'::char(18),'Geldgeber ' || trim(string_not_null(pbv_geldgeber)) || ' im Bereich Personal ist nicht dem Landesschlssel des Geldgebers (KLR) zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_imp_sva_pbv 
where klr_geldgeber is null;  





--Lschung vorh. Stichtage:
delete from kenn_pbv_klr
where  stichtag in (select distinct stichtag
from tmp_pbv_klr2)
;
insert into kenn_pbv_klr(hs_nr,
       jahr,
       monat,
       kapitel,
       titel,
       kostenart,
       kalk_kostenart,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       extkost,
       extkotr,
       stichtag,
       zaehlung,
       datum,
       summe)
       select 
       hs_nr,
       jahr,
       monat,
       kapitel,
       titel,
       kostenart,
       kalk_kostenart,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       extkost,
       extkotr,
       stichtag,
       zaehlung,
       datum,
       sum(summe)
       from tmp_pbv_klr2
       group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;
       
drop table tmp_doppelt;
drop table tmp_stichtag;
drop table tmp_imp_sva_pbv;
drop table tmp_pbv_klr2;

</#if>
