--Freemarker Template 
--derzeit noch nicht benutzt
<sqlvars>
<sqlvar name="sva_installed">
select count(*) from db_version where his_system ='sva';
</sqlvar>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
<sqlvar name="kenn_profil">
select apnr from konstanten where beschreibung='KENN_PROFIL';
</sqlvar>
</sqlvars>

<#assign sva_filter="" /> 
<#assign type_double="double precision" />
<#if '${SQLdialect}'='Informix' >
<#assign type_double="float" />
</#if>


--Ermittlung aus KENN Modul kenn_pbv_astat
create temp table tmp_pbv_aggr (
tid serial,
personal_nr integer,
	hs_nr INTEGER , 
jahr SMALLINT , 
geschlecht SMALLINT , 
bund_fachgebiet CHAR(10) , 
bund_taetigkeit SMALLINT , 
bund_dienstart SMALLINT , 
buadbz CHAR(5) , 
bund_geldgeber CHAR(10) , 
zaehlung CHAR(2) , 
datum date , 
befristet SMALLINT,
ca501_staat integer,
ca501_staat_2 integer,
ernennung_alter SMALLINT ,
ernennung_jahr SMALLINT ,
geburtsjahr smallint,
qualifizierung_art smallint,
summe ${type_double} 
);



create temp table tmp_pbv_aggr2(
	hs_nr INTEGER , 
jahr SMALLINT ,
geschlecht SMALLINT , 
bund_fachgebiet CHAR(10) , 
bund_taetigkeit SMALLINT , 
bund_dienstart SMALLINT , 
buadbz CHAR(5) , 
bund_geldgeber CHAR(4) , 
zaehlung CHAR(2) , 
datum date , 
befristet SMALLINT,
ca501_staat integer,
ca501_staat_2 integer,
ernennung_alter SMALLINT ,
ernennung_jahr SMALLINT ,
geburtsjahr smallint,
qualifizierung_art smallint,
lfb char(10),
fgr char(10),
summe ${type_double} 
) 
;

delete from kenn_pbv_aggr_astat where 0=
(select apnr from konstanten where beschreibung ='KENN_PERSONAL_ARCHIV');





-- drop table tmp_pbv_aggr;
-- drop table tmp_doppelt;


--VZ


insert into tmp_pbv_aggr (
hs_nr,
       jahr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       bund_geldgeber,
       zaehlung,
       datum,
       befristet,
       ca501_staat,
ernennung_jahr  ,
geburtsjahr,
       qualifizierung_art,
       personal_nr,
              summe
)
select  

hs_nr,
jahr,
ef23 as geschlecht,
ef11 as bund_fachgebiet,
val(ef13) as bund_taetigkeit,
ef01 as bund_dienstart,
ef12 as buadbz,
ef22 as bund_geldgeber,
'v' as zaehlung,
today() as datum,
case when ef19='2' then 1 end  as befristet,
ef26 as staat,
case when ef36 is not null then val(ef36)
when ef37 is not null then val(ef37)
else ernennung_jahr_ngl
end
as ernennung_jahr,
ef25 as geburtsjahr,
val(ef33) as qualifizierung_art,
A.personal_nr,
case when ef14='1' then 1
 when ef14='2' and ef15 is not null then val(ef15)::${type_double}/100
 when ef14='2' and ef16 is not null then val(ef16)::${type_double}/40
else 0
end as summe
from kenn_pbv_astat A, kenn_stichtag S
where S.stichtagsart_id='PESA'
and S.bezugszeit=A.jahr
and S.bezugsart='J'
and S.berechnen='1'
;

update tmp_pbv_aggr set befristet=0 where befristet is null;

--zweistellige Jahre werden vierstellig:
update tmp_pbv_aggr set ernennung_jahr=2000+ernennung_jahr
where ernennung_jahr <=val(substring('' || year(today()) from 3 for 2));
update tmp_pbv_aggr set ernennung_jahr=1900+ernennung_jahr
where ernennung_jahr<1900;

update tmp_pbv_aggr set geburtsjahr=2000+geburtsjahr
where geburtsjahr <=val(substring('' || year(today()) from 3 for 2));
update tmp_pbv_aggr set geburtsjahr=1900+geburtsjahr
where geburtsjahr<1900;

update tmp_pbv_aggr set ernennung_alter=ernennung_jahr-geburtsjahr
where ernennung_jahr is not null;

--update tmp_pbv_aggr set personal_nr=tid
--where personal_nr is null;


create temp table tmp_doppelt(
tid integer,
personal_nr integer,
jahr integer,
vzae ${type_double}
);

insert into tmp_doppelt(personal_nr,jahr,vzae)
select personal_nr,jahr,max(summe) from tmp_pbv_aggr
group by 1,2;

--zuerst aus HH-Mitteln:

--wenn mglich erstmal ohne Beurlaubte:
update tmp_doppelt set tid=(select min(tid) from tmp_pbv_aggr A
where A.personal_nr=tmp_doppelt.personal_nr
and A.jahr=tmp_doppelt.jahr
and A.summe=tmp_doppelt.vzae
and (A.bund_geldgeber in ('01','02','99') or A.bund_geldgeber is null or A.bund_geldgeber='')
);

--dann auch Drittmittel (ohne beurl.).

update tmp_doppelt set tid=(select min(tid) from tmp_pbv_aggr A
where A.personal_nr=tmp_doppelt.personal_nr
and A.jahr=tmp_doppelt.jahr
and A.summe=tmp_doppelt.vzae
and A.bund_geldgeber not in ('01','02','99','')
)
where tid is null
;

--dann andere (d.h. inkl. Beurl.)

update tmp_doppelt set tid=(select min(tid) from tmp_pbv_aggr A
where A.personal_nr=tmp_doppelt.personal_nr
and A.jahr=tmp_doppelt.jahr
and A.summe=tmp_doppelt.vzae
)
where tid is null;

--Zusammenziehen:
--VZ:
insert into tmp_pbv_aggr2(hs_nr,
jahr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       bund_geldgeber,
       zaehlung,
       datum,
       befristet,
       ca501_staat,
       ernennung_jahr,
       ernennung_alter,
       qualifizierung_art,
        summe)
      select
       hs_nr,
       jahr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       bund_geldgeber,
       zaehlung,
       datum,
       befristet,
       ca501_staat,
       ernennung_jahr,
       ernennung_alter,
       qualifizierung_art,
      sum(summe)
      from tmp_pbv_aggr
      group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
      ;
--Kpfe:
insert into tmp_pbv_aggr2(hs_nr,
	jahr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       bund_geldgeber,
       zaehlung,
       datum,
       befristet,
       ca501_staat,
       ernennung_jahr,
      ernennung_alter,
       qualifizierung_art,
        summe)
      select
       hs_nr,
       A.jahr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       bund_geldgeber,
       'k',
       datum,
       befristet,
       ca501_staat,
       ernennung_jahr,
       ernennung_alter,
       qualifizierung_art,
      count(distinct A.personal_nr)
      from tmp_pbv_aggr A, tmp_doppelt D
where A.tid=D.tid
      group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
      ;
      
      
--Ermittlung FGR:
update tmp_pbv_aggr2 set lfb=(select A.parent from kenn_lfb_fg A
where tmp_pbv_aggr2.jahr between year(A.gueltig_von) and year(A.gueltig_bis)
and trim(A.apnr)=trim(tmp_pbv_aggr2.bund_fachgebiet));

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_pbv_astat'::char(18),'Fachgebiet (Bund) ' || trim(bund_fachgebiet) || ' ist unbekannt !'::char(200), 'Warnung'::char(10) 
from tmp_pbv_aggr2 
where lfb is null; 

update tmp_pbv_aggr2 set fgr=(select A.parent from kenn_lfb_fg A
where tmp_pbv_aggr2.jahr between year(A.gueltig_von) and year(A.gueltig_bis)
and trim(A.apnr)=trim(tmp_pbv_aggr2.lfb));

update tmp_pbv_aggr2 set fgr=(select A.apnr from kenn_dim_fgr A
where tmp_pbv_aggr2.jahr between year(A.gueltig_von) and year(A.gueltig_bis)
and A.fg_personal=tmp_pbv_aggr2.fgr);

update tmp_pbv_aggr2 set fgr='U' where fgr is null;

--Lschung vorh. Stichtage:
delete from kenn_pbv_aggr_astat
where jahr in (select distinct jahr
from tmp_pbv_aggr2)
;
insert into kenn_pbv_aggr_astat(hs_nr,
       jahr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       bund_geldgeber,
       zaehlung,
       datum,
       befristet,
       staat,
       ernennung_jahr,
       ernennung_alter,
       qualifizierung_art,
       fgr,
       summe)
       select 
       hs_nr,
       jahr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       bund_geldgeber,
       zaehlung,
       datum,
       befristet,
       ca501_staat,
       ernennung_jahr,
       ernennung_alter,
       qualifizierung_art,
       fgr,
       sum(summe)
       from tmp_pbv_aggr2
       group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16;
       
drop table tmp_pbv_aggr;
drop table tmp_pbv_aggr2;
drop table tmp_doppelt;

