--Freemarker Template 

<sqlvars>
<sqlvar name="sva_installed">
select count(*) from db_version where his_system ='sva';
</sqlvar>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
<sqlvar name="kenn_profil">
select apnr from konstanten where beschreibung='KENN_PROFIL';
</sqlvar>
</sqlvars>

<#assign sva_filter="" /> 
<#assign type_double="double precision" />
<#if '${SQLdialect}'='Informix' >
<#assign type_double="float" />
</#if>

<#if K_KENN_PROFIL?exists && K_KENN_PROFIL=5>
--nur Sachsen: 
--Personal mit k_vertragsart.Bundesstatistikrelevanzschlssel=J 
<#assign sva_filter="and A.vertart in (select V.apnr from sva_k_vertragsart V where bundstat_relevant='J')" /> 
</#if>

<#if sva_installed=1>
--Ermittlung aus SVA Modul
create temp table tmp_pbv_aggr (
tid serial,
personal_nr integer,
besch_verh_nr integer,
besch_st_nr integer,
geschlecht smallint,
ch110_besch_st char(10),
bund_fachgebiet char(10),
ca107_dienstart char(10),
bund_dienstart smallint,
vertart char(10),
bund_taetigkeit smallint,
ca108_amtsbez char(10),
buadbz char(5),
ch212_geldgeber char(10),
klr_geldgeber char(10),
kapitel char(5),
beurl_art char(10), 
vzae ${type_double},
drittmittel smallint,
projekt  char(10) ,
kostenstelle char(10),
extkotr char(30) ,
extkost char(30),
stichtag date,
zaehlung char(2),
d_befristung date,
befristet SMALLINT,
ca501_staat integer,
ca501_staat_2 integer,
datum date,
d_besch_von     date,
d_besch_bis     date,
wochenstunden ${type_double},
stunden_gewichtet ${type_double},
stunden_pro_jahr ${type_double},
pfi_prozent     ${type_double},
anteil_proz    ${type_double},
dauer_tage integer,
k_art_zeit_his_system_key char(1),
summe ${type_double}
);



create temp table tmp_pbv_aggr2(
	hs_nr INTEGER , 
geschlecht SMALLINT , 
bund_fachgebiet CHAR(10) , 
bund_taetigkeit SMALLINT , 
bund_dienstart SMALLINT , 
buadbz CHAR(5) , 
klr_geldgeber CHAR(4) , 
kapitel CHAR(5) , 
stichtag DATE , 
zaehlung CHAR(2) , 
datum date , 
summe ${type_double} , 
extkost CHAR(30) , 
extkotr CHAR(30), 
befristet SMALLINT,
ca501_staat integer,
ca501_staat_2 integer
) 
;

delete from kenn_pbv_aggr where 0=
(select apnr from konstanten where beschreibung ='KENN_PERSONAL_ARCHIV');

create temp table tmp_doppelt(
tid integer,
personal_nr integer,
stichtag date,
klr_geldgeber char(10),
vzae ${type_double}
);




-- drop table tmp_pbv_aggr;
-- drop table tmp_doppelt;


--Kpfe


insert into tmp_pbv_aggr (
personal_nr ,
geschlecht,
ch110_besch_st, 
ca107_dienstart,
vertart,
ca108_amtsbez, 
ch212_geldgeber,
kapitel,
projekt ,
kostenstelle,
beurl_art,
stichtag,
vzae,
drittmittel,
zaehlung,
datum,
d_befristung,
ca501_staat,
ca501_staat_2,
summe)
select  
A.personal_nr ,
A.geschlecht,
A.ch110_besch_st,
A.ca107_dienstart,
A.vertart,
A.ca108_amtsbez,
A.ch212_geldgeber,
A.kapitel,
A.projekt ,
A.kostenstelle,
A.beurl_art,
S.stichtag,
A.vzae,
A.drittmittel,
'k'::char(1),
today(),
A.d_befristung,
A.ca501_staat,
<#if K_KENN_PROFIL?exists && K_KENN_PROFIL=5>
--nur Sachsen: 
A.ca501_staat_2,
<#else>
null::integer,
</#if>
1::Integer from sva_inst I,sva_pbv_aggr A, kenn_stichtag S
where 
--year(today())=year(S.stichtag)
S.stichtag between d_besch_von and d_besch_bis 
and S.stichtagsart_id='PESI'
and S.berechnen='1' and I.key_apnr=A.ch110_besch_st
and S.stichtag between I.gueltig_seit and I.gueltig_bis
${sva_filter}
;



--durch die Finanzierung kommen Personen doppelt rein, es wird jetzt der jeweils grte Anteil
--selektiert.


insert into tmp_doppelt(personal_nr,stichtag,vzae)
select personal_nr,stichtag,max(vzae) from tmp_pbv_aggr
group by 1,2;

--zuerst aus HH-Mitteln:

--wenn mglich erstmal ohne Beurlaubte:
update tmp_doppelt set tid=(select min(tid) from tmp_pbv_aggr A
where A.personal_nr=tmp_doppelt.personal_nr
and A.stichtag=tmp_doppelt.stichtag
and A.vzae=tmp_doppelt.vzae
and (A.drittmittel !=1 or A.drittmittel is null)
and beurl_art is null
);

--dann auch Drittmittel (ohne beurl.).

update tmp_doppelt set tid=(select min(tid) from tmp_pbv_aggr A
where A.personal_nr=tmp_doppelt.personal_nr
and A.stichtag=tmp_doppelt.stichtag
and A.vzae=tmp_doppelt.vzae
and A.drittmittel =1 
and beurl_art is null
)
where tid is null
;

--dann andere (d.h. inkl. Beurl.)

update tmp_doppelt set tid=(select min(tid) from tmp_pbv_aggr A
where A.personal_nr=tmp_doppelt.personal_nr
and A.stichtag=tmp_doppelt.stichtag
and A.vzae=tmp_doppelt.vzae
)
where tid is null;

--Vollzeit-quivalente
insert into tmp_pbv_aggr (
geschlecht,
ch110_besch_st,
ca107_dienstart,
vertart,
ca108_amtsbez,
ch212_geldgeber,
kapitel,
projekt ,
kostenstelle,
beurl_art,
stichtag,
zaehlung,
datum,
d_befristung,
ca501_staat,
ca501_staat_2,
summe)
select  
A.geschlecht,
A.ch110_besch_st,
A.ca107_dienstart,
A.vertart,
A.ca108_amtsbez,
A.ch212_geldgeber,
A.kapitel,
A.projekt ,
A.kostenstelle,
A.beurl_art,
S.stichtag,
'v'::char(1),
today(),
A.d_befristung,
A.ca501_staat,
<#if K_KENN_PROFIL?exists && K_KENN_PROFIL=5>
--nur Sachsen: 
ca501_staat_2,
<#else>
null::integer,
</#if>
sum(vzae) from sva_inst I,sva_pbv_aggr A, kenn_stichtag S
where 
 S.stichtag between d_besch_von and d_besch_bis 
and S.stichtagsart_id='PESI'
and S.berechnen='1'
and I.key_apnr=A.ch110_besch_st
and S.stichtag between I.gueltig_seit and I.gueltig_bis
${sva_filter}
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
;
<#if kenn_profil=5>

--VZ pro Jahr Sachsen:
--Vollzeit-quivalente
insert into tmp_pbv_aggr (
personal_nr,
besch_verh_nr,
geschlecht,
ch110_besch_st,
ca107_dienstart,
vertart,
ca108_amtsbez,
ch212_geldgeber,
kapitel,
projekt ,
kostenstelle,
beurl_art,
stichtag,
zaehlung,
datum,
d_befristung,
ca501_staat,
ca501_staat_2,
d_besch_von,
d_besch_bis,
pfi_prozent,
anteil_proz, 
wochenstunden)
select  
A.personal_nr,
A.besch_verh_nr,
A.geschlecht,
A.ch110_besch_st,
A.ca107_dienstart,
A.vertart,
A.ca108_amtsbez,
A.ch212_geldgeber,
A.kapitel,
A.projekt ,
A.kostenstelle,
A.beurl_art,
S.stichtag,
'j'::char(1),
today(),
A.d_befristung,
A.ca501_staat,
<#if K_KENN_PROFIL?exists && K_KENN_PROFIL=5>
--nur Sachsen: 
A.ca501_staat_2,
<#else>
null::integer,
</#if>
d_besch_von,
d_besch_bis,
pfi_prozent,
anteil_proz, 
sum(stunden) from sva_inst I,sva_pbv_aggr A, kenn_stichtag S
where 
  S.stichtagsart_id='PESI'
and S.berechnen='1'
and I.key_apnr=A.ch110_besch_st
and S.stichtag between I.gueltig_seit and I.gueltig_bis
and year(S.stichtag) between year(A.d_besch_von) and year(A.d_besch_bis)
${sva_filter}
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22
;

--Stunden anteilig auf poz_prozent und pfi_prozent:
update tmp_pbv_aggr set stunden_gewichtet=wochenstunden*pfi_prozent*anteil_proz/10000
where zaehlung='j';
--Ermittlung Art der Arbeitszeit:
update tmp_pbv_aggr set k_art_zeit_his_system_key=(
select min(art_zeit) from sva_paz P
where P.pgd_join_id=tmp_pbv_aggr.personal_nr
and P.pbv_nr=tmp_pbv_aggr.besch_verh_nr
and P.von <= tmp_pbv_aggr.d_besch_von
and P.bis >= tmp_pbv_aggr.d_besch_bis
)
where zaehlung='j';
--Semestereinzelstunden und Jahresstunden aufs Jahr hochsetzen:
update tmp_pbv_aggr set stunden_pro_jahr=stunden_gewichtet*26,
d_besch_von=date_val('01.01.' || year(stichtag)),
d_besch_bis = date_val('31.12.' || year(stichtag))
where zaehlung='j'
and k_art_zeit_his_system_key in ('D');

update tmp_pbv_aggr set stunden_pro_jahr=stunden_gewichtet*52,
d_besch_von=date_val('01.01.' || year(stichtag)),
d_besch_bis = date_val('31.12.' || year(stichtag))
where zaehlung='j'
and k_art_zeit_his_system_key in ('E','J');


--Wenn Beginn der Beschftigung vor Jahresbeginn liegt:
update tmp_pbv_aggr set d_besch_von=date_val('01.01.' || year(stichtag))
where zaehlung='j'
and d_besch_von <date_val('01.01.' || year(stichtag));
--Wenn Ende der Beschftigung nach Jahresende liegt:
update tmp_pbv_aggr set d_besch_bis=date_val('31.12.' || year(stichtag))
where zaehlung='j'
and d_besch_bis > date_val('31.12.' || year(stichtag));
--Dauer in Tagen ermitteln:
update tmp_pbv_aggr set dauer_tage=d_besch_bis-d_besch_von+1
where zaehlung='j';
--Wochenstunden hochrechnen auf Stunden pro Jahr:
update tmp_pbv_aggr set stunden_pro_jahr =stunden_gewichtet * 52  * dauer_tage/365
where zaehlung='j'
--nur wenn keine Einzelstunden:
and stunden_pro_jahr is null;
--wenn ganzes Jahr:
update tmp_pbv_aggr set stunden_pro_jahr =stunden_gewichtet * 52 
where zaehlung='j'
and dauer_tage = 365
--nur wenn keine Einzelstunden:
and stunden_pro_jahr is null;

--VZ Formel Sachsen: stunden_pro_jahr / (52 *40) 
update tmp_pbv_aggr set summe =stunden_pro_jahr /(52*40) 
where zaehlung='j';

--Ende VZ Jahr

--Kpfe pro Jahr:
insert into tmp_pbv_aggr (
personal_nr ,
geschlecht,
--ch110_besch_st,
--ca107_dienstart,
--vertart,
ca108_amtsbez,
ch212_geldgeber,
--kapitel,
projekt ,
kostenstelle,
beurl_art,
stichtag,
zaehlung,
datum,
--d_befristung,
ca501_staat,
vzae)
select  
A.personal_nr ,
A.geschlecht,
--A.ch110_besch_st,
--A.ca107_dienstart,
--A.vertart,
A.ca108_amtsbez,
A.ch212_geldgeber,
--A.kapitel,
A.projekt ,
A.kostenstelle,
A.beurl_art,
S.stichtag,
'p'::char(1),
today(),
--A.d_befristung,
A.ca501_staat,
A.vzae
from sva_inst I,sva_pbv_aggr A, kenn_stichtag S
where 
  S.stichtagsart_id='PESI'
and S.berechnen='1'
and I.key_apnr=A.ch110_besch_st
and S.stichtag between I.gueltig_seit and I.gueltig_bis
and year(S.stichtag) between year(A.d_besch_von) and year(A.d_besch_bis)
${sva_filter}

;

</#if>

update tmp_pbv_aggr set bund_fachgebiet=(select bund_fachgebiet from sva_inst where key_apnr=tmp_pbv_aggr.ch110_besch_st)
;
update tmp_pbv_aggr set bund_dienstart=(select val(bund_dienstart) from sva_k_dienstart where apnr=tmp_pbv_aggr.ca107_dienstart)
;
update tmp_pbv_aggr set bund_taetigkeit=(select val(bund_taetigkeit) from sva_k_vertragsart where apnr=tmp_pbv_aggr.vertart)
;
update tmp_pbv_aggr set buadbz=(select bund_adbz from sva_k_amtsdienst where apnr=tmp_pbv_aggr.ca108_amtsbez)
;
update tmp_pbv_aggr set klr_geldgeber=
(select C.gruppe from  sva_cifx C 
where C.key=636
and tmp_pbv_aggr.ch212_geldgeber=C.apnr)
where ch212_geldgeber is not null;
update tmp_pbv_aggr set klr_geldgeber=substring(klr_geldgeber from 5 for 20)
where klr_geldgeber like 'KLR_%';


--wird nur in Sachsen benutzt
<#if kenn_profil=5>

--beurlaubtes Personal wird nur gezhlt wenn Bezge gezahlt werden:
delete from tmp_pbv_aggr where beurl_art in (
select C.apnr from sva_cifx C
where C.key=106
and (C.struktur_c is null or  C.struktur_c != 'J') --C.struktur_c enthlt Bezge-KZ, ggf. mit "J" gefllt
);
--TODO bundstat
<#if cob_installed=1>

update tmp_pbv_aggr set befristet=1 where d_befristung is not null and d_befristung < date_val('01.01.2900');
update tmp_pbv_aggr set befristet=0 where befristet is null;

--09.07.2012 Sachsen: Sofern Kostenstelle und Kostentrger zugeordnet sind, wird der externe Schlssel des Kostentrgers (der Finanzierung) ausgewertet. 
update tmp_pbv_aggr set extkotr=(select P.k_extkotr from cob_proj P
where P.projnr=tmp_pbv_aggr.projekt)
;
-- ext. Kostenstelle ermitteln
update tmp_pbv_aggr set extkost=(select min(I.key_extkotr) from kenn_inst_to_ext I
where I.instnr=tmp_pbv_aggr.kostenstelle
and I.key_extkotr is not null
and trim(I.key_extkotr) !='')
;
--wenn projnr leer ist, wird ext. Kostenstelle genommen
update tmp_pbv_aggr set extkotr=extkost where extkost is not null
and extkotr is null;

update tmp_pbv_aggr set extkotr=(select min(E.key) from kenn_inst I, kenn_extkotr E
where substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Produktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
and E.kategorie='lf' --Ebene LFB
and E.key like '1%' --nur Lehre
and I.key_apnr=tmp_pbv_aggr.kostenstelle)
where extkotr is null;

</#if> --COB-bezogene Transf.
--Staat erheben:
--Wenn doppelte Staatsangehrigkeit, dann ist eine Person "Deutsch"
update tmp_pbv_aggr set ca501_staat=0 where ca501_staat_2=0;
update tmp_pbv_aggr set ca501_staat=1 where ca501_staat >0 and ca501_staat not in (997,998,999);
update tmp_pbv_aggr set ca501_staat=2 where ca501_staat in (997,998,999) or ca501_staat is null;
<#else>
--auerhalb Sachsen Datensparsamkeit:
update tmp_pbv_aggr set ca501_staat=2;

</#if>
select 'jetzt' from xdummy;

--kpfe

insert into tmp_pbv_aggr2 (geschlecht,
bund_fachgebiet,
bund_dienstart,
bund_taetigkeit,
buadbz,
klr_geldgeber,
kapitel,
stichtag,
zaehlung,
datum,
extkotr,
extkost,
befristet,
ca501_staat,
summe)
select geschlecht,
bund_fachgebiet,
bund_dienstart,
bund_taetigkeit,
buadbz,
A.klr_geldgeber,
kapitel,
A.stichtag,
zaehlung,
datum,
extkotr,
extkost,
befristet,
ca501_staat,
count(distinct A.personal_nr)
from tmp_pbv_aggr A, tmp_doppelt D
where A.zaehlung='k'
and A.tid=D.tid
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14;


--vzae / VZ pro Jahr:
insert into tmp_pbv_aggr2 (geschlecht,
bund_fachgebiet,
bund_dienstart,
bund_taetigkeit,
buadbz,
klr_geldgeber,
kapitel,
stichtag,
zaehlung,
datum,
extkotr,
extkost,
befristet,
ca501_staat,
summe)
select geschlecht,
bund_fachgebiet,
bund_dienstart,
bund_taetigkeit,
buadbz,
klr_geldgeber,
kapitel,
stichtag,
zaehlung,
datum,
extkotr,
extkost,
befristet,
ca501_staat,
sum(summe)
from tmp_pbv_aggr
where zaehlung in ('v','j')
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14;

--Kpfe pro Jahr:

delete from tmp_doppelt;
insert into tmp_doppelt(personal_nr,stichtag,klr_geldgeber, vzae)
select personal_nr,stichtag,klr_geldgeber,max(vzae) from tmp_pbv_aggr
where zaehlung='p'
group by 1,2,3;
--zuerst aus HH-Mitteln:

--wenn mglich erstmal ohne Beurlaubte:
update tmp_doppelt set tid=(select min(tid) from tmp_pbv_aggr A
where A.personal_nr=tmp_doppelt.personal_nr
and A.stichtag=tmp_doppelt.stichtag
and A.vzae=tmp_doppelt.vzae
and (A.klr_geldgeber=tmp_doppelt.klr_geldgeber or 
(A.klr_geldgeber is null
and tmp_doppelt.klr_geldgeber is null
))
--beurlaubtes Personal wird nur ausgeschlossen wenn keine Bezge gezahlt werden:
and (beurl_art is null or beurl_art not in (select C.apnr from sva_cifx C
where C.key=106
and (C.struktur_c is null or  C.struktur_c != 'J')))
and A.zaehlung='p'
);


--dann andere (d.h. inkl. Beurl.)

update tmp_doppelt set tid=(select min(tid) from tmp_pbv_aggr A
where A.personal_nr=tmp_doppelt.personal_nr
and A.stichtag=tmp_doppelt.stichtag
and A.vzae=tmp_doppelt.vzae
and (A.klr_geldgeber=tmp_doppelt.klr_geldgeber or 
(A.klr_geldgeber is null
and tmp_doppelt.klr_geldgeber is null
))
--and A.beurl_art is null
and A.zaehlung='p'
)
where tid is null;

insert into tmp_pbv_aggr2 (geschlecht,
bund_fachgebiet,
bund_dienstart,
bund_taetigkeit,
buadbz,
klr_geldgeber,
--kapitel,
stichtag,
zaehlung,
datum,
extkotr,
extkost,
--befristet,
ca501_staat,
summe)
select geschlecht,
bund_fachgebiet,
bund_dienstart,
bund_taetigkeit,
buadbz,
A.klr_geldgeber,
--kapitel,
A.stichtag,
zaehlung,
datum,
extkotr,
extkost,
--befristet,
ca501_staat,
count(distinct A.personal_nr)
from tmp_pbv_aggr A, tmp_doppelt D
where A.zaehlung='p'
and A.tid=D.tid
group by 1,2,3,4,5,6,7,8,9,10,11,12;

update tmp_pbv_aggr2 set hs_nr=(select hs_nr from hochschulinfo);

--nur Sachsen:
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5)>
insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'cob_proj/sva_inst'::char(18),'kenn_pbv_aggr'::char(18),'Projekt' || string_not_null(trim(projekt)) || ' oder Kost.' || string_not_null(trim(kostenstelle)) ||' im Bereich Personal ist nicht externem Kostentrger zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_pbv_aggr 
where extkotr is null
and zaehlung !='p'
;  
</#if>
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL=1 || K_KENN_PROFIL=2 ||K_KENN_PROFIL=3)>
--nur BaWue


insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'sva_inst'::char(18),'kenn_pbv_aggr'::char(18),'Institution' || trim(ch110_besch_st) ||' im Bereich Personal ist nicht dem Bundesschlssel des Fachgebiets zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_pbv_aggr 
where bund_fachgebiet is null;  

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'sva_inst'::char(18),'Bund-Fachgebiet-Schlssel ' || trim(B.bund_fachgebiet)  
||' im Bereich Personal ist unbekannt !'::char(200), 'Warnung'::char(10) 
from tmp_pbv_aggr2 B  left outer join kenn_lfb_fg L
on (B.bund_fachgebiet=L.apnr)
where L.apnr  is null
and B.bund_fachgebiet is not null;
</#if>

insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'sva_k_vertragsart'::char(18),'kenn_pbv_aggr'::char(18),'Vertragsart ' || trim(vertart) ||' im Bereich Personal ist nicht dem Bundesschlssel der Ttigkeit (haupt/nebenberufl.) zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_pbv_aggr 
where (bund_taetigkeit is null or bund_taetigkeit not in (1,2))
and zaehlung !='p';  

insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'sva_k_dienstart'::char(18),'kenn_pbv_aggr'::char(18),'Dienstart ' || trim(ca107_dienstart) || ' im Bereich Personal ist nicht dem Bundesschlssel der Dienstart (wiss./nichtwiss.) zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_pbv_aggr 
where (bund_dienstart is null or bund_dienstart not in (1,2))
and zaehlung !='p';  

insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'sva_k_amtsdienst'::char(18),'kenn_pbv_aggr'::char(18),'Amts-Dienstbez. ' || trim(ca108_amtsbez) || ' im Bereich Personal ist nicht dem Bundesschlssel der Amts-Dienstbez. (Professoren etc) zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_pbv_aggr 
where buadbz is null
and zaehlung !='p'
;  

insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'sva_geldgeber'::char(18),'kenn_pbv_aggr'::char(18),'Geldgeber ' || trim(ch212_geldgeber) || ' im Bereich Personal ist nicht dem Landesschlssel des Geldgebers (KLR) zugeordnet !'::char(200), 'Warnung'::char(10) 
from tmp_pbv_aggr 
where klr_geldgeber is null
and ch212_geldgeber is not null;  

insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'sva_geldgeber'::char(18),'kenn_pbv_aggr'::char(18),'Geldgeber ' || trim(ch212_geldgeber) || ' im Bereich Personal weicht im Feld klr_geldgeber von der Sicht Mittelherkunft KLR BaWue ab !'::char(240), 'Warnung'::char(10) 
from tmp_pbv_aggr A, sva_cifx C 
where C.key=636
and A.ch212_geldgeber=C.apnr
and trim('KLR_' || A.klr_geldgeber) != trim(C.gruppe) 
and ch212_geldgeber is not null; 




drop table tmp_doppelt;



--Lschung vorh. Stichtage:
delete from kenn_pbv_aggr
where stichtag in (select distinct stichtag
from tmp_pbv_aggr2)
;
insert into kenn_pbv_aggr(hs_nr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       kapitel,
       stichtag,
       zaehlung,
       datum,
       summe,
       extkost,
       extkotr,
       befristet,
       staat)
       select 
       hs_nr,
       geschlecht,
       bund_fachgebiet,
       bund_taetigkeit,
       bund_dienstart,
       buadbz,
       klr_geldgeber,
       kapitel,
       stichtag,
       zaehlung,
       datum,
       summe,
       extkost,
       extkotr,
       befristet,
       ca501_staat
       from tmp_pbv_aggr2;
       
drop table tmp_pbv_aggr;
drop table tmp_pbv_aggr2;

</#if>
