--Freemarker Template 

<sqlvars>
<sqlvar name="sva_installed">
select count(*) from db_version where his_system ='sva';
</sqlvar>
</sqlvars>

<#if sva_installed=1>

delete from kenn_pbe_aggr where 0=
(select apnr from konstanten where beschreibung ='KENN_STELLEN_ARCHIV');


create temp table tmp_sgd_einz (
stellen_nr integer,
sbst_nr integer,
ch110_besch_st char(10),
bund_fachgebiet char(10),
ca107_dienstart char(10),
buadbz char(10),
stichtag date,
faktor decimal(3,2),
titel CHAR(5) , 
ca109_key_bvl char(10),
bund_bvl_stelle CHAR(10) , 
ca115_haushverm char(10),
hhv SMALLINT , 
kategorie_gruppe SMALLINT,
plan smallint,
leer smallint
);


create temp table tmp_sgd_aggr (
stellen_nr integer,
sbst_nr integer,
ch110_besch_st char(10),
bund_fachgebiet char(10),
ca107_dienstart char(10),
bund_dienstart SMALLINT,
faktor decimal(3,2),
buadbz char(10),
besetzung char(1),
ca108_amtsbez char(10),
vzae_besetzung DECIMAL(10,2),
vzae_besetzung_beamt DECIMAL(10,2),
vzae_besetzung_besch DECIMAL(10,2),
vzae_besetzung_uw DECIMAL(10,2),
koepfe_besetzung DECIMAL(10,2), 
buadbz_besetzung char(10),
da_besetzung SMALLINT,
taet_besetzung SMALLINT,
stichtag date,
datum date,
zaehlung char(1),
summe decimal(10,2),
titel CHAR(5) , 
ca109_key_bvl char(10),
bund_bvl_stelle CHAR(10) , 
kennzeichen char(4),
hhv SMALLINT , 
kategorie_gruppe SMALLINT 
);

create temp table tmp_pbe_einz (
stichtag date,
stellen_nr integer,
soe_serial integer,
pbe_serial integer,
personal_nr integer,
besch_verh_nr integer,
ch110_besch_st_p char(10),
kostenstelle char(10),
vzae_besetzung decimal(10,2),
koepfe_besetzung decimal(10,2),
ca107_dienstart char(10),
ca108_amtsbez char(10),
ca107_dienstart_p char(10),
ca108_amtsbez_p char(10),
vertart char(10),
da_besetzung smallint,
taet_besetzung smallint,
pbe_prozent decimal(14,3),
buadbz_besetzung char(10),
abw_besetzt SMALLINT,
vertart_besetzung smallint
);

create temp table tmp_pbe_aggr_dup (
stichtag date,
stellen_nr integer,
soe_serial integer,
pbe_serial integer,
personal_nr integer,
besch_verh_nr integer,
ch110_besch_st_p char(10),
kostenstelle char(10),
vzae decimal(10,2),
ca107_dienstart char(10),
ca108_amtsbez char(10),
ca107_dienstart_p char(10),
ca108_amtsbez_p char(10),
vertart char(10),
da_besetzung smallint,
taet_besetzung smallint,
pbe_prozent decimal(14,3),
buadbz_besetzung char(10),
abw_besetzt SMALLINT,
vertart_besetzung smallint
);

create temp table tmp_pbe_aggr(
		hs_nr INTEGER , 
bund_fachgebiet CHAR(10) , 
bund_dienstart SMALLINT , 
faktor decimal(3,2) , 
buadbz CHAR(10) , 
besetzung CHAR(1) , 
buadbz_besetzung CHAR(10) , 
da_besetzung SMALLINT , 
taet_besetzung SMALLINT , 
stichtag DATE , 
datum date , 
zaehlung CHAR(2) , 
summe decimal(10,2) 
) 
;


--Zuerst einzelne Stellen, wg. Duplikaten
insert into tmp_sgd_einz (stellen_nr,
sbst_nr,
ch110_besch_st,
ca107_dienstart,
faktor,
buadbz,
stichtag,
ca109_key_bvl ,
plan,
leer
)
select distinct stellen_nr,
sbst_nr,
ch110_besch_st,
ca107_dienstart,
faktor,
buadbz,
S.stichtag,
A.ca109_key_bvl ,
A.plan,
A.leer
from sva_inst I,sva_sgd_aggr A, kenn_stichtag S
where 
--year(today())=year(S.stichtag)
S.stichtag between d_gueltig_anfang and d_gueltig_ende
and S.stichtagsart_id='STLI'
and S.berechnen='1'
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL=1 || K_KENN_PROFIL=2 ||K_KENN_PROFIL=3)>
--nur BaWue
--Filter auf plan
and A.plan=1
</#if>
and I.key_apnr=A.ch110_besch_st
and S.stichtag between I.gueltig_seit and I.gueltig_bis
;
--VZAE
insert into tmp_sgd_aggr (stellen_nr,
sbst_nr,
ch110_besch_st,
ca107_dienstart,
--faktor,
buadbz,
besetzung,
stichtag,
datum,
zaehlung,
titel  , 
ca109_key_bvl ,
faktor)
select stellen_nr,
sbst_nr,
ch110_besch_st,
ca107_dienstart,
--faktor,9
buadbz,
'N'::char(1),
S.stichtag,
today(),
'v'::char(1),
titel  , 
ca109_key_bvl ,
sum(faktor)
from tmp_sgd_einz S
group by 1,2,3,4,5,6,7,8,9,10,11;

update tmp_sgd_aggr set bund_fachgebiet=(select bund_fachgebiet from sva_inst where key_apnr=tmp_sgd_aggr.ch110_besch_st)
;
update tmp_sgd_aggr set bund_dienstart=(select val(bund_dienstart) from sva_k_dienstart where apnr=tmp_sgd_aggr.ca107_dienstart)
;
update tmp_sgd_aggr set bund_bvl_stelle=(select bund_bvlgruppe 
from sva_k_bvlgruppe where apnr=tmp_sgd_aggr.ca109_key_bvl)
;



--Besetzte Stellen
--zunchst Duplikate aufgrund von HHV rausfischen mit distinct:
insert into tmp_pbe_aggr_dup (stichtag,
stellen_nr,
soe_serial,
pbe_serial,
personal_nr ,
besch_verh_nr ,
ch110_besch_st_p ,
kostenstelle ,
pbe_prozent,
vertart,
ca107_dienstart_p,
ca108_amtsbez_p,
vzae
)
select distinct S.stichtag,
B.stellen_nr,
B.soe_serial ,
B.pbe_serial,
B.personal_nr,
B.besch_verh_nr,
ch110_besch_st_p ,
kostenstelle ,
prozent,
B.vertart,
B.ca107_dienstart_p,
B.ca108_amtsbez_p,
B.prozent/100
from sva_pbe_aggr B, kenn_stichtag S 
where 
 S.stichtag between B.d_besetz_anfang and B.d_besetz_ende
 and S.berechnen='1'
 and S.stichtagsart_id='STLI'
<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL=1 || K_KENN_PROFIL=2 ||K_KENN_PROFIL=3)>
--nur BaWue: nur echte Besetzungen, keine Mittelschpfungen
and B.personal_nr is not null
</#if>
 and ${SVA_PBE_AGGR_BESETZ}
;

insert into tmp_pbe_einz (stichtag,
stellen_nr,
soe_serial,
pbe_serial,
personal_nr ,
besch_verh_nr ,
ch110_besch_st_p ,
kostenstelle ,
pbe_prozent,
abw_besetzt,
vertart,
ca107_dienstart_p,
ca108_amtsbez_p,
vzae_besetzung,
koepfe_besetzung 
)
select B.stichtag,
B.stellen_nr,
B.soe_serial ,
B.pbe_serial,
B.personal_nr,
B.besch_verh_nr,
B.ch110_besch_st_p ,
B.kostenstelle ,
B.pbe_prozent,
B.abw_besetzt,
B.vertart,
B.ca107_dienstart_p,
B.ca108_amtsbez_p,
sum(B.vzae),
count(distinct B.personal_nr)  --eigentlich Unsinn, muss immer 1 sein
from tmp_pbe_aggr_dup B
group by 1,2,3,4,5,6,7,8,9,10,11,12,13;






 
update tmp_pbe_einz set da_besetzung=(select val(bund_dienstart) from sva_k_dienstart where apnr=tmp_pbe_einz.ca107_dienstart_p);
update tmp_pbe_einz set taet_besetzung=(select val(bund_taetigkeit) from sva_k_vertragsart where apnr=tmp_pbe_einz.vertart);
update tmp_pbe_einz set buadbz_besetzung=(select bund_adbz from sva_k_amtsdienst where apnr=tmp_pbe_einz.ca108_amtsbez_p);
--VZ Besetzung:
insert into tmp_pbe_aggr(
       bund_fachgebiet,
       bund_dienstart,
       faktor,
       buadbz,
       buadbz_besetzung,
       da_besetzung,
       taet_besetzung,
       stichtag,
       datum,
       zaehlung,
       summe)
       select 
       bund_fachgebiet,
       bund_dienstart,
       faktor,
       buadbz,
       B.buadbz_besetzung,
       B.da_besetzung,
       B.taet_besetzung,
       B.stichtag,
       S.datum,
       'v'::char(1),
       sum(B.vzae_besetzung)
from tmp_sgd_aggr S,tmp_pbe_einz B
where S.stichtag=B.stichtag
and S.stellen_nr=B.stellen_nr
and (B.soe_serial=S.sbst_nr or B.soe_serial is null)
group by 1,2,3,4,5,6,7,8,9,10;
--Kpfe
insert into tmp_pbe_aggr(
       bund_fachgebiet,
       bund_dienstart,
       faktor,
       buadbz,
       buadbz_besetzung,
       da_besetzung,
       taet_besetzung,
       stichtag,
       datum,
       zaehlung,
       summe)
       select 
       bund_fachgebiet,
       bund_dienstart,
       faktor,
       buadbz,
       B.buadbz_besetzung,
       B.da_besetzung,
       B.taet_besetzung,
       B.stichtag,
       S.datum,
       'k'::char(1),
       count(distinct B.personal_nr)
from tmp_sgd_aggr S,tmp_pbe_einz B
where S.stichtag=B.stichtag
and S.stellen_nr=B.stellen_nr
and (B.soe_serial=S.sbst_nr or B.soe_serial is null)
group by 1,2,3,4,5,6,7,8,9,10;

update tmp_pbe_aggr set hs_nr=(select hs_nr from hochschulinfo);

--Fr Diagnose:

-- select da_besetzung,vzae_besetzung from tmp_pbe_einz where stellen_nr=564
-- and stichtag=date_val('01.12.2014');
-- 
-- select S.stellen_nr,
-- S.faktor,
-- sum(B.vzae_besetzung) as vzae_besetzung,
-- count(distinct B.personal_nr) as koepfe
-- from tmp_sgd_aggr S,tmp_pbe_einz B
-- where S.stichtag=B.stichtag
-- and S.stellen_nr=B.stellen_nr
-- and (B.soe_serial=S.sbst_nr or B.soe_serial is null)
-- and S.stichtag=date_val('01.12.2014')
-- --and S.stellen_nr in (554)
-- BaWue--fr Kennz 57:
-- and buadbz not like '0%'
-- and B.da_besetzung=1
-- and B.taet_besetzung=1
-- --fuer Kennz. 53:
--and S.buadbz like '0%'  
-- group by 1,2
--order by 1,2
-- ;

--Lschung vorh. Stichtage:
delete from kenn_pbe_aggr
where stichtag in (select distinct stichtag
from tmp_pbe_aggr)
;

insert into kenn_pbe_aggr (hs_nr,
       bund_fachgebiet,
       bund_dienstart,
       faktor,
       buadbz,
       buadbz_besetzung,
       da_besetzung,
       taet_besetzung,
       stichtag,
       datum,
       zaehlung,
       summe)
select hs_nr,
bund_fachgebiet,
       bund_dienstart,
       faktor,
       buadbz,
       buadbz_besetzung,
       da_besetzung,
       taet_besetzung,
       stichtag,
       datum,
       zaehlung,
       summe
       from tmp_pbe_aggr;




drop table tmp_sgd_aggr;
drop table tmp_pbe_aggr;
drop table tmp_sgd_einz;
drop table tmp_pbe_einz;
drop table tmp_pbe_aggr_dup;


</#if>
