
--Freemarker Template 

<sqlvars>
--landesspezifika ermitteln: 5='nrw',14='Sachsen',8 'BaWue'
<sqlvar name="bland_kuerzel">
select 746::integer as kuerzel from cif where key=659 and apnr=5 
union
select 751::integer from cif where key=659 and apnr=14 
union
select 750::integer from cif where key=659 and apnr=8
union
select 750::integer from xdummy where 0=(
select count(*) from cif where key=659 and apnr in (5,8,14)) 
;
</sqlvar>
<sqlvar name = "k_astat_studienfach_land_exists">
SELECT sp_table_exists('k_astat_studienfach_land') FROM xdummy;
</sqlvar>
<sqlvar name = "k_astat_abschluss3steller_land_exists">
SELECT sp_table_exists('k_astat_abschluss3steller_land') FROM xdummy;
</sqlvar>
<sqlvar name = "k_astat_staat_eu_exists">
SELECT sp_table_exists('k_astat_staat_eu') FROM xdummy;
</sqlvar>
<sqlvar name = "sos_staat_eu_exists">
SELECT sp_table_exists('sos_staat_eu') FROM xdummy;
</sqlvar>
<sqlvar name="abschlusstypen" type="hashsequence">
SELECT apnr,lang_3 as whereclause from kenn_cifx
where key=689
and apnr !='S' --sonstige wird unten als Joker genutzt
;
</sqlvar>
<sqlvar name = "ewr_staaten">
select lang_3 as ewr_staaten from kenn_cifx where key=691
and apnr='BA_EWR';
</sqlvar>
</sqlvars>

<#assign staat_eu_table_name="" />
<#if k_astat_staat_eu_exists==1>
	<#assign staat_eu_table_name="k_astat_staat_eu" />
<#elseif sos_staat_eu_exists==1>
	<#assign staat_eu_table_name="sos_staat_eu" />
</#if>

--(c) 2008 Daniel Quathamer
delete from kenn_lab_aggr_astat where 0=
(select apnr from konstanten where beschreibung ='KENN_STUDIUM_ARCHIV');

--zuerst bereinigen:es darf nur 2015er oder 2016er Lieferung geben.
--2016 hat Prioritt:
create temp table tmp_sem
(
semester integer,
format integer
);
insert into tmp_sem
select distinct semester,2015
from kenn_lab_astat_2015
where semester in(
select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='PRFA'
);
insert into tmp_sem
select distinct semester,2016
from kenn_lab_astat
where semester in(
select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='PRFA'
);

insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_lab_astat'::char(18),'Semester '|| semester || ' liegt in 2015er und 2016er Format vor, 2015 wird gelscht', 'Info'::char(10) 
from kenn_lab_astat_2015
where semester in (
select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='PRFA'
)
and semester in (select T.semester
from tmp_sem T
where T.format=2016) ;  


delete from kenn_lab_astat_2015
where semester in (
select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='PRFA'
)
and semester in (select T.semester
from tmp_sem T
where T.format=2016);

drop table tmp_sem;


create temp table tmp_lab_aggr_astat(
quellformat smallint,
	hs_nr INTEGER , 
	matrikel_nr integer,
	ef006 varchar(255),
studiengang_nr SMALLINT , 
fach_nr SMALLINT , 
geschlecht SMALLINT , 
ca12_staat SMALLINT , 
sem_der_pruefung SMALLINT , 
stg_land CHAR(4) , 
stg CHAR(4) , 
sb char(19),
fgr char(10),
abschluss_astat_land char(10),
abschluss_astat_bund char(10),
abschlussart char(10),
abgrp char(255),
abschlusstyp char(10), --BaWue Gruppierung 2024
regel SMALLINT , 
fach_sem_zahl SMALLINT , 
hzbart_astat CHAR(10) , 
hzbkfzkz CHAR(2) , 
hzb_staat integer,
hzb_staat_eu smallint,
hzb_staat_ewr smallint,
stort CHAR(10) , 
stufrm CHAR(10) , 
pruefung_monat SMALLINT , 
pruefung_jahr SMALLINT , 
pruefung_ergebnis SMALLINT ,
ausland smallint,
datum date , 
summe INTEGER 
) 
;

<#assign  studiengang_nr_fach_nr = [
  {"studiengang_nr":"1", "fach_nr":"1", "fach":"ef150","abschluss":"ef147u2", "regel":"ef149", "pruefung_monat":"ef155", "pruefung_jahr":"ef156", "pruefung_ergebnis":"ef157", "fach_sem_zahl":"ef127","stufrm":"ef147u1"},
  {"studiengang_nr":"1", "fach_nr":"2", "fach":"ef151","abschluss":"ef147u2", "regel":"ef149", "pruefung_monat":"ef155", "pruefung_jahr":"ef156", "pruefung_ergebnis":"ef157", "fach_sem_zahl":"ef127","stufrm":"ef147u1"},
  {"studiengang_nr":"1", "fach_nr":"3", "fach":"ef153","abschluss":"ef147u2", "regel":"ef149", "pruefung_monat":"ef155", "pruefung_jahr":"ef156", "pruefung_ergebnis":"ef157", "fach_sem_zahl":"ef127","stufrm":"ef147u1"},
  {"studiengang_nr":"2", "fach_nr":"1", "fach":"ef187","abschluss":"ef184u2", "regel":"ef186", "pruefung_monat":"ef192", "pruefung_jahr":"ef193", "pruefung_ergebnis":"ef194", "fach_sem_zahl":"ef164","stufrm":"ef184u1"},
  {"studiengang_nr":"2", "fach_nr":"2", "fach":"ef188","abschluss":"ef184u2", "regel":"ef186", "pruefung_monat":"ef192", "pruefung_jahr":"ef193", "pruefung_ergebnis":"ef194", "fach_sem_zahl":"ef164","stufrm":"ef184u1"},
  {"studiengang_nr":"2", "fach_nr":"3", "fach":"ef190","abschluss":"ef184u2", "regel":"ef186", "pruefung_monat":"ef192", "pruefung_jahr":"ef193", "pruefung_ergebnis":"ef194", "fach_sem_zahl":"ef164","stufrm":"ef184u1"}
  ] />

<#assign  studiengang_nr_fach_nr_2015 = [
  {"studiengang_nr":"1", "fach_nr":"1", "fach":"ef127","abschluss":"ef126u2", "regel":"null::char(1)", "pruefung_monat":"ef132", "pruefung_jahr":"ef133", "pruefung_ergebnis":"ef134", "fach_sem_zahl":"ef121","stufrm":"ef126u1"},
  {"studiengang_nr":"1", "fach_nr":"2", "fach":"ef128","abschluss":"ef126u2", "regel":"null::char(1)", "pruefung_monat":"ef132", "pruefung_jahr":"ef133", "pruefung_ergebnis":"ef134", "fach_sem_zahl":"ef121","stufrm":"ef126u1"},
  {"studiengang_nr":"1", "fach_nr":"3", "fach":"ef129","abschluss":"ef126u2", "regel":"null::char(1)", "pruefung_monat":"ef132", "pruefung_jahr":"ef133", "pruefung_ergebnis":"ef134", "fach_sem_zahl":"ef121","stufrm":"ef126u1"},
  {"studiengang_nr":"2", "fach_nr":"1", "fach":"ef143","abschluss":"ef142u2", "regel":"null::char(1)", "pruefung_monat":"ef148", "pruefung_jahr":"ef149", "pruefung_ergebnis":"ef150", "fach_sem_zahl":"ef137","stufrm":"ef142u1"},
  {"studiengang_nr":"2", "fach_nr":"2", "fach":"ef144","abschluss":"ef142u2", "regel":"null::char(1)", "pruefung_monat":"ef148", "pruefung_jahr":"ef149", "pruefung_ergebnis":"ef150", "fach_sem_zahl":"ef137","stufrm":"ef142u1"},
  {"studiengang_nr":"2", "fach_nr":"3", "fach":"ef145","abschluss":"ef142u2", "regel":"null::char(1)", "pruefung_monat":"ef148", "pruefung_jahr":"ef149", "pruefung_ergebnis":"ef150", "fach_sem_zahl":"ef137","stufrm":"ef142u1"}
  ] />


  
  
<#foreach stgnr in studiengang_nr_fach_nr>
--${stgnr.studiengang_nr}. Studiengang, ${stgnr.fach_nr}. Fach:
insert into tmp_lab_aggr_astat(
quellformat,
hs_nr,
matrikel_nr,
ef006,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_der_pruefung,
       stg_land,
       abschluss_astat_land,
       regel,
       fach_sem_zahl,
       hzbart_astat,
       hzbkfzkz,
       hzb_staat,
stort , 
stufrm  , 
       pruefung_monat,
       pruefung_jahr,
       pruefung_ergebnis,
       datum,
       summe)
 select
 2016,
 hs_nr,
 matrikel_nr,
 ef006,
${stgnr.studiengang_nr} as       studiengang_nr,
${stgnr.fach_nr} as       fach_nr,
val(ef007) as geschlecht,
val(ef010) as ca12_staat,
semester as       sem_der_pruefung,
${stgnr.fach} as stg_land,
${stgnr.abschluss} as abschluss,
val(${stgnr.regel}) as regel,
val(${stgnr.fach_sem_zahl}) as fach_sem_zahl,
ef118 as hzbart_astat,
ef119u1 as hzbkfzkz,
(case when ef119u1='99' then val(ef119u2) else 0 end) as hzb_staat,
ef004 as stort,
${stgnr.stufrm},
val(${stgnr.pruefung_monat}) ,
val(${stgnr.pruefung_jahr}) ,
val(${stgnr.pruefung_ergebnis}) ,
today(),
       count(*) as summe
FROM kenn_lab_astat 
where ${stgnr.abschluss} is not null
<#if stgnr.studiengang_nr!="1" || stgnr.fach_nr !="1"> 
--der "Kopf"-Satz kommt immer rein, weil bei Absolventenmeldungen Promotion oft das Fach fehlt:
and ${stgnr.fach} is not null
</#if>
and semester in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='PRFA')
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22
 ;

</#foreach>

  
<#foreach stgnr in studiengang_nr_fach_nr_2015>
--${stgnr.studiengang_nr}. Studiengang, ${stgnr.fach_nr}. Fach:
insert into tmp_lab_aggr_astat(
quellformat,
hs_nr,
matrikel_nr,
ef006,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_der_pruefung,
       stg_land,
       abschluss_astat_land,
       regel,
       fach_sem_zahl,
       hzbart_astat,
       hzbkfzkz,
       hzb_staat,
stort , 
stufrm  , 
       pruefung_monat,
       pruefung_jahr,
       pruefung_ergebnis,
       datum,
       summe)
 select
 2015,
 hs_nr,
 matrikel_nr,
 ef006,
${stgnr.studiengang_nr} as       studiengang_nr,
${stgnr.fach_nr} as       fach_nr,
val(ef007) as geschlecht,
val(ef009) as ca12_staat,
semester as       sem_der_pruefung,
${stgnr.fach} as stg_land,
${stgnr.abschluss} as abschluss,
val(${stgnr.regel}) as regel,
val(${stgnr.fach_sem_zahl}) as fach_sem_zahl,
ef110 as hzbart_astat,
ef111u1 as hzbkfzkz,
(case when ef111u1='99' then val(ef111u2) else 0 end) as hzb_staat,
ef004 as stort,
${stgnr.stufrm},
val(${stgnr.pruefung_monat}) ,
val(${stgnr.pruefung_jahr}) ,
val(${stgnr.pruefung_ergebnis}) ,
today(),
       count(*) as summe
FROM kenn_lab_astat_2015 
where ${stgnr.abschluss} is not null
<#if stgnr.studiengang_nr!="1" || stgnr.fach_nr !="1"> 
--der "Kopf"-Satz kommt immer rein, weil bei Absolventenmeldungen Promotion oft das Fach fehlt:
and ${stgnr.fach} is not null
</#if>
and semester in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='PRFA')
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22
 ;

</#foreach>

--ermittlung der HZB-Art aus Studierendenlieferung
--neues Format:
update tmp_lab_aggr_astat set hzbart_astat=(select min(A.ef118)
from kenn_sos_astat A
where A.matrikel_nr=tmp_lab_aggr_astat.matrikel_nr
and A.semester<=tmp_lab_aggr_astat.sem_der_pruefung
and trim(A.ef118) !='')
where quellformat=2016
and (hzbart_astat is null or trim(hzbart_astat)='')
and matrikel_nr != -1 --nur wenn keine Promotionen mit knstl. Matrikelnr.
;
--altes Format:
update tmp_lab_aggr_astat set hzbart_astat=(select min(ef110)
from kenn_sos_astat_2015 A
where A.matrikel_nr=tmp_lab_aggr_astat.matrikel_nr
and A.semester<=tmp_lab_aggr_astat.sem_der_pruefung
and trim(A.ef110) !='')
where quellformat=2015
and (hzbart_astat is null or trim(hzbart_astat)='')
and matrikel_nr != -1 --nur wenn keine Promotionen mit knstl. Matrikelnr.
;


<#if k_astat_studienfach_land_exists=1>

SELECT L.schluessel,
       L.land,
       null::char(10) as keybund,
       max(nvl(L.gueltig_bis,30001)) as gueltig_bis
   into temp tmp_stg
FROM k_astat_studienfach_land L, cif C
where L.land=C.apnr
and C.key=659 --Bundesland der Hochschule
group by 1,2,3;

update tmp_stg set keybund=(select distinct L.keybund
from k_astat_studienfach_land L
where L.schluessel=tmp_stg.schluessel
and L.land=tmp_stg.land
and (L.gueltig_bis=tmp_stg.gueltig_bis or (L.gueltig_bis is null and tmp_stg.gueltig_bis =30001))
);

update tmp_lab_aggr_astat set stg=(select K.keybund from tmp_stg K where (tmp_lab_aggr_astat.stg_land=K.schluessel or tmp_lab_aggr_astat.stg_land='0' || K.schluessel))
where 1=(select count(*) from tmp_stg K where tmp_lab_aggr_astat.stg_land=K.schluessel or tmp_lab_aggr_astat.stg_land='0' || K.schluessel);

update tmp_lab_aggr_astat set stg='0' || stg where length(trim(stg))=3;


drop table tmp_stg;
</#if>


update tmp_lab_aggr_astat set sb=(select A.parent from kenn_stg_astat A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_lab_aggr_astat.sem_der_pruefung
and A.astat=tmp_lab_aggr_astat.stg_land);
update tmp_lab_aggr_astat set fgr=(select A.parent from kenn_stg_astat A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_lab_aggr_astat.sem_der_pruefung
and A.astat=tmp_lab_aggr_astat.sb);

update tmp_lab_aggr_astat set fgr=(select A.apnr from kenn_dim_fgr A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_lab_aggr_astat.sem_der_pruefung
and A.fg_studierende=tmp_lab_aggr_astat.fgr);

update tmp_lab_aggr_astat set fgr='U' where fgr is null;


update tmp_lab_aggr_astat set abschlussart=(select A.parent from kenn_abschl_astat A
where A.astat=tmp_lab_aggr_astat.abschluss_astat_land);
update tmp_lab_aggr_astat set abgrp='BA' where abschlussart='A24';
update tmp_lab_aggr_astat set abgrp='MA' where abschlussart='A37';
--Diplom 
update tmp_lab_aggr_astat set abgrp='D' where abschluss_astat_land in (
'11', --Diplom Uni                                                                                          
'12', --Diplom Uni Dolmetscher                                                                              
'13', --Diplom Uni bersetzer                                                                               
'14', --Diplom I UNI GH                                                                                     
'18', --Diplom Lehrerprfung Uni                                                                            
'29', --sonst.LA nach Schulart                                                                              
'51', --Diplom FH                                                                                           
'53', --Diplom FH Dolmetscher                                                                               
'54', --Diplom FH bersetzer                                                                                
'75' --Diplom Kunsthochschule 
);
--Staatsexamen:
update tmp_lab_aggr_astat set abgrp='ST' where abschluss_astat_land in (
'08', --Staatsexamen ohn.LA Prfg.                                                                           
'09', --Staatsexamen einphasig                                                                              
'20', --LA Grund- und Hauptschulen
'21', --LA Grundschulen
'22', --LA Hauptschulen
'42', --LA Grundstufe/Primarstufe
'28', --LA Sekundarstufe I/Primarstufe
'40', --LA Grundschulen/Sekundarstufe I
'23', --LA Realschulen
'24', --LA Haupt- und Realschulen/Unterstufe und Mittelstufe Gymnasien
'43', --LA Mittelstufe/Sekundarstufe I
'41', --LA Sekundarstufe II/Sekundarstufe I
'25', --LA Gymnasien
'44', --LA Oberstufe/Sekundarstufe II, allgemeinbildende Schulen
'26', --LA Sonderschulen/Frderschulen
'27', --LA Berufliche Schulen
'45', --LA Oberstufe/Sekundarstufe II, berufliche Schulen
'29' --Sonstige Staatsprfungen nach Schularten/Schulstufen
);
--Promotion:
update tmp_lab_aggr_astat set abgrp='P' where abschluss_astat_land in ('06','07','91','92');


update tmp_lab_aggr_astat set abgrp='S' where abgrp is null;
--Studienbezogene Auslandsaufenthalte fr die 1. Prfung Staat:
update tmp_lab_aggr_astat set ausland=1
where 0< (select count(*) from  kenn_lab_astat A
where A.semester=tmp_lab_aggr_astat.sem_der_pruefung
and A.ef006=tmp_lab_aggr_astat.ef006
and (A.ef135 !='' or A.ef139  !='' or A.ef143 !='')
);

update tmp_lab_aggr_astat set ausland=0 where ausland is null;

<#if k_astat_abschluss3steller_land_exists=1>
-- Bund Abschluss ermitteln:
update tmp_lab_aggr_astat set abschluss_astat_bund=(select min(substring(K.keybund from 2 for 2))
from k_astat_abschluss3steller_land K, cif C
where K.land=C.apnr
and C.key=659 --Bundesland der Hochschule
and substring(K.schluessel from 2 for 2) =tmp_lab_aggr_astat.abschluss_astat_land);

--Fallback: 
update tmp_lab_aggr_astat set abschluss_astat_bund=abschluss_astat_land
where abschluss_astat_bund is null;

<#else>
--Fallback: vor Kern 5.1 gab es keine Zuordnung in kenn:
update tmp_lab_aggr_astat set abschluss_astat_bund=abschluss_astat_land;

</#if>


--HZB-Staat EWR
update tmp_lab_aggr_astat set hzb_staat_ewr=1
where hzb_staat in (${ewr_staaten});


--HZB-Staat EU?
--hzb_staat_eu ermitteln:
<#if staat_eu_table_name!="">
update tmp_lab_aggr_astat set hzb_staat_eu=1
where hzb_staat=0
or exists (select eu
from k_astat_staat_eu E
where tmp_lab_aggr_astat.sem_der_pruefung between E.semester_von and E.semester_bis
and val(E.astat)= tmp_lab_aggr_astat.hzb_staat
and eu='J');

update tmp_lab_aggr_astat set hzb_staat_eu=0
where hzb_staat!=0
and exists (select eu
from k_astat_staat_eu E
where tmp_lab_aggr_astat.sem_der_pruefung between E.semester_von and E.semester_bis
and val(E.astat)= tmp_lab_aggr_astat.hzb_staat
and eu='N');
</#if>
--Gruppierung und Lehramt:
<#if abschlusstypen?has_content>
<#foreach typ in abschlusstypen>

update tmp_lab_aggr_astat set abschlusstyp='${typ.apnr}'
where abschluss_astat_bund in (${typ.whereclause})
;
</#foreach>
</#if>

update tmp_lab_aggr_astat set abschlusstyp='S' where abschlusstyp is null;



delete from kenn_lab_aggr_astat
where sem_der_pruefung in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='PRFA')
;

insert into kenn_lab_aggr_astat(hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_der_pruefung,
       stg,
       stg_land,
       abschluss,
       fgr,
       abgrp,
       regel,
       fach_sem_zahl,
       hzbart_astat,
       hzbkfzkz,
       stort,
       stufrm,
       pruefung_monat,
       pruefung_jahr,
       pruefung_ergebnis,
       ausland,
       datum,
       summe)
       select hs_nr,
       studiengang_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       sem_der_pruefung,
       stg,
       stg_land,
       abschluss_astat_bund,
       fgr,
       abgrp,
       regel,
       fach_sem_zahl,
       hzbart_astat,
       hzbkfzkz,
       stort,
       stufrm,
       pruefung_monat,
       pruefung_jahr,
       pruefung_ergebnis,
       ausland,
       datum,
       sum(summe)
       from tmp_lab_aggr_astat
       group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22
       ;
       
       
       
delete from kenn_absolv_aggr_astat
where sem_der_pruefung in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='PRFA')
;

insert into kenn_absolv_aggr_astat(hs_nr,
       fach_nr,
       geschlecht,
       bildungstyp,
       sem_der_pruefung,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       aufbaustudium,
       datum,
       summe)
       select 
  hs_nr,
       fach_nr,
       (case when geschlecht=2 then 2 else 1 end) as geschlecht,
       (case when ca12_staat=0 or hzb_staat=0 then 'BI' --Bildungsinlnger = Staat D, oder HZB-art in BRD 
       when hzb_staat_ewr=1 then 'BA_EWR'
       when hzb_staat_eu =1 then 'BA_EU'
       when hzb_staat_eu =0 then 'BA_N_E'
       else 'U' end) as bildungstyp,
       sem_der_pruefung,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       (case when stufrm in ('3','4','6') then 1 else 0 end) as aufbaustudium,
       datum,
       sum(summe)
       from tmp_lab_aggr_astat
       where pruefung_ergebnis =1  --nur bestandene Prfungen
       and hs_nr is not null
       group by hs_nr,
       fach_nr,
       geschlecht,
       ca12_staat,
       hzb_staat,
       hzb_staat_eu,
       hzb_staat_ewr,
       sem_der_pruefung,
       stg,
       stg_land,
       abschlusstyp,
       regel,
       fach_sem_zahl,
       stufrm,
       datum;      


drop table tmp_lab_aggr_astat;

<#if k_astat_studienfach_land_exists=1>

--Korrektur Fchergruppe:
select distinct stg,
sem_der_pruefung as semester,
null::char(19) as sb,
null::char(10) AS fgr
into temp tmp_stg_aggr_astat
from kenn_lab_aggr_astat;

update tmp_stg_aggr_astat set sb=(select A.parent from kenn_stg_astat A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_stg_aggr_astat.semester
and A.astat=tmp_stg_aggr_astat.stg);

update tmp_stg_aggr_astat set fgr=(select A.parent from kenn_stg_astat A, kenn_semester S
where S.sem_beginn between A.gueltig_von and A.gueltig_bis
and S.tid=tmp_stg_aggr_astat.semester
and A.astat=tmp_stg_aggr_astat.sb);

update tmp_stg_aggr_astat set fgr=(select A.apnr from kenn_dim_fgr A
where A.fg_studierende=tmp_stg_aggr_astat.fgr);

update tmp_stg_aggr_astat set fgr='U' where fgr is null;

update kenn_lab_aggr_astat set fgr=(select min(T.fgr)
from tmp_stg_aggr_astat T
where T.stg=kenn_lab_aggr_astat.stg
and T.semester=kenn_lab_aggr_astat.sem_der_pruefung);


drop table tmp_stg_aggr_astat;

</#if>
