
--Freemarker Template

<sqlvars>
    <sqlvar name="fin_installed">
        select count(*) from db_version where his_system ='fin';
    </sqlvar>
    <sqlvar name="cob_installed">
        select count(*) from db_version where his_system ='cob';
    </sqlvar>
    <sqlvar name="kfmkam">
        select apnr from konstanten where beschreibung='KENN_kfm_kam'
        union
        select 0 from xdummy where 0=(select count(*)from konstanten where beschreibung='KENN_kfm_kam');
    </sqlvar>
    <sqlvar name="KENN_FINANZEN_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_FINANZEN_DATENQUELLE'
    </sqlvar>
</sqlvars>

<#macro doubletype>
    <#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>
<#if fin_installed=1||KENN_FINANZEN_DATENQUELLE=170>

    delete from kenn_konto_aggr where 0=
    (select apnr from konstanten where beschreibung ='KENN_FINANZEN_ARCHIV');

    create temp table tmp_quartal
    (
    tid integer,
    bezugszeit integer,
    jahr smallint,
    quartal integer
    );

    --zuerst alle zu berechnenden Quartale zusammenstellen:

    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '1'),
    bezugszeit,
    1
    from kenn_stichtag
    where stichtagsart_id='HASL'
    and berechnen='1'
    and bezugsart='J';
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '2'),
    bezugszeit,
    2

    from kenn_stichtag
    where stichtagsart_id='HASL'
    and berechnen='1'
    and bezugsart='J';
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '3'),
    bezugszeit,
    3

    from kenn_stichtag
    where stichtagsart_id='HASL'
    and berechnen='1'
    and bezugsart='J';
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '4'),
    bezugszeit,
    4
    from kenn_stichtag
    where stichtagsart_id='HASL'
    and berechnen='1'
    and bezugsart='J';

    --nun die einzelnen Quartale, werden ggf. danach mit distinct rausgeworfen
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    bezugszeit ,
    val(substring('' || bezugszeit from 1 for 4)),
    val(substring('' || bezugszeit from 5 for 1))

    from kenn_stichtag
    where stichtagsart_id='HASL'
    and berechnen='1'
    and bezugsart='Q';

    --

    create temp table tmp_quartal2
    (

    bezugszeit integer,
    jahr smallint,
    quartal integer,
    bvkr_sicht_id integer,
    inst_sicht_id integer,
    monat_von smallint,
    monat_bis smallint

    );

    insert into tmp_quartal2
    (bezugszeit,
    jahr,
    quartal)
    select distinct bezugszeit,
    jahr,
    quartal
    from tmp_quartal;

    update tmp_quartal2 set monat_von=quartal*3-2;
    update tmp_quartal2 set monat_bis=quartal*3;

    <#if fin_installed=1&&KENN_FINANZEN_DATENQUELLE!=170>
        <#assign jahrspalte="rechnungsjahr" />
        <#assign monatspalte="monat" />
        <#if K_KENN_FINANZEN_KLRPERIODE?has_content && K_KENN_FINANZEN_KLRPERIODE=1>
            <#assign jahrspalte="klrjahr" />
            <#assign monatspalte="klrmonat" />
        </#if>
        <#if kfmkam=2>
            --kaufmnnischer Zeitbezug (Sachsen):
            <#assign jahrspalte="fibujahr" />
            <#assign monatspalte="fibumonat" />
        </#if>



        --auch Schluesseltabellen
        <#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>
            --nur NHS Sachsen:
            delete from kenn_dr
            where (jahr in (SELECT bezugszeit
            FROM kenn_stichtag where bezugsart='J'
            and stichtagsart_id='HASL'
            and berechnen='1')
            or jahr in (select val(substring('' || K.bezugszeit from 1 for 4)) from kenn_stichtag K
            where  K.berechnen='1'
            and K.stichtagsart_id='HASL'
            and K.bezugsart='Q')
            );

            insert into kenn_dr (jahr, kapitel, dr, dritt, bezeichnung, check1, ktobez)
            SELECT jahr,  kapitel,   dr,  dritt,  bezeichnung,  check1,  ktobez
            FROM fin_dr
            where (jahr in (SELECT bezugszeit
            FROM kenn_stichtag where bezugsart='J'
            and stichtagsart_id='HASL'
            and berechnen='1')
            or jahr in (select val(substring('' || K.bezugszeit from 1 for 4)) from kenn_stichtag K
            where  K.berechnen='1'
            and K.stichtagsart_id='HASL'
            and K.bezugsart='Q')
            );

            update kenn_dr set hs_nr=(select hs_nr from hochschulinfo)
            where hs_nr is null;
            delete from kenn_titel
            where (jahr in (SELECT bezugszeit
            FROM kenn_stichtag where bezugsart='J'
            and stichtagsart_id='HASL'
            and berechnen='1')
            or jahr in (select val(substring('' || K.bezugszeit from 1 for 4)) from kenn_stichtag K
            where  K.berechnen='1'
            and K.stichtagsart_id='HASL'
            and K.bezugsart='Q')
            )
            ;
            insert into kenn_titel (jahr,       kapitel,       dr,       dr2,       titel,       dritt,       ktobez)
            SELECT jahr,       kapitel,       dr,       dr2,       titel,       dritt,       ktobez
            FROM fin_titel
            where (jahr in (SELECT bezugszeit
            FROM kenn_stichtag where bezugsart='J'
            and stichtagsart_id='HASL'
            and berechnen='1')
            or jahr in (select val(substring('' || K.bezugszeit from 1 for 4)) from kenn_stichtag K
            where  K.berechnen='1'
            and K.stichtagsart_id='HASL'
            and K.bezugsart='Q')
            )
            ;
            update kenn_titel set hs_nr=(select hs_nr from hochschulinfo)
            where hs_nr is null;
        </#if>



        create temp table tmp_konto_aggr (
        hs_nr INTEGER ,
        jahr SMALLINT ,
        quartal integer,
        monat SMALLINT ,
        fikrkey CHAR(12) ,
        klr_geldgeber CHAR(10),
        titelgruppe_gege char(5),
        titel char(10),
        zweckbestimmung_ut char(10),
        dr char(5),
        dr2 char(5),
        titelart CHAR(1) ,
        kapitel char(5),
        ch110_institut CHAR(10) ,
        projnr char(10),
        betragsart CHAR(1) ,
        bund_fachgebiet char(10),
        bvkr_art char(12),
        extkotr char(30),
        extkost char(30),
        datum date ,
        kfmkam smallint,
        hhans <@doubletype/> default 0,
        einnahmen <@doubletype/> default 0,
        ausgaben  <@doubletype/> default 0,
        --nur Sachsen bentigt
        akts_tit <@doubletype/> default 0,
        hhans_tit <@doubletype/> default 0,
        einnahmen_tit <@doubletype/> default 0,
        ausgaben_tit  <@doubletype/> default 0,
        reste_tit <@doubletype/> default 0,
        haushaltsvorgriff <@doubletype/> default 0
        );
        update fin_konto_aggr set vojs_tit=0 where vojs_tit is null;
        update fin_konto_aggr set reste_tit=0 where reste_tit is null;

        <#if kfmkam=0||kfmkam=1>
            --Standard kameral
            insert into
            tmp_konto_aggr (
            jahr,
            quartal,
            monat,
            fikrkey,
            titelgruppe_gege,
            titel,
            zweckbestimmung_ut,
            dr,dr2,
            kapitel,
            ch110_institut,
            projnr,
            datum,
            kfmkam,
            hhans,
            einnahmen,
            ausgaben,
            akts_tit,
            hhans_tit,
            einnahmen_tit,
            ausgaben_tit,
            reste_tit
            )
            select A.${jahrspalte},
            Q.bezugszeit,
            A.${monatspalte},
            A.fikr,
            A.titelgruppe_gege,
            A.titel,
            <#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>
                A.zweckbestimmung_ut,A.dr,A.dr2,
            <#else>
                ''::char(1),''::char(1),''::char(1),
            </#if>
            A.kapitel,
            A.ch110_institut,
            A.kostentraeger,
            today(),
            ${kfmkam}::smallint,
            sum(hhans_dr) ,
            sum(einnahmen_dr),
            sum(ausgaben_dr),
            <#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>
                sum(akt_soll_tit),
                sum(hhans_tit) ,
                sum(einnahmen_tit),
                sum(ausgaben_tit),
                sum(reste_tit) -- 9.7.2016 Drittmittelreste nicht mehr bentigt+sum(vojs_tit) -- Haushalt und Drittmittel
            <#else>
                null::<@doubletype/>,null::<@doubletype/>,null::<@doubletype/>,null::<@doubletype/>,null::<@doubletype/>
            </#if>
            from fin_konto_aggr A,tmp_quartal2 Q
            where Q.jahr=A.${jahrspalte}
            and A.${monatspalte} between Q.monat_von and Q.monat_bis
            and ${KENN_FIN_KONTEN}
            group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14;


        <#else>--  kfm

            --update tmp_konto_aggr set einnahmen=0,einnahmen_tit=0,ausgaben=0,ausgaben_tit=0;
            create temp table tmp_berechnung(jahr smallint,monat smallint, ggnr varchar(4),kst_nr varchar(10), ktr_nr varchar(10),koa_nr varchar(12),ertraghaben <@doubletype/> default 0,ertragsoll <@doubletype/> default 0,aufwandsoll <@doubletype/> default 0,aufwandhaben <@doubletype/> default 0);
            -- ERTRAG
            insert into tmp_berechnung (jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,ertraghaben)
            select haushaltsjahr::smallint,month(bdatum),ggnr,kst_nr, ktr_nr,koa_nr,sum(betrag) from fin_fibu_journal
            where kontohaben in (${KENN_DRITT_ERTRAEGE_STANDARD}) and ggnr is not null
            and kontohaben like '5%'
            and kontohaben not in (select sachkonto from fin_fibu_kont where klasse='SKONTO')
            group by 1,2,3,4,5,6;

            insert into tmp_berechnung (jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,ertragsoll)
            select haushaltsjahr::smallint,month(bdatum),ggnr,kst_nr, ktr_nr,koa_nr,sum(betrag) from fin_fibu_journal
            where kontosoll in (${KENN_DRITT_ERTRAEGE_STANDARD}) and ggnr is not null
            and kontosoll like '5%'
            and kontosoll not in (select sachkonto from fin_fibu_kont where klasse='SKONTO')
            group by 1,2,3,4,5,6;

            -- AUFWAND
            insert into tmp_berechnung (jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,aufwandhaben)
            select haushaltsjahr::smallint,month(bdatum),ggnr, kst_nr,ktr_nr,koa_nr,sum(betrag) from fin_fibu_journal
            where kontohaben in (${KENN_DRITT_AUFWAND_STANDARD}) and ggnr is not null
            <#if KENN_DRITT_ABSCHR?exists&&KENN_DRITT_ABSCHR!=''&&KENN_DRITT_ABSCHR!='1=0'>
                and kontohaben not in (${KENN_DRITT_ABSCHR}) -- keine Abschreibungen
            </#if>
            and (kontohaben like '6%' or kontohaben like '7%')
            and kontohaben not in (select sachkonto from fin_fibu_kont where klasse='SKONTO')
            group by 1,2,3,4,5,6;
            insert into tmp_berechnung (jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,aufwandsoll)
            select haushaltsjahr::smallint,month(bdatum),ggnr, kst_nr,ktr_nr,koa_nr,sum(betrag) from fin_fibu_journal
            where kontosoll in (${KENN_DRITT_AUFWAND_STANDARD}) and ggnr is not null
            <#if KENN_DRITT_ABSCHR?exists&&KENN_DRITT_ABSCHR!=''&&KENN_DRITT_ABSCHR!='1=0'>
                and kontosoll not in (${KENN_DRITT_ABSCHR})  -- keine Abschreibungen
            </#if>
            and (kontosoll like '6%' or kontosoll like '7%')
            and kontosoll not in (select sachkonto from fin_fibu_kont where klasse='SKONTO')
            group by 1,2,3,4,5,6;

            create temp table tmp_konto_fibu(jahr smallint,monat smallint, ggnr varchar(4), kst_nr varchar(10),ktr_nr varchar(10), koa_nr varchar(12),ertrag <@doubletype/> default 0,aufwand <@doubletype/> default 0);
            insert into tmp_konto_fibu (jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,ertrag)
            select jahr,monat,ggnr,kst_nr, ktr_nr,koa_nr,sum(ertraghaben)-sum(ertragsoll) from tmp_berechnung
            group by 1,2,3,4,5,6;
            insert into tmp_konto_fibu (jahr,monat,ggnr,kst_nr, ktr_nr,koa_nr,aufwand)
            select jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,sum(aufwandsoll)-sum(aufwandhaben) from tmp_berechnung
            group by 1,2,3,4,5,6;

            --Skonto
            -- vergl. https://hiszilla.his.de/hiszilla/show_bug.cgi?id=152579#c4 und weitere
            --Summe der auf dem als SKONTO klassifizierten Konto im Haben gebuchten Betrge
            --abzglich evtl. im Soll auf diesem Konto gebuchten Betrge.
            delete from tmp_berechnung;
            insert into tmp_berechnung (jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,aufwandhaben)
            select haushaltsjahr::smallint,month(bdatum),ggnr, kst_nr,ktr_nr,koa_nr,sum(betrag)*-1 from fin_fibu_journal
            where kontohaben in (select sachkonto from fin_fibu_kont where klasse='SKONTO')
            and ggnr is not null
            and betrag<0
            group by 1,2,3,4,5,6;
            insert into tmp_berechnung (jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,aufwandhaben)
            select haushaltsjahr::smallint,month(bdatum),ggnr, kst_nr,ktr_nr,koa_nr,sum(betrag) from fin_fibu_journal
            where kontohaben in (select sachkonto from fin_fibu_kont where klasse='SKONTO')
            and ggnr is not null
            and betrag>0
            group by 1,2,3,4,5,6;
            insert into tmp_berechnung (jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,aufwandsoll)
            select haushaltsjahr::smallint,month(bdatum),ggnr, kst_nr,ktr_nr,koa_nr,sum(betrag) from fin_fibu_journal
            where kontosoll in (select sachkonto from fin_fibu_kont where klasse='SKONTO')
            and ggnr is not null
            group by 1,2,3,4,5,6;


            insert into tmp_konto_fibu (jahr,monat,ggnr,kst_nr, ktr_nr,koa_nr,aufwand)
            select jahr,monat,ggnr, kst_nr,ktr_nr,koa_nr,(sum(aufwandhaben)-sum(aufwandsoll))*-1 from tmp_berechnung
            group by 1,2,3,4,5,6;


            drop table tmp_berechnung;




            insert into
            tmp_konto_aggr (
            jahr,
            quartal,
            monat,
            fikrkey,
            titelgruppe_gege,
            ch110_institut,
            projnr,
            datum,
            kfmkam,
            einnahmen,
            ausgaben)
            select A.jahr,
            Q.bezugszeit,
            A.monat,
            A.koa_nr,
            A.ggnr,
            A.kst_nr,
            A.ktr_nr,
            today(),
            ${kfmkam}::smallint,
            sum(ertrag) ,
            sum(aufwand)

            from tmp_konto_fibu A,tmp_quartal2 Q
            where Q.jahr=A.jahr
            and A.monat between Q.monat_von and Q.monat_bis
            group by 1,2,3,4,5,6,7,8,9;

            drop table tmp_konto_fibu;
            <#if K_KENN_PROFIL?exists&& K_KENN_PROFIL==5 && KENN_DRITT_ABSCHR?exists&&KENN_DRITT_ABSCHR!=''&&KENN_DRITT_ABSCHR!='1=0'>
                --Abschreibungen aus der KLR holen:
                insert into
                tmp_konto_aggr (
                jahr,
                quartal,
                monat,
                fikrkey,
                klr_geldgeber,
                extkost,
                extkotr ,
                datum,
                kfmkam,
                ausgaben)
                select A.jahr,
                Q.bezugszeit,
                A.monat,
                A.bvkr_art,
                --kenn_busa_aggr enthlt nicht ggnr, aber klr_geldgeber,
                --beim insert bleibt feld tmp_konto_aggr.titelgruppe_gege null, dadurch wird unten der klr_geldgeber nicht berschrieben
                A.klr_geldgeber,
                A.inst_art,
                A.projnr,
                today(),
                ${kfmkam}::smallint,
                sum(betrag)

                from kenn_busa_aggr A,tmp_quartal2 Q
                where Q.jahr=A.jahr
                and A.monat between Q.monat_von and Q.monat_bis
                and A.kokl_faktor=1 and bvkr_art='K_SK_2_Afa' and inst_art is not null
                -- Freemarker Variable KENN_DRITT_ABSCHR wird nicht bentigt, da ber BVKR_ART abgefragt wird
                group by 1,2,3,4,5,6,7,8,9;
            </#if>
            -- bis hier kaufm
        </#if>





        update tmp_konto_aggr set dr=dr2 where dr2!='';

        <#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==1 || K_KENN_PROFIL==2 || K_KENN_PROFIL==3)>
            --nur in BaWue:
            --bvkr-Kostenart ermitteln:
            --derzeit noch vereinfacht: wenn Nummern bereinstimmen
            --update tmp_konto_aggr set bvkr_art =fikrkey where fikrkey in (
            --select C.apnr from kenn_cifx C where C.key=669 ); --Haushalts-BVKR

            --In Zukunft wird geprft ob es eine Hierarchie fr das Quartal gibt,
            --wenn nein wird die Numerik verwandt

            --Joker: auerhalb der BVKR-Hierarchie
            --update tmp_konto_aggr set bvkr_art='S' where bvkr_art is null;
            --Ende Alte Variante

            --neue Variante:

            --in dieser  Tabelle stehen spaeter Schluessel fuer das jew. Quartal
            create temp table tmp_fikr(fikrkey char(12),quartal integer,
            bvkr_art char(12),ueberkey char(12)
            );
            --Kopie fr Unterselects:
            create temp table tmp_fikr2(fikrkey char(12),quartal integer,
            bvkr_art char(12),ueberkey char(12)
            );



            --nun die zugehrigen Sichten zuordnen:
            --Die Regel geht vom allgemeinen zum Besonderen, d.h. erst die Sicht fr "alle"

            --BVKR
            --Sichten mit stichtag_id=0 gelten fr alle Stichtage
            update tmp_quartal2 set bvkr_sicht_id=(select min(S.tid)
            from sichten S, kenn_sichten K
            where K.sicht_name_intern=S.name_intern
            and K.dimension='BVKR_H'
            and K.stichtag_id=0)
            ;

            --Sicht frs ganze Jahr:
            update tmp_quartal2 set bvkr_sicht_id=(
            select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
            where K.sicht_name_intern=S.name_intern
            and I.tid=K.stichtag_id
            and K.dimension='BVKR_H'
            and I.bezugsart='J'
            and I.bezugszeit=tmp_quartal2.jahr)
            where 0 < (select count(*)
            from sichten S, kenn_sichten K , kenn_stichtag I
            where K.sicht_name_intern=S.name_intern
            and I.tid=K.stichtag_id
            and K.dimension='BVKR_H'
            and I.bezugsart='J'
            and I.bezugszeit=tmp_quartal2.jahr);

            --Sicht frs Quartal:
            update tmp_quartal2 set bvkr_sicht_id=(
            select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
            where K.sicht_name_intern=S.name_intern
            and I.tid=K.stichtag_id
            and K.dimension='BVKR_H'
            and I.bezugsart='Q'
            and I.bezugszeit=tmp_quartal2.bezugszeit)
            where 0 < (select count(*)
            from sichten S, kenn_sichten K , kenn_stichtag I
            where K.sicht_name_intern=S.name_intern
            and I.tid=K.stichtag_id
            and K.dimension='BVKR_H'
            and I.bezugsart='Q'
            and I.bezugszeit=tmp_quartal2.bezugszeit);

            --Ab ins Pruefprotokoll:
            --derzeit noch nicht aktiv, weil MWK noch keine BVKR-Sichten im Bereich Haushalt erhebt:
            -- insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
            -- select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Haushalt gilt folgende BVKR-Kostenartensicht:' || S.name)::char(200), 'Info'::char(10)
            -- from tmp_quartal2 Q, sichten S
            -- where S.tid=Q.bvkr_sicht_id
            -- ;
            -- insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
            -- select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Haushalt ist keine BVKR-Kostenartensicht definiert')::char(200), 'Warnung'::char(10)
            -- from tmp_quartal2 Q
            -- where Q.bvkr_sicht_id is null
            -- ;

            -- insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
            -- select distinct today(),'kenn_sichten'::char(18),'Fr Dimension Kostenarten (BVKR Haushalt) wurde keine Hierarchie aus dem Bereich Haushalt gewhlt, sondern ' || trim(I.name )::char(200), 'Warnung'::char(10)
            -- from  kenn_sichten S, sichten I
            -- where I.name_intern=S.sicht_name_intern
            -- and S.dimension='BVKR_H'
            -- and S.sichtart != 'FIN-Kosten-/Erlsarten-Sicht'
            -- ;

            --\! echo "hier"
            --Wenn alt. Hier. als BVKR-Sicht definiert ist:
            insert into tmp_fikr(fikrkey ,quartal ,
            ueberkey)
            select distinct A.key,Q.bezugszeit,A.parent from
            fin_fikr F,kenn_alt_keys A, tmp_quartal2 Q
            where F.key = A.key
            and Q.bvkr_sicht_id=A.hierarchie_id
            and A.relation='fikr-h'
            and (date_val('01.' || Q.monat_bis || '.' || Q.jahr) >= F.key_von or F.key_von is null )
            and (date_val('01.' || Q.monat_bis || '.' || Q.jahr) <= F.key_bis or F.key_bis is null )
            ;
            -- --Wenn regulre Sicht als KoA-Sicht def.:
            insert into tmp_fikr(fikrkey ,quartal ,
            ueberkey)
            select distinct F.key,Q.bezugszeit,F.ueberg from
            fin_fikr F, sichten S, tmp_quartal2 Q
            where Q.bvkr_sicht_id=S.tid
            and (date_val('01.' || Q.monat_bis || '.' || Q.jahr) >= F.key_von or F.key_von is null )
            and (date_val('01.' || Q.monat_bis || '.' || Q.jahr) <= F.key_bis or F.key_bis is null )
            and S.type=10
            ;


            --Kopie fr Unterselects:
            insert into tmp_fikr2
            select * from tmp_fikr;
            create index tmp_ix_fikr1 on tmp_fikr2(fikrkey);
            create index tmp_ix_fikr2 on tmp_fikr2(quartal);

            --Der einfachste Fall: Schlssel ist gleich BVKR:
            update tmp_fikr set bvkr_art=fikrkey where fikrkey in (select C.apnr from kenn_cifx C
            where C.key=669);
            --Nun wird der jeweils bergeordnete Schlssel versucht:
            --Ist ueberkey ein BVKR-Schlssel?
            update tmp_fikr set bvkr_art=ueberkey
            where bvkr_art is null
            and ueberkey in (select C.apnr from kenn_cifx C
            where C.key=669);
            --Wenn nein: nchsthhere Ebene
            --Dies in einer Schleife
            <#list 1..10 as i>
                update tmp_fikr set ueberkey=(select T.ueberkey
                from tmp_fikr2 T
                where T.quartal=tmp_fikr.quartal
                and T.fikrkey=tmp_fikr.ueberkey)
                where bvkr_art is null
                ;
                --Wenn ueberkey==null, dann wird bvkr_art='S' gesetzt
                update tmp_fikr set bvkr_art='S' where bvkr_art is null and ueberkey is null;

                update tmp_fikr set bvkr_art=ueberkey
                where bvkr_art is null
                and ueberkey in (select C.apnr from kenn_cifx C
                where C.key=669);
            </#list>

            --in tmp_fikr stehen jetzt interne Schlssel und externe
            create index tmp_ix_fikr3 on tmp_fikr(fikrkey);
            create index tmp_ix_fikr4 on tmp_fikr(quartal);
            --erste Prfung: enthlt die alt. Hier Knoten, die nicht zum BVKR zugeordnet werden knnen?
            insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
            select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || F.quartal || ' im Bereich Haushalt kann Kostenart ' || trim(fikrkey) || ' nicht dem BVKR zugeordnet werden)')::char(200), 'Warnung'::char(10)
            from tmp_fikr F
            where F.bvkr_art is null;

            --zweite Prfung: enthlt die alt. Hier berhaupt alle BVKR-Knoten?
            create temp table tmp_bvkr_quartal
            (quartal integer,fikrkey char(12));
            insert into tmp_bvkr_quartal
            select distinct Q.bezugszeit,C.apnr
            from kenn_cifx C, tmp_quartal2 Q
            where C.key=669
            and C.apnr not in ('S','ALLE');

            --derzeit noch nicht aktiv, weil MWK noch keine BVKR-Sichten im Bereich Haushalt erhebt:
            -- insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
            -- select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || C.quartal || ' im Bereich Haushalt fehlt Kostenart ' || trim(C.fikrkey) || ' in der alt. Hier. des BVKR)')::char(200), 'Warnung'::char(10)
            -- from tmp_bvkr_quartal C left outer join tmp_fikr F
            -- on (F.quartal=C.quartal
            -- and F.fikrkey=C.fikrkey)
            -- where F.fikrkey is null
            -- ;
            drop table tmp_bvkr_quartal;

            update tmp_konto_aggr set fikrkey=
            (select T.bvkr_art from  tmp_fikr T
            where T.quartal=tmp_konto_aggr.quartal
            and tmp_konto_aggr.fikrkey=T.fikrkey)
            where fikrkey is not null;

            --Ende Ermittlung BHKR-KoA
            drop TABLE tmp_fikr;
            drop TABLE tmp_fikr2;

            insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
            select distinct today(),'kenn_sichten'::char(18),'kenn_konto_aggr'::char(18),'Einnahmen / Ausgaben ohne BVKR-Kostenart: ' || count(*)::integer , 'Info'::char(10)
            from tmp_konto_aggr A
            where A.fikrkey is null;

        </#if>

        --Die Sicht weicht ggf. von der Tabelle gege ab:

        update tmp_konto_aggr set klr_geldgeber=
        (select C.gruppe from  fin_cifx C
        where C.key=636
        and tmp_konto_aggr.titelgruppe_gege=C.apnr)
        where titelgruppe_gege is not null;
        update tmp_konto_aggr set klr_geldgeber=substring(klr_geldgeber from 5 for 20)
        where klr_geldgeber like 'KLR_%';

        --36002-Umschlsselung DQ Deaktiviert 21.7.2016
        <#if K_KENN_PROFIL?exists&& K_KENN_PROFIL==5>
            --  update tmp_konto_aggr set titel='36001' where titel='36002' and (klr_geldgeber is null or klr_geldgeber not in ('11','12','19','21','22','28','29','31','32','33a','33b','33c','33d','34','34a','35','36','37','38','39','40'));
            --vergl oben Suche nach "Titel 36002 - Drittmittelreste"
        </#if>

        update tmp_konto_aggr set bund_fachgebiet=
        (select C.bund_fachgebiet from  kenn_inst C
        where tmp_konto_aggr.ch110_institut=C.key_apnr
        and date_val('01.'||tmp_konto_aggr.monat ||'.' || tmp_konto_aggr.jahr) between C.gueltig_seit and gueltig_bis)
        where ch110_institut is not null;

        --09.07.2012 Sachsen: Sofern Kostenstelle und Kostentrger zugeordnet sind, wird der externe Schlssel des Kostentrgers ausgewertet.
        <#if cob_installed==1 && K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>
            update tmp_konto_aggr set extkotr=(select P.k_extkotr from cob_proj P
            where P.projnr=tmp_konto_aggr.projnr)
            where extkotr is null
            ;
            -- ext. Kostenstelle ermitteln

            update tmp_konto_aggr set extkost=(select min(I.key_extkotr) from kenn_inst_to_ext I
            where I.instnr=tmp_konto_aggr.ch110_institut
            and I.key_extkotr is not null
            and trim(I.key_extkotr) !='')
            where extkost is null
            ;

            --wenn projnr leer ist, wird ext. Kostenstelle genommen
            update tmp_konto_aggr set extkotr=extkost where extkost is not null
            and extkotr is null;

            update tmp_konto_aggr set extkotr=(select min(E.key) from kenn_inst I, kenn_extkotr E
            where substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Produktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
            and E.kategorie='lf' --Ebene LFB
            and E.key like '1%' --nur Lehre
            and I.key_apnr=tmp_konto_aggr.ch110_institut)
            where extkotr is null;

            insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
            select distinct today(),'cob_proj/inst'::char(18),'kenn_konto_aggr'::char(18),'Projekt ' || string_not_null(trim(projnr)) || ' oder Kost.' || string_not_null(trim(ch110_institut)) ||' im Bereich Finanzen ist nicht externem Kostentrger zugeordnet !'::char(200), 'Warnung'::char(10)
            from tmp_konto_aggr
            where extkotr is null;



        </#if>

        insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
        select distinct today(),'fin_geldgeber'::char(18),'kenn_konto_aggr'::char(18),'Geldgeber ' || trim(titelgruppe_gege) || ' im Bereich Finanzen ist nicht dem Landesschlssel des Geldgebers (KLR) zugeordnet !'::char(200), 'Warnung'::char(10)
        from tmp_konto_aggr
        where klr_geldgeber is null
        and titelgruppe_gege is not null
        and trim(titelgruppe_gege) !='';


        insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
        select distinct today(),'fin_geldgeber'::char(18),'kenn_konto_aggr'::char(18),'Geldgeber ' || trim(titelgruppe_gege) || ' im Bereich Finanzen weicht im Feld klr_geldgeber von der Sicht Mittelherkunft KLR BaWue ab !'::char(240), 'Warnung'::char(10)
        from tmp_konto_aggr A, fin_cifx C
        where C.key=636
        and A.titelgruppe_gege=C.apnr
        and trim('KLR_' || A.klr_geldgeber) != trim(C.gruppe)
        and titelgruppe_gege is not null;



        --Wenn KAHIKA das Quellsystem ist, mssen bei Ausgaben die Vorzeichen umgedreht werden.
        update tmp_konto_aggr set ausgaben=ausgaben *-1
        where 2=(select apnr from konstanten where beschreibung='FIN_Quellsystem');

        update tmp_konto_aggr set hs_nr=(select hs_nr from hochschulinfo);


        --update tmp_konto_aggr set fikrkey='' where fikrkey is null;


        delete from kenn_konto_aggr where jahr in (select K.bezugszeit from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='HASL'
        and K.bezugsart='J'
        )
        ;

       delete from kenn_konto_aggr where quartal in (select K.bezugszeit from kenn_stichtag K
    where K.berechnen='1'
    and K.stichtagsart_id='HASL'
    and K.bezugsart='Q'
    )
    ;


        --vier inserts:
        --Ergebnis Landes-HH-Rechnung kommt aus manueller Schnittstelle
        --demnchst ber Schalter KENN_HHM_LHR_MAN=0 auch aus FIN
        insert into kenn_konto_aggr (
        hs_nr,
        jahr,
        betragsart,
        datum,
        betrag
        )
        select
        I.hs_nr,
        jahr,
        'L'::Char(1),
        today(),
        sum(wert)
        from kenn_zahl_wert H, hochschulinfo I
        where I.hs_nr=H.hs_nr
        and H.kenn_zahl='HHM_LHR'
        and H.jahr in (select K.bezugszeit from kenn_stichtag K
        where  K.berechnen='1'
        and K.stichtagsart_id='HASL')
        and 1=(select apnr from konstanten where beschreibung='KENN_HHM_LHR_MAN')
        group by 1,2,3,4;

        insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
        select today(),'fin_konto_aggr'::char(18),'kenn_konto_aggr'::char(18),'Konstante KENN_HHM_LHR_MAN=0 wird noch nicht untersttzt'::char(240), 'Warnung'::char(10)
        from xdummy where (select apnr from konstanten where beschreibung='KENN_HHM_LHR_MAN')=0;


        --HHAns
        insert into kenn_konto_aggr (
        hs_nr,
        jahr,
        quartal,
        monat,
        fikrkey,
        klr_geldgeber,
        extkotr,
        extkost,
        titel,
        dr,
        kapitel,
        betragsart,
        bund_fachgebiet,
        datum,
        betrag
        )
        select
        hs_nr,
        jahr,
        quartal,
        monat,
        fikrkey,
        klr_geldgeber,
        extkotr,
        extkost,
        titel,
        dr,
        kapitel,
        'H'::Char(1),
        bund_fachgebiet,
        datum,
        sum(hhans)
        from tmp_konto_aggr
        where
        (jahr in (select K.bezugszeit from kenn_stichtag K
        where  K.berechnen='1'
        and K.stichtagsart_id='HASL'
        and K.bezugsart='J')
        or quartal in (select K.bezugszeit from kenn_stichtag K
        where  K.berechnen='1'
        and K.stichtagsart_id='HASL'
        and K.bezugsart='Q')
        )
        group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14;



        --Ausgaben
        insert into kenn_konto_aggr (
        hs_nr,
        jahr,
        quartal,
        monat,
        fikrkey,
        klr_geldgeber,
        extkotr,
        extkost,
        titel,
        dr,
        kapitel,
        betragsart,
        bund_fachgebiet,
        datum,
        kfmkam,
        betrag
        )
        select
        hs_nr,
        jahr,
        quartal,
        monat,
        fikrkey,
        klr_geldgeber,
        extkotr,
        extkost,
        titel,
        dr,
        kapitel,
        'A'::Char(1),
        bund_fachgebiet,
        datum,
        kfmkam,
        sum(ausgaben)
        from tmp_konto_aggr
        where
        (jahr in (select K.bezugszeit from kenn_stichtag K
        where  K.berechnen='1'
        and K.stichtagsart_id='HASL'
        and K.bezugsart='J')
        or quartal in (select K.bezugszeit from kenn_stichtag K
        where  K.berechnen='1'
        and K.stichtagsart_id='HASL'
        and K.bezugsart='Q')
        )
        group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;



        --Einnahmen allgemein
        insert into kenn_konto_aggr (
        hs_nr,
        jahr,
        quartal,
        monat,
        fikrkey,
        klr_geldgeber,
        extkotr,
        extkost,
        titel,
        dr,
        kapitel,
        betragsart,
        bund_fachgebiet,
        datum,
        kfmkam,
        betrag
        )
        select
        hs_nr,
        jahr,
        quartal,
        monat,
        fikrkey,
        klr_geldgeber,
        extkotr,
        extkost,
        titel,
        dr,
        kapitel,
        'E'::Char(1),
        bund_fachgebiet,
        datum,
        kfmkam,
        sum(einnahmen)
        from tmp_konto_aggr
        where
        (jahr in (select K.bezugszeit from kenn_stichtag K
        where  K.berechnen='1'
        and K.stichtagsart_id='HASL'
        and K.bezugsart='J')
        or quartal in (select K.bezugszeit from kenn_stichtag K
        where  K.berechnen='1'
        and K.stichtagsart_id='HASL'
        and K.bezugsart='Q')
        )
        group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;
        --nur Sachsen:  Einnahmen aus Weiterbildungsangeboten
        <#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5) && KENN_EINN_WEITERB?exists >
            --Einnahmen aus Weiterbildung:
            insert into kenn_konto_aggr (
            hs_nr,
            jahr,
            quartal,
            monat,
            fikrkey,
            klr_geldgeber,
            extkotr,
            extkost,
            titel,
            dr,
            kapitel,
            betragsart,
            bund_fachgebiet,
            datum,
            kfmkam,
            betrag
            )
            select
            hs_nr,
            jahr,
            quartal,
            monat,
            fikrkey,
            klr_geldgeber,
            extkotr,
            extkost,
            titel,
            dr,
            kapitel,
            'B'::Char(1),
            bund_fachgebiet,
            datum,
            kfmkam,
            sum(einnahmen)
            from tmp_konto_aggr
            where
            (jahr in (select K.bezugszeit from kenn_stichtag K
            where  K.berechnen='1'
            and K.stichtagsart_id='HASL'
            and K.bezugsart='J')
            or quartal in (select K.bezugszeit from kenn_stichtag K
            where  K.berechnen='1'
            and K.stichtagsart_id='HASL'
            and K.bezugsart='Q')
            )
            and ${KENN_EINN_WEITERB}
            group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;
        </#if>



        drop table tmp_konto_aggr;

    </#if>
    <#if KENN_FINANZEN_DATENQUELLE==170>
        delete from kenn_konto_aggr where jahr in (select K.bezugszeit from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='HASL'
        and K.bezugsart='J'
        )
        ;

        delete from kenn_konto_aggr where quartal::char(5) in (select K.bezugszeit::char(5) from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='HASL'
        and K.bezugsart='Q'
        )
        ;
        insert into kenn_konto_aggr
        ( hs_nr,
        jahr,
        quartal,
        monat,
        --kapitel, -- kapitel wird nicht bernommen, enthlt in gxstage evtl. testweise den fonds
        dr,
     --   titel, -- wird nicht bernommen
        fikrkey,
        klr_geldgeber,
        betragsart,
        bund_fachgebiet,
        datum,
        betrag,
        extkost,
        extkotr,
        kfmkam)

        SELECT hs_nr,
        gjahr,
        G.quartal,
        G.monat,
     --   kapitel,
        dr,
       -- titel,
        fikrkey,
        klr_geldgeber,
        betragsart,
        bund_fachgebiet,
        datum,
        betrag,
        extkost,
        extkotr,
        kfmkam
        FROM gxstage_kenn_finanzen G, tmp_quartal2 Q
        where Q.jahr=G.gjahr
        and G.monat between Q.monat_von and Q.monat_bis;
    </#if>
    drop table tmp_quartal;
    drop table tmp_quartal2;
</#if>
--delete from kenn_konto_aggr where betrag=0;
