--Freemarker Template
--ram excelexport
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="Kennzahl" type="sicht" name_intern="kenn_report_katalog" ></sqlvar>
<sqlvar name="kenn_katalog" type="hashsequence"><![CDATA[

select trim(K.id) as id,trim(R.gruppe_1) as gruppe_1,
trim(R.gruppe_2) as gruppe_2,
trim(K.name) as name,
trim(K.quelltabelle) as quelltabelle,
trim(K.quellfeld) as quellfeld,
K.bedingung as bedingung,
trim(K.stichtagsart) as stichtagsart,
trim(K.bezugsart) as  bezugsart,
trim(K.zeitfeld) as zeitfeld,
R.ebene,
R.ord_nr,
K.einheit,
K.beschreibung,
K.bezugszeit_diff,
R.report_id,
R.parent_katalog_id,
(select count(*)::integer from kenn_katalog_sub S where S.report_id=R.report_id
and S.katalog_id=R.katalog_id) as differenzierung
FROM kenn_katalog K, kenn_katalog_rpt R
where K.id=R.katalog_id
and R.report_id='MWKBW2017'
order by 12;
]]>
</sqlvar>
<sqlvar name="kenn_katalog_sub" type="hashsequence"><![CDATA[
--freemarker template
select S.report_id,
S.katalog_id,
S.sub_caption,
S.sub_key_col,
S.sub_lookup_table,
S.sub_lookup_key,
S.sub_lookup_name,
S.sub_lookup_whereclause,
S.sub_lookup_snowflake,
S.ord_nr
FROM kenn_katalog_sub S
where S.report_id='MWKBW2017'
order by S.ord_nr;
]]>
</sqlvar>

</sqlvars>



<#assign type_double="double precision" />
<#if '${SQLdialect}'='Informix' >
<#assign type_double="float" />
</#if>
<#assign jahrfilter_start="1900" />
<#assign jahrfilter_ende="3000" />
<#assign report_id="MWKBW2017" />

<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL=1 || K_KENN_PROFIL=2 ||K_KENN_PROFIL=3  ||K_KENN_PROFIL=4)>
            --nur BaWue

create temp table tmp_kennz_aggr
(
hs_nr integer,
kennzahl_str varchar(255),
report_id CHAR(40),
katalog_id CHAR(100),
parent_katalog_id CHAR(100),
gruppe_1 char(40),
gruppe_2 char(40),
hochschule_str nchar(255),
hochschulart char(10),
hochschulart_str varchar(255),
stichtagsart nchar(255),
zeitraum_int integer,
bezugszeit integer,
zeitraum_str char(255), 
bezugsart char(1),
ebene smallint,
ord_nr smallint,
ord_nr_2 smallint,
is_sub smallint,
sub_1_caption  varchar(255),
sub_1_key  varchar(255),
sub_1_name  varchar(255),
sub_2_caption  varchar(255),
sub_2_key  varchar(255),
sub_2_name  varchar(255),
betrag ${type_double},
einheit char(255), 
jahr integer,
semester integer,
wert_str varchar(255)
 ) <@informixnolog/>;

create temp table tmp_kennz
(
tid integer,
hs_nr integer,
fgr char(10),
fgr_str varchar(255),
kennzahl_str varchar(255),
report_id char(40),
katalog_id CHAR(100),
parent_katalog_id char(100),
hochschule_str nchar(255),
stichtagsart nchar(255),
zeitraum_int integer,
zeitraum_str char(255), 
bezugsart char(1),
bezugszeit integer,
ebene smallint,
ord_nr smallint,
ord_nr_2 smallint,
is_sub smallint,
sub_1_caption  varchar(255),
sub_1_key  varchar(255),
sub_2_caption  varchar(255),
sub_2_key varchar(255),
betrag ${type_double},
einheit char(255), 
nexttable varchar(250),
nexttable2 varchar(250),
jahr integer,
semester integer,
wert_str varchar(255)
 ) <@informixnolog/>;
 
 
  
 create temp table tmp_betrag
(hs_nr integer,
is_sub smallint,
sub_1_caption  varchar(255),
sub_1_key  varchar(255),
sub_2_caption  varchar(255),
sub_2_key varchar(255),
 bezugszeit integer,
  betrag1 ${type_double},
  betrag2 ${type_double}
  ) <@informixnolog/>;
  
-- ##################################################
-- ######## Start der Schleife ######################
-- ##################################################
<#assign sortnr=0>
--Schleife, ber Fcher im ausgewhlten Baum, Reihenfolge genau wie im Baum
--diese Kommentare werden schon im 1. Schritt von generateSql gelscht
--fr Entwicklungszwecke kann man tricksen
<@addcomment "SCHLEIFE"/>

<#foreach kennz in .vars["Kennzahl"].depthFirstElements>
<@addcomment "${kennz.name}"/>
<#foreach katalog in kenn_katalog>
<#if kennz.key == katalog.id>
<#assign sortnr=sortnr +1 />

<#if katalog.quelltabelle !=''>
<#assign zeit_bedingung=" and 1=1 " />
<#if katalog.bezugsart = "K">
<#assign zeit_bedingung = zeit_bedingung+" and 1=1 " />
<#elseif  katalog.bezugsart = "A" || katalog.bezugsart = "P" || katalog.bezugsart = "B"|| katalog.bezugsart = "V">
  --akad. Jahr automatisch ermitteln
<#assign zeit_bedingung = zeit_bedingung + " and (get_akad_jahr("+katalog.zeitfeld+",'"+katalog.bezugsart+"') - ("+katalog.bezugszeit_diff+")) between "+ jahrfilter_start+" and "+jahrfilter_ende />
 <#else>
<#assign zeit_bedingung = zeit_bedingung+" and ("+katalog.zeitfeld+"- ("+katalog.bezugszeit_diff+")) between "+ jahrfilter_start+" and "+jahrfilter_ende />
  </#if>


--zuerst Berechnung:
--ohne Differenzierung:
insert into tmp_kennz(
hs_nr ,
report_id,
katalog_id,
parent_katalog_id,
 stichtagsart ,
  kennzahl_str ,
 zeitraum_int,
 bezugsart,
  bezugszeit,
 ebene,
 ord_nr,
 is_sub ,
<#if katalog.einheit="Text">
 wert_str,
<#else>
betrag,
</#if>
 einheit)
  
select hs_nr,
'${katalog.report_id}',
'${kennz.key}'::char(100),
'${katalog.parent_katalog_id}'::char(100),
 '${katalog.stichtagsart}'::nchar(255),
  '${kennz.name}'::char(255) ,
  ${katalog.zeitfeld},
 '${katalog.bezugsart}'::char(1),
  <#if katalog.bezugsart = "A" || katalog.bezugsart = "P" || katalog.bezugsart = "B"|| katalog.bezugsart = "V">
  --akad. Jahr automatisch ermitteln
  get_akad_jahr(${katalog.zeitfeld},'${katalog.bezugsart}')-(${katalog.bezugszeit_diff}),
  <#else>
  ${katalog.zeitfeld}-(${katalog.bezugszeit_diff}),
  </#if>
 
 ${katalog.ebene}::smallint,
 ${sortnr}::smallint,
 0 as is_sub,
 ${katalog.quellfeld},
 '${katalog.einheit}'::varchar(255)
 from xdummy left outer join ${katalog.quelltabelle} 
on (  1=1
  ${katalog.bedingung}
  ${zeit_bedingung}

)

 <#if katalog.einheit!="Text">
 group by 1,2,3,4,5,6,7,8,9,10
 </#if>
 ;
--mit Differenzierung:
<#if katalog.differenzierung !=0 >
insert into tmp_kennz(
hs_nr ,
report_id,
katalog_id,
parent_katalog_id,
 stichtagsart ,
  kennzahl_str ,
 zeitraum_int,
 bezugsart,
  bezugszeit,
 ebene,
 ord_nr,
 is_sub ,
sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key,
<#if katalog.einheit="Text">
 wert_str,
<#else>
betrag,
</#if>
 einheit)
  
select hs_nr,
'${katalog.report_id}',
'${kennz.key}'::char(100),
'${katalog.parent_katalog_id}'::char(100),
 '${katalog.stichtagsart}'::nchar(255),
  '${kennz.name}'::char(255) ,
  ${katalog.zeitfeld},
 '${katalog.bezugsart}'::char(1),
  <#if katalog.bezugsart = "A" || katalog.bezugsart = "P" || katalog.bezugsart = "B"|| katalog.bezugsart = "V">
  --akad. Jahr automatisch ermitteln
  get_akad_jahr(${katalog.zeitfeld},'${katalog.bezugsart}')-(${katalog.bezugszeit_diff}),
 <#else>
  ${katalog.zeitfeld}-(${katalog.bezugszeit_diff}),
  </#if>
 
 ${katalog.ebene}::smallint,
 ${sortnr}::smallint,
 1 as is_sub,
<@getSubSelectFields katalog_id=kennz.key quelltabelle=katalog.quelltabelle /> 
 ${katalog.quellfeld},
 '${katalog.einheit}'::varchar(255)
 from xdummy left outer join ${katalog.quelltabelle} 
on (  1=1
  ${katalog.bedingung}
  ${zeit_bedingung}

)

 <#if katalog.einheit!="Text">
 group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16
 </#if>
  ;
</#if> --wenn mit Differenzierung

<#else>
--Kennzahl nicht aus Quelltabelle, sondern berechnet aus Kindern:
<#assign rsnum=1 />
<#assign formel=katalog.quellfeld />
<#assign aggrfunction="" />

<#if formel?index_of("/") != -1>
	<#assign operator="/" />
	<#assign direction="col" />
<#elseif formel?index_of("*") != -1>
	<#assign operator="*" />
	<#assign direction="col" />
<#elseif formel?index_of("-") != -1>
	<#assign operator="-" />
	<#assign direction="col" />
<#elseif formel?index_of(",") != -1>
<#if formel?index_of("(") !=-1>
	<#assign start=formel?index_of("(")/>
	<#assign start_vor=start-1/>
	<#assign start_nach=start+1/>
	<#assign laenge=formel?length - start/>
	<#assign laenge_nach=laenge+1/>
	<#assign aggrfunction=formel[0..start_vor] />
	<#assign formel=formel[start_nach..laenge_nach] />
</#if>
	<#assign operator="," />
	<#assign direction="row" />
<#elseif formel?index_of("+") != -1>
	<#assign operator="+" />
	<#assign aggrfunction="sum" />
	<#assign direction="row" />
</#if>

<#if formel !="">
<#list formel?split(operator) as rs>
<#if direction=="col">
<#if rsnum == 1>
--ohne Differenzierung:
insert into tmp_betrag(
hs_nr ,
bezugszeit,
is_sub,
betrag1
 )
 select hs_nr,
 bezugszeit,
 is_sub,
sum(betrag)
 from tmp_kennz  
 where  katalog_id='${rs}'
 and is_sub=0
  group by 1,2,3
  having sum(betrag) is not null
  ;
  
<#if katalog.differenzierung !=0 >
--mit Differenzierung:
insert into tmp_betrag(
hs_nr ,
bezugszeit,
is_sub,
sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key,
betrag1
 )
 select hs_nr,
 bezugszeit,
 is_sub,
sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key,
sum(betrag)
 from tmp_kennz  
 where  katalog_id='${rs}'
  and is_sub=1
  group by 1,2,3,4,5,6,7
   having sum(betrag) is not null
  ;
  
</#if> --wenn mit Differenzierung
 
<#else> --wenn rsnum ungleich 1
--ohne Differenzierung:
--falls der Zhler leer ist, wird er bei Division zu 0:
insert into tmp_betrag(
hs_nr ,
  bezugszeit,
  betrag1
 )
 select distinct hs_nr,
 bezugszeit,
 0
 from tmp_kennz  
 where  katalog_id='${rs}'
 and is_sub=0
 and 0=(select count(*) from tmp_betrag T where T.hs_nr=tmp_kennz.hs_nr
 and T.bezugszeit=tmp_kennz.bezugszeit
 and T.is_sub=0);
--nun Division vorbereiten:
update tmp_betrag set betrag2=(select 
sum(betrag)
 from tmp_kennz  T
 where  katalog_id='${rs}'
 and T.hs_nr=tmp_betrag.hs_nr
 and T.bezugszeit=tmp_betrag.bezugszeit
 and T.is_sub=tmp_betrag.is_sub
 )
where is_sub=0
 ;
<#if katalog.differenzierung !=0 >
 --mit Differenzierung:
 --falls der Zhler leer ist, wird er bei Division zu 0:
insert into tmp_betrag(
hs_nr ,
  bezugszeit,
is_sub,
sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key,
betrag1
 )
 select distinct hs_nr,
 bezugszeit,
is_sub,
sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key,
 0
 from tmp_kennz  
 where  katalog_id='${rs}'
 and is_sub=1
 and 0=(select count(*) from tmp_betrag T where T.hs_nr=tmp_kennz.hs_nr
 and T.bezugszeit=tmp_kennz.bezugszeit
 and T.is_sub=1
 and T.is_sub=tmp_kennz.is_sub
 and T.sub_1_key=tmp_kennz.sub_1_key
 and T.sub_2_key=tmp_kennz.sub_2_key);
 
 update tmp_betrag set betrag2=(select 
sum(betrag)
 from tmp_kennz  T
 where  katalog_id='${rs}'
 and T.hs_nr=tmp_betrag.hs_nr
 and T.bezugszeit=tmp_betrag.bezugszeit
 and T.is_sub=tmp_betrag.is_sub
 and T.sub_1_key=tmp_betrag.sub_1_key
 and T.sub_2_key=tmp_betrag.sub_2_key
 
 )
where is_sub=1
 ;
 </#if>--wenn mit Differenzierung
 </#if>  --wenn rsnum ungleich 1
<#else> 
--direction row:
--ohne Differenzierung:
insert into tmp_betrag(
hs_nr ,
  bezugszeit,
  is_sub,
 betrag1
 )
 select hs_nr,
 bezugszeit,
 is_sub,
sum(betrag)
 from tmp_kennz  
 where  katalog_id ='${rs}'
 and is_sub=0
  group by 1,2,3;

<#if katalog.differenzierung !=0 >
--mit Differenzierung:
insert into tmp_betrag(
hs_nr ,
  bezugszeit,
  is_sub,
sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key,
 betrag1
 )
 select hs_nr,
 bezugszeit,
 is_sub,
sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key,
sum(betrag)
 from tmp_kennz  
 where  katalog_id ='${rs}'
 and is_sub=1
  group by 1,2,3,4,5,6,7;
  

</#if> --wenn mit Differenzierung
</#if> --wenn direction row
<#assign rsnum= rsnum+1 />
</#list>

--division durch 0 verhindern:
<#if operator=="/">
update tmp_betrag set betrag2=null where betrag2=0;
</#if>

insert into tmp_kennz(
hs_nr ,
report_id,
 katalog_id,
parent_katalog_id,
 stichtagsart ,
  kennzahl_str ,
 bezugszeit,
 bezugsart,
 ebene,
 ord_nr,
 betrag,
 einheit,
 is_sub,
sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key
)
select
hs_nr ,
'${katalog.report_id}',
'${katalog.id}'::char(100),
'${katalog.parent_katalog_id}'::char(100),
'${katalog.stichtagsart}'::nchar(255),
 '${katalog.name}'::char(255) ,
 bezugszeit,
 '${katalog.bezugsart}',
 ${katalog.ebene}::smallint,
 ${sortnr}::smallint,
 <#if direction=="row">
 ${aggrfunction}(betrag1),
 <#else>
 betrag1 ${operator} betrag2,
 </#if>
 '${katalog.einheit}' ,
is_sub,
sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key
 from tmp_betrag
 <#if direction=="row">
 group by hs_nr,
 bezugszeit,
 is_sub,
 sub_1_caption,
sub_1_key,
sub_2_caption,
sub_2_key

 </#if>
  ;

delete from tmp_betrag;
--Ende Berechnung aus Kindern
</#if> --wenn formel nicht leer
</#if>
</#if>
</#foreach>
</#foreach>
-- ##################################################
-- ######### Ende der Schleife zur Berechnung ######################
-- ##################################################

insert into tmp_kennz_aggr(ebene,
kennzahl_str,
ord_nr,
hs_nr ,
report_id,
 katalog_id,
 parent_katalog_id,
 stichtagsart ,
 zeitraum_int,
 bezugsart,
 bezugszeit,
 is_sub,
sub_1_caption ,
sub_1_key,
sub_2_caption ,
sub_2_key,
 betrag,
 einheit)
select T.ebene,
T.kennzahl_str,
T.ord_nr,
T.hs_nr ,
T.report_id,
T.katalog_id,
T.parent_katalog_id,
T.stichtagsart ,
T.zeitraum_int,
T.bezugsart,
T.bezugszeit,
T.is_sub,
sub_1_caption  , 
sub_1_key , 
sub_2_caption  , 
sub_2_key , 
T.betrag,
T.einheit
from tmp_kennz T
where T.hs_nr is not null
and betrag is not null
;

--denormalisiere Gruppen:
<#if kenn_katalog_sub?size &gt; 0> 
<#assign ord_nr=1 />
<#assign last_katalog_id="" />
<#foreach gruppe in kenn_katalog_sub>
<#if gruppe.katalog_id==last_katalog_id>
<#assign last_katalog_id=gruppe.katalog_id />
<#assign ord_nr=ord_nr+1 />
<#else>
<#assign ord_nr=1 />
</#if>
<#if gruppe.sub_lookup_table !="">
update tmp_kennz_aggr set sub_${ord_nr}_name=(select T1.${gruppe.sub_lookup_name} 
from ${gruppe.sub_lookup_table} T1
where T1.${gruppe.sub_lookup_key}=tmp_kennz_aggr.sub_${ord_nr}_key
<#if gruppe.sub_lookup_whereclause!="">
--mit zustzlicher whereclause:
and ${gruppe.sub_lookup_whereclause}
</#if>
)
where katalog_id='${gruppe.katalog_id}'
and is_sub=1
;


update tmp_kennz_aggr set sub_${ord_nr}_name=sub_${ord_nr}_key
where sub_${ord_nr}_name is null
and katalog_id='${gruppe.katalog_id}'
and is_sub=1
;

<#else>
update tmp_kennz_aggr set sub_${ord_nr}_name=sub_${ord_nr}_key
where katalog_id='${gruppe.katalog_id}'
and is_sub=1
;
</#if>
update tmp_kennz_aggr set sub_${ord_nr}_name='Unbekannt' 
where sub_${ord_nr}_key='_U'
and katalog_id='${gruppe.katalog_id}'
and is_sub=1
;
 </#foreach>
 </#if>


 
update tmp_kennz_aggr set hochschule_str=(select name from hochschulinfo where hs_nr =tmp_kennz_aggr.hs_nr);
update tmp_kennz_aggr set zeitraum_str=(select druck from kenn_semester where tid=tmp_kennz_aggr.zeitraum_int)
where bezugsart in ('S','4','A');
update tmp_kennz_aggr set zeitraum_str=zeitraum_int
where bezugsart in ('J');
update tmp_kennz_aggr set zeitraum_str=(select druck from kenn_quartale where apnr=tmp_kennz_aggr.zeitraum_int)
where bezugsart='Q';
update tmp_kennz_aggr set zeitraum_str=zeitraum_int where zeitraum_str is null;

update tmp_kennz_aggr set sub_1_name=sub_1_key 
where sub_1_caption is not null 
and (sub_1_name is null or sub_1_name='')
and is_sub=1;
update tmp_kennz_aggr set sub_2_name=sub_2_key 
where sub_2_caption is not null 
and (sub_2_name is null or sub_2_name='')
and is_sub=1;


drop table tmp_kennz;
drop table tmp_betrag;

truncate table kenn_kennz_aggr;


insert into kenn_kennz_aggr(
ebene,
report_id,
katalog_id,
parent_katalog_id,
ord_nr,
--kennzahl_str,
hs_nr,
--hochschule_str, 
zeitraum_int,
--zeitraum_str,
bezugszeit,
is_sub,
sub_1_caption ,
sub_1_key,
sub_1_name,
sub_2_caption ,
sub_2_key,
sub_2_name,
betrag,
einheit
)
select ebene,
report_id,
katalog_id,
parent_katalog_id,
ord_nr,
--kennzahl_str,
hs_nr,
--hochschule_str, 
zeitraum_int,
--zeitraum_str,
bezugszeit,
is_sub,
sub_1_caption ,
sub_1_key,
sub_1_name,
sub_2_caption ,
sub_2_key,
sub_2_name,
betrag,
einheit
from tmp_kennz_aggr
;

update kenn_kennz_aggr set katalog_id_beschreibung=(select K.beschreibung
from kenn_katalog K
where K.id=kenn_kennz_aggr.katalog_id);

<#if 1==0 >
--klappt noch nicht: Harmonisierung der Gruppen:
--welche Gruppen gibt es?
select distinct ebene,
report_id,
katalog_id,
parent_katalog_id,
ord_nr,
hs_nr,
beschreibung,
zeitraum_int,
bezugszeit,
is_sub,
sub_1_caption ,
sub_1_key,
sub_1_name,
sub_2_caption ,
sub_2_key,
sub_2_name,
einheit
into temp tmp_differenzierungen
FROM tmp_kennz_aggr T
where T.is_sub=1
and T.hs_nr is not null
and T.bezugszeit is not null;

insert into kenn_kennz_aggr(
ebene,
report_id,
katalog_id,
parent_katalog_id,
ord_nr,
hs_nr,
katalog_id_beschreibung,
zeitraum_int,
bezugszeit,
is_sub,
sub_1_caption ,
sub_1_key,
sub_1_name,
sub_2_caption ,
sub_2_key,
sub_2_name,
betrag,
einheit
)
select distinct D.ebene-1,
D.report_id,
D.parent_katalog_id,
null::char(10) as parent_katalog_id,
D.ord_nr,
D.hs_nr,
D.beschreibung,
D.zeitraum_int,
D.bezugszeit,
D.is_sub,
D.sub_1_caption ,
D.sub_1_key,
D.sub_1_name,
D.sub_2_caption ,
D.sub_2_key,
D.sub_2_name,
0,
D.einheit
from tmp_differenzierungen D left outer join tmp_kennz_aggr T  
on (
D.report_id=T.report_id
and D.parent_katalog_id=T.katalog_id
and D.hs_nr=T.hs_nr
and D.bezugszeit=T.bezugszeit
and D.is_sub=T.is_sub
and D.sub_1_caption=T.sub_1_caption
and D.sub_2_caption=T.sub_2_caption
and D.sub_1_key=T.sub_1_key
and D.sub_2_key=T.sub_2_key
)
where T.hs_nr is null
and 1=0
;

drop table tmp_differenzierungen;
</#if>

drop table tmp_kennz_aggr;
</#if>

<#macro getSubSelectFields katalog_id quelltabelle>
<#assign sub_1_caption="" />
<#assign sub_1_key="''" />
<#assign sub_2_caption="" />
<#assign sub_2_key="''" />

<#if kenn_katalog_sub?size &gt; 0> 
 <#assign ord_nr=0 />
 <#foreach gruppe in kenn_katalog_sub>
 <#if gruppe.katalog_id==katalog_id>
 <#assign ord_nr=ord_nr+1 />
 <#if ord_nr==1>
 <#assign sub_1_caption=gruppe.sub_caption />
 <#if gruppe.sub_lookup_snowflake == "">
 	<#assign sub_1_key="nvl("+gruppe.sub_key_col+",'_U'::varchar(255))" />
 <#else>
 	<#assign sub_1_key="nvl(("+gruppe.sub_lookup_snowflake+" ="+quelltabelle+"."+gruppe.sub_key_col+" ),'_U'::varchar(255))" />
 </#if>
 
 </#if>
 <#if ord_nr==2>
 <#assign sub_2_caption=gruppe.sub_caption />
 <#assign sub_2_key=gruppe.sub_key_col />
 </#if>
 
 </#if>
 </#foreach>
 </#if>
 
 '${sub_1_caption}',
 ${sub_1_key},
 '${sub_2_caption}',
 ${sub_2_key},
 
</#macro>
