
--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
    <sqlvar name="fin_installed">
        select count(*) from db_version where his_system ='fin';
    </sqlvar>
      <sqlvar name="tmp_konto_aggr_exists">
        select sp_table_exists('tmp_konto_aggr') from xdummy;
    </sqlvar>
      <sqlvar name="KENN_FINANZEN_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_FINANZEN_DATENQUELLE'
    </sqlvar>
    <sqlvar name="bezugsquartale_kenn_stichtag" type='hashsequence'>
create temp table tmp_quartale(jahr smallint,
quartal smallint);
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '1') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='KAM_QB' 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '2') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='KAM_QB' 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '3') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='KAM_QB' 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '4') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='KAM_QB' 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct val(substring(''|| K.bezugszeit from 1 for 4)),K.bezugszeit 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='KAM_QB' 
and K.bezugsart='Q'
;
select distinct jahr, quartal
from tmp_quartale;
drop table tmp_quartale;

</sqlvar>
 
</sqlvars>

<#macro doubletype>
    <#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>

<#if tmp_konto_aggr_exists==1 && fin_installed=1 && K_KENN_PROFIL?exists && (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)
&&  bezugsquartale_kenn_stichtag?exists && bezugsquartale_kenn_stichtag?has_content >

--nicht fr BaWue berechnen:

    delete from kenn_kam_quartal where 0=
    (select apnr from konstanten where beschreibung ='KENN_FINANZEN_ARCHIV');

    create temp table tmp_quartal
    (
    tid integer,
    bezugszeit integer,
    jahr smallint,
    quartal integer
    );

create temp table tmp_zeilen(
hs_nr integer,
zeile integer,
dr varchar(50),
titel varchar(50),
gueltig_von date,
gueltig_bis date
)
;
insert into tmp_zeilen(
hs_nr,
zeile,
dr,
titel,
gueltig_von,
gueltig_bis
)
select  H.hs_nr ,
split_part (K.id,'_',2)::integer as zeile, 
R.gruppe_1 as tg, 
R.gruppe_2 as titel,
K.gueltig_von,
K.gueltig_bis
from kenn_katalog K,kenn_katalog_rpt R ,hochschulinfo H
where K.id =R.katalog_id
and R.report_id='KAM_Q'
and R.gruppe_2 is not null
;

    --zuerst alle zu berechnenden Quartale zusammenstellen:
<#list 1..4 as quartal>
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(''|| bezugszeit || '${quartal}'),
    bezugszeit,
    ${quartal}
    from kenn_stichtag
    where stichtagsart_id='KAM_QB'
    and berechnen='1'
    and bezugsart='J';
    --vorjahr:
   insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(''|| bezugszeit || '${quartal}'),
    bezugszeit-1,
    ${quartal}
    from kenn_stichtag
    where stichtagsart_id='KAM_QB'
    and berechnen='1'
    and bezugsart='J';
</#list>

insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    bezugszeit,
    val(substring('' || bezugszeit from 1 for 4)), 
    val(substring('' || bezugszeit from 5 for 1))
    from kenn_stichtag
    where stichtagsart_id='KAM_QB'
    and berechnen='1'
    and bezugsart='Q';


create temp table tmp_quartal2
    (

    bezugszeit integer,
    jahr smallint,
    quartal integer,
    monat_von smallint,
    monat_bis smallint

    );

    insert into tmp_quartal2
    (bezugszeit,
    jahr,
    quartal)
    select distinct bezugszeit,
    jahr,
    quartal
    from tmp_quartal;


CREATE TEMP TABLE tmp_kenn_kam_quartal (
    hs_nr integer,
    jahr integer,
    quartal smallint,
    dr character varying(50),
    titel character varying(50),
    soll double precision DEFAULT 0,
    reste double precision DEFAULT 0,
    haushaltsvorgriff double precision DEFAULT 0,
    istq1 double precision DEFAULT 0,
    istvorjahr_q1 double precision DEFAULT 0,
    istq2 double precision DEFAULT 0,
    istvorjahr_q2 double precision DEFAULT 0,
    istq3 double precision DEFAULT 0,
    istvorjahr_q3 double precision DEFAULT 0,
    istq4 double precision DEFAULT 0,
    istvorjahr_q4 double precision DEFAULT 0,
--    erlaeuterung text
datum date
);
<#if bezugsquartale_kenn_stichtag?exists && bezugsquartale_kenn_stichtag?has_content >
<#foreach bezugsquartal in bezugsquartale_kenn_stichtag>

select 'Lauf fuer Quartal ${bezugsquartal.quartal} beginnt: ' || now() from xdummy;

insert into tmp_kenn_kam_quartal(
hs_nr,
       jahr,
       quartal,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       <#list 1..4 as quartal>
       istq${quartal},
       istvorjahr_q${quartal},
       </#list>
       datum
   )
           select
            Z.hs_nr,
            ${bezugsquartal.jahr},
	    ${bezugsquartal.quartal},
            Z.dr,
            Z.titel,
            (case when jahr=${bezugsquartal.jahr} then sum(akts_tit) else 0 end) as soll,
	    (case when jahr=${bezugsquartal.jahr} then sum(reste_tit) else 0 end) as reste,
	    (case when jahr=${bezugsquartal.jahr} then sum(haushaltsvorgriff) else 0 end) as haushaltsvorgriff,
       <#list 1..4 as quartal>
	    (case when jahr=${bezugsquartal.jahr} and quartal=${quartal} and substring(Z.titel from 1 for 1) in ('4','5','6','7','8','9') then sum(ausgaben_tit)
	    when jahr=${bezugsquartal.jahr} and quartal=${quartal} and substring(Z.titel from 1 for 1) in ('0','1','2','3') then sum(einnahmen_tit)
	    else 0 end) as istq${quartal},
	    (case when jahr=${bezugsquartal.jahr}-1 and quartal=${quartal} and substring(Z.titel from 1 for 1) in ('4','5','6','7','8','9') then sum(ausgaben_tit)
	    when jahr=${bezugsquartal.jahr}-1 and quartal=${quartal} and substring(Z.titel from 1 for 1) in ('0','1','2','3') then sum(einnahmen_tit)
	    else 0 end) as istvorjahr_q${quartal},
        </#list>
today()
            from tmp_zeilen Z left outer join tmp_konto_aggr T on (
	    Z.titel=T.titel
	    and T.bezugsjahr=${bezugsquartal.jahr}
	    
		and (T.jahr::char(10)||T.quartal::char(10))::integer between get_quartal(Z.gueltig_von) and get_quartal(Z.gueltig_bis)
)
	    group by 1,2,3,4,5,quartal,jahr
	    ;
</#foreach>
</#if>

--drop table tmp_konto_aggr; --wird noch bei trans_kenn_kam_ja.sql bentigt
drop table tmp_zeilen;

delete from kenn_kam_quartal where jahr in (select K.bezugszeit from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='KAM_QB'
        and K.bezugsart='J'
        )
        ;
-- 
    delete from kenn_kam_quartal where quartal in (select K.bezugszeit from kenn_stichtag K
     where K.berechnen='1'
     and K.stichtagsart_id='KAM_QB'
     and K.bezugsart='Q'
     )
     ;

insert into kenn_kam_quartal(
hs_nr,
       jahr,
       quartal,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       <#list 1..4 as quartal>
       istq${quartal},
       istvorjahr_q${quartal},
       </#list>
       datum
   )
select
hs_nr,
       jahr,
       quartal,
       dr,
       titel,
       sum(soll),
       sum(reste),
       sum(haushaltsvorgriff),
       <#list 1..4 as quartal>
       sum(istq${quartal}),
       sum(istvorjahr_q${quartal}),
       </#list>
       datum
       from tmp_kenn_kam_quartal
       group by 1,2,3,4,5,datum;
       
   
    drop table  tmp_kenn_kam_quartal;
    drop table tmp_quartal;
    drop table tmp_quartal2;
    

 
--testfall ausgaben_tit Titel 52701 in 2020 Monat 12 =469,4 EUR:
select 'Quartal 20204 sollte 469,4 ergeben:',
sum(istq4) as ausgaben_tit 
from kenn_kam_quartal
where jahr=2020
and quartal=20204
and titel='52701'
;
--testfall ausgaben_tit Titel 52701 in 2021 Monat 10 =2000 EUR:
select 'Quartal 20214 sollte 2000 ergeben:',
sum(istq4) as ausgaben_tit 
from kenn_kam_quartal
where jahr=2021
and quartal=20214
and titel='52701'
;
--und vorjahr 469,4 EUR
select 'Quartal 20214 sollte 469,4 ergeben:',
sum(istvorjahr_q4) as ausgaben_tit 
from kenn_kam_quartal
where jahr=2021
and quartal=20214
and titel='52701'
;
</#if>
--delete from kenn_kam_quartal where betrag=0;
