
--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
    <sqlvar name="fin_installed">
        select count(*) from db_version where his_system ='fin';
    </sqlvar>
      <sqlvar name="tmp_konto_aggr_exists">
        select sp_table_exists('tmp_konto_aggr') from xdummy;
    </sqlvar>
      <sqlvar name="KENN_FINANZEN_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_FINANZEN_DATENQUELLE'
    </sqlvar>
    <sqlvar name="bezugsjahre_kenn_stichtag" type='hashsequence'>
select distinct K.bezugszeit as jahr
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id  = 'KAM_JA' 
and K.bezugsart='J'
;

</sqlvar>
 
</sqlvars>

<#macro doubletype>
    <#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>

<#if  tmp_konto_aggr_exists==1 && fin_installed=1 && K_KENN_PROFIL?exists && (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)
&&  bezugsjahre_kenn_stichtag?exists && bezugsjahre_kenn_stichtag?has_content >


CREATE TEMP TABLE tmp_kenn_kam_ja (
    hs_nr integer,
    jahr integer,
    dr character varying(50),
    titel character varying(50),
    soll double precision DEFAULT 0,
    reste double precision DEFAULT 0,
    haushaltsvorgriff double precision DEFAULT 0,
    ist double precision DEFAULT 0,
datum date
);

create temp table tmp_zeilen(
hs_nr integer,
zeile integer,
dr varchar(50),
titel varchar(50),
gueltig_von date,
gueltig_bis date
)
;
insert into tmp_zeilen(
hs_nr,
zeile,
dr,
titel,
gueltig_von,
gueltig_bis
)
select  H.hs_nr ,
split_part (K.id,'_',2)::integer as zeile, 
R.gruppe_1 as tg, 
R.gruppe_2 as titel,
K.gueltig_von,
K.gueltig_bis
from kenn_katalog K,kenn_katalog_rpt R ,hochschulinfo H
where K.id =R.katalog_id
and R.report_id='KAM_J'
and R.gruppe_2 is not null
;

<#foreach bezugsjahr in bezugsjahre_kenn_stichtag>

select 'Lauf fuer jahr ${bezugsjahr.jahr} beginnt: ' || now() from xdummy;

insert into tmp_kenn_kam_ja(
hs_nr,
       jahr,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       ist,
       datum
   )
           select
            Z.hs_nr,
            ${bezugsjahr.jahr},
            Z.dr,
            Z.titel,
            sum(akts_tit) as soll,
	    sum(reste_tit) as reste,
	    sum(haushaltsvorgriff) as haushaltsvorgriff,
	    (case when substring(Z.titel from 1 for 1) in ('4','5','6','7','8','9') then sum(ausgaben_tit)
	    when substring(Z.titel from 1 for 1) in ('0','1','2','3') then sum(einnahmen_tit)
	    else 0 end) as ist,
	    
today()
            from tmp_zeilen Z left outer join tmp_konto_aggr T on (
	    Z.titel=T.titel
	    and T.jahr=${bezugsjahr.jahr}
	    and T.bezugsjahr=${bezugsjahr.jahr}
	    
	    and T.jahr between year(Z.gueltig_von) and year(Z.gueltig_bis)
)
	    group by 1,2,3,4,jahr
	    ;
</#foreach>



delete from kenn_kam_ja where jahr in (select K.bezugszeit from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='KAM_JA'
        and K.bezugsart='J'
        )
        ;

insert into kenn_kam_ja(
hs_nr,
       jahr,
       dr,
       titel,
       soll,
       reste,
       haushaltsvorgriff,
       ist,
       datum
   )
select
hs_nr,
       jahr,
       dr,
       titel,
       sum(soll),
       sum(reste),
       sum(haushaltsvorgriff),
       sum(ist),
       datum
       from tmp_kenn_kam_ja
       group by 1,2,3,4,datum;
       
   
    drop table  tmp_kenn_kam_ja;
    drop table tmp_konto_aggr;
drop table tmp_zeilen;


    --testfall ausgaben_tit Titel 52701 in 2020 Monat 12 =469,4 EUR:
select 'Jahr 2020 sollte 469,4 ergeben:',
sum(ist) as ausgaben_tit 
from kenn_kam_ja
where jahr=2020
and titel='52701'
;

</#if>
--delete from kenn_kam_ja where betrag=0;
