
--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
    <sqlvar name="fin_installed">
        select count(*) from db_version where his_system ='fin';
    </sqlvar>
      <sqlvar name="KENN_FINANZEN_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_FINANZEN_DATENQUELLE'
    </sqlvar>

 
</sqlvars>

<#macro doubletype>
    <#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>

<#if fin_installed=1 && K_KENN_PROFIL?exists && (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>

--nicht fr BaWue berechnen:

<#assign jahrspalte="rechnungsjahr" />
<#assign monatspalte="monat" />

drop table if exists tmp_konto_aggr;

create temp table tmp_quartale(jahr smallint,
quartal smallint);
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '1') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id in ('KAM_QB', 'KAM_JA') 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '2') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id in ('KAM_QB', 'KAM_JA') 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '3') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id in ('KAM_QB', 'KAM_JA') 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '4') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id in ('KAM_QB', 'KAM_JA') 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct val(substring(''|| K.bezugszeit from 1 for 4)),K.bezugszeit 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='KAM_QB' 
and K.bezugsart='Q'
;

<@selectintotmp source="tmp_quartale" target="tmp_quartale2" 
      select="distinct quartal as bezugsquartal, 
jahr as bezugsjahr, 
jahr,
val(substring('' || quartal from 5 for 1)) as quartal,
null::integer as monat_von,
null::integer as monat_bis">
      </@selectintotmp> <@informixnolog/>;



--Quartale des Vorjahres fr kam_qb:
insert into tmp_quartale2
select distinct quartal as bezugsquartal,
jahr as bezugsjahr, 
jahr-1,
val(substring('' || quartal from 5 for 1)) as quartal ,
null::integer as monat_von,
null::integer as monat_bis
from tmp_quartale;

update tmp_quartale2 set monat_von=quartal*3-2;
update tmp_quartale2 set monat_bis=quartal*3;
--Korrekturmonate:
update tmp_quartale2 set monat_bis=14 where quartal=4;


create  table tmp_konto_aggr (
        hs_nr INTEGER ,
        jahr SMALLINT ,
	bezugsjahr integer,
        quartal integer,
        monat SMALLINT ,
        fikrkey CHAR(12) ,
        klr_geldgeber CHAR(10),
        titelgruppe_gege char(5),
        titel char(10),
        zweckbestimmung_ut char(10),
        dr char(5),
        dr2 char(5),
        titelart CHAR(1) ,
        kapitel char(5),
        ch110_institut CHAR(10) ,
        projnr char(10),
        betragsart CHAR(1) ,
        bund_fachgebiet char(10),
        bvkr_art char(12),
        extkotr char(30),
        extkost char(30),
        datum date ,
        kfmkam smallint,
        hhans <@doubletype/> default 0,
        einnahmen <@doubletype/> default 0,
        ausgaben  <@doubletype/> default 0,
        --nur Sachsen bentigt
        akts_tit <@doubletype/> default 0,
        hhans_tit <@doubletype/> default 0,
        einnahmen_tit <@doubletype/> default 0,
        ausgaben_tit  <@doubletype/> default 0,
        reste_tit <@doubletype/> default 0,
        haushaltsvorgriff <@doubletype/> default 0
        );
        update fin_konto_aggr set vojs_tit=0 where vojs_tit is null;
        update fin_konto_aggr set reste_tit=0 where reste_tit is null;

            --Standard kameral
            insert into
            tmp_konto_aggr (
            jahr,
	    bezugsjahr,
            quartal,
            monat,
            fikrkey,
            titelgruppe_gege,
            titel,
            zweckbestimmung_ut,
            dr,dr2,
            kapitel,
            ch110_institut,
            projnr,
            datum,
            kfmkam,
            hhans,
            einnahmen,
            ausgaben,
            akts_tit,
            hhans_tit,
            einnahmen_tit,
            ausgaben_tit,
            reste_tit
            )
            select A.${jahrspalte},
	    Q.bezugsjahr,
            Q.quartal,
            A.${monatspalte},
            A.fikr,
            A.titelgruppe_gege,
            A.titel,
            A.zweckbestimmung_ut,
	    A.dr,
	    A.dr2,
            A.kapitel,
            A.ch110_institut,
            A.kostentraeger,
            today(),
            1::smallint as kfmkam,
            sum(hhans_dr) ,
            sum(einnahmen_dr),
            sum(ausgaben_dr),
                sum(akt_soll_tit),
                sum(hhans_tit) ,
                sum(einnahmen_tit),
                sum(ausgaben_tit),
                sum(reste_tit) -- 9.7.2016 Drittmittelreste nicht mehr bentigt+sum(vojs_tit) -- Haushalt und Drittmittel
            from fin_konto_aggr A,tmp_quartale2 Q
            where Q.jahr=A.${jahrspalte}
            and A.${monatspalte} between Q.monat_von and Q.monat_bis
            and ${KENN_FIN_KONTEN}
            group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;


            --Haushaltsvorgriff
            <#if K_KENN_PROFIL?exists&& K_KENN_PROFIL==5 >
                --Der "Haushaltsvorgriff" kann auf allen Titeln erfolgen.
                --Es werden nicht Haushaltsreste oder Drittmittelreste ausgewertet, sondern das aktuelle Soll ohne Reste.
                --Wenn 2016 ausgewertet wird, wird in der HL nach Buchungen geschaut, die als Buchungsdatum noch 2016 haben, aber schon das Haushaltsjahr 2017 betreffen.
                --Buchungen fr das Haushaltsjahr 2017, die erst in 2017 erfolgen, werden nicht ausgewertet.
                -- Mails Benthien/FLoss 8.7.2016


                create temp table tmp_hhvorgriff(
                rechnungsjahr smallint,
                monat smallint,
                fikr char(12),
                titelgruppe_gege char(10),
                titel char(10),
                zweckbestimmung_ut char(3),
                dr char(5),dr2 char(5),
                kapitel char(5),
                ch110_institut char(10),
                kostentraeger char(10),
                betrag decimal(17,5));
                -- temp Tabelle wird fr alle Haushaltsjahre gefllt, beim insert into tmp_konto_aggr werden nur die per Berechnen-Hkchen gewnschten ausgelesen
                insert into tmp_hhvorgriff
                (rechnungsjahr,monat,fikr,titelgruppe_gege,titel,zweckbestimmung_ut,dr,dr2,kapitel,kostentraeger,betrag)
                select rechnungsjahr-1,month(buchungsdatum),fikr,titelgruppe_gege,titel,zweckbestimmung_ut,dr,dr2,kapitel,kostentraeger,sum(betrag) from fin_buch
                where
                rechnungsjahr=year(buchungsdatum)+1 and
                voa_buchschl in (101, 151, 102, 152, 104, 154, 110, 160, 111, 161, 112, 162, 120, 170, 201, 251, 202, 252, 203, 253, 204, 254, 206, 256) -- Buchungsschlssel positiv von AKTS
                group by 1,2,3,4,5,6,7,8,9,10;

                -- negative akts-Buchungsschlssel und Reste abziehen
                insert into tmp_hhvorgriff
                (rechnungsjahr,monat,fikr,titelgruppe_gege,titel,zweckbestimmung_ut,dr,dr2,kapitel,kostentraeger,betrag)
                select rechnungsjahr-1,month(buchungsdatum),fikr,titelgruppe_gege,titel,zweckbestimmung_ut,dr,dr2,kapitel,kostentraeger,sum(betrag*-1) from fin_buch
                where
                rechnungsjahr=year(buchungsdatum)+1 and
                voa_buchschl in (
                -- negative akts-Schssel
                103, 153,
                -- Reste abziehen
                104, 154, 112, 162
                )
                group by 1,2,3,4,5,6,7,8,9,10;

                insert into
                tmp_konto_aggr (
                jahr,
		bezugsjahr,
                quartal,
                monat,
                fikrkey,
                titelgruppe_gege,
                titel,
                zweckbestimmung_ut,
                dr,dr2,
                kapitel,
                ch110_institut,
                projnr,
                datum,
                kfmkam,
                haushaltsvorgriff
                )
                select A.${jahrspalte},
                Q.bezugsquartal,
		Q.bezugsjahr,
                A.${monatspalte},
                A.fikr,
                A.titelgruppe_gege,
                A.titel,
                A.zweckbestimmung_ut,A.dr,A.dr2,
                A.kapitel,
                A.ch110_institut,
                A.kostentraeger,
                today(),
                1::smallint,
                sum(betrag)
                from tmp_hhvorgriff A,tmp_quartale2 Q
                where Q.jahr=A.${jahrspalte}
                and A.${monatspalte} between Q.monat_von and Q.monat_bis
                and ${KENN_FIN_KONTEN}
                group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15;

                drop table tmp_hhvorgriff;
            </#if>
 
        update tmp_konto_aggr set dr=dr2 where dr2!='';


        --36002-Umschlsselung DQ Deaktiviert 21.7.2016
        <#if K_KENN_PROFIL?exists&& K_KENN_PROFIL==5>
            --  update tmp_konto_aggr set titel='36001' where titel='36002' and (klr_geldgeber is null or klr_geldgeber not in ('11','12','19','21','22','28','29','31','32','33a','33b','33c','33d','34','34a','35','36','37','38','39','40'));
            --vergl oben Suche nach "Titel 36002 - Drittmittelreste"
        </#if>
--testfall ausgaben_tit Titel 52701 in 2020 Monat 12 =469,4 EUR:
select 'sollte 469,4 ergeben:',
sum(ausgaben_tit) as ausgaben_tit 
from tmp_konto_aggr
where jahr=2020
and bezugsjahr=2020
and titel='52701'
;
--testfall ausgaben_tit Titel 52701 in 2021 Monat 10 =2000 EUR:
select 'sollte 2000 ergeben:',
sum(ausgaben_tit) as ausgaben_tit 
from tmp_konto_aggr
where jahr=2021
and bezugsjahr=2021
and titel='52701'
;
--und vorjahr 469,4 EUR
select 'sollte 469,4 ergeben:',
sum(ausgaben_tit) as ausgaben_tit 
from tmp_konto_aggr
where jahr=2020
and bezugsjahr=2021
and titel='52701'
;


    drop table tmp_quartale;
    drop table tmp_quartale2;
</#if>
--delete from kenn_kam_quartal where betrag=0;





