
--Freemarker Template

<sqlvars>
    <sqlvar name="cob_installed">
        select count(*) from db_version where his_system ='cob';
    </sqlvar>
    <sqlvar name="KENN_FLAECHEN_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_FLAECHEN_DATENQUELLE'
    </sqlvar>
</sqlvars>

<#if cob_installed=1||KENN_FLAECHEN_DATENQUELLE=170>

    delete from kenn_flaeche where 0=
    (select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');

    <#if cob_installed=1&&KENN_FLAECHEN_DATENQUELLE!=170>
        CREATE temp TABLE tmp_flaeche (
        hs_nr integer,
        ch110_institut character(10),
        rnanr character(4),
        nutzungsart character(4),
        kfanr varchar(10),
        jahr smallint,
        extkotr char(10),
        projnr char(10),
        datum date,
        flaeche double precision
        );


        insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
        select distinct today(),'kenn_stichtag'::char(18),'Stichtag fr Flchen im Jahr ' || bezugszeit || ' nicht definiert, es wird max(periodendatum) vorbelegt.'::char(200), 'Info'::char(10)
        from kenn_stichtag
        where stichtagsart_id='FLCG'
        and stichtag is null;

        update kenn_stichtag set stichtag=(select max(C.periodendatum) from cob_imp_flaeche C
        where year(C.periodendatum)=kenn_stichtag.bezugszeit)
        where stichtagsart_id='FLCG'
        and stichtag is null;


        insert into tmp_flaeche (ch110_institut,rnanr,kfanr,jahr,datum,projnr,flaeche)
        select ch110_institut,C.rnanr,C.kfanr,K.bezugszeit,today(),C.projnr,sum(C.flaeche)
        from cob_imp_flaeche C, kenn_stichtag K
        --echo "hier noch quelldatnr abfragen."
        where C.periodendatum = K.stichtag
        and K.stichtagsart_id='FLCG'
        and K.berechnen='1'
        --and K.bezugszeit=year(C.periodendatum)
        group by 1,2,3,4,5,6;

        update tmp_flaeche set nutzungsart='H' where 0 <
        (SELECT count(*) from cob_cifx C, cob_rna2nakfa R where C.key=700 and C.apnr=R.na_nr and R.rna_key=tmp_flaeche.rnanr and C.druck like 'H%');
        update tmp_flaeche set nutzungsart='N'
        where nutzungsart is null
        and 0 <
        (SELECT count(*) from cob_cifx C, cob_rna2nakfa R where C.key=700 and C.apnr=R.na_nr and R.rna_key=tmp_flaeche.rnanr and C.druck like 'N%')
        ;
        update tmp_flaeche set hs_nr=(select hs_nr from hochschulinfo);

        --Der LFB wird in erster Prioritt ber das Projekt zugewiesen
        update tmp_flaeche set extkotr=(select min(k_extkotr) from cob_proj P where P.projnr=tmp_flaeche.projnr)
        where projnr is not null;


        <#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>
            --nur NHS Sachsen:
            --Der LFB wird in zweiter Prioritt ber das Projekt proj.fins zugewiesen
            update tmp_flaeche set extkotr=(select min(E.key) from cob_proj I, kenn_extkotr E
            where I.projnr=tmp_flaeche.projnr
            and substring(E.key from 4 for 3)=I.fins --der LFB ist im externen Porduktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
            and E.kategorie='lf' --Ebene LFB
            and E.key like '1%' --nur Lehre
            )
            where extkotr is null
            and projnr is not null
            ;
            --und in dritter Prioritt ber die Kostenstelle:
            update tmp_flaeche set extkotr=(select min(I.key_extkotr) from kenn_inst_to_ext I
            where I.instnr=tmp_flaeche.ch110_institut
            and I.key_extkotr is not null
            and trim(I.key_extkotr) !=''
            )
            where  extkotr is null
            ;
            --in vierter Prioritt ber den LFB der inst:
            update tmp_flaeche set extkotr=(select min(E.key) from kenn_inst I, kenn_extkotr E
            where I.key_apnr=tmp_flaeche.ch110_institut
            and substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Produktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
            and E.kategorie='lf' --Ebene LFB
            and E.key like '1%' --nur Lehre
            )
            where  extkotr is null
            ;

            insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
            select distinct today(),'cob_proj'::char(18),'Projekt ' || trim(projnr) || ' im Bereich Flchen ist keinem ext. Kostentrger zugeordnet !'::char(200), 'Warnung'::char(10)
            from tmp_flaeche
            where extkotr is null
            and projnr is not null;
            insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
            select distinct today(),'cob_inst'::char(18),'Kostenstelle ' || trim(ch110_institut) || ' im Bereich Flchen ist keinem LFB zugeordnet !'::char(200), 'Warnung'::char(10)
            from tmp_flaeche
            where extkotr is null
            and projnr is null
            and ch110_institut is not null
            ;
        </#if>

        delete from kenn_flaeche where jahr in (
        select bezugszeit from kenn_stichtag where stichtagsart_id='FLCG'
        and berechnen='1'
        );

        insert into kenn_flaeche (hs_nr,ch110_institut,nutzungsart,jahr,kfanr,datum,extkotr,flaeche)
        select hs_nr,ch110_institut,nutzungsart,jahr,kfanr,datum,extkotr,sum(flaeche)
        from tmp_flaeche
        group by 1,2,3,4,5,6,7;


        drop table tmp_flaeche;
    </#if>
    <#if KENN_FLAECHEN_DATENQUELLE==170>
        delete from kenn_flaeche where jahr in (
        select bezugszeit from kenn_stichtag where stichtagsart_id='FLCG'
        and berechnen='1'
        );
        insert into kenn_flaeche (
        hs_nr,
        ch110_institut,
        nutzungsart,
        kfanr,
        jahr,
        datum,
        flaeche,
        extkotr)
        SELECT hs_nr,
        quell_institut,
        nutzungsart,
        kfanr,
        jahr,
        datum,
        flaeche,
        extkotr
        FROM gxstage_flaeche where jahr in
        (select bezugszeit from kenn_stichtag where stichtagsart_id='FLCG' and berechnen='1');

    </#if>

</#if>
