--freemarker template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>
<sqlvars>
<sqlvar name="jahre_kenn_stichtag" type='hashsequence'>
select K.bezugszeit as id from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='KWIPL'          
and K.bezugsart='J';
</sqlvar>
</sqlvars>


create temp table tmp_erg(
hs_nr integer,
jahr smallint,
sortnr smallint, 
kuerzel varchar(40), 
kontengruppe varchar(255),
zweck varchar(255),
ist decimal(14,2),
ist_fuer_summierung decimal(14,2)
)<@informixnolog/>;
create temp table tmp_summe (ist decimal(14,2) )<@informixnolog/>;

<#if jahre_kenn_stichtag?exists && jahre_kenn_stichtag?has_content >
<#foreach jahr in jahre_kenn_stichtag>
delete from tmp_erg;

--jahr wird unten per update gesetzt
<#macro einfuegen sortnr kuerzel kg zweck sql hjahr>
insert into tmp_erg (sortnr,kuerzel,kontengruppe,zweck,ist)
values (${sortnr},'${kuerzel}','${kg}','${zweck}',
(select sum(saldo) from fin_fibu_kontenstand where  haushaltsjahr::integer=${hjahr}  and bkreis::varchar(10) in (select key_bga from fin_bga where bilanz='1') and ${sql})
);
</#macro>

<#macro summe sortnr bedingung  kg="" kuerzel="" zweck="">
delete from tmp_summe;
insert into tmp_summe select sum(ist) from tmp_erg where ${bedingung};
insert into tmp_erg (sortnr,kuerzel,kontengruppe,zweck,ist)
select ${sortnr},'${kuerzel}','${kg}','${zweck}',ist from tmp_summe;
</#macro>
<#macro differenz sortnr bedingung_plus bedingung_minus kg="" kuerzel="" zweck="">
delete from tmp_summe;
insert into tmp_summe select sum(ist) from tmp_erg where ${bedingung_plus};
insert into tmp_summe select sum(-ist) from tmp_erg where ${bedingung_minus};
insert into tmp_erg (sortnr,kuerzel,kontengruppe,zweck,ist)
select ${sortnr},'${kuerzel}','${kg}','${zweck}',sum(ist) from tmp_summe
group by 1,2,3,4;
</#macro>
insert into tmp_erg (sortnr,kuerzel,zweck) values (10,'A','Erfolgsplan');
insert into tmp_erg (sortnr,kuerzel,zweck) values (20,'I.','(ordentliche) Ertrge');
<@einfuegen sortnr=30 kuerzel="1." kg="50" sql="sachkonto like '50%'" zweck="Ertrge aus der Hochschulttigkeit" hjahr=jahr.id/>
<@einfuegen sortnr=40 kuerzel="2." kg="51" sql="sachkonto like '51%'" zweck="Ertrge aus Gebhren und Sanktionen, Entgelte" hjahr=jahr.id/>
<@einfuegen sortnr=50 kuerzel="3." kg="520,521" sql="(sachkonto like '520%' or sachkonto like '521%')" zweck="Erhhungen oder Verminderungen des Bestandes an unfertigen und fertigen Leistungen" hjahr=jahr.id/>
<@einfuegen sortnr=60 kuerzel="4." kg="525" sql="sachkonto like '525%'" zweck="Andere aktivierte Eigenleistungen" hjahr=jahr.id/>
<@einfuegen sortnr=70 kuerzel="5." kg="53,54,58" sql="(sachkonto like '53%' or sachkonto like '54%'  or sachkonto like '58%')" zweck="Sonstige betriebliche Ertrge" hjahr=jahr.id/>
<@einfuegen sortnr=80 kuerzel="5.1" kg="" sql='1=0' zweck="Ertrge aus Zuweisungen und Zuschssen, Kostenerstattungen sowie Produktabgeltung" hjahr=jahr.id/>
<@einfuegen sortnr=90 kuerzel="5.1.1." kg="" sql='1=0' zweck="darunter: Ertrge aus Zuweisungen und Zuschssen, Kostenerstattungen sowie Produktabgeltung vom Freistaat Sachsen" hjahr=jahr.id/>
<@einfuegen sortnr=100 kuerzel="5.2" kg="" sql='1=0' zweck="Ertrge aus Zuweisungen und Zuschssen zur Finanzierung von Investitionen" hjahr=jahr.id/>
<@einfuegen sortnr=110 kuerzel="5.2.1" kg="" sql='1=0' zweck="Ertrge aus Zuweisungen und Zuschssen zur Finanzierung von Investitionen vom Freistaat Sachsen" hjahr=jahr.id/>
<@einfuegen sortnr=120 kuerzel="5.3" kg="" sql='1=0'  zweck="Ertrge aus der Auflsung von Sonderposten" hjahr=jahr.id/>
<@summe sortnr=130 bedingung="sortnr in (30,40,50,60,70,80,100,110,120)" kg="Summe"/>
<@summe sortnr=131 bedingung="sortnr in (30,40,50,60,70,80,100,110,120)" kg="Summe der (ordentlichen) Ertrge"/>
insert into tmp_erg (sortnr,kuerzel) values (140,'II. (ordentliche Aufwendungen)');
insert into tmp_erg (sortnr,kuerzel,kontengruppe) values (150,'6.','Materialaufwand');
<@einfuegen sortnr=160 kuerzel="6.1" kg="60"  sql="sachkonto like '60%'" zweck="Aufwand fr Schrifttum, Lehr- und Lernmittel, Materialien und bezogene Waren" hjahr=jahr.id/>
<@einfuegen sortnr=170 kuerzel="6.2" kg="60" sql="sachkonto like '60%'" zweck="Aufwendungen fr Energie und sonstige verwaltungswirtschaftliche Ttigkeit" hjahr=jahr.id/>
<@einfuegen sortnr=180 kuerzel="6.3" kg="61" sql="sachkonto like '61%'"zweck="Aufwendungen fr bezogene Leistungen" hjahr=jahr.id/>
<@summe sortnr=190 bedingung="sortnr>=160 and sortnr<=180" zweck="Summe" />
insert into tmp_erg (sortnr,kuerzel,kontengruppe) values (200,'7.','Personalaufwand');
<@einfuegen sortnr=210 kuerzel="7.1" kg="62" sql="sachkonto like '62%'" zweck="Entgelte fr Beschftigte" hjahr=jahr.id/>
<@einfuegen sortnr=220 kuerzel="7.2" kg="63" sql="sachkonto like '63%'" zweck="Bezge der Beamten" hjahr=jahr.id/>
<@einfuegen sortnr=230 kuerzel="7.3" kg="62" sql="sachkonto like '62%'" zweck="Vergtungen fr Auszubildende/Volontre" hjahr=jahr.id/>
<@einfuegen sortnr=240 kuerzel="7.4" kg="62" sql="sachkonto like '62%'" zweck="Entgelte Drittmittelbeschftigte" hjahr=jahr.id/>
<@einfuegen sortnr=250 kuerzel="7.5" kg="64" sql="sachkonto like '64%'" zweck="Soziale Abgaben und Aufwendungen fr Altersversorgung und fr Untersttzung" hjahr=jahr.id/>
<@einfuegen sortnr=260 kuerzel="7.6" kg="65" sql="sachkonto like '65%'" zweck="Sonstige Personalaufwendungen" hjahr=jahr.id/>
<@summe sortnr=270 bedingung="sortnr>=210 and sortnr<=260" kg="Summe"/>
<@einfuegen sortnr=280 kuerzel="8" kg="66" sql="sachkonto like '66%'" zweck="Abschreibungen" hjahr=jahr.id/>
insert into tmp_erg (sortnr,kuerzel,kontengruppe) values (290,'9.','Sonstige betriebliche Aufwendungen');
<@einfuegen sortnr=295 kuerzel="9.1" kg="67" sql="sachkonto like '67%'" zweck="Aufwendungen fr die Inanspruchnahme von Rechten und Diensten" hjahr=jahr.id/>
<@einfuegen sortnr=300 kuerzel="9.2" kg="68" sql="sachkonto like '68%'"zweck="Weitere Aufwendungen fr Kommunikation, Dokumentation, Information, Reisen, Literatur, Werbung" hjahr=jahr.id/>
<@einfuegen sortnr=310 kuerzel="9.3" kg="69" sql="sachkonto like '69%'"zweck="Aufwendungen fr Beitrge und Sonstiges sowie Wertkorrekturen und periodenfremde Aufwendungen" hjahr=jahr.id/>
<@einfuegen sortnr=320 kuerzel="" kg="" sql='1=0'  zweck="davon: Aufwendungen fr die Einstellung in Sonderposten " hjahr=jahr.id/>
<@einfuegen sortnr=330 kuerzel="9.4" kg="71,78" sql="(sachkonto like '71%' or sachkonto like '78%')"zweck="Aufwendungen fr Zuweisungen und Zuschsse, Investitionszuschsse und Kostenerstattungen sowie aus Produktabgeltung" hjahr=jahr.id/>
<@einfuegen sortnr=340 kuerzel="9.5" kg="73" sql="sachkonto like '73%'" zweck="Aufwendungen fr sonstige Leistungen an Dritte" hjahr=jahr.id/>
<@einfuegen sortnr=350 kuerzel="9.6" kg="70" sql="sachkonto like '70%'"  zweck="Betriebliche Steuern" hjahr=jahr.id/>
<@summe sortnr=360 bedingung="sortnr in (295,300,310,330,340,350)" zweck="Summe" />
<@summe sortnr=370 bedingung="sortnr in (160,170,180,210,220,230,240,250,260,280,295,300,310,330,340,350)" zweck="Summe der ordentlichen Aufwendungen"/>
<@differenz sortnr=380 bedingung_plus="sortnr in (131)" bedingung_minus="sortnr in (370)" kuerzel="III." zweck="Verwaltungsergebnis(=ertrge I. ./.Aufwendungen II.)"/>

--insert into tmp_erg (sortnr,kuerzel,zweck) values (380,'III.','Verwaltungsergebnis(=ertrge I. ./.Aufwendungen II.)');
<@einfuegen sortnr=390 kuerzel="10." kg="56" sql="sachkonto like '56%'" zweck="Ertrge aus Beteiligungen an verbundenen Unternehmen" hjahr=jahr.id/>
<@einfuegen sortnr=400 kuerzel="11." kg="56" sql="sachkonto like '56%'"  zweck="Ertrge aus anderen Wertpapieren und Ausleihungen des Finanzvermgens" hjahr=jahr.id/>
<@einfuegen sortnr=410 kuerzel="12." kg="57" sql="sachkonto like '57%'"  zweck="Sonstige Zinsen und hnliche Ertrge" hjahr=jahr.id/>
<@einfuegen sortnr=420 kuerzel="13." kg="74" sql="sachkonto like '74%'" zweck="Abschreibungen auf Finanzanlagen und auf Wertpapiere des Umlaufvermgens" hjahr=jahr.id/>
<@einfuegen sortnr=430 kuerzel="14." kg="75" sql="sachkonto like '75%'"  zweck="Zinsen und hnliche Aufwendungen" hjahr=jahr.id/>
<@differenz sortnr=440 bedingung_plus="sortnr in (400)" bedingung_minus="sortnr in (410,420,430)" kuerzel="IV." zweck="Finanzergebnis(=11+12./.13./.14)"/>
<@summe sortnr=450 bedingung="sortnr in (390,400,410,420,430)" kuerzel="IV." zweck="Ergebnis der gewhnlichen Geschftsttigkeit(=III.+IV)"/>
<@einfuegen sortnr=460 kuerzel="15." kg="59" sql="sachkonto like '59%'" zweck="Auerordentliche Ertrge" hjahr=jahr.id/>
<@einfuegen sortnr=470 kuerzel="16." kg="79" sql="sachkonto like '79%'" zweck="Auerordentliche Aufwendungen" hjahr=jahr.id/>
<@summe sortnr=480 bedingung="sortnr in (0)" kuerzel="VI." zweck="Summe Steuern"/>
<@summe sortnr=490 bedingung="sortnr in (0)" kuerzel="VII." zweck="Jahresergebnis(=V.+VI../.Steuern)"/>
insert into tmp_erg (sortnr,kuerzel,zweck) values (500,'B.Investitionsplan','');
<@einfuegen sortnr=510 kuerzel="1." kg="" sql='1=0' zweck="Investitionen aus Mitteln des Freistaates Sachsen (ber 5 T EUR)" hjahr=jahr.id/>
<@einfuegen sortnr=520 kuerzel="2." kg="" sql='1=0' zweck="Investitionen aus Mitteln des Freistaates Sachsen (bis zu 5 T EUR)" hjahr=jahr.id/>
<@einfuegen sortnr=530 kuerzel="3." kg="" sql='1=0' zweck="Sonderinvestitionen (nachrichtlich)" hjahr=jahr.id/>
<@einfuegen sortnr=540 kuerzel="4." kg="" sql='1=0' zweck="Investitionen aus Mitteln Dritter und eigenen Einnahmen" hjahr=jahr.id/>
<@summe sortnr=550 bedingung="sortnr in (510,520,530,540)" zweck="Summe Investitionen"/>
insert into tmp_erg (sortnr,kuerzel,zweck) values (560,'C.','Finanzplan');
insert into tmp_erg (sortnr,kuerzel,zweck) values (570,'I.','Finanzbedarf');
insert into tmp_erg (sortnr,kuerzel,zweck) values (580,'1.','Finanzbedarf fr den laufenden Betrieb');
<@einfuegen sortnr=590 kuerzel="1.1" kg="" sql='1=0' zweck="Jahresfehlbetrag/-berschuss(vgl.A Erfolgsplan VIII.)" hjahr=jahr.id/>
<@einfuegen sortnr=600 kuerzel="1.2" kg="" sql='1=0' zweck="-Zuweisungen und Zuschsse des Freistaates Sachsen" hjahr=jahr.id/>
<@einfuegen sortnr=610 kuerzel="1.3" kg="" sql='1=0' zweck="+/-Abschreibungen/Zuschreibungen" hjahr=jahr.id/>
<@einfuegen sortnr=620 kuerzel="1.4" kg="" sql='1=0' zweck="+/-Zunahme/Abnahme der Rckstellungen" hjahr=jahr.id/>
<@einfuegen sortnr=630 kuerzel="1.5" kg="" sql='1=0' zweck="+/-Zunahme/Abnahme der Sonderposten aus Investitionszuweisungen/-zuschssen" hjahr=jahr.id/>
<@einfuegen sortnr=640 kuerzel="1.6" kg="" sql='1=0' zweck="+/-Sonstige zahlungswirksamem Aufwendungen/Ertrge" hjahr=jahr.id/>
<@einfuegen sortnr=650 kuerzel="1.7" kg="" sql='1=0' zweck="+/-Verlust/Gewinn aus dem Abgang von Anlagevermgen" hjahr=jahr.id/>
<@einfuegen sortnr=660 kuerzel="1.8" kg="" sql='1=0' zweck="+/-Abnahme /Zunahme der Vorrte, Forderungen aus Lieferungen und Leistungen sowie anderer Aktiva (soweit nicht Investitions- oder Finanzierungsbereich zugeordnet)" hjahr=jahr.id/>
<@einfuegen sortnr=670 kuerzel="1.9" kg="" sql='1=0' zweck="+/-Zunahme/Abnahme der Verbindlichkeiten aus Lieferungen und Leistungen sowie anderer Passiva (soweit nicht Investitions- oder Finanzierungsbereich zugeordnet)" hjahr=jahr.id/>
<@summe sortnr=680 bedingung="sortnr>=590 and sortnr<=670" zweck="Summe Finanzbedarf fr den laufenden Betrieb"/>
insert into tmp_erg (sortnr,kuerzel,zweck) values (690,'2.','Finanzbedarf fr Investitionen');
<@einfuegen sortnr=700 kuerzel="2.1" kg="" sql='1=0' zweck="+Einzahlungen aus dem Abgang von Anlagevermgen" hjahr=jahr.id/>
<@einfuegen sortnr=710 kuerzel="2.2" kg="" sql='1=0' zweck="-Auszahlungen fr Investitionen (vgl. B. Investitionsplan)" hjahr=jahr.id/>
<@summe sortnr=720 bedingung="sortnr>=700 and sortnr<=710" zweck="Summe Finanzbedarf fr Investitionen"/>
<@summe sortnr=730 bedingung="sortnr in (680,720)" zweck="Summe Finanzbedarf(=1.+2.)"/>
insert into tmp_erg (sortnr,kuerzel,zweck) values (740,'II.','Deckungsmittel');

<@einfuegen sortnr=750 kuerzel="3." kg="" sql='1=0' zweck="+Zuweisungen und Zuschsse des Freistaates Sachsen fr den laufenden Betrieb" hjahr=jahr.id/>
<@einfuegen sortnr=760 kuerzel="4." kg="" sql='1=0' zweck="+/-Zuweisungen und Zuschsse des Freistaates Sachsen fr Investitionen" hjahr=jahr.id/>
<@einfuegen sortnr=770 kuerzel="5." kg="" sql='1=0' zweck="+/- Entnahme/Bildung von Rcklagen" hjahr=jahr.id/>
<@einfuegen sortnr=780 kuerzel="6." kg="" sql='1=0' zweck="+/- Sonstiges" hjahr=jahr.id/>
<@summe sortnr=790 bedingung="sortnr>=750 and sortnr<=780" zweck="Summe Deckungsmittel"/>
<@summe sortnr=800 bedingung="sortnr in (730,790)" zweck="Summe I.+II."/>

update tmp_erg set jahr=${jahr.id};
update tmp_erg set ist=round(ist/1000,2) ;

update tmp_erg set hs_nr=(select hs_nr from hochschulinfo);
--ab in Zieltabelle

--- update der Zieltabelle falls schon vorhanden
update kenn_fibu_wiplan
set ist=(select ist from tmp_erg where tmp_erg.hs_nr||'-'||jahr||'-'||sortnr=kenn_fibu_wiplan.id)
where sortnr<500;


--ggfs. in Kontendefinition gelschte eintrge entfernen

delete from kenn_fibu_wiplan 
where jahr=${jahr.id} and id not in
(select hs_nr||'-'||${jahr.id}||'-'||sortnr from tmp_erg);

--bereits vorhandene Datenstze aus temp  Tabelle lschen
delete from tmp_erg where hs_nr||'-'||jahr||'-'||sortnr in (select id from kenn_fibu_wiplan);

update kenn_fibu_wiplan set datum=today() where jahr=${jahr.id} ;


insert into kenn_fibu_wiplan ( hs_nr,id,
       jahr,
       kuerzel,
       kontengruppe,
       zweckbestimmung,
       ist,
       sortnr,
       datum)
SELECT hs_nr,
hs_nr||'-'||jahr||'-'||sortnr,
       jahr,
       kuerzel,
       kontengruppe,
       zweck,
       ist,
       sortnr,
       today()
FROM tmp_erg;

</#foreach> -- ENDE Jahrschleife
</#if>
drop table tmp_summe;
drop table tmp_erg;






