--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>
--auswertungsid fr das Jahr die id mit der hchsten Gltigkeit auslesen
<sqlvars>
<sqlvar name="fin_fibu_auswertung_art_exists">
select sp_table_exists('fin_fibu_auswertung_art') from xdummy
</sqlvar> 
<sqlvar name="fin_fibu_auswertung_definition_exists">
select sp_table_exists('fin_fibu_auswertung_definition') from xdummy
</sqlvar> 
<sqlvar name='startjahr_neues_design'>select 2015 from xdummy</sqlvar> 
<sqlvar name="jahre_kenn_stichtag" type='hashsequence'>
select distinct val(substring(''|| K.bezugszeit from 1 for 4)) as id from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='GuVQ'   
;
</sqlvar>
<sqlvar name="bezugsquartale_kenn_stichtag" type='hashsequence'>
create temp table tmp_quartale(jahr smallint,
quartal smallint);
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '1') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='GuVQ' 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '2') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='GuVQ' 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '3') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='GuVQ' 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct K.bezugszeit, val('' || K.bezugszeit || '4') as id 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='GuVQ' 
and K.bezugsart='J'
;
insert into tmp_quartale(jahr, quartal)  
select distinct val(substring(''|| K.bezugszeit from 1 for 4)),K.bezugszeit 
from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='GuVQ' 
and K.bezugsart='Q'
;
select distinct jahr, quartal
from tmp_quartale;
drop table tmp_quartale;

</sqlvar>
<sqlvar name='auswertungids' type="hashsequence" ><![CDATA[
<#if fin_fibu_auswertung_art_exists==1 >
--fuer jedes Jahr die id mit der hchsten Gltigkeit auslesen
create temp table tmp_last_art (id integer,bezeichnung varchar(255),gueltig_ab integer,zieljahr integer);
create temp table tmp_max_gueltig_ab (gueltig_ab integer);

<#if jahre_kenn_stichtag?exists && jahre_kenn_stichtag?has_content >
<#foreach jahr in jahre_kenn_stichtag>
insert into tmp_last_art 
select id, bezeichnung,gueltig_ab,${jahr.id} from fin_fibu_auswertung_art where

art = 'G'  and bezeichnung like '%Quartal%'                           

and gueltig_ab <=${jahr.id} ; -- aktiv = 'J' entfernt 96184#c2
delete from tmp_max_gueltig_ab;
insert into tmp_max_gueltig_ab 
select max(gueltig_ab) from tmp_last_art where zieljahr=${jahr.id};
delete from tmp_last_art where gueltig_ab not in (select gueltig_ab from tmp_max_gueltig_ab) and zieljahr=${jahr.id};
</#foreach>
</#if>
select zieljahr,id from tmp_last_art;
drop table tmp_last_art;drop table tmp_max_gueltig_ab;
</#if>
]]></sqlvar>
<sqlvar name='definitionen' type='hashsequence'><![CDATA[ 
<#if fin_fibu_auswertung_definition_exists==1>
select fibu_auswertung_art_id,
id,
drucktext,
hierarchie_ebene,
status from fin_fibu_auswertung_definition where
      hierarchie_ebene>0 
  order by fibu_auswertung_art_id,
id;
</#if>
  ]]></sqlvar>
<sqlvar name="Auswertungsdefinition" type="sicht" name_intern="fibu_auswertung_def" ></sqlvar>
</sqlvars>


<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>


-- fibu_auswertung_konten_zuordnung.status ist bit-codiert:
-- Bit0: Konto und -saldo anzeigen (0=Nein, 1=Ja)
-- Bit1: Saldo in bergeordneten Hierarchiestufen fr Summen verwenden (0=Nein, 1=Ja)
--00==0 = nix - technisch mglich, jedoch unsinnig (d.h. das Konto wird komplett ignoriert).
--01   =1 =  nicht anzeigen, saldo verwenden
-- 10  = 2 = anzeigen, saldo nicht verwenden
-- 11 = 3 = anzeigen, saldo verwenden

 
--Einzelbetrge kontret auf ein Sachkonto gebucht
create temp table tmp_konto (sachkonto varchar(12),
kategorie char(1),--bei Kategorie K betrag * -1
klasse char(8),
sollhaben char(1),
<#list 1..4 as quartal>
q${quartal}soll <@doubletype/>,
q${quartal}haben <@doubletype/>,
q${quartal}betrag <@doubletype/>,
vorjahr_q${quartal}soll <@doubletype/>,
vorjahr_q${quartal}haben <@doubletype/>,
vorjahr_q${quartal}betrag <@doubletype/>,
</#list>
vorjahrsoll <@doubletype/>,
vorjahrhaben <@doubletype/>,
vorjahr <@doubletype/>
) <@informixnolog/>;

create temp table tmp_erg (hs_nr integer,
jahr smallint,
bezugsquartal smallint,
defid integer,
kontengruppe varchar(255),
zeile varchar(255),
name varchar(255),
hierarchie_ebene smallint,
<#list 1..4 as quartal>
q${quartal} <@doubletype/>,
vorjahr_q${quartal} <@doubletype/>,
</#list>
vorjahr <@doubletype/>,
 sortnr integer,
zeilennr integer
 ) <@informixnolog/>;

create temp table tmp_max (maxsortnr integer) <@informixnolog/>;
create temp table tmp_sum (
<#list 1..4 as quartal>
q${quartal} <@doubletype/>,
vorjahr_q${quartal} <@doubletype/>,
</#list>
vorjahr <@doubletype/>) 
<@informixnolog/>;

<#if bezugsquartale_kenn_stichtag?exists && bezugsquartale_kenn_stichtag?has_content >
<#foreach bezugsquartal in bezugsquartale_kenn_stichtag>

delete from tmp_konto;


 insert into tmp_konto (sachkonto,
q1haben,
q1soll,
q2haben,
q2soll,
q3haben,
q3soll,
q4haben,
q4soll)
select sachkonto,
sum(haben_00)+sum(haben_01)+sum(haben_02)+sum(haben_03),
sum(soll_00)+sum(soll_01)+sum(soll_02)+sum(soll_03),
sum(haben_04)+sum(haben_05)+sum(haben_06),
sum(soll_04)+sum(soll_05)+sum(soll_06),
sum(haben_07)+sum(haben_08)+sum(haben_09),
sum(soll_07)+sum(soll_08)+sum(soll_09),
sum(haben_10)+sum(haben_11)+sum(haben_12)+sum(haben_13),
sum(soll_10)+sum(soll_11)+sum(soll_12)+sum(soll_13)
from fin_fibu_kontenstand where haushaltsjahr::integer=${bezugsquartal.jahr} and sachkonto in
    (select sachkonto from fin_fibu_auswertung_konten_zuordnung where status not in (0,2) )
     and (bkreis=0 or bkreis in (select k_bga_id from fin_bga where bilanz='1') )
     group by 1;

--vorjahr:
insert into tmp_konto (sachkonto,
vorjahr_q1haben,
vorjahr_q1soll,
vorjahr_q2haben,
vorjahr_q2soll,
vorjahr_q3haben,
vorjahr_q3soll,
vorjahr_q4haben,
vorjahr_q4soll,
vorjahrsoll,
vorjahrhaben
)
select sachkonto,
sum(haben_00)+sum(haben_01)+sum(haben_02)+sum(haben_03),
sum(soll_00)+sum(soll_01)+sum(soll_02)+sum(soll_03),
sum(haben_04)+sum(haben_05)+sum(haben_06),
sum(soll_04)+sum(soll_05)+sum(soll_06),
sum(haben_07)+sum(haben_08)+sum(haben_09),
sum(soll_07)+sum(soll_08)+sum(soll_09),
sum(haben_10)+sum(haben_11)+sum(haben_12)+sum(haben_13),
sum(soll_10)+sum(soll_11)+sum(soll_12)+sum(soll_13),
sum(soll),
sum(haben)
from fin_fibu_kontenstand where haushaltsjahr::integer=${bezugsquartal.jahr}-1 
and sachkonto in (select sachkonto from fin_fibu_auswertung_konten_zuordnung where status not in (0,2) )
     and (bkreis=0 or bkreis in (select k_bga_id from fin_bga where bilanz='1') )
     group by 1;
     

update tmp_konto set sollhaben=(select sollhaben from fin_fibu_kont 
where haushaltsjahr::integer<=${bezugsquartal.jahr} 
and (hhjende is null or hhjende::integer >= ${bezugsquartal.jahr})
and tmp_konto.sachkonto=fin_fibu_kont.sachkonto
);
--verrechnen
update tmp_konto set 
<#list 1..4 as quartal>
q${quartal}betrag=q${quartal}soll-q${quartal}haben,
vorjahr_q${quartal}betrag=vorjahr_q${quartal}soll-vorjahr_q${quartal}haben,
</#list>
vorjahr=vorjahrsoll-vorjahrhaben 
where sollhaben='S';

update tmp_konto set 
<#list 1..4 as quartal>
q${quartal}betrag=q${quartal}haben-q${quartal}soll,
vorjahr_q${quartal}betrag=vorjahr_q${quartal}haben-vorjahr_q${quartal}soll,
</#list>
vorjahr=vorjahrhaben-vorjahrsoll 
where sollhaben='H';
   
-- bei Kontokategorie K betrag mal -1
update tmp_konto set kategorie=(select kategorie from fin_fibu_kont 
where   haushaltsjahr::integer<=${bezugsquartal.jahr} 
  and (hhjende is null or hhjende::integer >= ${bezugsquartal.jahr})
  and tmp_konto.sachkonto=fin_fibu_kont.sachkonto
  );
update tmp_konto set 
<#list 1..4 as quartal>
q${quartal}betrag=q${quartal}betrag*-1,
vorjahr_q${quartal}betrag=vorjahr_q${quartal}betrag*-1,
</#list>
vorjahr=vorjahr*-1 where kategorie='K';

-- VINT/FINT rausfiltern
update tmp_konto set klasse=
 (select distinct klasse from fin_fibu_kont
 where tmp_konto.sachkonto=fin_fibu_kont.sachkonto 
 and haushaltsjahr::integer<= ${bezugsquartal.jahr} 
 and ( hhjende is null or hhjende::integer>= ${bezugsquartal.jahr} ) );
update tmp_konto set 
<#list 1..4 as quartal>
q${quartal}betrag=0,
vorjahr_q${quartal}betrag=0,
</#list>
vorjahr=0 
where klasse in ('VINT','FINT');

-- TMP_ERG wird gefllt
---richtige Auswertungsid fr das Jahr raussuchen
    <#assign auswertungsid=-1/>
   <#foreach a in auswertungids>
   <#if a.zieljahr==bezugsquartal.jahr?number><#assign auswertungsid=a.id/></#if>
   </#foreach>
  
  
--   BERICHTSDEFINITIONEN durcharbeiten

<#assign sortnr=0>
<#foreach def in definitionen>
<#if def.fibu_auswertung_art_id==auswertungsid&&def.drucktext!='Unterstrich'>
<#assign sortnr=sortnr+1000>
insert into tmp_erg (jahr,
bezugsquartal,
defid,
name,
hierarchie_ebene,
sortnr)
values (${bezugsquartal.jahr},
${bezugsquartal.quartal},
${def.id},
'${def.drucktext?replace("EUR"," EUR")?replace("\x20AC"," EUR")?replace("\x0080"," EUR")?replace("'","''")}',
${def.hierarchie_ebene},
${sortnr});


-- fibu_auswertung_definition.status ist bit-codiert:
-- Bit0: Summe dessen was oberhalb ist anzeigen (0=Nein, 1=Ja)
-- Bit1: Summe in bergeordneten Hierarchiestufen verwenden (0=Nein, 1=Ja)
-- Bit2: Summe dessen was unterhalb ist anzeigen (0=Nein, 1=Ja) --also in der gleichen Zeile

-- 000 = 0 = oberhalb nein, verwenden nein, unterhalb nein
-- 001 = 1 = oberhalb nein, verwenden nein, unterhalb ja
-- 010 = 2 = oberhalb nein,verwenden ja, unterhalb nein
-- 011 = 3 = oberhalb nein, verwenden ja, unterhalb ja
-- 100 = 4 = oberhalb ja, verwenden nein, unterhalb nein
-- 101 = 5 = oberhalb ja, verwenden nein, unterhalb ja  -> nicht erlaubt
-- 110 = 6 = oberhalb ja, verwenden ja, unterhalb nein
-- 111 = 7 = oberhalb ja, verwenden ja, unterhalb ja

<#macro sachkontenauswahl def>
 sachkonto in 
 (select sachkonto from fin_fibu_auswertung_konten_zuordnung where status not in (0,2) and 
 fibu_auswertung_definition_id in ${Auswertungsdefinition("getSubkeys","${auswertungsid}-${def.id}")?replace("${auswertungsid}-","")}    )   
</#macro>
-- Summe nur bei bestimmtem Status anzeigen
<#if def.status==1||def.status==3||def.status==5||def.status==7>
update tmp_erg set
<#list 1..4 as quartal>
  q${quartal}=(select sum(q${quartal}betrag) from tmp_konto where <@sachkontenauswahl def=def/> ),
  vorjahr_q${quartal}=(select sum(vorjahr_q${quartal}betrag) from tmp_konto where <@sachkontenauswahl def=def/> ),
</#list>
vorjahr=(select sum(vorjahr) from tmp_konto where <@sachkontenauswahl def=def/> )
   where  jahr=${bezugsquartal.jahr} and defid=${def.id};
</#if>
</#if>
   
   
 
</#foreach>


--Summe dessen was OBERHALB stehen soll - Sortierung ndern und Summe berechnen
<#assign sortnr=0>
<#foreach def in definitionen>
<#if def.fibu_auswertung_art_id==auswertungsid>
<#assign sortnr=sortnr+1000>
<#if def.status==4||def.status==5||def.status==6||def.status==7>

--Summe
delete from tmp_sum;
insert into tmp_sum (
<#list 1..4 as quartal>
q${quartal},
vorjahr_q${quartal},
</#list>
vorjahr)
select 
<#list 1..4 as quartal>
sum(q${quartal}betrag),
sum(vorjahr_q${quartal}betrag),
</#list>
sum(vorjahr) from tmp_konto where  <@sachkontenauswahl def=def/>   ;
update tmp_erg set 
<#list 1..4 as quartal>
q${quartal}=(select q${quartal} from tmp_sum),
vorjahr_q${quartal}=(select vorjahr_q${quartal} from tmp_sum),
</#list>
vorjahr=(select vorjahr from tmp_sum)
where  jahr=${bezugsquartal.jahr}  and defid=${def.id};


--Sortierung
delete from tmp_max;
insert into tmp_max select max(sortnr) from tmp_erg 
where  jahr=${bezugsquartal.jahr}  
and defid in  ${Auswertungsdefinition("getSubkeys","${auswertungsid}-${def.id}")?replace("${auswertungsid}-","")} 
;
update tmp_erg set sortnr=(select maxsortnr+101-${def.hierarchie_ebene} from tmp_max) 
where  jahr=${bezugsquartal.jahr}  and defid=${def.id}
; 

  
</#if>
</#if>
</#foreach>


</#foreach> -- Ende bezugsquartale
 
</#if>
drop table tmp_max;  
drop table tmp_sum;
drop table tmp_konto;


delete from tmp_erg where name='Unterstrich';

update tmp_erg set hs_nr=(select hs_nr from hochschulinfo);

update tmp_erg set hierarchie_ebene=5 where name in ('= Summe der (ordentlichen) Ertrge','Summe der ordentlichen Aufwendungen','= Summe der betrieblichen Aufwendungen');


--- update der Zieltabelle falls schon vorhanden
update kenn_fibu_quartal
set 
kontengruppe=(select kontengruppe from tmp_erg where tmp_erg.hs_nr||'-'||jahr||'-'||defid=kenn_fibu_quartal.id
and tmp_erg.bezugsquartal=kenn_fibu_quartal.quartal),
zeile=(select zeile from tmp_erg where tmp_erg.hs_nr||'-'||jahr||'-'||defid=kenn_fibu_quartal.id
and tmp_erg.bezugsquartal=kenn_fibu_quartal.quartal),
name=(select name from tmp_erg where tmp_erg.hs_nr||'-'||jahr||'-'||defid=kenn_fibu_quartal.id
and tmp_erg.bezugsquartal=kenn_fibu_quartal.quartal),
<#list 1..4 as quartal>
q${quartal}=(select q${quartal} from tmp_erg where tmp_erg.hs_nr||'-'||jahr||'-'||defid=kenn_fibu_quartal.id
and tmp_erg.bezugsquartal=kenn_fibu_quartal.quartal),
vorjahr_q${quartal}=(select vorjahr_q${quartal} from tmp_erg where tmp_erg.hs_nr||'-'||jahr||'-'||defid=kenn_fibu_quartal.id
and tmp_erg.bezugsquartal=kenn_fibu_quartal.quartal),
</#list>
steuerungvorjahr=(select vorjahr from tmp_erg where tmp_erg.hs_nr||'-'||jahr||'-'||defid=kenn_fibu_quartal.id
and tmp_erg.bezugsquartal=kenn_fibu_quartal.quartal)
--ak Bedingung falls Jahr nicht in fibu. Ansonsten werden alle selbst erzeugten mit null berschrieben.
where jahr in (select distinct jahr from tmp_erg)
and quartal in ( select distinct bezugsquartal from tmp_erg)
;
--ggfs. in Kontendefinition gelschte eintrge entfernen
<#if bezugsquartale_kenn_stichtag?exists && bezugsquartale_kenn_stichtag?has_content >
<#foreach bezugsquartal in bezugsquartale_kenn_stichtag>
delete from kenn_fibu_quartal 
where jahr=${bezugsquartal.jahr}
and quartal=${bezugsquartal.quartal}
and id not in
(select hs_nr||'-'||${bezugsquartal.jahr}||'-'||defid from tmp_erg where jahr=${bezugsquartal.jahr});


--Ermittlung Zeilennr:
create temp table tmp_zeilennr (zeilennr serial,
defid integer,
sortnr integer
) <@informixnolog/>;

insert into tmp_zeilennr (defid,sortnr)
select distinct defid,sortnr
from tmp_erg where jahr=${bezugsquartal.jahr}
order by sortnr 
;
update tmp_erg set zeilennr=(select zeilennr
from tmp_zeilennr T
where T.defid=tmp_erg.defid)
where jahr=${bezugsquartal.jahr}
;

drop table tmp_zeilennr;

</#foreach>
</#if>



--manuelle Daten ab Zeile 70 (Investionsplan) vor dem Lschen retten:
update tmp_erg set 
       q1=T.q1,
       q2=T.q2,
       q3=T.q3,
       q4=T.q4,
vorjahr=T.steuerungvorjahr
       from kenn_fibu_quartal T
       where T.hs_nr=tmp_erg.hs_nr
       and T.jahr =tmp_erg.jahr
       and T.zeilennr=tmp_erg.zeilennr
and T.quartal=tmp_erg.bezugsquartal 
       and tmp_erg.zeilennr>70; 


--bereits vorhandene Datenstze aus  Tabelle lschen
delete from  kenn_fibu_quartal 
where quartal in (select S.bezugszeit
from kenn_stichtag S
where S.bezugsart='Q'
and S.berechnen='1'
and S.stichtagsart_id='GuVQ' 
)
or jahr in (select S.bezugszeit 
from kenn_stichtag S 
where S.bezugsart='J'
and S.berechnen='1'
and S.stichtagsart_id='GuVQ' 
)
;


-- Neu 1/2015
--Hierarchie-Ebene wird in Script trans_kenn_fibu_quartal_kg.sql gem Wunsch von SMWK gesetzt!

--nur neue Datenstze einfgen
insert into kenn_fibu_quartal ( hs_nr,id,
       jahr,
       quartal,
       name,
       hierarchie_ebene,
<#list 1..4 as quartal>
       q${quartal},
       vorjahr_q${quartal},
</#list>
       steuerungvorjahr,
       sortnr,
       sortnr2,
       datum,
       zeilennr)
SELECT hs_nr,
hs_nr||'-'||jahr||'-'||defid,
       jahr,
       bezugsquartal,
       name,
       hierarchie_ebene,
<#list 1..4 as quartal>
       q${quartal},
       vorjahr_q${quartal},
</#list>
       vorjahr,
       sortnr,
       defid,
       today(),
        zeilennr
FROM tmp_erg;
drop table tmp_erg;



