--Freemarker Template
--guv und Bilanz -> stichtagsart='GuV' 'Bilanz', art= 'G' bzw 'B', ZIeltabellevariable
-- Unterstrich auskommentiert

<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>
<#assign zieltabelle='kenn_fibu_bilanz'/>
<sqlvars>
<sqlvar name="fin_fibu_auswertung_art_exists">
select sp_table_exists('fin_fibu_auswertung_art') from xdummy
</sqlvar> 
<sqlvar name="fin_fibu_auswertung_definition_exists">
select sp_table_exists('fin_fibu_auswertung_definition') from xdummy
</sqlvar> 
<sqlvar name="jahre_kenn_stichtag" type='hashsequence'>
select K.bezugszeit as id from kenn_stichtag K
where  K.berechnen='1'
and K.stichtagsart_id='Bilanz'              --hier auf GuV/Bilanz 
and K.bezugsart='J';
</sqlvar>
<sqlvar name='auswertungids' type="hashsequence" ><![CDATA[
<#if fin_fibu_auswertung_art_exists==1 >
--fuer jedes Jahr die id mit der hchsten Gltigkeit auslesen
create temp table tmp_last_art (id integer,bezeichnung varchar(255),gueltig_ab integer,zieljahr integer);
create temp table tmp_max_gueltig_ab (gueltig_ab integer);
<#if jahre_kenn_stichtag?exists && jahre_kenn_stichtag?has_content >
<#foreach jahr in jahre_kenn_stichtag>
insert into tmp_last_art 
select id, bezeichnung,gueltig_ab,${jahr.id} from fin_fibu_auswertung_art where

art = 'B'                              --hier auf G/B 

and gueltig_ab <=${jahr.id} and aktiv='J' ;
delete from tmp_max_gueltig_ab;
insert into tmp_max_gueltig_ab 
select max(gueltig_ab) from tmp_last_art where zieljahr=${jahr.id};
delete from tmp_last_art where gueltig_ab not in (select gueltig_ab from tmp_max_gueltig_ab) and zieljahr=${jahr.id};
</#foreach>
</#if>

select zieljahr,id from tmp_last_art;
drop table tmp_last_art;drop table tmp_max_gueltig_ab;
</#if>
]]></sqlvar>

<sqlvar name='definitionen' type='hashsequence'><![CDATA[
<#if fin_fibu_auswertung_definition_exists==1>
select fibu_auswertung_art_id,id,drucktext,hierarchie_ebene,status from fin_fibu_auswertung_definition where
      hierarchie_ebene>0 
  order by fibu_auswertung_art_id,id
</#if>
  ]]></sqlvar>
<sqlvar name="Auswertungsdefinition" type="sicht" name_intern="fibu_auswertung_def" ></sqlvar>


</sqlvars>
<#macro doubletype>
<#if SQLdialect='Postgres'>double precision<#else>float</#if>
</#macro>
create temp table tmp_erg (hs_nr integer,defid integer,jahr smallint,  name varchar(255),hierarchie_ebene smallint,betrag <@doubletype/>,betragvorjahr <@doubletype/>,
unterstrich smallint default 0,sortnr integer) <@informixnolog/>;

create temp table tmp_max (maxsortnr integer) <@informixnolog/>;
create temp table tmp_sum (summe <@doubletype/> default 0,summevorjahr <@doubletype/> default 0) <@informixnolog/>;
create temp table tmp_unterstrich (defid integer, nextsortnr integer) <@informixnolog/>;

--Einzelbetrge kontret auf ein Sachkonto gebucht
create temp table tmp_konto (jahr smallint,sachkonto varchar(12),kategorie char(1),--bei Kategorie K betrag * -1
 klasse char(8),betrag <@doubletype/>) <@informixnolog/>;


<#if jahre_kenn_stichtag?exists && jahre_kenn_stichtag?has_content >
<#foreach jahr in jahre_kenn_stichtag>
delete from tmp_konto;

-- fibu_auswertung_konten_zuordnung.status ist bit-codiert:
-- Bit0: Konto und -saldo anzeigen (0=Nein, 1=Ja)
-- Bit1: Saldo in bergeordneten Hierarchiestufen fr Summen verwenden (0=Nein, 1=Ja)
--00==0 = nix - technisch mglich, jedoch unsinnig (d.h. das Konto wird komplett ignoriert).
--01   =1 =  nicht anzeigen, saldo verwenden
-- 10  = 2 = anzeigen, saldo nicht verwenden
-- 11 = 3 = anzeigen, saldo verwenden



 
 insert into tmp_konto (jahr,sachkonto,betrag)
select ${jahr.id},sachkonto,sum(saldo)  from fin_fibu_kontenstand where haushaltsjahr::integer=${jahr.id} and sachkonto in
    (select sachkonto from fin_fibu_auswertung_konten_zuordnung where status not in (0,2) )
    and (bkreis=0 or bkreis in (select k_bga_id from fin_bga where bilanz='1') )
     group by 1,2;
  --frs Vorjahr
 insert into tmp_konto (jahr,sachkonto,betrag)
select ${jahr.id}-1,sachkonto,sum(saldo)  from fin_fibu_kontenstand where haushaltsjahr::integer=${jahr.id}-1 and sachkonto in
    (select sachkonto from fin_fibu_auswertung_konten_zuordnung where status not in (0,2) )
   and (bkreis=0 or bkreis in (select k_bga_id from fin_bga where bilanz='1') )
     group by 1,2;
  
   
   
   -- bei Kontokategorie K betrag mal -1
update tmp_konto set kategorie=(select kategorie from fin_fibu_kont where   
  haushaltsjahr::integer<=${jahr.id} and (hhjende is null or hhjende::integer >= ${jahr.id})
   and tmp_konto.sachkonto=fin_fibu_kont.sachkonto
  );
   update tmp_konto set betrag=betrag*-1 where kategorie='K';
   
   -- VINT/FINT rausfiltern
   update tmp_konto set klasse=
 (select distinct klasse from fin_fibu_kont where tmp_konto.sachkonto=fin_fibu_kont.sachkonto and
    haushaltsjahr::integer<= ${jahr.id} and ( hhjende is null or hhjende::integer>= ${jahr.id} ) );
update tmp_konto set betrag=0 where klasse in ('VINT','FINT');
   
   
   
   -- TMP_ERG wird gefllt
    ---richtige Auswertungsid fr das Jahr raussuchen
    <#assign auswertungsid=-1/>
   <#foreach a in auswertungids>
   <#if a.zieljahr==jahr.id?number><#assign auswertungsid=a.id/></#if>
   </#foreach>
   
   --alle Definitionen durchgehen, nur die fr das Auswertungsjahr bestimmten nutzen
  <#assign sortnr=0>
<#foreach def in definitionen>
<#if def.fibu_auswertung_art_id==auswertungsid&&def.drucktext!='Unterstrich'>
<#assign sortnr=sortnr+1000>

    --Fr Aktiva und Passiva zustzliche berschriften
 --#if jahr.id?number&lt;2015>
--#if def.drucktext='Summe Aktiva'>
--insert into tmp_erg (defid,jahr,name,hierarchie_ebene,sortnr) 
  -- values (-1,${jahr.id},'Aktiva',1,${sortnr});
  --assign sortnr=sortnr+1000>
--/#if>
--#if def.drucktext='Summe Passiva'>
--insert into tmp_erg (defid,jahr,name,hierarchie_ebene,sortnr)
  --values (-2,${jahr.id},'Passiva',1,${sortnr});
  --#assign sortnr=sortnr+1000>
--/#if>
---/#if>
insert into tmp_erg (defid,jahr,name,hierarchie_ebene,sortnr)
values (${def.id},${jahr.id},
'${def.drucktext?replace("EUR"," EUR")?replace("\x20AC"," EUR")?replace("\x0080"," EUR")}',
 ${def.hierarchie_ebene},${sortnr});

-- fibu_auswertung_definition.status ist bit-codiert:
-- Bit0: Summe dessen was oberhalb ist anzeigen (0=Nein, 1=Ja)
-- Bit1: Summe in bergeordneten Hierarchiestufen verwenden (0=Nein, 1=Ja)
-- Bit2: Summe dessen was unterhalb ist anzeigen (0=Nein, 1=Ja) --also in der gleichen Zeile

-- 000 = 0 = oberhalb nein, verwenden nein, unterhalb nein
-- 001 = 1 = oberhalb nein, verwenden nein, unterhalb ja
-- 010 = 2 = oberhalb nein,verwenden ja, unterhalb nein
-- 011 = 3 = oberhalb nein, verwenden ja, unterhalb ja
-- 100 = 4 = oberhalb ja, verwenden nein, unterhalb nein
-- 101 = 5 = oberhalb ja, verwenden nein, unterhalb ja  -> nicht erlaubt
-- 110 = 6 = oberhalb ja, verwenden ja, unterhalb nein
-- 111 = 7 = oberhalb ja, verwenden ja, unterhalb ja
  -- nur bei bestimmten Status Summe berechnen
<#if def.status==1||def.status==3||def.status==5||def.status==7>
<#macro sachkontenauswahl def>
  sachkonto in 
 (select sachkonto from fin_fibu_auswertung_konten_zuordnung where status not in (0,2) and fibu_auswertung_definition_id in ${Auswertungsdefinition("getSubkeys","${auswertungsid}-${def.id}")?replace("${auswertungsid}-","")}
 )
</#macro>

update tmp_erg set betrag=(select sum(betrag) from tmp_konto where jahr=${jahr.id} and <@sachkontenauswahl def=def/>  )
   where  jahr=${jahr.id} and defid=${def.id};
   --frs Vorjahr
   update tmp_erg set betragvorjahr=(select sum(betrag) from tmp_konto where jahr=${jahr.id}-1  and <@sachkontenauswahl def=def/> )
   where  jahr=${jahr.id} and defid=${def.id};
   </#if>

 
 </#if>
</#foreach>
   
  
--@selectintotmp source="tmp_erg" target="tmp_anz" select="count(*) as anzahl"> where jahr=${jahr.id} /@selectintotmp>;
--select 'Bilanz ${jahr.id} Fehler: Erwartete Zeilenanzahl 72 gefunden: '||anzahl||' - fibu Konfiguration prfen' from tmp_anz where anzahl!=72;-- and ${jahr.id}>=2015;
--drop table tmp_anz;

--Summe dessen was OBERHALB stehen soll - Sortierung ndern und Summe berechnen

<#assign sortnr=0>
<#foreach def in definitionen>
<#if def.fibu_auswertung_art_id==auswertungsid>
<#assign sortnr=sortnr+1000>
<#if def.status==4||def.status==5||def.status==6||def.status==7>

--Summe

delete from tmp_sum;
insert into tmp_sum (summe) select sum(betrag) from tmp_konto where jahr=${jahr.id} and <@sachkontenauswahl def=def/>;
insert into tmp_sum (summevorjahr) select sum(betrag) from tmp_konto where jahr=${jahr.id}-1 and <@sachkontenauswahl def=def/>;
 
  -- and status not in (0,1,4,5)
  ;
update tmp_erg set betrag=(select sum(summe) from tmp_sum) where jahr=${jahr.id}  and defid=${def.id};
update tmp_erg set betragvorjahr=(select sum(summevorjahr) from tmp_sum) where jahr=${jahr.id}  and defid=${def.id};
--Sortierung
delete from tmp_max;
insert into tmp_max select max(sortnr) from tmp_erg where jahr=${jahr.id} 
  and defid in  ${Auswertungsdefinition("getSubkeys","${auswertungsid}-${def.id}")?replace("${auswertungsid}-","")} ;
update tmp_erg set sortnr=(select maxsortnr+101-${def.hierarchie_ebene} from tmp_max) where  jahr=${jahr.id}  and defid=${def.id}; 

  
</#if>
</#if>
</#foreach>

-- wenn ein  Eintrag unterstrich vorhanden ist, soll der folgende Eintrag oberhalb und unterhalb einen Strich haben

--insert into tmp_unterstrich (defid,nextsortnr) select defid,sortnr from tmp_erg where jahr=${jahr.id} and  name='Unterstrich';
--update tmp_unterstrich set nextsortnr=(select min(sortnr) from tmp_erg where jahr=${jahr.id}  and sortnr>tmp_unterstrich.nextsortnr);
--update tmp_erg set unterstrich=1 where jahr=${jahr.id}  and issachkonto=0 and sortnr in (select nextsortnr from tmp_unterstrich);


  
  </#foreach> -- Ende Jahr
 
</#if>


drop table tmp_unterstrich;

delete from tmp_erg where name='Unterstrich';

--update tmp_erg set unterstrich=1 where issachkonto=0 and name like '%Jahresberschuss%';

   
   drop table tmp_max;  
drop table tmp_sum;
drop table tmp_konto;


update tmp_erg set hs_nr=(select hs_nr from hochschulinfo);



--- Einfgen in ZIeltabelle
delete from ${zieltabelle} where jahr in (select jahr from tmp_erg);
insert into ${zieltabelle} ( hs_nr,
       jahr,
       name,
       hierarchie_ebene,
       betrag,
       betragvorjahr,
       unterstrich,
       sortnr,
       sortnr2, -- defid als sortnr2 bergeben
       datum)
SELECT hs_nr,
       jahr,
       name,
       hierarchie_ebene,
       betrag,
       betragvorjahr,
       unterstrich,
       sortnr,
       defid,
       today()
FROM tmp_erg;
drop table tmp_erg;
