--freemarker template
<sqlvars>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
</sqlvars>

--nur Sachsen:

<#if cob_installed=1 && K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>

  
  create temp table tmp_dlk
  (
    hs_nr integer,
    lehreinheit char(10),
    k_extkotr char(10),
    sem integer,
    ln_eigen float,
    ln_fremd float,
    lna float, --lehrnachfrage smtlicher Stg. an die betrachtete LE
    lnd float, --lehrnachfrage der eigenen Stg. an alle LE
dlk float  ) ;

insert into tmp_dlk(hs_nr ,
    lehreinheit ,
    k_extkotr ,
    sem)
    select distinct hs_nr,lehreinheit,k_extkotr,sem
    from kenn_auslastung 
    where bezugstyp='E'
    and sem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDG')
    ;
--Formeln siehe NHS RHB D.4.1.2  

update tmp_dlk set lnd=(select sum(K.cnw*K.ffidrgf2)
from kenn_auslastung K
where K.sem=tmp_dlk.sem
and K.lehreinheit=tmp_dlk.lehreinheit
and K.bezugstyp='E');

update tmp_dlk set ln_eigen=(select sum(K.ca*K.ffidrgf2)
from kenn_auslastung K
where K.sem=tmp_dlk.sem
and K.lehreinheit=tmp_dlk.lehreinheit
and K.bezugstyp='E');
update tmp_dlk set ln_fremd=(select sum(K.ca*K.ffidrgf2)
from kenn_auslastung K
where K.sem=tmp_dlk.sem
and K.lehreinheit=tmp_dlk.lehreinheit
and K.bezugstyp='F');

update tmp_dlk set lna=ln_eigen+ln_fremd;
update tmp_dlk set dlk=lna/lnd;

delete from kenn_dlk where sem in 
 (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDG');

insert into kenn_dlk(hs_nr ,
    lehreinheit ,
    k_extkotr ,
    sem,
    datum,
    ln_eigen ,
    ln_fremd ,
    lna , 
    lnd , 
dlk
)
select hs_nr ,
    lehreinheit ,
    k_extkotr ,
    sem,
    today(),
    ln_eigen ,
    ln_fremd ,
    lna , 
    lnd , 
dlk
from tmp_dlk 
;

drop table tmp_dlk;

</#if>
