
--Freemarker Template

<sqlvars>
    <sqlvar name="KENN_KOSTEN_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_KOSTEN_DATENQUELLE'
    </sqlvar>
    <sqlvar name="KENN_KOSTEN_ARCHIV">
        select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV'
    </sqlvar>
    <sqlvar name="cob_installed">
        select count(*) from db_version where his_system ='cob';
    </sqlvar>

</sqlvars>

-- KENN_KOSTEN_DATENQUELLE=170 Datenbernahme aus GXSTAGE
<#if cob_installed=1 || KENN_KOSTEN_DATENQUELLE=170>


    <#if KENN_KOSTEN_ARCHIV?has_content >
        <#if KENN_KOSTEN_ARCHIV =0>
            <#if SQLdialect='Postgres'>
                truncate table kenn_busa_aggr;
            <#else>
                delete from kenn_busa_aggr;

            </#if>
        </#if>
    </#if>


    create temp table tmp_quartal
    (
    tid integer,
    bezugszeit integer,
    jahr smallint,
    quartal integer
    );

    --zuerst alle Quartale zusammenstellen:

    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '1'),
    bezugszeit,
    1
    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='J';
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '2'),
    bezugszeit,
    2

    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='J';
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '3'),
    bezugszeit,
    3

    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='J';
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    val(bezugszeit || '4'),
    bezugszeit,
    4
    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='J';

    --nun die einzelnen Quartale, werden ggf. danach mit distinct rausgeworfen
    insert into tmp_quartal(
    tid,
    bezugszeit,
    jahr,
    quartal
    )
    select tid,
    bezugszeit ,
    val(substring('' || bezugszeit from 1 for 4)),
    val(substring('' || bezugszeit from 5 for 1))

    from kenn_stichtag
    where stichtagsart_id='KOTN'
    and berechnen='1'
    and bezugsart='Q';

    --

    create temp table tmp_quartal2
    (

    bezugszeit integer,
    jahr smallint,
    quartal integer,
    bvkr_sicht_id integer,
    inst_sicht_id integer,
    monat_von smallint,
    monat_bis smallint

    );

    insert into tmp_quartal2
    (bezugszeit,
    jahr,
    quartal)
    select distinct bezugszeit,
    jahr,
    quartal
    from tmp_quartal;

    update tmp_quartal2 set monat_von=quartal*3-2;
    update tmp_quartal2 set monat_bis=quartal*3;
    update tmp_quartal2 set monat_bis=13 where monat_bis=12; --Korrekturmonat soll rein



    <#if cob_installed=1&&KENN_KOSTEN_DATENQUELLE!=170>
        create temp table tmp_ausg(gruppe char(12),key char(12),ueberg char(12));
        create temp table tmp_hier(gruppe char(12),key char(120),ueberg char(12));
        create temp table tmp_kenn_busa_aggr (
        hs_nr INTEGER ,
        jahr SMALLINT ,
        quartal integer,
        monat SMALLINT ,
        fikrkey CHAR(12) ,
        kokl_faktor SMALLINT ,
        klr_geldgeber CHAR(10),
        ggnr char(10) ,
        ch110_institut CHAR(10) ,
        projnr_tmp CHAR(10) ,
        projnr char(10),
        bvkr_art char(12),
        inst_art char(20),
        datum date ,
        betrag double precision
        );

        --in diesen beiden Tabellen stehen spaeter sich Schluessel fuer das jew. Quartal
        create temp table tmp_fikr(fikrkey char(12),bezugszeit integer);
        create temp table tmp_inst(ch110_institut char(10),bezugszeit integer);



        --nun die zugehrigen Sichten zuordnen:
        --Die Regel geht vom allgemeinen zum Besonderen, d.h. erst die Sicht fr "alle"

        --zuerst BVKR
        --Sichten mit stichtag_id=0 gelten fr alle Stichtage
        update tmp_quartal2 set bvkr_sicht_id=(select min(S.tid)
        from sichten S, kenn_sichten K
        where K.sicht_name_intern=S.name_intern
        and K.dimension='BVKR'
        and K.stichtag_id=0)
        ;

        --Sicht frs ganze Jahr:
        update tmp_quartal2 set bvkr_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr);

        --Sicht frs Quartal:
        update tmp_quartal2 set bvkr_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='BVKR'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit);

        --nun INST
        --Sichten mit stichtag_id=0 gelten fr alle Stichtage
        update tmp_quartal2 set inst_sicht_id=(select min(S.tid) from sichten S, kenn_sichten K
        where K.sicht_name_intern=S.name_intern
        and K.dimension='MWK_INST'
        and K.stichtag_id=0);

        --Sicht frs ganze Jahr:
        update tmp_quartal2 set inst_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='MWK_INST'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='MWK_INST'
        and I.bezugsart='J'
        and I.bezugszeit=tmp_quartal2.jahr);

        --Sicht frs Quartal:
        update tmp_quartal2 set inst_sicht_id=(
        select min(S.tid) from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='MWK_INST'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit)
        where 0 < (select count(*)
        from sichten S, kenn_sichten K , kenn_stichtag I
        where K.sicht_name_intern=S.name_intern
        and I.tid=K.stichtag_id
        and K.dimension='MWK_INST'
        and I.bezugsart='Q'
        and I.bezugszeit=tmp_quartal2.bezugszeit);




        --Ab ins Pruefprotokoll:
        insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
        select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung gilt folgende BVKR-Kostenartensicht:' || S.name)::char(200), 'Info'::char(10)
        from tmp_quartal2 Q, sichten S
        where S.tid=Q.bvkr_sicht_id
        ;
        insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
        select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung ist keine BVKR-Kostenartensicht definiert')::char(200), 'Warnung'::char(10)
        from tmp_quartal2 Q
        where Q.bvkr_sicht_id is null
        ;

        insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
        select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung gilt folgende externe Kostenstellensicht:' || trim(S.name))::char(200), 'Info'::char(10)
        from tmp_quartal2 Q, sichten S
        where S.tid=Q.inst_sicht_id
        ;
        insert into kenn_pruefrout (datum,tabelle_kenn,problem,aktion)
        select distinct today(),'kenn_sichten'::char(18),('Fr Quartal ' || Q.bezugszeit || ' im Bereich Kostenrechnung ist keine externe Kostenstellensicht definiert')::char(200), 'Warnung'::char(10)
        from tmp_quartal2 Q
        where Q.inst_sicht_id is null
        ;




        --Aus Performance-Grnden werden alle KoA udn KoST, die in Betracht kommen,
        --vorselektiert.

        --Wenn alt. Hier. als INST-Sicht definiert ist:

        insert into tmp_inst
        select distinct A.key,Q.bezugszeit from
        cob_inst C,cob_alt_keys A, sichten S, tmp_quartal2 Q
        where C.key_apnr=A.key
        and Q.inst_sicht_id=S.tid
        and S.alt_hier_id=A.hierarchie_id::char(150)
        and date_val('01.' || Q.monat_von || '.' || Q.jahr) between C.gueltig_seit and C.gueltig_bis
        and S.type=20
        ;
        --Wenn regulre Sicht als INST-Sicht def.:
        insert into tmp_inst
        select distinct C.key_apnr,Q.bezugszeit from
        cob_inst C, sichten S, tmp_quartal2 Q
        where Q.inst_sicht_id=S.tid
        and date_val('01.' || Q.monat_von || '.' || Q.jahr) between C.gueltig_seit and C.gueltig_bis
        and S.type=10
        ;
        --Wenn alt. Hier. als BVKR-Sicht definiert ist:
        insert into tmp_fikr
        select distinct A.key,Q.bezugszeit from
        cob_fikr F,cob_alt_keys A, sichten S, tmp_quartal2 Q
        where F.key = A.key
        and Q.bvkr_sicht_id=S.tid
        and S.alt_hier_id=A.hierarchie_id::char(150)
        and date_val('01.' || Q.monat_von || '.' || Q.jahr) between F.key_von and F.key_bis
        and S.type=20
        ;
        --Wenn regulre Sicht als KoA-Sicht def.:
        insert into tmp_fikr
        select distinct F.key,Q.bezugszeit from
        cob_fikr F, sichten S, tmp_quartal2 Q
        where Q.bvkr_sicht_id=S.tid
        and date_val('01.' || Q.monat_von || '.' || Q.jahr) between F.key_von and F.key_bis
        and S.type=10
        ;

        create index tmp_ix_fikr1 on tmp_fikr(fikrkey);
        create index tmp_ix_fikr2 on tmp_fikr(bezugszeit);


        insert into tmp_kenn_busa_aggr (
        jahr,
        quartal,
        monat,
        fikrkey,
        kokl_faktor,
        ggnr,
        ch110_institut,
        projnr_tmp,
        datum,
        betrag
        )
        -- select A.jahr,Q.bezugszeit,A.monat,A.fikrkey,kokl_faktor,ggnr,A.ch110_institut,projnr,today(),sum(betrag)
        -- from cob_busa_aggr A, kenn_fikr F,tmp_quartal2 Q
        -- where Q.jahr=A.jahr
        -- and A.monat between Q.monat_von and Q.monat_bis
        -- and F.key=A.fikrkey
        -- and date_val('01.' || A.monat || '.' || A.jahr ) between F.key_von and F.key_bis
        -- and A.fikrkey in (select distinct T.fikrkey from tmp_fikr T where T.bezugszeit=Q.bezugszeit)
        -- and A.ch110_institut in (select distinct I.ch110_institut from  tmp_inst I where I.bezugszeit=Q.bezugszeit)
        -- group by 1,2,3,4,5,6,7,8;
        select A.jahr,Q.bezugszeit,A.monat,A.fikrkey,kokl_faktor,ggnr,A.ch110_institut,projnr,today(),sum(betrag)
        from cob_busa_aggr A, kenn_fikr F,tmp_quartal2 Q,tmp_fikr T --, tmp_inst I
        where Q.jahr=A.jahr
        and A.monat between Q.monat_von and Q.monat_bis
        and F.key=A.fikrkey
        and date_val('01.' || trim(replace(A.monat::char(2), '13', '12')) || '.' || A.jahr ) between F.key_von and F.key_bis
        and A.fikrkey = T.fikrkey
        and T.bezugszeit=Q.bezugszeit
        --and A.ch110_institut=I.ch110_institut
        --and I.bezugszeit=Q.bezugszeit
        and F.hs_nr !=0
        group by 1,2,3,4,5,6,7,8;


        update tmp_kenn_busa_aggr set klr_geldgeber=(select klr_geldgeber from cob_geldgeber C where C.ggnr=tmp_kenn_busa_aggr.ggnr)
        where ggnr is not null;

        update tmp_kenn_busa_aggr set hs_nr=(select hs_nr from hochschulinfo);


        --Der externe Produktschlssel wird in erster Prioritt ber den externen Kotr. zugewiesen
        update tmp_kenn_busa_aggr set projnr=(select k_extkotr from cob_proj P where P.projnr=tmp_kenn_busa_aggr.projnr_tmp)
        where projnr_tmp is not null;
        --nur Sachsen:
        <#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5)>

            --Der LFB wird in zweiter Prioritt ber das Projekt zugewiesen
            -- update tmp_kenn_busa_aggr set projnr=(select min(E.key) from cob_proj I, kenn_extkotr E
            -- where I.projnr=tmp_kenn_busa_aggr.projnr_tmp
            -- and substring(E.key from 4 for 3)=I.fins --der LFB ist im externen Porduktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
            -- and E.kategorie='lf' --Ebene LFB
            -- and E.key like '1%' --nur Lehre
            -- )
            -- where projnr is null;
            -- ;
        </#if>

        insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.parent
        from cob_alt_keys C, tmp_quartal2 Q, sichten S
        where S.tid=Q.bvkr_sicht_id
        and S.type=20
        and C.hierarchie_id::char(150)=S.alt_hier_id
        ;
        insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.ueberg
        from kenn_fikr C, tmp_quartal2 Q, sichten S
        where S.tid=Q.bvkr_sicht_id
        and S.type=10
        ;

        create index tmp_ix_thier1 on tmp_hier(gruppe);
        create index tmp_ix_thier2 on tmp_hier(ueberg);

        <#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL=1 || K_KENN_PROFIL=2 ||K_KENN_PROFIL=3)>
            --nur BaWue

            --BVKR-Leafs
            insert into tmp_ausg select distinct Q.bezugszeit,C.apnr,C.apnr
            from tmp_quartal2 Q,kenn_cifx C where C.key=668 and ebene >2
            --der 906 ist der einzige Schlssel, der auch untergeordnete Schlssel hat
            --er bekommt spter eine Sonderbehandlung
            and C.apnr != '906';

            create index tmp_ausg1 on tmp_ausg(gruppe,key);

            select 'Anzahl Stze tmp_ausg: ' || count(*)
            from tmp_ausg;

            select 'Anzahl Stze tmp_hier: ' || count(*) || ' Start:' || now()
            from tmp_hier;

            <#if SQLdialect='Postgres'>
                select sp_get_children() ;
            <#else>

                execute procedure sp_get_children();

            </#if>

            --select * from tmp_ausg;
            --

            --Gibt es folgenden Fall: eine KoA, die als Leaf im BVKR fungiert,
            --ist in der alt.Hier. der Hochschule ein Element unterhalb eines anderen Leafs,
            --dann tritt der paradoxe Fall auf, da eine Buchung bei der BVKR-Art beide Leafs haben soll
            --was aber nicht geht.
            --Daher rausschmeien:
            create temp table tmp_doppelt(gruppe char(12),key char(12),ueberg char(12));
            insert into tmp_doppelt (gruppe,key)
            select gruppe,key from tmp_ausg group by 1,2 having count(*) > 1;

            insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
            select distinct today(),'cob_alt_keys'::char(18),'kenn_alt_keys'::char(18),
            ('Fr Quartal ' || trim(D.gruppe) || ' im Bereich Kostenrechnung ist die Kostenart ' || trim(D.key) || ' einer BVKR-KoA untergeordnet, obwohl sie selbst eine BVKR-KoA ist.')::char(250),
            'Info'::char(10)
            from tmp_doppelt D
            ;

            delete from tmp_ausg where gruppe || '_' || key in
            (select D.gruppe || '_' || D.key from tmp_doppelt D)
            and key != ueberg;

            drop table tmp_doppelt;


            update tmp_kenn_busa_aggr set bvkr_art=
            (select distinct ueberg from tmp_ausg A
            where A.key=tmp_kenn_busa_aggr.fikrkey
            and val(A.gruppe)=tmp_kenn_busa_aggr.quartal
            );

            update tmp_kenn_busa_aggr set bvkr_art='S'
            where bvkr_art is null
            and fikrkey in(
            select key from tmp_ausg A where val(A.gruppe)=tmp_kenn_busa_aggr.quartal
            );

            --nun der 906er
            delete from tmp_ausg;
            insert into tmp_ausg select distinct Q.bezugszeit,'906'::char(12),'906'::char(12)
            from tmp_quartal2 Q;

            <#if SQLdialect='Postgres'>
                select sp_get_children() ;
            <#else>

                execute procedure sp_get_children();

            </#if>

            --der 906 wird nur zugewiesen, wenn die Kinder 90689 etc.nicht schon zugewiesen sind.

            update tmp_kenn_busa_aggr set bvkr_art='906' where fikrkey in(
            select key from tmp_ausg A where A.ueberg='906'
            and val(A.gruppe)=tmp_kenn_busa_aggr.quartal
            )
            and (bvkr_art not like '906%' or bvkr_art is null)
            ;

            --BaWue Ext. Kostenstelle:
            update tmp_kenn_busa_aggr set inst_art=hs_nr || '_' ||
            (select min(I.key_ext) from kenn_inst_to_ext I
            where I.instnr=tmp_kenn_busa_aggr.ch110_institut
            and I.key_ext is not null
            and trim(I.key_ext) !='')
            --nur wenn die interne Kostenstelle in der alt.Hier drin ist:
            where ch110_institut in (
            select A.ch110_institut from tmp_inst A where A.bezugszeit=tmp_kenn_busa_aggr.quartal
            )
            ;
            update tmp_kenn_busa_aggr set inst_art='_S' where inst_art is null
            and ch110_institut in (
            select A.ch110_institut from tmp_inst A where A.bezugszeit=tmp_kenn_busa_aggr.quartal
            )
            ;

        </#if>
        --nur Sachsen:
        <#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==5)>
            --401	K_PK	Personalkosten
            --403	K_SK_11_Miet	Mietkosten
            --405	K_SK_12_BW	Bewirtschaftungskosten
            --407	K_SK_2_Afa	Abschreibungen
            --409	K_SK_3_WKo	sonstige Sachkosten

            --BVKR-Leafs
            insert into tmp_ausg select distinct Q.bezugszeit,
            'K_PK','K_PK'
            from tmp_quartal2 Q
            ;
            insert into tmp_ausg select distinct Q.bezugszeit,
            'K_SK_11_Miet','K_SK_11_Miet'
            from tmp_quartal2 Q
            ;
            insert into tmp_ausg select distinct Q.bezugszeit,
            'K_SK_12_BW','K_SK_12_BW'
            from tmp_quartal2 Q
            ;
            insert into tmp_ausg select distinct Q.bezugszeit,
            'K_SK_2_Afa','K_SK_2_Afa'
            from tmp_quartal2 Q
            ;
            insert into tmp_ausg select distinct Q.bezugszeit,
            'K_SK_3_WKo','K_SK_3_WKo'
            from tmp_quartal2 Q
            ;
            insert into tmp_ausg select distinct Q.bezugszeit,
            'E_HH_1','E_HH_1'
            from tmp_quartal2 Q
            ;
            insert into tmp_ausg select distinct Q.bezugszeit,
            'E_DM_21_PF','E_DM_21_PF'
            from tmp_quartal2 Q
            ;
            insert into tmp_ausg select distinct Q.bezugszeit,
            'E_DM_22_WT','E_DM_22_WT'
            from tmp_quartal2 Q
            ;
            insert into tmp_ausg select distinct Q.bezugszeit,
            'E_Sonst_3','E_Sonst_3'
            from tmp_quartal2 Q
            ;
            create index tmp_ausg1 on tmp_ausg(gruppe,key);

            select 'Anzahl Stze tmp_ausg: ' || count(*)
            from tmp_ausg;

            select 'Anzahl Stze tmp_hier: ' || count(*) || ' Start:' || now()
            from tmp_hier;

            <#if SQLdialect='Postgres'>
                select sp_get_children() ;
            <#else>

                execute procedure sp_get_children();

            </#if>

            --select * from tmp_ausg;
            --

            --Gibt es folgenden Fall: eine KoA, die als Leaf im BVKR fungiert,
            --ist in der alt.Hier. der Hochschule ein Element unterhalb eines anderen Leafs,
            --dann tritt der paradoxe Fall auf, da eine Buchung bei der BVKR-Art beide Leafs haben soll
            --was aber nicht geht.
            --Daher rausschmeien:
            create temp table tmp_doppelt(gruppe char(12),key char(12),ueberg char(12));
            insert into tmp_doppelt (gruppe,key)
            select gruppe,key from tmp_ausg group by 1,2 having count(*) > 1;

            insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
            select distinct today(),'cob_alt_keys'::char(18),'kenn_alt_keys'::char(18),
            ('Fr Quartal ' || trim(D.gruppe) || ' im Bereich Kostenrechnung ist die Kostenart ' || trim(D.key) || ' einer BVKR-KoA untergeordnet, obwohl sie selbst eine BVKR-KoA ist.')::char(250),
            'Info'::char(10)
            from tmp_doppelt D
            ;

            delete from tmp_ausg where gruppe || '_' || key in
            (select D.gruppe || '_' || D.key from tmp_doppelt D)
            and key != ueberg;

            drop table tmp_doppelt;


            update tmp_kenn_busa_aggr set bvkr_art=
            (select distinct ueberg from tmp_ausg A
            where A.key=tmp_kenn_busa_aggr.fikrkey
            and val(A.gruppe)=tmp_kenn_busa_aggr.quartal
            );

            update tmp_kenn_busa_aggr set bvkr_art='S'
            where bvkr_art is null
            and fikrkey in(
            select key from tmp_ausg A where val(A.gruppe)=tmp_kenn_busa_aggr.quartal
            );

            --Ext. Kostenstelle Sachsen:
            --ist auch der Produktschlssel
            update tmp_kenn_busa_aggr set inst_art=(select min(I.key_extkotr) from kenn_inst_to_ext I
            where I.instnr=tmp_kenn_busa_aggr.ch110_institut
            and I.key_extkotr is not null
            and trim(I.key_extkotr) !='')
            --nur wenn die interne Kostenstelle in der alt.Hier drin ist:
            where ch110_institut in (
            select A.ch110_institut from tmp_inst A where A.bezugszeit=tmp_kenn_busa_aggr.quartal
            )
            ;
            --Wenn ext. Kostenstelle noch nicht gepflegt wird, dann wird versucht dies aus sva_inst.fins (in Sachsen der LFB) zu nehmen:
            update tmp_kenn_busa_aggr set inst_art=(select min(E.key) from kenn_extkotr E, kenn_inst I
            where I.key_apnr=tmp_kenn_busa_aggr.ch110_institut
            and substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Porduktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
            and E.kategorie='lf' --Ebene LFB
            and E.key like '1%' --nur Lehre
            )
            --nur wenn die interne Kostenstelle in der alt.Hier drin ist:
            where inst_art is null
            and ch110_institut in (
            select A.ch110_institut from tmp_inst A where A.bezugszeit=tmp_kenn_busa_aggr.quartal
            )
            ;

            --wenn projnr leer ist, wird inst_art genommen
            --update tmp_kenn_busa_aggr set projnr=inst_art where inst_art is not null
            --and projnr is null;


            --Wenn es dann immer noch leer ist, kommt _S = "sonstige" rein

            update tmp_kenn_busa_aggr set inst_art='_S' where inst_art is null
            --nur wenn die interne Kostenstelle in der alt.Hier drin ist:
            and ch110_institut in (
            select A.ch110_institut from tmp_inst A where A.bezugszeit=tmp_kenn_busa_aggr.quartal
            )
            ;

        </#if> --Ende Sachsen



        delete from kenn_busa_aggr where jahr in (select K.bezugszeit from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='KOTN'
        and K.bezugsart='J'
        )
        ;
        delete from kenn_busa_aggr where quartal in (select K.bezugszeit from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='KOTN'
        and K.bezugsart='Q'
        )
        ;

        --nochmal ein join mit tmp_fikr und tmp_inst,
        --falls fr ein Quartal oder Jahr eine KoA oder KoSt nicht in der
        --jew. alt.Hier enthalten ist.


        insert into kenn_busa_aggr (
        hs_nr,
        jahr,
        quartal,
        monat,
        fikrkey,
        kokl_faktor,
        klr_geldgeber,
        ch110_institut,
        projnr,
        bvkr_art,
        inst_art,
        datum,
        betrag
        )
        select
        A.hs_nr,
        A.jahr,
        A.quartal,
        A.monat,
        A.fikrkey,
        A.kokl_faktor,
        A.klr_geldgeber,
        A.ch110_institut,
        A.projnr,
        A.bvkr_art,
        A.inst_art,
        A.datum,
        sum(A.betrag)
        from tmp_kenn_busa_aggr A,tmp_fikr TF, tmp_inst I
        where TF.fikrkey=A.fikrkey
        and TF.bezugszeit=A.quartal
        and I.ch110_institut=A.ch110_institut
        and I.bezugszeit=A.quartal
        group by 1,2,3,4,5,6,7,8,9,10,11,12; --,12;




        insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
        select distinct today(),'cob_geldgeber'::char(18),'Geldgeber ' || trim(ggnr) || ' im Bereich Kosten ist nicht dem Landesschlssel des Geldgebers (KLR) zugeordnet !'::char(200), 'Warnung'::char(10)
        from tmp_kenn_busa_aggr
        where klr_geldgeber is null
        and ggnr is not null;

        insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
        select distinct today(),'cob_proj'::char(18),'Projekt ' || trim(projnr_tmp) || ' im Bereich Kosten ist keinem externen Kostentrger zugeordnet !'::char(200), 'Warnung'::char(10)
        from tmp_kenn_busa_aggr
        where projnr is null
        and projnr_tmp is not null;

        insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
        select distinct today(),'cob_inst'::char(18),'Kostenstelle ' || trim(ch110_institut) || ' im Bereich Kosten ist keiner externen Kostenstelle zugeordnet !'::char(200), 'Warnung'::char(10)
        from tmp_kenn_busa_aggr
        where (inst_art is null or inst_art='_S')
        and ch110_institut is not null
        and ch110_institut in (
        select A.ch110_institut from tmp_inst A where A.bezugszeit=tmp_kenn_busa_aggr.quartal
        )
        and quartal in (select bezugszeit from tmp_quartal)
        ;

        drop table tmp_kenn_busa_aggr;
        drop TABLE tmp_fikr;
        drop TABLE tmp_inst;

        drop table tmp_ausg;
        drop table tmp_hier;
    </#if> -- ende Datenquelle COB

    <#if KENN_KOSTEN_DATENQUELLE=170>


        delete from kenn_busa_aggr where jahr in (select K.bezugszeit from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='KOTN'
        and K.bezugsart='J'
        )
        ;
        delete from kenn_busa_aggr where quartal::char(5) in (select K.bezugszeit::char(5) from kenn_stichtag K
        where K.berechnen='1'
        and K.stichtagsart_id='KOTN'
        and K.bezugsart='Q'
        )
        ;
      <@selectintotmp source="gxstage_busa_aggr G, tmp_quartal2 Q" target="tmp_busa" 
      select="G.hs_nr,G.jahr,G.quartal,G.monat,G.fikrkey,G.kokl_faktor,G.klr_geldgeber,G.ch110_institut,G.projnr,G.bvkr_art,G.inst_art,datum,G.betrag">
      where Q.jahr=G.jahr
        and G.monat between Q.monat_von and Q.monat_bis
      </@selectintotmp> <@informixnolog/>;
	
      -- BVKR Anpassen
      
<#if KENN_FIPOS_TO_BVKR?exists&&KENN_FIPOS_TO_BVKR?has_content>
<#assign inlinetemplate=KENN_FIPOS_TO_BVKR?interpret/>
<@inlinetemplate/>
<#if bvkr_zuordnung?exists>
<#foreach regel in bvkr_zuordnung>
update tmp_busa set bvkr_art='${regel.bvkr_art}' where ${regel.bedingung};
</#foreach>
</#if>
</#if>
--Ausgaben sind in SAP standardmig negativ, da in Kenn Saldo nach Formel kosten-erloese berechnet wird, Vorzeichen umdrehen.
--update tmp_busa set betrag=betrag*-1 where kokl_faktor=1;
--es werden doch ausgaben Positiv geliefert und erlse negativ daher
update tmp_busa set betrag=betrag*-1 where kokl_faktor=-1;
update tmp_busa set fikrkey=null; -- wegen mglicher Lnge von Finanzpositionen von mehr als 12 Zeichen gemacht

        insert into kenn_busa_aggr (
        hs_nr,
        jahr,
        quartal,
        monat,
	fikrkey,
        kokl_faktor,
        klr_geldgeber,
	ch110_institut,
        projnr,
        bvkr_art,
        inst_art,
        datum,
        betrag
        )
        select  hs_nr,
        jahr,
        quartal,
        monat,
	fikrkey,
        kokl_faktor,
        klr_geldgeber,
	ch110_institut,
        projnr,
        bvkr_art,
        inst_art,
        datum,
        betrag from tmp_busa;
	drop table tmp_busa;

    </#if> -- ende Datenquelle GXSTAGE

    drop table tmp_quartal;
    drop table tmp_quartal2;



</#if>
