--freemarker template
<sqlvars>
<sqlvar name="cob_installed">
select count(*) from db_version where his_system ='cob';
</sqlvar>
<sqlvar name="aktuelles_jahr">
select year(today()) from xdummy;
</sqlvar>
<sqlvar name="kenn_zahl_wert_exists">
select sp_table_exists('kenn_zahl_wert') from xdummy;
</sqlvar>

</sqlvars>



<#if cob_installed=1 >

select '${SQLdialect}' from xdummy;

create temp table tmp_auslastung
  (
    ebene smallint,
    ordnr serial,
    lehreinheit char(10),
    lehreinheit_str char(255),
    k_extkotr char(10),
    k_extkotr_str char(255),
    sem integer,
    stugkey char(20),
    stug_dbez varchar(254),
    stug_rstuz integer,
    stug_plaetze integer,
    stug_plaetze_summe integer,
    eigen smallint, -- char(1), --eigen, fremd
    ca float,
    studierende float,
    sws_lehrnf_eigen float,
    sws_lehrnf_fremd float,
    sws_lehrnf_ea float,
    sws_lehrang float,
    lvs_lehrnf float,
    lvs_lehrang float,
    auslastung float,
    dlk float
  ) ;
  
  create temp table tmp_auslastung2
  (
    ebene smallint,
    gesamt smallint,
    ordnr integer,
    lehreinheit char(10),
    lehreinheit_str char(255),
    lehreinheit_sort char(255),
    k_extkotr char(10),
    k_extkotr_str char(255),
    sem integer,
    stugkey char(20),
    stug_dbez varchar(254),
    stug_rstuz integer,
    stug_plaetze integer,
    stug_plaetze_summe integer,
    eigen smallint, -- char(1), --eigen, fremd
    ca float,
    studierende float,
    sws_lehrnf_eigen float,
    sws_lehrnf_fremd float,
    sws_lehrnf_ea float,
    sws_lehrang float,
    lvs_lehrnf float,
    lvs_lehrang float,
    auslastung float,
    dlk float
  ) ;
  
create temp table tmp_stug
  (
    
    lehreinheit char(10),
    k_extkotr char(10),
    stupl_id integer,
    sem integer,
    stugkey char(20),
    stug_dbez varchar(254),
    stug_rstuz integer,
    stug_plaetze integer

  ) ;  
<#if TableFieldExists?exists && TableFieldExists('cob_stupl','stupl_id')>  
insert into tmp_stug(
lehreinheit,
    k_extkotr ,
    stupl_id ,
    sem ,
    stugkey,
    stug_dbez ,
    stug_rstuz ,
    stug_plaetze)
select S.key_lehreinh,
S.k_extkotr,
P.stupl_id,
P.sem,
S.stug_key,
S.stug_dbez,
S.stug_rstuz,
sum(P.stug_plaetze)
from 
cob_stug S, cob_stupl P
where P.stug_key=S.stug_key
and P.sem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDG')
group by 1,2,3,4,5,6,7
;
</#if>
--zuerst Lehrnachfrage eigen:
insert into tmp_auslastung(
ebene,
lehreinheit,
k_extkotr,
sem,
stugkey,
stug_dbez,
stug_rstuz,
eigen,
ca,
stug_plaetze,
studierende)
select 
4::smallint,
S.lehreinheit,
S.k_extkotr,
S.sem,
S.stugkey,
S.stug_dbez,
S.stug_rstuz,
1::smallint,
L.lvm_ca,
S.stug_plaetze,
sum(K.ffidrgf2)
from  cob_lvm L, tmp_stug S
left outer join  cob_su_imp_stud K on (S.stugkey=K.stugkey and K.sem=S.sem)
where L.stupl_id=S.stupl_id
and L.lvm_lekey=S.lehreinheit
group by 1,2,3,4,5,6,7,8,9,10;
--fremd:  

insert into tmp_auslastung(
ebene,
lehreinheit,
--k_extkotr,
sem,
stugkey,
stug_dbez,
stug_rstuz,
eigen,
ca,
stug_plaetze,
studierende)
select 
4::smallint,
L.lvm_lekey,
--S.k_extkotr,
S.sem,
S.stugkey,
S.stug_dbez,
S.stug_rstuz,
0::smallint,
L.lvm_ca,
S.stug_plaetze,
sum(K.ffidrgf2)
from  cob_lvm L, tmp_stug S
left outer join  cob_su_imp_stud K on (S.stugkey=K.stugkey and K.sem=S.sem)
where L.stupl_id=S.stupl_id
and L.lvm_lekey!=S.lehreinheit
group by 1,2,3,4,5,6,7,8,9;

update tmp_auslastung set lehreinheit_str=(select drucktext from organigramm where key_apnr=tmp_auslastung.lehreinheit);
--update tmp_auslastung set k_extkotr_str=(select name from cob_extkotr where key=tmp_auslastung.k_extkotr);

update tmp_auslastung set sws_lehrnf_eigen=studierende* ca/stug_rstuz
where eigen=1
and stug_rstuz >0;
update tmp_auslastung set sws_lehrnf_fremd=studierende* ca/stug_rstuz
where eigen=0
and stug_rstuz >0;

update tmp_auslastung set sws_lehrnf_eigen=0 where sws_lehrnf_eigen is null;
update tmp_auslastung set sws_lehrnf_fremd=0 where sws_lehrnf_fremd is null;

--jetzt Lehrangebot:
<#if kenn_zahl_wert_exists==0 || K_KENN_LEHRANG_MAN=0>

--Berechnung aus cob_stupl:
  CREATE temp table tmp_sem_current
  (tid integer, 
  ord integer
  );
  CREATE temp table tmp_sem_all
  (tid integer, 
  ord integer
  );
--Matrix der mglichen Semester aufbauen, damit man spter Sem. nach RSZ filtern kann:
<#assign zaehler=40>
<#list 1..20 as jahr>
<#list 1..2 as ss_ws>
insert into tmp_sem_current(tid,ord) values (${aktuelles_jahr-jahr}${3-ss_ws},${zaehler});
insert into tmp_sem_all(tid,ord) values (${aktuelles_jahr-jahr}${3-ss_ws},${zaehler});
<#assign zaehler=zaehler-1>
</#list>
</#list>

--Jetzt Lehrangebot ermitteln:
--siehe https://wiki.his.de/mediawiki/index.php/COB:_Daten_der_Lehre#Angebotsorientierte_Lehrmenge
--Zuerst Zhler:
--Alle Semester der RSZ das Produkt von Stug. Pltzen und CA-Wert
<#if TableFieldExists?exists && TableFieldExists('cob_stupl','stupl_id')>
update tmp_auslastung set stug_plaetze_summe=(
select sum(S.stug_plaetze*L.lvm_ca)
from cob_stupl S, cob_lvm L, tmp_sem_current C, tmp_sem_all A 
where S.stug_key=tmp_auslastung.stugkey
and L.stupl_id=S.stupl_id
and L.lvm_lekey=tmp_auslastung.lehreinheit
and A.tid=S.sem
and tmp_auslastung.sem=C.tid
--Beispiel: 
--Studiengang X hat im SS 2012 eine RSZ von 7 Sem.
--die Matrix:
--  9	20122
--  8	20121 *(akt. Sem)
--  7	20112
--  6   20111
--  5   20102
--  4   20101
--  3   20092
--  2   20091
--  1   20082
--  ---------
-- 8 - 7=1
-- d.h. alle Semester von index 2-8 ( 20091 bis 20121) kommen rein:
and (C.ord -  tmp_auslastung.stug_rstuz) <  A.ord
and C.ord >= A.ord
)
where eigen=1
;
</#if>
update tmp_auslastung set sws_lehrang=stug_plaetze_summe / stug_rstuz
where stug_rstuz >0 ;
drop table tmp_sem_current;
drop table tmp_sem_all;
</#if>
--in Zieltabelle einfgen:
--Ab Ebene 3 nur zum Debuggen:
--zuerst unterste Ebene
insert into tmp_auslastung2( ebene,
gesamt,
ordnr,
sem,
lehreinheit,
    lehreinheit_str,
    lehreinheit_sort,
    stug_dbez ,
    stug_rstuz ,
    stug_plaetze ,
    eigen , --eigen, fremd
    ca ,
    studierende ,
    sws_lehrnf_eigen,
    sws_lehrnf_fremd,
    sws_lehrang)
    select ebene, 
    10::smallint,
    2010::smallint,
    sem,
lehreinheit,
    lehreinheit_str,
    lehreinheit_str,
    stug_dbez ,
    stug_rstuz ,
    stug_plaetze ,
    eigen , --eigen, fremd
    ca ,
    sum(studierende) ,
    sum(sws_lehrnf_eigen),
    sum(sws_lehrnf_fremd),
    sum(sws_lehrang)
    from tmp_auslastung
    where eigen=1
    group by 1,2,3,4,5,6,7,8,9,10,11,12;
    --Fremd:
insert into tmp_auslastung2( ebene,
gesamt,
ordnr,
sem,
lehreinheit,
    lehreinheit_str,
    lehreinheit_sort,
    stug_dbez ,
    stug_rstuz ,
    stug_plaetze ,
    eigen , --eigen, fremd
    ca ,
    studierende ,
    sws_lehrnf_eigen,
    sws_lehrnf_fremd
    )
    select ebene, 
    10::smallint,--gesamt 
    2510::smallint,
    sem,
lehreinheit,
    lehreinheit_str,
    lehreinheit_str,
    stug_dbez ,
    stug_rstuz ,
    stug_plaetze ,
    eigen , --eigen, fremd
    ca ,
    sum(studierende) ,
    sum(sws_lehrnf_eigen),
    sum(sws_lehrnf_fremd)
    from tmp_auslastung
    where eigen=0
    group by 1,2,3,4,5,6,7,8,9,10,11,12;
--Summenzeile Eigenanteil:
insert into tmp_auslastung2( ebene, 
gesamt,
ordnr,
sem,
lehreinheit,
    lehreinheit_str,
    lehreinheit_sort,
    studierende ,
    sws_lehrnf_eigen,
    sws_lehrnf_fremd,
    sws_lehrang)
    select 3::smallint, 
        10::smallint,
    2000::smallint,
    sem,
lehreinheit,
    trim(lehreinheit_str) || ' Eigenanteil'::char(255),
    lehreinheit_str,
    sum(studierende) ,
    sum(sws_lehrnf_eigen),
    sum(sws_lehrnf_fremd),
    sum(sws_lehrang)
    from tmp_auslastung
    where eigen=1
    group by 1,2,3,4,5,6,7;
--Summenzeile Fremdanteil:
insert into tmp_auslastung2( ebene, 
gesamt,
ordnr,
sem,
lehreinheit,
    lehreinheit_str,
    lehreinheit_sort,
    studierende ,
    sws_lehrnf_eigen,
    sws_lehrnf_fremd
 )
    select 3::smallint, 
    10::smallint,
    2500::smallint,
    sem,
lehreinheit,
    trim(lehreinheit_str) || ' Dienstleistung'::char(255),
    lehreinheit_str,
    sum(studierende) ,
    sum(sws_lehrnf_eigen),
    sum(sws_lehrnf_fremd)
    from tmp_auslastung
    where eigen=0
    group by 1,2,3,4,5,6,7;
--Summenzeile LE   
insert into tmp_auslastung2( ebene,
gesamt,
ordnr,
sem,
lehreinheit,
    lehreinheit_str,
    lehreinheit_sort,
    studierende ,
    sws_lehrnf_eigen,
    sws_lehrnf_fremd
    )
    select 2::smallint,
        10::smallint,
    10::smallint,
    sem,
lehreinheit,
    trim(lehreinheit_str) ,
    lehreinheit_str,
    sum(studierende) ,
    sum(sws_lehrnf_eigen),
    sum(sws_lehrnf_fremd)
    from tmp_auslastung
    group by 1,2,3,4,5,6,7;
    
update tmp_auslastung2 set sws_lehrnf_ea=(select sum(A.studierende* A.ca/A.stug_rstuz)
from tmp_auslastung A, cob_stug G
where G.stug_key=A.stugkey
and G.key_lehreinh=tmp_auslastung2.lehreinheit
and A.sem=tmp_auslastung2.sem
--and A.eigen=1
and A.stug_rstuz >0
)
where ebene=2;

update tmp_auslastung2 set sws_lehrang=(select sum(sws_lehrang)
from tmp_auslastung A
where A.lehreinheit=tmp_auslastung2.lehreinheit
and A.sem=tmp_auslastung2.sem
and A.eigen=1)
where ebene=2;
<#if kenn_zahl_wert_exists==1 && K_KENN_LEHRANG_MAN=1>
--Aus manueller Schnittstelle
update tmp_auslastung2 set sws_lehrang=(select sum(wert)
from kenn_zahl_wert K
where K.kenn_zahl='LEHRE_SWS'
and K.sem=tmp_auslastung2.sem
and K.ch110_institut=tmp_auslastung2.lehreinheit)
where ebene=2;
</#if>

--Gesamt:
-- insert into tmp_auslastung2( ebene,
-- gesamt,
-- ordnr,
-- sem,
-- lehreinheit,
    -- lehreinheit_str,
    -- lehreinheit_sort,
    -- studierende ,
-- sws_lehrnf_eigen,
-- sws_lehrnf_fremd,
    -- sws_lehrang)
    -- select 1::smallint,
    -- 1::smallint,
    -- 0::smallint,
    -- sem,
-- 'Gesamt'::varchar(40),
-- 'Gesamt'::varchar(40),
-- 'Gesamt'::varchar(40),
    -- sum(studierende) ,
    -- sum(sws_lehrnf_eigen),
    -- sum(sws_lehrnf_fremd),
    -- sum(sws_lehrang)
    -- from tmp_auslastung
    -- where eigen=1
    -- group by 1,2,3,4,5,6,7;

update tmp_auslastung2 set sws_lehrnf_ea=(select sum(A.studierende* A.ca/A.stug_rstuz)
from tmp_auslastung A
where --eigen=1
--and 
A.sem=tmp_auslastung2.sem
and A.stug_rstuz >0
)
where ebene=1; 
--Auslastung:
update tmp_auslastung2 set auslastung=(sws_lehrnf_eigen+sws_lehrnf_fremd)/sws_lehrang*100
where ebene <=2
and sws_lehrang >0 ;
--DLK
update tmp_auslastung2 set dlk=(sws_lehrnf_eigen+sws_lehrnf_fremd)/sws_lehrnf_ea
where ebene <=2
and sws_lehrnf_ea >0 ;

--Ext. Kostenstelle Sachsen:
--ist auch der Produktschlssel
update tmp_auslastung2 set k_extkotr=(select min(I.key_extkotr) from kenn_inst_to_ext I
where I.instnr=tmp_auslastung2.lehreinheit
and I.key_extkotr is not null
and trim(I.key_extkotr) !='')
;
--Wenn ext. Kostenstelle noch nicht gepflegt wird, dann wird versucht dies aus sva_inst.fins (in Sachsen der LFB) zu nehmen:
update tmp_auslastung2 set k_extkotr=(select min(E.key) from kenn_extkotr E, kenn_inst I
where I.key_apnr=tmp_auslastung2.lehreinheit
and substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Porduktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
and E.kategorie='lf' --Ebene LFB
and E.key like '1%' --nur Lehre
)
where k_extkotr is null
;
  
--einfgen in echte Tabelle
delete from kenn_auslastung where 0=
(select apnr from konstanten where beschreibung ='KENN_KOSTEN_ARCHIV');


delete from kenn_auslastung
where sem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDG')
;

insert into kenn_auslastung
(
hs_nr,
lehreinheit,
k_extkotr,
sem,
--stugkey,
--cnw,
--bezugstyp,
datum,
--ca,
ffidrgf2,
sws_lehrang,
--lvs_lehrang,
sws_lehrnf,
sws_lehrnf_eigen,
sws_lehrnf_fremd,
sws_lehrnf_ea,
--lvs_lehrnf
dlk
)
select 
H.hs_nr,
lehreinheit,
k_extkotr,
sem,
today(),
studierende,
sws_lehrang,
--sum(lvs_lehrang),
sws_lehrnf_eigen+sws_lehrnf_fremd,
sws_lehrnf_eigen,
sws_lehrnf_fremd,
sws_lehrnf_ea,
--sum(lvs_lehrnf)
dlk
from tmp_auslastung2, hochschulinfo H
where ebene<=2
;



insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'cob_lvm'::char(18),'Studiengang ' || trim(S.stugkey) || ' fehlt in Lehrverflechtung'::char(200), 'Warnung'::char(10) 
from cob_su_imp_stud S left outer join tmp_auslastung T 
on (T.stugkey=S.stugkey
and T.sem=S.sem)
where S.sem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='STDG')
and T.stugkey is null
;

drop table tmp_auslastung;
drop table tmp_auslastung2;
drop table tmp_stug;


</#if> --Ende cob installed


