
--Freemarker Template 

<sqlvars>
<sqlvar name="zul_installed">
select count(*) from db_version where his_system ='zul';
</sqlvar>
<sqlvar name="sos_installed">
select count(*) from db_version where his_system ='sos';
</sqlvar>
<sqlvar name = "k_astat_studienfach_land_exists">
SELECT sp_table_exists('k_astat_studienfach_land') FROM xdummy;
</sqlvar>
<sqlvar name = "k_astat_abschluss3steller_land_exists">
SELECT sp_table_exists('k_astat_abschluss3steller_land') FROM xdummy;
</sqlvar>
<sqlvar name = "k_astat_staat_eu_exists">
SELECT sp_table_exists('k_astat_staat_eu') FROM xdummy;
</sqlvar>
<sqlvar name = "sos_staat_eu_exists">
SELECT sp_table_exists('sos_staat_eu') FROM xdummy;
</sqlvar>
<sqlvar name="abschlusstypen" type="hashsequence">
SELECT apnr,lang_3 as whereclause from kenn_cifx
where key=689
and apnr !='S' --sonstige wird unten als Joker genutzt
;
</sqlvar>
<sqlvar name = "ewr_staaten">
select lang_3 as ewr_staaten from kenn_cifx where key=691
and apnr='BA_EWR';
</sqlvar>
<sqlvar name="SOS_Quellsystem_var">
    select apnr from konstanten where beschreibung='SOS_Quellsystem'
</sqlvar>
</sqlvars>

<#if zul_installed=1>

<#assign staat_eu_table_name="" />
<#if k_astat_staat_eu_exists==1>
	<#assign staat_eu_table_name="k_astat_staat_eu" />
<#elseif sos_staat_eu_exists==1>
	<#assign staat_eu_table_name="sos_staat_eu" />
</#if>

<#assign hzb_staat_erste="null::integer" />
<#if TableFieldExists?exists && TableFieldExists('zul_antr_aggr','hzb_staat_erste')>
<#assign hzb_staat_erste="hzb_staat_erste" />
</#if>

--(c) 2008 Daniel Quathamer

create temp table tmp_kenn_antr_aggr
( 
hs_nr integer, 
fach_nr smallint, 
geschlecht smallint,
ca12_staat smallint,
bewsem smallint,
zul_kz char(1),
fach_sem_zahl smallint,
antrnr smallint,
stg_int char(10),
stg_land char(4),
stg_bund char(4), -- in Zieltabelle stg
abschluss char(10),
abschluss_astat_land char(10),
abschluss_astat_bund char(10),
abschluss_grp char(20),
abschlussart char(10),
abschlusstyp char(10), --BaWue Gruppierung 2024
stort CHAR(10) ,
stort_astat char(10),
stufrm char(10),
stufrm_astat char(10),
hzbart smallint,
hzbart_erste smallint,
hzb_staat_erste integer,
hzb_staat_erste_eu smallint,
hzb_staat_erste_ewr smallint,
datum date,
einschreib_kz CHAR(1) , 
annahme_kz CHAR(1) , 
antrag_gueltig_kz CHAR(1),
summe integer);
	
--Bewerber
insert into tmp_kenn_antr_aggr (
hs_nr,
zul_kz,
fach_nr,
geschlecht,
ca12_staat,
bewsem,
antrnr,
fach_sem_zahl,
stg_int,
abschluss,
      stort,
      stufrm,
       hzbart,
       hzbart_erste,
       hzb_staat_erste,
datum,
einschreib_kz,
annahme_kz,
antrag_gueltig_kz,
       summe)
select H.hs_nr,
       S.zul_kz,
       S.fachnr,
       S.geschlecht,
       S.ca12_staat,
       S.bewsem,
       S.antrnr,
       S.stgsem,
       S.stg,
 S.abschl,
       S.stort,
       S.stufrm,
       S.hzbart,
       S.hzbart_erste,
       ${hzb_staat_erste},
       today(),
       S.einschreib_kz,
       annahme_kz,
       antrag_gueltig_kz,
       count(*)
FROM zul_antr_aggr S, hochschulinfo H, kenn_stichtag K
where S.bewsem = K.bezugszeit 
and K.stichtagsart_id='BEW'
and K.berechnen='1'
group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19;

update tmp_kenn_antr_aggr set antrag_gueltig_kz='J' where
antrag_gueltig_kz is null;


<#if sos_installed==1 && SOS_Quellsystem_var==5>
--manche HSen pflegen die amtlichen Fcher in Abhngigkeit vom Abschluss:
update tmp_kenn_antr_aggr set stg_land=(select min(astat2) from k_abstgv K 
where K.stg=tmp_kenn_antr_aggr.stg_int and K.abschl=tmp_kenn_antr_aggr.abschluss and K.astat2 is not null)
where stg_land is null;
</#if>

 --Amtliche Fcher und Abschlsse
update tmp_kenn_antr_aggr set stg_land=(select min(right(astat,3)) from cifx K where K.key=30 and K.apnr=tmp_kenn_antr_aggr.stg_int and K.astat is not null)
where stg_land is null
;


<#if k_astat_studienfach_land_exists=1>


SELECT L.schluessel,
       L.land,
       null::char(10) as keybund,
       max(nvl(L.gueltig_bis,30001)) as gueltig_bis
   into temp tmp_stg
FROM k_astat_studienfach_land L, cif C
where L.land=C.apnr
and C.key=659 --Bundesland der Hochschule
group by 1,2,3;

update tmp_stg set keybund=(select distinct L.keybund
from k_astat_studienfach_land L
where L.schluessel=tmp_stg.schluessel
and L.land=tmp_stg.land
and (L.gueltig_bis=tmp_stg.gueltig_bis or (L.gueltig_bis is null and tmp_stg.gueltig_bis =30001))
);

update tmp_kenn_antr_aggr set stg_bund=(select K.keybund from tmp_stg K where (tmp_kenn_antr_aggr.stg_land=K.schluessel or tmp_kenn_antr_aggr.stg_land='0' || K.schluessel))
where 1=(select count(*) from tmp_stg K where tmp_kenn_antr_aggr.stg_land=K.schluessel or tmp_kenn_antr_aggr.stg_land='0' || K.schluessel);

update tmp_kenn_antr_aggr set stg_bund='0' || stg_bund where length(trim(stg_bund))=3;



drop table tmp_stg;
</#if>

--Amtliche Abschlsse
--zuerst Land:
update tmp_kenn_antr_aggr set abschluss_astat_land=(select min(astat) from cifx K where K.key=35 and K.apnr=tmp_kenn_antr_aggr.abschluss and K.astat is not null);

<#if k_astat_abschluss3steller_land_exists=1>


--dann Bund:
update tmp_kenn_antr_aggr set abschluss_astat_bund=(select min(substring(K.keybund from 2 for 2))
from k_astat_abschluss3steller_land K, cif C
where K.land=C.apnr
and C.key=659 --Bundesland der Hochschule
and substring(K.schluessel from 2 for 2) =tmp_kenn_antr_aggr.abschluss_astat_land);

--Fallback: 
update tmp_kenn_antr_aggr set abschluss_astat_bund=abschluss_astat_land
where abschluss_astat_bund is null;

<#else>
--Fallback: vor Kern 5.1 gab es keine Zuordnung in kenn:
update tmp_kenn_antr_aggr set abschluss_astat_bund=abschluss_astat_land;

</#if>


--Gruppierung und Lehramt:
<#if abschlusstypen?has_content>
<#foreach typ in abschlusstypen>

update tmp_kenn_antr_aggr set abschlusstyp='${typ.apnr}'
where abschluss_astat_bund in (${typ.whereclause})
;
</#foreach>
</#if>

update tmp_kenn_antr_aggr set abschlusstyp='S' where abschlusstyp is null;



--HZB-Arten:
--update tmp_kenn_antr_aggr set hzbart_astat=(select min(astat) from sos_k_hzbart K where K.apnr=tmp_kenn_antr_aggr.hzbart_int and K.astat is not null);
--Standort:
update tmp_kenn_antr_aggr set stort_astat=(select min(astat) from cifx K where K.key=9012 and K.apnr=tmp_kenn_antr_aggr.stort and K.astat is not null);
--stufrm_astat:
update tmp_kenn_antr_aggr set stufrm_astat=(select min(astat) from cifx K where K.key=612 and K.apnr=tmp_kenn_antr_aggr.stufrm and K.astat is not null);



insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'k_stg'::char(18),'Das Studienfach ' || trim(S.stg_int) || ' hat keinen gltigen ASTAT-Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_antr_aggr S left outer join kenn_stg_astat A on (S.stg_land=A.astat)  
where A.astat is null ;  


insert into kenn_pruefrout (datum,tabelle_quelle,problem,aktion)
select distinct today(),'k_abint'::char(18),'Der Abschluss ' || trim(S.abschluss) || ' hat keinen gltigen ASTAT-Wert'::char(100), 'Warnung'::char(10) 
from tmp_kenn_antr_aggr S left outer join kenn_abschl_astat A on (S.abschluss_astat_bund=A.astat)  
where A.astat is null ;

--Nur PH BaWue: Prfroutine abint gegen kenn_abschl_sbereich.unl :

<#if K_KENN_PROFIL?exists&& (K_KENN_PROFIL==2)>

insert into kenn_pruefrout (datum,tabelle_kenn,tabelle_quelle,problem,aktion)
select distinct today(),'kenn_abschl_sbereich'::char(18),'zul_k_abint'::char(18),'Der Abschluss ' || trim(S.abschluss) || ' hat keine Abschlussgruppe'::char(100), 'Warnung'::char(10) 
from tmp_kenn_antr_aggr S left outer join kenn_abschl_sbereich A on 
(S.abschluss=A.abschluss)
where A.abschluss is null
and 0 <
(SELECT count(*) FROM kenn_stichtag where bezugsart='S' and stichtagsart in ('Bewerberstatistik') and berechnen='1')
;

--Auerdem ist annahme_kz=einschreib_kz
update tmp_kenn_antr_aggr set einschreib_kz=annahme_kz;

</#if>

--HZB-Staat EWR
update tmp_kenn_antr_aggr set hzb_staat_erste_ewr=1
where hzb_staat_erste in (${ewr_staaten});


--hzb_staat_erste_eu ermitteln:
<#if staat_eu_table_name!="">
update tmp_kenn_antr_aggr set hzb_staat_erste_eu=1
where hzb_staat_erste=0
or exists (select eu
from k_astat_staat_eu E
where tmp_kenn_antr_aggr.bewsem between E.semester_von and E.semester_bis
and val(E.astat)= tmp_kenn_antr_aggr.hzb_staat_erste
and eu='J');

update tmp_kenn_antr_aggr set hzb_staat_erste_eu=0
where hzb_staat_erste!=0
and exists (select eu
from k_astat_staat_eu E
where tmp_kenn_antr_aggr.bewsem between E.semester_von and E.semester_bis
and val(E.astat)= tmp_kenn_antr_aggr.hzb_staat_erste
and eu='N');
</#if>

delete from kenn_antr_aggr
where bewsem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='BEW')
;



insert into kenn_antr_aggr
( hs_nr,
zul_kz,
fach_nr,
geschlecht,
ca12_staat,
bewsem,
antrnr,
fach_sem_zahl,
stg_land,
stg,--stg_bund
abschluss,
hzbart,
datum,
stort,
stg_int,
abint,
einschreib_kz,
summe
       )
SELECT hs_nr,
zul_kz,
fach_nr,
geschlecht,
ca12_staat,
bewsem,
antrnr,
fach_sem_zahl,
stg_land,
stg_bund,
abschluss_astat_bund,
hzbart,
datum,
stort_astat,
stg_int,
abschluss,
einschreib_kz,
       sum(summe)
FROM tmp_kenn_antr_aggr
where antrag_gueltig_kz='J'
 group by 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17;


insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
select distinct today(),'antr_aggr'::char(18),'kenn_antr_aggr'::char(18),('Es gibt ' || count(*)::integer || ' Flle, wo Bewerber kein gltiges Geschlecht haben. ')::char(100), 'Info'::char(10) 
from kenn_antr_aggr S 
where (geschlecht is null or geschlecht not in (1,2,3))  
and 0 < (select sum(summe) from tmp_kenn_antr_aggr 
where (geschlecht is null or geschlecht not in (1,2,3)))
;  


--jetzt Befllung  :

delete from kenn_antr_prozess_aggr
where bewsem in (select K.bezugszeit
from kenn_stichtag K
where K.berechnen='1'
and K.stichtagsart_id='BEW')
;
insert into kenn_antr_prozess_aggr(
 hs_nr,
       fach_nr,
       geschlecht,
       bewsem,
       stg,
       stg_land,
       abschlusstyp,
       antrnr,
       fach_sem_zahl_1,
       antrag_status,
       aufbaustudium,
       datum,
       summe)
select  hs_nr,
       fach_nr,
       (case when geschlecht=2 then 2 else 1 end) as geschlecht,
       bewsem,
       stg_bund,
       stg_land,
       abschlusstyp, 
       antrnr,
       (case when fach_sem_zahl=1 then 1 else 0 end) as fach_sem_zahl_1,
       (case when einschreib_kz='J' then 'E'
       when annahme_kz='J' then 'A'
       when zul_kz='J' then 'Z'
       when antrag_gueltig_kz='J' then 'G'
       when antrag_gueltig_kz='N' then 'NG'
       else 'U' end) as antrag_status,
       (case when stufrm_astat in ('3','4','6') then 1 else 0 end) as aufbaustudium,
       datum,
       sum(summe)
FROM tmp_kenn_antr_aggr
group by hs_nr,
       fach_nr,
       geschlecht,
       bewsem,
       stg_bund,
       stg_land,
       abschlusstyp,
       antrnr,
       fach_sem_zahl,
       einschreib_kz,
       annahme_kz,
       zul_kz,
       antrag_gueltig_kz,
       stufrm_astat,
       datum
;


drop table tmp_kenn_antr_aggr;

</#if> --Ende zul_installed=1




