
--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>
<sqlvars>
    <sqlvar name="KENN_ANLAGEN_DATENQUELLE">
        select apnr from konstanten where beschreibung ='KENN_ANLAGEN_DATENQUELLE'
    </sqlvar>
    <sqlvar name="jahre_kenn_stichtag">
        select K.bezugszeit,'' || K.bezugszeit from kenn_stichtag K
        where  K.berechnen='1'
        and K.stichtagsart_id='ANLAGEN'
        and K.bezugsart='J'
        ;
    </sqlvar>
    <sqlvar name="jahre_asp">
        select jahr,typ from tmp_jahre_asp
	--select 2017,'asp_bga' from xdummy
        ;
    </sqlvar>
    <sqlvar name="ivs_installed">
        select count(*) from db_version where his_system ='ivs';
    </sqlvar>
    <sqlvar name="fin_installed">
        select count(*) from db_version where his_system ='fin';
    </sqlvar>
<sqlvar name="tmp_anlagen_aggr_exists">
select sp_table_exists('tmp_anlagen_aggr') from xdummy;

</sqlvar>
</sqlvars>


<#if ivs_installed=1&& (!KENN_ANLAGEN_DATENQUELLE?exists || KENN_ANLAGEN_DATENQUELLE?string=="" || KENN_ANLAGEN_DATENQUELLE?string !="170" )>


<#if tmp_anlagen_aggr_exists==1>
drop table tmp_anlagen_aggr;
</#if>
--nur zur Sicherheit wg. HISinOne:
<#if SQLdialect='Postgres'>
drop table if exists tmp_anlagen_aggr;
</#if>

    create temp table tmp_anlagen_aggr(
    hs_nr INTEGER ,
    asp_haushaltsjahr SMALLINT ,
    asp_bezugsjahr SMALLINT,
    ch110_institut CHAR(10) ,
    inst_ext char(20) ,
    extkotr char(30),
    bund_fachgebiet CHAR(10) ,
    projnr char(10),
    asp_akl varchar(6) ,
    rest DECIMAL(14,2) ,
    rest_vj DECIMAL(14,2) ,
    zugang DECIMAL(14,2) ,
    abgang DECIMAL(14,2) ,
    abschr DECIMAL(14,2) ,
    histor_ahk DECIMAL(14,2) ,
    umbuch DECIMAL(14,2) ,
    zuschr DECIMAL(14,2) ,
    abschr_ges DECIMAL(14,2) ,
    abschr_afa_bis DECIMAL(14,2),
    datum date
    );
    --zuerst ivasp:
    <#if jahre_kenn_stichtag?exists && jahre_kenn_stichtag?has_content >
        <#foreach jahr in jahre_kenn_stichtag>

            select 'Lauf fuer Jahr ${jahr.key} beginnt: ' || now() from xdummy;

            <#assign datenquelle="" />
            <#assign group_filter="" />

            <#if jahre_asp?exists && jahre_asp?has_content >
                <#foreach jahr_asp in jahre_asp>
                    <#if jahr_asp.key=jahr.key>
                       <#if jahr_asp.name =="asp" >
                       <#assign datenquelle="ivs_asp" />
		       <#else>
		       <#assign datenquelle="ivs_asp_bga" />
		       </#if>
                        select 'Datenquelle ${datenquelle} fr ${jahr.key}: ' from xdummy;
                        insert into
                        tmp_anlagen_aggr (
                        asp_bezugsjahr,
                        asp_haushaltsjahr,
                        ch110_institut,
                        --       bund_fachgebiet,
                        asp_akl,
                        datum,
			rest,
			rest_vj,
			zugang,
			abgang,
			abschr,
			histor_ahk,
			<#if datenquelle="ivs_asp_bga">
			umbuch,
			zuschr,
			</#if>
			abschr_afa_bis
                        )
                        select asp_bezugsjahr,
                        asp_haushaltsjahr,
                        <#if datenquelle = "ivs_asp_bga" && TableFieldExists('ivs_asp_bga','ivst_inst')>
                            ivst_inst,
                        <#else>
                            asp_kostenstelle,
                        </#if>
                        asp_akl,
                        today(),
			sum(A.asp_restw_ende),
			sum(A.asp_restw_beginn),
			sum(A.asp_preis_zugang),
			sum(A.asp_preis_abgang),
			sum(A.asp_afa_periode),
			sum(A.asp_preis_beginn),
<#if datenquelle="ivs_asp_bga">
sum(A.asp_umbubetrag),
sum(A.asp_zusch_periode),
</#if>
sum(A.asp_afa_bis)
                        from ${datenquelle} A
                        where
                        A.asp_bezugsjahr=${jahr.key}
                        <#if KENN_anlagen_kam_CUSTOM?exists && KENN_anlagen_kam_CUSTOM !="">
                            <@addcomment comment="Embedding customer-specific repository Script KENN_anlagen_kam_CUSTOM"/>
                            ${KENN_anlagen_kam_CUSTOM}
                        </#if>
                        <#if KENN_anlagen_kfm_CUSTOM?exists && KENN_anlagen_kfm_CUSTOM !="">
                            <@addcomment comment="Embedding customer-specific repository Script KENN_anlagen_kfm_CUSTOM"/>
                            ${KENN_anlagen_kfm_CUSTOM}
                        </#if>
group by 1,2,3,4,5
                        ;

         </#if>
        </#foreach>
    </#if>
</#foreach>
    update tmp_anlagen_aggr set hs_nr=(select hs_nr from hochschulinfo);
    update tmp_anlagen_aggr set abschr_afa_bis=0 where abschr_afa_bis is null;
    update tmp_anlagen_aggr set abschr=0 where abschr is null;
    update tmp_anlagen_aggr set abschr_ges=abschr+abschr_afa_bis;


    -- update tmp_anlagen_aggr set asp_akl=(select apnr from kenn_cifx where key=671 and parent is null and today() between d_akt_von and d_akt_bis)
    -- where asp_akl is null;

    --ein Fall fr die Prfroutine
    --SELECT asp_akl,count(*)
    -- FROM kenn_anlagen_aggr where
    -- and asp_akl not in (select apnr from kenn_cifx where key=671 and today() between d_akt_von and d_akt_bis)
    -- group by 1 ;


    update tmp_anlagen_aggr set bund_fachgebiet=
    (select C.bund_fachgebiet from  kenn_inst C
    where tmp_anlagen_aggr.ch110_institut=C.key_apnr
    and date_val('01.01.' || tmp_anlagen_aggr.asp_haushaltsjahr) between C.gueltig_seit and gueltig_bis)
    where ch110_institut is not null;

    --Ext. Kostenstelle

    update tmp_anlagen_aggr set inst_ext=hs_nr || '_' ||
    (select min(I.key_ext) from kenn_inst_to_ext I
    where I.hs_nr=tmp_anlagen_aggr.hs_nr
    and I.instnr=tmp_anlagen_aggr.ch110_institut
    and I.key_ext is not null
    and trim(I.key_ext) !='');

    update tmp_anlagen_aggr set inst_ext='_S' where inst_ext is null;

    --09.07.2012 Sachsen: Sofern Kostenstelle und Kostentrger zugeordnet sind, wird der externe Schlssel des Kostentrgers (der Finanzierung) ausgewertet.
    <#if K_KENN_PROFIL?exists && (K_KENN_PROFIL==5 || K_KENN_PROFIL==0)>
        --ext Kostenstelle, wenn Projekt  nicht gefllt:
        update tmp_anlagen_aggr set extkotr=(select min(I.key_extkotr) from kenn_inst_to_ext I
        where I.instnr=tmp_anlagen_aggr.ch110_institut
        and I.key_extkotr is not null
        and trim(I.key_extkotr) !='')
        ;
        <#if fin_installed==1>
            update tmp_anlagen_aggr set extkotr=(select min(E.key) from fin_inst I, kenn_extkotr E
            where substring(E.key from 4 for 3)=I.bund_lehr_forsch --der LFB ist im externen Produktschlssel an Stelle 4-6, also z.B. LFB 740 in 108740=LFB Le LFB Raumplanung
            and E.kategorie='lf' --Ebene LFB
            and E.key like '1%' --nur Lehre
            and I.key_apnr=tmp_anlagen_aggr.ch110_institut)
            where extkotr is null
            ;
        </#if>
    </#if>


    --update tmp_anlagen_aggr set fikrkey='' where fikrkey is null;


    delete from kenn_anlagen_aggr where jahr in (select K.bezugszeit from kenn_stichtag K
    where K.berechnen='1'
    and K.stichtagsart_id='ANLAGEN'
    and K.bezugsart='J'
    )
    ;

    insert into
    kenn_anlagen_aggr (hs_nr,
    jahr,
    inst_ext,
    extkotr,
    bund_fachgebiet,
    asp_akl,
    datum,
    rest,
    rest_vj,
    zugang,
    abgang,
    abschr,
    histor_ahk,
    umbuch,
    zuschr,
    abschr_ges
    )
    select hs_nr,
    asp_bezugsjahr,
    inst_ext,
    extkotr,
    bund_fachgebiet,
    asp_akl,
    datum,
    sum(rest),
    sum(rest_vj),
    sum(zugang),
    sum(abgang),
    sum(abschr),
    sum(histor_ahk),
    sum(umbuch),
    sum(zuschr),
    sum(abschr_ges)

    from tmp_anlagen_aggr
    group by 1,2,3,4,5,6,7;

    insert into kenn_pruefrout (datum,tabelle_quelle,tabelle_kenn,problem,aktion)
    select distinct today(),'inst'::char(18),'kenn_anlagen_aggr'::char(18),'Anlagen ohne externe Kostenstelle: ' || count(*)::integer , 'Info'::char(10)
    from tmp_anlagen_aggr A
    where A.inst_ext='_S';




</#if> -- ende Jahre gefllt
    drop table tmp_anlagen_aggr;
</#if> -- ende Datenquelle ivs



<#if KENN_ANLAGEN_DATENQUELLE?exists && KENN_ANLAGEN_DATENQUELLE?string!="" && KENN_ANLAGEN_DATENQUELLE?string=="170">
    delete from kenn_anlagen_aggr where jahr in (select K.bezugszeit from kenn_stichtag K
    where K.berechnen='1'
    and K.stichtagsart_id='ANLAGEN'
    and K.bezugsart='J');

    insert into
    kenn_anlagen_aggr (hs_nr,
    jahr,
    inst_ext,
    bund_fachgebiet,
    asp_akl,
    datum,
    rest,
    rest_vj,
    zugang,
    abgang,
    abschr,
    histor_ahk,
    umbuch,
    zuschr,
    abschr_ges,
    extkotr
    )
    select G.hs_nr,
    G.gjahr,
    G.inst_ext,
    G.bund_fachgebiet,
    G.asp_akl,
    datum,
    G.rest,
    G.rest_vj,
    G.zugang,
    G.abgang,
    G.abschr,
    G.histor_ahk,
    G.umbuch,
    G.zuschr,
    G.abschr_ges,
    extkotr
    from gxstage_anlagen_aggr G
    where G.gjahr in (select K.bezugszeit from kenn_stichtag K
    where K.berechnen='1'
    and K.stichtagsart_id='ANLAGEN'
    and K.bezugsart='J');

update kenn_anlagen_aggr set inst_ext='_S' where inst_ext is null;
</#if> -- ende Datenquelle GXSTAGE

drop table tmp_jahre_asp;
