-- bertragung der Daten von kenn_sgd_aggr nach kenn_stelle_hhpl
-- Beim STBB  wird auf diese Tabelle zugegriffen und falls diese nach einem Upgrade 
-- nicht neu berechnet werden, wrden ohne dieses upgrade die Zahlen nicht mehr angezeigt werden.

create temp table tmp_sgd_aggr_jahre (hs_nr integer,
kapitel char(10),
titel CHAR(5) , 
jahr integer,
stichtag date
);

create temp table tmp_stelle_hhpl_jahre (hs_nr integer,
kapitel char(10),
titel CHAR(5) , 
jahr_von integer,
jahr_bis integer
);

--welche Jahre sind vorhanden in kenn_sgd_aggr?
insert into tmp_sgd_aggr_jahre (hs_nr,
jahr,
  kapitel,
  titel,
 stichtag
)
select distinct hs_nr,
year(stichtag),
  kapitel,
  titel,
 stichtag from kenn_sgd_aggr 
where month(stichtag)=1
and kategorie_gruppe=1;



--welche Jahre sind in kenn_stelle_hhpl vorhanden?
insert into tmp_stelle_hhpl_jahre (hs_nr,
  kapitel,
  titel,
 jahr_von,
 jahr_bis)
select distinct hs_nr,  
kapitel,
  titel,
 jahr_von,
 jahr_bis from kenn_stelle_hhpl;

--diese dann entfernen:
delete from tmp_sgd_aggr_jahre 
where 0< (select count(*)
from tmp_stelle_hhpl_jahre T
where tmp_sgd_aggr_jahre.jahr between T.jahr_von and T.jahr_bis
		 and T.hs_nr=tmp_sgd_aggr_jahre.hs_nr
		 and T.kapitel=tmp_sgd_aggr_jahre.kapitel
  and T.titel= tmp_sgd_aggr_jahre.titel
 );


INSERT INTO kenn_stelle_hhpl
(
  kapitel,
  titel,
  hs_nr,
  bvl_stelle_kurz,
  adbz_land,
  datum,
  jahr_von,
  jahr_bis,
  summe
)
select 
K.kapitel,
K.titel,
 	K.hs_nr,
	K.bvl_stelle_kurz,
	K.adbz_land,
	today(),
	year(K.stichtag),
	year(K.stichtag),
	sum(K.summe)
from tmp_sgd_aggr_jahre T, kenn_sgd_aggr K
where T.hs_nr=K.hs_nr
and T.jahr=year(K.stichtag)
and T.stichtag=K.stichtag
and K.kapitel=T.kapitel
and K.titel=T.titel
and K.kategorie_gruppe=1
group by 1,2,3,4,5,6,7,8;

drop table tmp_sgd_aggr_jahre;
drop table tmp_stelle_hhpl_jahre;
