--freemarker template

<#if SQLdialect='Postgres'>

truncate table kenn_flaeche_cube;

<#else>

delete from kenn_flaeche_cube;

</#if>

create temp table tmp_flaeche_cube(
	hs_nr INTEGER , 
bund_fachgebiet CHAR(10) ,
ch110_institut char(10),
    inst_art char(20),
nutzungsart CHAR(4) , 
kfanr VARCHAR(2) , 
jahr SMALLINT , 
flaeche DECIMAL(15,2) 
);

insert into tmp_flaeche_cube( hs_nr,
       nutzungsart,
       ch110_institut,
       kfanr,
       jahr,
       flaeche)
SELECT hs_nr,
       nutzungsart,
       ch110_institut,
       kfanr,
       jahr,
       sum(flaeche)
FROM kenn_flaeche
group by 1,2,3,4,5;

update tmp_flaeche_cube set bund_fachgebiet =(
select min(I.bund_fachgebiet) from kenn_inst I
where
tmp_flaeche_cube.hs_nr=I.hs_nr
and I.key_apnr=tmp_flaeche_cube.ch110_institut);

--Joker: unbekanntes Fach
update tmp_flaeche_cube set bund_fachgebiet ='-9'
where bund_fachgebiet is null;
--Unbek. Nutzungsart
update tmp_flaeche_cube set nutzungsart ='S'
where nutzungsart is null or nutzungsart not in ('H','N');

update tmp_flaeche_cube set inst_art=hs_nr || '_' || (select min(I.key_ext) from kenn_inst_to_ext I
where I.hs_nr=tmp_flaeche_cube.hs_nr
and I.instnr=tmp_flaeche_cube.ch110_institut
and I.key_ext is not null
);
update tmp_flaeche_cube set inst_art='_S' where inst_art is null;



insert into  kenn_flaeche_cube(hs_nr,
       nutzungsart,
       bund_fachgebiet,
       kfanr,
       jahr,
       inst_art,
       flaeche)
SELECT hs_nr,
       nutzungsart,
       bund_fachgebiet,
       kfanr,
       jahr,
       inst_art,
       sum(flaeche)
FROM tmp_flaeche_cube
group by 1,2,3,4,5,6;

drop table tmp_flaeche_cube;
