
--Freemarker Template 

<sqlvars>
<sqlvar name="hochschulen">
select trim(hs_nr::char(10)),trim(name),30 from hochschulinfo
</sqlvar>
</sqlvars>

<#if hochschulen?has_content >




 create temp table tmp_ausg(gruppe char(12),key char(12),ueberg char(12));
 create temp table tmp_hier(gruppe char(12),key char(12),ueberg char(12));


--in dieser Tabelle stehen spaeter Schluessel fuer das jew. Quartal
create temp table tmp_inst(ch110_institut char(10),bezugszeit integer);


create temp table tmp_quartal
(
  
    bezugszeit integer,
    jahr smallint,
    quartal integer,
    bvkr_sicht_id integer,
    inst_sicht_id integer,
    monat_von smallint,
    monat_bis smallint

);

<#foreach hochschule in hochschulen>

select 'Lauf fuer Hochschule ${hochschule.key} ${hochschule.name} beginnt: ' || now() from xdummy;

<#if SQLdialect='Postgres'>

begin work;


</#if>

--zuerst alle Quartale zusammenstellen, die noch ohne BVKR-Art sind:

create temp table tmp_quartal_anz
(  bezugszeit integer,
    jahr smallint,
    quartal integer,
anzahl integer);

insert into tmp_quartal_anz(

       quartal,
       jahr
       )
select distinct quartal,
       jahr
  from kenn_busa_aggr;

update tmp_quartal_anz set anzahl=(select
  count(*) from kenn_busa_aggr A
  where bvkr_art is not null
  and A.quartal=tmp_quartal_anz.quartal);
       
insert into tmp_quartal(

       bezugszeit,
       jahr
       )
select distinct quartal,
       jahr
       
  from tmp_quartal_anz
  where anzahl = 0;
  
  
drop table tmp_quartal_anz;



update tmp_quartal set quartal=val(substring('' || bezugszeit from 5 for 1));
update tmp_quartal set monat_von=quartal*3-2;
update tmp_quartal set monat_bis=quartal*3;

--nun die zugehrigen Sichten zuordnen:
--Die Regel geht vom allgemeinen zum Besonderen, d.h. erst die Sicht fr "alle"

--zuerst BVKR
--zuerst Jahr
update tmp_quartal set bvkr_sicht_id=(select min(S.tid) 
from kenn_hs_sichten S 
 where S.hs_nr=${hochschule.key}
 and S.dimension='BVKR'
and S.bezugszeit=tmp_quartal.jahr
and S.bezugsart='J')
;
--dann quartal
update tmp_quartal set bvkr_sicht_id=(select min(S.tid) 
from kenn_hs_sichten S 
 where S.hs_nr=${hochschule.key}
 and S.dimension='BVKR'
and S.bezugszeit=tmp_quartal.bezugszeit
and S.bezugsart='Q')
where 0 < (select count(*)
from kenn_hs_sichten S 
 where S.hs_nr=${hochschule.key}
 and S.dimension='BVKR'
and S.bezugszeit=tmp_quartal.bezugszeit
and S.bezugsart='Q')
;

--nun INST
update tmp_quartal set inst_sicht_id=(select min(S.tid) 
from kenn_hs_sichten S 
 where S.hs_nr=${hochschule.key}
 and S.dimension='MWK_INST'
and S.bezugszeit=tmp_quartal.jahr
and S.bezugsart='J')
;
update tmp_quartal set inst_sicht_id=(select min(S.tid) 
from kenn_hs_sichten S 
 where S.hs_nr=${hochschule.key}
 and S.dimension='MWK_INST'
and S.bezugszeit=tmp_quartal.bezugszeit
and S.bezugsart='Q')
where 0 < (select count(*)
from kenn_hs_sichten S 
 where S.hs_nr=${hochschule.key}
 and S.dimension='MWK_INST'
and S.bezugszeit=tmp_quartal.bezugszeit
and S.bezugsart='Q')
;


<#if SQLdialect='Postgres'>

commit;

</#if>

--Zuruecksetzen der Schluessel

select 'Zuruecksetzen der Schluessel '|| now()  from xdummy;
<#if SQLdialect='Postgres'>

begin work;

</#if>

update kenn_busa_aggr set bvkr_art=null, inst_art=null
where hs_nr=${hochschule.key}
and quartal in (select bezugszeit from tmp_quartal);

--fllen der Hierarchien


insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.parent
from kenn_alt_keys C, tmp_quartal Q, kenn_hs_sichten S
where S.tid=Q.bvkr_sicht_id
and S.alt_hier_id is not null
and C.relation='fikr'
and C.hierarchie_id=S.alt_hier_id
and (
(S.bezugszeit=Q.bezugszeit and S.bezugsart='Q') 
or
(S.bezugszeit=Q.jahr and S.bezugsart='J')
)
and S.hs_nr=${hochschule.key}
and C.hs_nr=${hochschule.key}
;
insert into tmp_hier select Q.bezugszeit as gruppe,C.key,C.ueberg
from kenn_fikr C, tmp_quartal Q, kenn_hs_sichten S
where S.tid=Q.bvkr_sicht_id
and S.alt_hier_id is null
and (
(S.bezugszeit=Q.bezugszeit and S.bezugsart='Q') 
or
(S.bezugszeit=Q.jahr and S.bezugsart='J')
)
and S.hs_nr=${hochschule.key}
and C.hs_nr=${hochschule.key}
and date_val('01.' || Q.monat_bis || '.' || Q.jahr ) between C.key_von and C.key_bis
;

select 'Inst Hierarchie fuellen ' || now() from xdummy;

--Inst:
insert into tmp_inst select C.key,Q.bezugszeit
from kenn_alt_keys C, tmp_quartal Q, kenn_hs_sichten S
where S.tid=Q.inst_sicht_id
and S.alt_hier_id is not null
and C.relation='inst'
and C.hierarchie_id=S.alt_hier_id
and (
(S.bezugszeit=Q.bezugszeit and S.bezugsart='Q') 
or
(S.bezugszeit=Q.jahr and S.bezugsart='J')
)
and S.hs_nr=${hochschule.key}
and C.hs_nr=${hochschule.key}
;
insert into tmp_inst select C.key_apnr,Q.bezugszeit 
from kenn_inst C, tmp_quartal Q, kenn_hs_sichten S
where S.tid=Q.inst_sicht_id
and S.alt_hier_id is null
and (
(S.bezugszeit=Q.bezugszeit and S.bezugsart='Q') 
or
(S.bezugszeit=Q.jahr and S.bezugsart='J')
)
and S.hs_nr=${hochschule.key}
and C.hs_nr=${hochschule.key}
and date_val('01.' || Q.monat_bis || '.' || Q.jahr ) between C.gueltig_seit and C.gueltig_bis
;

--BVKR-Leafs
insert into tmp_ausg select distinct Q.bezugszeit,C.apnr,C.apnr
from tmp_quartal Q,kenn_cifx C where C.key=668 and ebene >2
--der 906 ist der einzige Schlssel, der auch untergeordnete Schlssel hat
--er bekommt spter eine Sonderbehandlung
and C.apnr != '906';


<#if SQLdialect='Postgres'>

commit;

</#if>

select 'BVKR-Kinder suchen ' || now()  from xdummy;

<#if SQLdialect='Postgres'>

begin work;

</#if>
 
<#if SQLdialect='Postgres'>
select sp_get_children() ;
<#else>

execute procedure sp_get_children();

</#if>

--select * from tmp_ausg;
-- 
<#if SQLdialect='Postgres'>

commit;

</#if>
<#if SQLdialect='Postgres'>

begin work;

</#if>

--Gibt es folgenden Fall: eine KoA, die als Leaf im BVKR fungiert,
--ist in der alt.Hier. der Hochschule ein Element unterhalb eines anderen Leafs,
--dann tritt der paradoxe Fall auf, da eine Buchung bei der BVKR-Art beide Leafs haben soll
--was aber nicht geht.
--Daher rausschmeien:
create temp table tmp_doppelt(gruppe char(12),key char(12),ueberg char(12));
insert into tmp_doppelt (gruppe,key)
select gruppe,key from tmp_ausg group by 1,2 having count(*) > 1;



delete from tmp_ausg where gruppe || '_' || key in 
(select D.gruppe || '_' || D.key from tmp_doppelt D)
and key != ueberg;

drop table tmp_doppelt;


update kenn_busa_aggr set bvkr_art=
(select distinct ueberg from tmp_ausg A
where A.key=kenn_busa_aggr.fikrkey
and val(A.gruppe)=kenn_busa_aggr.quartal)
where hs_nr=${hochschule.key}
and quartal in (select bezugszeit from tmp_quartal)
;

--Alle anderen Schlssel, die in dem Quartal existieren, bekommen ein S
update kenn_busa_aggr set bvkr_art='S' 
where bvkr_art is null
and fikrkey in(
select key from tmp_hier A where val(A.gruppe)=kenn_busa_aggr.quartal
)
and hs_nr=${hochschule.key}
and quartal in (select bezugszeit from tmp_quartal)
;

--nun der 906er
delete from tmp_ausg;
insert into tmp_ausg select distinct Q.bezugszeit,'906'::char(12),'906'::char(12)
from tmp_quartal Q;

<#if SQLdialect='Postgres'>
select sp_get_children() ;
<#else>

execute procedure sp_get_children();

</#if>

--der 906 wird nur zugewiesen, wenn die Kinder 90689 etc.nicht schon zugewiesen sind.

update kenn_busa_aggr set bvkr_art='906' where fikrkey in(
select key from tmp_ausg A where A.ueberg='906'
and val(A.gruppe)=kenn_busa_aggr.quartal
)
and (bvkr_art not like '906%' or bvkr_art is null)
and hs_nr=${hochschule.key}
and quartal in (select bezugszeit from tmp_quartal)
;



<#if SQLdialect='Postgres'>

commit;

</#if>

select 'inst_art setzen' || now()  from xdummy;

<#if SQLdialect='Postgres'>

begin work;

</#if>

update kenn_busa_aggr set inst_art=ch110_institut
where inst_art is null
and ch110_institut in(
select A.ch110_institut from tmp_inst A where A.bezugszeit=kenn_busa_aggr.quartal
)
and hs_nr=${hochschule.key}
and quartal in (select bezugszeit from tmp_quartal)
;

delete from tmp_quartal;

delete from tmp_inst;
 delete from tmp_ausg;
 delete from tmp_hier;

 
<#if SQLdialect='Postgres'>

commit;

</#if>
select '--------------------------------------------------------'|| now()  from xdummy;

</#foreach>


drop table tmp_quartal;

drop TABLE tmp_inst;
 drop table tmp_ausg;
 drop table tmp_hier;
 
</#if>
