--freemarker template
<sqlvars>
<sqlvar name="laeuft_im_HUES_var">
select 1 from xdummy where 1 != (select count(*) from hochschulinfo)
union
select 0 from xdummy where 1 = (select count(*) from hochschulinfo);
</sqlvar>
<sqlvar name="hsnr_kenn_tabellen" type="hashsequence">select table_name,name from sx_fields
where name='hs_nr' 
and table_name like 'kenn_%'
and table_name not in ('kenn_hochschulen', 'kenn_hs_sichten','hochschulinfo','kenn_rpt_ansprech','kenn_stbb_kap_titel_bericht')
and table_name not like 'kennx%'
;</sqlvar>

</sqlvars>

<#assign laeuft_im_HUES=0 /> 
<#if laeuft_im_HUES_var =1>
<#assign laeuft_im_HUES=1 />
</#if>

begin work;

<#foreach tabelle in hsnr_kenn_tabellen>
<#if laeuft_im_HUES==1>
insert into kennx_pruef(       hs_nr,
       datum,
       tabelle_kennx,
       meldung,
       loglevel)
       select 
       hs_nr,
       today() as datum,
       '${tabelle.table_name}' as tabelle_kennx,
       count(*) || ' Datenstze Massenlschung',
'INFO'::char(10) 
from  ${tabelle.table_name}
where hs_nr::varchar(255) in ('5151','2640')
group by 1;
;
</#if>
delete from  ${tabelle.table_name}
where hs_nr::varchar(255) in ('5151','2640');
</#foreach>

commit;

