--Freemarker Template
<#include "SQL_lingua_franca"/>
<#include "SuperX_general"/>

<sqlvars>
<sqlvar name="bestaende" type="hashsequence">
select B.apnr,B.druck,B.quelltabelle,B.bezugsart as timeunit,B.zeitfeld,B.stichtagsart_id from kenn_bestandsart B 
where  B.quelltabelle is not null
order by 3
 ;
 
</sqlvar>
<sqlvar name="KENN_VACUUM_VAR" >
select  apnr from konstanten where  beschreibung='KENN_VACUUM' --Nur in KENNX definiert
union
select 1 from xdummy
where 0=(select count(*) from konstanten where  beschreibung='KENN_VACUUM') --das Script luft beim HS-KENN
 ;
 </sqlvar>
 <sqlvar name="kennx_pruef_exist">

	select sp_table_exists('kennx_pruef') from xdummy

</sqlvar>
</sqlvars>

<#if KENN_VACUUM_VAR==1>
--das Script luft nur beim HS-KENN oder in KENNX am Ende aller Laderoutinen

create temp table tmp_bestand
(
hs_nr integer,
key integer,
bestandsart char(40),
stichtagsart_id char(40),
druck varchar(255),
quelltabelle  varchar(255),
timeunit char(1),
semester integer,
jahr integer,
quartal integer,
zeitwert integer,
bestand_anz integer,
datenherkunft varchar(255)
)
;
<#if bestaende?has_content>
<#foreach bestand in bestaende>

insert into tmp_bestand(hs_nr,
bestandsart,
stichtagsart_id,
quelltabelle,
timeunit,
zeitwert,
bestand_anz)
select hs_nr,
'${bestand.apnr}'::char(40),
'${bestand.stichtagsart_id}'::char(40),
'${bestand.quelltabelle}'::char(255),
'${bestand.timeunit}'::char(1),
${bestand.zeitfeld},
count(*) 
from ${bestand.quelltabelle}
<#if bestand.quelltabelle == "kenn_zahl_wert">
where kenn_zahl ='${bestand.apnr}'
</#if>
group by 1,2,3,4,5,6
;
</#foreach>
</#if>


--<#if kennx_pruef_exist=1>
---- bernehme Datenherkunft aus kennx_pruef
--update tmp_bestand B set datenherkunft = (select P.datenherkunft from kennx_pruef P
--where B.hs_nr=P.hs_nr
--	and B.stichtagsart_id=P.stichtagsart
--	and B.zeitwert=P.bezugszeit -- or (B.zeitwert!=P.bezugszeit and substring(B.zeitwert::text, 1, 4)::integer=P.bezugszeit) -- falls bezugsart nicht bereinstimmt
--	and P.datum = (select max(P2.datum) from kennx_pruef P2
--					where B.hs_nr=P2.hs_nr
--						and B.stichtagsart_id=P2.stichtagsart
--						and B.zeitwert=P2.bezugszeit -- or (B.zeitwert!=P2.bezugszeit and substring(B.zeitwert::text, 1, 4)::integer=P2.bezugszeit) -- falls bezugsart nicht bereinstimmt
--				)
--	)
--;

---- bernehme Datenherkunft aus kenn_bestand, falls sie in kennx_pruef nicht mehr vorhanden ist
--update tmp_bestand B set datenherkunft=
--(select B2.datenherkunft from kenn_bestand B2
--	where 1=1
--		and B.hs_nr=B2.hs_nr
--		and B.stichtagsart_id=B2.stichtagsart_id
--		and B.zeitwert=B2.zeitwert)
--where B.datenherkunft is null
--;
--</#if>

delete from kenn_bestand;

insert into kenn_bestand(hs_nr,
       bestandsart,
       stichtagsart_id,
       quelltabelle,
       timeunit,
       zeitwert,
       bestand_anz,
       datenherkunft)
select
hs_nr,
       bestandsart,
       stichtagsart_id,
       quelltabelle,
       timeunit,
       zeitwert,
       bestand_anz,
       datenherkunft
from tmp_bestand;

drop table tmp_bestand;

</#if>



