select sp_update_sequence('sx_downloads');

drop table IF EXISTS tmp_downloads;

CREATE temp TABLE tmp_downloads
(
   tid             integer,
   name            char(255),
   ch110_institut  char(10),
   bezugsdatum     date,
   jahr integer,
   quartal integer,
   monat varchar(255),
   kapitel varchar(255),
   titel varchar(255),
   importdatum     date,
   kommentar       text,
   kommentar_url   char(255),
   contenttype     varchar(255),
   datei           char(255)      NOT NULL,
   gueltig_seit    date ,
   gueltig_bis     date 
);  



insert into tmp_downloads(name,
       ch110_institut,
   jahr ,
   quartal ,
   kapitel,
   titel,
       importdatum,
       kommentar,
--       kommentar_url,
       contenttype,
       datei,
       gueltig_seit,
       gueltig_bis)
       select 'Leerstellenbericht' ,
       ${Hochschule} as ch110_institut,
       ${Jahr},
       ${Quartal},
       '${Kapitel}',
       '${Titel}',
       today() as importdatum,
       'Hochgeladen am ' || date_str(today()) as kommentar, --TODO userid
--       kommentar_url,
       'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' as contenttype,
       '${zieldatei}',
       date_val('01.01.1900' ) as gueltig_seit,
       date_val('01.01.2900' ) as gueltig_bis
 from xdummy;

 update tmp_downloads set monat=lpad('' || (((quartal-1)*3)+1),2,'0');
 
update tmp_downloads set bezugsdatum=date_val('01.' || monat  || '.' || jahr ) 
;
update tmp_downloads set name = trim(name) || ' ' || string_not_null((select H.name from kenn_hochschulen H
where H.hs_nr=${Hochschule} )) || ' ' || year(bezugsdatum) || ' ' || monat  || ' ' || kapitel || ' ' || titel
;

--TODO Liefersperren auswerten

delete from tmp_downloads where datei in (select distinct datei from sx_downloads);

insert into sx_downloads(name,
       ch110_institut,
       bezugsdatum,
       importdatum,
       kommentar,
       kommentar_url,
       contenttype,
       datei,
       gueltig_seit,
       gueltig_bis)
       select name,
       ch110_institut,
       bezugsdatum,
       importdatum,
       kommentar,
       kommentar_url,
       contenttype,
       datei,
       gueltig_seit,
       gueltig_bis
       from tmp_downloads;
       
update tmp_downloads set tid=(select max(tid) from sx_downloads D
where D.datei=tmp_downloads.datei);

insert into download_keyw_bez
(
   keyword_id   ,
   download_id  
   )
   select distinct E.tid, D.tid
   from sx_keywords E, tmp_downloads D
   where E.name='Leerstellenbericht'
;


drop table tmp_downloads;
   
insert into kennx_pruef (datum,
hs_nr,
stichtagsart,
bezugszeit,
bezugsart,
meldung,
loglevel,
datenherkunft,
aktion)
select today(),
${Hochschule},
'LEERST',
${Jahr},
'J',
'Upload des Leerstellenberichtes erfolgreich',
'INFO'::char(10) ,
'manuell',
'erfolgreich'
from xdummy
;

