
--SQL Script automatisch generiert von SuperX unload_params_fuellen.xsl
--Unload Parameter und deren Defaults setzen

--freemarker template
<sqlvars>
<sqlvar name="unload_params_exists">
select sp_table_exists('unload_params') from xdummy;

</sqlvar>

</sqlvars>
<#if unload_params_exists=1>

create temp table tmp_unload_params(
	tid SERIAL  not null, 
	param_id VARCHAR(255)  not null, 
	param_val VARCHAR(255) , 
	default_val VARCHAR(255) , 
	description VARCHAR(255) , 
	systeminfo_id INTEGER ,
	wertebereich varchar(250),
	ab_version varchar(10),
	gruppe varchar(255),
	sachgebiete_id integer,
	priority integer,
	sourcesystem integer 
);


-- Standardparameter DATABASE (fr alle Komponenten)
insert into tmp_unload_params(param_id,
		param_val,
		default_val,
		description,
		priority,
		sourcesystem,
		wertebereich,
		ab_version,
		gruppe,
		systeminfo_id
		)
		values ('DATABASE',
		'POSTGRES',
		'POSTGRES',
		'Quell-DBMS',
		1,
		0,
		'POSTGRES, INFORMIX',
		'>6.0',
		'Systemparameter',
		109
		);
		

-- Standardparameter SOURCESYSTEM (fr alle Komponenten)
		 

insert into tmp_unload_params(param_id,
		param_val,
		default_val,
		description,
		priority,
		sourcesystem,
		wertebereich,
		ab_version,
		gruppe,
		systeminfo_id)
		values ('SOURCESYSTEM',
		'eduetl',
		'eduetl',
			'Datenquelle/Quellsystem',
			1,
			0,
			'z.B. sospos, sva oder hisinone'
			, '>6.0',
			'Systemparameter',
			109);
			


--Parameter aus der Moduldatei
		

--description wird immer gendert:
update unload_params set description=(select T.description
	from tmp_unload_params T
	where T.param_id=unload_params.param_id
		and T.systeminfo_id=unload_params.systeminfo_id)
	where systeminfo_id=109
	and param_id in (select param_id from tmp_unload_params);

--default_val wird immer gendert:
update unload_params set default_val=(select T.default_val
	from tmp_unload_params T
	where T.param_id=unload_params.param_id
		and T.systeminfo_id=unload_params.systeminfo_id)
	where systeminfo_id=109
	and param_id in (select param_id from tmp_unload_params);


--priority ndern:
--diese Spalte und nachfolgende sind mit 2022.06 hinzugekommen
--wg. Abwrtskompaitbilitt zu Kern 4.9 daher bedingte Ausfhrung:
<#if TableFieldExists?exists && TableFieldExists('unload_params','priority')>
update unload_params set priority=(select T.priority
	from tmp_unload_params T
	where T.param_id=unload_params.param_id
		and T.systeminfo_id=unload_params.systeminfo_id)
	where systeminfo_id=109
	and param_id in (select param_id from tmp_unload_params);
--sourcesystem ndern:

update unload_params set sourcesystem=(select T.sourcesystem
	from tmp_unload_params T
	where T.param_id=unload_params.param_id
		and T.systeminfo_id=unload_params.systeminfo_id)
	where systeminfo_id=109
	and param_id in (select param_id from tmp_unload_params);

--wertebereich ndern:

update unload_params set wertebereich=(select T.wertebereich
	from tmp_unload_params T
	where T.param_id=unload_params.param_id
		and T.systeminfo_id=unload_params.systeminfo_id)
	where systeminfo_id=109
	and param_id in (select param_id from tmp_unload_params);
	
--ab_version ndern:
update unload_params set ab_version=(select T.ab_version
	from tmp_unload_params T
	where T.param_id=unload_params.param_id
		and T.systeminfo_id=unload_params.systeminfo_id)
	where systeminfo_id=109
	and param_id in (select param_id from tmp_unload_params);
	
--gruppe ndern:
update unload_params set gruppe=(select T.gruppe
	from tmp_unload_params T
	where T.param_id=unload_params.param_id
		and T.systeminfo_id=unload_params.systeminfo_id)
	where systeminfo_id=109
	and param_id in (select param_id from tmp_unload_params);
</#if>


delete from tmp_unload_params where systeminfo_id || param_id in
	(select systeminfo_id || param_id from unload_params);

insert into unload_params(param_id,
		param_val,
		default_val,
		description,
		systeminfo_id
		<#if TableFieldExists?exists && TableFieldExists('unload_params','priority')>
		, 
		priority,
		sourcesystem,
		wertebereich,
		ab_version,
		gruppe
		</#if>
		)
select param_id,
		param_val,
		default_val,
		description,
		systeminfo_id
		<#if TableFieldExists?exists && TableFieldExists('unload_params','priority')>
		,
		 priority,
		sourcesystem,
		wertebereich,
		ab_version,
		gruppe</#if>
		from tmp_unload_params
	where param_id is not null;
	drop table tmp_unload_params;


</#if>
