
--SQL Script automatisch generiert von SuperX sx_tables_fuellen.xsl


--freemarker template
<sqlvars>
<sqlvar name="sx_tables_exists">
select sp_table_exists('sx_tables') from xdummy;

</sqlvar>

</sqlvars>
<#if sx_tables_exists=1>



CREATE temp table tmp_tables(
name CHAR(255) , 
caption CHAR(255) , 
description CHAR(255) , 
table_type CHAR(255) , 
systeminfo_id INTEGER  , 
systeminfo_orig INTEGER  , 
thema CHAR(255) , 
sachgebiete_id CHAR(255) 
);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_abint','Studienabschluss (intern)','Hochschulinterne Abschlsse',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_abschl_pruef_grp','','Verzeichnis der externen Prfungsgruppen',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_abschl_sbereich','','',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_absolv_aggr_astat','Absolventen (amtl. Stat.) Unis BaWue','Hilfstabelle Prfungsstatistik (amtl.) fr Semesterberichte Unis BaWue',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_alt_keys','','Enthaelt die alternativen Hierarchien aus alt_inst, alt_fikr, alt_proj, die ans MWK exportiert werden. Nur fr Hochschulen, die mit dem SuperX-COB-Modul arbeiten.',
'Schlsselstabelle',
109,
109,
'Zentrale Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_anlagen_aggr','Anlagen','Aggregierte Anlagedaten aus IVS',
'Hilfstabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_antr_aggr','Bewerberstatistik','Hilfstabelle Bewerberstatistik',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_antr_cube','Bewerbungen (Semesterberichte)','Semesterberichte Bewerbungen',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_antr_prozess_aggr','Bewerbungsproze-Statistik','Hilfstabelle Bewerbungsproze-Statistik',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_auslastung','Auslastung','Lehrnachfrage/angebot gem. KapVo (nur Sachsen)',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_bestand','','Hilfstabelle Lieferungen pro Bestand',
'Hilfstabelle',
109,
109,
'Administration Kenn-Modul',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_bestandsart','','Bestandsarten',
'Schlsseltabelle',
109,
109,
'Administration Kenn-Modul',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_bestandsart_bland','','Bestandsarten zu Bundeslndern',
'Schlsseltabelle',
109,
109,
'Administration Kenn-Modul',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_busa_aggr','Primrbuchungen','Hilfstabelle Primrkosten, busa steht fr Buchungsstze, aber die Werte sind aggregiert',
'Hilfstabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_cifx','','Zentrale KENN-Schlssel, bestehend aus Schlssel, astat und ggf. auch parent.',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_dim_extkost','Externe Kostenstelle','Verzeichnis der externen Kostenstellen',
'Schlsseltabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_dim_extkotr','Externe Kostentrger','Verzeichnis der externen Kostentrger',
'Schlsseltabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_dim_fgr','Fchergruppe','Schlssel des Stat. Bundesamtes fr Fchergruppen (Studierende und Personal)',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_dim_lfb_fg','Fachgebiet (Bund)','         Schlssel des Stat. Bundesamtes fr Lehr-Forschungsbereiche und Fachgebiete. Die Tabelle spannt eine Hierarchie auf:         Alle         Fchergruppe         Lehr- und Forschungsbreich         Fachgebiet       ',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_dr','TGR/Deckungsring','Deckungsring-Bezeichnungen der Hochschule (nur gefllt wenn Konstante KENN_KAMERAL_ERWEITERT=1)',
'Schlsseltabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_drittm_aggr','Haushalt','Aggregierte Drittmittel der Hs-Finanzstat.',
'Hilfstabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_extkotr','','Verzeichnis der externen Kostentrger aus dem SuperX-COB-Modul',
'Schlsseltabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_extkotr_lfb_hs','Lehr- und Forschungsbereiche zu Hochschulen','Externer Kostentrger (nur Lehr- und Forschungsbereiche) zu Hochschulen',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_extkotr_stg','','',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_fibu_bilanz','Bilanz','',
'Hilfstabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_fibu_guv','GuV','',
'Hilfstabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_fibu_quartal','Kaufm. Quartalsbericht','',
'Hilfstabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_fibu_wiplan','Kaufm. Wirtschaftsplan','',
'Hilfstabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_fikr','Kostenarten','Kostenarten (Bundesschlssel) aus dem SuperX-COB-Modul',
'Schlsseltabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_flaeche','Flchen','Hilfstabelle Flchen aus HISCOB (Tabl. cob_imp_flaeche)',
'Hilfstabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_flaeche_cube','','Joolap-Cube Flchen aus HISCOB (Tabl. cob_imp_flaeche)',
'Hilfstabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_geschl','','View Geschlecht',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hochschulen','','Verzeichnis der Hochschulen',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hsfinanz_stat','Hochschulfinanzstatistik','Importtabelle der Hs-Finanzstat.',
'Datentabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hzbart','','View Hochschulzugangsberechtigung (gruppiert)',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hzbart_astat','','Art der Hochschulzugangsber. (Amtlich)',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_inst','Kostenstellen (intern)','Kostenstellen der Hochschulen aus dem SuperX-COB-Modul (alternative Hierarchie KENN-Kostenstellen und KENN-Lehreinheiten)',
'Schlsseltabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_inst_to_ext','Kostenstellen (intern) zu extern','',
'Schlsseltabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_k_buadbz','','Amts- und Dienstbezeichnungen Bundesschlssel, vgl. http://www.destatis.de/allg/d/veroe/hoch/hochdow3.htm',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_kam_ja','Kameraler Jahresabschluss','',
'Hilfstabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_kam_quartal','Kameraler Quartalsbericht','',
'Hilfstabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_katalog','','Formeln fr Grunddaten und Kennzahlen',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_katalog_grp','','Gruppierungen fr Grunddaten und Kennzahlen',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_katalog_rpt','','Berichtslayouts fr Grunddaten und Kennzahlen',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_katalog_sub','','Differenzierungen fr Grunddaten und Kennzahlen',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_kennz_aggr','Zentrale Kennzahlen (Aggregation)','',
'Hilfstabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_konto_aggr','Haushalt','Aggregierte Haushalts-Kontendaten aus FIN',
'Hilfstabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_kzfa','','View Fachkennzeichen (H=Hauptfach, N=Nebenfach)',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_kzfach_int','Fachkennzeichen (intern)','Hochschulinterne Fachkennzeichen',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_lab_aggr_astat','Absolventen (amtl. Stat.)','Hilfstabelle Prfungsstatistik (amtl.)',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_lab_astat','Absolventen (amtl.)','Statistiktabelle Absolventen zur Lieferung ans STALA (nach neuem Format)',
'Datentabelle',
109,
109,
'Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_lab_astat_2015','Absolventen (amtl. altes Format)','Statistiktabelle Absolventen zur Lieferung ans STALA (nach altem Format bis 2016)',
'Datentabelle',
109,
109,
'Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_lfb_fg','','         Schlssel des Stat. Bundesamtes fr Lehr-Forschungsbereiche und Fachgebiete. Die Tabelle spannt eine Hierarchie auf:         Alle         Fchergruppe         Lehr- und Forschungsbreich         Fachgebiet                  Im Feld "parent" steht j',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_lieferung','','Lieferungen Datum+Hochschule',
'Datentabelle',
109,
109,
'Administration Grunddaten und Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_pbe_aggr','Besetzung','Hilfstabelle Stellenbesetzungen einer Hochschule (aggregiert, nur Planstellen)',
'Hilfstabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_pbv_aggr','Personal','Hilfstabelle Personal-Beschftigungsverhltnisse einer Hochschule',
'Hilfstabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_pbv_aggr_astat','Personal','Hilfstabelle Personal-Beschftigungsverhltnisse auf Basis amtl. Stat.',
'Hilfstabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_pbv_astat','Personalstatistik (amtl.)','Hilfstabelle Personal amtl. Stat',
'Hilfstabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_pbv_klr','Personal (KLR)','Personalstammstze aus der KLR',
'Datentabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_pkosten_cube','Primrkosten','Cube Primrkosten',
'Hilfstabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_proj_gege','Projekt zu Geldgeber','Kostentrger zu Geldgeber',
'Schlsseltabelle',
109,
109,
'Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_prom_astat','Promovierendenstatistik (amtl.)','Tabelle zum Import der Lieferung der Promovierenden ans STALA',
'Datentabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_promo','Promovierende','Datentabelle Promovierende: Begonnen in Jahr, Erfolgreich in Jahr, Kooperation mit anderer HS (HS-Nr. bei HS im Land, Dauer in Jahren,  Geschlecht, Summe',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_promo_aggr','Promovierende (aggr.)','Hilfstabelle Promovierende: Begonnen in Jahr, Erfolgreich in Jahr, Kooperation mit anderer HS (HS-Nr. bei HS im Land, Dauer in Jahren,  Geschlecht, Summe',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_pruefrout','','Log-Tabelle fr Prfroutinen',
'Datentabelle',
109,
109,
'Administration Grunddaten und Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_quartal_hier','','Zuordnung alternativer Hiearchien zu Landesschlsseln pro Quartal',
'Schlsseltabelle',
109,
109,
'Administration Grunddaten und Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_report_stichtagsart','','Berichte zu Stichtagsarten',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_rpt_ansprech','Ansprechpartner/-innen zum Bericht','',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_rpt_version','Berichtsversion','',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_sb_astfr_lfb','','Gegenberstellung /Zusammenfhrung der amtlichen Schlssel zum Forschungs- und Lehrbereich (LuF), Studienbereich (StB) und zur Fachrichtung (FR) der Gasthrerstatistik',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_sember_stg_cube','Studierende (Semesterberichte)','Semesterberichte Studierende',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_semester','','Schlsseltabelle Semester',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_sgd_aggr','Stellen','Hilfstabelle Stellengrunddaten einer Hochschule (aggregiert, nur Planstellen)',
'Hilfstabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_sichten','','Zuordnung von Default-Hierarchien zu Berichtsdimensionen,z.B. BVKR',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_skosten_cube','Primr- und Sekundrkosten (Externe Kostentrger)','Cube Primrkosten und Verteilbuchungen',
'Hilfstabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_sos_astat','Studierendenstatik (amtl.)','Statistiktabelle Studierende zur Lieferung ans STALA (nach neuem Format)',
'Datentabelle',
109,
109,
'Studierende',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_sos_astat_2015','Studierendenstatik (amtl. altes Format)','Statistiktabelle Studierende zur Lieferung ans STALA (nach altem Format bis 2016)',
'Datentabelle',
109,
109,
'Studierende',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_sos_lab','Absolventen','Hilfstabelle Prfungen (Hauptprfungen, bestanden, stichtagsbezogen)',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_sos_stg','Studierende','Hilfstabelle Studierendenstatistik (Haupthrer ohne beurlaubte und exmatrik., stichtagsbezogen)',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_staat','','Nationalitten der Studierenden',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_status','','SQL-Codes fr die flexible Filterung von Einschreib- und Rckmeldekennzeichen',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stbb_kap_titel_bericht','','',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stelle_bvl_bez','','',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stelle_hhpl','','',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stg_aggr','Studierende (Semesterberichte)','Hilfstabelle Studierendenstatistik (fr Semesterberichte)',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stg_aggr_astat','Studierende (Semesterberichte)','Hilfstabelle Studierendenstatistik (amtl.)',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stg_cube','','Cube-Tabelle Belegungen von Studiengngen',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stg_int','Studienfach (intern)','Hochschulinterne Fcher',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stichtag','','Schlsseltabelle Stichtage zu Datenlieferungen',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stichtagsart','','Stichtagsarten',
'Schlsseltabelle',
109,
109,
'Administration Kenn-Modul',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stort','','Standorte (Amtlich)',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stuart','','Studienart (Amtlich)',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stud_aggr_astat','Studierende (Semesterberichte Uni BaWue)','Hilfstabelle Studierendenstatistik (amtl.) fr Semesterberichte Unis BaWue',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stufrm','','Studienform (Amtlich)',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stug','Studiengnge','',
'Schlsseltabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stupl','Studienpltze','Studienplaetze je Studiengang',
'Hilfstabelle',
109,
109,
'Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stylesheet_version','Stylesheet zu Berichtsversion','',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_su_imp_stud','Studierende (KLR)','Studierendenstatistik fr die Kostenrechnung aus dem SuperX-COB-Modul',
'Hilfstabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_titel','Titel','Titel-Bezeichnungen der Hochschule (nur gefllt wenn Konstante KENN_KAMERAL_ERWEITERT=1)',
'Schlsseltabelle',
109,
109,
'Grunddaten Finanzrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_vari','','Verteilschritte fr Grunddaten und Kennzahlen im Bereich Kostenrechnung',
'Schlsseltabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_vert_int','Vertiefung (intern)','Hochschulinterne Vertiefungen',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_vtbu_aggr','Sekundr- und Verteilbuchungen','Hilfstabelle Verteilbuchungen aus HISCOB',
'Hilfstabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_vtbu_qp_aggr','Kosten der Querschnittsprodukte','Hilfstabelle Verteilbuchungen Querschnittsprodukte aus HISCOB',
'Hilfstabelle',
109,
109,
'Grunddaten Kostenrechnung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_zahl_wert','Manuelle Schnittstelle','Kennzahlen aus manueller Schnittstelle',
'Datentabelle',
109,
109,
'Zentrale Kennzahlen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_zsl_ausgleich_kennungen','ZSL Ausgleich Kennungen','',
'Schlsseltabelle',
109,
109,
'ZSL-Mittelverteilung',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_zulzahl_id','','Nur BaWue: ID fr Zulassungszahlen mit Namen und Kurzbeschreibung',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_zulzahl_sem','','Nur BaWue: Zulassungszahlen pro Semester',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_zulzahl2int','','Nur BaWue: Zuordnung der Zulassungszahl-ID zum internen Studiengang',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('dim_hochschule','Hochschule','Hochschule',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('dim_kenn_abschl_astat','Abschlsse (amtlich)','Abschlsse (amtlich)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('dim_kenn_bvkr_art','Kostenarten (BVKR)','Abschlsse (amtlich)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('dim_kenn_koepfe_faelle','Kpfe/Flle','Studierendenzhlung',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('dim_kenn_monat','Monat','Monate und Quartale',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('dim_kenn_stg_astat','Studienfcher (amtlich)','Studienfcher (amtlich)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('dim_kenn_stg_int','Studienfcher (intern)','Studienfcher (intern)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('k_astat_studienfach_land_l','Fcherschlssel lokal','Abschlsse (amtlich) zu Prfungsgruppen (BaWue PHen)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_abschl_astat','','Amtliche Abschlsse',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_abschl_astat_pruef_grp','Berichte und Kennzahlen','Abschlsse (amtlich) zu Prfungsgruppen (BaWue PHen)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_bezugszeit','Bezugszeiten','Verzeichnis von Bezugszeiten',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_dienstart','','Schlssel der Dienstart (Bund): Wiss./Nichtwiss./Sonsitge',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_extkotr_a','Ext. Kostentrger (Zeitreihe)','Externer Kostentrger (nur Lehre BaWue)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_extkotr_lehre_k','Ext. Kostentrger Lehre nach LeFgr','Externer Kostentrger (nur Lehre BaWue)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_extkotr_lfb','Lehr- und Forschungsbereiche','Externer Kostentrger (nur Lehr- und Forschungsbereiche)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_gege','','View kenn_gege',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hochschulen_plus','kenn_hochschulen plus Zwischenknoten','kenn_hochschulen plus Zwischenknoten',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hs_sichten','','View Sichten',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hs_st_trgart','','View Hochschulen/Standorte nach Hochschulart und Trgerschaft',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hs_stort','','View Hochschulen/Standorte (alphabetisch)',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hs_stort_art','','View Hochschulen/Standorte nach Hochschulart',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hs_stort_trg','','View Hochschulen/Standorte nach Trgerschaft',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_hzbart_astat_akt','','View Art der Hochschulzugangsber. (Amtlich) aktuell',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_perso_z','','View kenn_perso_z',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_quartale','','View kenn_quartale',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_redaktionsstatus','','View Tedaktionsstatus',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_report','Landesspez. Berichte','Verzeichnis von landesspez. Berichten',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_report_fuer_stichtagsarten','Landesspez. Berichte','Stichtagsarten zum Verzeichnis von landesspez. Berichten',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_report_katalog','Berichte und Kennzahlen','Abschlsse (amtlich)',
'Schlsseltabelle',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stbb_kapitel','','',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stbb_titel','','',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stell_z','','View kenn_stell_z',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stg_astat','','Amtliche Fcher, Studienbereiche und Fchgruppen',
'Schlsseltabelle',
109,
109,
'Grunddaten Studierende, Prfungen',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_stg_sb','','View Fcher und Studienbereiche',
'',
109,
109,
'',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_taetigkeit','','Schlssel der Ttigkeit (Bund): Haupt/Nebenberufl.',
'Schlsseltabelle',
109,
109,
'Grunddaten Stellen, Personal',
109);

insert into tmp_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id) 
values('kenn_zahlen','','View kenn_zahlen (Variablennamen fr kenn_zahl_wert)',
'',
109,
109,
'',
109);


delete from sx_tables where name in (select T.name from tmp_tables T);

insert into sx_tables (name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id)
select name,caption,description,table_type,systeminfo_id,systeminfo_orig,thema,sachgebiete_id
from tmp_tables;

drop table tmp_tables;


</#if>

 
CREATE temp TABLE tmp_db_forms (
    tid serial NOT NULL,
    name character(100),
    tablename character(100),
    form_path character(255),
    caption character(200),
    description character(255)
);
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('kenn_sichten','kenn_sichten','/edit/kenn/kenn_sichten_edit.jsp','Sichten fr das KENN-Modul bearbeiten'::varchar(200),'In diesem Formular knnen Sie Sichten fr zu berechnende Grunddaten und Kennzahlen festlegen. Nach einer nderung mssen Sie den kenn_update.x neu starten.'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('kenn_zulzahl2int_edit','kenn_zulzahl2int','/edit/kenn/kenn_zulzahl2int_edit.jsp','Hochschulinterne Studiengnge zur ID aus der BaWue-Datenbank zuordnen'::varchar(200),'In diesem Formular knnen Sie Hochschulinterne Studiengnge zur Zulassungszahl-IDs (BaWue-Datenbank) zuordnen'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('kenn_zulzahl_id_edit','kenn_zulzahl_id','/edit/kenn/kenn_zulzahl_id_edit.jsp','Studiengnge (extern) bearbeiten'::varchar(200),'In diesem Formular knnen Sie Zulassungszahl-IDs verwalten'::varchar(255));
insert into tmp_db_forms (name, tablename,form_path,caption,description)
values ('kenn_rpt_ansprech_list','kenn_rpt_ansprech','/edit/kenn/kenn_rpt_ansprech_list.jsp','Ansprechpartner/-innen zum Bericht (Listenformular)'::varchar(200),'In diesem Formular knnen Sie Ansprechpartner/-innen zum Bericht bearbeiten. Diese Angaben werden als Kontaktadressen zum zustndigen Landesministerium bertragen (nur Sachsen).'::varchar(255));


delete from db_forms where name in (select name from tmp_db_forms);
delete from sachgeb_dbform_bez where sachgebiete_id=109;

create temp table tmp_hilf(tid integer);
insert into tmp_hilf select max(tid) from db_forms;
update tmp_hilf set tid=0 where tid is null;
insert into db_forms(tid,name, tablename,form_path,caption,description)
select H.tid+D.tid, name, tablename,form_path,caption,description
from tmp_db_forms D, tmp_hilf H;

insert into sachgeb_dbform_bez select  109, H.tid+D.tid 
from tmp_db_forms D, tmp_hilf H;

drop table tmp_hilf;
drop table tmp_db_forms;

-- his1 rightname fuer Sachgebiete nachtragen


--freemarker template

<#if TableFieldExists?exists&&TableFieldExists('sachgebiete','rightname')>

update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFI]' where tid=109;
update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFS]' where tid=110;
update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFH]' where tid=111;
update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFC]' where tid=112;
update sachgebiete set rightname='CS_BIA_STANDARDREPORTS_VIEW_REPORTS[PFF]' where tid=113;
update sachgebiete set rightname='CS_BIA_ADMINISTRATE_TOPIC_AREA[PFI]' where tid=22;
update sachgebiete set rightname='CS_BIA_ADMINISTRATE_TOPIC_AREA[PFM]' where tid=114;
</#if>

